/****************************************************************************
*
* Copyright (c) 2023 STMicroelectronics - All Rights Reserved
*
* License terms: STMicroelectronics Proprietary in accordance with licensing
* terms SLA0098 at www.st.com.
*
* THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*****************************************************************************/
/*
*  @file    STGAP4_configuration.h
*  @version M4_VERSION
*  @brief   STGAP4S configuration macros and function
*
*  @details STGAP4S configuration macros and function.
*
*/		    
#ifndef __STGAP4_CONFIGURATION_H__
#define __STGAP4_CONFIGURATION_H__

#ifdef __cplusplus
extern "C" {
#endif

/* Number of devices cconnected on SPI chain (from 1 up to 8) */
#define NUMBER_DEVICES 6
/* CRC check ENABLED or DISABLED */
#define CRC_FLAG ENABLED		    

/* Timer Used for delay */
#define TIMER_HANDLE TIM8
#define TIMER_CLOCK_MHZ 300

/*===========================================================================*/
/* Module macros.                                                            */
/*===========================================================================*/
/* STGAP4 CONFIGURATION VALUES */		    
#define DEVICE1_REGISTERS_VALUES {\
/* CFG1 0b01000000 */\
(0x40U),\
/* CFG2 0b00100010 */\
(0x22U),\
/* CFG3 0b11000001 */\
(0xC1U),\
/* CFG4 0b00000000 */\
(0x00U),\
/* CFG5 0b00000101 */\
(0x05U),\
/* CFG6 0b00000000U */\
(0x00U),\
/* CFG7 0b00000001 */\
(0x01U),\
/*TEST1 */\
(0x00U),\
/* DIAG1CFGA 0b01010000 */\
(0x50U),\
/* DIAG1CFGB 0b01001000 */\
(0x48U),\
/* DIAG2CFGA 0b00101101 */\
(0x2DU),\
/* DIAG2CFGB 0b10000011 */\
(0x83U)\
}

#define DEVICE2_REGISTERS_VALUES {\
/* CFG1 0b01000000 */\
(0x40U),\
/* CFG2 0b00100010 */\
(0x22U),\
/* CFG3 0b11000001 */\
(0xC1U),\
/* CFG4 0b00000000 */\
(0x00U),\
/* CFG5 0b00000101 */\
(0x05U),\
/* CFG6 0b00000000U */\
(0x00U),\
/* CFG7 0b00000001 */\
(0x01U),\
/*TEST1 */\
(0x00U),\
/* DIAG1CFGA 0b01010000 */\
(0x50U),\
/* DIAG1CFGB 0b01001000 */\
(0x48U),\
/* DIAG2CFGA 0b00101101 */\
(0x2DU),\
/* DIAG2CFGB 0b10000011 */\
(0x83U)\
}

#define DEVICE3_REGISTERS_VALUES {\
/* CFG1 0b01000000 */\
(0x40U),\
/* CFG2 0b00100010 */\
(0x22U),\
/* CFG3 0b11000001 */\
(0xC1U),\
/* CFG4 0b00000000 */\
(0x00U),\
/* CFG5 0b00000101 */\
(0x05U),\
/* CFG6 0b00000000U */\
(0x00U),\
/* CFG7 0b00000001 */\
(0x01U),\
/*TEST1 */\
(0x00U),\
/* DIAG1CFGA 0b01010000 */\
(0x50U),\
/* DIAG1CFGB 0b01001000 */\
(0x48U),\
/* DIAG2CFGA 0b00101101 */\
(0x2DU),\
/* DIAG2CFGB 0b10000011 */\
(0x83U)\
}

#define DEVICE4_REGISTERS_VALUES {\
/* CFG1 0b01000000 */\
(0x40U),\
/* CFG2 0b00100010 */\
(0x22U),\
/* CFG3 0b11000001 */\
(0xC1U),\
/* CFG4 0b00000000 */\
(0x00U),\
/* CFG5 0b00000101 */\
(0x05U),\
/* CFG6 0b00000000U */\
(0x00U),\
/* CFG7 0b00000001 */\
(0x01U),\
/*TEST1 */\
(0x00U),\
/* DIAG1CFGA 0b01010000 */\
(0x50U),\
/* DIAG1CFGB 0b01001000 */\
(0x48U),\
/* DIAG2CFGA 0b00101101 */\
(0x2DU),\
/* DIAG2CFGB 0b10000011 */\
(0x83U)\
}

#define DEVICE5_REGISTERS_VALUES {\
/* CFG1 0b01000000 */\
(0x40U),\
/* CFG2 0b00100010 */\
(0x22U),\
/* CFG3 0b11000001 */\
(0xC1U),\
/* CFG4 0b00000000 */\
(0x00U),\
/* CFG5 0b00000101 */\
(0x05U),\
/* CFG6 0b00000000U */\
(0x00U),\
/* CFG7 0b00000001 */\
(0x01U),\
/*TEST1 */\
(0x00U),\
/* DIAG1CFGA 0b01010000 */\
(0x50U),\
/* DIAG1CFGB 0b01001000 */\
(0x48U),\
/* DIAG2CFGA 0b00101101 */\
(0x2DU),\
/* DIAG2CFGB 0b10000011 */\
(0x83U)\
}

#define DEVICE6_REGISTERS_VALUES {\
/* CFG1 0b01000000 */\
(0x40U),\
/* CFG2 0b00100010 */\
(0x22U),\
/* CFG3 0b11000001 */\
(0xC1U),\
/* CFG4 0b00000000 */\
(0x00U),\
/* CFG5 0b00000101 */\
(0x05U),\
/* CFG6 0b00000000U */\
(0x00U),\
/* CFG7 0b00000001 */\
(0x01U),\
/*TEST1 */\
(0x00U),\
/* DIAG1CFGA 0b01010000 */\
(0x50U),\
/* DIAG1CFGB 0b01001000 */\
(0x48U),\
/* DIAG2CFGA 0b00101101 */\
(0x2DU),\
/* DIAG2CFGB 0b10000011 */\
(0x83U)\
}

/* default value */
#ifndef DEVICE1_REGISTERS_VALUES
#define DEVICE1_REGISTERS_VALUES {\
/* CFG1 0b01000000 */\
(0x40U),\
/* CFG2 0b00100010 */\
(0x22U),\
/* CFG3 0b11000001 */\
(0xC1U),\
/* CFG4 0b00000000 */\
(0x00U),\
/* CFG5 0b00000101 */\
(0x05U),\
/* CFG6 0b00000000U */\
(0x00U),\
/* CFG7 0b00000001 */\
(0x01U),\
/*TEST1 */\
(0x00U),\
/* DIAG1CFGA 0b01010000 */\
(0x50U),\
/* DIAG1CFGB 0b01001000 */\
(0x48U),\
/* DIAG2CFGA 0b00101101 */\
(0x2DU),\
/* DIAG2CFGB 0b10000011 */\
(0x83U)\
}
#endif
/* default value */
#ifndef DEVICE2_REGISTERS_VALUES
#define DEVICE2_REGISTERS_VALUES {\
/* CFG1 0b01000000 */\
(0x40U),\
/* CFG2 0b00100010 */\
(0x22U),\
/* CFG3 0b11000001 */\
(0xC1U),\
/* CFG4 0b00000000 */\
(0x00U),\
/* CFG5 0b00000101 */\
(0x05U),\
/* CFG6 0b00000000U */\
(0x00U),\
/* CFG7 0b00000001 */\
(0x01U),\
/*TEST1 */\
(0x00U),\
/* DIAG1CFGA 0b01010000 */\
(0x50U),\
/* DIAG1CFGB 0b01001000 */\
(0x48U),\
/* DIAG2CFGA 0b00101101 */\
(0x2DU),\
/* DIAG2CFGB 0b10000011 */\
(0x83U)\
}
#endif
/* default value */
#ifndef DEVICE3_REGISTERS_VALUES
#define DEVICE3_REGISTERS_VALUES {\
/* CFG1 0b01000000 */\
(0x40U),\
/* CFG2 0b00100010 */\
(0x22U),\
/* CFG3 0b11000001 */\
(0xC1U),\
/* CFG4 0b00000000 */\
(0x00U),\
/* CFG5 0b00000101 */\
(0x05U),\
/* CFG6 0b00000000U */\
(0x00U),\
/* CFG7 0b00000001 */\
(0x01U),\
/*TEST1 */\
(0x00U),\
/* DIAG1CFGA 0b01010000 */\
(0x50U),\
/* DIAG1CFGB 0b01001000 */\
(0x48U),\
/* DIAG2CFGA 0b00101101 */\
(0x2DU),\
/* DIAG2CFGB 0b10000011 */\
(0x83U)\
}
#endif
/* default value */
#ifndef DEVICE4_REGISTERS_VALUES
#define DEVICE4_REGISTERS_VALUES {\
/* CFG1 0b01000000 */\
(0x40U),\
/* CFG2 0b00100010 */\
(0x22U),\
/* CFG3 0b11000001 */\
(0xC1U),\
/* CFG4 0b00000000 */\
(0x00U),\
/* CFG5 0b00000101 */\
(0x05U),\
/* CFG6 0b00000000U */\
(0x00U),\
/* CFG7 0b00000001 */\
(0x01U),\
/*TEST1 */\
(0x00U),\
/* DIAG1CFGA 0b01010000 */\
(0x50U),\
/* DIAG1CFGB 0b01001000 */\
(0x48U),\
/* DIAG2CFGA 0b00101101 */\
(0x2DU),\
/* DIAG2CFGB 0b10000011 */\
(0x83U)\
}
#endif
/* default value */
#ifndef DEVICE5_REGISTERS_VALUES
#define DEVICE5_REGISTERS_VALUES {\
/* CFG1 0b01000000 */\
(0x40U),\
/* CFG2 0b00100010 */\
(0x22U),\
/* CFG3 0b11000001 */\
(0xC1U),\
/* CFG4 0b00000000 */\
(0x00U),\
/* CFG5 0b00000101 */\
(0x05U),\
/* CFG6 0b00000000U */\
(0x00U),\
/* CFG7 0b00000001 */\
(0x01U),\
/*TEST1 */\
(0x00U),\
/* DIAG1CFGA 0b01010000 */\
(0x50U),\
/* DIAG1CFGB 0b01001000 */\
(0x48U),\
/* DIAG2CFGA 0b00101101 */\
(0x2DU),\
/* DIAG2CFGB 0b10000011 */\
(0x83U)\
}
#endif
/* default value */
#ifndef DEVICE6_REGISTERS_VALUES
#define DEVICE6_REGISTERS_VALUES {\
/* CFG1 0b01000000 */\
(0x40U),\
/* CFG2 0b00100010 */\
(0x22U),\
/* CFG3 0b11000001 */\
(0xC1U),\
/* CFG4 0b00000000 */\
(0x00U),\
/* CFG5 0b00000101 */\
(0x05U),\
/* CFG6 0b00000000U */\
(0x00U),\
/* CFG7 0b00000001 */\
(0x01U),\
/*TEST1 */\
(0x00U),\
/* DIAG1CFGA 0b01010000 */\
(0x50U),\
/* DIAG1CFGB 0b01001000 */\
(0x48U),\
/* DIAG2CFGA 0b00101101 */\
(0x2DU),\
/* DIAG2CFGB 0b10000011 */\
(0x83U)\
}
#endif
/* default value */
#ifndef DEVICE7_REGISTERS_VALUES
#define DEVICE7_REGISTERS_VALUES {\
/* CFG1 0b01000000 */\
(0x40U),\
/* CFG2 0b00100010 */\
(0x22U),\
/* CFG3 0b11000001 */\
(0xC1U),\
/* CFG4 0b00000000 */\
(0x00U),\
/* CFG5 0b00000101 */\
(0x05U),\
/* CFG6 0b00000000U */\
(0x00U),\
/* CFG7 0b00000001 */\
(0x01U),\
/*TEST1 */\
(0x00U),\
/* DIAG1CFGA 0b01010000 */\
(0x50U),\
/* DIAG1CFGB 0b01001000 */\
(0x48U),\
/* DIAG2CFGA 0b00101101 */\
(0x2DU),\
/* DIAG2CFGB 0b10000011 */\
(0x83U)\
}
#endif
/* default value */
#ifndef DEVICE8_REGISTERS_VALUES
#define DEVICE8_REGISTERS_VALUES {\
/* CFG1 0b01000000 */\
(0x40U),\
/* CFG2 0b00100010 */\
(0x22U),\
/* CFG3 0b11000001 */\
(0xC1U),\
/* CFG4 0b00000000 */\
(0x00U),\
/* CFG5 0b00000101 */\
(0x05U),\
/* CFG6 0b00000000U */\
(0x00U),\
/* CFG7 0b00000001 */\
(0x01U),\
/*TEST1 */\
(0x00U),\
/* DIAG1CFGA 0b01010000 */\
(0x50U),\
/* DIAG1CFGB 0b01001000 */\
(0x48U),\
/* DIAG2CFGA 0b00101101 */\
(0x2DU),\
/* DIAG2CFGB 0b10000011 */\
(0x83U)\
}
#endif

#endif /* __STGAP4_CONFIGURATION_H__ */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
