/****************************************************************************
*
* Copyright (c) 2023 STMicroelectronics - All Rights Reserved
*
* License terms: STMicroelectronics Proprietary in accordance with licensing
* terms SLA0098 at www.st.com.
*
* THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*
*****************************************************************************/
/*
*   @file    Power stage parameters.h
*   @version 1.1.0
*   @brief   This file contains Power stage parameters
*
*   @details This file contains Power stage parameters
*/

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __POWER_STAGE_PARAMETERS_H
#define __POWER_STAGE_PARAMETERS_H

/************* PWM Driving signals section **************/
/* High side Polarity */
#define PHASE_UH_POLARITY             LL_TIM_OCPOLARITY_HIGH 
#define PHASE_VH_POLARITY             LL_TIM_OCPOLARITY_HIGH
#define PHASE_WH_POLARITY             LL_TIM_OCPOLARITY_HIGH

#define HW_COMPLEMENTED_LOW_SIDE      DISABLE 
/* Low side Polarity */
#define PHASE_UL_POLARITY             LL_TIM_OCPOLARITY_HIGH 
#define PHASE_VL_POLARITY             LL_TIM_OCPOLARITY_HIGH
#define PHASE_WL_POLARITY             LL_TIM_OCPOLARITY_HIGH

/********** Inrush current limiter signal section *******/
#define INRUSH_CURR_LIMITER_POLARITY  DOUT_ACTIVE_HIGH 

/******* Dissipative brake driving signal section *******/
#define DISSIPATIVE_BRAKE_POLARITY    DOUT_ACTIVE_HIGH

/*********** Bus voltage sensing section ****************/
/* ENABLE/DISABLE Bus voltage sensing */
#define VBUS_VOLTAGE_ENABLE FALSE
#define VBUS_PARTITIONING_FACTOR      0.0022 /*!< It expresses how 
                                                  much the Vbus is attenuated  
                                                  before being converted into 
                                                  digital value */
#define NOMINAL_BUS_VOLTAGE_V         750

#define VBUS_NETWORK_PULLUP_RES_OHM   9100000
#define VBUS_NETWORK_PULLDW_RES_OHM   30000
/******** Current reading parameters section ******/
/*** Topology ***/
#define ICS_SENSORS

#define ICS_SHUNT_SELECTION (ICS_SHUNT_PHASES)

#define RSHUNT                        0.00165 

/* Selected L9502 gate driver */
#define USE_L9502
/* L9502 ADC measurement parameters */
#define EXT_ADC_RES ADC_10_BIT
/* ADC MIN DUTY */
#define EXT_ADC_MIN_DUTY 0.0039f
/* ADC MAX DUTY */
#define EXT_ADC_MAX_DUTY 0.997f

/*  Overall Amplification gain is calculated as shunt resistor times Amplification Network Gain */
#define AMPLIFICATION_GAIN            0.00165 
/*Current sensing on legs as configured */
#define ICS_SENSING_SELECTION (ICS_SENSING_ON_UV_PHASES)
/*** Noise parameters ***/
#define TNOISE_NS                     2550 
#define TRISE_NS                      2550 
#define MAX_TNTR_NS TNOISE_NS 

/************ Temperature sensing section ***************/
/* ENABLE/DISABLE Temperature sensing */
#define TEMP_VOLTAGE_ENABLE TRUE
/* V[V]=V0+dV/dT[V/Celsius]*(T-T0)[Celsius]*/
#define V0_V                          0.761 /*!< in Volts */
#define T0_C                          25.0 /*!< in Celsius degrees */                                               
#define dV_dT                         0.021 /*!< V/Celsius degrees */
#define T_MAX                         125 /*!< Sensor measured 
		                                                       temperature at maximum 
		                                                       power stage working 
		                                                       temperature, Celsius degrees */
#endif /*__POWER_STAGE_PARAMETERS_H*/
