/****************************************************************************
*
* Copyright (c) 2023 STMicroelectronics - All Rights Reserved
*
* License terms: STMicroelectronics Proprietary in accordance with licensing
* terms SLA0098 at www.st.com.
*
* THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*****************************************************************************/
/**
*   @file    main.c
*   @brief   Demo projetc
*
*/
#include <stdint.h>
#include <stdbool.h>
#include "main.h"
#include "motorcontrol.h"
#include "sr5e1_ll_exti.h"
#ifdef USE_L9907
#include "SRxxx_L9907.h"
#endif
#ifdef USE_L9502
#include "L9502.h"
#endif

#include <test_env.h>
#include "clock_cfg.h"
#include <test_env.h>

static void EXTI_Init(void);
#ifdef USE_L9502
void L9502_En_Button(void);
#endif
#ifdef USE_L9907
void L9907_En2_Button(void);
#endif



/* Enable/disable Test ADC regular conversion */
/* #define TEST_ADC_REG_CONV */

#ifdef TEST_ADC_REG_CONV
  RegConv_t testRegConvADC;
  uint8_t handleRegADC;
  uint16_t testRegConvADCData;
#endif

/* DEBUG PIN */
/* #define GPIOE13    gpio_iopack(GPIO_PORT_E, GPIO_PIN_13) */


/* DEBUG PIN ADC TRIG SIN /COS (Reolver) */
/* #define TIM15_CH1 gpio_iopack(GPIO_PORT_H, GPIO_PIN_6) */
/* #define PADPC5 gpio_iopack(GPIO_PORT_C, GPIO_PIN_5) */


/* ISR priority */
/* ADC EOC - TSK High freq. */
#define IRQ_HF_ADC_PRIO   2U
/* TIMx UP */
#define IRQ_TIMx_UP_PRIO  0U

/* encoder priority */
#define IRQ_ENC_TIMx_PRIO 3U

/* hall priority */
#define IRQ_HALL_TIMx_PRIO 3U

/* UART Live Monitor */
#define IRQ_UART1_PRIO    4U
/* FDCAN1 Live Monitor */
#define IRQ_FDCAN1_PRIO   3U
/* TIM BRK IN */ 
#define IRQ_TIMBRK_PRIO   5U

/* External Interrupt */
#define IRQ_EXTI_PRIO     4U
/* ADC EOC - Resolver */
#define IRQ_RES_ADCx_PRIO     2U

State_t StateMotor;
bool startMot = FALSE;

/* #define TEST_TOGGLE_PIN_LED */

#ifdef TEST_TOGGLE_PIN_LED
static void user_led_toggling(void) {

    gpio_toggle_pin(USER_LED_2);
}
#endif


/**
 * @brief   Application entry point.
 * @note    Environment has been fully set up at this point.
 */
int main(void) {
    
  /* SDK initialization.*/
  test_env_init(
      TEST_INIT_CLOCK    |
      TEST_INIT_GPIO     |
      TEST_INIT_BOARD    |
      TEST_INIT_IRQ      |
      TEST_INIT_OSAL);

  /* Enable interrupts.*/
  osal_sys_unlock();
  
#ifdef TEST_TOGGLE_PIN_LED
  for ( ; ; ) {
        /* Blink USER_LED_2.*/
        user_led_toggling();
        osal_delay_millisec(250U);
  }
#endif

  /* Enable and setting priority of IRQs used by Motor Control */
  /* ADC EOC - TSK High freq. */
  irq_set_priority(IRQ_HF_ADC_VECTOR, IRQ_HF_ADC_PRIO);
  irq_enable(IRQ_HF_ADC_VECTOR);
  
  /* TIM BRK IN */
  irq_set_priority(IRQ_TIMx_BRK_VECTOR, IRQ_TIMBRK_PRIO);
  irq_enable(IRQ_HF_ADC_VECTOR);

  /* TIMx UP */
  irq_set_priority(IRQ_TIMx_UP_VECTOR, IRQ_TIMx_UP_PRIO);
  irq_enable(IRQ_TIMx_UP_VECTOR);
#if defined (ENCODER) || defined(AUX_ENCODER)
  /* encoder  */
  irq_set_priority(ENC_TIMx_VECTOR, IRQ_ENC_TIMx_PRIO);
  irq_enable(ENC_TIMx_VECTOR);
#endif

#if defined(HALL_SENSORS) || defined(AUX_HALL_SENSORS)
  /* Hall Sensors */
  irq_set_priority(HALL_TIMx_VECTOR, IRQ_HALL_TIMx_PRIO);
  irq_enable(HALL_TIMx_VECTOR);
#endif

#ifdef CAN_COMMUNICATION
  /* FDCAN1 */
  irq_set_priority(IRQ_CAN1_LINE0_VECTOR, IRQ_FDCAN1_PRIO);
  irq_enable(IRQ_CAN1_LINE0_VECTOR);
#endif

#ifdef SERIAL_COMMUNICATION
  /* UART 1 */
  irq_set_priority(IRQ_UART1_VECTOR, IRQ_UART1_PRIO);
  irq_enable(IRQ_UART1_VECTOR);
#endif
  /* EXTI - Port I Pin 6 - L9907_EN2_BUTTON */
  irq_set_priority(IRQ_EXTI9_5_VECTOR, IRQ_EXTI_PRIO);
  irq_enable(IRQ_EXTI9_5_VECTOR);

  /* EXTI - Port I Pin 2 -  */
  irq_set_priority(IRQ_EXTI2_VECTOR, IRQ_EXTI_PRIO);
  irq_enable(IRQ_EXTI2_VECTOR);
#if defined(RESOLVER) || defined(AUX_RESOLVER)
  /* Resolver ADC end of convers  */
  irq_set_priority(IRQ_RES_ADC_VECTOR, IRQ_RES_ADCx_PRIO);
  irq_enable(IRQ_RES_ADC_VECTOR);
#endif
  EXTI_Init();

  MX_MotorControl_Init();
   /* enable D-cache */
  //SCB_EnableDCache();

#ifdef TEST_ADC_REG_CONV
  testRegConvADC.regADC = ADC1;
  testRegConvADC.channel = MC_ADC_CHANNEL_8; /* ADC SAR 1 In 8 - PD5 */
  testRegConvADC.samplingTime = LL_ADC_SAMPLING_CYCLE(47); 
  handleRegADC = RCM_RegisterRegConv(&testRegConvADC);
#endif
    
     if(StateMotor == IDLE)
     {
        {
           while(IDLE != MC_GetSTMStateMotor1())
           {
           }
           /* This command sets what will be the first speed ramp after the
           MCI_StartMotor command. It requires as first parameter the oMCI[0], as
           second parameter the target mechanical speed in thenth of Hz and as
           third parameter the speed ramp duration in milliseconds. */
  #if (OPEN_LOOP_FOC == TRUE)
           MC_ProgramSpeedRampMotor1(OPEN_LOOP_SPEED_RPM/6, OPEN_LOOP_SPEED_RAMP_DURATION_MS);
  #else
           MC_ProgramSpeedRampMotor1(1000/6, 1500);
  #endif
           /* This is a user command used to start the motor. The speed ramp shall be
              pre programmed before the command.*/
           startMot = MC_StartMotor1();
        }
     }

  /* This is the system idle loop, it is executed when no other tasks are
     ready for execution.*/
  while (true) {
    /* Idle loop.*/
#ifdef TEST_ADC_REG_CONV
    if(RCM_GetUserConvState() == RCM_USERCONV_IDLE)
    {
      RCM_RequestUserConv(handleRegADC);
    } 
    if(RCM_GetUserConvState() == RCM_USERCONV_EOC)
    {
       testRegConvADCData = RCM_GetUserConv();
    }
#endif
  }
}
 
/**
  * @brief  This function is executed in case of error occurrence.
  * @retval None
  */
void Error_Handler(void)
{
  /* USER CODE BEGIN Error_Handler_Debug */
  /* User can add his own implementation to report the HAL error return state */
  __disable_irq();
  while (1)
  {
  }
  /* USER CODE END Error_Handler_Debug */
}

/**
  * @brief GPIO Initialization Function
  * @param None
  * @retval None
  */
static void EXTI_Init(void)
{

  LL_EXTI_InitTypeDef EXTI_InitStruct = {0};

  /* L9907 Enable 2 button - PAD_PI6 (EXTI_POSITION_8  | EXTICR[1]) */
  LL_SYSCFG_SetEXTISource(LL_SYSCFG_EXTI_PORTI, LL_SYSCFG_EXTI_LINE6);

  EXTI_InitStruct.Line_0_31 = LL_EXTI_LINE_6;
  EXTI_InitStruct.LineCommand = ENABLE;
  EXTI_InitStruct.Mode = LL_EXTI_MODE_IT;
  EXTI_InitStruct.Trigger = LL_EXTI_TRIGGER_FALLING;
  LL_EXTI_Init(&EXTI_InitStruct);

  /* L9907 FS FLAG - PAD_PI2 (EXTI_POSITION_8  | EXTICR[0]) */
  //LL_SYSCFG_SetEXTISource(LL_SYSCFG_EXTI_PORTH, LL_SYSCFG_EXTI_LINE5);
  LL_SYSCFG_SetEXTISource(LL_SYSCFG_EXTI_PORTI, LL_SYSCFG_EXTI_LINE2);

  EXTI_InitStruct.Line_0_31 = LL_EXTI_LINE_2;
  EXTI_InitStruct.LineCommand = ENABLE;
  EXTI_InitStruct.Mode = LL_EXTI_MODE_IT;
  EXTI_InitStruct.Trigger = LL_EXTI_TRIGGER_FALLING;
  LL_EXTI_Init(&EXTI_InitStruct);

}

#ifdef USE_L9502
/**
  * @brief  Button to set EN2 on L9907 board.
  * @param  None
  * @retval None
  */
void L9502_En_Button(void)
{
  /* enable DIS pin */
  gpio_set_pin(L9502_DIS); /* LS */
 
#if defined(L9502_DIS2)
  gpio_set_pin(L9502_DIS2); /* LS */
#endif
}
#endif

#ifdef USE_L9907
/**
  * @brief  Button to set EN2 on L9907 board.
  * @param  None
  * @retval None
  */
void L9907_En2_Button(void)
{
  gpio_set_pin(E2_GPIO);gpio_set_pin(E1_GPIO);
}
#endif

