package com.st.stellar.component.stgap4s.impl

import java.util.Locale
import com.google.inject.Inject
import com.google.inject.Provider
import com.st.stellar.component.Component
import org.eclipse.core.runtime.NullProgressMonitor
import org.eclipse.emf.ecore.resource.Resource
import org.eclipse.core.resources.IResource
import org.eclipse.core.resources.ResourcesPlugin
import org.eclipse.xtext.generator.AbstractGenerator
import org.eclipse.xtext.generator.IFileSystemAccess2
import org.eclipse.xtext.generator.IGeneratorContext
import org.eclipse.emf.ecore.resource.ResourceSet
import com.st.stellar.component.stgap4s.Stgap4s
import com.st.stellar.component.stgap4s.DTset_enum
import com.st.stellar.component.stgap4s.INfilter_enum
import com.st.stellar.component.stgap4s.desatth_enum
import com.st.stellar.component.stgap4s.desatCurr_enum
import com.st.stellar.component.stgap4s.OVLOVHth_enum
import com.st.stellar.component.stgap4s.VLONth_enum
import com.st.stellar.component.stgap4s.VHONth_enum
import com.st.stellar.component.stgap4s.OUT_DTth_enum
import com.st.stellar.component.stgap4s.ADC_input_enum
import com.st.stellar.component.stgap4s.ADC_CScur_enum
import com.st.stellar.component.stgap4s.SENSEth_enum
import com.st.stellar.component.stgap4s.LTO_SOFTtime_enum
import com.st.stellar.component.stgap4s.ControllerFreq_enum
import com.st.stellar.component.stgap4s.ADC_Highth_enum
import com.st.stellar.component.stgap4s.ADC_Lowth_enum
import com.st.stellar.component.stgap4s.OFFmode_enum

class Stgap4sCodeGenerator extends AbstractGenerator {
	
	@Inject Provider<ResourceSet> rsp

	override doGenerate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
		val resourceSet = rsp.get
		val r = resourceSet.getResource(input.URI, true)
		if(r.contents.empty) return
		val cmp = r.contents.head as Component
		   val html_STGAP4Scfg = generateSTGAP4ScfgCode(cmp)
           fsa.generateFile("../code-gen/STGAP4_configuration.h", html_STGAP4Scfg)
		   
			try {
				ResourcesPlugin.workspace.root.refreshLocal(IResource.DEPTH_INFINITE, new NullProgressMonitor)
			} catch (IllegalStateException ise) {
				// Ignore it... workspace is closed 
			}
	}

	def String generateSTGAP4ScfgCode(Component comp) {
		val settings = (comp as Stgap4s)
		val num_devices = settings.number_of_stgap4s_devices		
		val listregs = settings.TConf_register1
	    var res = ""
	    res = res + '''
		    /****************************************************************************
		    *
		    * Copyright (c) 2023 STMicroelectronics - All Rights Reserved
		    *
		    * License terms: STMicroelectronics Proprietary in accordance with licensing
		    * terms SLA0098 at www.st.com.
		    *
		    * THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
		    * INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
		    *****************************************************************************/
		    /*
		    *  @file    STGAP4_configuration.h
		    *  @version M4_VERSION
		    *  @brief   STGAP4S configuration macros and function
		    *
		    *  @details STGAP4S configuration macros and function.
		    *
		    */		    
		    #ifndef __STGAP4_CONFIGURATION_H__
		    #define __STGAP4_CONFIGURATION_H__
		    
		    #ifdef __cplusplus
		    extern "C" {
		    #endif
		    
		    /* Number of devices cconnected on SPI chain (from 1 up to 8) */
		    #define NUMBER_DEVICES «listregs.size»
		    /* CRC check ENABLED or DISABLED */
		    #define CRC_FLAG ENABLED		    
		    
		    /* Timer Used for delay */
		    #define TIMER_HANDLE TIM8
		    #define TIMER_CLOCK_MHZ 300
		    
		    /*===========================================================================*/
		    /* Module macros.                                                            */
		    /*===========================================================================*/
		    /* STGAP4 CONFIGURATION VALUES */		    
	    '''	    
		for (element : listregs) {
			val uvl03v3in_en = element.configuration_register_1.uvl03v3in_en.value
			val sd_flag = element.configuration_register_1.sd_flag.value
            val dtset_temp = element.configuration_register_1.dtset
  		    var dtset_cfg_2 = 0
            var dtset_cfg_1 = 0
            var dtset_cfg_0 = 0
            if(dtset_temp === DTset_enum.DTSET_DISABLED){
              dtset_cfg_2 = 0
              dtset_cfg_1 = 0
              dtset_cfg_0 = 0
            }else if(dtset_temp === DTset_enum.DTSET_250){
              dtset_cfg_2 = 0
              dtset_cfg_1 = 0
              dtset_cfg_0 = 1   
            }else if(dtset_temp === DTset_enum.DTSET_500){
              dtset_cfg_2 = 0
              dtset_cfg_1 = 1
              dtset_cfg_0 = 0   
          }else if(dtset_temp === DTset_enum.DTSET_750){
              dtset_cfg_2 = 0
              dtset_cfg_1 = 1
              dtset_cfg_0 = 1   
          }else if(dtset_temp === DTset_enum.DTSET_1000){
              dtset_cfg_2 = 1
              dtset_cfg_1 = 0
              dtset_cfg_0 = 0   
          }else if(dtset_temp === DTset_enum.DTSET_1250){
              dtset_cfg_2 = 1
              dtset_cfg_1 = 0
              dtset_cfg_0 = 1   
          }else if(dtset_temp === DTset_enum.DTSET_1500){
              dtset_cfg_2 = 1
              dtset_cfg_1 = 1
              dtset_cfg_2 = 0   
          }else if(dtset_temp === DTset_enum.DTSET_2000){
              dtset_cfg_2 = 1
              dtset_cfg_1 = 1
              dtset_cfg_0 = 1   
          }
	   val infilter_temp = element.configuration_register_1.infilter
	   var infilter_cfg_0 = 0
       var infilter_cfg_1 = 0	   
       if(infilter_temp === INfilter_enum.INFILTER_DISABLED){
            infilter_cfg_1 = 0
            infilter_cfg_0 = 0
        }else if(infilter_temp === INfilter_enum.INFILTER_70){
            infilter_cfg_1 = 0
            infilter_cfg_0 = 1   
        }else if(infilter_temp === INfilter_enum.INFILTER_160){
            infilter_cfg_1 = 1
            infilter_cfg_0 = 0   
        }else if(infilter_temp === INfilter_enum.INFILTER_500){
            infilter_cfg_1 = 1
           infilter_cfg_0 = 1   
       }		
		val adc_pwm_en = element.configuration_register_1.adc_pwm_en.value		  

		val sense_en = element.configuration_register_2.sense_en.value
		val safeoff_en = element.configuration_register_2.safeoff_en.value
		val desat_en = element.configuration_register_2.desat_en.value		
	    val desatcur_temp = element.configuration_register_2.desatcur
    	var desatcur_cfg_0 = 0
        var desatcur_cfg_1 = 0	   
        if(desatcur_temp === desatCurr_enum.DESAT_CURR_250){
            desatcur_cfg_1 = 0
            desatcur_cfg_0 = 0
        }else if(desatcur_temp === desatCurr_enum.DESAT_CURR_500){
            desatcur_cfg_1 = 0
            desatcur_cfg_0 = 1   
        }else if(desatcur_temp === desatCurr_enum.DESAT_CURR_750){
            desatcur_cfg_1 = 1
            desatcur_cfg_0 = 0   
        }else if(desatcur_temp === desatCurr_enum.DESAT_CURR_1000){
            desatcur_cfg_1 = 1
            desatcur_cfg_0 = 1   
        }
	    val desatth_temp = element.configuration_register_2.desatth
		var desatth_cfg_2 = 0
        var desatth_cfg_1 = 0
        var desatth_cfg_0 = 0
        if(desatth_temp === desatth_enum.DESAT_THRESHOLD_3){
            desatth_cfg_2 = 0
            desatth_cfg_1 = 0
            desatth_cfg_0 = 0
        }else if(desatth_temp === desatth_enum.DESAT_THRESHOLD_4){
            desatth_cfg_2 = 0
            desatth_cfg_1 = 0
            desatth_cfg_0 = 1   
        }else if(desatth_temp === desatth_enum.DESAT_THRESHOLD_5){
            desatth_cfg_2 = 0
            desatth_cfg_1 = 1
            desatth_cfg_0 = 0   
        }else if(desatth_temp === desatth_enum.DESAT_THRESHOLD_6){
            desatth_cfg_2 = 0
            desatth_cfg_1 = 1
            desatth_cfg_0 = 1   
        }else if(desatth_temp === desatth_enum.DESAT_THRESHOLD_7){
            desatth_cfg_2 = 1
            desatth_cfg_1 = 0
            desatth_cfg_0 = 0   
        }else if(desatth_temp === desatth_enum.DESAT_THRESHOLD_8){
            desatth_cfg_2 = 1
            desatth_cfg_1 = 0
            desatth_cfg_0 = 1   
        }else if(desatth_temp === desatth_enum.DESAT_THRESHOLD_9){
            desatth_cfg_2 = 1
            desatth_cfg_1 = 1
            desatth_cfg_0 = 0   
        }else if(desatth_temp === desatth_enum.DESAT_THRESHOLD_10){
            desatth_cfg_2 = 1
            desatth_cfg_1 = 1
            desatth_cfg_0 = 1   
        }		
    	val OVLOVHth_temp = element.configuration_register_3.OVLOVHth
    	var OVLOVHth_cfg_0 = 0
        var OVLOVHth_cfg_1 = 0	           
        if(OVLOVHth_temp ===  OVLOVHth_enum.OVVH_OFF_ON_19_18){
             OVLOVHth_cfg_1 = 0
             OVLOVHth_cfg_0 = 0
         }else if(OVLOVHth_temp === OVLOVHth_enum.OVVH_OFF_ON_21_20){
             OVLOVHth_cfg_1 = 0
             OVLOVHth_cfg_0 = 1   
         }else if(OVLOVHth_temp === OVLOVHth_enum.OVVH_OFF_ON_23_22){
             OVLOVHth_cfg_1 = 1
             OVLOVHth_cfg_0 = 0   
         }else if(OVLOVHth_temp === OVLOVHth_enum.OVVH_OFF_ON_34_33){
             OVLOVHth_cfg_1 = 1
             OVLOVHth_cfg_0 = 1   
         }		
    	 val UVLOlatch = element.configuration_register_3.UVLOlatch.value
    	
    	 val VLONth_temp = element.configuration_register_3.VLONth
    	 var VLONth_cfg_0 = 0
         var VLONth_cfg_1 = 0	   
         if(VLONth_temp ===  VLONth_enum.VLO_NTH_DISABLED){
            VLONth_cfg_1 = 0
            VLONth_cfg_0 = 0
        }else if(VLONth_temp === VLONth_enum.VLOFF_ON_MINUS2_MINUS3){
            VLONth_cfg_1 = 0
            VLONth_cfg_0 = 1   
        }else if(VLONth_temp === VLONth_enum.VLOFF_ON_MINUS4_MINUS5){
            VLONth_cfg_1 = 1
            VLONth_cfg_0 = 0   
        }else if(VLONth_temp === VLONth_enum.VLOFF_ON_MINUS6_MINUS7){
            VLONth_cfg_1 = 1
            VLONth_cfg_0 = 1   
        }	
    
    	val VHONth_temp = element.configuration_register_3.VHONth
    	var VHONth_cfg_2 = 0
        var VHONth_cfg_1 = 0
        var VHONth_cfg_0 = 0
        if(VHONth_temp === VHONth_enum.VHO_NTH_DISABLED){
            VHONth_cfg_2 = 0
            VHONth_cfg_1 = 0
            VHONth_cfg_0 = 0
        }else if(VHONth_temp === VHONth_enum.VHOFF_ON_10_11){
            VHONth_cfg_2 = 0
            VHONth_cfg_1 = 0
            VHONth_cfg_0 = 1   
        }else if(VHONth_temp === VHONth_enum.VHOFF_ON_11_12){
            VHONth_cfg_2 = 0
            VHONth_cfg_1 = 1
            VHONth_cfg_0 = 0   
        }else if(VHONth_temp === VHONth_enum.VHOFF_ON_12_13){
            VHONth_cfg_2 = 0
            VHONth_cfg_1 = 1
            VHONth_cfg_0 = 1   
        }else if(VHONth_temp === VHONth_enum.VHOFF_ON_13_14){
            VHONth_cfg_2 = 1
            VHONth_cfg_1 = 0
            VHONth_cfg_0 = 0   
        }else if(VHONth_temp === VHONth_enum.VHOFF_ON_14_15){
            VHONth_cfg_2 = 1
            VHONth_cfg_1 = 0
            VHONth_cfg_0 = 1   
        }else if(VHONth_temp === VHONth_enum.VHOFF_ON_15_16){
            VHONth_cfg_2 = 1
            VHONth_cfg_1 = 1
            VHONth_cfg_0 = 0   
        }else if(VHONth_temp === VHONth_enum.VHOFF_ON_16_17){
            VHONth_cfg_2 = 1
            VHONth_cfg_1 = 1
            VHONth_cfg_0 = 1   
        }		
  	    val SENSEth_temp = element.configuration_register_4.SENSEth
  		var SENSEth_cfg_2 = 0
          var SENSEth_cfg_1 = 0
          var SENSEth_cfg_0 = 0
          if(SENSEth_temp === SENSEth_enum.SENS_ETH_100){
              SENSEth_cfg_2 = 0
              SENSEth_cfg_1 = 0
              SENSEth_cfg_0 = 0
          }else if(SENSEth_temp === SENSEth_enum.SENS_ETH_125){
              SENSEth_cfg_2 = 0
              SENSEth_cfg_1 = 0
              SENSEth_cfg_0 = 1   
          }else if(SENSEth_temp === SENSEth_enum.SENS_ETH_150){
              SENSEth_cfg_2 = 0
              SENSEth_cfg_1 = 1
              SENSEth_cfg_0 = 0   
          }else if(SENSEth_temp === SENSEth_enum.SENS_ETH_175){
              SENSEth_cfg_2 = 0
              SENSEth_cfg_1 = 1
              SENSEth_cfg_0 = 1   
          }else if(SENSEth_temp === SENSEth_enum.SENS_ETH_200){
              SENSEth_cfg_2 = 1
              SENSEth_cfg_1 = 0
              SENSEth_cfg_0 = 0   
          }else if(SENSEth_temp === SENSEth_enum.SENS_ETH_250){
              SENSEth_cfg_2 = 1
              SENSEth_cfg_1 = 0
              SENSEth_cfg_0 = 1   
          }else if(SENSEth_temp === SENSEth_enum.SENS_ETH_300){
              SENSEth_cfg_2 = 1
              SENSEth_cfg_1 = 1
              SENSEth_cfg_0 = 0   
          }else if(SENSEth_temp === SENSEth_enum.SENS_ETH_400){
              SENSEth_cfg_2 = 1
              SENSEth_cfg_1 = 1
              SENSEth_cfg_0 = 1   
          }				
  
  	   val ADC_CScur_temp = element.configuration_register_4.ADC_CScur
  	   var ADC_CScur_cfg_0 = 0
         var ADC_CScur_cfg_1 = 0	   
         if(ADC_CScur_temp ===  ADC_CScur_enum.ADC_CSRC_0){
              ADC_CScur_cfg_1 = 0
              ADC_CScur_cfg_0 = 0
          }else if(ADC_CScur_temp === ADC_CScur_enum.ADC_CSRC_300){
              ADC_CScur_cfg_1 = 0
              ADC_CScur_cfg_0 = 1   
          }else if(ADC_CScur_temp === ADC_CScur_enum.ADC_CSRC_600){
              ADC_CScur_cfg_1 = 1
              ADC_CScur_cfg_0 = 0   
          }else if(ADC_CScur_temp === ADC_CScur_enum.ADC_CSRC_1000){
              ADC_CScur_cfg_1 = 1
              ADC_CScur_cfg_0 = 1   
          }
  		
  	   val adc_input_temp = element.configuration_register_4.adc_input
  	   var adc_input_cfg_0 = 0
         if(adc_input_temp ===  ADC_input_enum.ADC_INPUT_DIFFERENTIAL){
              adc_input_cfg_0 = 0
          }else if(adc_input_temp === ADC_input_enum.ADC_INPUT_INTERNAL_IC){
              adc_input_cfg_0 = 1
          }
  		
  	   val SOFT_2LTO = element.configuration_register_4.SOFT_2LTO.value  
  	   val OUT_DTth_temp = element.configuration_register_4.OUT_DTth
  	   var OUT_DTth_cfg_0 = 0
         if(OUT_DTth_temp ===  OUT_DTth_enum.OUT_DTTH_55){
              OUT_DTth_cfg_0 = 0
          }else if(OUT_DTth_temp === OUT_DTth_enum.OUT_DTTH_88){
              OUT_DTth_cfg_0 = 1
          }
		  
	   val LTO_softTime_temp = element.configuration_register_5.LTO_softTime
	   var LTO_softTime_cfg_3 = 0		
	   var LTO_softTime_cfg_2 = 0
       var LTO_softTime_cfg_1 = 0
       var LTO_softTime_cfg_0 = 0
       if(LTO_softTime_temp === LTO_SOFTtime_enum.SOFT_TURN_OF_TIMEOUT_050){
           LTO_softTime_cfg_3 = 0		
           LTO_softTime_cfg_2 = 0
           LTO_softTime_cfg_1 = 0
           LTO_softTime_cfg_0 = 0
       }else if(LTO_softTime_temp === LTO_SOFTtime_enum.SOFT_TURN_OF_TIMEOUT_075){
           LTO_softTime_cfg_3 = 0		
           LTO_softTime_cfg_2 = 0
           LTO_softTime_cfg_1 = 0
           LTO_softTime_cfg_0 = 1   
       }else if(LTO_softTime_temp === LTO_SOFTtime_enum.SOFT_TURN_OF_TIMEOUT_100){
           LTO_softTime_cfg_3 = 0		            
			LTO_softTime_cfg_2 = 0
           LTO_softTime_cfg_1 = 1
           LTO_softTime_cfg_0 = 0   
       }else if(LTO_softTime_temp === LTO_SOFTtime_enum.SOFT_TURN_OF_TIMEOUT_150){
           LTO_softTime_cfg_3 = 0		
           LTO_softTime_cfg_2 = 0
           LTO_softTime_cfg_1 = 1
           LTO_softTime_cfg_0 = 1   
       }else if(LTO_softTime_temp === LTO_SOFTtime_enum.SOFT_TURN_OF_TIMEOUT_200){
           LTO_softTime_cfg_3 = 0		
           LTO_softTime_cfg_2 = 1
           LTO_softTime_cfg_1 = 0
           LTO_softTime_cfg_0 = 0   
       }else if(LTO_softTime_temp === LTO_SOFTtime_enum.SOFT_TURN_OF_TIMEOUT_250){
           LTO_softTime_cfg_3 = 0		
           LTO_softTime_cfg_2 = 1
           LTO_softTime_cfg_1 = 0
           LTO_softTime_cfg_0 = 1   
       }else if(LTO_softTime_temp === LTO_SOFTtime_enum.SOFT_TURN_OF_TIMEOUT_300){
           LTO_softTime_cfg_3 = 0		
           LTO_softTime_cfg_2 = 1
           LTO_softTime_cfg_1 = 1
           LTO_softTime_cfg_0 = 0   
       }else if(LTO_softTime_temp === LTO_SOFTtime_enum.SOFT_TURN_OF_TIMEOUT_350){
           LTO_softTime_cfg_3 = 0		
           LTO_softTime_cfg_2 = 1
           LTO_softTime_cfg_1 = 1
           LTO_softTime_cfg_0 = 1   
       }else if(LTO_softTime_temp === LTO_SOFTtime_enum.SOFT_TURN_OF_TIMEOUT_375){
           LTO_softTime_cfg_3 = 1		
           LTO_softTime_cfg_2 = 0
           LTO_softTime_cfg_1 = 0
           LTO_softTime_cfg_0 = 0   
       }else if(LTO_softTime_temp === LTO_SOFTtime_enum.SOFT_TURN_OF_TIMEOUT_400){
           LTO_softTime_cfg_3 = 1		
           LTO_softTime_cfg_2 = 0
           LTO_softTime_cfg_1 = 0
           LTO_softTime_cfg_0 = 1   
       }else if(LTO_softTime_temp === LTO_SOFTtime_enum.SOFT_TURN_OF_TIMEOUT_425){
           LTO_softTime_cfg_3 = 1		
           LTO_softTime_cfg_2 = 0
           LTO_softTime_cfg_1 = 1
           LTO_softTime_cfg_0 = 0   
       }else if(LTO_softTime_temp === LTO_SOFTtime_enum.SOFT_TURN_OF_TIMEOUT_450){
           LTO_softTime_cfg_3 = 1		
           LTO_softTime_cfg_2 = 0
           LTO_softTime_cfg_1 = 1
           LTO_softTime_cfg_0 = 1   
       }else if(LTO_softTime_temp === LTO_SOFTtime_enum.SOFT_TURN_OF_TIMEOUT_475){
           LTO_softTime_cfg_3 = 1	
           LTO_softTime_cfg_2 = 1
           LTO_softTime_cfg_1 = 0
           LTO_softTime_cfg_0 = 0   
       }else if(LTO_softTime_temp === LTO_SOFTtime_enum.SOFT_TURN_OF_TIMEOUT_500){
           LTO_softTime_cfg_3 = 1		
           LTO_softTime_cfg_2 = 1
           LTO_softTime_cfg_1 = 0
           LTO_softTime_cfg_0 = 1   
       }else if(LTO_softTime_temp === LTO_SOFTtime_enum.SOFT_TURN_OF_TIMEOUT_525){
           LTO_softTime_cfg_3 = 1		
           LTO_softTime_cfg_2 = 1
           LTO_softTime_cfg_1 = 1
           LTO_softTime_cfg_0 = 0   
       }else if(LTO_softTime_temp === LTO_SOFTtime_enum.SOFT_TURN_OF_TIMEOUT_025){
           LTO_softTime_cfg_3 = 1		
           LTO_softTime_cfg_2 = 1
           LTO_softTime_cfg_1 = 1
           LTO_softTime_cfg_0 = 1   
       }

       val CRC_SPI = element.configuration_register_6.CRC_SPI.value
 	   val ControllerFreq_temp = element.configuration_register_6.controller_freq
 	   var ControllerFreq_cfg_0 = 0
        var ControllerFreq_cfg_1 = 0	   
        if(ControllerFreq_temp ===  ControllerFreq_enum.FREQ_40_0KHZ){
             ControllerFreq_cfg_1 = 0
             ControllerFreq_cfg_0 = 0
         }else if(ControllerFreq_temp === ControllerFreq_enum.FREQ_20_0KHZ){
             ControllerFreq_cfg_1 = 0
             ControllerFreq_cfg_0 = 1   
         }else if(ControllerFreq_temp === ControllerFreq_enum.FREQ_30_0KHZ){
             ControllerFreq_cfg_1 = 1
             ControllerFreq_cfg_0 = 0   
         }else if(ControllerFreq_temp === ControllerFreq_enum.FREQ_60_0KHZ){
             ControllerFreq_cfg_1 = 1
             ControllerFreq_cfg_0 = 1   
         }
 
 	    val ADC_HIGHth_temp = element.configuration_register_7.ADC_HIGHth
 		var ADC_HIGHth_cfg_2 = 0
         var ADC_HIGHth_cfg_1 = 0
         var ADC_HIGHth_cfg_0 = 0
         if(ADC_HIGHth_temp === ADC_Highth_enum.ADC_HIG_HTH_1500){
             ADC_HIGHth_cfg_2 = 0
             ADC_HIGHth_cfg_1 = 0
             ADC_HIGHth_cfg_0 = 0
         }else if(ADC_HIGHth_temp === ADC_Highth_enum.ADC_HIG_HTH_1715){
             ADC_HIGHth_cfg_2 = 0
             ADC_HIGHth_cfg_1 = 0
             ADC_HIGHth_cfg_0 = 1   
         }else if(ADC_HIGHth_temp === ADC_Highth_enum.ADC_HIG_HTH_1930){
             ADC_HIGHth_cfg_2 = 0
             ADC_HIGHth_cfg_1 = 1
             ADC_HIGHth_cfg_0 = 0   
         }else if(ADC_HIGHth_temp === ADC_Highth_enum.ADC_HIG_HTH_2145){
             ADC_HIGHth_cfg_2 = 0
             ADC_HIGHth_cfg_1 = 1
             ADC_HIGHth_cfg_0 = 1   
         }else if(ADC_HIGHth_temp === ADC_Highth_enum.ADC_HIG_HTH_2360){
             ADC_HIGHth_cfg_2 = 1
             ADC_HIGHth_cfg_1 = 0
             ADC_HIGHth_cfg_0 = 0   
         }else if(ADC_HIGHth_temp === ADC_Highth_enum.ADC_HIG_HTH_2570){
             ADC_HIGHth_cfg_2 = 1
             ADC_HIGHth_cfg_1 = 0
             ADC_HIGHth_cfg_0 = 1   
         }else if(ADC_HIGHth_temp === ADC_Highth_enum.ADC_HIG_HTH_2785){
             ADC_HIGHth_cfg_2 = 1
             ADC_HIGHth_cfg_1 = 1
             ADC_HIGHth_cfg_0 = 0   
         }else if(ADC_HIGHth_temp === ADC_Highth_enum.ADC_HIG_HTH_3000){
             ADC_HIGHth_cfg_2 = 1
             ADC_HIGHth_cfg_1 = 1
             ADC_HIGHth_cfg_0 = 1   
         }		
 	    val ADC_LOWth_temp = element.configuration_register_7.ADC_LOWth
 		var ADC_LOWth_cfg_2 = 0
         var ADC_LOWth_cfg_1 = 0
         var ADC_LOWth_cfg_0 = 0
         if(ADC_LOWth_temp === ADC_Lowth_enum.ADC_LOWTH_0){
             ADC_LOWth_cfg_2 = 0
             ADC_LOWth_cfg_1 = 0
             ADC_LOWth_cfg_0 = 0
         }else if(ADC_LOWth_temp === ADC_Lowth_enum.ADC_LOWTH_0215){
             ADC_LOWth_cfg_2 = 0
             ADC_LOWth_cfg_1 = 0
             ADC_LOWth_cfg_0 = 1   
         }else if(ADC_LOWth_temp === ADC_Lowth_enum.ADC_LOWTH_0430){
             ADC_LOWth_cfg_2 = 0
             ADC_LOWth_cfg_1 = 1
             ADC_LOWth_cfg_0 = 0   
         }else if(ADC_LOWth_temp === ADC_Lowth_enum.ADC_LOWTH_0645){
             ADC_LOWth_cfg_2 = 0
             ADC_LOWth_cfg_1 = 1
             ADC_LOWth_cfg_0 = 1   
         }else if(ADC_LOWth_temp === ADC_Lowth_enum.ADC_LOWTH_0855){
             ADC_LOWth_cfg_2 = 1
             ADC_LOWth_cfg_1 = 0
             ADC_LOWth_cfg_0 = 0   
         }else if(ADC_LOWth_temp === ADC_Lowth_enum.ADC_LOWTH_1070){
             ADC_LOWth_cfg_2 = 1
             ADC_LOWth_cfg_1 = 0
             ADC_LOWth_cfg_0 = 1   
         }else if(ADC_LOWth_temp === ADC_Lowth_enum.ADC_LOWTH_1285){
             ADC_LOWth_cfg_2 = 1
             ADC_LOWth_cfg_1 = 1
             ADC_LOWth_cfg_0 = 0   
         }else if(ADC_LOWth_temp === ADC_Lowth_enum.ADC_LOWTH_1500){
             ADC_LOWth_cfg_2 = 1
             ADC_LOWth_cfg_1 = 1
             ADC_LOWth_cfg_0 = 1   
         }           
        val ADC_EN = element.configuration_register_7.adc_en.value
 
 	   val OFFMODE_temp = element.configuration_register_7.off_mode
 	   var OFFMODE_cfg_0 = 0
        if(OFFMODE_temp ===  OFFmode_enum.SAME_TIME_OUT2){
             OFFMODE_cfg_0 = 0
         }else if(OFFMODE_temp === OFFmode_enum.REMAIN_OFF){
             OFFMODE_cfg_0 = 1
         }
		 
		val diagreg1 = element.diag1cfga_register
		val diag1_7 = diagreg1.DIAG1CFGA_7.value
		val diag1_6 = diagreg1.DIAG1CFGA_6.value
		val diag1_5 = diagreg1.DIAG1CFGA_5.value
		val diag1_4 = diagreg1.DIAG1CFGA_4.value
		val diag1_3 = diagreg1.DIAG1CFGA_3.value
		val diag1_2 = diagreg1.DIAG1CFGA_2.value
		val diag1_1 = diagreg1.DIAG1CFGA_1.value
		val diag1_0 = diagreg1.DIAG1CFGA_0.value
		val diag_reg1_1 =  nibble(diag1_7,diag1_6,diag1_5,diag1_4)
		val diag_reg1_0 =  nibble(diag1_3,diag1_2,diag1_1,diag1_0)

		val diagreg2 = element.diag1cfgb_register
		val diag2_7 = diagreg2.DIAG1CFGB_7.value
		val diag2_6 = diagreg2.DIAG1CFGB_6.value
		val diag2_5 = diagreg2.DIAG1CFGB_5.value
		val diag2_4 = diagreg2.DIAG1CFGB_4.value
		val diag2_3 = diagreg2.DIAG1CFGB_3.value
		val diag2_2 = diagreg2.DIAG1CFGB_2.value
		val diag2_1 = diagreg2.DIAG1CFGB_1.value
		val diag2_0 = diagreg2.DIAG1CFGB_0.value
		val diag_reg2_1 =  nibble(diag2_7,diag2_6,diag2_5,diag2_4)
		val diag_reg2_0 =  nibble(diag2_3,diag2_2,diag2_1,diag2_0)
		
		val diagreg3 = element.diag2cfga_register
		val diag3_7 = diagreg3.DIAG2CFGA_7.value
		val diag3_6 = diagreg3.DIAG2CFGA_6.value
		val diag3_5 = diagreg3.DIAG2CFGA_5.value
		val diag3_4 = diagreg3.DIAG2CFGA_4.value
		val diag3_3 = diagreg3.DIAG2CFGA_3.value
		val diag3_2 = diagreg3.DIAG2CFGA_2.value
		val diag3_1 = diagreg3.DIAG2CFGA_1.value
		val diag3_0 = diagreg3.DIAG2CFGA_0.value
		val diag_reg3_1 =  nibble(diag3_7,diag3_6,diag3_5,diag3_4)
		val diag_reg3_0 =  nibble(diag3_3,diag3_2,diag3_1,diag3_0)

		val diagreg4 = element.diag2cfgb_register
		val diag4_7 = diagreg4.DIAG2CFGB_7.value
		val diag4_6 = diagreg4.DIAG2CFGB_6.value
		val diag4_5 = diagreg4.DIAG2CFGB_5.value
		val diag4_4 = diagreg4.DIAG2CFGB_4.value
		val diag4_3 = diagreg4.DIAG2CFGB_3.value
		val diag4_2 = diagreg4.DIAG2CFGB_2.value
		val diag4_1 = diagreg4.DIAG2CFGB_1.value
		val diag4_0 = diagreg4.DIAG2CFGB_0.value
		val diag_reg4_1 =  nibble(diag4_7,diag4_6,diag4_5,diag4_4)
		val diag_reg4_0 =  nibble(diag4_3,diag4_2,diag4_1,diag4_0)

 		val cfg_reg7_1 = nibble(ADC_HIGHth_cfg_2,ADC_HIGHth_cfg_1,ADC_HIGHth_cfg_0,ADC_LOWth_cfg_2)
 		val cfg_reg7_0 = nibble(ADC_LOWth_cfg_1,ADC_LOWth_cfg_0,ADC_EN,OFFMODE_cfg_0)
 		val cfg_reg6_1 = nibble(ControllerFreq_cfg_1,ControllerFreq_cfg_0,CRC_SPI,0)
 		val cfg_reg6_0 = nibble(0,0,0,0)
  	    val cfg_reg5_1 = nibble(0,0,0,0)
	    val cfg_reg5_0 = nibble(LTO_softTime_cfg_3,LTO_softTime_cfg_2,LTO_softTime_cfg_1,LTO_softTime_cfg_0)  		
  		val cfg_reg4_1 = nibble(SENSEth_cfg_2,SENSEth_cfg_1,SENSEth_cfg_0,ADC_CScur_cfg_1)
  		val cfg_reg4_0 = nibble(ADC_CScur_cfg_0,adc_input_cfg_0,SOFT_2LTO,OUT_DTth_cfg_0)    	
        val cfg_reg3_1 = nibble(OVLOVHth_cfg_1,OVLOVHth_cfg_0,UVLOlatch,VLONth_cfg_1)
        val cfg_reg3_0 = nibble(VLONth_cfg_0,VHONth_cfg_2,VHONth_cfg_1,VHONth_cfg_0)		
        val cfg_reg1_1 = nibble(uvl03v3in_en, sd_flag,dtset_cfg_2,dtset_cfg_1)
		val cfg_reg1_0 = nibble(dtset_cfg_0, infilter_cfg_1,infilter_cfg_0,adc_pwm_en)
		val cfg_reg2_1 = nibble(sense_en,safeoff_en,desat_en,desatcur_cfg_1) 
		val cfg_reg2_0 = nibble(desatcur_cfg_0,desatth_cfg_2,desatth_cfg_1,desatth_cfg_0)
		    res = res + '''
		    #define DEVICE«listregs.indexOf(element)+1»_REGISTERS_VALUES {\
		    /* CFG1 0b«uvl03v3in_en»«sd_flag»«dtset_cfg_2»«dtset_cfg_1»«dtset_cfg_0»«infilter_cfg_1»«infilter_cfg_0»«adc_pwm_en» */\
		    (0x«cfg_reg1_1»«cfg_reg1_0»U),\
		    /* CFG2 0b«sense_en»«safeoff_en»«desat_en»«desatcur_cfg_1»«desatcur_cfg_0»«desatth_cfg_2»«desatth_cfg_1»«desatth_cfg_0» */\
		    (0x«cfg_reg2_1»«cfg_reg2_0»U),\
		    /* CFG3 0b«OVLOVHth_cfg_1»«OVLOVHth_cfg_0»«UVLOlatch»«VLONth_cfg_1»«VLONth_cfg_0»«VHONth_cfg_2»«VHONth_cfg_1»«VHONth_cfg_0» */\
		    (0x«cfg_reg3_1»«cfg_reg3_0»U),\
		    /* CFG4 0b«SENSEth_cfg_2»«SENSEth_cfg_1»«SENSEth_cfg_0»«ADC_CScur_cfg_1»«ADC_CScur_cfg_0»«adc_input_cfg_0»«SOFT_2LTO»«OUT_DTth_cfg_0» */\
		    (0x«cfg_reg4_1»«cfg_reg4_0»U),\
		    /* CFG5 0b0000«LTO_softTime_cfg_3»«LTO_softTime_cfg_2»«LTO_softTime_cfg_1»«LTO_softTime_cfg_0» */\
		    (0x«cfg_reg5_1»«cfg_reg5_0»U),\
		    /* CFG6 0b«ControllerFreq_cfg_1»«ControllerFreq_cfg_0»«CRC_SPI»00000U */\
		    (0x«cfg_reg6_1»«cfg_reg6_0»U),\
		    /* CFG7 0b«ADC_HIGHth_cfg_2»«ADC_HIGHth_cfg_1»«ADC_HIGHth_cfg_0»«ADC_LOWth_cfg_2»«ADC_LOWth_cfg_1»«ADC_LOWth_cfg_0»«ADC_EN»«OFFMODE_cfg_0» */\
		    (0x«cfg_reg7_1»«cfg_reg7_0»U),\
		    /*TEST1 */\
		    (0x00U),\
		    /* DIAG1CFGA 0b«diag1_7»«diag1_6»«diag1_5»«diag1_4»«diag1_3»«diag1_2»«diag1_1»«diag1_0» */\
		    (0x«diag_reg1_1»«diag_reg1_0»U),\
		    /* DIAG1CFGB 0b«diag2_7»«diag2_6»«diag2_5»«diag2_4»«diag2_3»«diag2_2»«diag2_1»«diag2_0» */\
		    (0x«diag_reg2_1»«diag_reg2_0»U),\
		    /* DIAG2CFGA 0b«diag3_7»«diag3_6»«diag3_5»«diag3_4»«diag3_3»«diag3_2»«diag3_1»«diag3_0» */\
		    (0x«diag_reg3_1»«diag_reg3_0»U),\
		    /* DIAG2CFGB 0b«diag4_7»«diag4_6»«diag4_5»«diag4_4»«diag4_3»«diag4_2»«diag4_1»«diag4_0» */\
		    (0x«diag_reg4_1»«diag_reg4_0»U)\
		    }
		    
	    '''		
		}
res = res + '''
		    /* default value */
		    #ifndef DEVICE1_REGISTERS_VALUES
		    #define DEVICE1_REGISTERS_VALUES {\
		    /* CFG1 0b01000000 */\
		    (0x40U),\
		    /* CFG2 0b00100010 */\
		    (0x22U),\
		    /* CFG3 0b11000001 */\
		    (0xC1U),\
		    /* CFG4 0b00000000 */\
		    (0x00U),\
		    /* CFG5 0b00000101 */\
		    (0x05U),\
		    /* CFG6 0b00000000U */\
		    (0x00U),\
		    /* CFG7 0b00000001 */\
		    (0x01U),\
		    /*TEST1 */\
		    (0x00U),\
		    /* DIAG1CFGA 0b01010000 */\
		    (0x50U),\
		    /* DIAG1CFGB 0b01001000 */\
		    (0x48U),\
		    /* DIAG2CFGA 0b00101101 */\
		    (0x2DU),\
		    /* DIAG2CFGB 0b10000011 */\
		    (0x83U)\
		    }
		    #endif
		    /* default value */
		    #ifndef DEVICE2_REGISTERS_VALUES
		    #define DEVICE2_REGISTERS_VALUES {\
		    /* CFG1 0b01000000 */\
		    (0x40U),\
		    /* CFG2 0b00100010 */\
		    (0x22U),\
		    /* CFG3 0b11000001 */\
		    (0xC1U),\
		    /* CFG4 0b00000000 */\
		    (0x00U),\
		    /* CFG5 0b00000101 */\
		    (0x05U),\
		    /* CFG6 0b00000000U */\
		    (0x00U),\
		    /* CFG7 0b00000001 */\
		    (0x01U),\
		    /*TEST1 */\
		    (0x00U),\
		    /* DIAG1CFGA 0b01010000 */\
		    (0x50U),\
		    /* DIAG1CFGB 0b01001000 */\
		    (0x48U),\
		    /* DIAG2CFGA 0b00101101 */\
		    (0x2DU),\
		    /* DIAG2CFGB 0b10000011 */\
		    (0x83U)\
		    }
		    #endif
		    /* default value */
		    #ifndef DEVICE3_REGISTERS_VALUES
		    #define DEVICE3_REGISTERS_VALUES {\
		    /* CFG1 0b01000000 */\
		    (0x40U),\
		    /* CFG2 0b00100010 */\
		    (0x22U),\
		    /* CFG3 0b11000001 */\
		    (0xC1U),\
		    /* CFG4 0b00000000 */\
		    (0x00U),\
		    /* CFG5 0b00000101 */\
		    (0x05U),\
		    /* CFG6 0b00000000U */\
		    (0x00U),\
		    /* CFG7 0b00000001 */\
		    (0x01U),\
		    /*TEST1 */\
		    (0x00U),\
		    /* DIAG1CFGA 0b01010000 */\
		    (0x50U),\
		    /* DIAG1CFGB 0b01001000 */\
		    (0x48U),\
		    /* DIAG2CFGA 0b00101101 */\
		    (0x2DU),\
		    /* DIAG2CFGB 0b10000011 */\
		    (0x83U)\
		    }
		    #endif
		    /* default value */
		    #ifndef DEVICE4_REGISTERS_VALUES
		    #define DEVICE4_REGISTERS_VALUES {\
		    /* CFG1 0b01000000 */\
		    (0x40U),\
		    /* CFG2 0b00100010 */\
		    (0x22U),\
		    /* CFG3 0b11000001 */\
		    (0xC1U),\
		    /* CFG4 0b00000000 */\
		    (0x00U),\
		    /* CFG5 0b00000101 */\
		    (0x05U),\
		    /* CFG6 0b00000000U */\
		    (0x00U),\
		    /* CFG7 0b00000001 */\
		    (0x01U),\
		    /*TEST1 */\
		    (0x00U),\
		    /* DIAG1CFGA 0b01010000 */\
		    (0x50U),\
		    /* DIAG1CFGB 0b01001000 */\
		    (0x48U),\
		    /* DIAG2CFGA 0b00101101 */\
		    (0x2DU),\
		    /* DIAG2CFGB 0b10000011 */\
		    (0x83U)\
		    }
		    #endif
		    /* default value */
		    #ifndef DEVICE5_REGISTERS_VALUES
		    #define DEVICE5_REGISTERS_VALUES {\
		    /* CFG1 0b01000000 */\
		    (0x40U),\
		    /* CFG2 0b00100010 */\
		    (0x22U),\
		    /* CFG3 0b11000001 */\
		    (0xC1U),\
		    /* CFG4 0b00000000 */\
		    (0x00U),\
		    /* CFG5 0b00000101 */\
		    (0x05U),\
		    /* CFG6 0b00000000U */\
		    (0x00U),\
		    /* CFG7 0b00000001 */\
		    (0x01U),\
		    /*TEST1 */\
		    (0x00U),\
		    /* DIAG1CFGA 0b01010000 */\
		    (0x50U),\
		    /* DIAG1CFGB 0b01001000 */\
		    (0x48U),\
		    /* DIAG2CFGA 0b00101101 */\
		    (0x2DU),\
		    /* DIAG2CFGB 0b10000011 */\
		    (0x83U)\
		    }
		    #endif
		    /* default value */
		    #ifndef DEVICE6_REGISTERS_VALUES
		    #define DEVICE6_REGISTERS_VALUES {\
		    /* CFG1 0b01000000 */\
		    (0x40U),\
		    /* CFG2 0b00100010 */\
		    (0x22U),\
		    /* CFG3 0b11000001 */\
		    (0xC1U),\
		    /* CFG4 0b00000000 */\
		    (0x00U),\
		    /* CFG5 0b00000101 */\
		    (0x05U),\
		    /* CFG6 0b00000000U */\
		    (0x00U),\
		    /* CFG7 0b00000001 */\
		    (0x01U),\
		    /*TEST1 */\
		    (0x00U),\
		    /* DIAG1CFGA 0b01010000 */\
		    (0x50U),\
		    /* DIAG1CFGB 0b01001000 */\
		    (0x48U),\
		    /* DIAG2CFGA 0b00101101 */\
		    (0x2DU),\
		    /* DIAG2CFGB 0b10000011 */\
		    (0x83U)\
		    }
		    #endif
		    /* default value */
		    #ifndef DEVICE7_REGISTERS_VALUES
		    #define DEVICE7_REGISTERS_VALUES {\
		    /* CFG1 0b01000000 */\
		    (0x40U),\
		    /* CFG2 0b00100010 */\
		    (0x22U),\
		    /* CFG3 0b11000001 */\
		    (0xC1U),\
		    /* CFG4 0b00000000 */\
		    (0x00U),\
		    /* CFG5 0b00000101 */\
		    (0x05U),\
		    /* CFG6 0b00000000U */\
		    (0x00U),\
		    /* CFG7 0b00000001 */\
		    (0x01U),\
		    /*TEST1 */\
		    (0x00U),\
		    /* DIAG1CFGA 0b01010000 */\
		    (0x50U),\
		    /* DIAG1CFGB 0b01001000 */\
		    (0x48U),\
		    /* DIAG2CFGA 0b00101101 */\
		    (0x2DU),\
		    /* DIAG2CFGB 0b10000011 */\
		    (0x83U)\
		    }
		    #endif
		    /* default value */
		    #ifndef DEVICE8_REGISTERS_VALUES
		    #define DEVICE8_REGISTERS_VALUES {\
		    /* CFG1 0b01000000 */\
		    (0x40U),\
		    /* CFG2 0b00100010 */\
		    (0x22U),\
		    /* CFG3 0b11000001 */\
		    (0xC1U),\
		    /* CFG4 0b00000000 */\
		    (0x00U),\
		    /* CFG5 0b00000101 */\
		    (0x05U),\
		    /* CFG6 0b00000000U */\
		    (0x00U),\
		    /* CFG7 0b00000001 */\
		    (0x01U),\
		    /*TEST1 */\
		    (0x00U),\
		    /* DIAG1CFGA 0b01010000 */\
		    (0x50U),\
		    /* DIAG1CFGB 0b01001000 */\
		    (0x48U),\
		    /* DIAG2CFGA 0b00101101 */\
		    (0x2DU),\
		    /* DIAG2CFGB 0b10000011 */\
		    (0x83U)\
		    }
		    #endif
		    
		    #endif /* __STGAP4_CONFIGURATION_H__ */

		    /************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
	    '''	
	 return res	

	}
	

    def String nibble (int a, int b, int c, int d){
	 if ( ((a<0) || (a>1)) || ((b<0) || (b>1) ) || ((c<0) || (c>1) ) || ((d<0) || (d>1)) )
	 /*[#function nibble a,b,c,d]
	 [#stop "nibble: operand must be a binary number («a»,«b»,«c»,«d»)"]*/
	 return 'X'
	 else{
		var x1 = (8*a) + (4*b) + (2*c) + d
		if(x1 == 10){
			return 'A'
		}else if(x1 == 11){
			return 'B'
		}else if(x1 == 12){
			return 'C'
		}else if(x1 == 13){
			return 'D'
		}else if(x1 == 14){
			return 'E'
		}else if(x1 == 15){
			return 'F'
		}else if(x1 == 0){
			return '0'
		}else if(x1 == 1){
			return '1'
		}else if(x1 == 2){
			return '2'
		}else if(x1 == 3){
			return '3'
		}else if(x1 == 4){
			return '4'
		}else if(x1 == 5){
			return '5'
		}else if(x1 == 6){
			return '6'
		}else if(x1 == 7){
			return '7'
		}else if(x1 == 8){
			return '8'
		}else if(x1 == 9){
			return '9'
		}
	  }
	}
	
	def String int2hex (int x1){
	   if(x1 == 10){
	   	return 'A'
	   }else if(x1 == 11){
	   	return 'B'
	   }else if(x1 == 12){
	   	return 'C'
	   }else if(x1 == 13){
	   	return 'D'
	   }else if(x1 == 14){
	   	return 'E'
	   }else if(x1 == 15){
	   	return 'F'
	   }
	 }
}