/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.component.stgap4s.impl;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.st.stellar.component.Component;
import com.st.stellar.component.stgap4s.ADC_CScur_enum;
import com.st.stellar.component.stgap4s.ADC_Highth_enum;
import com.st.stellar.component.stgap4s.ADC_Lowth_enum;
import com.st.stellar.component.stgap4s.ADC_input_enum;
import com.st.stellar.component.stgap4s.ControllerFreq_enum;
import com.st.stellar.component.stgap4s.DIAG1CFGA_REGISTER;
import com.st.stellar.component.stgap4s.DIAG1CFGB_REGISTER;
import com.st.stellar.component.stgap4s.DIAG2CFGA_REGISTER;
import com.st.stellar.component.stgap4s.DIAG2CFGB_REGISTER;
import com.st.stellar.component.stgap4s.DTset_enum;
import com.st.stellar.component.stgap4s.INfilter_enum;
import com.st.stellar.component.stgap4s.LTO_SOFTtime_enum;
import com.st.stellar.component.stgap4s.OFFmode_enum;
import com.st.stellar.component.stgap4s.OUT_DTth_enum;
import com.st.stellar.component.stgap4s.OVLOVHth_enum;
import com.st.stellar.component.stgap4s.SENSEth_enum;
import com.st.stellar.component.stgap4s.Stgap4s;
import com.st.stellar.component.stgap4s.VHONth_enum;
import com.st.stellar.component.stgap4s.VLONth_enum;
import com.st.stellar.component.stgap4s.configuration_registers;
import com.st.stellar.component.stgap4s.desatCurr_enum;
import com.st.stellar.component.stgap4s.desatth_enum;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class Stgap4sCodeGenerator
extends AbstractGenerator {
    @Inject
    private Provider<ResourceSet> rsp;

    public void doGenerate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
        try {
            ResourceSet resourceSet = (ResourceSet)this.rsp.get();
            Resource r = resourceSet.getResource(input.getURI(), true);
            boolean _isEmpty = r.getContents().isEmpty();
            if (_isEmpty) {
                return;
            }
            EObject _head = (EObject)IterableExtensions.head((Iterable)r.getContents());
            Component cmp = (Component)_head;
            String html_STGAP4Scfg = this.generateSTGAP4ScfgCode(cmp);
            fsa.generateFile("../code-gen/STGAP4_configuration.h", (CharSequence)html_STGAP4Scfg);
            try {
                IWorkspaceRoot _root = ResourcesPlugin.getWorkspace().getRoot();
                NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
                _root.refreshLocal(2, (IProgressMonitor)_nullProgressMonitor);
            }
            catch (Throwable _t) {
                if (!(_t instanceof IllegalStateException)) {
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public String generateSTGAP4ScfgCode(Component comp) {
        Stgap4s settings = (Stgap4s)comp;
        int num_devices = settings.getNumber_of_stgap4s_devices();
        EList<configuration_registers> listregs = settings.getTConf_register1();
        Object res = "";
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/****************************************************************************");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("* Copyright (c) 2023 STMicroelectronics - All Rights Reserved");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("* License terms: STMicroelectronics Proprietary in accordance with licensing");
        _builder.newLine();
        _builder.append("* terms SLA0098 at www.st.com.");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("* THIS SOFTWARE IS DISTRIBUTED \"AS IS,\" AND ALL WARRANTIES ARE DISCLAIMED,");
        _builder.newLine();
        _builder.append("* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.");
        _builder.newLine();
        _builder.append("*****************************************************************************/");
        _builder.newLine();
        _builder.append("/*");
        _builder.newLine();
        _builder.append("*  @file    STGAP4_configuration.h");
        _builder.newLine();
        _builder.append("*  @version M4_VERSION");
        _builder.newLine();
        _builder.append("*  @brief   STGAP4S configuration macros and function");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("*  @details STGAP4S configuration macros and function.");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("*/\t\t    ");
        _builder.newLine();
        _builder.append("#ifndef __STGAP4_CONFIGURATION_H__");
        _builder.newLine();
        _builder.append("#define __STGAP4_CONFIGURATION_H__");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#ifdef __cplusplus");
        _builder.newLine();
        _builder.append("extern \"C\" {");
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/* Number of devices cconnected on SPI chain (from 1 up to 8) */");
        _builder.newLine();
        _builder.append("#define NUMBER_DEVICES ");
        int _size = listregs.size();
        _builder.append((Object)_size);
        _builder.newLineIfNotEmpty();
        _builder.append("/* CRC check ENABLED or DISABLED */");
        _builder.newLine();
        _builder.append("#define CRC_FLAG ENABLED\t\t    ");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/* Timer Used for delay */");
        _builder.newLine();
        _builder.append("#define TIMER_HANDLE TIM8");
        _builder.newLine();
        _builder.append("#define TIMER_CLOCK_MHZ 300");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/*===========================================================================*/");
        _builder.newLine();
        _builder.append("/* Module macros.                                                            */");
        _builder.newLine();
        _builder.append("/*===========================================================================*/");
        _builder.newLine();
        _builder.append("/* STGAP4 CONFIGURATION VALUES */\t\t    ");
        _builder.newLine();
        String _plus = (String)res + String.valueOf(_builder);
        res = _plus;
        for (configuration_registers element : listregs) {
            int uvl03v3in_en = element.getConfiguration_register_1().getUvl03v3in_en().getValue();
            int sd_flag = element.getConfiguration_register_1().getSd_flag().getValue();
            DTset_enum dtset_temp = element.getConfiguration_register_1().getDtset();
            int dtset_cfg_2 = 0;
            int dtset_cfg_1 = 0;
            int dtset_cfg_0 = 0;
            if (dtset_temp == DTset_enum.DTSET_DISABLED) {
                dtset_cfg_2 = 0;
                dtset_cfg_1 = 0;
                dtset_cfg_0 = 0;
            } else if (dtset_temp == DTset_enum.DTSET_250) {
                dtset_cfg_2 = 0;
                dtset_cfg_1 = 0;
                dtset_cfg_0 = 1;
            } else if (dtset_temp == DTset_enum.DTSET_500) {
                dtset_cfg_2 = 0;
                dtset_cfg_1 = 1;
                dtset_cfg_0 = 0;
            } else if (dtset_temp == DTset_enum.DTSET_750) {
                dtset_cfg_2 = 0;
                dtset_cfg_1 = 1;
                dtset_cfg_0 = 1;
            } else if (dtset_temp == DTset_enum.DTSET_1000) {
                dtset_cfg_2 = 1;
                dtset_cfg_1 = 0;
                dtset_cfg_0 = 0;
            } else if (dtset_temp == DTset_enum.DTSET_1250) {
                dtset_cfg_2 = 1;
                dtset_cfg_1 = 0;
                dtset_cfg_0 = 1;
            } else if (dtset_temp == DTset_enum.DTSET_1500) {
                dtset_cfg_2 = 1;
                dtset_cfg_1 = 1;
                dtset_cfg_2 = 0;
            } else if (dtset_temp == DTset_enum.DTSET_2000) {
                dtset_cfg_2 = 1;
                dtset_cfg_1 = 1;
                dtset_cfg_0 = 1;
            }
            INfilter_enum infilter_temp = element.getConfiguration_register_1().getInfilter();
            int infilter_cfg_0 = 0;
            int infilter_cfg_1 = 0;
            if (infilter_temp == INfilter_enum.INFILTER_DISABLED) {
                infilter_cfg_1 = 0;
                infilter_cfg_0 = 0;
            } else if (infilter_temp == INfilter_enum.INFILTER_70) {
                infilter_cfg_1 = 0;
                infilter_cfg_0 = 1;
            } else if (infilter_temp == INfilter_enum.INFILTER_160) {
                infilter_cfg_1 = 1;
                infilter_cfg_0 = 0;
            } else if (infilter_temp == INfilter_enum.INFILTER_500) {
                infilter_cfg_1 = 1;
                infilter_cfg_0 = 1;
            }
            int adc_pwm_en = element.getConfiguration_register_1().getAdc_pwm_en().getValue();
            int sense_en = element.getConfiguration_register_2().getSense_en().getValue();
            int safeoff_en = element.getConfiguration_register_2().getSafeoff_en().getValue();
            int desat_en = element.getConfiguration_register_2().getDesat_en().getValue();
            desatCurr_enum desatcur_temp = element.getConfiguration_register_2().getDesatcur();
            int desatcur_cfg_0 = 0;
            int desatcur_cfg_1 = 0;
            if (desatcur_temp == desatCurr_enum.DESAT_CURR_250) {
                desatcur_cfg_1 = 0;
                desatcur_cfg_0 = 0;
            } else if (desatcur_temp == desatCurr_enum.DESAT_CURR_500) {
                desatcur_cfg_1 = 0;
                desatcur_cfg_0 = 1;
            } else if (desatcur_temp == desatCurr_enum.DESAT_CURR_750) {
                desatcur_cfg_1 = 1;
                desatcur_cfg_0 = 0;
            } else if (desatcur_temp == desatCurr_enum.DESAT_CURR_1000) {
                desatcur_cfg_1 = 1;
                desatcur_cfg_0 = 1;
            }
            desatth_enum desatth_temp = element.getConfiguration_register_2().getDesatth();
            int desatth_cfg_2 = 0;
            int desatth_cfg_1 = 0;
            int desatth_cfg_0 = 0;
            if (desatth_temp == desatth_enum.DESAT_THRESHOLD_3) {
                desatth_cfg_2 = 0;
                desatth_cfg_1 = 0;
                desatth_cfg_0 = 0;
            } else if (desatth_temp == desatth_enum.DESAT_THRESHOLD_4) {
                desatth_cfg_2 = 0;
                desatth_cfg_1 = 0;
                desatth_cfg_0 = 1;
            } else if (desatth_temp == desatth_enum.DESAT_THRESHOLD_5) {
                desatth_cfg_2 = 0;
                desatth_cfg_1 = 1;
                desatth_cfg_0 = 0;
            } else if (desatth_temp == desatth_enum.DESAT_THRESHOLD_6) {
                desatth_cfg_2 = 0;
                desatth_cfg_1 = 1;
                desatth_cfg_0 = 1;
            } else if (desatth_temp == desatth_enum.DESAT_THRESHOLD_7) {
                desatth_cfg_2 = 1;
                desatth_cfg_1 = 0;
                desatth_cfg_0 = 0;
            } else if (desatth_temp == desatth_enum.DESAT_THRESHOLD_8) {
                desatth_cfg_2 = 1;
                desatth_cfg_1 = 0;
                desatth_cfg_0 = 1;
            } else if (desatth_temp == desatth_enum.DESAT_THRESHOLD_9) {
                desatth_cfg_2 = 1;
                desatth_cfg_1 = 1;
                desatth_cfg_0 = 0;
            } else if (desatth_temp == desatth_enum.DESAT_THRESHOLD_10) {
                desatth_cfg_2 = 1;
                desatth_cfg_1 = 1;
                desatth_cfg_0 = 1;
            }
            OVLOVHth_enum OVLOVHth_temp = element.getConfiguration_register_3().getOVLOVHth();
            int OVLOVHth_cfg_0 = 0;
            int OVLOVHth_cfg_1 = 0;
            if (OVLOVHth_temp == OVLOVHth_enum.OVVH_OFF_ON_19_18) {
                OVLOVHth_cfg_1 = 0;
                OVLOVHth_cfg_0 = 0;
            } else if (OVLOVHth_temp == OVLOVHth_enum.OVVH_OFF_ON_21_20) {
                OVLOVHth_cfg_1 = 0;
                OVLOVHth_cfg_0 = 1;
            } else if (OVLOVHth_temp == OVLOVHth_enum.OVVH_OFF_ON_23_22) {
                OVLOVHth_cfg_1 = 1;
                OVLOVHth_cfg_0 = 0;
            } else if (OVLOVHth_temp == OVLOVHth_enum.OVVH_OFF_ON_34_33) {
                OVLOVHth_cfg_1 = 1;
                OVLOVHth_cfg_0 = 1;
            }
            int UVLOlatch = element.getConfiguration_register_3().getUVLOlatch().getValue();
            VLONth_enum VLONth_temp = element.getConfiguration_register_3().getVLONth();
            int VLONth_cfg_0 = 0;
            int VLONth_cfg_1 = 0;
            if (VLONth_temp == VLONth_enum.VLO_NTH_DISABLED) {
                VLONth_cfg_1 = 0;
                VLONth_cfg_0 = 0;
            } else if (VLONth_temp == VLONth_enum.VLOFF_ON_MINUS2_MINUS3) {
                VLONth_cfg_1 = 0;
                VLONth_cfg_0 = 1;
            } else if (VLONth_temp == VLONth_enum.VLOFF_ON_MINUS4_MINUS5) {
                VLONth_cfg_1 = 1;
                VLONth_cfg_0 = 0;
            } else if (VLONth_temp == VLONth_enum.VLOFF_ON_MINUS6_MINUS7) {
                VLONth_cfg_1 = 1;
                VLONth_cfg_0 = 1;
            }
            VHONth_enum VHONth_temp = element.getConfiguration_register_3().getVHONth();
            int VHONth_cfg_2 = 0;
            int VHONth_cfg_1 = 0;
            int VHONth_cfg_0 = 0;
            if (VHONth_temp == VHONth_enum.VHO_NTH_DISABLED) {
                VHONth_cfg_2 = 0;
                VHONth_cfg_1 = 0;
                VHONth_cfg_0 = 0;
            } else if (VHONth_temp == VHONth_enum.VHOFF_ON_10_11) {
                VHONth_cfg_2 = 0;
                VHONth_cfg_1 = 0;
                VHONth_cfg_0 = 1;
            } else if (VHONth_temp == VHONth_enum.VHOFF_ON_11_12) {
                VHONth_cfg_2 = 0;
                VHONth_cfg_1 = 1;
                VHONth_cfg_0 = 0;
            } else if (VHONth_temp == VHONth_enum.VHOFF_ON_12_13) {
                VHONth_cfg_2 = 0;
                VHONth_cfg_1 = 1;
                VHONth_cfg_0 = 1;
            } else if (VHONth_temp == VHONth_enum.VHOFF_ON_13_14) {
                VHONth_cfg_2 = 1;
                VHONth_cfg_1 = 0;
                VHONth_cfg_0 = 0;
            } else if (VHONth_temp == VHONth_enum.VHOFF_ON_14_15) {
                VHONth_cfg_2 = 1;
                VHONth_cfg_1 = 0;
                VHONth_cfg_0 = 1;
            } else if (VHONth_temp == VHONth_enum.VHOFF_ON_15_16) {
                VHONth_cfg_2 = 1;
                VHONth_cfg_1 = 1;
                VHONth_cfg_0 = 0;
            } else if (VHONth_temp == VHONth_enum.VHOFF_ON_16_17) {
                VHONth_cfg_2 = 1;
                VHONth_cfg_1 = 1;
                VHONth_cfg_0 = 1;
            }
            SENSEth_enum SENSEth_temp = element.getConfiguration_register_4().getSENSEth();
            int SENSEth_cfg_2 = 0;
            int SENSEth_cfg_1 = 0;
            int SENSEth_cfg_0 = 0;
            if (SENSEth_temp == SENSEth_enum.SENS_ETH_100) {
                SENSEth_cfg_2 = 0;
                SENSEth_cfg_1 = 0;
                SENSEth_cfg_0 = 0;
            } else if (SENSEth_temp == SENSEth_enum.SENS_ETH_125) {
                SENSEth_cfg_2 = 0;
                SENSEth_cfg_1 = 0;
                SENSEth_cfg_0 = 1;
            } else if (SENSEth_temp == SENSEth_enum.SENS_ETH_150) {
                SENSEth_cfg_2 = 0;
                SENSEth_cfg_1 = 1;
                SENSEth_cfg_0 = 0;
            } else if (SENSEth_temp == SENSEth_enum.SENS_ETH_175) {
                SENSEth_cfg_2 = 0;
                SENSEth_cfg_1 = 1;
                SENSEth_cfg_0 = 1;
            } else if (SENSEth_temp == SENSEth_enum.SENS_ETH_200) {
                SENSEth_cfg_2 = 1;
                SENSEth_cfg_1 = 0;
                SENSEth_cfg_0 = 0;
            } else if (SENSEth_temp == SENSEth_enum.SENS_ETH_250) {
                SENSEth_cfg_2 = 1;
                SENSEth_cfg_1 = 0;
                SENSEth_cfg_0 = 1;
            } else if (SENSEth_temp == SENSEth_enum.SENS_ETH_300) {
                SENSEth_cfg_2 = 1;
                SENSEth_cfg_1 = 1;
                SENSEth_cfg_0 = 0;
            } else if (SENSEth_temp == SENSEth_enum.SENS_ETH_400) {
                SENSEth_cfg_2 = 1;
                SENSEth_cfg_1 = 1;
                SENSEth_cfg_0 = 1;
            }
            ADC_CScur_enum ADC_CScur_temp = element.getConfiguration_register_4().getADC_CScur();
            int ADC_CScur_cfg_0 = 0;
            int ADC_CScur_cfg_1 = 0;
            if (ADC_CScur_temp == ADC_CScur_enum.ADC_CSRC_0) {
                ADC_CScur_cfg_1 = 0;
                ADC_CScur_cfg_0 = 0;
            } else if (ADC_CScur_temp == ADC_CScur_enum.ADC_CSRC_300) {
                ADC_CScur_cfg_1 = 0;
                ADC_CScur_cfg_0 = 1;
            } else if (ADC_CScur_temp == ADC_CScur_enum.ADC_CSRC_600) {
                ADC_CScur_cfg_1 = 1;
                ADC_CScur_cfg_0 = 0;
            } else if (ADC_CScur_temp == ADC_CScur_enum.ADC_CSRC_1000) {
                ADC_CScur_cfg_1 = 1;
                ADC_CScur_cfg_0 = 1;
            }
            ADC_input_enum adc_input_temp = element.getConfiguration_register_4().getAdc_input();
            int adc_input_cfg_0 = 0;
            if (adc_input_temp == ADC_input_enum.ADC_INPUT_DIFFERENTIAL) {
                adc_input_cfg_0 = 0;
            } else if (adc_input_temp == ADC_input_enum.ADC_INPUT_INTERNAL_IC) {
                adc_input_cfg_0 = 1;
            }
            int SOFT_2LTO = element.getConfiguration_register_4().getSOFT_2LTO().getValue();
            OUT_DTth_enum OUT_DTth_temp = element.getConfiguration_register_4().getOUT_DTth();
            int OUT_DTth_cfg_0 = 0;
            if (OUT_DTth_temp == OUT_DTth_enum.OUT_DTTH_55) {
                OUT_DTth_cfg_0 = 0;
            } else if (OUT_DTth_temp == OUT_DTth_enum.OUT_DTTH_88) {
                OUT_DTth_cfg_0 = 1;
            }
            LTO_SOFTtime_enum LTO_softTime_temp = element.getConfiguration_register_5().getLTO_softTime();
            int LTO_softTime_cfg_3 = 0;
            int LTO_softTime_cfg_2 = 0;
            int LTO_softTime_cfg_1 = 0;
            int LTO_softTime_cfg_0 = 0;
            if (LTO_softTime_temp == LTO_SOFTtime_enum.SOFT_TURN_OF_TIMEOUT_050) {
                LTO_softTime_cfg_3 = 0;
                LTO_softTime_cfg_2 = 0;
                LTO_softTime_cfg_1 = 0;
                LTO_softTime_cfg_0 = 0;
            } else if (LTO_softTime_temp == LTO_SOFTtime_enum.SOFT_TURN_OF_TIMEOUT_075) {
                LTO_softTime_cfg_3 = 0;
                LTO_softTime_cfg_2 = 0;
                LTO_softTime_cfg_1 = 0;
                LTO_softTime_cfg_0 = 1;
            } else if (LTO_softTime_temp == LTO_SOFTtime_enum.SOFT_TURN_OF_TIMEOUT_100) {
                LTO_softTime_cfg_3 = 0;
                LTO_softTime_cfg_2 = 0;
                LTO_softTime_cfg_1 = 1;
                LTO_softTime_cfg_0 = 0;
            } else if (LTO_softTime_temp == LTO_SOFTtime_enum.SOFT_TURN_OF_TIMEOUT_150) {
                LTO_softTime_cfg_3 = 0;
                LTO_softTime_cfg_2 = 0;
                LTO_softTime_cfg_1 = 1;
                LTO_softTime_cfg_0 = 1;
            } else if (LTO_softTime_temp == LTO_SOFTtime_enum.SOFT_TURN_OF_TIMEOUT_200) {
                LTO_softTime_cfg_3 = 0;
                LTO_softTime_cfg_2 = 1;
                LTO_softTime_cfg_1 = 0;
                LTO_softTime_cfg_0 = 0;
            } else if (LTO_softTime_temp == LTO_SOFTtime_enum.SOFT_TURN_OF_TIMEOUT_250) {
                LTO_softTime_cfg_3 = 0;
                LTO_softTime_cfg_2 = 1;
                LTO_softTime_cfg_1 = 0;
                LTO_softTime_cfg_0 = 1;
            } else if (LTO_softTime_temp == LTO_SOFTtime_enum.SOFT_TURN_OF_TIMEOUT_300) {
                LTO_softTime_cfg_3 = 0;
                LTO_softTime_cfg_2 = 1;
                LTO_softTime_cfg_1 = 1;
                LTO_softTime_cfg_0 = 0;
            } else if (LTO_softTime_temp == LTO_SOFTtime_enum.SOFT_TURN_OF_TIMEOUT_350) {
                LTO_softTime_cfg_3 = 0;
                LTO_softTime_cfg_2 = 1;
                LTO_softTime_cfg_1 = 1;
                LTO_softTime_cfg_0 = 1;
            } else if (LTO_softTime_temp == LTO_SOFTtime_enum.SOFT_TURN_OF_TIMEOUT_375) {
                LTO_softTime_cfg_3 = 1;
                LTO_softTime_cfg_2 = 0;
                LTO_softTime_cfg_1 = 0;
                LTO_softTime_cfg_0 = 0;
            } else if (LTO_softTime_temp == LTO_SOFTtime_enum.SOFT_TURN_OF_TIMEOUT_400) {
                LTO_softTime_cfg_3 = 1;
                LTO_softTime_cfg_2 = 0;
                LTO_softTime_cfg_1 = 0;
                LTO_softTime_cfg_0 = 1;
            } else if (LTO_softTime_temp == LTO_SOFTtime_enum.SOFT_TURN_OF_TIMEOUT_425) {
                LTO_softTime_cfg_3 = 1;
                LTO_softTime_cfg_2 = 0;
                LTO_softTime_cfg_1 = 1;
                LTO_softTime_cfg_0 = 0;
            } else if (LTO_softTime_temp == LTO_SOFTtime_enum.SOFT_TURN_OF_TIMEOUT_450) {
                LTO_softTime_cfg_3 = 1;
                LTO_softTime_cfg_2 = 0;
                LTO_softTime_cfg_1 = 1;
                LTO_softTime_cfg_0 = 1;
            } else if (LTO_softTime_temp == LTO_SOFTtime_enum.SOFT_TURN_OF_TIMEOUT_475) {
                LTO_softTime_cfg_3 = 1;
                LTO_softTime_cfg_2 = 1;
                LTO_softTime_cfg_1 = 0;
                LTO_softTime_cfg_0 = 0;
            } else if (LTO_softTime_temp == LTO_SOFTtime_enum.SOFT_TURN_OF_TIMEOUT_500) {
                LTO_softTime_cfg_3 = 1;
                LTO_softTime_cfg_2 = 1;
                LTO_softTime_cfg_1 = 0;
                LTO_softTime_cfg_0 = 1;
            } else if (LTO_softTime_temp == LTO_SOFTtime_enum.SOFT_TURN_OF_TIMEOUT_525) {
                LTO_softTime_cfg_3 = 1;
                LTO_softTime_cfg_2 = 1;
                LTO_softTime_cfg_1 = 1;
                LTO_softTime_cfg_0 = 0;
            } else if (LTO_softTime_temp == LTO_SOFTtime_enum.SOFT_TURN_OF_TIMEOUT_025) {
                LTO_softTime_cfg_3 = 1;
                LTO_softTime_cfg_2 = 1;
                LTO_softTime_cfg_1 = 1;
                LTO_softTime_cfg_0 = 1;
            }
            int CRC_SPI = element.getConfiguration_register_6().getCRC_SPI().getValue();
            ControllerFreq_enum ControllerFreq_temp = element.getConfiguration_register_6().getController_freq();
            int ControllerFreq_cfg_0 = 0;
            int ControllerFreq_cfg_1 = 0;
            if (ControllerFreq_temp == ControllerFreq_enum.FREQ_40_0KHZ) {
                ControllerFreq_cfg_1 = 0;
                ControllerFreq_cfg_0 = 0;
            } else if (ControllerFreq_temp == ControllerFreq_enum.FREQ_20_0KHZ) {
                ControllerFreq_cfg_1 = 0;
                ControllerFreq_cfg_0 = 1;
            } else if (ControllerFreq_temp == ControllerFreq_enum.FREQ_30_0KHZ) {
                ControllerFreq_cfg_1 = 1;
                ControllerFreq_cfg_0 = 0;
            } else if (ControllerFreq_temp == ControllerFreq_enum.FREQ_60_0KHZ) {
                ControllerFreq_cfg_1 = 1;
                ControllerFreq_cfg_0 = 1;
            }
            ADC_Highth_enum ADC_HIGHth_temp = element.getConfiguration_register_7().getADC_HIGHth();
            int ADC_HIGHth_cfg_2 = 0;
            int ADC_HIGHth_cfg_1 = 0;
            int ADC_HIGHth_cfg_0 = 0;
            if (ADC_HIGHth_temp == ADC_Highth_enum.ADC_HIG_HTH_1500) {
                ADC_HIGHth_cfg_2 = 0;
                ADC_HIGHth_cfg_1 = 0;
                ADC_HIGHth_cfg_0 = 0;
            } else if (ADC_HIGHth_temp == ADC_Highth_enum.ADC_HIG_HTH_1715) {
                ADC_HIGHth_cfg_2 = 0;
                ADC_HIGHth_cfg_1 = 0;
                ADC_HIGHth_cfg_0 = 1;
            } else if (ADC_HIGHth_temp == ADC_Highth_enum.ADC_HIG_HTH_1930) {
                ADC_HIGHth_cfg_2 = 0;
                ADC_HIGHth_cfg_1 = 1;
                ADC_HIGHth_cfg_0 = 0;
            } else if (ADC_HIGHth_temp == ADC_Highth_enum.ADC_HIG_HTH_2145) {
                ADC_HIGHth_cfg_2 = 0;
                ADC_HIGHth_cfg_1 = 1;
                ADC_HIGHth_cfg_0 = 1;
            } else if (ADC_HIGHth_temp == ADC_Highth_enum.ADC_HIG_HTH_2360) {
                ADC_HIGHth_cfg_2 = 1;
                ADC_HIGHth_cfg_1 = 0;
                ADC_HIGHth_cfg_0 = 0;
            } else if (ADC_HIGHth_temp == ADC_Highth_enum.ADC_HIG_HTH_2570) {
                ADC_HIGHth_cfg_2 = 1;
                ADC_HIGHth_cfg_1 = 0;
                ADC_HIGHth_cfg_0 = 1;
            } else if (ADC_HIGHth_temp == ADC_Highth_enum.ADC_HIG_HTH_2785) {
                ADC_HIGHth_cfg_2 = 1;
                ADC_HIGHth_cfg_1 = 1;
                ADC_HIGHth_cfg_0 = 0;
            } else if (ADC_HIGHth_temp == ADC_Highth_enum.ADC_HIG_HTH_3000) {
                ADC_HIGHth_cfg_2 = 1;
                ADC_HIGHth_cfg_1 = 1;
                ADC_HIGHth_cfg_0 = 1;
            }
            ADC_Lowth_enum ADC_LOWth_temp = element.getConfiguration_register_7().getADC_LOWth();
            int ADC_LOWth_cfg_2 = 0;
            int ADC_LOWth_cfg_1 = 0;
            int ADC_LOWth_cfg_0 = 0;
            if (ADC_LOWth_temp == ADC_Lowth_enum.ADC_LOWTH_0) {
                ADC_LOWth_cfg_2 = 0;
                ADC_LOWth_cfg_1 = 0;
                ADC_LOWth_cfg_0 = 0;
            } else if (ADC_LOWth_temp == ADC_Lowth_enum.ADC_LOWTH_0215) {
                ADC_LOWth_cfg_2 = 0;
                ADC_LOWth_cfg_1 = 0;
                ADC_LOWth_cfg_0 = 1;
            } else if (ADC_LOWth_temp == ADC_Lowth_enum.ADC_LOWTH_0430) {
                ADC_LOWth_cfg_2 = 0;
                ADC_LOWth_cfg_1 = 1;
                ADC_LOWth_cfg_0 = 0;
            } else if (ADC_LOWth_temp == ADC_Lowth_enum.ADC_LOWTH_0645) {
                ADC_LOWth_cfg_2 = 0;
                ADC_LOWth_cfg_1 = 1;
                ADC_LOWth_cfg_0 = 1;
            } else if (ADC_LOWth_temp == ADC_Lowth_enum.ADC_LOWTH_0855) {
                ADC_LOWth_cfg_2 = 1;
                ADC_LOWth_cfg_1 = 0;
                ADC_LOWth_cfg_0 = 0;
            } else if (ADC_LOWth_temp == ADC_Lowth_enum.ADC_LOWTH_1070) {
                ADC_LOWth_cfg_2 = 1;
                ADC_LOWth_cfg_1 = 0;
                ADC_LOWth_cfg_0 = 1;
            } else if (ADC_LOWth_temp == ADC_Lowth_enum.ADC_LOWTH_1285) {
                ADC_LOWth_cfg_2 = 1;
                ADC_LOWth_cfg_1 = 1;
                ADC_LOWth_cfg_0 = 0;
            } else if (ADC_LOWth_temp == ADC_Lowth_enum.ADC_LOWTH_1500) {
                ADC_LOWth_cfg_2 = 1;
                ADC_LOWth_cfg_1 = 1;
                ADC_LOWth_cfg_0 = 1;
            }
            int ADC_EN = element.getConfiguration_register_7().getAdc_en().getValue();
            OFFmode_enum OFFMODE_temp = element.getConfiguration_register_7().getOff_mode();
            int OFFMODE_cfg_0 = 0;
            if (OFFMODE_temp == OFFmode_enum.SAME_TIME_OUT2) {
                OFFMODE_cfg_0 = 0;
            } else if (OFFMODE_temp == OFFmode_enum.REMAIN_OFF) {
                OFFMODE_cfg_0 = 1;
            }
            DIAG1CFGA_REGISTER diagreg1 = element.getDiag1cfga_register();
            int diag1_7 = diagreg1.getDIAG1CFGA_7().getValue();
            int diag1_6 = diagreg1.getDIAG1CFGA_6().getValue();
            int diag1_5 = diagreg1.getDIAG1CFGA_5().getValue();
            int diag1_4 = diagreg1.getDIAG1CFGA_4().getValue();
            int diag1_3 = diagreg1.getDIAG1CFGA_3().getValue();
            int diag1_2 = diagreg1.getDIAG1CFGA_2().getValue();
            int diag1_1 = diagreg1.getDIAG1CFGA_1().getValue();
            int diag1_0 = diagreg1.getDIAG1CFGA_0().getValue();
            String diag_reg1_1 = this.nibble(diag1_7, diag1_6, diag1_5, diag1_4);
            String diag_reg1_0 = this.nibble(diag1_3, diag1_2, diag1_1, diag1_0);
            DIAG1CFGB_REGISTER diagreg2 = element.getDiag1cfgb_register();
            int diag2_7 = diagreg2.getDIAG1CFGB_7().getValue();
            int diag2_6 = diagreg2.getDIAG1CFGB_6().getValue();
            int diag2_5 = diagreg2.getDIAG1CFGB_5().getValue();
            int diag2_4 = diagreg2.getDIAG1CFGB_4().getValue();
            int diag2_3 = diagreg2.getDIAG1CFGB_3().getValue();
            int diag2_2 = diagreg2.getDIAG1CFGB_2().getValue();
            int diag2_1 = diagreg2.getDIAG1CFGB_1().getValue();
            int diag2_0 = diagreg2.getDIAG1CFGB_0().getValue();
            String diag_reg2_1 = this.nibble(diag2_7, diag2_6, diag2_5, diag2_4);
            String diag_reg2_0 = this.nibble(diag2_3, diag2_2, diag2_1, diag2_0);
            DIAG2CFGA_REGISTER diagreg3 = element.getDiag2cfga_register();
            int diag3_7 = diagreg3.getDIAG2CFGA_7().getValue();
            int diag3_6 = diagreg3.getDIAG2CFGA_6().getValue();
            int diag3_5 = diagreg3.getDIAG2CFGA_5().getValue();
            int diag3_4 = diagreg3.getDIAG2CFGA_4().getValue();
            int diag3_3 = diagreg3.getDIAG2CFGA_3().getValue();
            int diag3_2 = diagreg3.getDIAG2CFGA_2().getValue();
            int diag3_1 = diagreg3.getDIAG2CFGA_1().getValue();
            int diag3_0 = diagreg3.getDIAG2CFGA_0().getValue();
            String diag_reg3_1 = this.nibble(diag3_7, diag3_6, diag3_5, diag3_4);
            String diag_reg3_0 = this.nibble(diag3_3, diag3_2, diag3_1, diag3_0);
            DIAG2CFGB_REGISTER diagreg4 = element.getDiag2cfgb_register();
            int diag4_7 = diagreg4.getDIAG2CFGB_7().getValue();
            int diag4_6 = diagreg4.getDIAG2CFGB_6().getValue();
            int diag4_5 = diagreg4.getDIAG2CFGB_5().getValue();
            int diag4_4 = diagreg4.getDIAG2CFGB_4().getValue();
            int diag4_3 = diagreg4.getDIAG2CFGB_3().getValue();
            int diag4_2 = diagreg4.getDIAG2CFGB_2().getValue();
            int diag4_1 = diagreg4.getDIAG2CFGB_1().getValue();
            int diag4_0 = diagreg4.getDIAG2CFGB_0().getValue();
            String diag_reg4_1 = this.nibble(diag4_7, diag4_6, diag4_5, diag4_4);
            String diag_reg4_0 = this.nibble(diag4_3, diag4_2, diag4_1, diag4_0);
            String cfg_reg7_1 = this.nibble(ADC_HIGHth_cfg_2, ADC_HIGHth_cfg_1, ADC_HIGHth_cfg_0, ADC_LOWth_cfg_2);
            String cfg_reg7_0 = this.nibble(ADC_LOWth_cfg_1, ADC_LOWth_cfg_0, ADC_EN, OFFMODE_cfg_0);
            String cfg_reg6_1 = this.nibble(ControllerFreq_cfg_1, ControllerFreq_cfg_0, CRC_SPI, 0);
            String cfg_reg6_0 = this.nibble(0, 0, 0, 0);
            String cfg_reg5_1 = this.nibble(0, 0, 0, 0);
            String cfg_reg5_0 = this.nibble(LTO_softTime_cfg_3, LTO_softTime_cfg_2, LTO_softTime_cfg_1, LTO_softTime_cfg_0);
            String cfg_reg4_1 = this.nibble(SENSEth_cfg_2, SENSEth_cfg_1, SENSEth_cfg_0, ADC_CScur_cfg_1);
            String cfg_reg4_0 = this.nibble(ADC_CScur_cfg_0, adc_input_cfg_0, SOFT_2LTO, OUT_DTth_cfg_0);
            String cfg_reg3_1 = this.nibble(OVLOVHth_cfg_1, OVLOVHth_cfg_0, UVLOlatch, VLONth_cfg_1);
            String cfg_reg3_0 = this.nibble(VLONth_cfg_0, VHONth_cfg_2, VHONth_cfg_1, VHONth_cfg_0);
            String cfg_reg1_1 = this.nibble(uvl03v3in_en, sd_flag, dtset_cfg_2, dtset_cfg_1);
            String cfg_reg1_0 = this.nibble(dtset_cfg_0, infilter_cfg_1, infilter_cfg_0, adc_pwm_en);
            String cfg_reg2_1 = this.nibble(sense_en, safeoff_en, desat_en, desatcur_cfg_1);
            String cfg_reg2_0 = this.nibble(desatcur_cfg_0, desatth_cfg_2, desatth_cfg_1, desatth_cfg_0);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("#define DEVICE");
            int _indexOf = listregs.indexOf((Object)element);
            int _plus_1 = _indexOf + 1;
            _builder_1.append((Object)_plus_1);
            _builder_1.append("_REGISTERS_VALUES {\\");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("/* CFG1 0b");
            _builder_1.append((Object)uvl03v3in_en);
            _builder_1.append((Object)sd_flag);
            _builder_1.append((Object)dtset_cfg_2);
            _builder_1.append((Object)dtset_cfg_1);
            _builder_1.append((Object)dtset_cfg_0);
            _builder_1.append((Object)infilter_cfg_1);
            _builder_1.append((Object)infilter_cfg_0);
            _builder_1.append((Object)adc_pwm_en);
            _builder_1.append(" */\\");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("(0x");
            _builder_1.append(cfg_reg1_1);
            _builder_1.append(cfg_reg1_0);
            _builder_1.append("U),\\");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("/* CFG2 0b");
            _builder_1.append((Object)sense_en);
            _builder_1.append((Object)safeoff_en);
            _builder_1.append((Object)desat_en);
            _builder_1.append((Object)desatcur_cfg_1);
            _builder_1.append((Object)desatcur_cfg_0);
            _builder_1.append((Object)desatth_cfg_2);
            _builder_1.append((Object)desatth_cfg_1);
            _builder_1.append((Object)desatth_cfg_0);
            _builder_1.append(" */\\");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("(0x");
            _builder_1.append(cfg_reg2_1);
            _builder_1.append(cfg_reg2_0);
            _builder_1.append("U),\\");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("/* CFG3 0b");
            _builder_1.append((Object)OVLOVHth_cfg_1);
            _builder_1.append((Object)OVLOVHth_cfg_0);
            _builder_1.append((Object)UVLOlatch);
            _builder_1.append((Object)VLONth_cfg_1);
            _builder_1.append((Object)VLONth_cfg_0);
            _builder_1.append((Object)VHONth_cfg_2);
            _builder_1.append((Object)VHONth_cfg_1);
            _builder_1.append((Object)VHONth_cfg_0);
            _builder_1.append(" */\\");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("(0x");
            _builder_1.append(cfg_reg3_1);
            _builder_1.append(cfg_reg3_0);
            _builder_1.append("U),\\");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("/* CFG4 0b");
            _builder_1.append((Object)SENSEth_cfg_2);
            _builder_1.append((Object)SENSEth_cfg_1);
            _builder_1.append((Object)SENSEth_cfg_0);
            _builder_1.append((Object)ADC_CScur_cfg_1);
            _builder_1.append((Object)ADC_CScur_cfg_0);
            _builder_1.append((Object)adc_input_cfg_0);
            _builder_1.append((Object)SOFT_2LTO);
            _builder_1.append((Object)OUT_DTth_cfg_0);
            _builder_1.append(" */\\");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("(0x");
            _builder_1.append(cfg_reg4_1);
            _builder_1.append(cfg_reg4_0);
            _builder_1.append("U),\\");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("/* CFG5 0b0000");
            _builder_1.append((Object)LTO_softTime_cfg_3);
            _builder_1.append((Object)LTO_softTime_cfg_2);
            _builder_1.append((Object)LTO_softTime_cfg_1);
            _builder_1.append((Object)LTO_softTime_cfg_0);
            _builder_1.append(" */\\");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("(0x");
            _builder_1.append(cfg_reg5_1);
            _builder_1.append(cfg_reg5_0);
            _builder_1.append("U),\\");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("/* CFG6 0b");
            _builder_1.append((Object)ControllerFreq_cfg_1);
            _builder_1.append((Object)ControllerFreq_cfg_0);
            _builder_1.append((Object)CRC_SPI);
            _builder_1.append("00000U */\\");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("(0x");
            _builder_1.append(cfg_reg6_1);
            _builder_1.append(cfg_reg6_0);
            _builder_1.append("U),\\");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("/* CFG7 0b");
            _builder_1.append((Object)ADC_HIGHth_cfg_2);
            _builder_1.append((Object)ADC_HIGHth_cfg_1);
            _builder_1.append((Object)ADC_HIGHth_cfg_0);
            _builder_1.append((Object)ADC_LOWth_cfg_2);
            _builder_1.append((Object)ADC_LOWth_cfg_1);
            _builder_1.append((Object)ADC_LOWth_cfg_0);
            _builder_1.append((Object)ADC_EN);
            _builder_1.append((Object)OFFMODE_cfg_0);
            _builder_1.append(" */\\");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("(0x");
            _builder_1.append(cfg_reg7_1);
            _builder_1.append(cfg_reg7_0);
            _builder_1.append("U),\\");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("/*TEST1 */\\");
            _builder_1.newLine();
            _builder_1.append("(0x00U),\\");
            _builder_1.newLine();
            _builder_1.append("/* DIAG1CFGA 0b");
            _builder_1.append((Object)diag1_7);
            _builder_1.append((Object)diag1_6);
            _builder_1.append((Object)diag1_5);
            _builder_1.append((Object)diag1_4);
            _builder_1.append((Object)diag1_3);
            _builder_1.append((Object)diag1_2);
            _builder_1.append((Object)diag1_1);
            _builder_1.append((Object)diag1_0);
            _builder_1.append(" */\\");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("(0x");
            _builder_1.append(diag_reg1_1);
            _builder_1.append(diag_reg1_0);
            _builder_1.append("U),\\");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("/* DIAG1CFGB 0b");
            _builder_1.append((Object)diag2_7);
            _builder_1.append((Object)diag2_6);
            _builder_1.append((Object)diag2_5);
            _builder_1.append((Object)diag2_4);
            _builder_1.append((Object)diag2_3);
            _builder_1.append((Object)diag2_2);
            _builder_1.append((Object)diag2_1);
            _builder_1.append((Object)diag2_0);
            _builder_1.append(" */\\");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("(0x");
            _builder_1.append(diag_reg2_1);
            _builder_1.append(diag_reg2_0);
            _builder_1.append("U),\\");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("/* DIAG2CFGA 0b");
            _builder_1.append((Object)diag3_7);
            _builder_1.append((Object)diag3_6);
            _builder_1.append((Object)diag3_5);
            _builder_1.append((Object)diag3_4);
            _builder_1.append((Object)diag3_3);
            _builder_1.append((Object)diag3_2);
            _builder_1.append((Object)diag3_1);
            _builder_1.append((Object)diag3_0);
            _builder_1.append(" */\\");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("(0x");
            _builder_1.append(diag_reg3_1);
            _builder_1.append(diag_reg3_0);
            _builder_1.append("U),\\");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("/* DIAG2CFGB 0b");
            _builder_1.append((Object)diag4_7);
            _builder_1.append((Object)diag4_6);
            _builder_1.append((Object)diag4_5);
            _builder_1.append((Object)diag4_4);
            _builder_1.append((Object)diag4_3);
            _builder_1.append((Object)diag4_2);
            _builder_1.append((Object)diag4_1);
            _builder_1.append((Object)diag4_0);
            _builder_1.append(" */\\");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("(0x");
            _builder_1.append(diag_reg4_1);
            _builder_1.append(diag_reg4_0);
            _builder_1.append("U)\\");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("}");
            _builder_1.newLine();
            _builder_1.newLine();
            String _plus_2 = (String)res + String.valueOf(_builder_1);
            res = _plus_2;
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("/* default value */");
        _builder_1.newLine();
        _builder_1.append("#ifndef DEVICE1_REGISTERS_VALUES");
        _builder_1.newLine();
        _builder_1.append("#define DEVICE1_REGISTERS_VALUES {\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG1 0b01000000 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x40U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG2 0b00100010 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x22U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG3 0b11000001 */\\");
        _builder_1.newLine();
        _builder_1.append("(0xC1U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG4 0b00000000 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x00U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG5 0b00000101 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x05U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG6 0b00000000U */\\");
        _builder_1.newLine();
        _builder_1.append("(0x00U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG7 0b00000001 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x01U),\\");
        _builder_1.newLine();
        _builder_1.append("/*TEST1 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x00U),\\");
        _builder_1.newLine();
        _builder_1.append("/* DIAG1CFGA 0b01010000 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x50U),\\");
        _builder_1.newLine();
        _builder_1.append("/* DIAG1CFGB 0b01001000 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x48U),\\");
        _builder_1.newLine();
        _builder_1.append("/* DIAG2CFGA 0b00101101 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x2DU),\\");
        _builder_1.newLine();
        _builder_1.append("/* DIAG2CFGB 0b10000011 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x83U)\\");
        _builder_1.newLine();
        _builder_1.append("}");
        _builder_1.newLine();
        _builder_1.append("#endif");
        _builder_1.newLine();
        _builder_1.append("/* default value */");
        _builder_1.newLine();
        _builder_1.append("#ifndef DEVICE2_REGISTERS_VALUES");
        _builder_1.newLine();
        _builder_1.append("#define DEVICE2_REGISTERS_VALUES {\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG1 0b01000000 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x40U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG2 0b00100010 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x22U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG3 0b11000001 */\\");
        _builder_1.newLine();
        _builder_1.append("(0xC1U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG4 0b00000000 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x00U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG5 0b00000101 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x05U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG6 0b00000000U */\\");
        _builder_1.newLine();
        _builder_1.append("(0x00U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG7 0b00000001 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x01U),\\");
        _builder_1.newLine();
        _builder_1.append("/*TEST1 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x00U),\\");
        _builder_1.newLine();
        _builder_1.append("/* DIAG1CFGA 0b01010000 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x50U),\\");
        _builder_1.newLine();
        _builder_1.append("/* DIAG1CFGB 0b01001000 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x48U),\\");
        _builder_1.newLine();
        _builder_1.append("/* DIAG2CFGA 0b00101101 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x2DU),\\");
        _builder_1.newLine();
        _builder_1.append("/* DIAG2CFGB 0b10000011 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x83U)\\");
        _builder_1.newLine();
        _builder_1.append("}");
        _builder_1.newLine();
        _builder_1.append("#endif");
        _builder_1.newLine();
        _builder_1.append("/* default value */");
        _builder_1.newLine();
        _builder_1.append("#ifndef DEVICE3_REGISTERS_VALUES");
        _builder_1.newLine();
        _builder_1.append("#define DEVICE3_REGISTERS_VALUES {\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG1 0b01000000 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x40U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG2 0b00100010 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x22U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG3 0b11000001 */\\");
        _builder_1.newLine();
        _builder_1.append("(0xC1U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG4 0b00000000 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x00U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG5 0b00000101 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x05U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG6 0b00000000U */\\");
        _builder_1.newLine();
        _builder_1.append("(0x00U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG7 0b00000001 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x01U),\\");
        _builder_1.newLine();
        _builder_1.append("/*TEST1 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x00U),\\");
        _builder_1.newLine();
        _builder_1.append("/* DIAG1CFGA 0b01010000 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x50U),\\");
        _builder_1.newLine();
        _builder_1.append("/* DIAG1CFGB 0b01001000 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x48U),\\");
        _builder_1.newLine();
        _builder_1.append("/* DIAG2CFGA 0b00101101 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x2DU),\\");
        _builder_1.newLine();
        _builder_1.append("/* DIAG2CFGB 0b10000011 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x83U)\\");
        _builder_1.newLine();
        _builder_1.append("}");
        _builder_1.newLine();
        _builder_1.append("#endif");
        _builder_1.newLine();
        _builder_1.append("/* default value */");
        _builder_1.newLine();
        _builder_1.append("#ifndef DEVICE4_REGISTERS_VALUES");
        _builder_1.newLine();
        _builder_1.append("#define DEVICE4_REGISTERS_VALUES {\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG1 0b01000000 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x40U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG2 0b00100010 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x22U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG3 0b11000001 */\\");
        _builder_1.newLine();
        _builder_1.append("(0xC1U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG4 0b00000000 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x00U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG5 0b00000101 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x05U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG6 0b00000000U */\\");
        _builder_1.newLine();
        _builder_1.append("(0x00U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG7 0b00000001 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x01U),\\");
        _builder_1.newLine();
        _builder_1.append("/*TEST1 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x00U),\\");
        _builder_1.newLine();
        _builder_1.append("/* DIAG1CFGA 0b01010000 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x50U),\\");
        _builder_1.newLine();
        _builder_1.append("/* DIAG1CFGB 0b01001000 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x48U),\\");
        _builder_1.newLine();
        _builder_1.append("/* DIAG2CFGA 0b00101101 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x2DU),\\");
        _builder_1.newLine();
        _builder_1.append("/* DIAG2CFGB 0b10000011 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x83U)\\");
        _builder_1.newLine();
        _builder_1.append("}");
        _builder_1.newLine();
        _builder_1.append("#endif");
        _builder_1.newLine();
        _builder_1.append("/* default value */");
        _builder_1.newLine();
        _builder_1.append("#ifndef DEVICE5_REGISTERS_VALUES");
        _builder_1.newLine();
        _builder_1.append("#define DEVICE5_REGISTERS_VALUES {\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG1 0b01000000 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x40U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG2 0b00100010 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x22U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG3 0b11000001 */\\");
        _builder_1.newLine();
        _builder_1.append("(0xC1U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG4 0b00000000 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x00U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG5 0b00000101 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x05U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG6 0b00000000U */\\");
        _builder_1.newLine();
        _builder_1.append("(0x00U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG7 0b00000001 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x01U),\\");
        _builder_1.newLine();
        _builder_1.append("/*TEST1 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x00U),\\");
        _builder_1.newLine();
        _builder_1.append("/* DIAG1CFGA 0b01010000 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x50U),\\");
        _builder_1.newLine();
        _builder_1.append("/* DIAG1CFGB 0b01001000 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x48U),\\");
        _builder_1.newLine();
        _builder_1.append("/* DIAG2CFGA 0b00101101 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x2DU),\\");
        _builder_1.newLine();
        _builder_1.append("/* DIAG2CFGB 0b10000011 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x83U)\\");
        _builder_1.newLine();
        _builder_1.append("}");
        _builder_1.newLine();
        _builder_1.append("#endif");
        _builder_1.newLine();
        _builder_1.append("/* default value */");
        _builder_1.newLine();
        _builder_1.append("#ifndef DEVICE6_REGISTERS_VALUES");
        _builder_1.newLine();
        _builder_1.append("#define DEVICE6_REGISTERS_VALUES {\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG1 0b01000000 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x40U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG2 0b00100010 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x22U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG3 0b11000001 */\\");
        _builder_1.newLine();
        _builder_1.append("(0xC1U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG4 0b00000000 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x00U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG5 0b00000101 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x05U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG6 0b00000000U */\\");
        _builder_1.newLine();
        _builder_1.append("(0x00U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG7 0b00000001 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x01U),\\");
        _builder_1.newLine();
        _builder_1.append("/*TEST1 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x00U),\\");
        _builder_1.newLine();
        _builder_1.append("/* DIAG1CFGA 0b01010000 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x50U),\\");
        _builder_1.newLine();
        _builder_1.append("/* DIAG1CFGB 0b01001000 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x48U),\\");
        _builder_1.newLine();
        _builder_1.append("/* DIAG2CFGA 0b00101101 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x2DU),\\");
        _builder_1.newLine();
        _builder_1.append("/* DIAG2CFGB 0b10000011 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x83U)\\");
        _builder_1.newLine();
        _builder_1.append("}");
        _builder_1.newLine();
        _builder_1.append("#endif");
        _builder_1.newLine();
        _builder_1.append("/* default value */");
        _builder_1.newLine();
        _builder_1.append("#ifndef DEVICE7_REGISTERS_VALUES");
        _builder_1.newLine();
        _builder_1.append("#define DEVICE7_REGISTERS_VALUES {\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG1 0b01000000 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x40U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG2 0b00100010 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x22U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG3 0b11000001 */\\");
        _builder_1.newLine();
        _builder_1.append("(0xC1U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG4 0b00000000 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x00U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG5 0b00000101 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x05U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG6 0b00000000U */\\");
        _builder_1.newLine();
        _builder_1.append("(0x00U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG7 0b00000001 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x01U),\\");
        _builder_1.newLine();
        _builder_1.append("/*TEST1 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x00U),\\");
        _builder_1.newLine();
        _builder_1.append("/* DIAG1CFGA 0b01010000 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x50U),\\");
        _builder_1.newLine();
        _builder_1.append("/* DIAG1CFGB 0b01001000 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x48U),\\");
        _builder_1.newLine();
        _builder_1.append("/* DIAG2CFGA 0b00101101 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x2DU),\\");
        _builder_1.newLine();
        _builder_1.append("/* DIAG2CFGB 0b10000011 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x83U)\\");
        _builder_1.newLine();
        _builder_1.append("}");
        _builder_1.newLine();
        _builder_1.append("#endif");
        _builder_1.newLine();
        _builder_1.append("/* default value */");
        _builder_1.newLine();
        _builder_1.append("#ifndef DEVICE8_REGISTERS_VALUES");
        _builder_1.newLine();
        _builder_1.append("#define DEVICE8_REGISTERS_VALUES {\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG1 0b01000000 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x40U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG2 0b00100010 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x22U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG3 0b11000001 */\\");
        _builder_1.newLine();
        _builder_1.append("(0xC1U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG4 0b00000000 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x00U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG5 0b00000101 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x05U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG6 0b00000000U */\\");
        _builder_1.newLine();
        _builder_1.append("(0x00U),\\");
        _builder_1.newLine();
        _builder_1.append("/* CFG7 0b00000001 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x01U),\\");
        _builder_1.newLine();
        _builder_1.append("/*TEST1 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x00U),\\");
        _builder_1.newLine();
        _builder_1.append("/* DIAG1CFGA 0b01010000 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x50U),\\");
        _builder_1.newLine();
        _builder_1.append("/* DIAG1CFGB 0b01001000 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x48U),\\");
        _builder_1.newLine();
        _builder_1.append("/* DIAG2CFGA 0b00101101 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x2DU),\\");
        _builder_1.newLine();
        _builder_1.append("/* DIAG2CFGB 0b10000011 */\\");
        _builder_1.newLine();
        _builder_1.append("(0x83U)\\");
        _builder_1.newLine();
        _builder_1.append("}");
        _builder_1.newLine();
        _builder_1.append("#endif");
        _builder_1.newLine();
        _builder_1.newLine();
        _builder_1.append("#endif /* __STGAP4_CONFIGURATION_H__ */");
        _builder_1.newLine();
        _builder_1.newLine();
        _builder_1.append("/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/");
        _builder_1.newLine();
        String _plus_1 = (String)res + String.valueOf(_builder_1);
        res = _plus_1;
        return res;
    }

    public String nibble(int a, int b, int c, int d) {
        if (a < 0 || a > 1 || b < 0 || b > 1 || c < 0 || c > 1 || d < 0 || d > 1) {
            return "X";
        }
        int x1 = 8 * a + 4 * b + 2 * c + d;
        if (x1 == 10) {
            return "A";
        }
        if (x1 == 11) {
            return "B";
        }
        if (x1 == 12) {
            return "C";
        }
        if (x1 == 13) {
            return "D";
        }
        if (x1 == 14) {
            return "E";
        }
        if (x1 == 15) {
            return "F";
        }
        if (x1 == 0) {
            return "0";
        }
        if (x1 == 1) {
            return "1";
        }
        if (x1 == 2) {
            return "2";
        }
        if (x1 == 3) {
            return "3";
        }
        if (x1 == 4) {
            return "4";
        }
        if (x1 == 5) {
            return "5";
        }
        if (x1 == 6) {
            return "6";
        }
        if (x1 == 7) {
            return "7";
        }
        if (x1 == 8) {
            return "8";
        }
        if (x1 == 9) {
            return "9";
        }
        return null;
    }

    public String int2hex(int x1) {
        if (x1 == 10) {
            return "A";
        }
        if (x1 == 11) {
            return "B";
        }
        if (x1 == 12) {
            return "C";
        }
        if (x1 == 13) {
            return "D";
        }
        if (x1 == 14) {
            return "E";
        }
        if (x1 == 15) {
            return "F";
        }
        return null;
    }
}

