package com.st.stellar.component.motorcontrol.validation

import com.st.stellar.component.motorcontrol.util.MotorcontrolValidator
import com.st.stellar.component.motorcontrol.MMotorcontrolPackage
import com.st.stellar.component.motorcontrol.Motorcontrol
import java.io.File
import java.util.Map
import org.eclipse.core.runtime.Path
import org.eclipse.emf.common.util.Diagnostic
import org.eclipse.emf.common.util.DiagnosticChain
import org.eclipse.emf.ecore.EObject
import org.eclipse.core.resources.ResourcesPlugin
import org.eclipse.core.resources.IProject import com.st.stellar.component.motorcontrol.MainSensor
import com.st.stellar.component.motorcontrol.AuxiliarySensor
import org.eclipse.xtext.EcoreUtil2
import com.st.stellar.component.motorcontrol.SensorList

class MyMotorcontrolValidator extends MotorcontrolValidator {

	public static final MyMotorcontrolValidator INSTANCE = new MyMotorcontrolValidator();

	Motorcontrol currentComponent

	static val ISSUE_CODE_PREFIX = "com.st.stellar.component.motorcontrol"

	override validateMotorcontrol(Motorcontrol comp, DiagnosticChain diagnostics, Map<Object, Object> context) {
		currentComponent = comp
		val res = super.validateMotorcontrol(comp, diagnostics, context)
		return res
	}

	static val WRONG_PATH = ISSUE_CODE_PREFIX + 'wrongPath'
	static val WRONG_SENSORLIST = ISSUE_CODE_PREFIX + 'wrongSensorList'
	
	override validateMainSensor(MainSensor mainSensor, DiagnosticChain diagnostics, Map<Object, Object> context){
		val root = EcoreUtil2.getRootContainer(mainSensor) as Motorcontrol
		val SensorSelection = root.drive_management.speed_sensor_selection
		var ret = true
		if(SensorSelection.auxiliary_sensor.sensor_list.sensor_selection.literal.equals(SensorSelection.main_sensor.sensor_list1.sensor_selection.literal) ){
			ret = false
		}else{
			ret = true
		}
		if (!ret) {
			if (diagnostics !== null) {
				diagnostics.add(
				createDiagnostic(Diagnostic::ERROR, WRONG_SENSORLIST, 0, "_UI_GenericConstraint_diagnostic",
					(#["checkSensorSelection",
					SensorSelection.main_sensor.sensor_list1.sensor_selection] as Object[]),
						(#[SensorSelection.main_sensor.sensor_list1] as Object[]), context))
					diagnostics.add(
					createDiagnostic(Diagnostic::ERROR, WRONG_SENSORLIST, 0, "_UI_GenericConstraint_diagnostic",
						(#["checkSensorSelection",
							SensorSelection.auxiliary_sensor.sensor_list.sensor_selection] as Object[]),
						(#[SensorSelection.auxiliary_sensor.sensor_list] as Object[]), context))
				}
 			}
	return ret
	}

	override validateAuxiliarySensor(AuxiliarySensor auxiliarySensor, DiagnosticChain diagnostics, Map<Object, Object> context) {
		val root = EcoreUtil2.getRootContainer(auxiliarySensor) as Motorcontrol
		val SensorSelection = root.drive_management.speed_sensor_selection
		var ret = true
		if(root.drive_management.speed_sensor_selection.auxiliary_sensor.sensor_list.sensor_selection.literal.equals(root.drive_management.speed_sensor_selection.main_sensor.sensor_list1.sensor_selection.literal) ){
			ret = false
		}else{
			ret = true
		}
		if (!ret) {
			if (diagnostics !== null) {
				diagnostics.add(
				createDiagnostic(Diagnostic::ERROR, WRONG_SENSORLIST, 0, "_UI_GenericConstraint_diagnostic",
					(#["checkSensorSelection",
					SensorSelection.main_sensor.sensor_list1.sensor_selection] as Object[]),
						(#[SensorSelection.main_sensor.sensor_list1] as Object[]), context))
					diagnostics.add(
					createDiagnostic(Diagnostic::ERROR, WRONG_SENSORLIST, 0, "_UI_GenericConstraint_diagnostic",
						(#["checkSensorSelection",
							SensorSelection.auxiliary_sensor.sensor_list.sensor_selection] as Object[]),
						(#[SensorSelection.auxiliary_sensor.sensor_list] as Object[]), context))
				}
 			}
	return ret
	}

	/*override validatePath_checkPath(String path, DiagnosticChain diagnostics, Map<Object, Object> context) {
		var res = checkPath(currentComponent, path, diagnostics, context)
		if (!res) {
			if (diagnostics !== null) {
				diagnostics.add(
					createDiagnostic(Diagnostic.ERROR, WRONG_PATH, 0, "_UI_GenericConstraint_diagnostic",
						#["checkPath", getValueLabel(MMotorcontrolPackage.Literals.PATH, path, context)], #[path], context))
				res = false
			}
		}
		return res
	}*/

	def checkPath(Motorcontrol comp, String location, DiagnosticChain chain, Map<Object, Object> map) {
		if(comp === null) return true
		val fileName = getProject(comp).getLocation().toOSString + File.separator + location
		val path = new Path(fileName)
		var res = false
		if (path.isValidPath(fileName)) {
			val file = new File(fileName)
			res = file.exists
		}
		res
	}

	static def IProject getProject(EObject model) {
		val uri = model.eResource.URI
		if (!uri.isFile) {
			return null
		}
		val projectName = uri.segmentsList().get(1).toString()
		return ResourcesPlugin.workspace.root.getProject(projectName)
	}
}
