package com.st.stellar.component.motorcontrol.impl

import com.st.stellar.component.motorcontrol.Torque
import com.st.stellar.component.motorcontrol.MMotorcontrolPackage
import com.st.stellar.component.motorcontrol.Magneticstructure_enum
import com.st.stellar.component.motorcontrol.Motorcontrol
import org.eclipse.xtext.EcoreUtil2
import org.eclipse.emf.ecore.EAttribute
import org.eclipse.emf.ecore.EObject
import java.util.List
import com.st.stellar.component.model.DerivedAttributeService
import org.eclipse.emf.common.notify.Notification
import org.eclipse.emf.common.notify.impl.AdapterImpl

// This class overrides the generated class and will be instantiated by factory
class TorqueImpl extends MTorqueImpl implements Torque{
	
		def dependsOn(EAttribute attr, EObject source, List<EAttribute> featureIDs) {
  		 DerivedAttributeService.INSTANCE.addDependencyListener(source, attr, featureIDs)
		}
		boolean initialized = false
	
	def addDependencies() {
		
		MMotorcontrolPackage.eINSTANCE.torque_Kp.dependsOn(
			this,
			#[
				MMotorcontrolPackage.eINSTANCE.torqueandfluxregulators_Manual_editing_enabled,
				MMotorcontrolPackage.eINSTANCE.torqueandfluxregulators_Cut_off_frequency,
				MMotorcontrolPackage.eINSTANCE.torqueandfluxregulators_Execution_rate,
				MMotorcontrolPackage.eINSTANCE.electricalparameters_Lq,
				MMotorcontrolPackage.eINSTANCE.electricalparameters_Ld
			]
		)
		
		MMotorcontrolPackage.eINSTANCE.torque_Ki.dependsOn(
			this,
			#[
				MMotorcontrolPackage.eINSTANCE.torqueandfluxregulators_Manual_editing_enabled,
				MMotorcontrolPackage.eINSTANCE.torqueandfluxregulators_Cut_off_frequency,
				MMotorcontrolPackage.eINSTANCE.torqueandfluxregulators_Execution_rate,
				MMotorcontrolPackage.eINSTANCE.electricalparameters_Lq,
				MMotorcontrolPackage.eINSTANCE.electricalparameters_Ld
			]
		)
		MMotorcontrolPackage.eINSTANCE.torque_Ki_div.dependsOn(
			this,			
			#[
				MMotorcontrolPackage.eINSTANCE.torqueandfluxregulators_Manual_editing_enabled,
				MMotorcontrolPackage.eINSTANCE.torqueandfluxregulators_Cut_off_frequency,
				MMotorcontrolPackage.eINSTANCE.torqueandfluxregulators_Execution_rate,
				MMotorcontrolPackage.eINSTANCE.electricalparameters_Lq,
				MMotorcontrolPackage.eINSTANCE.electricalparameters_Ld
			]
		)
			MMotorcontrolPackage.eINSTANCE.torque_Kp_div.dependsOn(
			this,
			#[
				MMotorcontrolPackage.eINSTANCE.torqueandfluxregulators_Manual_editing_enabled,
				MMotorcontrolPackage.eINSTANCE.torqueandfluxregulators_Cut_off_frequency,
				MMotorcontrolPackage.eINSTANCE.torqueandfluxregulators_Execution_rate,
				MMotorcontrolPackage.eINSTANCE.electricalparameters_Lq,
				MMotorcontrolPackage.eINSTANCE.electricalparameters_Ld
			]
		)

	}
	
	new(){
   	this.eAdapters.add(new AdapterImpl() {
      	 override notifyChanged(Notification arg0) {
         	  if (!initialized) {
        	       initialized = true
        	       addDependencies
       		    }
      		 }
  		 });
	}
	static class InternalTorque {
		double kp
		double ki
		int kp_div
		int ki_div
	}
	val InternalTorque torque = new InternalTorque()

	override int getKi() {
		val root = EcoreUtil2.getRootContainer(this) as Motorcontrol
		val parent = root.drive_management.drive_settings.torque_and_flux_regulators
		if (parent.manual_editing_enabled) {
			return super.getKi
		} else {
			calcKpKi(root)
			ki = torque.ki as int
			return ki
		}
	}

	override int getKi_div() {
		val root = EcoreUtil2.getRootContainer(this) as Motorcontrol
		val parent = root.drive_management.drive_settings.torque_and_flux_regulators
		if (parent.manual_editing_enabled) {
			return super.getKi_div
		} else {
			calcKpKi(root)
			ki_div = torque.ki_div as int
			return ki_div
		}
	}

	override int getKp() {
		val root = EcoreUtil2.getRootContainer(this) as Motorcontrol
		val parent = root.drive_management.drive_settings.torque_and_flux_regulators
		if (parent.manual_editing_enabled) {
			return super.getKp
		} else {
			calcKpKi(root)
			kp = torque.kp as int
			return kp
		}
	}

	override int getKp_div() {
		val root = EcoreUtil2.getRootContainer(this) as Motorcontrol
		val parent = root.drive_management.drive_settings.torque_and_flux_regulators
		if (parent.manual_editing_enabled) {
			return super.getKp_div
		} else {
			calcKpKi(root)
			kp_div = torque.kp_div as int
			return kp_div
		}
	}
	

//	/**********************************************************************************************************/
//	/* This function calculate the value of Kp Ki and divisors for torque and flux control loop               */
//	/**********************************************************************************************************/
	def calcKpKi(Motorcontrol motorControl) {
		var vbus = motorControl.power_stage.bus_voltage_sensing.nominal_voltage
		var gain = motorControl.power_stage.current_sensing.overall_amplification_gain
		var mcu_voltage = motorControl.control_stage.mcu_supply_voltage_and_clock_frequency.mcu_supply_voltage
		var cut_off = motorControl.drive_management.drive_settings.torque_and_flux_regulators.cut_off_frequency

		/* Calculate constant AB */
		var AB = ((vbus * gain) / mcu_voltage)
		// logger.logError(AB.toString());
		var structure = motorControl.motor_settings.magnetic_structure
		var ls = motorControl.motor_settings.electrical_parameters.ls
		var lq = motorControl.motor_settings.electrical_parameters.lq

		/* Calculate inductance based on magnetic structure */
		var Leq = 0.0
		if (structure == Magneticstructure_enum.SURFACE_MOUNTED_PMSM)
			Leq = ls
		else
			Leq = lq
		Leq = Leq / 1000.0

		var tfkp = ((Leq * cut_off) / AB)

		var stop = false
		for (var i = 0; i < 15 && !stop; i++) {
			torque.kp_div = 1 << i
			torque.kp = torque.kp_div * tfkp
			if ((torque.kp <= 4000.0) && (torque.kp >= 2000.0)) {
				stop = true
			}
		}

		var ld = motorControl.motor_settings.electrical_parameters.ld
		ld = ld / 1000.0f;
		/* Evaluation of ki for torque and flux */
		var rs = motorControl.motor_settings.electrical_parameters.rs

		var pwm_freq = motorControl.drive_management.drive_settings.pwm_generation_and_current_reading.pwm_frequency
		var rate = motorControl.drive_management.drive_settings.torque_and_flux_regulators.execution_rate.value
		/* Calculate FOC rate */
		var foc_rate = pwm_freq / rate

		/* [fki=((Rs*cut_off_freq/AB)*T)] */
		var fki = (rs * cut_off / AB) / foc_rate

		stop = false
		for (var i = 0; i < 15 && !stop; i++) {
			torque.ki_div = 1 << i
			torque.ki = torque.ki_div * fki
			if ((torque.ki <= 4000.0) && (torque.ki >= 2000.0)) {
				stop = true
			}
		}
	}

}
