package com.st.stellar.component.motorcontrol.impl

import com.st.stellar.component.model.DerivedAttributeService
import java.util.List
import com.st.stellar.component.motorcontrol.MMotorcontrolPackage
import com.st.stellar.component.motorcontrol.OverCurrentProtection
import org.eclipse.emf.common.notify.Notification
import org.eclipse.emf.common.notify.impl.AdapterImpl
import org.eclipse.emf.ecore.EAttribute
import org.eclipse.emf.ecore.EObject

// This class overrides the generated class and will be instantiated by factory
class OverCurrentProtectionImpl extends MOverCurrentProtectionImpl implements OverCurrentProtection {
	
	def dependsOn(EAttribute attr, EObject source, List<EAttribute> featureIDs) {
	 	DerivedAttributeService.INSTANCE.addDependencyListener(source, attr, featureIDs)
	 }
	 
	 boolean initialized = false
	 
	 new() {
		this.eAdapters.add(new AdapterImpl() {
			override notifyChanged(Notification arg0) {
				if (!initialized) {
					initialized = true
					addDependencies
				}
			}
		});
		
	}
	 

	def addDependencies() {

		MMotorcontrolPackage.eINSTANCE.overCurrentProtection_Expected_over_current_threshold.dependsOn(
			this,
			#[
				MMotorcontrolPackage.eINSTANCE.overCurrentProtection_Over_current_network_gain,
				MMotorcontrolPackage.eINSTANCE.overCurrentProtection_Over_current_network_offset,
				MMotorcontrolPackage.eINSTANCE.overCurrentProtection_Comparator_threshold
			]
		)
	}	 
	override getExpected_over_current_threshold() {
		val thr = this.comparator_threshold
		val offset = this.over_current_network_offset
		val gain = this.over_current_network_gain
		return (thr-offset)/gain
	} 
	 
 }