package com.st.stellar.component.motorcontrol.impl;



import com.st.stellar.component.motorcontrol.MotorcontrolPackage
import com.st.stellar.component.motorcontrol.validation.MyMotorcontrolValidator
import org.eclipse.emf.ecore.EValidator
import com.st.stellar.component.motorcontrol.Motorcontrol

// This class overrides the generated class and will be instantiated by factory
class MotorcontrolImpl extends MMotorcontrolImpl implements Motorcontrol {

new() {
		EValidator.Registry.INSTANCE.put(MotorcontrolPackage.eINSTANCE, new EValidator.Descriptor() {
			override getEValidator() {
				return MyMotorcontrolValidator.INSTANCE
			}
		});
		
	}


	
/* new() {
		DerivedAttributeService.INSTANCE.addDependencyListener(
			this,
			MotorcontrolPackage.eINSTANCE.motorcontrol_FilePath,
			#[
				MotorcontrolPackage.eINSTANCE.motorcontrol_Browse
			]
		)
		
		EValidator.Registry.INSTANCE.put(MotorcontrolPackage.eINSTANCE, new EValidator.Descriptor() {
			override getEValidator() {
				return MyMotorcontrolValidator.INSTANCE
			}
		});
		
	}

	override void browseModelPath() {
		Display.getDefault().syncExec([
			var DirectoryDialog dlg = new DirectoryDialog(Display.getDefault().getActiveShell()) // FileDialog dlg = new FileDialog(Display.getDefault().getActiveShell());
			// Set the initial filter path according
			// to anything they've selected or typed in
			dlg.setFilterPath("")

			// Change the title bar text
			dlg.setText("Select a folder")

			// Calling open() will open and run the dialog.
			// It will return the selected directory, or null if user cancels
			var String dir = dlg.open()
			if (dir !== null) {
				var IPath location = null;
				if (dir !== null) {
					// Replace absolute file name by relative path to the workspace
					location = new Path(dir);
					val base = getProject(this).getLocation();
					location = location.makeRelativeTo(base);

					setAttributeValue(this, MotorcontrolPackage.eINSTANCE.motorcontrol_FilePath, location.toString);
				}
			}
		])
	}
	
	static def IProject getProject(EObject model) {
		var IProject project = null
		val uri = model.eResource().getURI();
		if (!uri.isFile()) {
			project = null;
		}
		val projectName = uri.segmentsList().get(1).toString()
		project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
		return project;
	}
	
	def setAttributeValue(EObject object, EAttribute attribute, String value) {
		val editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor(object)

		val eClassifier = attribute.EType
		if (eClassifier instanceof EDataType) {
			val eDataType = eClassifier as EDataType
			val eFactory = eDataType.getEPackage().getEFactoryInstance()
			val newValue = eFactory.createFromString(eDataType, value)
			val Command command = SetCommand.create(editingDomain, object, attribute,
				newValue);
			// System.out.println("Attribute '" + attribute.getName() + "' set to " + newValue.toString());
			editingDomain.getCommandStack().execute(command);
		}
	}*/	
}
