package com.st.stellar.component.motorcontrol.impl

import java.util.Locale
import org.eclipse.emf.ecore.resource.Resource
import org.eclipse.xtext.generator.AbstractGenerator
import org.eclipse.xtext.generator.IFileSystemAccess2
import org.eclipse.xtext.generator.IGeneratorContext
import com.st.stellar.component.motorcontrol.Motorcontrol
import org.eclipse.emf.ecore.EObject;
import com.st.stellar.component.Component
import com.google.inject.Inject
import com.google.inject.Provider
import org.eclipse.core.resources.IResource
import org.eclipse.core.resources.ResourcesPlugin
import org.eclipse.core.runtime.NullProgressMonitor
import org.eclipse.emf.ecore.resource.ResourceSet
import com.st.stellar.component.motorcontrol.HighSideDriversignalpolarity_enum
import com.st.stellar.component.motorcontrol.LowSideDriversignalpolarity_enum
import com.st.stellar.component.motorcontrol.SensorSelection_enum
import com.st.stellar.component.motorcontrol.Polarity_enum
import com.st.stellar.component.motorcontrol.Magneticstructure_enum
import com.st.stellar.component.motorcontrol.CurrentReadingTopology_enum
import com.st.stellar.component.motorcontrol.ShuntPositioning_enum
import com.st.stellar.component.motorcontrol.PhaseSensingselection_enum
import com.st.stellar.component.motorcontrol.Controlmode_enum
import com.st.stellar.component.motorcontrol.Poweronstate_enum
import com.st.stellar.component.motorcontrol.Complementedfromhighside_enum
import com.st.stellar.component.motorcontrol.F1_enum
import com.st.stellar.component.motorcontrol.F2_enum
import com.st.stellar.component.motorcontrol.Autosettings_enum
import com.st.stellar.component.motorcontrol.HighsidePWMidlestate_enum
import com.st.stellar.component.motorcontrol.LowsidePWMidlestate_enum
import com.st.stellar.component.motorcontrol.PWM_moduletype_enum
import com.st.stellar.component.motorcontrol.ADC_COUPLE_enum
import com.st.stellar.component.motorcontrol.ADC_MODULETYPE_enum
import com.st.stellar.component.motorcontrol.CH1_enum
import com.st.stellar.component.motorcontrol.DAC_MODETYPE_enum
import com.st.stellar.component.motorcontrol.VBUS_TEMP_MODETYPE_enum
import com.st.stellar.component.motorcontrol.SENSING_TIM_CHANNELTYPE_enum
import com.st.stellar.component.motorcontrol.RES_DMA_MOD_enum
import com.st.stellar.component.motorcontrol.ADC_RESOLVER_enum
import com.st.stellar.component.motorcontrol.CH2_enum
import com.st.stellar.component.motorcontrol.COMSelection_enum 
import com.st.stellar.component.motorcontrol.Executionrate_enum
import com.st.stellar.component.motorcontrol.TIM_moduletype_enum
import com.st.stellar.component.motorcontrol.Amplificationselection_enum
import com.st.stellar.component.motorcontrol.DriverEnablingSignal_enum

class MotorcontrolCodeGenerator extends AbstractGenerator {

 @Inject Provider<ResourceSet> rsp

 override doGenerate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
		val resourceSet = rsp.get
		val r = resourceSet.getResource(input.URI, true)
		if(r.contents.empty) return
		val cmp = r.contents.head as Component
		val html_Power = generatePowerStageCode(cmp)
		fsa.generateFile("../code-gen/power_stage_parameters.h", html_Power)
        val html_PMSM = generatePMSMCode(cmp)
        fsa.generateFile("../code-gen/pmsm_motor_parameters.h", html_PMSM)
		val html_Drive = generateDriveParameterCode(cmp)
        fsa.generateFile("../code-gen/drive_parameters.h", html_Drive)
        val html_McConfig = generateMcConfigCode(cmp)
        fsa.generateFile("../code-gen/mc_config.h", html_McConfig)
		val html_PConv = generateParameterConversion(cmp)
		fsa.generateFile("../code-gen/parameters_conversion.h", html_PConv)   
		val html_PSR5E1 = generateParameterSR5E1(cmp)
		fsa.generateFile("../code-gen/parameters_conversion_SR5E1.h", html_PSR5E1)

		try {
			ResourcesPlugin.workspace.root.refreshLocal(IResource.DEPTH_INFINITE, new NullProgressMonitor)
		} catch (IllegalStateException ise) {
			// Ignore it... workspace is closed 
		}	
	}


	
	def String generatePowerStageCode(Component comp) {
	 	val powerStage = (comp as Motorcontrol).power_stage

		val hs_complemented = powerStage.phase_drivers.complemented_from_high_side
		val h_pol = powerStage.phase_drivers.high_side_driver_signal_polarity
		val l_pol = powerStage.phase_drivers.low_side_driver_signal_polarity
		val force = powerStage.phase_drivers.force_the_same_value_for_the_drivers
		val hw_dead_time = powerStage.phase_drivers.hw_inserted_dead_time
		val temperature_reading = powerStage.temperature_sensing.temperature_sensing_enable// upperCase

		val hu_pol = powerStage.phase_drivers.phase_u_driver.high_side_driver_signal_polarity
		val lu_pol = powerStage.phase_drivers.phase_u_driver.low_side_driver_signal_polarity
		val hv_pol = powerStage.phase_drivers.phase_v_driver.high_side_driver_signal_polarity
		val lv_pol = powerStage.phase_drivers.phase_v_driver.low_side_driver_signal_polarity
		val hw_pol = powerStage.phase_drivers.phase_w_driver.high_side_driver_signal_polarity
		val lw_pol = powerStage.phase_drivers.phase_w_driver.low_side_driver_signal_polarity

		val icl_pol = powerStage.inrush_current_limiter_shut_out.polarity
		val db_pol = powerStage.dissipative_brake.polarity
		
		val control_stage = (comp as Motorcontrol).control_stage
		val mcu_supply = control_stage.mcu_supply_voltage_and_clock_frequency.mcu_supply_voltage
		val vbus_voltage_reading = powerStage.bus_voltage_sensing.bus_voltage_sensing_enable
		val vbus_over_voltage_threshold = powerStage.bus_voltage_sensing.max_rated_bus_voltage
		val vbus_under_voltage_threshold = powerStage.bus_voltage_sensing.min_rated_bus_voltage
		val vbus_resistor_R1 = powerStage.bus_voltage_sensing.resistor_r1
		val vbus_resistor_R2 = powerStage.bus_voltage_sensing.resistor_r2		
		val v_nom = powerStage.bus_voltage_sensing.nominal_voltage
		val v_feedb_max = powerStage.bus_voltage_sensing.max_rated_bus_voltage/powerStage.bus_voltage_sensing.bus_voltage_divider	// Bus voltage divider is 1/(R2/(R1+R2))
		val v_feedb = v_nom/powerStage.bus_voltage_sensing.bus_voltage_divider
		var bus_div = 1.0
		if( vbus_voltage_reading ) {
			bus_div = 1/powerStage.bus_voltage_sensing.bus_voltage_divider
		} else if( v_nom>500) {
			bus_div = mcu_supply/1500 
		} else {
			bus_div = mcu_supply/500 
		}
		val v_meas_max = mcu_supply/bus_div
		
		var settings = powerStage.current_sensing
		val amp_selection = settings.amplification_selection
		val topology = settings.current_reading_topology
		val pos = settings.ics_or_two_shunt_settings.shunt_positioning
		val phase_select = settings.ics_or_two_shunt_settings.phase_sensing_selection
		val shunt = settings.shunt_resistor
		val gain = settings.overall_amplification_gain
		val rise = settings.rise_timing
		val noise = settings.noise_timing
		
		val settingsa = powerStage.application_task
		val charge_boot_cap_en_motor_1 = settingsa.enable_motor_1_gate_driver_boot_capacitors_charge
		val charge_boot_cap_en_motor_2 = settingsa.enable_motor_2_gate_driver_boot_capacitors_charge
		val charge_boot_cap_ms_motor_1 = settingsa.delay_in_ms_for_motor_1_drivers_boot_capacitors_charging
		val charge_boot_cap_ms_motor_2 = settingsa.delay_in_ms_for_motor_2_drivers_boot_capacitors_charging
		val offset_calibration_ms_motor_1 = settingsa.delay_in_ms_for_motor_1_current_reading_offset_calibration
		val offset_calibration_ms_motor_2 = settingsa.delay_in_ms_for_motor_2_current_reading_offset_calibration
		val permanency_stop_ms_motor_1 = settingsa.permanency_time_in_ms_for_motor_1_in_stop_state
		val permanency_stop_ms_motor_2 = settingsa.permanency_time_in_ms_for_motor_2_in_stop_state
		
		val settingsb = powerStage.temperature_sensing
		val V0 = settingsb.temperature_sensing_v0/1000
		val T0 = settingsb.temperature_sensing_t0
		val temp_coeff = settingsb.temperature_coefficient/1000
		val Tmax = settingsb.max_working_temperature_on_sensor
		//ctrl + Space for dynamic variables insertion
		
		val controlStage_c = (comp as Motorcontrol).control_stage
		val vbus_temp_c = controlStage_c.vbus_temp_measures
		val	temp_mode_check = vbus_temp_c.vbus_sensing_mode
		
		'''
		/****************************************************************************
		*
		* Copyright (c) 2023 STMicroelectronics - All Rights Reserved
		*
		* License terms: STMicroelectronics Proprietary in accordance with licensing
		* terms SLA0098 at www.st.com.
		*
		* THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
		* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
		*
		*****************************************************************************/
		/*
		*   @file    Power stage parameters.h
		*   @version 1.1.0
		*   @brief   This file contains Power stage parameters
		*
		*   @details This file contains Power stage parameters
		*/
		
		/* Define to prevent recursive inclusion -------------------------------------*/
		#ifndef __POWER_STAGE_PARAMETERS_H
		#define __POWER_STAGE_PARAMETERS_H
		
		/************* PWM Driving signals section **************/
		/* High side Polarity */
		«IF (force)»
			«IF (h_pol ===  HighSideDriversignalpolarity_enum.ACTIVE_LOW)»
				#define PHASE_UH_POLARITY             LL_TIM_OCPOLARITY_LOW 
				#define PHASE_VH_POLARITY             LL_TIM_OCPOLARITY_LOW 
				#define PHASE_WH_POLARITY             LL_TIM_OCPOLARITY_LOW 
			«ELSE»
				#define PHASE_UH_POLARITY             LL_TIM_OCPOLARITY_HIGH 
				#define PHASE_VH_POLARITY             LL_TIM_OCPOLARITY_HIGH
				#define PHASE_WH_POLARITY             LL_TIM_OCPOLARITY_HIGH
			«ENDIF»
		«ELSE»
			«IF (hu_pol ===  HighSideDriversignalpolarity_enum.ACTIVE_HIGH)»
				#define PHASE_UH_POLARITY             LL_TIM_OCPOLARITY_HIGH
			«ELSE»
				#define PHASE_UH_POLARITY             LL_TIM_OCPOLARITY_LOW
			«ENDIF»
			«IF (hv_pol ===  HighSideDriversignalpolarity_enum.ACTIVE_HIGH)»
				#define PHASE_VH_POLARITY             LL_TIM_OCPOLARITY_HIGH
			«ELSE»
				#define PHASE_VH_POLARITY             LL_TIM_OCPOLARITY_LOW
			«ENDIF»
			«IF (hw_pol ===  HighSideDriversignalpolarity_enum.ACTIVE_HIGH)»
				#define PHASE_WH_POLARITY             LL_TIM_OCPOLARITY_HIGH
			«ELSE»
				#define PHASE_WH_POLARITY             LL_TIM_OCPOLARITY_LOW
			«ENDIF»
		«ENDIF»
		
		#define HW_COMPLEMENTED_LOW_SIDE      «hs_complemented» 
		/* Low side Polarity */
		«IF(force)»
			«IF(l_pol === LowSideDriversignalpolarity_enum.ACTIVE_LOW)»
				#define PHASE_UL_POLARITY             LL_TIM_OCPOLARITY_LOW 
				#define PHASE_VL_POLARITY             LL_TIM_OCPOLARITY_LOW 
				#define PHASE_WL_POLARITY             LL_TIM_OCPOLARITY_LOW 
			«ELSE»
				#define PHASE_UL_POLARITY             LL_TIM_OCPOLARITY_HIGH 
				#define PHASE_VL_POLARITY             LL_TIM_OCPOLARITY_HIGH
				#define PHASE_WL_POLARITY             LL_TIM_OCPOLARITY_HIGH
			«ENDIF»
		«ELSE»
			«IF (lu_pol ===  LowSideDriversignalpolarity_enum.ACTIVE_HIGH)»
				#define PHASE_UL_POLARITY             LL_TIM_OCPOLARITY_HIGH
			«ELSE»
				#define PHASE_UL_POLARITY             LL_TIM_OCPOLARITY_LOW
			«ENDIF»
			«IF (lv_pol ===  LowSideDriversignalpolarity_enum.ACTIVE_HIGH)»
				#define PHASE_VL_POLARITY             LL_TIM_OCPOLARITY_HIGH
			«ELSE»
				#define PHASE_VL_POLARITY             LL_TIM_OCPOLARITY_LOW
			«ENDIF»
			«IF (lw_pol ===  LowSideDriversignalpolarity_enum.ACTIVE_HIGH)»
				#define PHASE_WL_POLARITY             LL_TIM_OCPOLARITY_HIGH
			«ELSE»
				#define PHASE_WL_POLARITY             LL_TIM_OCPOLARITY_LOW
			«ENDIF»
		«ENDIF»
		«IF(hs_complemented == Complementedfromhighside_enum.ENABLE)»		
		#define HW_DEAD_TIME_NS              «Math.round(hw_dead_time)» /*!< Dead-time inserted 
		                                              by HW if low side signals 
		                                              are not used */
		«ENDIF»			

		/********** Inrush current limiter signal section *******/
		«IF (icl_pol === Polarity_enum.ACTIVE_HIGH)»
		#define INRUSH_CURR_LIMITER_POLARITY  DOUT_ACTIVE_HIGH 
		«ELSE»
		#define INRUSH_CURR_LIMITER_POLARITY  DOUT_ACTIVE_LOW 
		«ENDIF»
		
		/******* Dissipative brake driving signal section *******/
		«IF(db_pol == Polarity_enum.ACTIVE_HIGH)»
		#define DISSIPATIVE_BRAKE_POLARITY    DOUT_ACTIVE_HIGH
		«ELSE»
		#define DISSIPATIVE_BRAKE_POLARITY    DOUT_ACTIVE_LOW
		«ENDIF»
		
		/*********** Bus voltage sensing section ****************/
		«IF(vbus_voltage_reading)»
			/* ENABLE/DISABLE Bus voltage sensing */
			#define VBUS_VOLTAGE_ENABLE TRUE
			«IF(vbus_under_voltage_threshold > vbus_over_voltage_threshold)»
			[#stop "Min Rated Bus Voltage («vbus_under_voltage_threshold»V) is higher than Max Rated Bus Voltage («vbus_over_voltage_threshold»V). Please update the over and under voltage values."]
			«ENDIF»
			«IF(vbus_under_voltage_threshold == vbus_over_voltage_threshold)»
			[#stop "Min Rated Bus Voltage («vbus_under_voltage_threshold»V) is equal to Max Rated Bus Voltage («vbus_over_voltage_threshold»V). Please update the over and under voltage values."]
			«ENDIF»
			«IF(amp_selection==Amplificationselection_enum.BY_L9502) && (temp_mode_check == VBUS_TEMP_MODETYPE_enum.TIM)»
			«IF(v_feedb_max > 5.7)»
			[#stop "Max Bus Voltage Feedback («v_feedb_max»V) is higher than ADC reference voltage (ADC reference Voltage = 5.7V). Please decrease Max Rated Bus Voltage to («v_meas_max») or change the value of R1 and/or R2."]
			«ENDIF»
			«IF(v_feedb > 5.7)»
			[#stop "Bus Voltage Feedback («v_feedb»V) is higher than ADC reference voltage (ADC reference Voltage = 5.7V). Please change the value of R1 and/or R2."]
			«ENDIF»			
			«ELSE»
			«IF(v_feedb_max > mcu_supply)»
			[#stop "Max Bus Voltage Feedback («v_feedb_max»V) is higher than ADC reference voltage (MCU Supply Voltage = «mcu_supply»V). Please decrease Max Rated Bus Voltage to («v_meas_max») or change the value of R1 and/or R2."]
			«ENDIF»
			«IF(v_feedb > mcu_supply)»
			[#stop "Bus Voltage Feedback («v_feedb»V) is higher than ADC reference voltage (MCU Supply Voltage = «mcu_supply»V). Please change the value of R1 and/or R2."]
			«ENDIF»
			«ENDIF»
		«ELSE»
			/* ENABLE/DISABLE Bus voltage sensing */
			#define VBUS_VOLTAGE_ENABLE FALSE
		«ENDIF»                                               
		#define VBUS_PARTITIONING_FACTOR      «String.format(Locale.ENGLISH,"%.04f",bus_div)» /*!< It expresses how 
		                                                  much the Vbus is attenuated  
		                                                  before being converted into 
		                                                  digital value */
		#define NOMINAL_BUS_VOLTAGE_V         «Math.round(v_nom)»
		
		#define VBUS_NETWORK_PULLUP_RES_OHM   «Math.round(vbus_resistor_R1*1000)»
		#define VBUS_NETWORK_PULLDW_RES_OHM   «Math.round(vbus_resistor_R2*1000)»
		/******** Current reading parameters section ******/
		/*** Topology ***/
		«IF(topology === CurrentReadingTopology_enum.ONE_SHUNT_RESISTOR)»
		#define SINGLE_SHUNT 
		«ENDIF»
		«IF(topology === CurrentReadingTopology_enum.THREE_SHUNT_RESISTOR)»
		#define THREE_SHUNT
		«ENDIF»
		«IF(topology === CurrentReadingTopology_enum.TWO_INSULATED_CURRENT_SENSORS)»
		#define ICS_SENSORS
		«ENDIF»

		«IF(pos==ShuntPositioning_enum.LEGS)»		
		#define ICS_SHUNT_SELECTION (ICS_SHUNT_LEGS)
		«ELSE»
		#define ICS_SHUNT_SELECTION (ICS_SHUNT_PHASES)
		«ENDIF»
		
		#define RSHUNT                        «shunt» 

		«IF(amp_selection==Amplificationselection_enum.BY_L9907)»
		/* Amplification selected L9907 gate driver */
		#define USE_L9907
		«ELSE»
		«IF(amp_selection==Amplificationselection_enum.BY_L9502)»
		/* Selected L9502 gate driver */
		#define USE_L9502
		/* L9502 ADC measurement parameters */
		#define EXT_ADC_RES ADC_10_BIT
		/* ADC MIN DUTY */
		#define EXT_ADC_MIN_DUTY 0.0039f
		/* ADC MAX DUTY */
		#define EXT_ADC_MAX_DUTY 0.997f
		
		«ELSE»
		«IF(amp_selection==Amplificationselection_enum.BY_L9908)»
		/* Amplification selected L9908 gate driver */
		#define USE_L9908
		«ELSE»
		«IF(amp_selection==Amplificationselection_enum.BY_STGAP4S)»
		/* Selected STGAP4S gate driver */
		#define USE_STGAP4S
		/* STGAP4S ADC measurement parameters */
		#define EXT_ADC_RES ADC_8_BIT
		/* ADC MIN DUTY */
		#define EXT_ADC_MIN_DUTY 0.1f
		/* ADC MAX DUTY */
		#define EXT_ADC_MAX_DUTY 0.9f
		
		«ENDIF»
		«ENDIF»
		«ENDIF»
		«ENDIF»
		/*  Overall Amplification gain is calculated as shunt resistor times Amplification Network Gain */
		#define AMPLIFICATION_GAIN            «gain» 
		/*Current sensing on legs as configured */
		«IF(phase_select==PhaseSensingselection_enum.UV)»
		#define ICS_SENSING_SELECTION (ICS_SENSING_ON_UV_PHASES)
		«ENDIF»
		«IF(phase_select==PhaseSensingselection_enum.UW)»
		#define ICS_SENSING_SELECTION (ICS_SENSING_ON_UW_PHASES)
		«ENDIF»
		«IF(phase_select==PhaseSensingselection_enum.VW)»
		#define ICS_SENSING_SELECTION (ICS_SENSING_ON_VW_PHASES)
		«ENDIF»
		/*** Noise parameters ***/
		#define TNOISE_NS                     «Math.round(noise)» 
		#define TRISE_NS                      «Math.round(rise)» 
		#define MAX_TNTR_NS TNOISE_NS 

		/************ Temperature sensing section ***************/
		«IF(temperature_reading)»
		/* ENABLE/DISABLE Temperature sensing */
		#define TEMP_VOLTAGE_ENABLE TRUE
		«ELSE»
		/* ENABLE/DISABLE Temperature sensing */
		#define TEMP_VOLTAGE_ENABLE FALSE
		«ENDIF»
		/* V[V]=V0+dV/dT[V/Celsius]*(T-T0)[Celsius]*/
		#define V0_V                          «V0» /*!< in Volts */
		#define T0_C                          «T0» /*!< in Celsius degrees */                                               
		#define dV_dT                         «String.format(Locale.ENGLISH,"%.03f",temp_coeff)» /*!< V/Celsius degrees */
		#define T_MAX                         «Math.round(Tmax)» /*!< Sensor measured 
				                                                       temperature at maximum 
				                                                       power stage working 
				                                                       temperature, Celsius degrees */
		#endif /*__POWER_STAGE_PARAMETERS_H*/
		'''
	}

	def String generatePMSMCode(Component comp) {

		// Power stage variables
        val powerStage = (comp as Motorcontrol).power_stage
		val topology = powerStage.current_sensing.current_reading_topology
        val overall_gain = powerStage.current_sensing.overall_amplification_gain
		
		// Motor settings variables
		val motorSettings = (comp as Motorcontrol).motor_settings
		val  magnetic = motorSettings.magnetic_structure
		val num_pole = motorSettings.electrical_parameters.pole_pairs
        val max_speed = motorSettings.electrical_parameters.max_rated_speed 
		val  x= motorSettings.electrical_parameters.nominal_current
		val b_emf = motorSettings.electrical_parameters.back_emfconstant
		val Rs = motorSettings.electrical_parameters.rs
		val autoset = motorSettings.electrical_parameters.autosettings
		val y = motorSettings.electrical_parameters.demagnetizing_current
		val Ls = motorSettings.electrical_parameters.ls/1000
		val Lq = motorSettings.electrical_parameters.lq/1000
		val Ld = motorSettings.electrical_parameters.ld/1000
	    val hs = motorSettings.sensors.hall_sensors
		val qe = motorSettings.sensors.quadrature_encoder
		val res = motorSettings.sensors.resolver
		val ext = motorSettings.sensors.external_sensor
		val res_phase_shift = motorSettings.sensors.resolver_phase_shift
		val sensors_displace = motorSettings.sensors.sensors_displacement  
		val sensors_angle = motorSettings.sensors.placement_electrical_angle  
		val mec_pulses = motorSettings.sensors.pulses_per_mechanical_revolution 
		
		// Control stage variables
		val controlStage = (comp as Motorcontrol).control_stage
		val mcu_supply = controlStage.mcu_supply_voltage_and_clock_frequency.mcu_supply_voltage
		
		
		val nom_curr= (x*32767*overall_gain*2)/mcu_supply
		var double demag_current = 0
		if (autoset == Autosettings_enum.ENABLE){
			demag_current = nom_curr
		}else{
			demag_current = (y*32767*overall_gain*2)/mcu_supply
		}
		
		val max_sensing_network_cur= mcu_supply/(2*overall_gain)
		val temp=max_sensing_network_cur
		val ratio = Ld/Lq


		
		
		
		//ctrl + Space for dynamic variables insertion
		'''
		/****************************************************************************
		*
		* Copyright (c) 2023 STMicroelectronics - All Rights Reserved
		*
		* License terms: STMicroelectronics Proprietary in accordance with licensing
		* terms SLA0098 at www.st.com.
		*
		* THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
		* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
		*
		*****************************************************************************/
		/*
		*   @file    PMSM motor parameters.h
		*   @version 1.1.0
		*   @brief   This file contains motor parameters
		*          
		*   @details This file contains motor parameters.
		*
		*/
		
		/* Define to prevent recursive inclusion -------------------------------------*/
		#ifndef __PMSM_MOTOR_PARAMETERS_H
		#define __PMSM_MOTOR_PARAMETERS_H

		#define MOTOR_TYPE             PMSM



		/***************** MOTOR ELECTRICAL PARAMETERS  ******************************/
		#define POLE_PAIR_NUM          «num_pole»  /* Number of motor pole pairs */
		#define RS                     «Rs»  /* Stator resistance , ohm*/
		«IF(magnetic === Magneticstructure_enum.SURFACE_MOUNTED_PMSM )»
		#define LS                     «String.format(Locale.ENGLISH,"%.08f",Ls)» /* Stator inductance, H
														For I-PMSM it is equal to Lq */
		«ELSE»
		#define LS                     «Lq»  /* Stator inductance, H
														For I-PMSM it is equal to Lq */
		«IF(ratio > 10)» 
		/*Error created for managing these exceptions.The generation must fail*/
		[#stop "Typical values of  (Ld/Lq) ratio are < 1, values bigger than 1 are admitted 
				but the ratio cannot exceed value of 10, actually is  «ratio»"]
		«ENDIF»    
		«ENDIF»

		/* When using Id = 0, NOMINAL_CURRENT is utilized to saturate the output of the 
		PID for speed regulation (i.e. reference torque). 
		Transformation of real currents (A) into s16 format must be done accordingly with 
		formula:
		Phase current (s16 0-to-peak) = (Phase current (A 0-to-peak)* 32767 * Rshunt *
										*Amplifying network gain)/(MCU supply voltage/2)
		*/

		#define NOMINAL_CURRENT         «Math.floor(nom_curr)»
		#define MOTOR_MAX_SPEED_RPM     «Math.round(max_speed)»  /*!< Maximum rated speed  */
		#define MOTOR_VOLTAGE_CONSTANT  «b_emf» /*!< Volts RMS ph-ph /kRPM */
		«IF(demag_current < 0.5)»
		#define ID_DEMAG                «Math.round(demag_current)»  /*!< Demagnetization current */
		«ELSE»
		#define ID_DEMAG               -«Math.round(demag_current)» /*!< Demagnetization current */
		«ENDIF»

		«IF(x > max_sensing_network_cur)» 
		/*Error created for managing these exceptions.The generation must fail*/

		[#stop "Nominal current higher than maximum supported by sensing network(«temp»A)"]
		«ENDIF»    

		/***************** MOTOR SENSORS PARAMETERS  ******************************/
		/* Motor sensors parameters are always generated but really meaningful only 
		if the corresponding sensor is actually present in the motor         */


		/*** Hall sensors ***/
		#define HALL_SENSORS_AVAILABLE  «hs.toString.toUpperCase(Locale.ENGLISH)»
		#define HALL_SENSORS_PLACEMENT  DEGREES_«sensors_displace» /*!<Define here the  
														mechanical position of the sensors
														with reference to an electrical cycle. 
														It can be either DEGREES_120 or 
														DEGREES_60 */
		«IF(sensors_displace ==  "60")» 
		/* Error created for managing these exceptions. The generation must fail */
		[#stop "DEGREES_60 displacement is not available for Hall Sensor, use DEGREES_120!"]
		«ENDIF»
																						
		#define HALL_PHASE_SHIFT        «Math.floor(sensors_angle).intValue» /*!< Define here in degrees  
														the electrical phase shift between 
														the low to high transition of 
														signal H1 and the maximum of 
														the Bemf induced on phase A */ 
		/*** Quadrature encoder ***/ 
		#define ENCODER_AVAILABLE       «qe.toString.toUpperCase(Locale.ENGLISH)»
		#define M1_ENCODER_PPR             «mec_pulses» /*!< Number of pulses per 
													revolution */
		/*** Resolver ***/
		#define RESOLVER_SENSORS_AVAILABLE  «res.toString.toUpperCase(Locale.ENGLISH)»
		#define RESOLVER_ANGLE_OFFSET_DEGREE        «Math.floor(res_phase_shift)»  /*!< Define here in degrees
														the electrical phase shift between
														the Resolver Channel A and the Bemf
														induced on phase A*/

		/*** External Sensor ***/
		#define EXTERNAL_SENSORS_AVAILABLE  «ext.toString.toUpperCase(Locale.ENGLISH)»

		#endif /*__PMSM_MOTOR_PARAMETERS_H*/
				'''
	}

    def String generateDriveParameterCode(Component comp) {
	 	// Power stage variables
		val powerStage = (comp as Motorcontrol).power_stage
		val vbus_voltage_reading = powerStage.bus_voltage_sensing.bus_voltage_sensing_enable// upperCase
		val temperature_reading = powerStage.temperature_sensing.temperature_sensing_enable// upperCase
		val topology = powerStage.current_sensing.current_reading_topology
		val overall_gain = powerStage.current_sensing.overall_amplification_gain
		val hs_complemented = powerStage.phase_drivers.complemented_from_high_side// upperCase
		val hs_signal = powerStage.phase_drivers.driver_enabling_signal
		val vbus = powerStage.bus_voltage_sensing.nominal_voltage
		
		val vbus_over_voltage_threshold = powerStage.bus_voltage_sensing.max_rated_bus_voltage
		val vbus_under_voltage_threshold = powerStage.bus_voltage_sensing.min_rated_bus_voltage
		val max_temp_on_sensor = powerStage.temperature_sensing.max_working_temperature_on_sensor
		val enable_hw_prot = powerStage.temperature_sensing.firmware_protection.enable
		val use_max_working_temp = powerStage.temperature_sensing.firmware_protection.over_temperature.set_intervention_threshold_to_max_working_temperature_on_sensor
		val over_temp_threshold = powerStage.temperature_sensing.firmware_protection.over_temperature.over_temperature_threshold
		val temp_hysteresis = powerStage.temperature_sensing.firmware_protection.over_temperature.hysteresis
		val inrushcurr_enable = powerStage.inrush_current_limiter_shut_out.enable_additional_features
		val po_state = powerStage.inrush_current_limiter_shut_out.power_on_state
		val after = powerStage.inrush_current_limiter_shut_out.change_state_after 
		var bus_div = 1.0

		// Motor setting variables
		val motorSettings = (comp as Motorcontrol).motor_settings
		val max_speed = motorSettings.electrical_parameters.max_rated_speed
		val hs = motorSettings.sensors.hall_sensors// upperCase
		val qe = motorSettings.sensors.quadrature_encoder// upperCase
		val ext = motorSettings.sensors.external_sensor// upperCase
        val pole = motorSettings.electrical_parameters.pole_pairs
        val magnetic = motorSettings.magnetic_structure
		val b_emf = motorSettings.electrical_parameters.back_emfconstant
		val Rs = motorSettings.electrical_parameters.rs
		val Ls = motorSettings.electrical_parameters.ls/1000
		val Ld = motorSettings.electrical_parameters.ld/1000
		val Lq = motorSettings.electrical_parameters.lq/1000
		val In= motorSettings.electrical_parameters.nominal_current
		

	    // Drive management variables
		val driveManagement = (comp as Motorcontrol).drive_management
		val main_sel = driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_selection				
		val en_aux_sel = driveManagement.speed_sensor_selection.auxiliary_sensor.enable_auxiliary_sensor
		val aux_sel = driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.sensor_selection
		val err_max = driveManagement.speed_sensor_selection.max_measurement_number_of_errors_before_fault
		var main_FIFO = 1.0
		var aux_FIFO = 1.0
		if(main_sel===SensorSelection_enum.HALL_SENSORS){
			 main_FIFO= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.hall_sensors.hall_average_speed_fifo_depth
			 aux_FIFO= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.hall_sensors.hall_average_speed_fifo_depth
		}else{
			 main_FIFO= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.quadrature_encoder.enc_average_speed_fifo_depth
			 aux_FIFO= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.quadrature_encoder.enc_average_speed_fifo_depth
		}
		val main_rev= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.quadrature_encoder.reverse_counting_direction
		val aux_rev= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.quadrature_encoder.reverse_counting_direction

		var tfreg = 1.0
		if(driveManagement.drive_settings.torque_and_flux_regulators.execution_rate==Executionrate_enum.E1){
			tfreg=1.0
		}else if(driveManagement.drive_settings.torque_and_flux_regulators.execution_rate==Executionrate_enum.E2){
			tfreg=2.0
		}else if(driveManagement.drive_settings.torque_and_flux_regulators.execution_rate==Executionrate_enum.E3){
			tfreg=3.0
		}else if(driveManagement.drive_settings.torque_and_flux_regulators.execution_rate==Executionrate_enum.E4){
			tfreg=4.0
		}else if(driveManagement.drive_settings.torque_and_flux_regulators.execution_rate==Executionrate_enum.E5){
			tfreg=5.0
		}
		
		//val tfreg=  driveManagement.drive_settings.torque_and_flux_regulators.execution_rate 
		val PWM_freq= driveManagement.drive_settings.pwm_generation_and_current_reading.pwm_frequency
		var PWM_freq_scaling = 1
		while((PWM_freq/PWM_freq_scaling > 65536) && (PWM_freq_scaling <= 16))
		{
			PWM_freq_scaling = PWM_freq_scaling<<1;
		}
		val main_shift= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.mainresolver.demodulation_trigger_delay
		val main_sig_freq= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.mainresolver.signal_frequency
		val main_pll_invert_dir= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.mainresolver.pll_invert_direction// upperCase 
		val main_res_mec_ratio= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.mainresolver.resolver_mechanical_ratio// upperCase
		val main_pll_manual_editing= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.mainresolver.pll_manual_editing_enabled// upperCase
		val main_res_KP_PLL= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.mainresolver.pll.kp_gain
		val main_res_KPDIV_PLL= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.mainresolver.pll.kp_div.literal
		val main_res_KI_PLL= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.mainresolver.pll.ki_gain
		val main_res_KIDIV_PLL= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.mainresolver.pll.ki_div.literal
		val main_phase_shift= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.mainresolver.resolver_advanced_parameters.resolver_shift
		val main_sin_phase= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.mainresolver.resolver_advanced_parameters.sin_phase_channel_b
		val main_cos_phase= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.mainresolver.resolver_advanced_parameters.cos_phase_channel_b
		val main_angle_read= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.mainresolver.resolver_advanced_parameters.resolver_angle_reading_type// upperCase
		val main_pole_mult= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.mainresolver.resolver_advanced_parameters.pole_pair_multiplier
		val aux_shift= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.auxresolver.demodulation_trigger_delay
		val aux_sig_freq= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.auxresolver.signal_frequency     
		val aux_pll_invert_dir= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.auxresolver.pll_invert_direction// upperCase
		val aux_res_mec_ratio= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.auxresolver.resolver_mechanical_ratio// upperCase                                
		val aux_pll_manual_editing= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.auxresolver.pll_manual_editing_enabled// upperCase
		val aux_res_KP_PLL= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.auxresolver.pll.kp_gain
		val aux_res_KPDIV_PLL= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.auxresolver.pll.kp_div
		val aux_res_KI_PLL= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.auxresolver.pll.ki_gain
		val aux_res_KIDIV_PLL= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.auxresolver.pll.ki_div
	    val aux_phase_shift= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.auxresolver.resolver_advanced_parameters.resolver_shift
		val aux_sin_phase= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.auxresolver.resolver_advanced_parameters.sin_phase_channel_b
		val aux_cos_phase= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.auxresolver.resolver_advanced_parameters.cos_phase_channel_b
		val aux_angle_read= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.auxresolver.resolver_advanced_parameters.resolver_angle_reading_type// upperCase
		val aux_pole_mult= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.auxresolver.resolver_advanced_parameters.pole_pair_multiplier
		val foc_rate=PWM_freq/tfreg
		var main_var= 		0.0
		var main_depth_loop=0.0
		var main_depth_obs= 0.0
		var main_emf_tol=	0.0
		var main_emf_gain= 	0.0
		var main_manual= 	false
		var main_G1=		0
		var main_G2= 		0
		var main_F1= 		F1_enum.E1
		var main_F2= 		F2_enum.E1
		var aux_var= 		0.0
		var aux_depth_loop= 0.0
		var aux_depth_obs= 	0.0
		var aux_emf_tol= 	0.0
		var aux_emf_gain=	0.0
		var aux_manual= 	false
		var aux_G1= 		0
		var aux_G2= 		0
		var aux_F1= 		F1_enum.E1
		var aux_F2= 		F2_enum.E1
		var aux_max_acc= 0.0
		var main_max_acc= 0.0
		
		if(main_sel==SensorSelection_enum.OBSERVER_PLL ){ //
			 main_var= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_pll1.variance_threshold/100
			 main_depth_loop= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_pll1.average_speed_depth_for_speed_loop
			 main_depth_obs= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_pll1.average_speed_depth_for_observer_equations
			 main_emf_tol= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_pll1.back_emf_consistency_tolerance
			 main_emf_gain= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_pll1.back_emf_consistency_gain
			 main_manual= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_pll1.manual_editing_enabled
			 main_G1= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_pll1.observer.gain1
			 main_G2= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_pll1.observer.gain2
			 main_F1= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_pll1.observer.f1
			 main_F2= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_pll1.observer.f2
			
		}else if(main_sel==SensorSelection_enum.OBSERVER_CORDIC ){
			 main_depth_loop= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_cordic1.average_speed_fifo_depth_for_speed_loop
			 main_depth_obs= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_cordic1.average_speed_fifo_depth_for_observer_equations
			 main_var= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_cordic1.variance_threshold/100
			 main_emf_tol= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_cordic1.back_emf_consistency_tolerance
			 main_emf_gain= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_cordic1.back_emf_consistency_gain
			 main_manual= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_cordic1.manual_editing_enabled
			 main_G1= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_cordic1.observer.gain1
			 main_G2= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_cordic1.observer.gain2
			 main_F1= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_cordic1.observer.f1
			 main_F2= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_cordic1.observer.f2
			 main_max_acc=((pole*driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_cordic1.maximum_application_acceleration/driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_cordic1.b_emf_quality_factor)*(65536/(foc_rate*foc_rate))/6)
		}	
		if(aux_sel==SensorSelection_enum.OBSERVER_PLL ){ //
			 
			 aux_var= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.sensor_less_observer_and_pll2.variance_threshold/100
			 aux_depth_loop= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.sensor_less_observer_and_pll2.average_speed_depth_for_speed_loop
			 aux_depth_obs= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.sensor_less_observer_and_pll2.average_speed_depth_for_observer_equations
			 aux_emf_tol= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.sensor_less_observer_and_pll2.back_emf_consistency_tolerance
			 aux_emf_gain= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.sensor_less_observer_and_pll2.back_emf_consistency_gain
			 aux_manual= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.sensor_less_observer_and_pll2.manual_editing_enabled
			 aux_G1= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.sensor_less_observer_and_pll2.observer.gain1
			 aux_G2= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.sensor_less_observer_and_pll2.observer.gain2
			 aux_F1= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.sensor_less_observer_and_pll2.observer.f1
			 aux_F2= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.sensor_less_observer_and_pll2.observer.f2
		}else if(aux_sel==SensorSelection_enum.OBSERVER_CORDIC ){
			 
			 aux_depth_loop= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.sensor_less_observer_and_cordic2.average_speed_fifo_depth_for_speed_loop
			 aux_depth_obs= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.sensor_less_observer_and_cordic2.average_speed_fifo_depth_for_observer_equations
			 aux_var= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.sensor_less_observer_and_cordic2.variance_threshold/100
			 aux_emf_tol= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.sensor_less_observer_and_cordic2.back_emf_consistency_tolerance
			 aux_emf_gain= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.sensor_less_observer_and_cordic2.back_emf_consistency_gain
			 aux_manual= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.sensor_less_observer_and_cordic2.manual_editing_enabled
			 aux_G1= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.sensor_less_observer_and_cordic2.observer.gain1
			 aux_G2= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.sensor_less_observer_and_cordic2.observer.gain2
			 aux_F1= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.sensor_less_observer_and_cordic2.observer.f1
			 aux_F2= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.sensor_less_observer_and_cordic2.observer.f2
			 aux_max_acc=((pole*driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.sensor_less_observer_and_cordic2.maximum_application_acceleration/driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.sensor_less_observer_and_cordic2.b_emf_quality_factor)*(65536/(foc_rate*foc_rate))/6)
			}	
		val main_KP_PLL= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_pll1.pll.kp_gain
		val main_KP_PLL_div= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_pll1.pll.kp_div
		val main_KI_PLL= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_pll1.pll.ki_gain
		val main_KI_PLL_div= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_pll1.pll.ki_div
		val aux_KP_PLL= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.sensor_less_observer_and_pll2.pll.kp_gain
		val aux_KP_PLL_div= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.sensor_less_observer_and_pll2.pll.kp_div
		val aux_KI_PLL= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.sensor_less_observer_and_pll2.pll.ki_gain
		val aux_KI_PLL_div= driveManagement.speed_sensor_selection.auxiliary_sensor.sensor_list.sensor_less_observer_and_pll2.pll.ki_div
		val hfi_freq= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_hfi.hfifrequency
		val amplitude= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_hfi.amplitude
		val kp= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_hfi.kp
		val ki= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_hfi.ki
		val kp_div= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_hfi.kp_div
		val ki_div= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_hfi.ki_div
		val pll_kp= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_hfi.scan.pll_kp
		val pll_ki= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_hfi.scan.pll_ki
		val scan_freq= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_hfi.scan.frequency
		val rotation_no= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_hfi.scan.rotation_number
		val min_reliable_speed= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_hfi.speed_threshold.minimum_reliable_speed
		val amplitude_boost= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_hfi.north_south_identification.amplitude_boost
		val wait_before= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_hfi.north_south_identification.wait_before
		val wait_after= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_hfi.north_south_identification.wait_after
		val min_sat_diff= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_hfi.north_south_identification.min_saturation_difference
		val debug_mode = driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_hfi.debug_mode
		val pulse_number= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_hfi.north_south_identification.pulse_number
		val pulses_skipped= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_hfi.north_south_identification.pulses_skipped
		val revert_direction = driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_hfi.revert_direction
		val sto_hfi_th= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_hfi.speed_threshold.sto_hfi_threshold
		val k_for_notch= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_hfi.k_for_notch
		val k_for_lp= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_hfi.k_for_low_pass
		val k_for_hp= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_hfi.k_for_high_pass
		val k_for_dc= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_hfi.k_for_dc
		val spc5_init=driveManagement.drive_settings.spc5_initialization// upperCase
		val hs_idle= driveManagement.drive_settings.pwm_generation_and_current_reading.high_side_pwm_idle_state
		val SW_dead_time= driveManagement.drive_settings.pwm_generation_and_current_reading.low_side_signals_and_dead_time.sw_inserted_dead_time
		val ls_idle= driveManagement.drive_settings.pwm_generation_and_current_reading.low_side_signals_and_dead_time.low_side_pwm_idle_state
		val speed_en= driveManagement.drive_settings.speed_regulator.max_speed_enabled
		val exec_rate= 1000/driveManagement.drive_settings.speed_regulator.execution_rate
		val SP_KP=driveManagement.drive_settings.speed_regulator.kp
		val SP_KI=driveManagement.drive_settings.speed_regulator.ki
		val SP_KIDIV=driveManagement.drive_settings.speed_regulator.ki_div
		val SP_KPDIV=driveManagement.drive_settings.speed_regulator.kp_div
		val cut_off_freq=driveManagement.drive_settings.torque_and_flux_regulators.cut_off_frequency
		val man_edit=driveManagement.drive_settings.torque_and_flux_regulators.manual_editing_enabled
		val T_KP=driveManagement.drive_settings.torque_and_flux_regulators.torque.kp
		val T_KI=driveManagement.drive_settings.torque_and_flux_regulators.torque.ki
		val T_KIDIV=driveManagement.drive_settings.torque_and_flux_regulators.torque.ki_div
		val T_KPDIV=driveManagement.drive_settings.torque_and_flux_regulators.torque.kp_div
		val F_KP=driveManagement.drive_settings.torque_and_flux_regulators.flux.kp
		val F_KI=driveManagement.drive_settings.torque_and_flux_regulators.flux.ki
		val F_KIDIV=driveManagement.drive_settings.torque_and_flux_regulators.flux.ki_div
		val F_KPDIV=driveManagement.drive_settings.torque_and_flux_regulators.flux.kp_div
		val cnt_mode=driveManagement.drive_settings.default_settings.control_mode
		val speed=driveManagement.drive_settings.default_settings.target_speed
		val torque_curr=driveManagement.drive_settings.default_settings.target_stator_current_torque_component
		val flux_curr=driveManagement.drive_settings.default_settings.target_stator_current_flux_component
		val dur= driveManagement.startup_parameters.encoder_alignment_settings.duration
		val align= driveManagement.startup_parameters.encoder_alignment_settings.alignment_electrical_angle 
		val  x= driveManagement.startup_parameters.encoder_alignment_settings.final_current_ramp_value
		val adv= driveManagement.startup_parameters.sensor_less_rev_up_settings.enable_advanced_profile
		val align_en= driveManagement.startup_parameters.sensor_less_rev_up_settings.basic.include_alignment_before_ramp_up
		val speed_duration= driveManagement.startup_parameters.sensor_less_rev_up_settings.basic.speed_ramp_duration 
		val speed_fin_val= driveManagement.startup_parameters.sensor_less_rev_up_settings.basic.speed_ramp_final_value 
		val align_duration= driveManagement.startup_parameters.sensor_less_rev_up_settings.basic.duration 
		val align_angle= driveManagement.startup_parameters.sensor_less_rev_up_settings.basic.alignment_electrical_angle 
		val y= driveManagement.startup_parameters.sensor_less_rev_up_settings.basic.final_current_ramp_value 
		val zi= driveManagement.startup_parameters.sensor_less_rev_up_settings.basic.current_ramp_initial_value 
		val zf= driveManagement.startup_parameters.sensor_less_rev_up_settings.basic.current_ramp_final_value 
		val ph3_duration_val= driveManagement.startup_parameters.sensor_less_rev_up_settings.basic.current_ramp_duration 
		val adv_align_angle= driveManagement.startup_parameters.sensor_less_rev_up_settings.advanced_customized.alignment_electrical_angle 
		val ph1_duration= driveManagement.startup_parameters.sensor_less_rev_up_settings.advanced_customized.phase_1.duration 
		val ph1_fin_speed= driveManagement.startup_parameters.sensor_less_rev_up_settings.advanced_customized.phase_1.final_speed 
		val x1= driveManagement.startup_parameters.sensor_less_rev_up_settings.advanced_customized.phase_1.final_current 
		val ph2_duration= driveManagement.startup_parameters.sensor_less_rev_up_settings.advanced_customized.phase_2.duration 
		val ph2_fin_speed= driveManagement.startup_parameters.sensor_less_rev_up_settings.advanced_customized.phase_2.final_speed 
		val x2= driveManagement.startup_parameters.sensor_less_rev_up_settings.advanced_customized.phase_2.final_current 
		val ph3_duration= driveManagement.startup_parameters.sensor_less_rev_up_settings.advanced_customized.phase_3.duration 
		val ph3_fin_speed= driveManagement.startup_parameters.sensor_less_rev_up_settings.advanced_customized.phase_3.final_speed 
		val x3= driveManagement.startup_parameters.sensor_less_rev_up_settings.advanced_customized.phase_3.final_current 
		val ph4_duration= driveManagement.startup_parameters.sensor_less_rev_up_settings.advanced_customized.phase_4.duration 
		val ph4_fin_speed= driveManagement.startup_parameters.sensor_less_rev_up_settings.advanced_customized.phase_4.final_speed 
		val x4= driveManagement.startup_parameters.sensor_less_rev_up_settings.advanced_customized.phase_4.final_current 
		val ph5_duration= driveManagement.startup_parameters.sensor_less_rev_up_settings.advanced_customized.phase_5.duration 
		val ph5_fin_speed= driveManagement.startup_parameters.sensor_less_rev_up_settings.advanced_customized.phase_5.final_speed 
		val x5= driveManagement.startup_parameters.sensor_less_rev_up_settings.advanced_customized.phase_5.final_current 
		val exec= driveManagement.startup_parameters.sensor_less_rev_up_settings.advanced_customized.execute_sensor_less_algorithm_starting_from
		val cons_startup= driveManagement.startup_parameters.sensor_less_rev_up_settings.consecutive_successfull_start_up_output_tests 
		val min_startup= driveManagement.startup_parameters.sensor_less_rev_up_settings.minimum_start_up_output_speed 
		val upper_limit= driveManagement.startup_parameters.sensor_less_rev_up_settings.estimated_speed_band_tolerance_upper_limit*16/100 
		val lower_limit= driveManagement.startup_parameters.sensor_less_rev_up_settings.estimated_speed_band_tolerance_lower_limit*16/100 
		val en_switch_over= driveManagement.startup_parameters.sensor_less_rev_up_settings.rev_up_to_foc_switch_over.enable
		val duration_switch_over= driveManagement.startup_parameters.sensor_less_rev_up_settings.rev_up_to_foc_switch_over.duration 
		val hfi_cons_startup= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_hfi.speed_threshold.consecutive_successful_start_up_output_tests 
		val hfi_sto_th= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_hfi.speed_threshold.hfi_sto_threshold 
		val hfi_upper_limit= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_hfi.speed_threshold.estimated_speed_band_tolerance_upper_limit*16/100 
		val hfi_lower_limit= driveManagement.speed_sensor_selection.main_sensor.sensor_list1.sensor_less_observer_and_hfi.speed_threshold.estimated_speed_band_tolerance_lower_limit*16/100
		val fw_enable = driveManagement.additional_features.additional_methods.flux_weakening_enable
		val v_limit = driveManagement.additional_features.additional_methods.flux_weakening.voltage_limit*10 
		val fw_kp = driveManagement.additional_features.additional_methods.flux_weakening.kp 
		val fw_ki = driveManagement.additional_features.additional_methods.flux_weakening.ki 
		val fw_kp_div = driveManagement.additional_features.additional_methods.flux_weakening.kp_div 
		val fw_ki_div = driveManagement.additional_features.additional_methods.flux_weakening.ki_div 
		val mtpa_enable = driveManagement.additional_features.additional_methods.mtpa_enable
		val ff_enable = driveManagement.additional_features.additional_methods.feed_forward_enable
		
		val com_sel = driveManagement.user_interface.com_selection
		val can_max_len = driveManagement.user_interface.can_details.max_message_length 
		val can_tx_start = driveManagement.user_interface.can_details.starting_tx_message_id 
		val br = driveManagement.user_interface.can_details.canbaudrate 
		val sbr = driveManagement.user_interface.serial_details.serialbaudrate
		
		// Control stage variables
		val controlStage = (comp as Motorcontrol).control_stage
		val cpu_clk = controlStage.mcu_supply_voltage_and_clock_frequency.cpu_clock_frequency
		val mcu_supply = controlStage.mcu_supply_voltage_and_clock_frequency.mcu_supply_voltage
		val mc_clk_for_res = 0 //controlStage.mcu_supply_voltage_and_clock_frequency.motor_control_clock_frequency
		val mc_clk = 0 // controlStage.mcu_supply_voltage_and_clock_frequency.motor_control_clock_frequency

		val loc=(PWM_freq/tfreg)*(PWM_freq/tfreg)
				if( vbus_voltage_reading ) {
			bus_div = 1/powerStage.bus_voltage_sensing.bus_voltage_divider
		} else if( vbus>500) {
			bus_div = mcu_supply/1500 
		} else {
			bus_div = mcu_supply/500 
		}
		var L= 0.0
		if(magnetic===Magneticstructure_enum.SURFACE_MOUNTED_PMSM){
			L=Ls
		} else {
			L=Lq
		}
		
		val RL_ratio=Rs/L
		val e2=0.25
		val e1=0.25*(1-(Rs/(L*foc_rate)))
		val k1=((e1+e2-2)*foc_rate)+RL_ratio
		val k2=(1-e1-e2+(e1*e2))*L*(foc_rate*foc_rate)
		val max_voltage=mcu_supply/(1.732*bus_div)
		val max_cur= mcu_supply/(2*overall_gain) 
		val max_bemf_voltage_temp=(max_speed*1.2*b_emf*1.4142/(1000*1.732))
		val max_bemf_voltage= Math.round(max_bemf_voltage_temp)
		
		// TBD
		var f1value =#[16384, 8192, 4096, 2048, 1024, 512, 256, 128, 64, 32, 16, 8, 4, 2,1]
		var f1=0
		var c1= 0.0
		var g1= 0.0
		var c3= 0.0
		var c5= 0.0
		var f2value =#[16384, 8192, 4096, 2048, 1024, 512, 256, 128, 64, 32, 16, 8, 4, 2,1]
		var f2=0
		var g2= 0.0
		// END TBD
		
		
		
		var exit = 0
		var i = 0
		do{
			f1 = f1value.get(i)
			c1= (f1*(Rs/(L*foc_rate)))
			g1= (f1*k1)/foc_rate
			c3= (f1*max_bemf_voltage/(L*max_cur*foc_rate))
			c5= (f1*max_voltage/(L*max_cur*foc_rate))
			if( (c1 < 32768)&&(c3 < 32768)&&(c5 < 32768)&&((g1 < 32768)&&(g1 > -32768))){
				exit = 1
				}
			i = i +1
		}while((i<15) && (exit == 0))

		i=0
		exit = 0
		do{
			f2=f2value.get(i)
			g2= (((max_cur*k2)/max_bemf_voltage)*(f2/foc_rate))
			if( (g2 < 32768)&&(g2 > -32768)){
				exit = 1
				}
			i = i + 1
		}while((i<15) && (exit == 0))
		
		/*
		//////////////////////////////////////////HELP HERE
		//[#list f1value as temp1]
		val f1=f1value]
		//////////////////////////////////////////END HELP
		val c1= (f1*(Rs/(L*foc_rate)))
		val g1= (f1*k1)/foc_rate
		val c3= (f1*max_bemf_voltage/(L*max_cur*foc_rate))
		val c5= (f1*max_voltage/(L*max_cur*foc_rate))

		if( (c1 < 32768)&&(c3 < 32768)&&(c5 < 32768)&&((g1 < 32768)&&(g1 > -32768))){}

		
		val f2value=[16384, 8192, 4096, 2048, 1024, 512, 256, 128, 64, 32, 16, 8, 4, 2, 1]]
		//[#list f2value as temp2]
		val f2=f2value]
		val g2= (((max_cur*k2)/max_bemf_voltage)*(f2/foc_rate))]
		«IF( (g2 < 32768)&&(g2 > -32768)]
		*/

	  	val lock_freq_dpp= (scan_freq*65536)/foc_rate	
		val max_scan_freq=hfi_freq/30
		val max_hfi_freq=foc_rate/10
		val norm_for_notch= 1/(1+(k_for_notch/2)+(k_for_notch*k_for_notch))
		val a0_for_notch = (1+k_for_notch*k_for_notch)*norm_for_notch
		val a1_for_notch = 2*(k_for_notch*k_for_notch-1)*norm_for_notch
		val b1_for_notch = -a1_for_notch
		val b2_for_notch = -(1-k_for_notch/2+k_for_notch*k_for_notch)*norm_for_notch

		val norm_for_lp= 1/(1+(k_for_lp/0.707107)+(k_for_lp*k_for_lp))
		val a0_for_lp = (k_for_lp*k_for_lp)*norm_for_lp
		val a1_for_lp = 2*a0_for_lp
		val b1_for_lp = -2*(k_for_lp*k_for_lp-1)*norm_for_lp
		val b2_for_lp = -(1-k_for_lp/0.707107+k_for_lp*k_for_lp)*norm_for_lp

		val norm_for_hp= 1/(1+(k_for_hp/0.707107)+(k_for_hp*k_for_hp))
		val a0_for_hp = norm_for_hp
		val a1_for_hp = -2*a0_for_hp
		val b1_for_hp = -2*(k_for_hp*k_for_hp-1)*norm_for_hp
		val b2_for_hp = -(1-k_for_hp/0.707107+k_for_hp*k_for_hp)*norm_for_hp

		val norm_for_dc= 1/(1+(k_for_dc/0.707107)+(k_for_dc*k_for_dc))
		val a0_for_dc = k_for_dc*k_for_dc*norm_for_dc
		val a1_for_dc = 2*a0_for_dc
		val b1_for_dc = -2*(k_for_dc*k_for_dc-1)*norm_for_dc
		val b2_for_dc = -(1-k_for_dc/0.707107+k_for_dc*k_for_dc)*norm_for_dc
		val  torque_curr_digit = (torque_curr*32767*overall_gain*2)/mcu_supply
		val  flux_curr_digit   = (flux_curr * 32767*overall_gain*2)/mcu_supply
		val  final_curr_ramp= (x*32767*overall_gain*2)/mcu_supply
		val  ph1_final_curr= (y*32767*overall_gain*2)/mcu_supply
		val  ph2_final_curr= (zi*32767*overall_gain*2)/mcu_supply
		val  ph3_final_curr= (zf*32767*overall_gain*2)/mcu_supply
		val  ph3_final_speed= (ph3_duration_val/speed_duration)*speed_fin_val
		val  ph4_final_duration= (speed_duration-ph3_duration_val)
		val  ph1_fin_curr= (x1*32767*overall_gain*2)/mcu_supply
		val  ph2_fin_curr= (x2*32767*overall_gain*2)/mcu_supply
		val  ph3_fin_curr= (x3*32767*overall_gain*2)/mcu_supply
		val  ph4_fin_curr= (x4*32767*overall_gain*2)/mcu_supply
		val  ph5_fin_curr= (x5*32767*overall_gain*2)/mcu_supply
		val cFM=(b_emf*1.4142*60)/(1732*6.2832*pole)
		val T1=tfreg/PWM_freq
		val temp=(6.2832*max_cur*16384*bus_div)/(T1*mcu_supply)
		var c1_Q = 0.0
		var c1_D = 0.0
		if(magnetic==Magneticstructure_enum.SURFACE_MOUNTED_PMSM){
			c1_Q=Ls*temp
			c1_D=Ls*temp
		}else{
			c1_Q=Lq*temp
			c1_D=Ld*temp
		}
		val c2_QD=(6.2832*cFM*32768*bus_div)/(T1*mcu_supply*16)	
		val  nom_cur_digit= (In*32767*overall_gain*2)/mcu_supply
		val delta = Math.pow(cFM,2) + (8*Math.pow(Ld-Lq,2)*Math.pow(In,2))
		val cosEMax = (-cFM + Math.sqrt(delta))/(4*(Ld-Lq)*In)
		val Idmax = In*cosEMax
		val Iqmax = Math.sqrt(Math.pow(In,2) - Math.pow(Idmax,2))
		val cIqmax = (Iqmax*32767)/max_cur
		val cSegDiv = cIqmax/8

 
		//Iq e Id dei vettori
		val root = Math.pow(cFM,2)/(4*Math.pow(Lq-Ld,2))

		var Iq_array_0 = cIqmax/8
		var Id_array_0 = ((cFM/(2*((Lq-Ld)))) - Math.sqrt((root) + (Math.pow(Iqmax/8,2))))*32767/max_cur

		var Iq_array_1 = 2*cIqmax/8
		var Id_array_1 = ((cFM/(2*((Lq-Ld)))) - Math.sqrt((root) + (Math.pow(2*Iqmax/8,2))))*32767/max_cur

		var Iq_array_2 = 3*cIqmax/8
		var Id_array_2 = ((cFM/(2*((Lq-Ld)))) - Math.sqrt((root) + (Math.pow(3*Iqmax/8,2))))*32767/max_cur

		var Iq_array_3 = 4*cIqmax/8
		var Id_array_3 = ((cFM/(2*((Lq-Ld)))) - Math.sqrt((root) + (Math.pow(4*Iqmax/8,2))))*32767/max_cur

		var Iq_array_4 = 5*cIqmax/8
		var Id_array_4 = ((cFM/(2*((Lq-Ld)))) - Math.sqrt((root) + (Math.pow(5*Iqmax/8,2))))*32767/max_cur

		var Iq_array_5 = 6*cIqmax/8
		var Id_array_5 = ((cFM/(2*((Lq-Ld)))) - Math.sqrt((root) + (Math.pow(6*Iqmax/8,2))))*32767/max_cur

		var Iq_array_6 = 7*cIqmax/8
		var Id_array_6 = ((cFM/(2*((Lq-Ld)))) - Math.sqrt((root) + (Math.pow(7*Iqmax/8,2))))*32767/max_cur

		var Iq_array_7 = 8*cIqmax/8
		var Id_array_7 = ((cFM/(2*((Lq-Ld)))) - Math.sqrt((root) + (Math.pow(8*Iqmax/8,2))))*32767/max_cur

		val m0 = ( Id_array_0 / Iq_array_0)* 32768
		val m1 = (( Id_array_1 - Id_array_0 ) / (Iq_array_1 - Iq_array_0))* 32768
		val m2 = (( Id_array_2 - Id_array_1 ) / (Iq_array_2 - Iq_array_1))* 32768
		val m3 = (( Id_array_3 - Id_array_2 ) / (Iq_array_3 - Iq_array_2))* 32768
		val m4 = (( Id_array_4 - Id_array_3 ) / (Iq_array_4 - Iq_array_3))* 32768
		val m5 = (( Id_array_5 - Id_array_4 ) / (Iq_array_5 - Iq_array_4))* 32768
		val m6 = (( Id_array_6 - Id_array_5 ) / (Iq_array_6 - Iq_array_5))* 32768
		val m7 = (( Id_array_7 - Id_array_6 ) / (Iq_array_7 - Iq_array_6))* 32768

		val off1 = ( -(m1 * Iq_array_0/32768) + Id_array_0) 
		val off2 = ( -(m2 * Iq_array_1/32768) + Id_array_1) 
		val off3 = ( -(m3 * Iq_array_2/32768) + Id_array_2) 
		val off4 = ( -(m4 * Iq_array_3/32768) + Id_array_3) 
		val off5 = ( -(m5 * Iq_array_4/32768) + Id_array_4) 
		val off6 = ( -(m6 * Iq_array_5/32768) + Id_array_5) 
		val off7 = ( -(m7 * Iq_array_6/32768) + Id_array_6)       
		/*for( i = 0; i< 7; i++)
		var Iq_array = #[0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0]
		var Id_array = #[0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0]
		i=1
			do{
			 Iq_array.set(i-1, Iq_array.get(i-1)  +  ( i*cIqmax/8 ))
			 Id_array.set(i-1, Id_array.get(i-1)  +  ((cFM/(2*((Lq-Ld)))) - Math.sqrt((root) + (Math.pow(i*Iqmax/8,2))))*32767/max_cur) 
			i = i + 1
		}while(i <8)

		val m0 = ( Id_array.get(0) / Iq_array.get(0))* 32768
		val m1 = (( Id_array.get(1) - Id_array.get(0) ) / (Iq_array.get(1) - Iq_array.get(0)))* 32768
		val m2 = (( Id_array.get(2) - Id_array.get(1) ) / (Iq_array.get(2) - Iq_array.get(1)))* 32768
		val m3 = (( Id_array.get(3) - Id_array.get(2) ) / (Iq_array.get(3) - Iq_array.get(2)))* 32768
		val m4 = (( Id_array.get(4) - Id_array.get(3) ) / (Iq_array.get(4) - Iq_array.get(3)))* 32768
		val m5 = (( Id_array.get(5) - Id_array.get(4) ) / (Iq_array.get(5) - Iq_array.get(4)))* 32768
		val m6 = (( Id_array.get(6) - Id_array.get(5) ) / (Iq_array.get(6) - Iq_array.get(5)))* 32768
		val m7 = (( Id_array.get(7) - Id_array.get(6) ) / (Iq_array.get(7) - Iq_array.get(6)))* 32768
		
		val off1 = ( -(m1 * Iq_array.get(0)/32768) + Id_array.get(0)) 
		val off2 = ( -(m2 * Iq_array.get(1)/32768) + Id_array.get(1)) 
		val off3 = ( -(m3 * Iq_array.get(2)/32768) + Id_array.get(2)) 
		val off4 = ( -(m4 * Iq_array.get(3)/32768) + Id_array.get(3)) 
		val off5 = ( -(m5 * Iq_array.get(4)/32768) + Id_array.get(4)) 
		val off6 = ( -(m6 * Iq_array.get(5)/32768) + Id_array.get(5)) 
		val off7 = ( -(m7 * Iq_array.get(6)/32768) + Id_array.get(6)) */
		/*
		val m0 = 0		// debugging purpouse
		val m1 = 0
		val m2 = 0
		val m3 = 0
		val m4 = 0
		val m5 = 0
		val m6 = 0
		val m7 = 0
		
		
		val off1 = 0
		val off2 = 0
		val off3 = 0
		val off4 = 0
		val off5 = 0
		val off6 = 0
		val off7 = 0*/

		//ctrl + Space for dynamic variables insertion
    	'''
		/****************************************************************************
		*
		* Copyright (c) 2023 STMicroelectronics - All Rights Reserved
		*
		* License terms: STMicroelectronics Proprietary in accordance with licensing
		* terms SLA0098 at www.st.com.
		*
		* THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
		* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
		*
		*****************************************************************************/
		/*
		*   @file    Drive parameters.h
		*   @version 1.1.0
		*   @brief   This file contains motor parameters
		*          
		*   @details This file contains motor parameters.
		*
		*/
		
		/* Define to prevent recursive inclusion -------------------------------------*/
		#ifndef __DRIVE_PARAMETERS_H
		#define __DRIVE_PARAMETERS_H

		/******** MAIN AND AUXILIARY SPEED/POSITION SENSOR(S) SETTINGS SECTION ********/

	
		/*** Speed sensor selection ***/
	
		«IF( main_sel === SensorSelection_enum.OBSERVER_PLL)»
		#define STATE_OBSERVER_PLL 
		/* #define STATE_OBSERVER_CORDIC */
		/* #define HFINJECTION */
		/* #define ENCODER */
		/* #define HALL_SENSORS */
		/* #define RESOLVER */
		/* #define EXTERNAL_SENSOR */
		«ENDIF»
		«IF( main_sel=== SensorSelection_enum.OBSERVER_CORDIC)»
		/* #define STATE_OBSERVER_PLL */
		#define STATE_OBSERVER_CORDIC
		/* #define HFINJECTION */
		/* #define ENCODER */
		/* #define HALL_SENSORS */
		/* #define RESOLVER */
		/* #define EXTERNAL_SENSOR */
		«ENDIF»
		«IF( main_sel=== SensorSelection_enum.OBSERVER_HFI)»
		/* #define STATE_OBSERVER_PLL */
		/* #define STATE_OBSERVER_CORDIC */
		#define HFINJECTION
		/* #define ENCODER */
		/* #define HALL_SENSORS */
		/* #define RESOLVER */
		/* #define EXTERNAL_SENSOR */
		«ENDIF»
		«IF( main_sel=== SensorSelection_enum.QUADRATURE_ENCODER)»
		/* #define STATE_OBSERVER_PLL */
		/* #define STATE_OBSERVER_CORDIC */
		/* #define HFINJECTION */
		#define ENCODER
		/* #define HALL_SENSORS */
		/* #define RESOLVER */
		/* #define EXTERNAL_SENSOR */
		«ENDIF»
		«IF( main_sel=== SensorSelection_enum.HALL_SENSORS)»
		/* #define STATE_OBSERVER_PLL */
		/* #define STATE_OBSERVER_CORDIC */
		/* #define HFINJECTION */
		/* #define ENCODER */
		#define HALL_SENSORS
		/* #define RESOLVER */
		/* #define EXTERNAL_SENSOR */
		«ENDIF»
		«IF( main_sel=== SensorSelection_enum.RESOLVER)»
		/* #define STATE_OBSERVER_PLL */
		/* #define STATE_OBSERVER_CORDIC */
		/* #define HFINJECTION */
		/* #define ENCODER */
		/* #define HALL_SENSORS */
		#define RESOLVER 
		/* #define EXTERNAL_SENSOR */
		«ENDIF»
		«IF( main_sel=== SensorSelection_enum.EXTERNAL_SENSOR)»
		/* #define STATE_OBSERVER_PLL */
		/* #define STATE_OBSERVER_CORDIC */
		/* #define HFINJECTION */
		/* #define ENCODER */
		/* #define HALL_SENSORS */
		/* #define RESOLVER */
		#define EXTERNAL_SENSOR
		«ENDIF»

		/*** Auxiliary speed measurement selection ***/
		«IF( en_aux_sel)»
						«IF( aux_sel===SensorSelection_enum.RESOLVER)»
		#define AUX_RESOLVER
		/* #define AUX_STATE_OBSERVER_PLL */
		/* #define AUX_STATE_OBSERVER_CORDIC */
		/* #define AUX_HFINJECTION */
		/* #define AUX_ENCODER */
		/* #define AUX_HALL_SENSORS */
		/* #define AUX_EXTERNAL_SENSOR */
						«ENDIF»
						«IF( aux_sel===SensorSelection_enum.OBSERVER_PLL)»
		/* #define AUX_RESOLVER */ 
		#define AUX_STATE_OBSERVER_PLL
		/* #define AUX_STATE_OBSERVER_CORDIC */
		/* #define AUX_HFINJECTION */
		/* #define AUX_ENCODER */
		/* #define AUX_HALL_SENSORS */
		/* #define AUX_EXTERNAL_SENSOR */
						«ENDIF»
						«IF( aux_sel===SensorSelection_enum.OBSERVER_CORDIC)»
		/* #define AUX_RESOLVER */
		/* #define AUX_STATE_OBSERVER_PLL */
		#define AUX_STATE_OBSERVER_CORDIC
		/* #define AUX_HFINJECTION */
		/* #define AUX_ENCODER */
		/* #define AUX_HALL_SENSORS */
		/* #define AUX_EXTERNAL_SENSOR */
						«ENDIF»
						«IF( aux_sel===SensorSelection_enum.OBSERVER_HFI)»
		/* #define AUX_RESOLVER */
		/* #define AUX_STATE_OBSERVER_PLL */
		/* #define AUX_STATE_OBSERVER_CORDIC */
		#define AUX_HFINJECTION
		/* #define AUX_ENCODER */
		/* #define AUX_HALL_SENSORS */
		/* #define AUX_EXTERNAL_SENSOR */
						«ENDIF»
						«IF( aux_sel===SensorSelection_enum.QUADRATURE_ENCODER)»
		/* #define AUX_RESOLVER */
		/* #define AUX_STATE_OBSERVER_PLL */
		/* #define AUX_STATE_OBSERVER_CORDIC */
		/* #define AUX_HFINJECTION */
		#define AUX_ENCODER
		/* #define AUX_HALL_SENSORS */ 
		/* #define AUX_EXTERNAL_SENSOR */ 
						«ENDIF»
						«IF( aux_sel===SensorSelection_enum.HALL_SENSORS)»
		/* #define AUX_RESOLVER */
		/* #define AUX_STATE_OBSERVER_PLL */
		/* #define AUX_STATE_OBSERVER_CORDIC */
		/* #define AUX_HFINJECTION */
		/* #define AUX_ENCODER */
		#define AUX_HALL_SENSORS 
		/* #define AUX_EXTERNAL_SENSOR */ 
						«ENDIF»
						«IF( aux_sel===SensorSelection_enum.EXTERNAL_SENSOR)»
		/* #define AUX_RESOLVER */
		/* #define AUX_STATE_OBSERVER_PLL */
		/* #define AUX_STATE_OBSERVER_CORDIC */
		/* #define AUX_HFINJECTION */
		/* #define AUX_ENCODER */
		/* #define AUX_HALL_SENSORS */
		#define AUX_EXTERNAL_SENSOR
						«ENDIF»
		«ELSE»
		/* #define AUX_RESOLVER */
		/* #define AUX_STATE_OBSERVER_PLL */
		/* #define AUX_STATE_OBSERVER_CORDIC */
		/* #define AUX_HFINJECTION */
		/* #define AUX_ENCODER */
		/* #define AUX_HALL_SENSORS */
		/* #define AUX_EXTERNAL_SENSOR */
		«ENDIF»

		/*** Drives number selection ***/
		#define SINGLEDRIVE
		/* #define DUALDRIVE */
	

		/*** Speed measurement settings ***/

		«IF(speed_en)»
		#define USE_CHECK_MAX_SPEED
		«ENDIF»
		
		#define MAX_APPLICATION_SPEED_RPM       «Math.round(max_speed)» /*!< rpm, mechanical */
		#define MIN_APPLICATION_SPEED_RPM       0 /*!< rpm, mechanical,  
																absolute value */
		#define MEAS_ERRORS_BEFORE_FAULTS       «Math.round(err_max)» /*!< Number of speed  
																	measurement errors before 
																	main sensor goes in fault */

		« IF(en_aux_sel)»
			«IF( ((aux_sel===SensorSelection_enum.QUADRATURE_ENCODER)&&(main_sel===SensorSelection_enum.QUADRATURE_ENCODER)) ||
				((aux_sel===SensorSelection_enum.HALL_SENSORS)&&(main_sel===SensorSelection_enum.HALL_SENSORS))             ||
				((aux_sel===SensorSelection_enum.OBSERVER_PLL)&&(main_sel===SensorSelection_enum.OBSERVER_PLL))             ||
				((aux_sel===SensorSelection_enum.OBSERVER_CORDIC)&&(main_sel===SensorSelection_enum.OBSERVER_CORDIC))             ||
				((aux_sel===SensorSelection_enum.RESOLVER)&&(main_sel===SensorSelection_enum.RESOLVER))                      ||
				((aux_sel===SensorSelection_enum.EXTERNAL_SENSOR)&&(main_sel===SensorSelection_enum.EXTERNAL_SENSOR)))»
			/* Error created for managing these exceptions.The generation must fail */
			[#stop "When auxiliary sensor « aux_sel » is enabled cannot be the same sensor as the main « main_sel »"]
			«ENDIF»
		«ENDIF»
		«IF( ( (main_sel===SensorSelection_enum.OBSERVER_HFI) && (((en_aux_sel))||(aux_sel!=SensorSelection_enum.OBSERVER_PLL)) ))»
		/* Error created for managing these exceptions.The generation must fail */
		[#stop "When Main sensor is Observer+HFI the Auxiliary should be Observer+PLL, while it is disabled or set to a sensored one"]
		«ENDIF»
		«IF( main_sel===SensorSelection_enum.HALL_SENSORS)»
		/****** Hall sensors ************/
		#define HALL_MEAS_ERRORS_BEFORE_FAULTS  «Math.round(err_max) » /*!< Number of failed
                                                           derived class specific speed
                                                           measurements before main sensor
                                                           goes in fault */

		#define HALL_AVERAGING_FIFO_DEPTH        «Math.round(main_FIFO)» /*!< depth of the FIFO used to
                                                           average mechanical speed in
                                                           0.1Hz resolution */
		#define HALL_MTPA  						«mtpa_enable»	
		«ELSE»
		«IF( (aux_sel===SensorSelection_enum.HALL_SENSORS) && (en_aux_sel) )» 
		/****** Hall sensors ************/
		#define HALL_MEAS_ERRORS_BEFORE_FAULTS  «Math.round(err_max) » /*!< Number of failed
                                                           derived class specific speed
                                                           measurements before main sensor
                                                           goes in fault */

		#define HALL_AVERAGING_FIFO_DEPTH        «Math.round(aux_FIFO)» /*!< depth of the FIFO used to
                                                           average mechanical speed in
                                                           0.1Hz resolution */
		#define HALL_MTPA  						«mtpa_enable»	
		«ENDIF»
		«ENDIF»		
		«IF( main_sel===SensorSelection_enum.QUADRATURE_ENCODER)»
		/****** Encoder ************/
		/****** Quadrature Encoder is the main sensor ******/
		#define ENC_MEAS_ERRORS_BEFORE_FAULTS    «Math.round(err_max) » /*!< Number of failed   
																derived class specific speed 
																measurements before main sensor  
																goes in fault */
		«IF( main_rev)»
		#define ENC_INVERT_SPEED                ENABLE  /*!< To be enabled for  
																	encoder (main or aux) if  
																	measured speed is opposite 
																	to real one */
		«ELSE»
		#define ENC_INVERT_SPEED                DISABLE  /*!< To be enabled for  
																	encoder (main or aux) if  
																	measured speed is opposite 
																	to real one */
		«ENDIF»
		#define ENC_AVERAGING_FIFO_DEPTH        «Math.round(main_FIFO)» /*!< depth of the FIFO used to 
																	average mechanical speed in 
																	0.1Hz resolution */
		«ELSE»
		«IF( (aux_sel===SensorSelection_enum.QUADRATURE_ENCODER) && (en_aux_sel) )» 
		/****** Encoder ************/
		/****** Quadrature Encoder is the auxiliary sensor ******/
		#define ENC_MEAS_ERRORS_BEFORE_FAULTS    «Math.round(err_max)» /*!< Number of failed   
																derived class specific speed 
																measurements before main sensor  
																goes in fault */
							«IF( aux_rev)»
		#define ENC_INVERT_SPEED                ENABLE  /*!< To be enabled for  
																	encoder (main or aux) if  
																	measured speed is opposite 
																	to real one */
							«ELSE»
		#define ENC_INVERT_SPEED                DISABLE  /*!< To be enabled for  
																	encoder (main or aux) if  
																	measured speed is opposite 
																	to real one */
							«ENDIF»
		#define ENC_AVERAGING_FIFO_DEPTH        «Math.round(aux_FIFO)» /*!< depth of the FIFO used to 
																	average mechanical speed in 
																	0.1Hz resolution */		
		«ENDIF»
		«ENDIF»
		«IF( ((!qe) && (main_sel===SensorSelection_enum.QUADRATURE_ENCODER))|| ((!qe) && (aux_sel===SensorSelection_enum.QUADRATURE_ENCODER)))»
							«IF( main_sel===SensorSelection_enum.QUADRATURE_ENCODER)»
							/* Error created for managing these exceptions.The generation must fail */
							[#stop "Main speed Sensor is set to the Quadrature Encoder, but the motor doesn't support it"]
							«ENDIF»
							«IF( (aux_sel===SensorSelection_enum.QUADRATURE_ENCODER) && (en_aux_sel))»
							/* Error created for managing these exceptions.The generation must fail */
							[#stop "Auxiliary speed Sensor is set to the Quadrature Encoder, but the motor doesn't support it"]
							«ENDIF»
		«ENDIF»		
		«IF( ((!hs) && (main_sel===SensorSelection_enum.HALL_SENSORS))||((!hs) && (aux_sel===SensorSelection_enum.HALL_SENSORS)))»
							«IF( main_sel===SensorSelection_enum.HALL_SENSORS)»
							/* Error created for managing these exceptions.The generation must fail */
							[#stop "Main speed Sensor is set to the Hall Sensors, but the motor doesn't support it"]
							«ENDIF»
							«IF( (aux_sel===SensorSelection_enum.HALL_SENSORS) && (en_aux_sel))»
							/* Error created for managing these exceptions.The generation must fail */
							[#stop "Auxiliary speed Sensor is set to the Hall Sensors, but the motor doesn't support it"]
							«ENDIF»
		«ENDIF»	
		«IF( main_sel===SensorSelection_enum.RESOLVER)»
		/****** Resolver ************/

		/****** Resolver is the main sensor ******/
		#define EXCITING_FREQUENCY «Math.round(main_sig_freq)» /* Hz */
		#define EXCITING_AMPLITUDE_PERCENTAGE 100.0f    /* Exciting frequency in percentage (Max 3V) */
		#define RESOLVER_DELAY_TIM15_CCR1 «Math.round(main_shift)»U
		
		/* Resolver PLL invert direction */
		«IF(main_pll_invert_dir)»
		#define RESOLVER_INVERT_DIRECTION -1
		«ELSE»
		#define RESOLVER_INVERT_DIRECTION 1
		«ENDIF»
		/* Ratio between resolver frequency and rotor mechanical frequency  */       
		/* [Note: FW manages only case in which ( POLE_PAIR_NUM / RESOLVER_TO_MECHANICAL_RATIO ) >= 1] */
		#define RESOLVER_TO_MECHANICAL_RATIO  «main_res_mec_ratio»
		«IF( main_pll_manual_editing)»
		#define RESOLVER_PLL_KP_GAIN                «Math.round(main_res_KP_PLL)»
		#define RESOLVER_PLL_KP_DIVIDER				«main_res_KPDIV_PLL»
		#define RESOLVER_PLL_KI_GAIN                «Math.round(main_res_KI_PLL)»
		#define RESOLVER_PLL_KI_DIVIDER				«main_res_KIDIV_PLL»
		«ELSE»
		#define RESOLVER_PLL_KP_GAIN                «Math.round(((532*pole*max_speed*tfreg)/PWM_freq))»  
		#define RESOLVER_PLL_KP_DIVIDER				16384
		#define RESOLVER_PLL_KI_GAIN                «Math.round(((1506742*pole*max_speed)/(4*loc)))»  
		#define RESOLVER_PLL_KI_DIVIDER				16384
		«ENDIF»
		#define OLENDSPEEDRPM   100.0f
		#define OLSTARTDURATION 1.0f
		#define OLCURRENT       1.0f
		
		
		#define EXCITING_AMPLITUDE_S32    (int32_t)((EXCITING_AMPLITUDE_PERCENTAGE * 32768.0f) / 100.0f)
		#define RESOLVER_ANGLE_OFFSET_S16 ((RESOLVER_ANGLE_OFFSET_DEGREE * 32768.0f) / 180.0f)
		#define OLCURRENTS16              (int16_t)((OLCURRENT * 65536.0f * AMPLIFICATION_GAIN * RSHUNT) / ADC_REFERENCE_VOLTAGE)
		#define RESOLVER_MAX_SPEED_DPP    (int16_t)(((float)(MOTOR_MAX_SPEED_RPM*1.15f) * 65536.0f)/(60.0f*EXCITING_FREQUENCY))
		«ELSE»
		«IF( (aux_sel===SensorSelection_enum.RESOLVER) && (en_aux_sel))»
		/****** Resolver ************/

		/****** Resolver is the auxiliary sensor ******/

		#define EXCITING_FREQUENCY «Math.round(aux_sig_freq)» /* Hz */
		#define EXCITING_AMPLITUDE_PERCENTAGE 100.0f    /* Exciting frequency in percentage (Max 3V) */
		#define RESOLVER_DELAY_TIM15_CCR1 « Math.round(aux_shift)»U
		
		/* Resolver PLL invert direction */
		«IF(aux_pll_invert_dir)»
		#define RESOLVER_INVERT_DIRECTION -1
		«ELSE»
		#define RESOLVER_INVERT_DIRECTION 1
		«ENDIF»
		/* Ratio between resolver frequency and rotor mechanical frequency */
		/* [Note: FW manages only case in which ( POLE_PAIR_NUM / RESOLVER_TO_MECHANICAL_RATIO ) >= 1] */       
		#define RESOLVER_TO_MECHANICAL_RATIO  «aux_res_mec_ratio»

		«IF( aux_pll_manual_editing)»
		#define RESOLVER_PLL_KP_GAIN                    « Math.round(aux_res_KP_PLL)»
		#define RESOLVER_PLL_KP_DIVIDER					«aux_res_KPDIV_PLL»
		#define RESOLVER_PLL_KI_GAIN                    « Math.round(aux_res_KI_PLL)»
		#define RESOLVER_PLL_KI_DIVIDER					«aux_res_KIDIV_PLL»
		«ELSE»
		#define RESOLVER_PLL_KP_GAIN                    « Math.round(((532*pole*max_speed*tfreg)/PWM_freq))»
		#define RESOLVER_PLL_KP_DIVIDER					16384
		#define RESOLVER_PLL_KI_GAIN                    « Math.round(((1506742*pole*max_speed)/(4*loc)))»
		#define RESOLVER_PLL_KI_DIVIDER					16384
		«ENDIF»
		
		#define OLENDSPEEDRPM   100.0f
		#define OLSTARTDURATION 1.0f
		#define OLCURRENT       1.0f
		
		#define EXCITING_AMPLITUDE_S32    (int32_t)((EXCITING_AMPLITUDE_PERCENTAGE * 32768.0f) / 100.0f)
		#define RESOLVER_ANGLE_OFFSET_S16 ((RESOLVER_ANGLE_OFFSET_DEGREE * 32768.0f) / 180.0f)
		#define OLCURRENTS16              (int16_t)((OLCURRENT * 65536.0f * AMPLIFICATION_GAIN * RSHUNT) / ADC_REFERENCE_VOLTAGE)
		#define RESOLVER_MAX_SPEED_DPP    (int16_t)(((float)(MOTOR_MAX_SPEED_RPM*1.15f) * 65536.0f)/(60.0f*EXCITING_FREQUENCY))
		
		«ENDIF»
		«ENDIF»


		
		«IF( main_sel===SensorSelection_enum.EXTERNAL_SENSOR)»
		/****** External sensors ************/

		/****** External Sensor is the main sensor ******/
		#define EXT_MEAS_ERRORS_BEFORE_FAULTS  « Math.round(err_max)» /*!< Number of failed   
																derived class specific speed 
																measurements before main sensor  
																goes in fault */
		«ELSE»
		«IF( (aux_sel===SensorSelection_enum.EXTERNAL_SENSOR) && (en_aux_sel))»
		/****** External sensors ************/

		/****** External Sensor is the auxiliary sensor ******/
		#define EXT_MEAS_ERRORS_BEFORE_FAULTS  « Math.round(err_max)» /*!< Number of failed   
																derived class specific speed 
																measurements before main sensor  
																goes in fault */		
		«ENDIF»
		«ENDIF»
		«IF( ((!ext) && (main_sel===SensorSelection_enum.EXTERNAL_SENSOR))||((!ext) && (aux_sel===SensorSelection_enum.EXTERNAL_SENSOR)))»
							«IF( main_sel===SensorSelection_enum.EXTERNAL_SENSOR)»
							/* Error created for managing these exceptions.The generation must fail */
							[#stop "Main speed Sensor is set to the External Sensor, but the motor doesn't support it"]
							«ENDIF»
							«IF( (aux_sel===SensorSelection_enum.EXTERNAL_SENSOR) && (en_aux_sel))»
							/* Error created for managing these exceptions.The generation must fail */
							[#stop "Auxiliary speed Sensor is set to the External Sensor, but the motor doesn't support it"]
							«ENDIF»
		«ENDIF»

	
		«IF( main_sel===SensorSelection_enum.OBSERVER_PLL)»
		/****** State Observer + PLL ************/

		/****** State Observer + PLL is the main sensor ******/
		«IF( main_depth_loop < main_depth_obs)»
		[#stop " In main sensor Observer+PLL Average speed depth for speed loop is lower than Average speed depth for speed Observer equations"]
		«ENDIF»
		#define VARIANCE_THRESHOLD               «main_var» /*!<Maximum accepted 
																	variance on speed 
																	estimates (percentage) */
								«IF( main_manual)»
		/* State observer scaling factors */
		#define F1                               «main_F1»
		#define F2                               «main_F2»
		#define F1_LOG                           LOG2(«aux_F1»)
		#define F2_LOG                           LOG2(«aux_F2»)

		/* State observer constants */
		#define GAIN1                            « Math.round(main_G1)»
		#define GAIN2                            « Math.round(main_G2)»
								«ELSE»
		/* State observer scaling factors */
		#define F1                               «f1»
		#define F2                               «f2»
		#define F1_LOG                           LOG2(«f1»)
		#define F2_LOG                           LOG2(«f2»)
		
		/* State observer constants */
		#define GAIN1                            « Math.round(g1)»
		#define GAIN2                            « Math.round(g2)»
								«ENDIF»
		/*Only in case PLL is used, PLL gains */
							«IF( main_manual)»
		#define PLL_KP_GAIN                      « Math.round(main_KP_PLL)»
		#define PLL_KPDIV     					« main_KP_PLL_div »
		#define PLL_KPDIV_LOG 					LOG2(PLL_KPDIV)
		#define PLL_KI_GAIN                      « Math.round(main_KI_PLL)»
		#define PLL_KIDIV     					« main_KI_PLL_div »
		#define PLL_KIDIV_LOG 					LOG2(PLL_KIDIV)
							«ELSE»
		#define PLL_KP_GAIN                      « Math.round(((532*pole*max_speed*tfreg)/PWM_freq))»
		#define PLL_KPDIV     					16384
		#define PLL_KPDIV_LOG 					LOG2(PLL_KPDIV)        
		#define PLL_KI_GAIN                      « Math.round(((1506742*pole*max_speed)/(4*loc)))»
		#define PLL_KIDIV     					65535
		#define PLL_KIDIV_LOG 					LOG2(PLL_KIDIV)        
							«ENDIF»

		#define OBS_MEAS_ERRORS_BEFORE_FAULTS    « Math.round(err_max)»  /*!< Number of consecutive errors   
																on variance test before a speed 
																feedback error is reported */
		#define STO_FIFO_DEPTH_DPP               « Math.round(main_depth_obs)»  /*!< Depth of the FIFO used  
																	to average mechanical speed  
																	in dpp format */
		#define STO_FIFO_DEPTH_DPP_LOG           LOG2(STO_FIFO_DEPTH_DPP)

		#define STO_FIFO_DEPTH_01HZ              « Math.round(main_depth_loop)»  /*!< Depth of the FIFO used  
																	to average mechanical speed  
																	in dpp format */
		#define STO_FIFO_DEPTH_UNIT              STO_FIFO_DEPTH_01HZ
		#define BEMF_CONSISTENCY_TOL             « Math.round(((main_emf_tol*64)/100))»   /* Parameter for B-emf 
																	amplitude-speed consistency */
		#define BEMF_CONSISTENCY_GAIN            « Math.round(((main_emf_gain*64)/100))»   /* Parameter for B-emf 
																amplitude-speed consistency */
		«ELSE»
		«IF( (aux_sel===SensorSelection_enum.OBSERVER_PLL) && (en_aux_sel))» 
		/****** State Observer + PLL ************/

		/****** State Observer + PLL is the auxiliary sensor ******/
		«IF( aux_depth_loop < aux_depth_obs)»
		[#stop " In auxiliary sensor Observer+PLL Average speed depth for speed loop is lower than Average speed depth for speed Observer equations"]
		«ENDIF»
		#define VARIANCE_THRESHOLD               «aux_var» /*!<Maximum accepted 
																	variance on speed 
																	estimates (percentage) */
		«IF( aux_manual)»
		/* State observer scaling factors */
		#define F1                               «aux_F1»
		#define F2                               «aux_F2»
		#define F1_LOG                           LOG2(«aux_F1»)
		#define F2_LOG                           LOG2(«aux_F2»)

		/* State observer constants */
		#define GAIN1                            «  Math.round(aux_G1)»
		#define GAIN2                            «  Math.round(aux_G2)»
		«ELSE»
		/* State observer scaling factors */
		#define F1                               «f1»
		#define F2                               «f2»
		#define F1_LOG                           LOG2(«f1»)
		#define F2_LOG                           LOG2(«f2»)

		/* State observer constants */
		#define GAIN1                            «  Math.round(g1)»
		#define GAIN2                            «  Math.round(g2)»
		«ENDIF»
		/* Only in case PLL is used, PLL gains */
		«IF( aux_manual)»
		#define PLL_KP_GAIN                      «  Math.round(aux_KP_PLL)»
		#define PLL_KPDIV     					« aux_KP_PLL_div »
		#define PLL_KPDIV_LOG 					LOG2(PLL_KPDIV)
		#define PLL_KI_GAIN                      «  Math.round(aux_KI_PLL)»
		#define PLL_KIDIV     					« aux_KI_PLL_div »
		#define PLL_KIDIV_LOG 					LOG2(PLL_KIDIV)
		«ELSE»
		#define PLL_KP_GAIN                      «  Math.round(((532*pole*max_speed*tfreg)/PWM_freq))»
		#define PLL_KPDIV     					16384
		#define PLL_KPDIV_LOG 					LOG2(PLL_KPDIV)
		#define PLL_KI_GAIN                      «  Math.round(((1506742*pole*max_speed)/(4*loc)))»
		#define PLL_KIDIV     					65535
		#define PLL_KIDIV_LOG 					LOG2(PLL_KIDIV)
		«ENDIF»

		#define OBS_MEAS_ERRORS_BEFORE_FAULTS    «  Math.round(err_max)»  /*!< Number of consecutive errors   
																on variance test before a speed 
																feedback error is reported */
		#define STO_FIFO_DEPTH_DPP               «  Math.round(aux_depth_obs)»  /*!< Depth of the FIFO used  
																	to average mechanical speed  
																	in dpp format */
        #define STO_FIFO_DEPTH_DPP_LOG           LOG2(STO_FIFO_DEPTH_DPP)
		
		#define STO_FIFO_DEPTH_01HZ              «  Math.round(aux_depth_loop)»  /*!< Depth of the FIFO used  
																	to average mechanical speed  
																	in dpp format */
		#define STO_FIFO_DEPTH_UNIT              STO_FIFO_DEPTH_01HZ
		#define BEMF_CONSISTENCY_TOL             «  Math.round(((aux_emf_tol*64)/100))»   /* Parameter for B-emf 
																	amplitude-speed consistency */
		#define BEMF_CONSISTENCY_GAIN            «  Math.round(((aux_emf_gain*64)/100))»   /* Parameter for B-emf 
																amplitude-speed consistency */
		
		«ENDIF»
		«ENDIF»

		
	
		«IF( main_sel===SensorSelection_enum.OBSERVER_CORDIC)»
		/****** State Observer + Cordic ************/	

		/****** State Observer + Cordic is the main sensor ******/
		«IF( main_depth_loop < main_depth_obs)»
		[#stop " In main sensor Observer+Cordic Average speed depth for speed loop is lower than Average speed depth for speed Observer equations"]
		«ENDIF»
		#define CORD_VARIANCE_THRESHOLD          «main_var»  /*!<Maxiumum accepted 
																	variance on speed 
																	estimates (percentage) */
							«IF( main_manual)»
		#define CORD_F1                          «main_F1»
		#define CORD_F2                          «main_F2»

		/* State observer constants */
		#define CORD_GAIN1                       « Math.round(main_G1)»
		#define CORD_GAIN2                       « Math.round(main_G2)»
							«ELSE»
		#define CORD_F1                          «f1»
		#define CORD_F2                          «f2»

		/* State observer constants */
		#define CORD_GAIN1                       « Math.round(g1)»
		#define CORD_GAIN2                       « Math.round(g2)»
							«ENDIF»

		#define CORD_MEAS_ERRORS_BEFORE_FAULTS   « Math.round(err_max)»  /*!< Number of consecutive errors   
																on variance test before a speed 
																feedback error is reported */
		#define CORD_FIFO_DEPTH_DPP              « Math.round(main_depth_obs)»  /*!< Depth of the FIFO used  
																	to average mechanical speed  
																	in dpp format */
		#define CORD_FIFO_DEPTH_01HZ             « Math.round(main_depth_loop)»  /*!< Depth of the FIFO used  
																to average mechanical speed  
																in dpp format */        
		#define CORD_MAX_ACCEL_DPPP              « Math.round(main_max_acc)»  /*!< Maximum instantaneous 
																	electrical acceleration (dpp 
																	per control period) */
		#define CORD_BEMF_CONSISTENCY_TOL        « Math.round(((main_emf_tol*64)/100))»  /* Parameter for B-emf 
																amplitude-speed consistency */
		#define CORD_BEMF_CONSISTENCY_GAIN       « Math.round(((main_emf_gain*64)/100))»  /* Parameter for B-emf 
																amplitude-speed consistency */
		«ELSE»
		«IF( (aux_sel===SensorSelection_enum.OBSERVER_CORDIC) && (en_aux_sel) )»
		/****** State Observer + Cordic is the auxiliary sensor ******/
		«IF( aux_depth_loop < aux_depth_obs) »
		[#stop " In auxiliary sensor Observer+Cordic Average speed depth for speed loop is lower than Average speed depth for speed Observer equations"]
		«ENDIF»
		#define CORD_VARIANCE_THRESHOLD          «aux_var»  /*!<Maxiumum accepted 
																	variance on speed 
																	estimates (percentage) */
							«IF( aux_manual)»
		#define CORD_F1                          «aux_F1»
		#define CORD_F2                          «aux_F2»

		/* State observer constants */
		#define CORD_GAIN1                       « Math.round(aux_G1)»
		#define CORD_GAIN2                       « Math.round(aux_G2)»
							«ELSE»
		#define CORD_F1                          «f1»
		#define CORD_F2                          «f2»

		/* State observer constants */
		#define CORD_GAIN1                       « Math.round(g1)»
		#define CORD_GAIN2                       « Math.round(g2)»
							«ENDIF»

		#define CORD_MEAS_ERRORS_BEFORE_FAULTS   « Math.round(err_max)»  /*!< Number of consecutive errors   
																on variance test before a speed 
																feedback error is reported */
		#define CORD_FIFO_DEPTH_DPP              « Math.round(aux_depth_obs)»  /*!< Depth of the FIFO used  
																	to average mechanical speed  
																	in dpp format */
		#define CORD_FIFO_DEPTH_01HZ             « Math.round(aux_depth_loop)»  /*!< Depth of the FIFO used  
																to average mechanical speed  
																in dpp format */        
		#define CORD_MAX_ACCEL_DPPP              « Math.round(aux_max_acc)»  /*!< Maximum instantaneous 
																	electrical acceleration (dpp 
																	per control period) */
		#define CORD_BEMF_CONSISTENCY_TOL        « Math.round(((aux_emf_tol*64)/100))»  /* Parameter for B-emf 
																amplitude-speed consistency */
		#define CORD_BEMF_CONSISTENCY_GAIN       « Math.round(((aux_emf_gain*64)/100))»  /* Parameter for B-emf 
																amplitude-speed consistency */
		«ENDIF»
		«ENDIF»

		«IF( main_sel===SensorSelection_enum.OBSERVER_HFI)»
		/****** State Observer + HFI ************/

		/****** State Observer + HFI is the main sensor ******/
		«IF( (magnetic=="Surface Mounted PMSM") )»
		/*Error created for managing these exceptions.The generation must fail*/
		[#stop "Main speed sensor is set to the Sensor-less (Observer+HFI), but the motor magnetic structure isn't set to Internal PMSM"]
		«ENDIF»
		«IF( (hfi_freq>( Math.round(max_hfi_freq))))»
		/*Error created for managing these exceptions.The generation must fail*/
		[#stop "Inserted value «hfi_freq» exeeds max HFI Frequency allowed « Math.round(max_hfi_freq)»"]
		«ENDIF»
		
		«IF( (scan_freq>( Math.round(max_scan_freq))))»
		/*Error created for managing these exceptions.The generation must fail*/
		[#stop "Inserted value «scan_freq» exeeds max Scan Frequency allowed «  Math.round(max_scan_freq)»"]
		«ENDIF»
		«IF( main_depth_loop < main_depth_obs)»
		[#stop " In main sensor Observer+HFI Average speed depth for speed loop is lower than Average speed depth for speed Observer equations"]
		«ENDIF»
		
		#define HFI_FREQUENCY                    « Math.round(hfi_freq)»   /* Frequency of the HFI voltage signal */
		#define HFI_AMPLITUDE                    « Math.round(amplitude)»   /* Amplitude of the HFI voltage signal */

		#define HFI_PID_KP_DEFAULT               « Math.round(kp)»   /* KP gains of the PI that tracks */
		#define HFI_PID_KI_DEFAULT               « Math.round(ki)»   /* KI gains of the PI that tracks*/
		#define HFI_PID_KPDIV                    « kp_div»   /* KP divisor of the PI that tracks */
		#define HFI_PID_KIDIV                    « ki_div»   /* KI divisor of the PI that tracks */

		#define HFI_IDH_DELAY                    32400

		#define HFI_PLL_KP_DEFAULT               «pll_kp» /* KP gain of the PLL that synchs */
		#define HFI_PLL_KI_DEFAULT               «pll_ki» /* KI gain of the PLL that synchs */
	
		#define HFI_NOTCH_0_COEFF                «a0_for_notch»
		#define HFI_NOTCH_1_COEFF                «a1_for_notch»
		#define HFI_NOTCH_2_COEFF                «a0_for_notch»
		#define HFI_NOTCH_3_COEFF                «b1_for_notch»
		#define HFI_NOTCH_4_COEFF                «b2_for_notch»
		
		#define HFI_LP_0_COEFF                   «a0_for_lp»
		#define HFI_LP_1_COEFF                   «a1_for_lp»
		#define HFI_LP_2_COEFF                   «a0_for_lp»
		#define HFI_LP_3_COEFF                   «b1_for_lp»
		#define HFI_LP_4_COEFF                   «b2_for_lp»

		#define HFI_HP_0_COEFF                   «a0_for_hp»
		#define HFI_HP_1_COEFF                   «a1_for_hp»
		#define HFI_HP_2_COEFF                   «a0_for_hp»
		#define HFI_HP_3_COEFF                   «b1_for_hp»
		#define HFI_HP_4_COEFF                   «b2_for_hp»
    
		#define HFI_DC_0_COEFF                   «a0_for_dc»
		#define HFI_DC_1_COEFF                   «a1_for_dc»
		#define HFI_DC_2_COEFF                   «a0_for_dc»
		#define HFI_DC_3_COEFF                   «b1_for_dc»
		#define HFI_DC_4_COEFF                   «b2_for_dc»

		#define HFI_MINIMUM_SPEED_RPM            « Math.round(min_reliable_speed)»   /* Speed below which the PLL (linked to STO) is reset */
		#define HFI_SPD_BUFFER_DEPTH_01HZ        STO_FIFO_DEPTH_01HZ
		#define HFI_LOCKFREQ                     « Math.round(lock_freq_dpp)»   /* Rotation freq of the initial scan, expressed in dpp */
		#define HFI_SCANROTATIONSNO              « Math.round(rotation_no)»   /* Number of electrical revolutions of the rotating stator field */
		#define HFI_WAITBEFORESN                 « Math.round(wait_before)»   /* Measured initial decay time of the signal [HFI freq/2]  */
		#define HFI_WAITAFTERNS                  « Math.round(wait_after)»   /* Measured final decay time of the signal [HFI freq / 2] */
		#define HFI_HIFRAMPLSCAN                 «amplitude+amplitude_boost»   /* High frequency signal amplification during scan */
		#define HFI_NSMAXDETPOINTS               « Math.round(pulse_number)»   /* Total duration of the NS detection stage [HFI freq/2] */
		#define HFI_NSDETPOINTSSKIP              « Math.round(pulses_skipped)»   /* Duration of the transitory in NS detection [HFI freq/2] */
		«IF( debug_mode)»
		#define HFI_DEBUG_MODE                  (TRUE)   /* Enables the HFI incremental system build */
		«ELSE»
		#define HFI_DEBUG_MODE                  (FALSE)   /* Enables the HFI incremental system build */
		«ENDIF»
		#define HFI_STO_RPM_TH                   OBS_MINIMUM_SPEED_RPM   /* threshold to validate STO -HFI switch */
		#define STO_HFI_RPM_TH                   « Math.round(sto_hfi_th)»   /* threshold to validate HFI-STO switch */
		#define HFI_RESTART_RPM_TH               (((HFI_STO_RPM_TH) + (STO_HFI_RPM_TH))/2)
		#define HFI_NS_MIN_SAT_DIFF              «min_sat_diff»   /* Typical measured saturation difference */
		«IF( revert_direction)»
		#define HFI_REVERT_DIRECTION            (TRUE)   /* Revert Direction */
		«ELSE»
		#define HFI_REVERT_DIRECTION            (FALSE)   /* Revert Direction */
		«ENDIF»
		#define HFI_WAITTRACK                    20
		#define HFI_WAITSYNCH                    20
		#define HFI_STEPANGLE                    3640
		#define HFI_MAXANGLEDIFF                 3640
		#define HFI_RESTARTTIMESEC               0.1
		«ENDIF»
		/* USER CODE BEGIN angle reconstruction M1 */
		#define PARK_ANGLE_COMPENSATION_FACTOR 0
		#define REV_PARK_ANGLE_COMPENSATION_FACTOR 0
		/* USER CODE END angle reconstruction M1 */
		
		/**************************    DRIVE SETTINGS SECTION   **********************/
	
		/* PWM generation and current reading */
		#define PWM_FREQUENCY                    « Math.round(PWM_freq)»
		#define PWM_FREQ_SCALING                 « Math.round(PWM_freq_scaling)»
		«IF( hs_complemented === Complementedfromhighside_enum.ENABLE)»
		«IF( hs_signal === DriverEnablingSignal_enum.ENABLE)»
		#define LOW_SIDE_SIGNALS_ENABLING        ES_GPIO		
		«ELSE»
		#define LOW_SIDE_SIGNALS_ENABLING        LS_DISABLED
		«ENDIF»
		#define SW_DEADTIME_NS                   (0x0U)  
		«ELSE»
		#define LOW_SIDE_SIGNALS_ENABLING        LS_PWM_TIMER
		#define SW_DEADTIME_NS                   « Math.round(SW_dead_time)» /*!< Dead-time to be inserted  
																by FW, only if low side 
																signals are enabled */
		«ENDIF»
																								
		/* Torque and flux regulation loops */
		#define REGULATION_EXECUTION_RATE     « Math.round(tfreg)»    /*!< FOC execution rate in 
																number of PWM cycles */  
		/* Gains values for torque and flux control loops */
		#define PID_TORQUE_KP_DEFAULT         « Math.round(T_KP)»       
		#define PID_TORQUE_KI_DEFAULT         « Math.round(T_KI)»
		#define PID_TORQUE_KD_DEFAULT         100
		#define PID_FLUX_KP_DEFAULT           « Math.round(F_KP)»
		#define PID_FLUX_KI_DEFAULT           « Math.round(F_KI)»
		#define PID_FLUX_KD_DEFAULT           100

		/* Torque/Flux control loop gains dividers*/
		#define TF_KPDIV                      « Math.round(T_KPDIV)»
		#define TF_KIDIV                      « Math.round(T_KIDIV)»
		#define TF_KDDIV                      8192 /*HARDWIRED*/
		#define TF_KPDIV_LOG                  LOG2(TF_KPDIV)
		#define TF_KIDIV_LOG                  LOG2(TF_KIDIV)
		#define TF_KDDIV_LOG                  LOG2(TF_KDDIV)

		
		#define TFDIFFERENTIAL_TERM_ENABLING  DISABLE

		/* Speed control loop */ 
		#define SPEED_LOOP_FREQUENCY_HZ       « Math.round(exec_rate)» /*!<Execution rate of speed   
															regulation loop (Hz) */
		#define PID_SPEED_KP_DEFAULT          « Math.round(SP_KP)»/(SPEED_UNIT/10)
		#define PID_SPEED_KI_DEFAULT          « Math.round(SP_KI)»/(SPEED_UNIT/10)
		#define PID_SPEED_KD_DEFAULT          0/(SPEED_UNIT/10)	/*HARDWIRED*/

		/* Speed PID parameter dividers */
		#define SP_KPDIV                      « Math.round(SP_KPDIV)»
		#define SP_KIDIV                      « Math.round(SP_KIDIV)»
		#define SP_KDDIV                      16
		#define SP_KPDIV_LOG                  LOG2(SP_KPDIV)
		#define SP_KIDIV_LOG                  LOG2(SP_KIDIV)
		#define SP_KDDIV_LOG                  LOG2(SP_KDDIV)

		/* USER CODE BEGIN PID_SPEED_INTEGRAL_INIT_DIV */
		#define PID_SPEED_INTEGRAL_INIT_DIV 1 /*  */
		/* USER CODE END PID_SPEED_INTEGRAL_INIT_DIV */


		#define SPD_DIFFERENTIAL_TERM_ENABLING DISABLE

		/* Default settings */
	
		«IF( cnt_mode===Controlmode_enum.SPEED_CONTROL)»
		#define DEFAULT_CONTROL_MODE           STC_SPEED_MODE  /*!< STC_TORQUE_MODE or 
																	STC_SPEED_MODE */  
		«ELSE»
		#define DEFAULT_CONTROL_MODE           STC_TORQUE_MODE /*!< STC_TORQUE_MODE or 
																	STC_SPEED_MODE */  
		«IF( (torque_curr>In))» 
		[#stop "Target stator current torque component higher than motor nominal current! Please set Torque component «torque_curr» less than Nominal Current «In»"]
		«ENDIF»
		«IF( (flux_curr>In))» 
		[#stop "Target stator current  flux  component higher than motor nominal current! Please set  Flux  component [ «flux_curr» ] less than Nominal Current «In»"]
		«ENDIF»
		«ENDIF»                                                         
		#define DEFAULT_TARGET_SPEED_RPM       « Math.round(speed)»
		#define DEFAULT_TARGET_SPEED_UNIT      (DEFAULT_TARGET_SPEED_RPM*SPEED_UNIT/_RPM)
		#define DEFAULT_TORQUE_COMPONENT       «Math.floor(torque_curr_digit) »
		#define DEFAULT_FLUX_COMPONENT         «Math.floor(flux_curr_digit)»

		/**************************    FIRMWARE PROTECTIONS SECTION   *****************/


		«IF( !vbus_voltage_reading)»
		#define OV_VOLTAGE_PROT_ENABLING        DISABLE /*!< Over voltage protection disabled */
		#define UV_VOLTAGE_PROT_ENABLING        DISABLE /*!< Under voltage protection disabled */
		«ELSE»
		#define OV_VOLTAGE_PROT_ENABLING        ENABLE /*!< Over voltage protection enabled */
		#define UV_VOLTAGE_PROT_ENABLING        ENABLE /*!< Under voltage protection enabled */
		«ENDIF»
		#define OV_VOLTAGE_THRESHOLD_V          (« Math.round(vbus_over_voltage_threshold)»U) /*!< Over-voltage threshold */
		#define UD_VOLTAGE_THRESHOLD_V          (« Math.round(vbus_under_voltage_threshold)»U) /*!< Under-voltage threshold */

		#define ON_OVER_VOLTAGE                 TURN_OFF_PWM /*!< TURN_OFF_PWM, 
																TURN_ON_R_BRAKE or 
																TURN_ON_LOW_SIDES */
		#define R_BRAKE_SWITCH_OFF_THRES_V      10
    
		«IF( !enable_hw_prot)»
		#define OV_TEMPERATURE_PROT_ENABLING    DISABLE
		«ELSE»
		#define OV_TEMPERATURE_PROT_ENABLING    ENABLE
		«ENDIF»
		«IF( use_max_working_temp)»
		#define OV_TEMPERATURE_THRESHOLD_C      (« Math.round(max_temp_on_sensor)»U) /*!< Celsius degrees */
		«ELSE»
		#define OV_TEMPERATURE_THRESHOLD_C      (« Math.round(over_temp_threshold)»U) /*!< Celsius degrees */
		«ENDIF»
		#define OV_TEMPERATURE_HYSTERESIS_C     (« Math.round(temp_hysteresis)»U)  /*!< Celsius degrees */

		#define HW_OV_CURRENT_PROT_BYPASS       DISABLE /*!<In case ON_OVER_VOLTAGE  
															is set to TURN_ON_LOW_SIDES
															this feature may be used to
															bypass HW over-current
															protection (if supported by 
															power stage) */
		/******************************   START-UP PARAMETERS   **********************/
	
		/* Encoder alignment */
		#define ALIGNMENT_DURATION              « Math.round(dur)»    /*!< milliseconds */
		#define ALIGNMENT_ANGLE_DEG             « Math.round(align)»      /*!< degrees [0...359] */
		#define FINAL_I_ALIGNMENT               «Math.floor(final_curr_ramp)»    /*!< s16A */
		/* With ALIGNMENT_ANGLE_DEG equal to 90 degrees final alignment */
		/* phase current = (FINAL_I_ALIGNMENT * 1.65/ Av)/(32767 * Rshunt) */
		/* being Av the voltage gain between Rshunt and A/D input */
    
		«IF( !adv)»
		/* Sensor-less rev-up sequence (BASIC)*/
		/* Phase 1 */
		«IF( !align_en)»
		#define STARTING_ANGLE_DEG             0 /*!< degrees [0...359] */
		#define PHASE1_DURATION                0 /*milliseconds */
		#define PHASE1_FINAL_SPEED_UNIT        (0*SPEED_UNIT/_RPM)/* rpm */
		#define PHASE1_FINAL_CURRENT           0
		«ELSE»
		#define STARTING_ANGLE_DEG             «align_angle»  /*!< degrees [0...359] */
		#define PHASE1_DURATION                0 /*milliseconds */
		#define PHASE1_FINAL_SPEED_UNIT        (0*SPEED_UNIT/_RPM) /* rpm */
		#define PHASE1_FINAL_CURRENT           «Math.floor(ph1_final_curr)»    /*!< s16A */
		«ENDIF»                                                         
		/* Phase 2 */
		#define PHASE2_DURATION                «align_duration» /*milliseconds */
		#define PHASE2_FINAL_SPEED_UNIT        0 /* rpm */
		#define PHASE2_FINAL_CURRENT           «Math.floor(ph2_final_curr)»    /*!< s16A */
		/* Phase 3 */
		#define PHASE3_DURATION                «ph3_duration_val» /*milliseconds */
		#define PHASE3_FINAL_SPEED_UNIT        (« Math.round(ph3_final_speed)»*SPEED_UNIT/_RPM)/* rpm */
		#define PHASE3_FINAL_CURRENT           «Math.floor(ph3_final_curr)»    /*!< s16A */
		/* Phase 4 */
		#define PHASE4_DURATION                «ph4_final_duration» /*milliseconds */
		#define PHASE4_FINAL_SPEED_UNIT        (« Math.round(speed_fin_val)»*SPEED_UNIT/_RPM) /* rpm */
		#define PHASE4_FINAL_CURRENT           «Math.floor(ph3_final_curr)»    /*!< s16A */
		/* Phase 5 */
		#define PHASE5_DURATION                0 /* milliseconds */
		#define PHASE5_FINAL_SPEED_UNIT        (« Math.round(speed_fin_val)»*SPEED_UNIT/_RPM) /* rpm */
		#define PHASE5_FINAL_CURRENT           «Math.floor(ph3_final_curr)»    /*!< s16A */

		#define ENABLE_SL_ALGO_FROM_PHASE      3
		«ELSE»
		/* Sensor-less rev-up sequence (ADV)*/
		#define STARTING_ANGLE_DEG             «adv_align_angle»  /*!< degrees [0...359] */
		/* Phase 1 */
		#define PHASE1_DURATION                «ph1_duration» /*milliseconds */
		#define PHASE1_FINAL_SPEED_UNIT        (« Math.round(ph1_fin_speed)»*SPEED_UNIT/_RPM) /* rpm */
		#define PHASE1_FINAL_CURRENT           «Math.floor(ph1_fin_curr)»    /*!< s16A */
		/* Phase 2 */
		#define PHASE2_DURATION                «ph2_duration» /*milliseconds */
		#define PHASE2_FINAL_SPEED_UNIT        (« Math.round(ph2_fin_speed)»*SPEED_UNIT/_RPM) /* rpm */
		#define PHASE2_FINAL_CURRENT           «Math.floor(ph2_fin_curr)»    /*!< s16A */
		/* Phase 3 */
		#define PHASE3_DURATION                «ph3_duration» /*milliseconds */
		#define PHASE3_FINAL_SPEED_UNIT        (« Math.round(ph3_fin_speed)»*SPEED_UNIT/_RPM)/* rpm */
		#define PHASE3_FINAL_CURRENT           «Math.floor(ph3_fin_curr)»    /*!< s16A */
		/* Phase 4 */
		#define PHASE4_DURATION                «ph4_duration» /*milliseconds */
		#define PHASE4_FINAL_SPEED_UNIT        (« Math.round(ph4_fin_speed)»*SPEED_UNIT/_RPM) /* rpm */
		#define PHASE4_FINAL_CURRENT           «Math.floor(ph4_fin_curr)»    /*!< s16A */
		/* Phase 5 */
		#define PHASE5_DURATION                «ph5_duration» /*milliseconds */
		#define PHASE5_FINAL_SPEED_UNIT        (« Math.round(ph5_fin_speed)»*SPEED_UNIT/_RPM)/* rpm */
		#define PHASE5_FINAL_CURRENT           «Math.floor(ph5_fin_curr)»    /*!< s16A */

		#define ENABLE_SL_ALGO_FROM_PHASE      «exec»
		«ENDIF»

		/* Observer start-up output conditions */
		«IF( main_sel===SensorSelection_enum.OBSERVER_HFI)»
		#define OBS_MINIMUM_SPEED_RPM          « Math.round(hfi_sto_th)»
		#define NB_CONSECUTIVE_TESTS           « Math.round(hfi_cons_startup)» /* corresponding to 
																former NB_CONSECUTIVE_TESTS/
																(TF_REGULATION_RATE/
																MEDIUM_FREQUENCY_TASK_RATE) */
		#define SPEED_BAND_UPPER_LIMIT         « Math.round(hfi_upper_limit)» /*!< It expresses how much 
																	estimated speed can exceed 
																	forced stator electrical 
																	without being considered wrong. 
																	In 1/16 of forced speed */
		#define SPEED_BAND_LOWER_LIMIT         « Math.round(hfi_lower_limit)»  /*!< It expresses how much 
																	estimated speed can be below 
																	forced stator electrical 
																	without being considered wrong. 
																	In 1/16 of forced speed */

		«ELSE»
		#define OBS_MINIMUM_SPEED_RPM          « Math.round(min_startup)»
		#define NB_CONSECUTIVE_TESTS           « Math.round(cons_startup)» /* corresponding to 
																former NB_CONSECUTIVE_TESTS/
																(TF_REGULATION_RATE/
																MEDIUM_FREQUENCY_TASK_RATE) */
		#define SPEED_BAND_UPPER_LIMIT         « Math.round(upper_limit)» /*!< It expresses how much 
																	estimated speed can exceed 
																	forced stator electrical 
																	without being considered wrong. 
																	In 1/16 of forced speed */
		#define SPEED_BAND_LOWER_LIMIT         « Math.round(lower_limit)»  /*!< It expresses how much 
																	estimated speed can be below 
																	forced stator electrical 
																	without being considered wrong. 
																	In 1/16 of forced speed */
		«ENDIF»
		«IF( !en_switch_over)»
		#define TRANSITION_DURATION            0  /* Switch over duration, ms */
		«ELSE»
		#define TRANSITION_DURATION            «duration_switch_over»  /* Switch over duration, ms */
		«ENDIF»
		/******************************   ADDITIONAL FEATURES   **********************/

		/******************************   Bus VOLTAGE Motor 1  **********************/
		«IF( !vbus_voltage_reading)»

		«ELSE»
		#define  M1_VBUS_SAMPLING_TIME  LL_ADC_SAMPLING_CYCLE(47)	/* HARDWIRED */
		«ENDIF»

		/******************************   Temperature sensing Motor 1  **********************/
		«IF( !temperature_reading)»

		«ELSE»
		#define  M1_TEMP_SAMPLING_TIME  LL_ADC_SAMPLING_CYCLE(47)  /* HARDWIRED */
		«ENDIF»
		
		/******************************   Current sensing Motor 1   **********************/
		#define ADC_SAMPLING_CYCLES (6 + SAMPLING_CYCLE_CORRECTION) //HARDWIRED
		

		«IF( ((mtpa_enable) && (magnetic=="Surface Mounted PMSM")) )»
		/*Error created for managing these exceptions.The generation must fail*/
		[#stop "MTPA strategy not applicable on SM-PMSM"]
		«ENDIF»
		«IF( ((mtpa_enable) ) && (Ld>=Lq) )»
		/*Error created for managing these exceptions.The generation must fail*/
		[#stop "using MTPA strategy, Ld must be lower than Lq for I-PMSM"]
		«ENDIF»
		/* Flux Weakening parameters */
		«IF( (fw_enable)  )»
		#define  FLUX_WEAKENING_ENABLING       ENABLE
		«ELSE»
		#define  FLUX_WEAKENING_ENABLING       DISABLE
		«ENDIF»
		#define  FW_VOLTAGE_REF                «v_limit» /*!<Vs reference, tenth 
																of a percent */
		#define  FW_KP_GAIN                    «fw_kp» /*!< Default Kp gain */
		#define  FW_KI_GAIN                    «fw_ki» /*!< Default Ki gain */
		#define  FW_KPDIV                      «fw_kp_div»
														/*!< Kp gain divisor.If FULL_MISRA_C_COMPLIANCY
														is not defined the divisor is implemented through
														algebrical right shifts to speed up PIs execution. 
														Only in this case this parameter specifies the 
														number of right shifts to be executed */
		#define  FW_KIDIV                      «fw_ki_div»
														/*!< Ki gain divisor.If FULL_MISRA_C_COMPLIANCY
														is not defined the divisor is implemented through
														algebrical right shifts to speed up PIs execution. 
														Only in this case this parameter specifies the 
														number of right shifts to be executed */
		/*  Feed-forward parameters */

		«IF( ff_enable)»
		#define FEED_FORWARD_CURRENT_REG_ENABLING   ENABLE
		#define CONSTANT1_Q                    « Math.round(c1_Q)»
		#define CONSTANT1_D                    « Math.round(c1_D)»
		#define CONSTANT2_QD                   « Math.round(c2_QD)»
		«ELSE»
		#define FEED_FORWARD_CURRENT_REG_ENABLING   DISABLE
		#define CONSTANT1_Q                    123532
		#define CONSTANT1_D                    123532
		#define CONSTANT2_QD                   5837
		«ENDIF»


		/*  Maximum Torque Per Ampere strategy parameters */
		«IF( mtpa_enable)»
		#define MTPA_ENABLING                  ENABLE
		#define IQMAX                          « Math.round(cIqmax)»
		#define SEGDIV                         « Math.round(cSegDiv)»
		#define ANGC                           {« Math.round(m0)»,« Math.round(m1)»,« Math.round(m2)»,« Math.round(m3)»,« Math.round(m4)»,« Math.round(m5)»,« Math.round(m6)»,« Math.round(m7)»}
		#define OFST                           {0,« Math.round(off1)»,« Math.round(off2)»,« Math.round(off3)»,« Math.round(off4)»,« Math.round(off5)»,« Math.round(off6)»,« Math.round(off7)»}
		«ELSE»
		#define MTPA_ENABLING                  DISABLE
		#define IQMAX                          « Math.round(nom_cur_digit)»
		#define SEGDIV                         0
		#define ANGC                           {0,0,0,0,0,0,0,0}
		#define OFST                           {0,0,0,0,0,0,0,0}
		«ENDIF»
		«IF( inrushcurr_enable  )»
		#define INRUSH_CURRLIMIT_ENABLING        ENABLE
		«ELSE»
		#define INRUSH_CURRLIMIT_ENABLING        DISABLE
		«ENDIF»
		«IF( (po_state===Poweronstate_enum.INACTIVE))»
		#define INRUSH_CURRLIMIT_AT_POWER_ON     INACTIVE   /* ACTIVE or INACTIVE */
		«ELSE»
		#define INRUSH_CURRLIMIT_AT_POWER_ON     ACTIVE     /* ACTIVE or INACTIVE */
		«ENDIF»
		#define INRUSH_CURRLIMIT_CHANGE_AFTER_MS «after»       /* milliseconds */
		/******************************** DEBUG ADD-ONs *******************************/
		#define LCD_JOYSTICK_FUNCTIONALITY       DISABLE
		#define LCD_MODE                         LCD_FULL
		#define START_STOP_BTN                   DISABLE
		
		/******************************** PFC ENABLING ********************************/
		/* #define PFC_ENABLED to enable the PFC */ 
		
		
		#endif /*__DRIVE_PARAMETERS_H*/

		'''
	
    }
 	
    def String generateMcConfigCode(Component comp) {
	 	// Power stage variables
		val ControlStage = (comp as Motorcontrol).control_stage
		
		val pwm_functionality = ControlStage.pwm_functionality
		val pwm_module = pwm_functionality.PWM_Module
		val pwm_u_ch = pwm_functionality.PWM_U_channel
		val pwm_v_ch = pwm_functionality.PWM_V_channel
		val pwm_w_ch = pwm_functionality.PWM_W_channel
		val pwm_adc_trig_ch = pwm_functionality.PWM_ADC_Trig_channel
		
		val currentsensing = ControlStage.currentSensing
		val brk_polarity = currentsensing.overcurrent_brk_polarity
		val brk_filter_div = currentsensing.overcurrent_brk_filter
		val brk2_enable = currentsensing.brk2_enable
		val brk2_polarity = currentsensing.overcurrent_brk2_polarity
		val brk2_filter_div = currentsensing.overcurrent_brk2_filter	
		val	adc_curr_ab = currentsensing.ADC_Current_IA_IB_Selection
		val	adc_curr_c = currentsensing.ADC_Current_C_Selection
		val	adc_ch_a = currentsensing.ADC_Channel_IA
		val	adc_ch_c = currentsensing.ADC_Channel_IB
		val	adc_ch_b = currentsensing.ADC_Channel_IC
		
		
		val dac_funcionality = ControlStage.dac_functionality
		val	dac_active = dac_funcionality.dac_enable
		val	debug_dac_ch1 = dac_funcionality.debug_ch1
		val	debug_dac_ch2 = dac_funcionality.debug_ch2
		val	dac_mode = dac_funcionality.dac_mode
		val	dac_tim_module = dac_funcionality.dac_timer_selection
		val	dac_tim_ch1 = dac_funcionality.ch1_timer_channel
		val	dac_tim_ch2 = dac_funcionality.ch2_timer_channel
		val	bdac_ch1 = dac_funcionality.ch1_bdac_channel
		val	bdac_ch2 = dac_funcionality.ch2_bdac_channel
		val variable_ch1 = dac_funcionality.ch1_variable
		val variable_ch2 = dac_funcionality.ch2_variable
		
		val resolverinterface = ControlStage.resolver
		val	res_adc = resolverinterface.resolver_adc_selection
		val sincos = resolverinterface.sin_cos_sensing
		val	adc_sin_ch = sincos.adc_channel_for_sin
		val	adc_cos_ch = sincos.adc_channel_for_cos
		val	res_dac_ch = resolverinterface.resolver_bdac_channel
		val res_dma = resolverinterface.resolver_dma
		val	res_dma_mod = res_dma.res_dma_mode
		val	res_dma_st = res_dma.res_dma_stream
		val	res_dmamux1_ch = res_dma.res_dmamux1_channel
		val	res_dmamux2_ch = res_dma.res_dmamux2_channel
		
		val vbus_temp = ControlStage.vbus_temp_measures
		val	vbus_mode = vbus_temp.vbus_sensing_mode
		val	adc_vbus_mod = vbus_temp.vbus_adc_module
		val	adc_vbus_ch = vbus_temp.vbus_adc_channel
		val	tim_vbus_mod = vbus_temp.vbus_tim_module
		val	tim_vbus_ch = vbus_temp.vbus_tim_channel
		val	tim_vbus_filter = vbus_temp.vbus_tim_filter		
		val	tim_vbus_device = vbus_temp.vbus_tim_device
		val	temp_mode = vbus_temp.temp_sensing_mode
		val	adc_temp_mod = vbus_temp.temp_adc_module
		val	adc_temp_ch = vbus_temp.temp_adc_channel
		val	tim_temp_device = vbus_temp.temp_tim_device
		val	tim_temp_mod = vbus_temp.temp_tim_module
		val	tim_temp_ch = vbus_temp.temp_tim_channel
		val	tim_temp_filter = vbus_temp.temp_tim_filter		
		
		val DriveMan = (comp as Motorcontrol).drive_management
		val hs_idle =  DriveMan.drive_settings.pwm_generation_and_current_reading.high_side_pwm_idle_state
		val ls_idle =  DriveMan.drive_settings.pwm_generation_and_current_reading.low_side_signals_and_dead_time.low_side_pwm_idle_state

		val Ctrl_stage = (comp as Motorcontrol).control_stage

		val main_enc_tim_module = Ctrl_stage.encoder.tim_module
		val aux_enc_tim_module = main_enc_tim_module
		val main_hall_tim_module = Ctrl_stage.hall.tim_module
		val aux_hall_tim_module = main_hall_tim_module

		val enc_tim_cha = Ctrl_stage.encoder.encoder_channels.encoder_tim_a
		val enc_tim_chb = Ctrl_stage.encoder.encoder_channels.encoder_tim_b
		val hall_tim_ch_s1 = Ctrl_stage.hall.hall_channels.hall_sensor_for_s1
		val hall_tim_ch_s2 = Ctrl_stage.hall.hall_channels.hall_sensor_for_s2
		val hall_tim_ch_s3 = Ctrl_stage.hall.hall_channels.hall_sensor_for_s3

		val main_sel = DriveMan.speed_sensor_selection.main_sensor.sensor_list1.sensor_selection				
		val en_aux_sel = DriveMan.speed_sensor_selection.auxiliary_sensor.enable_auxiliary_sensor
		val enableui = DriveMan.user_interface.enable_ui
		val aux_sel = DriveMan.speed_sensor_selection.auxiliary_sensor.sensor_list.sensor_selection
		val can_ch = DriveMan.user_interface.can_details.canchannel
		val can_br = DriveMan.user_interface.can_details.canbaudrate
		val can_start = DriveMan.user_interface.can_details.starting_tx_message_id
		val can_max_msg = DriveMan.user_interface.can_details.max_message_length
		val com_sel = DriveMan.user_interface.com_selection
		val ser_sel = DriveMan.user_interface.serial_details.serialchannel
		val ser_swap = DriveMan.user_interface.serial_details.txrx_swap
		val ser_br = DriveMan.user_interface.serial_details.serialbaudrate
		val ser_bidir = DriveMan.user_interface.serial_details.bidirectional
		
		val PowerStage = (comp as Motorcontrol).power_stage
		val ovrcurrent_rpot_en = PowerStage.over_current_protection.overcurrent_protection_enable
	    val hs_complemented = PowerStage.phase_drivers.complemented_from_high_side// upperCase
		val hs_signal = PowerStage.phase_drivers.driver_enabling_signal
		val topology = PowerStage.current_sensing.current_reading_topology
		
		var settingsP = PowerStage.current_sensing
		val Vamp_selection = settingsP.amplification_selection

		var boolean threeshunt = false

		if(topology == CurrentReadingTopology_enum.THREE_SHUNT_RESISTOR){
			threeshunt = true
		}

		var boolean InitADC1 = false
		var boolean InitADC2 = false
		var boolean InitADC3 = false
		var boolean InitADC4 = false
		var boolean InitADC5 = false

		
		if(((res_adc == ADC_RESOLVER_enum.ADC1_ADC2) && (main_sel == SensorSelection_enum.RESOLVER || ((aux_sel===SensorSelection_enum.RESOLVER) && (en_aux_sel)))) ||
		   ((res_adc == ADC_RESOLVER_enum.ADC1) && (main_sel == SensorSelection_enum.RESOLVER || ((aux_sel===SensorSelection_enum.RESOLVER) && (en_aux_sel)))) ||			 
		   (adc_curr_ab == ADC_COUPLE_enum.ADC1_ADC2) || 
		   ((adc_curr_c == ADC_MODULETYPE_enum.ADC1) && threeshunt))
		{
			InitADC1 = false
		}else if( (adc_vbus_mod == ADC_MODULETYPE_enum.ADC1) && (vbus_mode == VBUS_TEMP_MODETYPE_enum.ADC) || 
		          (adc_temp_mod == ADC_MODULETYPE_enum.ADC1) && (temp_mode == VBUS_TEMP_MODETYPE_enum.ADC)){
			InitADC1 = true
		}
		if(((res_adc == ADC_RESOLVER_enum.ADC1_ADC2) && (main_sel == SensorSelection_enum.RESOLVER || ((aux_sel===SensorSelection_enum.RESOLVER) && (en_aux_sel)))) ||
		   ((res_adc == ADC_RESOLVER_enum.ADC2) && (main_sel == SensorSelection_enum.RESOLVER || ((aux_sel===SensorSelection_enum.RESOLVER) && (en_aux_sel)))) ||
		   (adc_curr_ab == ADC_COUPLE_enum.ADC1_ADC2) || 
		   ((adc_curr_c == ADC_MODULETYPE_enum.ADC2) && threeshunt)){
			InitADC2 = false
		}else if((adc_vbus_mod == ADC_MODULETYPE_enum.ADC2) && (vbus_mode == VBUS_TEMP_MODETYPE_enum.ADC) || 
		   (adc_temp_mod == ADC_MODULETYPE_enum.ADC2) && (temp_mode == VBUS_TEMP_MODETYPE_enum.ADC)){
			InitADC2 = true
		}
		if(((res_adc == ADC_RESOLVER_enum.ADC3_ADC4) && (main_sel == SensorSelection_enum.RESOLVER || ((aux_sel===SensorSelection_enum.RESOLVER) && (en_aux_sel)))) ||
		   ((res_adc == ADC_RESOLVER_enum.ADC3) && (main_sel == SensorSelection_enum.RESOLVER || ((aux_sel===SensorSelection_enum.RESOLVER) && (en_aux_sel)))) ||
		   (adc_curr_ab == ADC_COUPLE_enum.ADC3_ADC4) || 
		   ((adc_curr_c == ADC_MODULETYPE_enum.ADC3) && threeshunt)){
			InitADC3 = false
		}else if((adc_vbus_mod == ADC_MODULETYPE_enum.ADC3) && (vbus_mode == VBUS_TEMP_MODETYPE_enum.ADC) || 
		   (adc_temp_mod == ADC_MODULETYPE_enum.ADC3) && (temp_mode == VBUS_TEMP_MODETYPE_enum.ADC)){
			InitADC3 = true
		}
		if(((res_adc == ADC_COUPLE_enum.ADC3_ADC4) && (main_sel == SensorSelection_enum.RESOLVER || ((aux_sel===SensorSelection_enum.RESOLVER) && (en_aux_sel)))) ||
		   ((res_adc == ADC_RESOLVER_enum.ADC4) && (main_sel == SensorSelection_enum.RESOLVER || ((aux_sel===SensorSelection_enum.RESOLVER) && (en_aux_sel)))) ||			 
		   (adc_curr_ab == ADC_COUPLE_enum.ADC3_ADC4) || 
		   ((adc_curr_c == ADC_MODULETYPE_enum.ADC4) && threeshunt)){
			InitADC4 = false
		}else if((adc_vbus_mod == ADC_MODULETYPE_enum.ADC4) && (vbus_mode == VBUS_TEMP_MODETYPE_enum.ADC) || 
	     	   (adc_temp_mod == ADC_MODULETYPE_enum.ADC4) && (temp_mode == VBUS_TEMP_MODETYPE_enum.ADC)){
			InitADC4 = true
		}
		if(((res_adc == ADC_RESOLVER_enum.ADC5)    && (main_sel == SensorSelection_enum.RESOLVER || ((aux_sel===SensorSelection_enum.RESOLVER) && (en_aux_sel)))) ||
		   ((adc_curr_c == ADC_MODULETYPE_enum.ADC5) && threeshunt)) {
			InitADC5 = false
		}else if((adc_vbus_mod == ADC_MODULETYPE_enum.ADC5) && (vbus_mode == VBUS_TEMP_MODETYPE_enum.ADC) || 
		         (adc_temp_mod == ADC_MODULETYPE_enum.ADC5) && (temp_mode == VBUS_TEMP_MODETYPE_enum.ADC)){
			InitADC5 = true
		}

		'''
		/****************************************************************************
		*
		* Copyright (c) 2023 STMicroelectronics - All Rights Reserved
		*
		* License terms: STMicroelectronics Proprietary in accordance with licensing
		* terms SLA0098 at www.st.com.
		*
		* THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
		* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
		*
		*****************************************************************************/
		/*
		* @file    mc_config.h
		* @author  Motor Control SDK Team, ST Microelectronics
		* @brief   Motor Control Subsystem components configuration and handler
		*          structures declarations.
		*/
		#ifndef __MC_CONFIG_H
		#define __MC_CONFIG_H
		
		#include "pid_regulator.h"
		#include "revup_ctrl.h"
		#include "speed_torq_ctrl.h"
		#include "virtual_speed_sensor.h"
		#include "ntc_temperature_sensor.h"
		#include "pwm_curr_fdbk.h"
		#include "r_divider_bus_voltage_sensor.h"
		#include "virtual_bus_voltage_sensor.h"
		#include "pqd_motor_power_measurement.h"
		#include "user_interface.h"
		#include "motor_control_protocol.h"
		#include "usart_frame_communication_protocol.h"
		#include "can_frame_communication_protocol.h"
		#include "dac_common_ui.h"
		#include "dac_rctimer_ui.h"
		#include "dac_ui.h"
		#include "ics_SR5E1_pwm_curr_fdbk.h"
		#include "encoder_speed_pos_fdbk.h"
		#include "resolver_SR5E1_speed_pos_fdbk.h"
		#include "enc_align_ctrl.h"
		#include "hall_speed_pos_fdbk.h"        
		#include "ramp_ext_mngr.h"
		#include "circle_limitation.h"
		#include "sto_speed_pos_fdbk.h"
		#include "sto_pll_speed_pos_fdbk.h"
		#include "external_adc_out.h"
		
		#ifdef USE_STGAP1S
		#include "gap_gate_driver_ctrl.h"
		#endif
		
		extern RevUpCtrl_Handle_t RevUpControlM1;
		extern PID_Handle_t PIDSpeedHandle_M1;
		extern PID_Handle_t PIDIqHandle_M1;
		extern PID_Handle_t PIDIdHandle_M1;
		extern NTC_Handle_t TempSensorParamsM1;
		extern PWMC_ICS_Handle_t PWM_Handle_M1;
		extern SpeednTorqCtrl_Handle_t SpeednTorqCtrlM1;
		extern PQD_MotorPowMeas_Handle_t PQD_MotorPowMeasM1;
		extern PQD_MotorPowMeas_Handle_t *pPQD_MotorPowMeasM1;
		extern VirtualSpeedSensor_Handle_t VirtualSpeedSensorM1;
		extern STO_Handle_t STO_M1;
		extern STO_PLL_Handle_t STO_PLL_M1;
		extern ENCODER_Handle_t ENCODER_M1;
		extern EncAlign_Handle_t EncAlignCtrlM1;
		extern HALL_Handle_t HALL_M1;
		extern Resolver_SR5E1_Handle_t Resolver_M1;
		extern RDivider_Handle_t RealBusVoltageSensorParamsM1;
		extern VirtualBusVoltageSensor_Handle_t VirtualBusVoltageSensorParamsM1;
		extern CircleLimitation_Handle_t CircleLimitationM1;
		extern RampExtMngr_Handle_t RampExtMngrHFParamsM1;
		extern UI_Handle_t UI_Params;
		extern DAC_UI_Handle_t DAC_UI_Params;
		extern UFCP_Handle_t pUSART;
		extern CFCP_Handle_t pFDCAN;
		extern Ext_ADC_OUT_t VBUS_EXT_ADCOUT_M1;
		extern Ext_ADC_OUT_t TEMP_EXT_ADCOUT_M1;        
		
		#ifdef USE_STGAP1S
		extern GAP_Handle_t STGAP_M1;
		#endif
		
		/* enable ITCM */
		#define MCTK_ITCM
		
		#define NBR_OF_MOTORS 1		
		
		/* PWM Module section */
		#define PWM_MODULE_SELECTION              «pwm_module.literal»    
		/* TIM channel assignment */
		#define TIMx_UH_CHANNEL       (LL_TIM_«pwm_u_ch.literal»)  /* Phase A Top transistor channel */
		#define TIMx_UL_CHANNEL       (LL_TIM_«pwm_u_ch.literal»N) /* Phase A Bottom transistor channel */
		#define TIMx_VH_CHANNEL       (LL_TIM_«pwm_v_ch.literal»)  /* Phase B Top transistor channel */ 
		#define TIMx_VL_CHANNEL       (LL_TIM_«pwm_v_ch.literal»N) /* Phase B Bottom transistor channel */ 
		#define TIMx_WH_CHANNEL       (LL_TIM_«pwm_w_ch.literal»)  /* Phase C Top transistor channel */
		#define TIMx_WL_CHANNEL       (LL_TIM_«pwm_w_ch.literal»N) /* Phase C Bottom transistor channel */
		#define TIMx_ADC_TRG_CH       (LL_TIM_«pwm_adc_trig_ch.literal»)  /* ADC trigger channel (current sensing) */
		
		«IF(pwm_module == PWM_moduletype_enum.TIM1)»
		#define ICS_ADC_INJ_TRIG_EXT_TIMx_TRGO         LL_ADC_INJ_TRIG_EXT_TIM1_TRGO
		«ELSE»		
		#define ICS_ADC_INJ_TRIG_EXT_TIMx_TRGO         LL_ADC_INJ_TRIG_EXT_TIM8_TRGO
		«ENDIF»		
		/* IDLE state --> to be moved into drive paramters.h file */
		«IF(hs_idle == HighsidePWMidlestate_enum.TURN_OFF)» 
		#define PWM_HIGH_SIDE_IDLE_STATE (LL_TIM_OCIDLESTATE_LOW)
		«ELSE»
		#define PWM_HIGH_SIDE_IDLE_STATE (LL_TIM_OCIDLESTATE_HIGH)
		«ENDIF»
		
		«IF(ls_idle == LowsidePWMidlestate_enum.TURN_OFF)» 
		#define PWM_LOW_SIDE_IDLE_STATE (LL_TIM_OCIDLESTATE_LOW)
		«ELSE»
		#define PWM_LOW_SIDE_IDLE_STATE (LL_TIM_OCIDLESTATE_HIGH)
		«ENDIF»
		«IF( hs_complemented === Complementedfromhighside_enum.ENABLE) && ( hs_signal === DriverEnablingSignal_enum.ENABLE)»
		«ELSE»
		/* These pin must be defined only for ES_GPIO configuration */
		#define ENABLE_CH1 0
		#define ENABLE_CH2 0
		#define ENABLE_CH3 0		
		«ENDIF»		
		/* over current protection */
		/* enable/disable in power stage over current protection */
		«IF(ovrcurrent_rpot_en)»
		#define SW_OV_CURRENT_PROT_ENABLING (LL_TIM_BREAK_ENABLE)
		«ELSE»
		#define SW_OV_CURRENT_PROT_ENABLING (LL_TIM_BREAK_DISABLE)
		«ENDIF»
		#define OVERCURR_FEEDBACK_POLARITY  (LL_TIM_BREAK_POLARITY_«brk_polarity.literal»)
		#define OVERCURR_BREAK_FILTER       (LL_TIM_BREAK_FILTER_«brk_filter_div.literal»)
		
		/* PWM BREAK2 */
		«IF(brk2_enable)»
		#define ICS_BREAK2_ENABLING           (LL_TIM_BREAK2_ENABLE)
		«ELSE»		
		#define ICS_BREAK2_ENABLING           (LL_TIM_BREAK2_DISABLE)		
		«ENDIF»		
		#define ICS_BREAK2_FEEDBACK_POLARITY  (LL_TIM_BREAK2_POLARITY_«brk2_polarity.literal»)
		#define ICS_BREAK2_FILTER             (LL_TIM_BREAK2_FILTER_«brk2_filter_div.literal»)		
		
		/* Currents Sensing ADC section */
		«IF( adc_curr_ab == ADC_COUPLE_enum.ADC1_ADC2)»
		#define ADC_0_PERIPH                    (ADC1)
		#define ADC_1_PERIPH                    (ADC2)
		«ELSE»
		«IF(adc_curr_ab == ADC_COUPLE_enum.ADC3_ADC4)»
		#define ADC_0_PERIPH                    (ADC3)
		#define ADC_1_PERIPH                    (ADC4)
		«ENDIF»
		«ENDIF»
		
		#define ADC_2_PERIPH                    («adc_curr_c.literal»)
		#define PHASE_IA_CURR_CHANNEL           (MC_ADC_«adc_ch_a.literal») 
		#define PHASE_IB_CURR_CHANNEL           (MC_ADC_«adc_ch_c.literal»)
		#define PHASE_IC_CURR_CHANNEL           (MC_ADC_«adc_ch_b.literal»)
		
		#define ADC_SAMPLING_TIME               (LL_ADC_SAMPLINGTIME_6CYCLES_5) 
		
		«IF( adc_curr_ab == ADC_COUPLE_enum.ADC1_ADC2)»
		#define ADCx_HF_M1_IRQHandler  IRQ_ADC1_HANDLER
		#define IRQ_HF_ADC_VECTOR      IRQ_ADC1_VECTOR
		«ELSE»
		#define ADCx_HF_M1_IRQHandler  IRQ_ADC3_HANDLER
		#define IRQ_HF_ADC_VECTOR      IRQ_ADC3_VECTOR
		«ENDIF»	
		
		/****             DAC    ***/
		/* DAC Debug Setting */
		
		«IF(dac_active)»
		#define DAC_FUNCTIONALITY                TRUE
		«ELSE»
		#define DAC_FUNCTIONALITY                FALSE
		«ENDIF»
		
		«IF(debug_dac_ch1 === CH1_enum.DEBUG)»
		#define DEBUG_DAC_CH1                    TRUE
		«ELSE»
		#define DEBUG_DAC_CH1                    FALSE
		«ENDIF»
		«IF(debug_dac_ch2 === CH2_enum.DEBUG)»
		#define DEBUG_DAC_CH2                    TRUE
		«ELSE»
		#define DEBUG_DAC_CH2                    FALSE
		«ENDIF»
		
		#define DEFAULT_DAC_CHANNEL_1            MC_PROTOCOL_REG_«variable_ch1.getName»
		#define DEFAULT_DAC_CHANNEL_2            MC_PROTOCOL_REG_«variable_ch2.getName»
		
		«IF(dac_mode == DAC_MODETYPE_enum.TIM)»
		/* DAC as TIM */
		#define TIM_DAC
		#define DAC_MODULE         «dac_tim_module.literal» /* (TIMx Module) */
		#define DAC_RESOURCE_CH1   LL_TIM_«dac_tim_ch1.literal» /* DAC TIM timer channel 1 */
		#define DAC_RESOURCE_CH2   LL_TIM_«dac_tim_ch2.literal» /* DAC TIM timer channel 2 */
		«ELSE»
		/* DAC as BDAC */
		#define DAC_MODULE         BDAC1 
		#define DAC_RESOURCE_CH1   LL_DAC_«bdac_ch1.literal» /* BDAC channel  */
		#define DAC_RESOURCE_CH2   LL_DAC_«bdac_ch2.literal» /* BDAC channel  */
		«ENDIF»
		«IF( main_sel===SensorSelection_enum.HALL_SENSORS)»
 		/****    HALL    ***/
 		/* HALL timer section */
 		#define HALL_TIMER_SELECTION              («main_hall_tim_module.literal»)
		#define HALL_S1_CH               		  (LL_TIM_«hall_tim_ch_s1.literal»)  
        #define HALL_S2_CH                        (LL_TIM_«hall_tim_ch_s2.literal»)  
		#define HALL_S3_CH                        (LL_TIM_«hall_tim_ch_s3.literal»)
		#define HALL_TIMx_VECTOR                  IRQ_«main_hall_tim_module.literal»_VECTOR		
		«ELSE»
		«IF( (aux_sel===SensorSelection_enum.HALL_SENSORS) && (en_aux_sel) )»
		/****    HALL    ***/
 		/* HALL timer section */
		#define HALL_TIMER_SELECTION              («aux_hall_tim_module.literal»)
		#define HALL_S1_CH               		  (LL_TIM_«hall_tim_ch_s1.literal»)
		#define HALL_S2_CH                        (LL_TIM_«hall_tim_ch_s2.literal»)
		#define HALL_S3_CH                        (LL_TIM_«hall_tim_ch_s3.literal»)
		#define HALL_TIMx_VECTOR                  IRQ_«aux_hall_tim_module.literal»_VECTOR		
		«ENDIF»
		«ENDIF»
		«IF( main_sel===SensorSelection_enum.QUADRATURE_ENCODER)»
		/****    ENCODER    ***/
 		/* ENCODER timer section */
		#define ENC_TIMER_SELECTION               («main_enc_tim_module.literal»)
		#define ENC_CH_A_INPUT                    (LL_TIM_«enc_tim_cha.literal»)
		#define ENC_CH_B_INPUT                    (LL_TIM_«enc_tim_chb.literal»)
		#define ENC_TIMx_VECTOR                   IRQ_«main_enc_tim_module.literal»_VECTOR
		«ELSE»
		«IF( (aux_sel===SensorSelection_enum.QUADRATURE_ENCODER) && (en_aux_sel) )»
		/****    ENCODER    ***/
 		/* ENCODER timer section */
		#define ENC_TIMER_SELECTION               («aux_enc_tim_module.literal»)
		#define ENC_CH_A_INPUT                    (LL_TIM_«enc_tim_cha.literal»)
		#define ENC_CH_B_INPUT                    (LL_TIM_«enc_tim_chb.literal»)
		#define ENC_TIMx_VECTOR                   IRQ_«aux_enc_tim_module.literal»_VECTOR
		«ENDIF»
		«ENDIF»
		«IF( main_sel===SensorSelection_enum.RESOLVER)»
		/****    RESOLVER    ***/
		«IF( res_adc == ADC_RESOLVER_enum.ADC1_ADC2)»
		/* DUAL ADC used for Resolver (SIN/COS) */
		#define RES_ADC_MODULE_SIN              (ADC1)
		#define RES_ADC_MODULE_COS              (ADC2)
		#define RES_ADC_MODULE_SIN_COS          (ADC1) /* not used */
		#define IRQ_RES_ADC_VECTOR              IRQ_ADC1_VECTOR
		#define ADCx_RES_M1_IRQHandler          IRQ_ADC1_HANDLER
		«ENDIF»
		«IF(res_adc == ADC_RESOLVER_enum.ADC3_ADC4)»
		/* DUAL ADC used for Resolver (SIN/COS)	*/	
		#define RES_ADC_MODULE_SIN              (ADC3)
		#define RES_ADC_MODULE_COS              (ADC4)
		#define RES_ADC_MODULE_SIN_COS          (ADC3) /* not used */
        #define IRQ_RES_ADC_VECTOR              IRQ_ADC3_VECTOR
		#define ADCx_RES_M1_IRQHandler          IRQ_ADC3_HANDLER		
		«ENDIF»
		«IF(res_adc == ADC_RESOLVER_enum.ADC1)»
		/* Single ADC used for Resolver (SIN/COS) */
		#define RES_SINGLE_ADC_RESOURCE
		#define RES_ADC_MODULE_SIN_COS          (ADC1)
		#define RES_ADC_MODULE_SIN              (ADC1) /* not used */
		#define RES_ADC_MODULE_COS              (ADC1) /* not used */
        #define IRQ_RES_ADC_VECTOR              IRQ_ADC1_VECTOR
		#define ADCx_RES_M1_IRQHandler          IRQ_ADC1_HANDLER		
		«ENDIF»
		«IF(res_adc == ADC_RESOLVER_enum.ADC2)»
		/* Single ADC used for Resolver (SIN/COS) */
		#define RES_SINGLE_ADC_RESOURCE
		#define RES_ADC_MODULE_SIN_COS          (ADC2)
		#define RES_ADC_MODULE_SIN              (ADC2) /* not used */
		#define RES_ADC_MODULE_COS              (ADC2) /* not used */
        #define IRQ_RES_ADC_VECTOR              IRQ_ADC2_VECTOR
		#define ADCx_RES_M1_IRQHandler          IRQ_ADC2_HANDLER		
		«ENDIF»
		«IF(res_adc == ADC_RESOLVER_enum.ADC3)»
		/* Single ADC used for Resolver (SIN/COS) */
		#define RES_SINGLE_ADC_RESOURCE
		#define RES_ADC_MODULE_SIN_COS          (ADC3)
		#define RES_ADC_MODULE_SIN              (ADC3) /* not used */
		#define RES_ADC_MODULE_COS              (ADC3) /* not used */
        #define IRQ_RES_ADC_VECTOR              IRQ_ADC3_VECTOR
		#define ADCx_RES_M1_IRQHandler          IRQ_ADC3_HANDLER		
		«ENDIF»
		«IF(res_adc == ADC_RESOLVER_enum.ADC4)»
		/* Single ADC used for Resolver (SIN/COS) */
		#define RES_SINGLE_ADC_RESOURCE
		#define RES_ADC_MODULE_SIN_COS          (ADC4)
		#define RES_ADC_MODULE_SIN              (ADC4) /* not used */
		#define RES_ADC_MODULE_COS              (ADC4) /* not used */
        #define IRQ_RES_ADC_VECTOR              IRQ_ADC4_VECTOR
		#define ADCx_RES_M1_IRQHandler          IRQ_ADC4_HANDLER		
		«ENDIF»
		«IF(res_adc == ADC_RESOLVER_enum.ADC5)»
		/* Single ADC used for Resolver (SIN/COS) */
		#define RES_SINGLE_ADC_RESOURCE
		#define RES_ADC_MODULE_SIN_COS          (ADC5)
		#define RES_ADC_MODULE_SIN              (ADC5) /* not used */
		#define RES_ADC_MODULE_COS              (ADC5 /* not used */
        #define IRQ_RES_ADC_VECTOR              IRQ_ADC5_VECTOR
		#define ADCx_RES_M1_IRQHandler          IRQ_ADC5_HANDLER		
		«ENDIF»		
		#define RES_ADC_CHANNEL_SIN             (LL_ADC_«adc_sin_ch.literal»)
		#define RES_ADC_CHANNEL_COS             (LL_ADC_«adc_cos_ch.literal»)
		
		#define RES_DAC_MODULE                  (BDAC1)               /* BDACx HW Settings */
		#define RES_DAC_CHANNEL                 (LL_DAC_«res_dac_ch.literal»)    /* Resolver excitation DAC channel */
		#define RES_DMA                         («res_dma_mod.literal»)                /* DMA peripheral used to update output register of the DAC (exciting signal) */
		#define RES_DMA_CHANNEL                 (LL_DMA_«res_dma_st.literal»)     /* STREAM_x DMA channel used to update output register of the DAC (exciting signal) */
		
		«IF( res_dma_mod == RES_DMA_MOD_enum.DMA1)»
		#define RES_DMA_MUX                     (DMAMUX1)             /* DMA mux used to update output register of the DAC  */
		#define RES_DMA_MUX_CH                 (LL_DMAMUX_«res_dmamux1_ch.literal») /* DMA mux channel used to update output register of the DAC  */
		«ELSE»
		#define RES_DMA_MUX                     (DMAMUX2)             /* DMA mux used to update output register of the DAC  */
		#define RES_DMA_MUX_CH                  (LL_DMAMUX_«res_dmamux2_ch.literal») /* DMA mux channel used to update output register of the DAC  */
		«ENDIF»
		
		#define RES_TIM_MODULE_FOR_DAC          (TIM6)                /* High frequency timer (TIM6 or TIM7) to clock the BDAC update of values */
		#define RES_TIM_MODULE_FOR_ADC          (TIM15)               /* Timer used to trigger the ADC conversions (SIN/COS). It is synchronized with TIM6 or TIM 7 */
		                                                              /* The triggering point is set by CCR 1 (TIM15_TRGO) */
		#define RES_TIM_CHANNEL_FOR_ADC         (LL_TIM_CHANNEL_CH1)  /* Timer chennel used to trigger the ADC conversions (SIN/COS). It is synchronized with TIM6 or TIM7 */
		«ELSE»
		«IF( (aux_sel===SensorSelection_enum.RESOLVER) && (en_aux_sel) )»
		/****    RESOLVER    ***/
		«IF( res_adc == ADC_RESOLVER_enum.ADC1_ADC2)»
		/* DUAL ADC used for Resolver (SIN/COS) */
		#define RES_ADC_MODULE_SIN              (ADC1)
		#define RES_ADC_MODULE_COS              (ADC2)
		#define RES_ADC_MODULE_SIN_COS          (ADC1) /* not used */
		#define IRQ_RES_ADC_VECTOR              IRQ_ADC1_VECTOR
		#define ADCx_RES_M1_IRQHandler          IRQ_ADC1_HANDLER		
		«ENDIF»
		«IF(res_adc == ADC_RESOLVER_enum.ADC3_ADC4)»
		/* DUAL ADC used for Resolver (SIN/COS) */
		#define RES_ADC_MODULE_SIN              (ADC3)
		#define RES_ADC_MODULE_COS              (ADC4)
		#define RES_ADC_MODULE_SIN_COS          (ADC3) /* not used */
		#define IRQ_RES_ADC_VECTOR              IRQ_ADC3_VECTOR
		#define ADCx_RES_M1_IRQHandler          IRQ_ADC3_HANDLER		
		«ENDIF»
		«IF(res_adc == ADC_RESOLVER_enum.ADC1)»
		/* Single ADC used for Resolver (SIN/COS) */
		#define RES_SINGLE_ADC_RESOURCE
		#define RES_ADC_MODULE_SIN_COS          (ADC1)
		#define RES_ADC_MODULE_SIN              (ADC1) /* not used */
		#define RES_ADC_MODULE_COS              (ADC1) /* not used */
		#define IRQ_RES_ADC_VECTOR              IRQ_ADC1_VECTOR
		#define ADCx_RES_M1_IRQHandler          IRQ_ADC1_HANDLER		
		«ENDIF»
		«IF(res_adc == ADC_RESOLVER_enum.ADC2)»
		/* Single ADC used for Resolver (SIN/COS) */
		#define RES_SINGLE_ADC_RESOURCE
		#define RES_ADC_MODULE_SIN_COS          (ADC2)
		#define RES_ADC_MODULE_SIN              (ADC2) /* not used */
		#define RES_ADC_MODULE_COS              (ADC2) /* not used */
		#define IRQ_RES_ADC_VECTOR              IRQ_ADC2_VECTOR
		#define ADCx_RES_M1_IRQHandler          IRQ_ADC2_HANDLER	
		«ENDIF»
		«IF(res_adc == ADC_RESOLVER_enum.ADC3)»
		/* Single ADC used for Resolver (SIN/COS) */
		#define RES_SINGLE_ADC_RESOURCE
		#define RES_ADC_MODULE_SIN_COS          (ADC3)
		#define RES_ADC_MODULE_SIN              (ADC3) /* not used */
		#define RES_ADC_MODULE_COS              (ADC3) /* not used */
		#define IRQ_RES_ADC_VECTOR              IRQ_ADC3_VECTOR
		#define ADCx_RES_M1_IRQHandler          IRQ_ADC3_HANDLER		
		«ENDIF»
		«IF(res_adc == ADC_RESOLVER_enum.ADC4)»
		/* Single ADC used for Resolver (SIN/COS) */
		#define RES_SINGLE_ADC_RESOURCE
		#define RES_ADC_MODULE_SIN_COS          (ADC4)
		#define RES_ADC_MODULE_SIN              (ADC4) /* not used */
		#define RES_ADC_MODULE_COS              (ADC4) /* not used */
		#define IRQ_RES_ADC_VECTOR              IRQ_ADC4_VECTOR
		#define ADCx_RES_M1_IRQHandler          IRQ_ADC4_HANDLER		
		«ENDIF»
		«IF(res_adc == ADC_RESOLVER_enum.ADC5)»
		/* Single ADC used for Resolver (SIN/COS) */
		#define RES_SINGLE_ADC_RESOURCE
		#define RES_ADC_MODULE_SIN_COS          (ADC5)
		#define RES_ADC_MODULE_SIN              (ADC5) /* not used */
		#define RES_ADC_MODULE_COS              (ADC5 /* not used */
		#define IRQ_RES_ADC_VECTOR              IRQ_ADC5_VECTOR
		#define ADCx_RES_M1_IRQHandler          IRQ_ADC5_HANDLER		
		«ENDIF»
		#define RES_ADC_CHANNEL_SIN             (LL_ADC_«adc_sin_ch.literal»)
		#define RES_ADC_CHANNEL_COS             (LL_ADC_«adc_cos_ch.literal»)
		
		#define RES_DAC_MODULE                  (BDAC1)               /* BDACx HW Settings */
		#define RES_DAC_CHANNEL                 (LL_DAC_«res_dac_ch.literal»)    /* Resolver excitation DAC channel */
		#define RES_DMA                         («res_dma_mod.literal»)                /* DMA peripheral used to update output register of the DAC (exciting signal) */
		#define RES_DMA_CHANNEL                 (LL_DMA_«res_dma_st.literal»)     /* STREAM_x DMA channel used to update output register of the DAC (exciting signal) */
		
		«IF( res_dma_mod == RES_DMA_MOD_enum.DMA1)»
		#define RES_DMA_MUX                     (DMAMUX1)             /* DMA mux used to update output register of the DAC  */
		#define RES_DMA_MUX_CH                 (LL_DMAMUX_«res_dmamux1_ch.literal») /* DMA mux channel used to update output register of the DAC  */
		«ELSE»
		#define RES_DMA_MUX                     (DMAMUX2)             /* DMA mux used to update output register of the DAC  */
		#define RES_DMA_MUX_CH                  (LL_DMAMUX_«res_dmamux2_ch.literal») /* DMA mux channel used to update output register of the DAC  */
		«ENDIF»		
		#define RES_TIM_MODULE_FOR_DAC          (TIM6)                /* High frequency timer (TIM6 or TIM7) to clock the BDAC update of values */
		#define RES_TIM_MODULE_FOR_ADC          (TIM15)               /* Timer used to trigger the ADC conversions (SIN/COS). It is synchronized with TIM6 or TIM 7 */
		                                                              /* The triggering point is set by CCR 1 (TIM15_TRGO) */
		#define RES_TIM_CHANNEL_FOR_ADC         (LL_TIM_CHANNEL_CH1)  /* Timer chennel used to trigger the ADC conversions (SIN/COS). It is synchronized with TIM6 or TIM7 */
		«ENDIF»
		«ENDIF»

		/* VBUS / TEMP sensing */
		/* nr. ADC modules on device */
		#define MAX_ADC_MODULE 5U
		
		/* ADC module configuration to initialize User conversion.                   */
		/* These macro initialiaze SAR ADC when the value is TRUE. The ADC module is */ 
		/* used for VBUS/Temperature sensing. The initializaion is done in current sensing module (for i.e. ICS)  */
		#define INIT_SARADC_UNIT_1 («InitADC1.toString.toUpperCase») 
		#define INIT_SARADC_UNIT_2 («InitADC2.toString.toUpperCase») 
		#define INIT_SARADC_UNIT_3 («InitADC3.toString.toUpperCase») 
		#define INIT_SARADC_UNIT_4 («InitADC4.toString.toUpperCase») 
		#define INIT_SARADC_UNIT_5 («InitADC5.toString.toUpperCase»)
		
		«IF(vbus_mode == VBUS_TEMP_MODETYPE_enum.TIM)»
		   «IF(Vamp_selection==Amplificationselection_enum.BY_L9502)»
		#define VBUS_ADC_REFERENCE_VOLTAGE 5.7
		   «ELSE»
		#define VBUS_ADC_REFERENCE_VOLTAGE ADC_REFERENCE_VOLTAGE
		   «ENDIF»
        «ELSE»		   
		#define VBUS_ADC_REFERENCE_VOLTAGE ADC_REFERENCE_VOLTAGE
		«ENDIF»
		
		/** VBus readings **/
		«IF(vbus_mode == VBUS_TEMP_MODETYPE_enum.TIM)»
		/* VBUS sensing configured with TIM (Input Capture) (external ADC sensing) */
		/* Enable ADC OUT for VBUS configuration */
		#define USE_VBUS_EXT_ADC_OUT
		#define VBUS_EXT_ADC_TIMER              «tim_vbus_mod.literal»
		#define VBUS_EXT_ADC_INPUT_CAPTURE_CH   LL_TIM_«tim_vbus_ch.literal» /* TIM timer channel */
		#define VBUS_EXT_ADC_DEVICE_NB          «tim_vbus_device» /* VBUS device number */
		#define VBUS_EXT_INPUT_FILTER           LL_TIM_IC_FILTER_«tim_vbus_filter.literal»
		«IF(tim_vbus_ch == SENSING_TIM_CHANNELTYPE_enum.CHANNEL_CH1)»
		#define VBUS_EXT_ADC_MEASURED_CH        LL_TIM_CHANNEL_CH2
		«ELSE»
		#define VBUS_EXT_ADC_MEASURED_CH        LL_TIM_CHANNEL_CH1
		«ENDIF»
		#define VBUS_EXT_ADC_TIM_IRQHandler     IRQ_«tim_vbus_mod.literal»_HANDLER
		#define VBUS_EXT_ADC_TIM_VECTOR         IRQ_«tim_vbus_mod.literal»_VECTOR
		#define VBUS_EXT_ADC_TIM_PRIO           IRQ_«tim_vbus_mod.literal»_PRIO
		«ELSE»
		/* VBUS configured to use internal ADC */
		#define VBUS_ADC_MODULE                 («adc_vbus_mod.literal»)        /*!< Adc module used for VBus sensing */
		#define VBUS_ADC_CHANNEL                (MC_ADC_«adc_vbus_ch.literal»)  /*!< Adc channel used for VBus sensing */
		#define VBUS_ADC_SAMPLING_TIME          (M1_VBUS_SAMPLING_TIME)         /* hardwired */
		«ENDIF»

		«IF(temp_mode == VBUS_TEMP_MODETYPE_enum.TIM)»
		   «IF(Vamp_selection==Amplificationselection_enum.BY_L9502)»
		#define TEMP_ADC_REFERENCE_VOLTAGE 5.0
		   «ELSE»
		#define TEMP_ADC_REFERENCE_VOLTAGE ADC_REFERENCE_VOLTAGE
		   «ENDIF»
        «ELSE»		   
		#define TEMP_ADC_REFERENCE_VOLTAGE ADC_REFERENCE_VOLTAGE
		«ENDIF»

		
		/** Temperature readings **/
		«IF(temp_mode == VBUS_TEMP_MODETYPE_enum.TIM)»
		/* Temperature sensing configured with TIM (Input Capture) (external ADC sensing) */
		/* Enable ADC OUT for Temperature sensing configuration */
		#define USE_TEMP_EXT_ADC_OUT
		#define TEMP_EXT_ADC_TIMER              «tim_temp_mod.literal»
		#define TEMP_EXT_ADC_INPUT_CAPTURE_CH   LL_TIM_«tim_temp_ch.literal» /* TIM timer channel */
		#define TEMP_EXT_ADC_DEVICE_NB          «tim_temp_device» /* Temperature device number */
		#define TEMP_EXT_INPUT_FILTER           LL_TIM_IC_FILTER_«tim_temp_filter.literal»		
		«IF(tim_temp_ch == SENSING_TIM_CHANNELTYPE_enum.CHANNEL_CH1)»
		#define TEMP_EXT_ADC_MEASURED_CH        LL_TIM_CHANNEL_CH2
		«ELSE»
		#define TEMP_EXT_ADC_MEASURED_CH        LL_TIM_CHANNEL_CH1
		«ENDIF»
		#define TEMP_EXT_ADC_TIM_IRQHandler     IRQ_«tim_temp_mod.literal»_HANDLER
		#define TEMP_EXT_ADC_TIM_VECTOR         IRQ_«tim_temp_mod.literal»_VECTOR
		#define TEMP_EXT_ADC_TIM_PRIO           IRQ_«tim_temp_mod.literal»_PRIO        
		«ELSE»
		/* Temperature sensing configured to use internal ADC */
		#define TEMP_FDBK_ADC_MODULE            («adc_temp_mod.literal»)
		#define TEMP_FDBK_ADC_CHANNEL           (MC_ADC_«adc_temp_ch.literal»)
		#define TEMP_ADC_SAMPLING_TIME          (uint16_t)(ADC_PRECHG_VALUE(SLOW_SARADC_PRECHG_VALUE_CONF)|ADC_INPSAMP_VALUE(SLOW_SARADC_INPSAMP_VALUE_CONF)) /* hardwired */
		«ENDIF»
		
		«IF(enableui)»
		«IF(com_sel == COMSelection_enum.SERIAL)»
		/* Serial communication */
		#define SERIAL_COMMUNICATION   /* enable SERIAL User Interface */
		#define USART_SELECTION                 «ser_sel.literal»
		#define USART_SPEED                     «ser_br.literal»
		«IF(ser_swap)»
		#define USART_SWAP_TXRX_PIN             LL_USART_TXRX_SWAPPED 
		«ELSE»
		#define USART_SWAP_TXRX_PIN             LL_USART_TXRX_STANDARD
		«ENDIF»
		«ELSE»
		/* Can communication */
		#define CAN_COMMUNICATION   /* enable CAN User Interface */
		#define CAN_SELECTION                   FD«can_ch.literal»
		#define CAN_MAX_MSG_LENGTH              «can_max_msg»U
		#define CAN_TX_MSG_ID_START             «can_start»U
		#define CAN_BR_SELECTION                CAN_«can_br.literal»_KBPS		
		«ENDIF»
		«ENDIF»
		#endif /* __MC_CONFIG_H */
		/******************* (C) COPYRIGHT 2023 STMicroelectronics *****END OF FILE****/
		'''
    }
 	
	def String generateParameterConversion(Component comp){
		val DriveMan = (comp as Motorcontrol).drive_management
		val main_sel = DriveMan.speed_sensor_selection.main_sensor.sensor_list1.sensor_selection				
		val en_aux_sel = DriveMan.speed_sensor_selection.auxiliary_sensor.enable_auxiliary_sensor
		val aux_sel = DriveMan.speed_sensor_selection.auxiliary_sensor.sensor_list.sensor_selection
		val main_encoder_ic_filter = DriveMan.speed_sensor_selection.main_sensor.sensor_list1.quadrature_encoder.encoder_ic_filter
		val aux_encoder_ic_filter = DriveMan.speed_sensor_selection.auxiliary_sensor.sensor_list.quadrature_encoder.encoder_ic_filter
		val main_hall_ic_filter = DriveMan.speed_sensor_selection.main_sensor.sensor_list1.hall_sensors.hall_ic_filter
		val aux_hall_ic_filter = DriveMan.speed_sensor_selection.auxiliary_sensor.sensor_list.hall_sensors.hall_ic_filter
		val fw_enable = DriveMan.additional_features.additional_methods.flux_weakening_enable
		val ff_enable = DriveMan.additional_features.additional_methods.feed_forward_enable
		val com_sel = DriveMan.user_interface.com_selection
		val serialchannel = DriveMan.user_interface.serial_details.serialchannel
		val boolean positioncontrol1 = false

	    val Ctrl_stage = (comp as Motorcontrol).control_stage
		val mcu_supply = Ctrl_stage.mcu_supply_voltage_and_clock_frequency.mcu_supply_voltage
		val dac_func_en = Ctrl_stage.dac_functionality.dac_enable

		val main_enc_tim_module = Ctrl_stage.encoder.tim_module
		val aux_enc_tim_module = main_enc_tim_module
		val main_hall_tim_module = Ctrl_stage.hall.tim_module
		val aux_hall_tim_module = main_hall_tim_module

		val powerStage = (comp as Motorcontrol).power_stage
		val vbus_voltage_reading = powerStage.bus_voltage_sensing.bus_voltage_sensing_enable 
		val topology = powerStage.current_sensing.current_reading_topology
		val pfc_enable = powerStage.pfc_power_factor_correction_.power_factor_correction_enable
		val hs_complemented = powerStage.phase_drivers.complemented_from_high_side

		// motor 2 settings
		val boolean dualmotor = false
		val boolean positioncontrol2 = false
		val boolean vbus_voltage_reading2 = false;
		val main_sel2 = 0;
		val aux_sel2 = 0;
		val boolean en_aux_sel2 =false
		val topology2 = 0;
		val boolean fw_enable2 = false
		val boolean ff_enable2 = false
		val main_encoder_ic_filter2 = 0;
		val aux_encoder_ic_filter2 = 0;
		val main_hall_ic_filter2 = 0;
		val aux_hall_ic_filter2 = 0;
		val main_enc_tim_module2 =0;
		val aux_enc_tim_module2 = 0;
		val main_hall_tim_module2 =0;
		val aux_hall_tim_module2 = 0;
		val hs_complemented2 = Complementedfromhighside_enum.DISABLE;

	 '''
		/****************************************************************************
		*
		* Copyright (c) 2023 STMicroelectronics - All Rights Reserved
		*
		* License terms: STMicroelectronics Proprietary in accordance with licensing
		* terms SLA0098 at www.st.com.
		*
		* THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
		* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
		*
		*****************************************************************************/
		/*
		* @file    parameters_conversion.h
		* @author  Motor Control SDK Team, ST Microelectronics
		* @brief   This file includes the proper Parameter conversion on the base
		*          of stdlib for the first drive
		*/

		/* Define to prevent recursive inclusion -------------------------------------*/
		#ifndef __PARAMETERS_CONVERSION_H
		#define __PARAMETERS_CONVERSION_H

		#include "mc_math.h"
		#include "parameters_conversion_SR5E1.h"
		#include "pmsm_motor_parameters.h"
		#include "drive_parameters.h"
		#include "power_stage_parameters.h"

		#define ADC_REFERENCE_VOLTAGE  «mcu_supply»

		/************************* CONTROL FREQUENCIES & DELAIES **********************/
		#define TF_REGULATION_RATE 	(uint32_t) ((uint32_t)(PWM_FREQUENCY)/(REGULATION_EXECUTION_RATE))

		/* TF_REGULATION_RATE_SCALED is TF_REGULATION_RATE divided by PWM_FREQ_SCALING to allow more dynamic */ 
		#define TF_REGULATION_RATE_SCALED (uint16_t) ((uint32_t)(PWM_FREQUENCY)/(REGULATION_EXECUTION_RATE*PWM_FREQ_SCALING))

		/* DPP_CONV_FACTOR is introduce to compute the right DPP with TF_REGULATOR_SCALED  */
		#define DPP_CONV_FACTOR (65536/PWM_FREQ_SCALING) 

		#define REP_COUNTER 			(uint16_t) ((REGULATION_EXECUTION_RATE *2u)-1u)

		#define SYS_TICK_FREQUENCY          2000
		#define UI_TASK_FREQUENCY_HZ        10
		#define SERIAL_COM_TIMEOUT_INVERSE  25
		#define SERIAL_COM_ATR_TIME_MS      20

		«IF(positioncontrol1)»
		 #define MEDIUM_FREQUENCY_TASK_RATE	(uint16_t)POSITION_LOOP_FREQUENCY_HZ
 
		 #define INRUSH_CURRLIMIT_DELAY_COUNTS  (uint16_t)(INRUSH_CURRLIMIT_DELAY_MS * \
		                                   ((uint16_t)POSITION_LOOP_FREQUENCY_HZ)/1000u -1u)
 
		 #define MF_TASK_OCCURENCE_TICKS  (SYS_TICK_FREQUENCY/POSITION_LOOP_FREQUENCY_HZ)-1u
		«ELSE»
		 #define MEDIUM_FREQUENCY_TASK_RATE	(uint16_t)SPEED_LOOP_FREQUENCY_HZ
 
		 #define INRUSH_CURRLIMIT_DELAY_COUNTS  (uint16_t)(INRUSH_CURRLIMIT_DELAY_MS * \
		                                   ((uint16_t)SPEED_LOOP_FREQUENCY_HZ)/1000u -1u)
 
		 #define MF_TASK_OCCURENCE_TICKS  (SYS_TICK_FREQUENCY/SPEED_LOOP_FREQUENCY_HZ)-1u
		«ENDIF»

		#define UI_TASK_OCCURENCE_TICKS  (SYS_TICK_FREQUENCY/UI_TASK_FREQUENCY_HZ)-1u
		#define SERIALCOM_TIMEOUT_OCCURENCE_TICKS (SYS_TICK_FREQUENCY/SERIAL_COM_TIMEOUT_INVERSE)-1u
		#define SERIALCOM_ATR_TIME_TICKS (uint16_t)(((SYS_TICK_FREQUENCY * SERIAL_COM_ATR_TIME_MS) / 1000u) - 1u)

		«IF(dualmotor)»
		 #define TF_REGULATION_RATE2 	(uint32_t) ((uint32_t)(PWM_FREQUENCY2)/REGULATION_EXECUTION_RATE2)
 
		 /* TF_REGULATION_RATE_SCALED2 is TF_REGULATION_RATE2 divided by PWM_FREQ_SCALING2 to allow more dynamic */ 
		 #define TF_REGULATION_RATE_SCALED2 (uint16_t) ((uint32_t)(PWM_FREQUENCY2)/(REGULATION_EXECUTION_RATE2*PWM_FREQ_SCALING2))
 
		 /* DPP_CONV_FACTOR2 is introduce to compute the right DPP with TF_REGULATOR_SCALED2  */
		 #define DPP_CONV_FACTOR2 (65536/PWM_FREQ_SCALING2) 
 
		 #define REP_COUNTER2 			(uint16_t) ((REGULATION_EXECUTION_RATE2 *2u)-1u)
 
		 «IF(positioncontrol2)»
		  #define MEDIUM_FREQUENCY_TASK_RATE2	(uint16_t)POSITION_LOOP_FREQUENCY_HZ2
  
		  #define INRUSH_CURRLIMIT_DELAY_COUNTS2  (uint16_t)(INRUSH_CURRLIMIT_DELAY_MS2 * \
		                                    ((uint16_t)POSITION_LOOP_FREQUENCY_HZ2)/1000u -1u)
  
		 «ELSE»
		  #define MEDIUM_FREQUENCY_TASK_RATE2	(uint16_t)SPEED_LOOP_FREQUENCY_HZ2
  
		  #define INRUSH_CURRLIMIT_DELAY_COUNTS2  (uint16_t)(INRUSH_CURRLIMIT_DELAY_MS2 * \
		                                    ((uint16_t)SPEED_LOOP_FREQUENCY_HZ2)/1000u -1u)
		 «ENDIF»
 
		  #define MF_TASK_OCCURENCE_TICKS2  (SYS_TICK_FREQUENCY/MEDIUM_FREQUENCY_TASK_RATE2)-1u
		«ENDIF»
   	    #define MAX_APPLICATION_SPEED_UNIT ((MAX_APPLICATION_SPEED_RPM*SPEED_UNIT)/_RPM)
		#define MIN_APPLICATION_SPEED_UNIT ((MIN_APPLICATION_SPEED_RPM*SPEED_UNIT)/_RPM)
		#if (NOMINAL_BUS_VOLTAGE_V >= 500 )
		#define MAX_MEASURABLE_VOLTAGE 1498 /* Max Voltage for High Voltage Traction Inverter */
		#else
		#define MAX_MEASURABLE_VOLTAGE 500  /* Max Voltage for Low Voltage Inverter */
		#endif
		#if (VBUS_VOLTAGE_ENABLE == TRUE)
		/*max phase voltage, 0-peak Volts*/
		#define MAX_VOLTAGE (int16_t)((ADC_REFERENCE_VOLTAGE/SQRT_3)/VBUS_PARTITIONING_FACTOR)
		#else
		#define MAX_VOLTAGE (int16_t)(MAX_MEASURABLE_VOLTAGE/2) /* Virtual sensor conversion factor */
		#endif        

		«IF(main_sel === SensorSelection_enum.OBSERVER_CORDIC || aux_sel === SensorSelection_enum.OBSERVER_CORDIC || main_sel === SensorSelection_enum.OBSERVER_PLL|| aux_sel === SensorSelection_enum.OBSERVER_PLL)»
		 /************************* COMMON OBSERVER PARAMETERS **************************/
		 #define MAX_BEMF_VOLTAGE  (uint16_t)((MAX_APPLICATION_SPEED_RPM * 1.2 *\
		                            MOTOR_VOLTAGE_CONSTANT*SQRT_2)/(1000u*SQRT_3)) 
		 «IF(topology == CurrentReadingTopology_enum.TWO_INSULATED_CURRENT_SENSORS)»
		  #define MAX_CURRENT (ADC_REFERENCE_VOLTAGE/(2*AMPLIFICATION_GAIN))
		 «ELSE»
		  #define MAX_CURRENT (ADC_REFERENCE_VOLTAGE/(2*RSHUNT*AMPLIFICATION_GAIN))
		 «ENDIF»
		 #define OBS_MINIMUM_SPEED_UNIT    (uint16_t) ((OBS_MINIMUM_SPEED_RPM*SPEED_UNIT)/_RPM)  
 
		 «IF(main_sel === SensorSelection_enum.OBSERVER_PLL|| aux_sel === SensorSelection_enum.OBSERVER_PLL)»
		  /************************* PLL PARAMETERS **************************/
		  #define C1 (int32_t)((((int16_t)F1)*RS)/(LS*TF_REGULATION_RATE))
		  #define C2 (int32_t) GAIN1
		  #define C3 (int32_t)((((int16_t)F1)*MAX_BEMF_VOLTAGE)/(LS*MAX_CURRENT*TF_REGULATION_RATE))
		  #define C4 (int32_t) GAIN2
		  #define C5 (int32_t)((((int16_t)F1)*MAX_VOLTAGE)/(LS*MAX_CURRENT*TF_REGULATION_RATE))
  
		  #define PERCENTAGE_FACTOR    (uint16_t)(VARIANCE_THRESHOLD*128u)      
		  #define HFI_MINIMUM_SPEED    (uint16_t) (HFI_MINIMUM_SPEED_RPM/6u)
		 «ENDIF»
 
		 «IF(main_sel === SensorSelection_enum.OBSERVER_CORDIC|| aux_sel === SensorSelection_enum.OBSERVER_CORDIC)»
     /*********************** OBSERVER + CORDIC PARAMETERS *************************/
		  #define CORD_C1 (int32_t)((((int16_t)CORD_F1)*RS)/(LS*TF_REGULATION_RATE))
		  #define CORD_C2 (int32_t) CORD_GAIN1
		  #define CORD_C3 (int32_t)((((int16_t)CORD_F1)*MAX_BEMF_VOLTAGE)/(LS*MAX_CURRENT\
		                                                             *TF_REGULATION_RATE))
		  #define CORD_C4 (int32_t) CORD_GAIN2
		  #define CORD_C5 (int32_t)((((int16_t)CORD_F1)*MAX_VOLTAGE)/(LS*MAX_CURRENT*\
		                                                            TF_REGULATION_RATE))
		  #define CORD_PERCENTAGE_FACTOR    (uint16_t)(CORD_VARIANCE_THRESHOLD*128u)      
		 «ENDIF»
		«ENDIF»

		«IF(dualmotor)»
		 «IF(main_sel2 === SensorSelection_enum.OBSERVER_CORDIC.value || aux_sel2 === SensorSelection_enum.OBSERVER_CORDIC.value || main_sel2 === SensorSelection_enum.OBSERVER_PLL.value|| aux_sel2 === SensorSelection_enum.OBSERVER_PLL.value)»
      /************************* COMMON OBSERVER PARAMETERS Motor 2 **************************/
		  #define MAX_BEMF_VOLTAGE2  (uint16_t)((MAX_APPLICATION_SPEED_RPM2 * 1.2 *\
		                             MOTOR_VOLTAGE_CONSTANT2*SQRT_2)/(1000u*SQRT_3))
		#if (NOMINAL_BUS_VOLTAGE_V2 >= 500 )
		#define MAX_MEASURABLE_VOLTAGE 1498 /* Max Voltage for High Voltage Traction Inverter */
		#else
		#define MAX_MEASURABLE_VOLTAGE 500  /* Max Voltage for Low Voltage Inverter */
		#endif  
		      
		  #define MAX_VOLTAGE (int16_t)((ADC_REFERENCE_VOLTAGE/SQRT_3)/VBUS_PARTITIONING_FACTOR)
		  #else
		  #define MAX_VOLTAGE (int16_t)(MAX_MEASURABLE_VOLTAGE/2) /* Virtual sensor conversion factor */
		  #endif              
		  «IF(topology2 === CurrentReadingTopology_enum.TWO_INSULATED_CURRENT_SENSORS.value)» 
		   #define MAX_CURRENT2 (ADC_REFERENCE_VOLTAGE/(2*AMPLIFICATION_GAIN2))
		  «ELSE»
		   #define MAX_CURRENT2 (ADC_REFERENCE_VOLTAGE/(2*RSHUNT2*AMPLIFICATION_GAIN2))
		  «ENDIF»
		  #define OBS_MINIMUM_SPEED_UNIT2        (uint16_t) ((OBS_MINIMUM_SPEED_RPM2*SPEED_UNIT)/_RPM)  
		 «ENDIF»
 
		 #define MAX_APPLICATION_SPEED_UNIT2 ((MAX_APPLICATION_SPEED_RPM2*SPEED_UNIT)/_RPM)
		 #define MIN_APPLICATION_SPEED_UNIT2 ((MIN_APPLICATION_SPEED_RPM2*SPEED_UNIT)/_RPM)
 
		 «IF(main_sel2 === SensorSelection_enum.OBSERVER_PLL.value || aux_sel2 === SensorSelection_enum.OBSERVER_PLL.value)»
		  /************************* PLL PARAMETERS **************************/
		  #define C12 (int32_t)((((int16_t)F12)*RS2)/(LS2*TF_REGULATION_RATE2))
		  #define C22 (int32_t) GAIN12
		  #define C32 (int32_t)((((int16_t)F12)*MAX_BEMF_VOLTAGE2)/(LS2*MAX_CURRENT2*TF_REGULATION_RATE2))
		  #define C42 (int32_t) GAIN22
		  #define C52 (int32_t)((((int16_t)F12)*MAX_VOLTAGE2)/(LS2*MAX_CURRENT2*TF_REGULATION_RATE2))
  
		  #define PERCENTAGE_FACTOR2    (uint16_t)(VARIANCE_THRESHOLD2*128u)      
  
		  #define HFI_MINIMUM_SPEED2        (uint16_t) (HFI_MINIMUM_SPEED_RPM2/6u)
		 «ENDIF»
 
		 «IF(main_sel2 === SensorSelection_enum.OBSERVER_CORDIC.value|| aux_sel2 === SensorSelection_enum.OBSERVER_CORDIC.value)» 
		  #define CORD_C12 (int32_t)((((int16_t)CORD_F12)*RS2)/(LS2*TF_REGULATION_RATE2))
		  #define CORD_C22 (int32_t) CORD_GAIN12
		  #define CORD_C32 (int32_t)((((int16_t)CORD_F12)*MAX_BEMF_VOLTAGE2)/(LS2*MAX_CURRENT2\
		                                                             *TF_REGULATION_RATE2))
		  #define CORD_C42 (int32_t) CORD_GAIN22
		  #define CORD_C52 (int32_t)((((int16_t)CORD_F12)*MAX_VOLTAGE2)/(LS2*MAX_CURRENT2*\
		                                                            TF_REGULATION_RATE2))
		  #define CORD_PERCENTAGE_FACTOR2    (uint16_t)(CORD_VARIANCE_THRESHOLD2*128u)      
		 «ENDIF»
		«ENDIF»

		/**************************   VOLTAGE CONVERSIONS  Motor 1 *************************/
		#define OVERVOLTAGE_THRESHOLD_d   (uint16_t)(OV_VOLTAGE_THRESHOLD_V*65535/\
		                                  (ADC_REFERENCE_VOLTAGE/VBUS_PARTITIONING_FACTOR))
		#define UNDERVOLTAGE_THRESHOLD_d  (uint16_t)((UD_VOLTAGE_THRESHOLD_V*65535)/\
		                                  ((uint16_t)(ADC_REFERENCE_VOLTAGE/\
		                                                           VBUS_PARTITIONING_FACTOR)))
		#define INT_SUPPLY_VOLTAGE          (uint16_t)(65536/ADC_REFERENCE_VOLTAGE)

		#define DELTA_TEMP_THRESHOLD        (OV_TEMPERATURE_THRESHOLD_C- T0_C)
		#define DELTA_V_THRESHOLD           (dV_dT * DELTA_TEMP_THRESHOLD)
		#define OV_TEMPERATURE_THRESHOLD_d  ((V0_V + DELTA_V_THRESHOLD)*INT_SUPPLY_VOLTAGE)

		#define DELTA_TEMP_HYSTERESIS        (OV_TEMPERATURE_HYSTERESIS_C)
		#define DELTA_V_HYSTERESIS           (dV_dT * DELTA_TEMP_HYSTERESIS)
		#define OV_TEMPERATURE_HYSTERESIS_d  (DELTA_V_HYSTERESIS*INT_SUPPLY_VOLTAGE)
		«IF(dualmotor)»
		 /**************************   VOLTAGE CONVERSIONS  Motor 2 *************************/
		 #define OVERVOLTAGE_THRESHOLD_d2   (uint16_t)(OV_VOLTAGE_THRESHOLD_V2*65535/\
		                                   (ADC_REFERENCE_VOLTAGE/VBUS_PARTITIONING_FACTOR2))
		 #define UNDERVOLTAGE_THRESHOLD_d2  (uint16_t)((UD_VOLTAGE_THRESHOLD_V2*65535)/\
		                                   ((uint16_t)(ADC_REFERENCE_VOLTAGE/\
		                                                            VBUS_PARTITIONING_FACTOR2)))
		 #define INT_SUPPLY_VOLTAGE2          (uint16_t)(65536/ADC_REFERENCE_VOLTAGE)
 
		 #define DELTA_TEMP_THRESHOLD2        (OV_TEMPERATURE_THRESHOLD_C2- T0_C2)
		 #define DELTA_V_THRESHOLD2           (dV_dT2 * DELTA_TEMP_THRESHOLD2)
		 #define OV_TEMPERATURE_THRESHOLD_d2  ((V0_V2 + DELTA_V_THRESHOLD2)*INT_SUPPLY_VOLTAGE2)
 
		 #define DELTA_TEMP_HYSTERESIS2        (OV_TEMPERATURE_HYSTERESIS_C2)
		 #define DELTA_V_HYSTERESIS2           (dV_dT2 * DELTA_TEMP_HYSTERESIS2)
		 #define OV_TEMPERATURE_HYSTERESIS_d2  (DELTA_V_HYSTERESIS2*INT_SUPPLY_VOLTAGE2)
		«ENDIF»
		


		«IF(main_sel === SensorSelection_enum.QUADRATURE_ENCODER|| aux_sel === SensorSelection_enum.QUADRATURE_ENCODER)»
		 /*************** Encoder Alignemnt ************************/
		 #define ALIGNMENT_ANGLE_S16      (int16_t)  (ALIGNMENT_ANGLE_DEG*65536u/360u)
		«ENDIF»
		«IF(main_sel2 === SensorSelection_enum.QUADRATURE_ENCODER.value|| aux_sel2 === SensorSelection_enum.QUADRATURE_ENCODER.value)»    
		 #define ALIGNMENT_ANGLE_S162      (int16_t)  (ALIGNMENT_ANGLE_DEG2*65536u/360u)
		«ENDIF»

		/*************** Timer for PWM generation & currenst sensing parameters  ******/
		#define PWM_PERIOD_CYCLES (uint16_t)((ADV_TIM_CLK_MHz*(uint32_t)1000000u/((uint32_t)(PWM_FREQUENCY)))&0xFFFE)

		«IF(dualmotor)»
		 #define PWM_PERIOD_CYCLES2 (uint16_t)((ADV_TIM_CLK_MHz2*(uint32_t)1000000u/((uint32_t)(PWM_FREQUENCY2)))&0xFFFE)
		«ENDIF»

		«IF( hs_complemented === Complementedfromhighside_enum.ENABLE)»
		#define DEADTIME_NS  HW_DEAD_TIME_NS
		«ELSE»
		#define DEADTIME_NS  SW_DEADTIME_NS
		«ENDIF»


		«IF(dualmotor)»
		«IF( hs_complemented2 === Complementedfromhighside_enum.ENABLE)»
		#define DEADTIME_NS2  HW_DEAD_TIME_NS2
		«ELSE»
		#define DEADTIME_NS2  SW_DEADTIME_NS2
		«ENDIF»
		«ENDIF»

		#define DEAD_TIME_ADV_TIM_CLK_MHz (ADV_TIM_CLK_MHz * TIM_CLOCK_DIVIDER)
		#define DEAD_TIME_COUNTS_1  (DEAD_TIME_ADV_TIM_CLK_MHz * DEADTIME_NS/1000uL)

		#if (DEAD_TIME_COUNTS_1 <= 255)
		#define DEAD_TIME_COUNTS (uint16_t) DEAD_TIME_COUNTS_1
		#elif (DEAD_TIME_COUNTS_1 <= 508)
		#define DEAD_TIME_COUNTS (uint16_t)(((DEAD_TIME_ADV_TIM_CLK_MHz * DEADTIME_NS/2) /1000uL) + 128)
		#elif (DEAD_TIME_COUNTS_1 <= 1008)
		#define DEAD_TIME_COUNTS (uint16_t)(((DEAD_TIME_ADV_TIM_CLK_MHz * DEADTIME_NS/8) /1000uL) + 320)
		#elif (DEAD_TIME_COUNTS_1 <= 2015)
		#define DEAD_TIME_COUNTS (uint16_t)(((DEAD_TIME_ADV_TIM_CLK_MHz * DEADTIME_NS/16) /1000uL) + 384)
		#else
		#define DEAD_TIME_COUNTS 510
		#endif
		«IF(dualmotor)»
		 #define DEAD_TIME_ADV_TIM_CLK_MHz2 (ADV_TIM_CLK_MHz2 * TIM_CLOCK_DIVIDER2)
		 #define DEAD_TIME_COUNTS2_1  (DEAD_TIME_ADV_TIM_CLK_MHz2 * DEADTIME_NS2/1000uL)
 
		 #if (DEAD_TIME_COUNTS2_1 <= 255)
		 #define DEAD_TIME_COUNTS2 (uint16_t) DEAD_TIME_COUNTS2_1
		 #elif (DEAD_TIME_COUNTS2_1 <= 508)
		 #define DEAD_TIME_COUNTS2 (uint16_t)(((DEAD_TIME_ADV_TIM_CLK_MHz2 * DEADTIME_NS2/2) /1000uL) + 128)
		 #elif (DEAD_TIME_COUNTS2_1 <= 1008)
		 #define DEAD_TIME_COUNTS2 (uint16_t)(((DEAD_TIME_ADV_TIM_CLK_MHz2 * DEADTIME_NS2/8) /1000uL) + 320)
		 #elif (DEAD_TIME_COUNTS2_1 <= 2015)
		 #define DEAD_TIME_COUNTS2 (uint16_t)(((DEAD_TIME_ADV_TIM_CLK_MHz2 * DEADTIME_NS2/16) /1000uL) + 384)
		 #else
		 #define DEAD_TIME_COUNTS2 510
		 #endif
		«ENDIF»

		#define DTCOMPCNT (uint16_t)((DEADTIME_NS * ADV_TIM_CLK_MHz) / 2000)
		#define TON_NS  500
		#define TOFF_NS 500
		#define TON  (uint16_t)((TON_NS * ADV_TIM_CLK_MHz)  / 2000)
		#define TOFF (uint16_t)((TOFF_NS * ADV_TIM_CLK_MHz) / 2000)
		«IF(dualmotor)»
		 #define DTCOMPCNT2 (uint16_t)((DEADTIME_NS2 * ADV_TIM_CLK_MHz2) / 2000)
		 #define TON_NS2  500
		 #define TOFF_NS2 500
		 #define TON2  (uint16_t)((TON_NS2 * ADV_TIM_CLK_MHz2)  / 2000)
		 #define TOFF2 (uint16_t)((TOFF_NS2 * ADV_TIM_CLK_MHz2) / 2000)
		«ENDIF»
		/**********************/
		/* MOTOR 1 ADC Timing */
		/**********************/
		#define SAMPLING_TIME ((ADC_SAMPLING_CYCLES * ADV_TIM_CLK_MHz) / ADC_CLK_MHz) /* In ADV_TIMER CLK cycles*/
		«IF(topology === CurrentReadingTopology_enum.ONE_SHUNT_RESISTOR)»
		 #define TRISE ((TRISE_NS * ADV_TIM_CLK_MHz)/1000uL)
		 #define TDEAD ((uint16_t)((DEADTIME_NS * ADV_TIM_CLK_MHz)/1000uL))
		 #define TAFTER ((uint16_t)(TDEAD + TRISE))
		 #define TBEFORE ((uint16_t)((ADC_TRIG_CONV_LATENCY_CYCLES + ADC_SAMPLING_CYCLES) * ADV_TIM_CLK_MHz) / ADC_CLK_MHz  + 1u)
		 #define TMIN ((uint16_t)( TAFTER + TBEFORE ))
		 #define HTMIN ((uint16_t)(TMIN >> 1))
		 #define CHTMIN ((uint16_t)(TMIN/(REGULATION_EXECUTION_RATE*2)))
		 #if (TRISE > SAMPLING_TIME)
		 #define MAX_TRTS (2 * TRISE)
		 #else
		 #define MAX_TRTS (2 * SAMPLING_TIME)
		 #endif
		«ELSE»
		 #define HTMIN 1 /* Required for main.c compilation only, CCR4 is overwritten at runtime */
		 #define TW_BEFORE ((uint16_t)((ADC_TRIG_CONV_LATENCY_CYCLES + ADC_SAMPLING_CYCLES) * ADV_TIM_CLK_MHz) / ADC_CLK_MHz  + 1u)
		 #define TW_BEFORE_R3_1 ((uint16_t)((ADC_TRIG_CONV_LATENCY_CYCLES + ADC_SAMPLING_CYCLES*2 + ADC_SAR_CYCLES) * ADV_TIM_CLK_MHz) / ADC_CLK_MHz  + 1u)
		 #define TW_AFTER ((uint16_t)(((DEADTIME_NS+MAX_TNTR_NS)*ADV_TIM_CLK_MHz)/1000ul))
		 #define MAX_TWAIT ((uint16_t)((TW_AFTER - SAMPLING_TIME)/2))
		«ENDIF»

		«IF(dualmotor)»
		 /**********************/
		 /* MOTOR 2 ADC Timing */
		 /**********************/
		 #define SAMPLING_TIME2 ((ADC_SAMPLING_CYCLES2 * ADV_TIM_CLK_MHz2) / ADC_CLK_MHz2) /* In ADV_TIMER2 CLK cycles*/ 
		 «IF(topology2 == CurrentReadingTopology_enum.ONE_SHUNT_RESISTOR.value)»
		  #define TRISE2 (((TRISE_NS2) * ADV_TIM_CLK_MHz2)/1000uL)
		  #define TDEAD2 ((uint16_t)((DEADTIME_NS2 * ADV_TIM_CLK_MHz2)/1000uL))
		  #define TAFTER2 ((uint16_t)( TDEAD2 + TRISE2 ))
		  #define TBEFORE2 ((uint16_t)((ADC_TRIG_CONV_LATENCY_CYCLES + ADC_SAMPLING_CYCLES2 ) * ADV_TIM_CLK_MHz2) / ADC_CLK_MHz2  + 1u)
		  #define TMIN2  (TAFTER2 + TBEFORE2)
		  #define HTMIN2 (uint16_t)(TMIN2 >> 1)
		  #define CHTMIN2 (uint16_t)(TMIN2/(REGULATION_EXECUTION_RATE2*2))
		  #if (TRISE2 > SAMPLING_TIME2)
		  #define MAX_TRTS2 (2 * TRISE2)
		  #else
		  #define MAX_TRTS2 (2 * SAMPLING_TIME2)
		  #endif
		 «ELSE»
		  #define HTMIN2 0 /* Required for main.c compilation only, CCR4 is overwritten at runtime */
		  #define TW_BEFORE2 ((uint16_t)((ADC_TRIG_CONV_LATENCY_CYCLES + ADC_SAMPLING_CYCLES2) * ADV_TIM_CLK_MHz2) / ADC_CLK_MHz2  + 1u)
		  #define TW_AFTER2 ((uint16_t)(((DEADTIME_NS2+MAX_TNTR_NS2)*ADV_TIM_CLK_MHz2)/1000ul))
		  #define MAX_TWAIT2 ((uint16_t)((TW_AFTER2 - SAMPLING_TIME2)/2))
		 «ENDIF»
		«ENDIF»

		/* USER CODE BEGIN temperature */

		#define M1_VIRTUAL_HEAT_SINK_TEMPERATURE_VALUE   25u
		#define M1_TEMP_SW_FILTER_BW_FACTOR      250u

		/* USER CODE END temperature */
		«IF(fw_enable || ff_enable)»
		 /* Flux Weakening - Feed forward */
		 #define M1_VQD_SW_FILTER_BW_FACTOR       128u
		 #define M1_VQD_SW_FILTER_BW_FACTOR_LOG LOG2(M1_VQD_SW_FILTER_BW_FACTOR)
		«ENDIF»

		«IF(dualmotor)»
		 /* USER CODE BEGIN temperature M2*/
		 #define M2_VIRTUAL_HEAT_SINK_TEMPERATURE_VALUE   25u
		 #define M2_TEMP_SW_FILTER_BW_FACTOR     250u
 
		 /* USER CODE END temperature M2*/
		 «IF(fw_enable2 || ff_enable2)»
		  /* Flux Weakening - Feed forward Motor 2*/
		  #define M2_VQD_SW_FILTER_BW_FACTOR      128u
		  #define M2_VQD_SW_FILTER_BW_FACTOR_LOG LOG2(M2_VQD_SW_FILTER_BW_FACTOR)
		 «ENDIF»
		«ENDIF»


		«IF(topology == CurrentReadingTopology_enum.TWO_INSULATED_CURRENT_SENSORS)»
		 #define PQD_CONVERSION_FACTOR (int32_t)(( 1000 * 3 * ADC_REFERENCE_VOLTAGE ) /\
		              ( 1.732 * AMPLIFICATION_GAIN ))
		«ELSE»
		 #define PQD_CONVERSION_FACTOR (int32_t)(( 1000 * 3 * ADC_REFERENCE_VOLTAGE ) /\
		              ( 1.732 * RSHUNT * AMPLIFICATION_GAIN ))
		«ENDIF»

		«IF(dualmotor)»
		 «IF(topology2 == CurrentReadingTopology_enum.TWO_INSULATED_CURRENT_SENSORS.value)»
		  #define PQD_CONVERSION_FACTOR2 (int32_t)(( 1000 * 3 * ADC_REFERENCE_VOLTAGE ) /\
		               ( 1.732 * AMPLIFICATION_GAIN2 ))
		 «ELSE»
		  #define PQD_CONVERSION_FACTOR2 (int32_t)(( 1000 * 3 * ADC_REFERENCE_VOLTAGE ) /\
		               ( 1.732 * RSHUNT2 * AMPLIFICATION_GAIN2 ))
		 «ENDIF»
		«ENDIF»

		#define USART_IRQHandler IRQ_«serialchannel.literal»_HANDLER

		/****** Prepares the UI configurations according the MCconfxx settings ********/
		«IF(com_sel=== COMSelection_enum.SERIAL)»
		 #define COM_ENABLE | OPT_COM
		«ELSE»
		 #define COM_ENABLE
		«ENDIF»

		«IF(dac_func_en)»
		 #define DAC_ENABLE | OPT_DAC
		 #define DAC_OP_ENABLE | UI_CFGOPT_DAC
		«ELSE»
		 #define DAC_ENABLE
		 #define DAC_OP_ENABLE
		«ENDIF»

		/* Motor 1 settings */
		«IF(fw_enable)»
		 #define FW_ENABLE | UI_CFGOPT_FW
		«ELSE»
		 #define FW_ENABLE
		«ENDIF»

		#define DIFFTERM_ENABLE

		«IF(dualmotor)»
		 /* Motor 2 settings */
		 «IF(fw_enable2)»
		 #define FW_ENABLE2 | UI_CFGOPT_FW
		 «ELSE»
		 #define FW_ENABLE2
		 «ENDIF»
 
		 #define DIFFTERM_ENABLE2
		«ENDIF»

		/* Sensors setting */
		«IF( main_sel===SensorSelection_enum.OBSERVER_PLL)»
		 #define MAIN_SCFG UI_SCODE_STO_PLL
		«ENDIF»

		«IF( aux_sel===SensorSelection_enum.OBSERVER_PLL && en_aux_sel)»
		 #define AUX_SCFG UI_SCODE_STO_PLL
		«ENDIF»

		«IF( main_sel===SensorSelection_enum.OBSERVER_CORDIC)»
		 #define MAIN_SCFG UI_SCODE_STO_CR
		«ENDIF»

		«IF( aux_sel===SensorSelection_enum.OBSERVER_CORDIC && en_aux_sel)»
		 #define AUX_SCFG UI_SCODE_STO_CR
		«ENDIF»

		«IF( main_sel===SensorSelection_enum.OBSERVER_HFI)»
		 #define MAIN_SCFG UI_SCODE_HFINJ
		«ENDIF»

		«IF( aux_sel===SensorSelection_enum.OBSERVER_HFI && en_aux_sel)»
		 #define AUX_SCFG UI_SCODE_HFINJ
		«ENDIF»

		«IF( main_sel===SensorSelection_enum.QUADRATURE_ENCODER)»
		 #define MAIN_SCFG UI_SCODE_ENC
		«ENDIF»

		«IF( aux_sel===SensorSelection_enum.QUADRATURE_ENCODER && en_aux_sel)»
		 #define AUX_SCFG UI_SCODE_ENC
		«ENDIF»

		«IF( main_sel===SensorSelection_enum.HALL_SENSORS)»
		 #define MAIN_SCFG UI_SCODE_HALL
		«ENDIF»

		«IF( aux_sel===SensorSelection_enum.HALL_SENSORS && en_aux_sel)»
		 #define AUX_SCFG UI_SCODE_HALL
		«ENDIF»

		«IF( main_sel===SensorSelection_enum.RESOLVER)»
		 #define MAIN_SCFG UI_SCODE_RES
		«ENDIF»

		«IF( aux_sel===SensorSelection_enum.RESOLVER && en_aux_sel)»
		 #define AUX_SCFG UI_SCODE_RES
		«ENDIF»

		«IF( aux_sel===SensorSelection_enum.EXTERNAL_SENSOR && en_aux_sel)»
		 #define AUX_SCFG 0x0
		«ENDIF»
        
        «IF(en_aux_sel == false)»
		 #define AUX_SCFG UI_SCODE_NONE
		«ENDIF»
        
		«IF(dualmotor)»
		 «IF( main_sel2 ===SensorSelection_enum.OBSERVER_PLL.value)»
		 #define MAIN_SCFG2 UI_SCODE_STO_PLL
		 «ENDIF»
 
		 «IF( aux_sel2 ===SensorSelection_enum.OBSERVER_PLL.value)»
		 #define AUX_SCFG2 UI_SCODE_STO_PLL
		 «ENDIF»
 
		 «IF( main_sel2===SensorSelection_enum.OBSERVER_CORDIC.value)»
		 #define MAIN_SCFG2 UI_SCODE_STO_CR
		 «ENDIF»
 
		 «IF( aux_sel2===SensorSelection_enum.OBSERVER_CORDIC.value)»
		 #define AUX_SCFG2 UI_SCODE_STO_CR
		 «ENDIF»
 
		 «IF( main_sel2===SensorSelection_enum.OBSERVER_HFI.value)»
		 #define MAIN_SCFG2 UI_SCODE_HFINJ
		 «ENDIF»
 
		 «IF( aux_sel2===SensorSelection_enum.OBSERVER_HFI.value)»
		 #define AUX_SCFG2 UI_SCODE_HFINJ
		 «ENDIF»
 
		 «IF( main_sel2===SensorSelection_enum.QUADRATURE_ENCODER.value)»
		 #define MAIN_SCFG2 UI_SCODE_ENC
		 «ENDIF»
 
		 «IF( aux_sel2===SensorSelection_enum.QUADRATURE_ENCODER.value)»
		 #define AUX_SCFG2 UI_SCODE_ENC
		 «ENDIF»
 
		 «IF( main_sel2===SensorSelection_enum.HALL_SENSORS.value)»
		 #define MAIN_SCFG2 UI_SCODE_HALL
		 «ENDIF»
 
		 «IF( aux_sel2===SensorSelection_enum.HALL_SENSORS.value)»
		 #define AUX_SCFG2 UI_SCODE_HALL
		 «ENDIF»
 
		 «IF( main_sel2===SensorSelection_enum.RESOLVER.value)»
		 #define MAIN_SCFG2 UI_SCODE_RES
		 «ENDIF»
 
		 «IF( aux_sel2===SensorSelection_enum.RESOLVER.value)»
		 #define AUX_SCFG2 UI_SCODE_RES
		 «ENDIF»
 
		 «IF( aux_sel2===SensorSelection_enum.EXTERNAL_SENSOR.value)»
		 #define AUX_SCFG2 0x0
		 «ENDIF»
		«ENDIF»
		
		#define PLLTUNING_ENABLE

		«IF(dualmotor)»
		#define PLLTUNING_ENABLE2
		«ENDIF»

		«IF(pfc_enable)»
		#define UI_CFGOPT_PFC_ENABLE | UI_CFGOPT_PFC
		«ELSE»
		#define UI_CFGOPT_PFC_ENABLE
		«ENDIF»

		/******************************************************************************* 
		  * UI configurations settings. It can be manually overwritten if special 
		  * configuartion is required. 
		*******************************************************************************/

		/* Specific options of UI */
		#define UI_CONFIG_M1 ( UI_CFGOPT_NONE DAC_OP_ENABLE FW_ENABLE DIFFTERM_ENABLE \
		  | (MAIN_SCFG << MAIN_SCFG_POS) | (AUX_SCFG << AUX_SCFG_POS) | UI_CFGOPT_SETIDINSPDMODE PLLTUNING_ENABLE UI_CFGOPT_PFC_ENABLE | UI_CFGOPT_PLLTUNING)

		«IF(dualmotor)»
		/* Specific options of UI, Motor 2 */
		#define UI_CONFIG_M2 ( UI_CFGOPT_NONE DAC_OP_ENABLE FW_ENABLE DIFFTERM_ENABLE2 \
		  | (MAIN_SCFG2 << MAIN_SCFG_POS) | (AUX_SCFG2 << AUX_SCFG_POS) | UI_CFGOPT_SETIDINSPDMODE PLLTUNING_ENABLE2 )
		«ELSE»
		#define UI_CONFIG_M2
		«ENDIF»

		#define DIN_ACTIVE_LOW Bit_RESET
		#define DIN_ACTIVE_HIGH Bit_SET

		#define DOUT_ACTIVE_HIGH   DOutputActiveHigh
		#define DOUT_ACTIVE_LOW    DOutputActiveLow

		«IF( main_sel===SensorSelection_enum.HALL_SENSORS)»
		/**********  AUXILIARY HALL TIMER MOTOR 1 *************/
		#define M1_HALL_TIM_PERIOD 65535
		#define M1_HALL_IC_FILTER  «main_hall_ic_filter»
		#define SPD_HALL_IRQHandler IRQ_«main_hall_tim_module.literal»_HANDLER
		«ELSE»
		«IF( (aux_sel===SensorSelection_enum.HALL_SENSORS) && (en_aux_sel) )»
		/**********  AUXILIARY HALL TIMER MOTOR 1 *************/
		#define M1_HALL_TIM_PERIOD 65535
		#define M1_HALL_IC_FILTER  «aux_hall_ic_filter»
		#define SPD_HALL_IRQHandler IRQ_«aux_hall_tim_module.literal»_HANDLER
		«ENDIF»
		«ENDIF»

		«IF( main_sel===SensorSelection_enum.QUADRATURE_ENCODER)»
		#define M1_PULSE_NBR ( (4 * (M1_ENCODER_PPR)) - 1 )
		#define M1_ENC_IC_FILTER  «main_encoder_ic_filter»  
		#define SPD_ENCODER_IRQHandler IRQ_«main_enc_tim_module.literal»_HANDLER  
		«ELSE»
		«IF( (aux_sel===SensorSelection_enum.QUADRATURE_ENCODER) && (en_aux_sel) )»
		#define M1_PULSE_NBR ( (4 * (M1_ENCODER_PPR)) - 1 )
		#define M1_ENC_IC_FILTER  «aux_encoder_ic_filter»   
		#define SPD_ENCODER_IRQHandler IRQ_«aux_enc_tim_module.literal»_HANDLER  
		«ENDIF»
		«ENDIF»

		«IF(dualmotor)»
		«IF( main_sel2 === SensorSelection_enum.HALL_SENSORS.value)»
		/**********  AUXILIARY HALL TIMER MOTOR 2 *************/
		#define M2_HALL_TIM_PERIOD 65535
		#define M2_HALL_IC_FILTER  «main_hall_ic_filter2»
		#define M2_SPD_HALL_IRQHandler IRQ_«main_hall_tim_module2»_HANDLER //main_hall_tim_module2.literal
		«ELSE»
		«IF( (aux_sel2 === SensorSelection_enum.HALL_SENSORS.value) && (en_aux_sel2) )»
		/**********  AUXILIARY HALL TIMER MOTOR 2 *************/
		#define M2_HALL_TIM_PERIOD 65535
		#define M2_HALL_IC_FILTER  «aux_hall_ic_filter2»
		#define M2_SPD_HALL_IRQHandler IRQ_«aux_hall_tim_module2»_HANDLER //aux_hall_tim_module2.literal
		«ENDIF»
		«ENDIF»

		«IF( main_sel2===SensorSelection_enum.QUADRATURE_ENCODER.value)»
		 #define M2_PULSE_NBR ( (4 * (M2_ENCODER_PPR)) - 1 )
		 #define M2_ENC_IC_FILTER  «main_encoder_ic_filter2»  
		 #define M2_SPD_ENCODER_IRQHandler IRQ_«main_enc_tim_module2»_HANDLER  //main_enc_tim_module2.literal
		«ELSE»
		 «IF( (aux_sel2===SensorSelection_enum.QUADRATURE_ENCODER.value) && (en_aux_sel) )»
		  #define M2_PULSE_NBR ( (4 * (M2_ENCODER_PPR)) - 1 )
		  #define M2_ENC_IC_FILTER  «aux_encoder_ic_filter2»   
		  #define M2_SPD_ENCODER_IRQHandler IRQ_«aux_enc_tim_module2»_HANDLER  //aux_enc_tim_module2.literal
		 «ENDIF»
		«ENDIF»
		«ENDIF»

		«IF(pfc_enable)»
		 #define PFC_ETRFILTER_IC   //${ Fx_ic_filter(MC.ETRFILTER?number) } /*TO DEFINE THE FUNCTION IN XTEND*/
		 #define PFC_SYNCFILTER_IC //${ Fx_ic_filter(MC.SYNCFILTER?number) } /*TO DEFINE THE FUNCTION IN XTEND*/
		«ENDIF»

		/* MMI Table Motor 1 MAX_MODULATION_100_PER_CENT */
		#define START_INDEX 63
		#define MAX_MODULE 32767
		#define MMITABLE  {\
		32767,32390,32146,31907,31673,31444,31220,31001,30787,30577,30371,\
		30169,29971,29777,29587,29400,29217,29037,28861,28687,28517,\
		28350,28185,28024,27865,27709,27555,27404,27256,27110,26966,\
		26824,26685,26548,26413,26280,26149,26019,25892,25767,25643,\
		25521,25401,25283,25166,25051,24937,24825,24715,24606,24498,\
		24392,24287,24183,24081,23980,23880,23782,23684,23588,23493,\
		23400,23307,23215,23125\
		}

		«IF(dualmotor)»
		 <#assign MMIvar2 = MMIfunction(_remove_last_char(MC.MAX_MODULATION_INDEX2)) >
		 /* MMI Table Motor 2 ${_remove_last_char(MC.MAX_MODULATION_INDEX2)} */
		 #define START_INDEX2     63
		 #define MAX_MODULE2      32767
		 #define MMITABLE2        {\
		 x32767,32390,32146,31907,31673,31444,31220,31001,30787,30577,30371,\
		 30169,29971,29777,29587,29400,29217,29037,28861,28687,28517,\
		 28350,28185,28024,27865,27709,27555,27404,27256,27110,26966,\
		 26824,26685,26548,26413,26280,26149,26019,25892,25767,25643,\
		 25521,25401,25283,25166,25051,24937,24825,24715,24606,24498,\
		 24392,24287,24183,24081,23980,23880,23782,23684,23588,23493,\
		 23400,23307,23215,23125\
		 }
		«ENDIF»
		
		#define SAMPLING_CYCLE_CORRECTION 0.5 /* Add half cycle required by StellarE ADC */
		#define LL_ADC_SAMPLINGTIME_1CYCLES_5 LL_ADC_SAMPLINGTIME_1CYCLE_5
		#define LL_ADC_SAMPLING_CYCLE(CYCLE) LL_ADC_SAMPLINGTIME_ ## CYCLE ## CYCLES_5

		#endif /*__PARAMETERS_CONVERSION_H*/

		/******************* (C) COPYRIGHT 2019 STMicroelectronics *****END OF FILE****/

	 '''
 
	}

	def String generateParameterSR5E1(Component comp){
		val ControlStage = (comp as Motorcontrol).control_stage

		val mcu_frq = ControlStage.mcu_supply_voltage_and_clock_frequency.cpu_clock_frequency
		val pwm_sel = ControlStage.pwm_functionality.PWM_Module
		val sysclk = mcu_frq
		val adv_tim_freq = sysclk
		val apb1_tim_freq = sysclk/2
		val apb2_tim_freq = sysclk
		val hall_tim_sel = ControlStage.hall.tim_module
		var hall_tim_freq = 0.0
		if((hall_tim_sel == TIM_moduletype_enum.TIM2) || (hall_tim_sel == TIM_moduletype_enum.TIM3)){
			hall_tim_freq = apb1_tim_freq
		}else{
			hall_tim_freq = apb2_tim_freq
		}
		

		'''
		/****************************************************************************
		 *
		 * Copyright (c) 2023 STMicroelectronics - All Rights Reserved
		 *
		 * License terms: STMicroelectronics Proprietary in accordance with licensing
		 * terms SLA0098 at www.st.com.
		 *
		 * THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
		 * INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
		 *****************************************************************************/
		 /**
		 *   @file    parameters_conversion_SR5E1.h
		 *   @version 1.1.0
		 *   @brief   This file contains the SR5E1 parameters needed for the Stellar
		 *            Motor Control.
		 *
		 *
		 */
		/* Define to prevent recursive inclusion -------------------------------------*/
		#ifndef __PARAMETERS_CONVERSION_SR5E1_H
		#define __PARAMETERS_CONVERSION_SR5E1_H

		#include "pmsm_motor_parameters.h"
		#include "drive_parameters.h"
		#include "power_stage_parameters.h"
		#include "mc_math.h"


		#define SYSCLK_FREQ       «mcu_frq.intValue»000000uL 
		#define TIM_CLOCK_DIVIDER  1
		#define ADV_TIM_CLK_MHz   «adv_tim_freq.intValue»
		#define ADC_CLK_MHz     42
		#define HALL_TIM_CLK    «hall_tim_freq.intValue»000000uL
		#define APB1TIM_FREQ    «apb1_tim_freq.intValue»000000uL

		/*************************  IRQ Handler Mapping  *********************/
		#define TIMx_UP_M1_IRQHandler IRQ_«pwm_sel.literal»_UP_HANDLER

		#define TIMx_BRK_M1_IRQHandler IRQ_«pwm_sel.literal»_BRK_HANDLER
		 
		#define IRQ_TIMx_BRK_VECTOR    IRQ_«pwm_sel.literal»_BRK_VECTOR
		                               
		#define IRQ_TIMx_UP_VECTOR     IRQ_«pwm_sel.literal»_UP_VECTOR	

		#define ADC_TRIG_CONV_LATENCY_CYCLES 3.5
		#define ADC_SAR_CYCLES 12.5

		#define M1_VBUS_SW_FILTER_BW_FACTOR     6u

		#if defined(STATE_OBSERVER_CORDIC) || defined(AUX_STATE_OBSERVER_CORDIC)
		#error "Observer Cordic sensor not available in this version"
		#endif

		#if defined(HFINJECTION) || defined(AUX_HFINJECTION)
		#error "HFINJECTION sensor not available in this version"
		#endif

		#if defined(EXTERNAL_SENSOR) || defined(AUX_EXTERNAL_SENSOR)
		#error "External sensor not available in this version"
		#endif

		#if defined(STATE_OBSERVER_PLL) && defined(AUX_STATE_OBSERVER_PLL)
		#error "Observer PLL defined as main and auxliary sensor"
		#endif

		#if defined(STATE_OBSERVER_CORDIC) && defined(AUX_STATE_OBSERVER_CORDIC)
		#error "Observer Cordic defined as main and auxliary sensor"
		#endif

		#if defined(HFINJECTION) && defined(AUX_HFINJECTION)
		#error "HFINJECTION sensor defined as main and auxliary sensor"
		#endif

		#if defined(ENCODER) && defined(AUX_ENCODER)
		#error "ENCODER sensor defined as main and auxliary sensor"
		#endif

		#if defined(HALL_SENSORS) && defined(AUX_HALL_SENSORS)
		#error "Hall sensor defined as main and auxliary sensor"
		#endif

		#if defined(RESOLVER) && defined(AUX_RESOLVER)
		#error "Resolver defined as main and auxliary sensor"
		#endif

		#if defined(EXTERNAL_SENSOR) && defined(AUX_EXTERNAL_SENSOR)
		#error "External sensor defined as main and auxliary sensor"
		#endif

		#endif /*__PARAMETERS_CONVERSION_SR5E1_H*/
		'''
	}
}