package com.st.stellar.component.motorcontrol.impl

import com.st.stellar.component.motorcontrol.Flux

import com.st.stellar.component.motorcontrol.Magneticstructure_enum
import com.st.stellar.component.motorcontrol.MMotorcontrolPackage
import org.eclipse.xtext.EcoreUtil2
import com.st.stellar.component.model.DerivedAttributeService
import com.st.stellar.component.motorcontrol.Motorcontrol
import org.eclipse.emf.ecore.EAttribute
import org.eclipse.emf.ecore.EObject
import java.util.List
import org.eclipse.emf.common.notify.Notification
import org.eclipse.emf.common.notify.impl.AdapterImpl

// This class overrides the generated class and will be instantiated by factory
class FluxImpl extends MFluxImpl implements Flux {
	
		def dependsOn(EAttribute attr, EObject source, List<EAttribute> featureIDs) {
  		 DerivedAttributeService.INSTANCE.addDependencyListener(source, attr, featureIDs)
		}
		boolean initialized = false
	
	def addDependencies() {
		
		MMotorcontrolPackage.eINSTANCE.flux_Kp.dependsOn(
			this,
			#[
				MMotorcontrolPackage.eINSTANCE.torqueandfluxregulators_Manual_editing_enabled,
				MMotorcontrolPackage.eINSTANCE.torqueandfluxregulators_Cut_off_frequency,
				MMotorcontrolPackage.eINSTANCE.torqueandfluxregulators_Execution_rate,
				MMotorcontrolPackage.eINSTANCE.electricalparameters_Lq,
				MMotorcontrolPackage.eINSTANCE.electricalparameters_Ld
			]
		)
		
		MMotorcontrolPackage.eINSTANCE.flux_Ki.dependsOn(
			this,
			#[
				MMotorcontrolPackage.eINSTANCE.torqueandfluxregulators_Manual_editing_enabled,
				MMotorcontrolPackage.eINSTANCE.torqueandfluxregulators_Cut_off_frequency,
				MMotorcontrolPackage.eINSTANCE.torqueandfluxregulators_Execution_rate,
				MMotorcontrolPackage.eINSTANCE.electricalparameters_Lq,
				MMotorcontrolPackage.eINSTANCE.electricalparameters_Ld
			]
		)
		MMotorcontrolPackage.eINSTANCE.flux_Ki_div.dependsOn(
			this,			
			#[
				MMotorcontrolPackage.eINSTANCE.torqueandfluxregulators_Manual_editing_enabled,
				MMotorcontrolPackage.eINSTANCE.torqueandfluxregulators_Cut_off_frequency,
				MMotorcontrolPackage.eINSTANCE.torqueandfluxregulators_Execution_rate,
				MMotorcontrolPackage.eINSTANCE.electricalparameters_Lq,
				MMotorcontrolPackage.eINSTANCE.electricalparameters_Ld
			]
		)
			MMotorcontrolPackage.eINSTANCE.flux_Kp_div.dependsOn(
			this,
			#[
				MMotorcontrolPackage.eINSTANCE.torqueandfluxregulators_Manual_editing_enabled,
				MMotorcontrolPackage.eINSTANCE.torqueandfluxregulators_Cut_off_frequency,
				MMotorcontrolPackage.eINSTANCE.torqueandfluxregulators_Execution_rate,
				MMotorcontrolPackage.eINSTANCE.electricalparameters_Lq,
				MMotorcontrolPackage.eINSTANCE.electricalparameters_Ld
			]
		)

	}
	
	new(){
   	this.eAdapters.add(new AdapterImpl() {
      	 override notifyChanged(Notification arg0) {
         	  if (!initialized) {
        	       initialized = true
        	       addDependencies
       		    }
      		 }
  		 });
	}
	static class InternalFlux {
		double kp
		double ki
		int kp_div
		int ki_div
	}
	static class InternalTorque {
		double kp
		int kp_div
	}
	val InternalFlux flux = new InternalFlux()
	val InternalTorque torque= new InternalTorque()
	override int getKi() {
		val root = EcoreUtil2.getRootContainer(this) as Motorcontrol
		val parent = root.drive_management.drive_settings.torque_and_flux_regulators	
		if (parent.manual_editing_enabled) {
			return super.getKi
		} else {

			calcKpKi(root)
			ki = flux.ki as int
			return ki//super.getKi
		}
	}

	override int getKi_div() {
		val root = EcoreUtil2.getRootContainer(this) as Motorcontrol
		val parent = root.drive_management.drive_settings.torque_and_flux_regulators	
		if (parent.manual_editing_enabled) {
			return super.getKi_div
		} else {
			calcKpKi(root)
			ki_div = flux.ki_div as int
			return ki_div//super.getKi_div
		}
	}

	override int getKp() {
		val root = EcoreUtil2.getRootContainer(this) as Motorcontrol
		val parent = root.drive_management.drive_settings.torque_and_flux_regulators	
		if (parent.manual_editing_enabled) {
			return super.getKp
		} else {
			calcKpKi(root)
			kp = flux.kp as int
			return kp//super.getKp
		}
	}

	override int getKp_div() {
		val root = EcoreUtil2.getRootContainer(this) as Motorcontrol
		val parent = root.drive_management.drive_settings.torque_and_flux_regulators	
		if (parent.manual_editing_enabled) {
			return super.getKp_div
		} else {
			calcKpKi(root)
			kp_div = flux.kp_div as int
			return kp_div//super.getKp_div
		}
	}
	

//	/**********************************************************************************************************/
//	/* This function calculate the value of Kp Ki and divisors for torque and flux control loop               */
//	/**********************************************************************************************************/
	def calcKpKi(Motorcontrol motorControl) {
		var vbus = motorControl.power_stage.bus_voltage_sensing.nominal_voltage
		var gain = motorControl.power_stage.current_sensing.overall_amplification_gain
		var mcu_voltage = motorControl.control_stage.mcu_supply_voltage_and_clock_frequency.mcu_supply_voltage
		var cut_off = motorControl.drive_management.drive_settings.torque_and_flux_regulators.cut_off_frequency

		/* Calculate constant AB */
		var AB = ((vbus * gain) / mcu_voltage)
		// logger.logError(AB.toString());
		var structure = motorControl.motor_settings.magnetic_structure
		var ls = motorControl.motor_settings.electrical_parameters.ls
		var lq = motorControl.motor_settings.electrical_parameters.lq

		/* Calculate inductance based on magnetic structure */
		var Leq = 0.0
		if (structure == Magneticstructure_enum.SURFACE_MOUNTED_PMSM)
			Leq = ls
		else
			Leq = lq
		Leq = Leq / 1000.0

		var tfkp = ((Leq * cut_off) / AB)
		var i = 0
		var stop = false
		for (i = 0; i < 15 && !stop; i++) {
			torque.kp_div = 1 << i
			flux.kp_div = torque.kp_div
			torque.kp = torque.kp_div * tfkp
			if ((torque.kp <= 4000.0) && (torque.kp >= 2000.0)) {
				stop = true
			}
		}

		var ld = motorControl.motor_settings.electrical_parameters.ld
		ld = ld / 1000.0f;
		
		var fkp = ((ld * cut_off) / AB);
		/* in case of internal PMSM magnetic structure */
		if (structure == Magneticstructure_enum.INTERNAL_PMSM){
			stop = false
			for (i = 0; i < 15 && !stop; i++) {
			flux.kp_div = 1 << i
			flux.kp = flux.kp_div * fkp
			  if ((flux.kp <= 4000.0) && (flux.kp >= 2000.0)) {
			    	stop = true
			  }
		    }	
		}else{
			flux.kp = torque.kp
		}		
		//println("Flux kp: "+flux_kp)

		/* Evaluation of ki for torque and flux */
		var rs = motorControl.motor_settings.electrical_parameters.rs

		var pwm_freq = motorControl.drive_management.drive_settings.pwm_generation_and_current_reading.pwm_frequency
		var rate = motorControl.drive_management.drive_settings.torque_and_flux_regulators.execution_rate.value
		/* Calculate FOC rate */
		var foc_rate = pwm_freq / rate

		/* [fki=((Rs*cut_off_freq/AB)*T)] */
		var fki = (rs * cut_off / AB) / foc_rate

		stop = false
		for (i = 0; i < 15 && !stop; i++) {
			flux.ki_div = 1 << i
			flux.ki = flux.ki_div * fki
			if ((flux.ki <= 4000.0) && (flux.ki >= 2000.0)) {
				stop = true
			}
		}
	}
}
