package com.st.stellar.component.motorcontrol.impl

import com.st.stellar.component.model.DerivedAttributeService
import com.st.stellar.component.motorcontrol.CurrentSensing
import java.util.List
import com.st.stellar.component.motorcontrol.MMotorcontrolPackage
import org.eclipse.emf.common.notify.Notification
import org.eclipse.emf.common.notify.impl.AdapterImpl
import org.eclipse.emf.ecore.EAttribute
import org.eclipse.emf.ecore.EObject
import com.st.stellar.component.motorcontrol.Amplificationselection_enum
import org.eclipse.xtext.EcoreUtil2
import com.st.stellar.component.motorcontrol.Motorcontrol

// This class overrides the generated class and will be instantiated by factory
class CurrentSensingImpl extends MCurrentSensingImpl implements CurrentSensing
{

 def dependsOn(EAttribute attr, EObject source, List<EAttribute> featureIDs) {
	 	DerivedAttributeService.INSTANCE.addDependencyListener(source, attr, featureIDs)
	 }
	 
def addDependencies() {

		MMotorcontrolPackage. eINSTANCE.currentSensing_Overall_amplification_gain.dependsOn(
			this,
			#[
				MMotorcontrolPackage.eINSTANCE.currentSensing_Amplification_network_gain,
				MMotorcontrolPackage.eINSTANCE.currentSensing_Shunt_resistor
			]
		)
		
		MMotorcontrolPackage.eINSTANCE.currentSensing_Max_readble_current.dependsOn(
			this,
			#[
				MMotorcontrolPackage.eINSTANCE.currentSensing_Amplification_network_gain,
				MMotorcontrolPackage.eINSTANCE.currentSensing_Shunt_resistor
			]
		)
		
	}
	
	boolean initialized = false
	 
	 new() {
		this.eAdapters.add(new AdapterImpl() {

			override notifyChanged(Notification arg0) {
				if (!initialized) {
					initialized = true
					addDependencies
				}
			}
		});
	}
override getOverall_amplification_gain() {
		val SR = this.shunt_resistor;
		val ANG = this.amplification_network_gain;
		val AS = this.amplification_selection;
		SR*ANG;
		/*if( AS == Amplificationselection_enum.ON_BOARD){ //uncomment when cross communication between component is on
			SR*ANG;
		}else {
			10*SR*ANG;
		}*/
	}
	
override getMax_readble_current() {
		val SR = this.shunt_resistor;
		val ANG = this.amplification_network_gain;
		val AS = this.amplification_selection;
		var OAG = 0.0;
		OAG=SR*ANG;
		/*if( AS == Amplificationselection_enum.ON_BOARD){		//uncomment when cross communication between component is on
			OAG=SR*ANG;
		}else {
			OAG=10*SR*ANG;
		}*/
		val root = EcoreUtil2.getRootContainer(this) as Motorcontrol
		var curr = 0.0;
		curr = root.control_stage.mcu_supply_voltage_and_clock_frequency.mcu_supply_voltage/(OAG*2);
		return Math.round(curr);
		
	}
}
