package com.st.stellar.component.motorcontrol.impl

import com.st.stellar.component.model.DerivedAttributeService
import java.util.List
import com.st.stellar.component.motorcontrol.BusVoltageSensing
import com.st.stellar.component.motorcontrol.Motorcontrol
import com.st.stellar.component.motorcontrol.MMotorcontrolPackage
import org.eclipse.emf.common.notify.Notification
import org.eclipse.emf.common.notify.impl.AdapterImpl
import org.eclipse.emf.ecore.EAttribute
import org.eclipse.emf.ecore.EObject
import org.eclipse.xtext.EcoreUtil2



// This class overrides the generated class and will be instantiated by factory
class BusVoltageSensingImpl extends MBusVoltageSensingImpl implements BusVoltageSensing
{
 def dependsOn(EAttribute attr, EObject source, List<EAttribute> featureIDs) {
	 	DerivedAttributeService.INSTANCE.addDependencyListener(source, attr, featureIDs)
	 }
	 
	def addDependencies() {
		MMotorcontrolPackage.eINSTANCE.busVoltageSensing_Bus_voltage_divider.dependsOn(
			this,
			#[
				MMotorcontrolPackage.eINSTANCE.busVoltageSensing_Resistor_r1,
				MMotorcontrolPackage.eINSTANCE.busVoltageSensing_Resistor_r2
			]
		)
		
		MMotorcontrolPackage.eINSTANCE.busVoltageSensing_Bus_voltage_feedback.dependsOn(
			this,
			#[
				MMotorcontrolPackage.eINSTANCE.busVoltageSensing_Resistor_r1,
				MMotorcontrolPackage.eINSTANCE.busVoltageSensing_Resistor_r2
			]
		)
		
	}
	
	boolean initialized = false
	 
	 new() {
		this.eAdapters.add(new AdapterImpl() {

			override notifyChanged(Notification arg0) {
				if (!initialized) {
					initialized = true
					addDependencies
				}
			}
		});
	}
	
	override getNominal_voltage() {
		val root =EcoreUtil2.getRootContainer(this) as Motorcontrol
		val dc_voltage_value = root.motor_settings.electrical_parameters.nominal_dc_voltage;
		return dc_voltage_value;
	}
	
	override getBus_voltage_divider() {
		val r1 = this.resistor_r1;
		val r2 = this.resistor_r2;
		return 1/(r2/(r1+r2));
		
	}
	
	
	override getBus_voltage_feedback() {
		val nom = getNominal_voltage();
		val r1 = this.resistor_r1;
		val r2 = this.resistor_r2;
		val div = 1/(r2/(r1+r2));		
		return nom/div;
	}
}
