/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.component.motorcontrol.impl;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.st.stellar.component.Component;
import com.st.stellar.component.motorcontrol.ADC_CHANNELTYPE_enum;
import com.st.stellar.component.motorcontrol.ADC_COUPLE_enum;
import com.st.stellar.component.motorcontrol.ADC_MODULETYPE_enum;
import com.st.stellar.component.motorcontrol.ADC_RESOLVER_enum;
import com.st.stellar.component.motorcontrol.Amplificationselection_enum;
import com.st.stellar.component.motorcontrol.ApplicationTask;
import com.st.stellar.component.motorcontrol.Autosettings_enum;
import com.st.stellar.component.motorcontrol.BDAC_CHANNELTYPE_enum;
import com.st.stellar.component.motorcontrol.CH1Variable_enum;
import com.st.stellar.component.motorcontrol.CH1_enum;
import com.st.stellar.component.motorcontrol.CH2Variable_enum;
import com.st.stellar.component.motorcontrol.CH2_enum;
import com.st.stellar.component.motorcontrol.COMSelection_enum;
import com.st.stellar.component.motorcontrol.CURRENTSENSING_functionality;
import com.st.stellar.component.motorcontrol.CanBaudRate_enum;
import com.st.stellar.component.motorcontrol.CanChannel_enum;
import com.st.stellar.component.motorcontrol.Complementedfromhighside_enum;
import com.st.stellar.component.motorcontrol.ControlStage;
import com.st.stellar.component.motorcontrol.Controlmode_enum;
import com.st.stellar.component.motorcontrol.CurrentReadingTopology_enum;
import com.st.stellar.component.motorcontrol.CurrentSensing;
import com.st.stellar.component.motorcontrol.DACFunctionality;
import com.st.stellar.component.motorcontrol.DAC_MODETYPE_enum;
import com.st.stellar.component.motorcontrol.DAC_TIM_CHANNELTYPE_enum;
import com.st.stellar.component.motorcontrol.DAC_TIM_MODULETYPE_enum;
import com.st.stellar.component.motorcontrol.DriveManagement;
import com.st.stellar.component.motorcontrol.DriverEnablingSignal_enum;
import com.st.stellar.component.motorcontrol.EnableMotor1GateDriverBootCapacitorsCharge_enum;
import com.st.stellar.component.motorcontrol.EnableMotor2GateDriverBootCapacitorsCharge_enum;
import com.st.stellar.component.motorcontrol.Executesensorlessalgorithmstartingfrom_enum;
import com.st.stellar.component.motorcontrol.Executionrate_enum;
import com.st.stellar.component.motorcontrol.F1_enum;
import com.st.stellar.component.motorcontrol.F2_enum;
import com.st.stellar.component.motorcontrol.HighSideDriversignalpolarity_enum;
import com.st.stellar.component.motorcontrol.HighsidePWMidlestate_enum;
import com.st.stellar.component.motorcontrol.INPUT_FILTERTYPE_enum;
import com.st.stellar.component.motorcontrol.KIdiv_enum;
import com.st.stellar.component.motorcontrol.KPdiv_enum;
import com.st.stellar.component.motorcontrol.LowSideDriversignalpolarity_enum;
import com.st.stellar.component.motorcontrol.LowsidePWMidlestate_enum;
import com.st.stellar.component.motorcontrol.Magneticstructure_enum;
import com.st.stellar.component.motorcontrol.MotorSettings;
import com.st.stellar.component.motorcontrol.Motorcontrol;
import com.st.stellar.component.motorcontrol.OVERCURRENT_BRK2_FILTERTYPE_enum;
import com.st.stellar.component.motorcontrol.OVERCURRENT_BRK2_POLARITY_enum;
import com.st.stellar.component.motorcontrol.OVERCURRENT_BRK_FILTERTYPE_enum;
import com.st.stellar.component.motorcontrol.OVERCURRENT_BRK_POLARITY_enum;
import com.st.stellar.component.motorcontrol.PLLKPdiv_enum;
import com.st.stellar.component.motorcontrol.PWM_channeltype_enum;
import com.st.stellar.component.motorcontrol.PWM_functionality;
import com.st.stellar.component.motorcontrol.PWM_moduletype_enum;
import com.st.stellar.component.motorcontrol.PhaseSensingselection_enum;
import com.st.stellar.component.motorcontrol.Polarity_enum;
import com.st.stellar.component.motorcontrol.PowerStage;
import com.st.stellar.component.motorcontrol.Poweronstate_enum;
import com.st.stellar.component.motorcontrol.RES_DMAMUX1_CHANNELTYPE_enum;
import com.st.stellar.component.motorcontrol.RES_DMAMUX2_CHANNELTYPE_enum;
import com.st.stellar.component.motorcontrol.RES_DMA_CONFIG;
import com.st.stellar.component.motorcontrol.RES_DMA_MOD_enum;
import com.st.stellar.component.motorcontrol.RES_DMA_STREAMTYPE_enum;
import com.st.stellar.component.motorcontrol.ResolverInterface;
import com.st.stellar.component.motorcontrol.Resolveranglereadingtype_enum;
import com.st.stellar.component.motorcontrol.SENSING_TIM_CHANNELTYPE_enum;
import com.st.stellar.component.motorcontrol.SensorSelection_enum;
import com.st.stellar.component.motorcontrol.Sensorsdisplacement_enum;
import com.st.stellar.component.motorcontrol.SerialBaudRate_enum;
import com.st.stellar.component.motorcontrol.SerialChannel_enum;
import com.st.stellar.component.motorcontrol.ShuntPositioning_enum;
import com.st.stellar.component.motorcontrol.SinCosSensing;
import com.st.stellar.component.motorcontrol.TIM_moduletype_enum;
import com.st.stellar.component.motorcontrol.TemperatureSensing;
import com.st.stellar.component.motorcontrol.VBUS_TEMP_CONTAINER;
import com.st.stellar.component.motorcontrol.VBUS_TEMP_MODETYPE_enum;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class MotorcontrolCodeGenerator
extends AbstractGenerator {
    @Inject
    private Provider<ResourceSet> rsp;

    public void doGenerate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
        try {
            ResourceSet resourceSet = (ResourceSet)this.rsp.get();
            Resource r = resourceSet.getResource(input.getURI(), true);
            boolean _isEmpty = r.getContents().isEmpty();
            if (_isEmpty) {
                return;
            }
            EObject _head = (EObject)IterableExtensions.head((Iterable)r.getContents());
            Component cmp = (Component)_head;
            String html_Power = this.generatePowerStageCode(cmp);
            fsa.generateFile("../code-gen/power_stage_parameters.h", (CharSequence)html_Power);
            String html_PMSM = this.generatePMSMCode(cmp);
            fsa.generateFile("../code-gen/pmsm_motor_parameters.h", (CharSequence)html_PMSM);
            String html_Drive = this.generateDriveParameterCode(cmp);
            fsa.generateFile("../code-gen/drive_parameters.h", (CharSequence)html_Drive);
            String html_McConfig = this.generateMcConfigCode(cmp);
            fsa.generateFile("../code-gen/mc_config.h", (CharSequence)html_McConfig);
            String html_PConv = this.generateParameterConversion(cmp);
            fsa.generateFile("../code-gen/parameters_conversion.h", (CharSequence)html_PConv);
            String html_PSR5E1 = this.generateParameterSR5E1(cmp);
            fsa.generateFile("../code-gen/parameters_conversion_SR5E1.h", (CharSequence)html_PSR5E1);
            try {
                IWorkspaceRoot _root = ResourcesPlugin.getWorkspace().getRoot();
                NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
                _root.refreshLocal(2, (IProgressMonitor)_nullProgressMonitor);
            }
            catch (Throwable _t) {
                if (!(_t instanceof IllegalStateException)) {
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public String generatePowerStageCode(Component comp) {
        boolean _equals_9;
        boolean _equals_8;
        String _xblockexpression = null;
        PowerStage powerStage = ((Motorcontrol)comp).getPower_stage();
        Complementedfromhighside_enum hs_complemented = powerStage.getPhase_drivers().getComplemented_from_high_side();
        HighSideDriversignalpolarity_enum h_pol = powerStage.getPhase_drivers().getHigh_side_driver_signal_polarity();
        LowSideDriversignalpolarity_enum l_pol = powerStage.getPhase_drivers().getLow_side_driver_signal_polarity();
        boolean force = powerStage.getPhase_drivers().isForce_the_same_value_for_the_drivers();
        double hw_dead_time = powerStage.getPhase_drivers().getHw_inserted_dead_time();
        boolean temperature_reading = powerStage.getTemperature_sensing().isTemperature_sensing_enable();
        HighSideDriversignalpolarity_enum hu_pol = powerStage.getPhase_drivers().getPhase_u_driver().getHigh_side_driver_signal_polarity();
        LowSideDriversignalpolarity_enum lu_pol = powerStage.getPhase_drivers().getPhase_u_driver().getLow_side_driver_signal_polarity();
        HighSideDriversignalpolarity_enum hv_pol = powerStage.getPhase_drivers().getPhase_v_driver().getHigh_side_driver_signal_polarity();
        LowSideDriversignalpolarity_enum lv_pol = powerStage.getPhase_drivers().getPhase_v_driver().getLow_side_driver_signal_polarity();
        HighSideDriversignalpolarity_enum hw_pol = powerStage.getPhase_drivers().getPhase_w_driver().getHigh_side_driver_signal_polarity();
        LowSideDriversignalpolarity_enum lw_pol = powerStage.getPhase_drivers().getPhase_w_driver().getLow_side_driver_signal_polarity();
        Polarity_enum icl_pol = powerStage.getInrush_current_limiter_shut_out().getPolarity();
        Polarity_enum db_pol = powerStage.getDissipative_brake().getPolarity();
        ControlStage control_stage = ((Motorcontrol)comp).getControl_stage();
        double mcu_supply = control_stage.getMcu_supply_voltage_and_clock_frequency().getMcu_supply_voltage();
        boolean vbus_voltage_reading = powerStage.getBus_voltage_sensing().isBus_voltage_sensing_enable();
        double vbus_over_voltage_threshold = powerStage.getBus_voltage_sensing().getMax_rated_bus_voltage();
        double vbus_under_voltage_threshold = powerStage.getBus_voltage_sensing().getMin_rated_bus_voltage();
        double vbus_resistor_R1 = powerStage.getBus_voltage_sensing().getResistor_r1();
        double vbus_resistor_R2 = powerStage.getBus_voltage_sensing().getResistor_r2();
        double v_nom = powerStage.getBus_voltage_sensing().getNominal_voltage();
        double _max_rated_bus_voltage = powerStage.getBus_voltage_sensing().getMax_rated_bus_voltage();
        double _bus_voltage_divider = powerStage.getBus_voltage_sensing().getBus_voltage_divider();
        double v_feedb_max = _max_rated_bus_voltage / _bus_voltage_divider;
        double _bus_voltage_divider_1 = powerStage.getBus_voltage_sensing().getBus_voltage_divider();
        double v_feedb = v_nom / _bus_voltage_divider_1;
        double bus_div = 1.0;
        if (vbus_voltage_reading) {
            double _divide;
            double _bus_voltage_divider_2 = powerStage.getBus_voltage_sensing().getBus_voltage_divider();
            bus_div = _divide = 1.0 / _bus_voltage_divider_2;
        } else {
            bus_div = v_nom > 500.0 ? mcu_supply / 1500.0 : mcu_supply / 500.0;
        }
        double v_meas_max = mcu_supply / bus_div;
        CurrentSensing settings = powerStage.getCurrent_sensing();
        Amplificationselection_enum amp_selection = settings.getAmplification_selection();
        CurrentReadingTopology_enum topology = settings.getCurrent_reading_topology();
        ShuntPositioning_enum pos = settings.getIcs_or_two_shunt_settings().getShunt_positioning();
        PhaseSensingselection_enum phase_select = settings.getIcs_or_two_shunt_settings().getPhase_sensing_selection();
        double shunt = settings.getShunt_resistor();
        double gain = settings.getOverall_amplification_gain();
        double rise = settings.getRise_timing();
        double noise = settings.getNoise_timing();
        ApplicationTask settingsa = powerStage.getApplication_task();
        EnableMotor1GateDriverBootCapacitorsCharge_enum charge_boot_cap_en_motor_1 = settingsa.getEnable_motor_1_gate_driver_boot_capacitors_charge();
        EnableMotor2GateDriverBootCapacitorsCharge_enum charge_boot_cap_en_motor_2 = settingsa.getEnable_motor_2_gate_driver_boot_capacitors_charge();
        int charge_boot_cap_ms_motor_1 = settingsa.getDelay_in_ms_for_motor_1_drivers_boot_capacitors_charging();
        int charge_boot_cap_ms_motor_2 = settingsa.getDelay_in_ms_for_motor_2_drivers_boot_capacitors_charging();
        int offset_calibration_ms_motor_1 = settingsa.getDelay_in_ms_for_motor_1_current_reading_offset_calibration();
        int offset_calibration_ms_motor_2 = settingsa.getDelay_in_ms_for_motor_2_current_reading_offset_calibration();
        int permanency_stop_ms_motor_1 = settingsa.getPermanency_time_in_ms_for_motor_1_in_stop_state();
        int permanency_stop_ms_motor_2 = settingsa.getPermanency_time_in_ms_for_motor_2_in_stop_state();
        TemperatureSensing settingsb = powerStage.getTemperature_sensing();
        double _temperature_sensing_v0 = settingsb.getTemperature_sensing_v0();
        double V0 = _temperature_sensing_v0 / 1000.0;
        double T0 = settingsb.getTemperature_sensing_t0();
        double _temperature_coefficient = settingsb.getTemperature_coefficient();
        double temp_coeff = _temperature_coefficient / 1000.0;
        double Tmax = settingsb.getMax_working_temperature_on_sensor();
        ControlStage controlStage_c = ((Motorcontrol)comp).getControl_stage();
        VBUS_TEMP_CONTAINER vbus_temp_c = controlStage_c.getVbus_temp_measures();
        VBUS_TEMP_MODETYPE_enum temp_mode_check = vbus_temp_c.getVbus_sensing_mode();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/****************************************************************************");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("* Copyright (c) 2023 STMicroelectronics - All Rights Reserved");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("* License terms: STMicroelectronics Proprietary in accordance with licensing");
        _builder.newLine();
        _builder.append("* terms SLA0098 at www.st.com.");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("* THIS SOFTWARE IS DISTRIBUTED \"AS IS,\" AND ALL WARRANTIES ARE DISCLAIMED,");
        _builder.newLine();
        _builder.append("* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("*****************************************************************************/");
        _builder.newLine();
        _builder.append("/*");
        _builder.newLine();
        _builder.append("*   @file    Power stage parameters.h");
        _builder.newLine();
        _builder.append("*   @version 1.1.0");
        _builder.newLine();
        _builder.append("*   @brief   This file contains Power stage parameters");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("*   @details This file contains Power stage parameters");
        _builder.newLine();
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/* Define to prevent recursive inclusion -------------------------------------*/");
        _builder.newLine();
        _builder.append("#ifndef __POWER_STAGE_PARAMETERS_H");
        _builder.newLine();
        _builder.append("#define __POWER_STAGE_PARAMETERS_H");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/************* PWM Driving signals section **************/");
        _builder.newLine();
        _builder.append("/* High side Polarity */");
        _builder.newLine();
        if (force) {
            if (h_pol == HighSideDriversignalpolarity_enum.ACTIVE_LOW) {
                _builder.append("#define PHASE_UH_POLARITY             LL_TIM_OCPOLARITY_LOW ");
                _builder.newLine();
                _builder.append("#define PHASE_VH_POLARITY             LL_TIM_OCPOLARITY_LOW ");
                _builder.newLine();
                _builder.append("#define PHASE_WH_POLARITY             LL_TIM_OCPOLARITY_LOW ");
                _builder.newLine();
            } else {
                _builder.append("#define PHASE_UH_POLARITY             LL_TIM_OCPOLARITY_HIGH ");
                _builder.newLine();
                _builder.append("#define PHASE_VH_POLARITY             LL_TIM_OCPOLARITY_HIGH");
                _builder.newLine();
                _builder.append("#define PHASE_WH_POLARITY             LL_TIM_OCPOLARITY_HIGH");
                _builder.newLine();
            }
        } else {
            if (hu_pol == HighSideDriversignalpolarity_enum.ACTIVE_HIGH) {
                _builder.append("#define PHASE_UH_POLARITY             LL_TIM_OCPOLARITY_HIGH");
                _builder.newLine();
            } else {
                _builder.append("#define PHASE_UH_POLARITY             LL_TIM_OCPOLARITY_LOW");
                _builder.newLine();
            }
            if (hv_pol == HighSideDriversignalpolarity_enum.ACTIVE_HIGH) {
                _builder.append("#define PHASE_VH_POLARITY             LL_TIM_OCPOLARITY_HIGH");
                _builder.newLine();
            } else {
                _builder.append("#define PHASE_VH_POLARITY             LL_TIM_OCPOLARITY_LOW");
                _builder.newLine();
            }
            if (hw_pol == HighSideDriversignalpolarity_enum.ACTIVE_HIGH) {
                _builder.append("#define PHASE_WH_POLARITY             LL_TIM_OCPOLARITY_HIGH");
                _builder.newLine();
            } else {
                _builder.append("#define PHASE_WH_POLARITY             LL_TIM_OCPOLARITY_LOW");
                _builder.newLine();
            }
        }
        _builder.newLine();
        _builder.append("#define HW_COMPLEMENTED_LOW_SIDE      ");
        _builder.append((Object)hs_complemented);
        _builder.append(" ");
        _builder.newLineIfNotEmpty();
        _builder.append("/* Low side Polarity */");
        _builder.newLine();
        if (force) {
            if (l_pol == LowSideDriversignalpolarity_enum.ACTIVE_LOW) {
                _builder.append("#define PHASE_UL_POLARITY             LL_TIM_OCPOLARITY_LOW ");
                _builder.newLine();
                _builder.append("#define PHASE_VL_POLARITY             LL_TIM_OCPOLARITY_LOW ");
                _builder.newLine();
                _builder.append("#define PHASE_WL_POLARITY             LL_TIM_OCPOLARITY_LOW ");
                _builder.newLine();
            } else {
                _builder.append("#define PHASE_UL_POLARITY             LL_TIM_OCPOLARITY_HIGH ");
                _builder.newLine();
                _builder.append("#define PHASE_VL_POLARITY             LL_TIM_OCPOLARITY_HIGH");
                _builder.newLine();
                _builder.append("#define PHASE_WL_POLARITY             LL_TIM_OCPOLARITY_HIGH");
                _builder.newLine();
            }
        } else {
            if (lu_pol == LowSideDriversignalpolarity_enum.ACTIVE_HIGH) {
                _builder.append("#define PHASE_UL_POLARITY             LL_TIM_OCPOLARITY_HIGH");
                _builder.newLine();
            } else {
                _builder.append("#define PHASE_UL_POLARITY             LL_TIM_OCPOLARITY_LOW");
                _builder.newLine();
            }
            if (lv_pol == LowSideDriversignalpolarity_enum.ACTIVE_HIGH) {
                _builder.append("#define PHASE_VL_POLARITY             LL_TIM_OCPOLARITY_HIGH");
                _builder.newLine();
            } else {
                _builder.append("#define PHASE_VL_POLARITY             LL_TIM_OCPOLARITY_LOW");
                _builder.newLine();
            }
            if (lw_pol == LowSideDriversignalpolarity_enum.ACTIVE_HIGH) {
                _builder.append("#define PHASE_WL_POLARITY             LL_TIM_OCPOLARITY_HIGH");
                _builder.newLine();
            } else {
                _builder.append("#define PHASE_WL_POLARITY             LL_TIM_OCPOLARITY_LOW");
                _builder.newLine();
            }
        }
        boolean _equals = Objects.equals((Object)hs_complemented, (Object)Complementedfromhighside_enum.ENABLE);
        if (_equals) {
            _builder.append("#define HW_DEAD_TIME_NS              ");
            long _round = Math.round(hw_dead_time);
            _builder.append((Object)_round);
            _builder.append(" /*!< Dead-time inserted ");
            _builder.newLineIfNotEmpty();
            _builder.append("                                              ");
            _builder.append("by HW if low side signals ");
            _builder.newLine();
            _builder.append("                                              ");
            _builder.append("are not used */");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("/********** Inrush current limiter signal section *******/");
        _builder.newLine();
        if (icl_pol == Polarity_enum.ACTIVE_HIGH) {
            _builder.append("#define INRUSH_CURR_LIMITER_POLARITY  DOUT_ACTIVE_HIGH ");
            _builder.newLine();
        } else {
            _builder.append("#define INRUSH_CURR_LIMITER_POLARITY  DOUT_ACTIVE_LOW ");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("/******* Dissipative brake driving signal section *******/");
        _builder.newLine();
        boolean _equals_1 = Objects.equals((Object)db_pol, (Object)Polarity_enum.ACTIVE_HIGH);
        if (_equals_1) {
            _builder.append("#define DISSIPATIVE_BRAKE_POLARITY    DOUT_ACTIVE_HIGH");
            _builder.newLine();
        } else {
            _builder.append("#define DISSIPATIVE_BRAKE_POLARITY    DOUT_ACTIVE_LOW");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("/*********** Bus voltage sensing section ****************/");
        _builder.newLine();
        if (vbus_voltage_reading) {
            _builder.append("/* ENABLE/DISABLE Bus voltage sensing */");
            _builder.newLine();
            _builder.append("#define VBUS_VOLTAGE_ENABLE TRUE");
            _builder.newLine();
            if (vbus_under_voltage_threshold > vbus_over_voltage_threshold) {
                _builder.append("[#stop \"Min Rated Bus Voltage (");
                _builder.append((Object)vbus_under_voltage_threshold);
                _builder.append("V) is higher than Max Rated Bus Voltage (");
                _builder.append((Object)vbus_over_voltage_threshold);
                _builder.append("V). Please update the over and under voltage values.\"]");
                _builder.newLineIfNotEmpty();
            }
            if (vbus_under_voltage_threshold == vbus_over_voltage_threshold) {
                _builder.append("[#stop \"Min Rated Bus Voltage (");
                _builder.append((Object)vbus_under_voltage_threshold);
                _builder.append("V) is equal to Max Rated Bus Voltage (");
                _builder.append((Object)vbus_over_voltage_threshold);
                _builder.append("V). Please update the over and under voltage values.\"]");
                _builder.newLineIfNotEmpty();
            }
            if (Objects.equals((Object)amp_selection, (Object)Amplificationselection_enum.BY_L9502) && Objects.equals((Object)temp_mode_check, (Object)VBUS_TEMP_MODETYPE_enum.TIM)) {
                if (v_feedb_max > 5.7) {
                    _builder.append("[#stop \"Max Bus Voltage Feedback (");
                    _builder.append((Object)v_feedb_max);
                    _builder.append("V) is higher than ADC reference voltage (ADC reference Voltage = 5.7V). Please decrease Max Rated Bus Voltage to (");
                    _builder.append((Object)v_meas_max);
                    _builder.append(") or change the value of R1 and/or R2.\"]");
                    _builder.newLineIfNotEmpty();
                }
                if (v_feedb > 5.7) {
                    _builder.append("[#stop \"Bus Voltage Feedback (");
                    _builder.append((Object)v_feedb);
                    _builder.append("V) is higher than ADC reference voltage (ADC reference Voltage = 5.7V). Please change the value of R1 and/or R2.\"]");
                    _builder.newLineIfNotEmpty();
                }
            } else {
                if (v_feedb_max > mcu_supply) {
                    _builder.append("[#stop \"Max Bus Voltage Feedback (");
                    _builder.append((Object)v_feedb_max);
                    _builder.append("V) is higher than ADC reference voltage (MCU Supply Voltage = ");
                    _builder.append((Object)mcu_supply);
                    _builder.append("V). Please decrease Max Rated Bus Voltage to (");
                    _builder.append((Object)v_meas_max);
                    _builder.append(") or change the value of R1 and/or R2.\"]");
                    _builder.newLineIfNotEmpty();
                }
                if (v_feedb > mcu_supply) {
                    _builder.append("[#stop \"Bus Voltage Feedback (");
                    _builder.append((Object)v_feedb);
                    _builder.append("V) is higher than ADC reference voltage (MCU Supply Voltage = ");
                    _builder.append((Object)mcu_supply);
                    _builder.append("V). Please change the value of R1 and/or R2.\"]");
                    _builder.newLineIfNotEmpty();
                }
            }
        } else {
            _builder.append("/* ENABLE/DISABLE Bus voltage sensing */");
            _builder.newLine();
            _builder.append("#define VBUS_VOLTAGE_ENABLE FALSE");
            _builder.newLine();
        }
        _builder.append("#define VBUS_PARTITIONING_FACTOR      ");
        String _format = String.format(Locale.ENGLISH, "%.04f", bus_div);
        _builder.append(_format);
        _builder.append(" /*!< It expresses how ");
        _builder.newLineIfNotEmpty();
        _builder.append("                                                  ");
        _builder.append("much the Vbus is attenuated  ");
        _builder.newLine();
        _builder.append("                                                  ");
        _builder.append("before being converted into ");
        _builder.newLine();
        _builder.append("                                                  ");
        _builder.append("digital value */");
        _builder.newLine();
        _builder.append("#define NOMINAL_BUS_VOLTAGE_V         ");
        long _round_1 = Math.round(v_nom);
        _builder.append((Object)_round_1);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#define VBUS_NETWORK_PULLUP_RES_OHM   ");
        long _round_2 = Math.round(vbus_resistor_R1 * 1000.0);
        _builder.append((Object)_round_2);
        _builder.newLineIfNotEmpty();
        _builder.append("#define VBUS_NETWORK_PULLDW_RES_OHM   ");
        long _round_3 = Math.round(vbus_resistor_R2 * 1000.0);
        _builder.append((Object)_round_3);
        _builder.newLineIfNotEmpty();
        _builder.append("/******** Current reading parameters section ******/");
        _builder.newLine();
        _builder.append("/*** Topology ***/");
        _builder.newLine();
        if (topology == CurrentReadingTopology_enum.ONE_SHUNT_RESISTOR) {
            _builder.append("#define SINGLE_SHUNT ");
            _builder.newLine();
        }
        if (topology == CurrentReadingTopology_enum.THREE_SHUNT_RESISTOR) {
            _builder.append("#define THREE_SHUNT");
            _builder.newLine();
        }
        if (topology == CurrentReadingTopology_enum.TWO_INSULATED_CURRENT_SENSORS) {
            _builder.append("#define ICS_SENSORS");
            _builder.newLine();
        }
        _builder.newLine();
        boolean _equals_2 = Objects.equals((Object)pos, (Object)ShuntPositioning_enum.LEGS);
        if (_equals_2) {
            _builder.append("#define ICS_SHUNT_SELECTION (ICS_SHUNT_LEGS)");
            _builder.newLine();
        } else {
            _builder.append("#define ICS_SHUNT_SELECTION (ICS_SHUNT_PHASES)");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("#define RSHUNT                        ");
        _builder.append((Object)shunt);
        _builder.append(" ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _equals_3 = Objects.equals((Object)amp_selection, (Object)Amplificationselection_enum.BY_L9907);
        if (_equals_3) {
            _builder.append("/* Amplification selected L9907 gate driver */");
            _builder.newLine();
            _builder.append("#define USE_L9907");
            _builder.newLine();
        } else {
            boolean _equals_4 = Objects.equals((Object)amp_selection, (Object)Amplificationselection_enum.BY_L9502);
            if (_equals_4) {
                _builder.append("/* Selected L9502 gate driver */");
                _builder.newLine();
                _builder.append("#define USE_L9502");
                _builder.newLine();
                _builder.append("/* L9502 ADC measurement parameters */");
                _builder.newLine();
                _builder.append("#define EXT_ADC_RES ADC_10_BIT");
                _builder.newLine();
                _builder.append("/* ADC MIN DUTY */");
                _builder.newLine();
                _builder.append("#define EXT_ADC_MIN_DUTY 0.0039f");
                _builder.newLine();
                _builder.append("/* ADC MAX DUTY */");
                _builder.newLine();
                _builder.append("#define EXT_ADC_MAX_DUTY 0.997f");
                _builder.newLine();
                _builder.newLine();
            } else {
                boolean _equals_5 = Objects.equals((Object)amp_selection, (Object)Amplificationselection_enum.BY_L9908);
                if (_equals_5) {
                    _builder.append("/* Amplification selected L9908 gate driver */");
                    _builder.newLine();
                    _builder.append("#define USE_L9908");
                    _builder.newLine();
                } else {
                    boolean _equals_6 = Objects.equals((Object)amp_selection, (Object)Amplificationselection_enum.BY_STGAP4S);
                    if (_equals_6) {
                        _builder.append("/* Selected STGAP4S gate driver */");
                        _builder.newLine();
                        _builder.append("#define USE_STGAP4S");
                        _builder.newLine();
                        _builder.append("/* STGAP4S ADC measurement parameters */");
                        _builder.newLine();
                        _builder.append("#define EXT_ADC_RES ADC_8_BIT");
                        _builder.newLine();
                        _builder.append("/* ADC MIN DUTY */");
                        _builder.newLine();
                        _builder.append("#define EXT_ADC_MIN_DUTY 0.1f");
                        _builder.newLine();
                        _builder.append("/* ADC MAX DUTY */");
                        _builder.newLine();
                        _builder.append("#define EXT_ADC_MAX_DUTY 0.9f");
                        _builder.newLine();
                        _builder.newLine();
                    }
                }
            }
        }
        _builder.append("/*  Overall Amplification gain is calculated as shunt resistor times Amplification Network Gain */");
        _builder.newLine();
        _builder.append("#define AMPLIFICATION_GAIN            ");
        _builder.append((Object)gain);
        _builder.append(" ");
        _builder.newLineIfNotEmpty();
        _builder.append("/*Current sensing on legs as configured */");
        _builder.newLine();
        boolean _equals_7 = Objects.equals((Object)phase_select, (Object)PhaseSensingselection_enum.UV);
        if (_equals_7) {
            _builder.append("#define ICS_SENSING_SELECTION (ICS_SENSING_ON_UV_PHASES)");
            _builder.newLine();
        }
        if (_equals_8 = Objects.equals((Object)phase_select, (Object)PhaseSensingselection_enum.UW)) {
            _builder.append("#define ICS_SENSING_SELECTION (ICS_SENSING_ON_UW_PHASES)");
            _builder.newLine();
        }
        if (_equals_9 = Objects.equals((Object)phase_select, (Object)PhaseSensingselection_enum.VW)) {
            _builder.append("#define ICS_SENSING_SELECTION (ICS_SENSING_ON_VW_PHASES)");
            _builder.newLine();
        }
        _builder.append("/*** Noise parameters ***/");
        _builder.newLine();
        _builder.append("#define TNOISE_NS                     ");
        long _round_4 = Math.round(noise);
        _builder.append((Object)_round_4);
        _builder.append(" ");
        _builder.newLineIfNotEmpty();
        _builder.append("#define TRISE_NS                      ");
        long _round_5 = Math.round(rise);
        _builder.append((Object)_round_5);
        _builder.append(" ");
        _builder.newLineIfNotEmpty();
        _builder.append("#define MAX_TNTR_NS TNOISE_NS ");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/************ Temperature sensing section ***************/");
        _builder.newLine();
        if (temperature_reading) {
            _builder.append("/* ENABLE/DISABLE Temperature sensing */");
            _builder.newLine();
            _builder.append("#define TEMP_VOLTAGE_ENABLE TRUE");
            _builder.newLine();
        } else {
            _builder.append("/* ENABLE/DISABLE Temperature sensing */");
            _builder.newLine();
            _builder.append("#define TEMP_VOLTAGE_ENABLE FALSE");
            _builder.newLine();
        }
        _builder.append("/* V[V]=V0+dV/dT[V/Celsius]*(T-T0)[Celsius]*/");
        _builder.newLine();
        _builder.append("#define V0_V                          ");
        _builder.append((Object)V0);
        _builder.append(" /*!< in Volts */");
        _builder.newLineIfNotEmpty();
        _builder.append("#define T0_C                          ");
        _builder.append((Object)T0);
        _builder.append(" /*!< in Celsius degrees */                                               ");
        _builder.newLineIfNotEmpty();
        _builder.append("#define dV_dT                         ");
        String _format_1 = String.format(Locale.ENGLISH, "%.03f", temp_coeff);
        _builder.append(_format_1);
        _builder.append(" /*!< V/Celsius degrees */");
        _builder.newLineIfNotEmpty();
        _builder.append("#define T_MAX                         ");
        long _round_6 = Math.round(Tmax);
        _builder.append((Object)_round_6);
        _builder.append(" /*!< Sensor measured ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t                                                       ");
        _builder.append("temperature at maximum ");
        _builder.newLine();
        _builder.append("\t\t                                                       ");
        _builder.append("power stage working ");
        _builder.newLine();
        _builder.append("\t\t                                                       ");
        _builder.append("temperature, Celsius degrees */");
        _builder.newLine();
        _builder.append("#endif /*__POWER_STAGE_PARAMETERS_H*/");
        _builder.newLine();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    public String generatePMSMCode(Component comp) {
        double max_sensing_network_cur;
        String _xblockexpression = null;
        PowerStage powerStage = ((Motorcontrol)comp).getPower_stage();
        CurrentReadingTopology_enum topology = powerStage.getCurrent_sensing().getCurrent_reading_topology();
        double overall_gain = powerStage.getCurrent_sensing().getOverall_amplification_gain();
        MotorSettings motorSettings = ((Motorcontrol)comp).getMotor_settings();
        Magneticstructure_enum magnetic = motorSettings.getMagnetic_structure();
        int num_pole = motorSettings.getElectrical_parameters().getPole_pairs();
        double max_speed = motorSettings.getElectrical_parameters().getMax_rated_speed();
        double x = motorSettings.getElectrical_parameters().getNominal_current();
        double b_emf = motorSettings.getElectrical_parameters().getBack_emfconstant();
        double Rs = motorSettings.getElectrical_parameters().getRs();
        Autosettings_enum autoset = motorSettings.getElectrical_parameters().getAutosettings();
        double y = motorSettings.getElectrical_parameters().getDemagnetizing_current();
        double _ls = motorSettings.getElectrical_parameters().getLs();
        double Ls = _ls / 1000.0;
        double _lq = motorSettings.getElectrical_parameters().getLq();
        double Lq = _lq / 1000.0;
        double _ld = motorSettings.getElectrical_parameters().getLd();
        double Ld = _ld / 1000.0;
        boolean hs = motorSettings.getSensors().isHall_sensors();
        boolean qe = motorSettings.getSensors().isQuadrature_encoder();
        boolean res = motorSettings.getSensors().isResolver();
        boolean ext = motorSettings.getSensors().isExternal_sensor();
        double res_phase_shift = motorSettings.getSensors().getResolver_phase_shift();
        Sensorsdisplacement_enum sensors_displace = motorSettings.getSensors().getSensors_displacement();
        int sensors_angle = motorSettings.getSensors().getPlacement_electrical_angle();
        int mec_pulses = motorSettings.getSensors().getPulses_per_mechanical_revolution();
        ControlStage controlStage = ((Motorcontrol)comp).getControl_stage();
        double mcu_supply = controlStage.getMcu_supply_voltage_and_clock_frequency().getMcu_supply_voltage();
        double nom_curr = x * 32767.0 * overall_gain * 2.0 / mcu_supply;
        double demag_current = 0.0;
        boolean _equals = Objects.equals((Object)autoset, (Object)Autosettings_enum.ENABLE);
        demag_current = _equals ? nom_curr : y * 32767.0 * overall_gain * 2.0 / mcu_supply;
        double temp = max_sensing_network_cur = mcu_supply / (2.0 * overall_gain);
        double ratio = Ld / Lq;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/****************************************************************************");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("* Copyright (c) 2023 STMicroelectronics - All Rights Reserved");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("* License terms: STMicroelectronics Proprietary in accordance with licensing");
        _builder.newLine();
        _builder.append("* terms SLA0098 at www.st.com.");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("* THIS SOFTWARE IS DISTRIBUTED \"AS IS,\" AND ALL WARRANTIES ARE DISCLAIMED,");
        _builder.newLine();
        _builder.append("* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("*****************************************************************************/");
        _builder.newLine();
        _builder.append("/*");
        _builder.newLine();
        _builder.append("*   @file    PMSM motor parameters.h");
        _builder.newLine();
        _builder.append("*   @version 1.1.0");
        _builder.newLine();
        _builder.append("*   @brief   This file contains motor parameters");
        _builder.newLine();
        _builder.append("*          ");
        _builder.newLine();
        _builder.append("*   @details This file contains motor parameters.");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/* Define to prevent recursive inclusion -------------------------------------*/");
        _builder.newLine();
        _builder.append("#ifndef __PMSM_MOTOR_PARAMETERS_H");
        _builder.newLine();
        _builder.append("#define __PMSM_MOTOR_PARAMETERS_H");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#define MOTOR_TYPE             PMSM");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("/***************** MOTOR ELECTRICAL PARAMETERS  ******************************/");
        _builder.newLine();
        _builder.append("#define POLE_PAIR_NUM          ");
        _builder.append((Object)num_pole);
        _builder.append("  /* Number of motor pole pairs */");
        _builder.newLineIfNotEmpty();
        _builder.append("#define RS                     ");
        _builder.append((Object)Rs);
        _builder.append("  /* Stator resistance , ohm*/");
        _builder.newLineIfNotEmpty();
        if (magnetic == Magneticstructure_enum.SURFACE_MOUNTED_PMSM) {
            _builder.append("#define LS                     ");
            String _format = String.format(Locale.ENGLISH, "%.08f", Ls);
            _builder.append(_format);
            _builder.append(" /* Stator inductance, H");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("For I-PMSM it is equal to Lq */");
            _builder.newLine();
        } else {
            _builder.append("#define LS                     ");
            _builder.append((Object)Lq);
            _builder.append("  /* Stator inductance, H");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("For I-PMSM it is equal to Lq */");
            _builder.newLine();
            if (ratio > 10.0) {
                _builder.append("/*Error created for managing these exceptions.The generation must fail*/");
                _builder.newLine();
                _builder.append("[#stop \"Typical values of  (Ld/Lq) ratio are < 1, values bigger than 1 are admitted ");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("but the ratio cannot exceed value of 10, actually is  ");
                _builder.append((Object)ratio, "\t\t");
                _builder.append("\"]");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        _builder.append("/* When using Id = 0, NOMINAL_CURRENT is utilized to saturate the output of the ");
        _builder.newLine();
        _builder.append("PID for speed regulation (i.e. reference torque). ");
        _builder.newLine();
        _builder.append("Transformation of real currents (A) into s16 format must be done accordingly with ");
        _builder.newLine();
        _builder.append("formula:");
        _builder.newLine();
        _builder.append("Phase current (s16 0-to-peak) = (Phase current (A 0-to-peak)* 32767 * Rshunt *");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t\t");
        _builder.append("*Amplifying network gain)/(MCU supply voltage/2)");
        _builder.newLine();
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#define NOMINAL_CURRENT         ");
        double _floor = Math.floor(nom_curr);
        _builder.append((Object)_floor);
        _builder.newLineIfNotEmpty();
        _builder.append("#define MOTOR_MAX_SPEED_RPM     ");
        long _round = Math.round(max_speed);
        _builder.append((Object)_round);
        _builder.append("  /*!< Maximum rated speed  */");
        _builder.newLineIfNotEmpty();
        _builder.append("#define MOTOR_VOLTAGE_CONSTANT  ");
        _builder.append((Object)b_emf);
        _builder.append(" /*!< Volts RMS ph-ph /kRPM */");
        _builder.newLineIfNotEmpty();
        if (demag_current < 0.5) {
            _builder.append("#define ID_DEMAG                ");
            long _round_1 = Math.round(demag_current);
            _builder.append((Object)_round_1);
            _builder.append("  /*!< Demagnetization current */");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("#define ID_DEMAG               -");
            long _round_2 = Math.round(demag_current);
            _builder.append((Object)_round_2);
            _builder.append(" /*!< Demagnetization current */");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        if (x > max_sensing_network_cur) {
            _builder.append("/*Error created for managing these exceptions.The generation must fail*/");
            _builder.newLine();
            _builder.newLine();
            _builder.append("[#stop \"Nominal current higher than maximum supported by sensing network(");
            _builder.append((Object)temp);
            _builder.append("A)\"]");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("/***************** MOTOR SENSORS PARAMETERS  ******************************/");
        _builder.newLine();
        _builder.append("/* Motor sensors parameters are always generated but really meaningful only ");
        _builder.newLine();
        _builder.append("if the corresponding sensor is actually present in the motor         */");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("/*** Hall sensors ***/");
        _builder.newLine();
        _builder.append("#define HALL_SENSORS_AVAILABLE  ");
        String _upperCase = Boolean.valueOf(hs).toString().toUpperCase(Locale.ENGLISH);
        _builder.append(_upperCase);
        _builder.newLineIfNotEmpty();
        _builder.append("#define HALL_SENSORS_PLACEMENT  DEGREES_");
        _builder.append((Object)sensors_displace);
        _builder.append(" /*!<Define here the  ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t");
        _builder.append("mechanical position of the sensors");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t");
        _builder.append("with reference to an electrical cycle. ");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t");
        _builder.append("It can be either DEGREES_120 or ");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t");
        _builder.append("DEGREES_60 */");
        _builder.newLine();
        boolean _equals_1 = Objects.equals((Object)sensors_displace, "60");
        if (_equals_1) {
            _builder.append("/* Error created for managing these exceptions. The generation must fail */");
            _builder.newLine();
            _builder.append("[#stop \"DEGREES_60 displacement is not available for Hall Sensor, use DEGREES_120!\"]");
            _builder.newLine();
        }
        _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        _builder.newLine();
        _builder.append("#define HALL_PHASE_SHIFT        ");
        int _intValue = Double.valueOf(Math.floor(sensors_angle)).intValue();
        _builder.append((Object)_intValue);
        _builder.append(" /*!< Define here in degrees  ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t");
        _builder.append("the electrical phase shift between ");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t");
        _builder.append("the low to high transition of ");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t");
        _builder.append("signal H1 and the maximum of ");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t");
        _builder.append("the Bemf induced on phase A */ ");
        _builder.newLine();
        _builder.append("/*** Quadrature encoder ***/ ");
        _builder.newLine();
        _builder.append("#define ENCODER_AVAILABLE       ");
        String _upperCase_1 = Boolean.valueOf(qe).toString().toUpperCase(Locale.ENGLISH);
        _builder.append(_upperCase_1);
        _builder.newLineIfNotEmpty();
        _builder.append("#define M1_ENCODER_PPR             ");
        _builder.append((Object)mec_pulses);
        _builder.append(" /*!< Number of pulses per ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t\t\t\t\t\t\t\t");
        _builder.append("revolution */");
        _builder.newLine();
        _builder.append("/*** Resolver ***/");
        _builder.newLine();
        _builder.append("#define RESOLVER_SENSORS_AVAILABLE  ");
        String _upperCase_2 = Boolean.valueOf(res).toString().toUpperCase(Locale.ENGLISH);
        _builder.append(_upperCase_2);
        _builder.newLineIfNotEmpty();
        _builder.append("#define RESOLVER_ANGLE_OFFSET_DEGREE        ");
        double _floor_1 = Math.floor(res_phase_shift);
        _builder.append((Object)_floor_1);
        _builder.append("  /*!< Define here in degrees");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t");
        _builder.append("the electrical phase shift between");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t");
        _builder.append("the Resolver Channel A and the Bemf");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t");
        _builder.append("induced on phase A*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/*** External Sensor ***/");
        _builder.newLine();
        _builder.append("#define EXTERNAL_SENSORS_AVAILABLE  ");
        String _upperCase_3 = Boolean.valueOf(ext).toString().toUpperCase(Locale.ENGLISH);
        _builder.append(_upperCase_3);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#endif /*__PMSM_MOTOR_PARAMETERS_H*/");
        _builder.newLine();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    /*
     * WARNING - void declaration
     */
    public String generateDriveParameterCode(Component comp) {
        long _round_127;
        long _round_126;
        void ff_enable;
        void fw_ki_div;
        void fw_kp_div;
        void fw_ki;
        void fw_kp;
        void v_limit;
        void fw_enable;
        void en_switch_over;
        long _round_124;
        long _round_123;
        void _floor_2;
        void final_curr_ramp;
        void _round_108;
        void _round_107;
        void _round_106;
        long _round_105;
        void _round_103;
        void _round_102;
        void _floor_1;
        void flux_curr_digit;
        void _floor;
        void torque_curr_digit;
        void _round_101;
        void _round_100;
        void _round_99;
        void _round_98;
        void _round_97;
        void _round_96;
        void _round_95;
        void _round_94;
        void _round_93;
        void _round_92;
        void _round_91;
        void _round_90;
        void _round_89;
        void _round_87;
        void _round_86;
        int _round_82;
        int _round_80;
        int _round_61;
        long _round_49;
        long _round_48;
        long _round_46;
        int _round_42;
        long _round_21;
        long _round_17;
        long _round_16;
        void loc;
        long _round_9;
        long _round_8;
        long _round_5;
        long _round_4;
        void mtpa_enable;
        void _round_1;
        void _round;
        void _builder;
        void m7;
        void m6;
        void m5;
        void m4;
        void m3;
        void m2;
        void m1;
        void Iq_array_7;
        void Id_array_7;
        void Iq_array_6;
        void Id_array_6;
        void Iq_array_5;
        void Id_array_5;
        void Iq_array_4;
        void Id_array_4;
        void Iq_array_3;
        void Id_array_3;
        void Iq_array_2;
        void Id_array_2;
        void Iq_array_1;
        void Id_array_1;
        void Iq_array_0;
        void Id_array_0;
        void _multiply_18;
        void _minus_8;
        void _sqrt_8;
        void _plus_8;
        void _pow_14;
        void _multiply_17;
        void _minus_7;
        void _sqrt_7;
        void _plus_7;
        void _pow_13;
        void _multiply_16;
        void _minus_6;
        void _sqrt_6;
        void _plus_6;
        void _pow_12;
        void _multiply_15;
        void _minus_5;
        void _sqrt_5;
        void _plus_5;
        void _pow_11;
        void _multiply_14;
        void _minus_4;
        void _sqrt_4;
        void _plus_4;
        void _pow_10;
        void _multiply_13;
        void _minus_3;
        void _sqrt_3;
        void _plus_3;
        void _pow_9;
        void _multiply_12;
        void _minus_2;
        void _sqrt_2;
        void _plus_2;
        void _pow_8;
        void _multiply_11;
        void _minus_1;
        void _sqrt_1;
        void _plus_1;
        void _pow_7;
        void root;
        void _multiply_10;
        void _pow_5;
        void _pow_6;
        void cIqmax;
        void Iqmax;
        void _minus;
        void _pow_4;
        void _pow_3;
        void Idmax;
        void cosEMax;
        void _plus;
        void _sqrt;
        void delta;
        void _multiply_9;
        void _pow;
        void _pow_2;
        void _multiply_8;
        void _pow_1;
        void cFM;
        double c1_D;
        double c1_Q;
        void _equals_9;
        void T1;
        void x5;
        void a0_for_dc;
        void norm_for_dc;
        void a0_for_hp;
        void norm_for_hp;
        void a0_for_lp;
        void norm_for_lp;
        void a1_for_notch;
        void norm_for_notch;
        int f2;
        void g2;
        void max_cur;
        void max_bemf_voltage;
        double g1;
        int f1;
        boolean exit;
        int i;
        void max_bemf_voltage_temp;
        void RL_ratio;
        void e1;
        void mcu_supply;
        double _divide_8;
        double _bus_voltage_divider;
        void controlStage;
        void _voltage_limit;
        void _multiply_7;
        void _estimated_speed_band_tolerance_lower_limit_1;
        void _multiply_6;
        void _estimated_speed_band_tolerance_upper_limit_1;
        void _multiply_5;
        void _estimated_speed_band_tolerance_lower_limit;
        void _multiply_4;
        void _estimated_speed_band_tolerance_upper_limit;
        int PWM_freq_scaling;
        String _xblockexpression = null;
        PowerStage powerStage = ((Motorcontrol)comp).getPower_stage();
        boolean vbus_voltage_reading = powerStage.getBus_voltage_sensing().isBus_voltage_sensing_enable();
        boolean temperature_reading = powerStage.getTemperature_sensing().isTemperature_sensing_enable();
        CurrentReadingTopology_enum topology = powerStage.getCurrent_sensing().getCurrent_reading_topology();
        double overall_gain = powerStage.getCurrent_sensing().getOverall_amplification_gain();
        Complementedfromhighside_enum hs_complemented = powerStage.getPhase_drivers().getComplemented_from_high_side();
        DriverEnablingSignal_enum hs_signal = powerStage.getPhase_drivers().getDriver_enabling_signal();
        double vbus = powerStage.getBus_voltage_sensing().getNominal_voltage();
        double vbus_over_voltage_threshold = powerStage.getBus_voltage_sensing().getMax_rated_bus_voltage();
        double vbus_under_voltage_threshold = powerStage.getBus_voltage_sensing().getMin_rated_bus_voltage();
        double max_temp_on_sensor = powerStage.getTemperature_sensing().getMax_working_temperature_on_sensor();
        boolean enable_hw_prot = powerStage.getTemperature_sensing().getFirmware_protection().isEnable();
        boolean use_max_working_temp = powerStage.getTemperature_sensing().getFirmware_protection().getOver_temperature().isSet_intervention_threshold_to_max_working_temperature_on_sensor();
        double over_temp_threshold = powerStage.getTemperature_sensing().getFirmware_protection().getOver_temperature().getOver_temperature_threshold();
        double temp_hysteresis = powerStage.getTemperature_sensing().getFirmware_protection().getOver_temperature().getHysteresis();
        boolean inrushcurr_enable = powerStage.getInrush_current_limiter_shut_out().isEnable_additional_features();
        Poweronstate_enum po_state = powerStage.getInrush_current_limiter_shut_out().getPower_on_state();
        int after = powerStage.getInrush_current_limiter_shut_out().getChange_state_after();
        double bus_div = 1.0;
        MotorSettings motorSettings = ((Motorcontrol)comp).getMotor_settings();
        double max_speed = motorSettings.getElectrical_parameters().getMax_rated_speed();
        boolean hs = motorSettings.getSensors().isHall_sensors();
        boolean qe = motorSettings.getSensors().isQuadrature_encoder();
        boolean ext = motorSettings.getSensors().isExternal_sensor();
        int pole = motorSettings.getElectrical_parameters().getPole_pairs();
        Magneticstructure_enum magnetic = motorSettings.getMagnetic_structure();
        double b_emf = motorSettings.getElectrical_parameters().getBack_emfconstant();
        double Rs = motorSettings.getElectrical_parameters().getRs();
        double _ls = motorSettings.getElectrical_parameters().getLs();
        double Ls = _ls / 1000.0;
        double _ld = motorSettings.getElectrical_parameters().getLd();
        double Ld = _ld / 1000.0;
        double _lq = motorSettings.getElectrical_parameters().getLq();
        double Lq = _lq / 1000.0;
        double In = motorSettings.getElectrical_parameters().getNominal_current();
        DriveManagement driveManagement = ((Motorcontrol)comp).getDrive_management();
        SensorSelection_enum main_sel = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_selection();
        boolean en_aux_sel = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().isEnable_auxiliary_sensor();
        SensorSelection_enum aux_sel = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getSensor_selection();
        double err_max = driveManagement.getSpeed_sensor_selection().getMax_measurement_number_of_errors_before_fault();
        double main_FIFO = 1.0;
        double aux_FIFO = 1.0;
        if (main_sel == SensorSelection_enum.HALL_SENSORS) {
            main_FIFO = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getHall_sensors().getHall_average_speed_fifo_depth();
            aux_FIFO = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getHall_sensors().getHall_average_speed_fifo_depth();
        } else {
            main_FIFO = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getQuadrature_encoder().getEnc_average_speed_fifo_depth();
            aux_FIFO = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getQuadrature_encoder().getEnc_average_speed_fifo_depth();
        }
        boolean main_rev = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getQuadrature_encoder().isReverse_counting_direction();
        boolean aux_rev = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getQuadrature_encoder().isReverse_counting_direction();
        double tfreg = 1.0;
        Executionrate_enum _execution_rate = driveManagement.getDrive_settings().getTorque_and_flux_regulators().getExecution_rate();
        boolean _equals = Objects.equals((Object)_execution_rate, (Object)Executionrate_enum.E1);
        if (_equals) {
            tfreg = 1.0;
        } else {
            Executionrate_enum _execution_rate_1 = driveManagement.getDrive_settings().getTorque_and_flux_regulators().getExecution_rate();
            boolean _equals_1 = Objects.equals((Object)_execution_rate_1, (Object)Executionrate_enum.E2);
            if (_equals_1) {
                tfreg = 2.0;
            } else {
                Executionrate_enum _execution_rate_2 = driveManagement.getDrive_settings().getTorque_and_flux_regulators().getExecution_rate();
                boolean _equals_2 = Objects.equals((Object)_execution_rate_2, (Object)Executionrate_enum.E3);
                if (_equals_2) {
                    tfreg = 3.0;
                } else {
                    Executionrate_enum _execution_rate_3 = driveManagement.getDrive_settings().getTorque_and_flux_regulators().getExecution_rate();
                    boolean _equals_3 = Objects.equals((Object)_execution_rate_3, (Object)Executionrate_enum.E4);
                    if (_equals_3) {
                        tfreg = 4.0;
                    } else {
                        Executionrate_enum _execution_rate_4 = driveManagement.getDrive_settings().getTorque_and_flux_regulators().getExecution_rate();
                        boolean _equals_4 = Objects.equals((Object)_execution_rate_4, (Object)Executionrate_enum.E5);
                        if (_equals_4) {
                            tfreg = 5.0;
                        }
                    }
                }
            }
        }
        double PWM_freq = driveManagement.getDrive_settings().getPwm_generation_and_current_reading().getPwm_frequency();
        for (PWM_freq_scaling = 1; PWM_freq / (double)PWM_freq_scaling > 65536.0 && PWM_freq_scaling <= 16; PWM_freq_scaling <<= 1) {
        }
        double main_shift = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getMainresolver().getDemodulation_trigger_delay();
        double main_sig_freq = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getMainresolver().getSignal_frequency();
        boolean main_pll_invert_dir = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getMainresolver().isPll_invert_direction();
        int main_res_mec_ratio = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getMainresolver().getResolver_mechanical_ratio();
        boolean main_pll_manual_editing = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getMainresolver().isPll_manual_editing_enabled();
        int main_res_KP_PLL = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getMainresolver().getPll().getKp_gain();
        String main_res_KPDIV_PLL = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getMainresolver().getPll().getKp_div().getLiteral();
        int main_res_KI_PLL = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getMainresolver().getPll().getKi_gain();
        String main_res_KIDIV_PLL = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getMainresolver().getPll().getKi_div().getLiteral();
        double main_phase_shift = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getMainresolver().getResolver_advanced_parameters().getResolver_shift();
        double main_sin_phase = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getMainresolver().getResolver_advanced_parameters().getSin_phase_channel_b();
        double main_cos_phase = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getMainresolver().getResolver_advanced_parameters().getCos_phase_channel_b();
        Resolveranglereadingtype_enum main_angle_read = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getMainresolver().getResolver_advanced_parameters().getResolver_angle_reading_type();
        double main_pole_mult = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getMainresolver().getResolver_advanced_parameters().getPole_pair_multiplier();
        double aux_shift = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getAuxresolver().getDemodulation_trigger_delay();
        double aux_sig_freq = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getAuxresolver().getSignal_frequency();
        boolean aux_pll_invert_dir = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getAuxresolver().isPll_invert_direction();
        int aux_res_mec_ratio = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getAuxresolver().getResolver_mechanical_ratio();
        boolean aux_pll_manual_editing = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getAuxresolver().isPll_manual_editing_enabled();
        int aux_res_KP_PLL = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getAuxresolver().getPll().getKp_gain();
        PLLKPdiv_enum aux_res_KPDIV_PLL = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getAuxresolver().getPll().getKp_div();
        int aux_res_KI_PLL = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getAuxresolver().getPll().getKi_gain();
        KIdiv_enum aux_res_KIDIV_PLL = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getAuxresolver().getPll().getKi_div();
        double aux_phase_shift = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getAuxresolver().getResolver_advanced_parameters().getResolver_shift();
        double aux_sin_phase = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getAuxresolver().getResolver_advanced_parameters().getSin_phase_channel_b();
        double aux_cos_phase = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getAuxresolver().getResolver_advanced_parameters().getCos_phase_channel_b();
        Resolveranglereadingtype_enum aux_angle_read = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getAuxresolver().getResolver_advanced_parameters().getResolver_angle_reading_type();
        double aux_pole_mult = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getAuxresolver().getResolver_advanced_parameters().getPole_pair_multiplier();
        double foc_rate = PWM_freq / tfreg;
        double main_var = 0.0;
        double main_depth_loop = 0.0;
        double main_depth_obs = 0.0;
        double main_emf_tol = 0.0;
        double main_emf_gain = 0.0;
        boolean main_manual = false;
        int main_G1 = 0;
        int main_G2 = 0;
        F1_enum main_F1 = F1_enum.E1;
        F2_enum main_F2 = F2_enum.E1;
        double aux_var = 0.0;
        double aux_depth_loop = 0.0;
        double aux_depth_obs = 0.0;
        double aux_emf_tol = 0.0;
        double aux_emf_gain = 0.0;
        boolean aux_manual = false;
        int aux_G1 = 0;
        int aux_G2 = 0;
        F1_enum aux_F1 = F1_enum.E1;
        F2_enum aux_F2 = F2_enum.E1;
        double aux_max_acc = 0.0;
        double main_max_acc = 0.0;
        boolean _equals_5 = Objects.equals((Object)main_sel, (Object)SensorSelection_enum.OBSERVER_PLL);
        if (_equals_5) {
            double _divide;
            double _variance_threshold = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_pll1().getVariance_threshold();
            main_var = _divide = _variance_threshold / 100.0;
            main_depth_loop = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_pll1().getAverage_speed_depth_for_speed_loop();
            main_depth_obs = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_pll1().getAverage_speed_depth_for_observer_equations();
            main_emf_tol = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_pll1().getBack_emf_consistency_tolerance();
            main_emf_gain = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_pll1().getBack_emf_consistency_gain();
            main_manual = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_pll1().isManual_editing_enabled();
            main_G1 = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_pll1().getObserver().getGain1();
            main_G2 = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_pll1().getObserver().getGain2();
            main_F1 = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_pll1().getObserver().getF1();
            main_F2 = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_pll1().getObserver().getF2();
        } else {
            boolean _equals_6 = Objects.equals((Object)main_sel, (Object)SensorSelection_enum.OBSERVER_CORDIC);
            if (_equals_6) {
                double _divide_3;
                double _divide_1;
                main_depth_loop = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_cordic1().getAverage_speed_fifo_depth_for_speed_loop();
                main_depth_obs = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_cordic1().getAverage_speed_fifo_depth_for_observer_equations();
                double _variance_threshold_1 = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_cordic1().getVariance_threshold();
                main_var = _divide_1 = _variance_threshold_1 / 100.0;
                main_emf_tol = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_cordic1().getBack_emf_consistency_tolerance();
                main_emf_gain = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_cordic1().getBack_emf_consistency_gain();
                main_manual = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_cordic1().isManual_editing_enabled();
                main_G1 = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_cordic1().getObserver().getGain1();
                main_G2 = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_cordic1().getObserver().getGain2();
                main_F1 = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_cordic1().getObserver().getF1();
                main_F2 = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_cordic1().getObserver().getF2();
                int _maximum_application_acceleration = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_cordic1().getMaximum_application_acceleration();
                int _multiply = pole * _maximum_application_acceleration;
                double _b_emf_quality_factor = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_cordic1().getB_emf_quality_factor();
                double _divide_2 = (double)_multiply / _b_emf_quality_factor;
                double _multiply_1 = _divide_2 * (65536.0 / (foc_rate * foc_rate));
                main_max_acc = _divide_3 = _multiply_1 / 6.0;
            }
        }
        boolean _equals_7 = Objects.equals((Object)aux_sel, (Object)SensorSelection_enum.OBSERVER_PLL);
        if (_equals_7) {
            double _divide_4;
            double _variance_threshold_2 = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getSensor_less_observer_and_pll2().getVariance_threshold();
            aux_var = _divide_4 = _variance_threshold_2 / 100.0;
            aux_depth_loop = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getSensor_less_observer_and_pll2().getAverage_speed_depth_for_speed_loop();
            aux_depth_obs = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getSensor_less_observer_and_pll2().getAverage_speed_depth_for_observer_equations();
            aux_emf_tol = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getSensor_less_observer_and_pll2().getBack_emf_consistency_tolerance();
            aux_emf_gain = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getSensor_less_observer_and_pll2().getBack_emf_consistency_gain();
            aux_manual = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getSensor_less_observer_and_pll2().isManual_editing_enabled();
            aux_G1 = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getSensor_less_observer_and_pll2().getObserver().getGain1();
            aux_G2 = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getSensor_less_observer_and_pll2().getObserver().getGain2();
            aux_F1 = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getSensor_less_observer_and_pll2().getObserver().getF1();
            aux_F2 = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getSensor_less_observer_and_pll2().getObserver().getF2();
        } else {
            boolean _equals_8 = Objects.equals((Object)aux_sel, (Object)SensorSelection_enum.OBSERVER_CORDIC);
            if (_equals_8) {
                double _divide_7;
                double _divide_5;
                aux_depth_loop = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getSensor_less_observer_and_cordic2().getAverage_speed_fifo_depth_for_speed_loop();
                aux_depth_obs = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getSensor_less_observer_and_cordic2().getAverage_speed_fifo_depth_for_observer_equations();
                double _variance_threshold_3 = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getSensor_less_observer_and_cordic2().getVariance_threshold();
                aux_var = _divide_5 = _variance_threshold_3 / 100.0;
                aux_emf_tol = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getSensor_less_observer_and_cordic2().getBack_emf_consistency_tolerance();
                aux_emf_gain = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getSensor_less_observer_and_cordic2().getBack_emf_consistency_gain();
                aux_manual = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getSensor_less_observer_and_cordic2().isManual_editing_enabled();
                aux_G1 = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getSensor_less_observer_and_cordic2().getObserver().getGain1();
                aux_G2 = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getSensor_less_observer_and_cordic2().getObserver().getGain2();
                aux_F1 = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getSensor_less_observer_and_cordic2().getObserver().getF1();
                aux_F2 = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getSensor_less_observer_and_cordic2().getObserver().getF2();
                int _maximum_application_acceleration_1 = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getSensor_less_observer_and_cordic2().getMaximum_application_acceleration();
                int _multiply_2 = pole * _maximum_application_acceleration_1;
                double _b_emf_quality_factor_1 = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getSensor_less_observer_and_cordic2().getB_emf_quality_factor();
                double _divide_6 = (double)_multiply_2 / _b_emf_quality_factor_1;
                double _multiply_3 = _divide_6 * (65536.0 / (foc_rate * foc_rate));
                aux_max_acc = _divide_7 = _multiply_3 / 6.0;
            }
        }
        int main_KP_PLL = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_pll1().getPll().getKp_gain();
        PLLKPdiv_enum main_KP_PLL_div = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_pll1().getPll().getKp_div();
        int main_KI_PLL = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_pll1().getPll().getKi_gain();
        KIdiv_enum main_KI_PLL_div = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_pll1().getPll().getKi_div();
        int aux_KP_PLL = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getSensor_less_observer_and_pll2().getPll().getKp_gain();
        PLLKPdiv_enum aux_KP_PLL_div = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getSensor_less_observer_and_pll2().getPll().getKp_div();
        int aux_KI_PLL = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getSensor_less_observer_and_pll2().getPll().getKi_gain();
        KIdiv_enum aux_KI_PLL_div = driveManagement.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getSensor_less_observer_and_pll2().getPll().getKi_div();
        int hfi_freq = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_hfi().getHfifrequency();
        int amplitude = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_hfi().getAmplitude();
        int kp = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_hfi().getKp();
        int ki = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_hfi().getKi();
        KPdiv_enum kp_div = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_hfi().getKp_div();
        KIdiv_enum ki_div = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_hfi().getKi_div();
        double pll_kp = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_hfi().getScan().getPll_kp();
        double pll_ki = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_hfi().getScan().getPll_ki();
        int scan_freq = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_hfi().getScan().getFrequency();
        int rotation_no = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_hfi().getScan().getRotation_number();
        int min_reliable_speed = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_hfi().getSpeed_threshold().getMinimum_reliable_speed();
        int amplitude_boost = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_hfi().getNorth_south_identification().getAmplitude_boost();
        int wait_before = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_hfi().getNorth_south_identification().getWait_before();
        int wait_after = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_hfi().getNorth_south_identification().getWait_after();
        int min_sat_diff = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_hfi().getNorth_south_identification().getMin_saturation_difference();
        boolean debug_mode = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_hfi().isDebug_mode();
        int pulse_number = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_hfi().getNorth_south_identification().getPulse_number();
        int pulses_skipped = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_hfi().getNorth_south_identification().getPulses_skipped();
        boolean revert_direction = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_hfi().isRevert_direction();
        int sto_hfi_th = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_hfi().getSpeed_threshold().getSto_hfi_threshold();
        double k_for_notch = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_hfi().getK_for_notch();
        double k_for_lp = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_hfi().getK_for_low_pass();
        double k_for_hp = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_hfi().getK_for_high_pass();
        double k_for_dc = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_hfi().getK_for_dc();
        boolean spc5_init = driveManagement.getDrive_settings().isSpc5_initialization();
        HighsidePWMidlestate_enum hs_idle = driveManagement.getDrive_settings().getPwm_generation_and_current_reading().getHigh_side_pwm_idle_state();
        double SW_dead_time = driveManagement.getDrive_settings().getPwm_generation_and_current_reading().getLow_side_signals_and_dead_time().getSw_inserted_dead_time();
        LowsidePWMidlestate_enum ls_idle = driveManagement.getDrive_settings().getPwm_generation_and_current_reading().getLow_side_signals_and_dead_time().getLow_side_pwm_idle_state();
        boolean speed_en = driveManagement.getDrive_settings().getSpeed_regulator().isMax_speed_enabled();
        double _execution_rate_5 = driveManagement.getDrive_settings().getSpeed_regulator().getExecution_rate();
        double exec_rate = 1000.0 / _execution_rate_5;
        int SP_KP = driveManagement.getDrive_settings().getSpeed_regulator().getKp();
        int SP_KI = driveManagement.getDrive_settings().getSpeed_regulator().getKi();
        int SP_KIDIV = driveManagement.getDrive_settings().getSpeed_regulator().getKi_div();
        int SP_KPDIV = driveManagement.getDrive_settings().getSpeed_regulator().getKp_div();
        double cut_off_freq = driveManagement.getDrive_settings().getTorque_and_flux_regulators().getCut_off_frequency();
        boolean man_edit = driveManagement.getDrive_settings().getTorque_and_flux_regulators().isManual_editing_enabled();
        int T_KP = driveManagement.getDrive_settings().getTorque_and_flux_regulators().getTorque().getKp();
        int T_KI = driveManagement.getDrive_settings().getTorque_and_flux_regulators().getTorque().getKi();
        int T_KIDIV = driveManagement.getDrive_settings().getTorque_and_flux_regulators().getTorque().getKi_div();
        int T_KPDIV = driveManagement.getDrive_settings().getTorque_and_flux_regulators().getTorque().getKp_div();
        int F_KP = driveManagement.getDrive_settings().getTorque_and_flux_regulators().getFlux().getKp();
        int F_KI = driveManagement.getDrive_settings().getTorque_and_flux_regulators().getFlux().getKi();
        int F_KIDIV = driveManagement.getDrive_settings().getTorque_and_flux_regulators().getFlux().getKi_div();
        int F_KPDIV = driveManagement.getDrive_settings().getTorque_and_flux_regulators().getFlux().getKp_div();
        Controlmode_enum cnt_mode = driveManagement.getDrive_settings().getDefault_settings().getControl_mode();
        double speed = driveManagement.getDrive_settings().getDefault_settings().getTarget_speed();
        double torque_curr = driveManagement.getDrive_settings().getDefault_settings().getTarget_stator_current_torque_component();
        double flux_curr = driveManagement.getDrive_settings().getDefault_settings().getTarget_stator_current_flux_component();
        int dur = driveManagement.getStartup_parameters().getEncoder_alignment_settings().getDuration();
        int align = driveManagement.getStartup_parameters().getEncoder_alignment_settings().getAlignment_electrical_angle();
        double x = driveManagement.getStartup_parameters().getEncoder_alignment_settings().getFinal_current_ramp_value();
        boolean adv = driveManagement.getStartup_parameters().getSensor_less_rev_up_settings().isEnable_advanced_profile();
        boolean align_en = driveManagement.getStartup_parameters().getSensor_less_rev_up_settings().getBasic().isInclude_alignment_before_ramp_up();
        int speed_duration = driveManagement.getStartup_parameters().getSensor_less_rev_up_settings().getBasic().getSpeed_ramp_duration();
        int speed_fin_val = driveManagement.getStartup_parameters().getSensor_less_rev_up_settings().getBasic().getSpeed_ramp_final_value();
        int align_duration = driveManagement.getStartup_parameters().getSensor_less_rev_up_settings().getBasic().getDuration();
        int align_angle = driveManagement.getStartup_parameters().getSensor_less_rev_up_settings().getBasic().getAlignment_electrical_angle();
        double y = driveManagement.getStartup_parameters().getSensor_less_rev_up_settings().getBasic().getFinal_current_ramp_value();
        double zi = driveManagement.getStartup_parameters().getSensor_less_rev_up_settings().getBasic().getCurrent_ramp_initial_value();
        double zf = driveManagement.getStartup_parameters().getSensor_less_rev_up_settings().getBasic().getCurrent_ramp_final_value();
        int ph3_duration_val = driveManagement.getStartup_parameters().getSensor_less_rev_up_settings().getBasic().getCurrent_ramp_duration();
        int adv_align_angle = driveManagement.getStartup_parameters().getSensor_less_rev_up_settings().getAdvanced_customized().getAlignment_electrical_angle();
        int ph1_duration = driveManagement.getStartup_parameters().getSensor_less_rev_up_settings().getAdvanced_customized().getPhase_1().getDuration();
        int ph1_fin_speed = driveManagement.getStartup_parameters().getSensor_less_rev_up_settings().getAdvanced_customized().getPhase_1().getFinal_speed();
        double x1 = driveManagement.getStartup_parameters().getSensor_less_rev_up_settings().getAdvanced_customized().getPhase_1().getFinal_current();
        int ph2_duration = driveManagement.getStartup_parameters().getSensor_less_rev_up_settings().getAdvanced_customized().getPhase_2().getDuration();
        int ph2_fin_speed = driveManagement.getStartup_parameters().getSensor_less_rev_up_settings().getAdvanced_customized().getPhase_2().getFinal_speed();
        double x2 = driveManagement.getStartup_parameters().getSensor_less_rev_up_settings().getAdvanced_customized().getPhase_2().getFinal_current();
        int ph3_duration = driveManagement.getStartup_parameters().getSensor_less_rev_up_settings().getAdvanced_customized().getPhase_3().getDuration();
        int ph3_fin_speed = driveManagement.getStartup_parameters().getSensor_less_rev_up_settings().getAdvanced_customized().getPhase_3().getFinal_speed();
        double x3 = driveManagement.getStartup_parameters().getSensor_less_rev_up_settings().getAdvanced_customized().getPhase_3().getFinal_current();
        int ph4_duration = driveManagement.getStartup_parameters().getSensor_less_rev_up_settings().getAdvanced_customized().getPhase_4().getDuration();
        int ph4_fin_speed = driveManagement.getStartup_parameters().getSensor_less_rev_up_settings().getAdvanced_customized().getPhase_4().getFinal_speed();
        double x4 = driveManagement.getStartup_parameters().getSensor_less_rev_up_settings().getAdvanced_customized().getPhase_4().getFinal_current();
        int n = driveManagement.getStartup_parameters().getSensor_less_rev_up_settings().getAdvanced_customized().getPhase_5().getDuration();
        int n2 = driveManagement.getStartup_parameters().getSensor_less_rev_up_settings().getAdvanced_customized().getPhase_5().getFinal_speed();
        double d = driveManagement.getStartup_parameters().getSensor_less_rev_up_settings().getAdvanced_customized().getPhase_5().getFinal_current();
        Executesensorlessalgorithmstartingfrom_enum executesensorlessalgorithmstartingfrom_enum = driveManagement.getStartup_parameters().getSensor_less_rev_up_settings().getAdvanced_customized().getExecute_sensor_less_algorithm_starting_from();
        int n3 = driveManagement.getStartup_parameters().getSensor_less_rev_up_settings().getConsecutive_successfull_start_up_output_tests();
        int n4 = driveManagement.getStartup_parameters().getSensor_less_rev_up_settings().getMinimum_start_up_output_speed();
        double d2 = driveManagement.getStartup_parameters().getSensor_less_rev_up_settings().getEstimated_speed_band_tolerance_upper_limit();
        void var266_219 = _estimated_speed_band_tolerance_upper_limit * 16.0;
        void var268_220 = _multiply_4 / 100.0;
        double d3 = driveManagement.getStartup_parameters().getSensor_less_rev_up_settings().getEstimated_speed_band_tolerance_lower_limit();
        void var272_222 = _estimated_speed_band_tolerance_lower_limit * 16.0;
        void var274_223 = _multiply_5 / 100.0;
        boolean bl = driveManagement.getStartup_parameters().getSensor_less_rev_up_settings().getRev_up_to_foc_switch_over().isEnable();
        int n5 = driveManagement.getStartup_parameters().getSensor_less_rev_up_settings().getRev_up_to_foc_switch_over().getDuration();
        int n6 = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_hfi().getSpeed_threshold().getConsecutive_successful_start_up_output_tests();
        int n7 = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_hfi().getSpeed_threshold().getHfi_sto_threshold();
        double d4 = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_hfi().getSpeed_threshold().getEstimated_speed_band_tolerance_upper_limit();
        void var282_229 = _estimated_speed_band_tolerance_upper_limit_1 * 16.0;
        void var284_230 = _multiply_6 / 100.0;
        double d5 = driveManagement.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_less_observer_and_hfi().getSpeed_threshold().getEstimated_speed_band_tolerance_lower_limit();
        void var288_232 = _estimated_speed_band_tolerance_lower_limit_1 * 16.0;
        void var290_233 = _multiply_7 / 100.0;
        boolean bl2 = driveManagement.getAdditional_features().getAdditional_methods().isFlux_weakening_enable();
        double d6 = driveManagement.getAdditional_features().getAdditional_methods().getFlux_weakening().getVoltage_limit();
        void var295_236 = _voltage_limit * 10.0;
        int n8 = driveManagement.getAdditional_features().getAdditional_methods().getFlux_weakening().getKp();
        int n9 = driveManagement.getAdditional_features().getAdditional_methods().getFlux_weakening().getKi();
        KPdiv_enum kPdiv_enum = driveManagement.getAdditional_features().getAdditional_methods().getFlux_weakening().getKp_div();
        KIdiv_enum kIdiv_enum = driveManagement.getAdditional_features().getAdditional_methods().getFlux_weakening().getKi_div();
        boolean bl3 = driveManagement.getAdditional_features().getAdditional_methods().isMtpa_enable();
        boolean bl4 = driveManagement.getAdditional_features().getAdditional_methods().isFeed_forward_enable();
        COMSelection_enum cOMSelection_enum = driveManagement.getUser_interface().getCom_selection();
        int n10 = driveManagement.getUser_interface().getCan_details().getMax_message_length();
        int n11 = driveManagement.getUser_interface().getCan_details().getStarting_tx_message_id();
        CanBaudRate_enum canBaudRate_enum = driveManagement.getUser_interface().getCan_details().getCanbaudrate();
        SerialBaudRate_enum serialBaudRate_enum = driveManagement.getUser_interface().getSerial_details().getSerialbaudrate();
        ControlStage controlStage2 = ((Motorcontrol)comp).getControl_stage();
        double d7 = controlStage.getMcu_supply_voltage_and_clock_frequency().getCpu_clock_frequency();
        double d8 = controlStage.getMcu_supply_voltage_and_clock_frequency().getMcu_supply_voltage();
        boolean bl5 = false;
        boolean bl6 = false;
        double d9 = PWM_freq / tfreg * (PWM_freq / tfreg);
        if (vbus_voltage_reading) {
            double d10 = powerStage.getBus_voltage_sensing().getBus_voltage_divider();
            double d11 = 1.0 / _bus_voltage_divider;
            bus_div = _divide_8;
        } else {
            bus_div = vbus > 500.0 ? mcu_supply / 1500.0 : mcu_supply / 500.0;
        }
        _bus_voltage_divider = 0.0;
        double L = magnetic == Magneticstructure_enum.SURFACE_MOUNTED_PMSM ? Ls : Lq;
        _divide_8 = Rs / L;
        double d12 = 0.25;
        double d13 = 0.25 * (1.0 - Rs / (L * foc_rate));
        void var325_258 = (e1 + 0.25 - 2.0) * foc_rate + RL_ratio;
        double d14 = (1.0 - e1 - 0.25 + e1 * 0.25) * L * (foc_rate * foc_rate);
        void var329_260 = mcu_supply / (1.732 * bus_div);
        void var331_261 = mcu_supply / (2.0 * overall_gain);
        double d15 = max_speed * 1.2 * b_emf * 1.4142 / 1732.0;
        long l = Math.round((double)max_bemf_voltage_temp);
        List list = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Integer[]{16384, 8192, 4096, 2048, 1024, 512, 256, 128, 64, 32, 16, 8, 4, 2, 1}));
        boolean bl7 = false;
        double d16 = 0.0;
        double d17 = 0.0;
        double d18 = 0.0;
        double d19 = 0.0;
        List list2 = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Integer[]{16384, 8192, 4096, 2048, 1024, 512, 256, 128, 64, 32, 16, 8, 4, 2, 1}));
        boolean bl8 = false;
        double d20 = 0.0;
        boolean bl9 = false;
        boolean bl10 = false;
        do {
            void max_voltage;
            void k1;
            void f1value;
            f1 = (Integer)f1value.get(i);
            double c1 = (double)f1 * (Rs / (L * foc_rate));
            g1 = (double)f1 * k1 / foc_rate;
            double c3 = (double)((long)f1 * max_bemf_voltage) / (L * max_cur * foc_rate);
            double c5 = (double)f1 * max_voltage / (L * max_cur * foc_rate);
            if (!(c1 < 32768.0) || !(c3 < 32768.0) || !(c5 < 32768.0) || !(g1 < 32768.0) || !(g1 > -32768.0)) continue;
            exit = true;
        } while (++i < 15 && !exit);
        i = 0;
        exit = false;
        do {
            void f2value;
            void k2;
            if (!((g2 = max_cur * k2 / (double)max_bemf_voltage * ((double)(f2 = ((Integer)f2value.get(i)).intValue()) / foc_rate)) < 32768.0) || !(g2 > -32768.0)) continue;
            exit = true;
        } while (++i < 15 && !exit);
        double d21 = (double)(scan_freq * 65536) / foc_rate;
        int n12 = hfi_freq / 30;
        double d22 = foc_rate / 10.0;
        double d23 = 1.0 / (1.0 + k_for_notch / 2.0 + k_for_notch * k_for_notch);
        double d24 = (1.0 + k_for_notch * k_for_notch) * norm_for_notch;
        double d25 = 2.0 * (k_for_notch * k_for_notch - 1.0) * norm_for_notch;
        void var364_281 = -a1_for_notch;
        double d26 = -(1.0 - k_for_notch / 2.0 + k_for_notch * k_for_notch) * norm_for_notch;
        double d27 = 1.0 / (1.0 + k_for_lp / 0.707107 + k_for_lp * k_for_lp);
        double d28 = k_for_lp * k_for_lp * norm_for_lp;
        double d29 = 2.0 * a0_for_lp;
        double d30 = -2.0 * (k_for_lp * k_for_lp - 1.0) * norm_for_lp;
        double d31 = -(1.0 - k_for_lp / 0.707107 + k_for_lp * k_for_lp) * norm_for_lp;
        double d32 = 1.0 / (1.0 + k_for_hp / 0.707107 + k_for_hp * k_for_hp);
        void var380_289 = norm_for_hp;
        double d33 = -2.0 * a0_for_hp;
        double d34 = -2.0 * (k_for_hp * k_for_hp - 1.0) * norm_for_hp;
        double d35 = -(1.0 - k_for_hp / 0.707107 + k_for_hp * k_for_hp) * norm_for_hp;
        double d36 = 1.0 / (1.0 + k_for_dc / 0.707107 + k_for_dc * k_for_dc);
        double d37 = k_for_dc * k_for_dc * norm_for_dc;
        double d38 = 2.0 * a0_for_dc;
        double d39 = -2.0 * (k_for_dc * k_for_dc - 1.0) * norm_for_dc;
        double d40 = -(1.0 - k_for_dc / 0.707107 + k_for_dc * k_for_dc) * norm_for_dc;
        double d41 = torque_curr * 32767.0 * overall_gain * 2.0 / mcu_supply;
        double d42 = flux_curr * 32767.0 * overall_gain * 2.0 / mcu_supply;
        double d43 = x * 32767.0 * overall_gain * 2.0 / mcu_supply;
        double d44 = y * 32767.0 * overall_gain * 2.0 / mcu_supply;
        double d45 = zi * 32767.0 * overall_gain * 2.0 / mcu_supply;
        double d46 = zf * 32767.0 * overall_gain * 2.0 / mcu_supply;
        int n13 = ph3_duration_val / speed_duration * speed_fin_val;
        int n14 = speed_duration - ph3_duration_val;
        double d47 = x1 * 32767.0 * overall_gain * 2.0 / mcu_supply;
        double d48 = x2 * 32767.0 * overall_gain * 2.0 / mcu_supply;
        double d49 = x3 * 32767.0 * overall_gain * 2.0 / mcu_supply;
        double d50 = x4 * 32767.0 * overall_gain * 2.0 / mcu_supply;
        void var420_310 = x5 * 32767.0 * overall_gain * 2.0 / mcu_supply;
        double d51 = b_emf * 1.4142 * 60.0 / (10882.5024 * (double)pole);
        double d52 = tfreg / PWM_freq;
        double d53 = 6.2832 * max_cur * 16384.0 * bus_div / (T1 * mcu_supply);
        double d54 = 0.0;
        double d55 = 0.0;
        boolean bl11 = Objects.equals((Object)magnetic, (Object)Magneticstructure_enum.SURFACE_MOUNTED_PMSM);
        if (_equals_9 != false) {
            c1_Q = Ls * temp;
            c1_D = Ls * temp;
        } else {
            c1_Q = Lq * temp;
            c1_D = Ld * temp;
        }
        double d56 = 6.2832 * cFM * 32768.0 * bus_div / (T1 * mcu_supply * 16.0);
        double d57 = In * 32767.0 * overall_gain * 2.0 / mcu_supply;
        double d58 = Math.pow((double)cFM, 2.0);
        double d59 = Math.pow(Ld - Lq, 2.0);
        double d60 = 8.0 * _pow_1;
        double d61 = Math.pow(In, 2.0);
        void var445_323 = _multiply_8 * _pow_2;
        void var447_324 = _pow + _multiply_9;
        double d62 = Math.sqrt((double)delta);
        void var451_326 = -cFM + _sqrt;
        void var453_327 = _plus / (4.0 * (Ld - Lq) * In);
        double d63 = In * cosEMax;
        double d64 = Math.pow(In, 2.0);
        double d65 = Math.pow((double)Idmax, 2.0);
        void var461_331 = _pow_3 - _pow_4;
        double d66 = Math.sqrt((double)_minus);
        void var465_333 = Iqmax * 32767.0 / max_cur;
        void var467_334 = cIqmax / 8.0;
        double d67 = Math.pow((double)cFM, 2.0);
        double d68 = Math.pow(Lq - Ld, 2.0);
        double d69 = 4.0 * _pow_6;
        void var475_338 = _pow_5 / _multiply_10;
        void var477_339 = cIqmax / 8.0;
        double d70 = Math.pow((double)(Iqmax / 8.0), 2.0);
        void var481_341 = root + _pow_7;
        double d71 = Math.sqrt((double)_plus_1);
        void var485_343 = cFM / (2.0 * (Lq - Ld)) - _sqrt_1;
        void var487_344 = _minus_1 * 32767.0;
        void var489_345 = _multiply_11 / max_cur;
        double d72 = 2.0 * cIqmax / 8.0;
        double d73 = Math.pow(2.0 * Iqmax / 8.0, 2.0);
        void var495_348 = root + _pow_8;
        double d74 = Math.sqrt((double)_plus_2);
        void var499_350 = cFM / (2.0 * (Lq - Ld)) - _sqrt_2;
        void var501_351 = _minus_2 * 32767.0;
        void var503_352 = _multiply_12 / max_cur;
        double d75 = 3.0 * cIqmax / 8.0;
        double d76 = Math.pow(3.0 * Iqmax / 8.0, 2.0);
        void var509_355 = root + _pow_9;
        double d77 = Math.sqrt((double)_plus_3);
        void var513_357 = cFM / (2.0 * (Lq - Ld)) - _sqrt_3;
        void var515_358 = _minus_3 * 32767.0;
        void var517_359 = _multiply_13 / max_cur;
        double d78 = 4.0 * cIqmax / 8.0;
        double d79 = Math.pow(4.0 * Iqmax / 8.0, 2.0);
        void var523_362 = root + _pow_10;
        double d80 = Math.sqrt((double)_plus_4);
        void var527_364 = cFM / (2.0 * (Lq - Ld)) - _sqrt_4;
        void var529_365 = _minus_4 * 32767.0;
        void var531_366 = _multiply_14 / max_cur;
        double d81 = 5.0 * cIqmax / 8.0;
        double d82 = Math.pow(5.0 * Iqmax / 8.0, 2.0);
        void var537_369 = root + _pow_11;
        double d83 = Math.sqrt((double)_plus_5);
        void var541_371 = cFM / (2.0 * (Lq - Ld)) - _sqrt_5;
        void var543_372 = _minus_5 * 32767.0;
        void var545_373 = _multiply_15 / max_cur;
        double d84 = 6.0 * cIqmax / 8.0;
        double d85 = Math.pow(6.0 * Iqmax / 8.0, 2.0);
        void var551_376 = root + _pow_12;
        double d86 = Math.sqrt((double)_plus_6);
        void var555_378 = cFM / (2.0 * (Lq - Ld)) - _sqrt_6;
        void var557_379 = _minus_6 * 32767.0;
        void var559_380 = _multiply_16 / max_cur;
        double d87 = 7.0 * cIqmax / 8.0;
        double d88 = Math.pow(7.0 * Iqmax / 8.0, 2.0);
        void var565_383 = root + _pow_13;
        double d89 = Math.sqrt((double)_plus_7);
        void var569_385 = cFM / (2.0 * (Lq - Ld)) - _sqrt_7;
        void var571_386 = _minus_7 * 32767.0;
        void var573_387 = _multiply_17 / max_cur;
        double d90 = 8.0 * cIqmax / 8.0;
        double d91 = Math.pow(8.0 * Iqmax / 8.0, 2.0);
        void var579_390 = root + _pow_14;
        double d92 = Math.sqrt((double)_plus_8);
        void var583_392 = cFM / (2.0 * (Lq - Ld)) - _sqrt_8;
        void var585_393 = _minus_8 * 32767.0;
        void var587_394 = _multiply_18 / max_cur;
        void var589_395 = Id_array_0 / Iq_array_0 * 32768.0;
        void var591_396 = (Id_array_1 - Id_array_0) / (Iq_array_1 - Iq_array_0) * 32768.0;
        void var593_397 = (Id_array_2 - Id_array_1) / (Iq_array_2 - Iq_array_1) * 32768.0;
        void var595_398 = (Id_array_3 - Id_array_2) / (Iq_array_3 - Iq_array_2) * 32768.0;
        void var597_399 = (Id_array_4 - Id_array_3) / (Iq_array_4 - Iq_array_3) * 32768.0;
        void var599_400 = (Id_array_5 - Id_array_4) / (Iq_array_5 - Iq_array_4) * 32768.0;
        void var601_401 = (Id_array_6 - Id_array_5) / (Iq_array_6 - Iq_array_5) * 32768.0;
        void var603_402 = (Id_array_7 - Id_array_6) / (Iq_array_7 - Iq_array_6) * 32768.0;
        void var605_403 = -(m1 * Iq_array_0 / 32768.0) + Id_array_0;
        void var607_404 = -(m2 * Iq_array_1 / 32768.0) + Id_array_1;
        void var609_405 = -(m3 * Iq_array_2 / 32768.0) + Id_array_2;
        void var611_406 = -(m4 * Iq_array_3 / 32768.0) + Id_array_3;
        void var613_407 = -(m5 * Iq_array_4 / 32768.0) + Id_array_4;
        void var615_408 = -(m6 * Iq_array_5 / 32768.0) + Id_array_5;
        void var617_409 = -(m7 * Iq_array_6 / 32768.0) + Id_array_6;
        StringConcatenation stringConcatenation = new StringConcatenation();
        _builder.append("\t");
        _builder.append("/****************************************************************************");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("*");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("* Copyright (c) 2023 STMicroelectronics - All Rights Reserved");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("*");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("* License terms: STMicroelectronics Proprietary in accordance with licensing");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("* terms SLA0098 at www.st.com.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("*");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("* THIS SOFTWARE IS DISTRIBUTED \"AS IS,\" AND ALL WARRANTIES ARE DISCLAIMED,");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("*");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("*****************************************************************************/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/*");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("*   @file    Drive parameters.h");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("*   @version 1.1.0");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("*   @brief   This file contains motor parameters");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("*          ");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("*   @details This file contains motor parameters.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("*");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* Define to prevent recursive inclusion -------------------------------------*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#ifndef __DRIVE_PARAMETERS_H");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#define __DRIVE_PARAMETERS_H");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/******** MAIN AND AUXILIARY SPEED/POSITION SENSOR(S) SETTINGS SECTION ********/");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/*** Speed sensor selection ***/");
        _builder.newLine();
        _builder.newLine();
        if (main_sel == SensorSelection_enum.OBSERVER_PLL) {
            _builder.append("\t");
            _builder.append("#define STATE_OBSERVER_PLL ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define STATE_OBSERVER_CORDIC */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define HFINJECTION */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define ENCODER */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define HALL_SENSORS */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define RESOLVER */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define EXTERNAL_SENSOR */");
            _builder.newLine();
        }
        if (main_sel == SensorSelection_enum.OBSERVER_CORDIC) {
            _builder.append("\t");
            _builder.append("/* #define STATE_OBSERVER_PLL */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define STATE_OBSERVER_CORDIC");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define HFINJECTION */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define ENCODER */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define HALL_SENSORS */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define RESOLVER */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define EXTERNAL_SENSOR */");
            _builder.newLine();
        }
        if (main_sel == SensorSelection_enum.OBSERVER_HFI) {
            _builder.append("\t");
            _builder.append("/* #define STATE_OBSERVER_PLL */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define STATE_OBSERVER_CORDIC */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define HFINJECTION");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define ENCODER */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define HALL_SENSORS */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define RESOLVER */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define EXTERNAL_SENSOR */");
            _builder.newLine();
        }
        if (main_sel == SensorSelection_enum.QUADRATURE_ENCODER) {
            _builder.append("\t");
            _builder.append("/* #define STATE_OBSERVER_PLL */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define STATE_OBSERVER_CORDIC */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define HFINJECTION */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define ENCODER");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define HALL_SENSORS */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define RESOLVER */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define EXTERNAL_SENSOR */");
            _builder.newLine();
        }
        if (main_sel == SensorSelection_enum.HALL_SENSORS) {
            _builder.append("\t");
            _builder.append("/* #define STATE_OBSERVER_PLL */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define STATE_OBSERVER_CORDIC */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define HFINJECTION */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define ENCODER */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define HALL_SENSORS");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define RESOLVER */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define EXTERNAL_SENSOR */");
            _builder.newLine();
        }
        if (main_sel == SensorSelection_enum.RESOLVER) {
            _builder.append("\t");
            _builder.append("/* #define STATE_OBSERVER_PLL */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define STATE_OBSERVER_CORDIC */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define HFINJECTION */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define ENCODER */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define HALL_SENSORS */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define RESOLVER ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define EXTERNAL_SENSOR */");
            _builder.newLine();
        }
        if (main_sel == SensorSelection_enum.EXTERNAL_SENSOR) {
            _builder.append("\t");
            _builder.append("/* #define STATE_OBSERVER_PLL */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define STATE_OBSERVER_CORDIC */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define HFINJECTION */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define ENCODER */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define HALL_SENSORS */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define RESOLVER */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define EXTERNAL_SENSOR");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/*** Auxiliary speed measurement selection ***/");
        _builder.newLine();
        if (en_aux_sel) {
            if (aux_sel == SensorSelection_enum.RESOLVER) {
                _builder.append("#define AUX_RESOLVER");
                _builder.newLine();
                _builder.append("/* #define AUX_STATE_OBSERVER_PLL */");
                _builder.newLine();
                _builder.append("/* #define AUX_STATE_OBSERVER_CORDIC */");
                _builder.newLine();
                _builder.append("/* #define AUX_HFINJECTION */");
                _builder.newLine();
                _builder.append("/* #define AUX_ENCODER */");
                _builder.newLine();
                _builder.append("/* #define AUX_HALL_SENSORS */");
                _builder.newLine();
                _builder.append("/* #define AUX_EXTERNAL_SENSOR */");
                _builder.newLine();
            }
            if (aux_sel == SensorSelection_enum.OBSERVER_PLL) {
                _builder.append("/* #define AUX_RESOLVER */ ");
                _builder.newLine();
                _builder.append("#define AUX_STATE_OBSERVER_PLL");
                _builder.newLine();
                _builder.append("/* #define AUX_STATE_OBSERVER_CORDIC */");
                _builder.newLine();
                _builder.append("/* #define AUX_HFINJECTION */");
                _builder.newLine();
                _builder.append("/* #define AUX_ENCODER */");
                _builder.newLine();
                _builder.append("/* #define AUX_HALL_SENSORS */");
                _builder.newLine();
                _builder.append("/* #define AUX_EXTERNAL_SENSOR */");
                _builder.newLine();
            }
            if (aux_sel == SensorSelection_enum.OBSERVER_CORDIC) {
                _builder.append("/* #define AUX_RESOLVER */");
                _builder.newLine();
                _builder.append("/* #define AUX_STATE_OBSERVER_PLL */");
                _builder.newLine();
                _builder.append("#define AUX_STATE_OBSERVER_CORDIC");
                _builder.newLine();
                _builder.append("/* #define AUX_HFINJECTION */");
                _builder.newLine();
                _builder.append("/* #define AUX_ENCODER */");
                _builder.newLine();
                _builder.append("/* #define AUX_HALL_SENSORS */");
                _builder.newLine();
                _builder.append("/* #define AUX_EXTERNAL_SENSOR */");
                _builder.newLine();
            }
            if (aux_sel == SensorSelection_enum.OBSERVER_HFI) {
                _builder.append("/* #define AUX_RESOLVER */");
                _builder.newLine();
                _builder.append("/* #define AUX_STATE_OBSERVER_PLL */");
                _builder.newLine();
                _builder.append("/* #define AUX_STATE_OBSERVER_CORDIC */");
                _builder.newLine();
                _builder.append("#define AUX_HFINJECTION");
                _builder.newLine();
                _builder.append("/* #define AUX_ENCODER */");
                _builder.newLine();
                _builder.append("/* #define AUX_HALL_SENSORS */");
                _builder.newLine();
                _builder.append("/* #define AUX_EXTERNAL_SENSOR */");
                _builder.newLine();
            }
            if (aux_sel == SensorSelection_enum.QUADRATURE_ENCODER) {
                _builder.append("/* #define AUX_RESOLVER */");
                _builder.newLine();
                _builder.append("/* #define AUX_STATE_OBSERVER_PLL */");
                _builder.newLine();
                _builder.append("/* #define AUX_STATE_OBSERVER_CORDIC */");
                _builder.newLine();
                _builder.append("/* #define AUX_HFINJECTION */");
                _builder.newLine();
                _builder.append("#define AUX_ENCODER");
                _builder.newLine();
                _builder.append("/* #define AUX_HALL_SENSORS */ ");
                _builder.newLine();
                _builder.append("/* #define AUX_EXTERNAL_SENSOR */ ");
                _builder.newLine();
            }
            if (aux_sel == SensorSelection_enum.HALL_SENSORS) {
                _builder.append("/* #define AUX_RESOLVER */");
                _builder.newLine();
                _builder.append("/* #define AUX_STATE_OBSERVER_PLL */");
                _builder.newLine();
                _builder.append("/* #define AUX_STATE_OBSERVER_CORDIC */");
                _builder.newLine();
                _builder.append("/* #define AUX_HFINJECTION */");
                _builder.newLine();
                _builder.append("/* #define AUX_ENCODER */");
                _builder.newLine();
                _builder.append("#define AUX_HALL_SENSORS ");
                _builder.newLine();
                _builder.append("/* #define AUX_EXTERNAL_SENSOR */ ");
                _builder.newLine();
            }
            if (aux_sel == SensorSelection_enum.EXTERNAL_SENSOR) {
                _builder.append("/* #define AUX_RESOLVER */");
                _builder.newLine();
                _builder.append("/* #define AUX_STATE_OBSERVER_PLL */");
                _builder.newLine();
                _builder.append("/* #define AUX_STATE_OBSERVER_CORDIC */");
                _builder.newLine();
                _builder.append("/* #define AUX_HFINJECTION */");
                _builder.newLine();
                _builder.append("/* #define AUX_ENCODER */");
                _builder.newLine();
                _builder.append("/* #define AUX_HALL_SENSORS */");
                _builder.newLine();
                _builder.append("#define AUX_EXTERNAL_SENSOR");
                _builder.newLine();
            }
        } else {
            _builder.append("\t");
            _builder.append("/* #define AUX_RESOLVER */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define AUX_STATE_OBSERVER_PLL */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define AUX_STATE_OBSERVER_CORDIC */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define AUX_HFINJECTION */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define AUX_ENCODER */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define AUX_HALL_SENSORS */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* #define AUX_EXTERNAL_SENSOR */");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/*** Drives number selection ***/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#define SINGLEDRIVE");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* #define DUALDRIVE */");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/*** Speed measurement settings ***/");
        _builder.newLine();
        _builder.newLine();
        if (speed_en) {
            _builder.append("\t");
            _builder.append("#define USE_CHECK_MAX_SPEED");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#define MAX_APPLICATION_SPEED_RPM       ");
        long l2 = Math.round(max_speed);
        _builder.append((Object)((long)_round), "\t");
        _builder.append(" /*!< rpm, mechanical */");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("#define MIN_APPLICATION_SPEED_RPM       0 /*!< rpm, mechanical,  ");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        _builder.append("absolute value */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#define MEAS_ERRORS_BEFORE_FAULTS       ");
        long l3 = Math.round(err_max);
        _builder.append((Object)((long)_round_1), "\t");
        _builder.append(" /*!< Number of speed  ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        _builder.append("measurement errors before ");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        _builder.append("main sensor goes in fault */");
        _builder.newLine();
        _builder.newLine();
        if (en_aux_sel && (aux_sel == SensorSelection_enum.QUADRATURE_ENCODER && main_sel == SensorSelection_enum.QUADRATURE_ENCODER || aux_sel == SensorSelection_enum.HALL_SENSORS && main_sel == SensorSelection_enum.HALL_SENSORS || aux_sel == SensorSelection_enum.OBSERVER_PLL && main_sel == SensorSelection_enum.OBSERVER_PLL || aux_sel == SensorSelection_enum.OBSERVER_CORDIC && main_sel == SensorSelection_enum.OBSERVER_CORDIC || aux_sel == SensorSelection_enum.RESOLVER && main_sel == SensorSelection_enum.RESOLVER || aux_sel == SensorSelection_enum.EXTERNAL_SENSOR && main_sel == SensorSelection_enum.EXTERNAL_SENSOR)) {
            _builder.append("\t");
            _builder.append("/* Error created for managing these exceptions.The generation must fail */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("[#stop \"When auxiliary sensor ");
            _builder.append((Object)aux_sel, "\t");
            _builder.append(" is enabled cannot be the same sensor as the main ");
            _builder.append((Object)main_sel, "\t");
            _builder.append("\"]");
            _builder.newLineIfNotEmpty();
        }
        if (main_sel == SensorSelection_enum.OBSERVER_HFI && (en_aux_sel || !Objects.equals((Object)aux_sel, (Object)SensorSelection_enum.OBSERVER_PLL))) {
            _builder.append("\t");
            _builder.append("/* Error created for managing these exceptions.The generation must fail */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("[#stop \"When Main sensor is Observer+HFI the Auxiliary should be Observer+PLL, while it is disabled or set to a sensored one\"]");
            _builder.newLine();
        }
        if (main_sel == SensorSelection_enum.HALL_SENSORS) {
            _builder.append("\t");
            _builder.append("/****** Hall sensors ************/");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define HALL_MEAS_ERRORS_BEFORE_FAULTS  ");
            long l4 = Math.round(err_max);
            _builder.append((Object)_round_2, "\t");
            _builder.append(" /*!< Number of failed");
            _builder.newLineIfNotEmpty();
            _builder.append("                                                           ");
            _builder.append("derived class specific speed");
            _builder.newLine();
            _builder.append("                                                           ");
            _builder.append("measurements before main sensor");
            _builder.newLine();
            _builder.append("                                                           ");
            _builder.append("goes in fault */");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define HALL_AVERAGING_FIFO_DEPTH        ");
            long l5 = Math.round(main_FIFO);
            _builder.append((Object)_round_3, "\t");
            _builder.append(" /*!< depth of the FIFO used to");
            _builder.newLineIfNotEmpty();
            _builder.append("                                                           ");
            _builder.append("average mechanical speed in");
            _builder.newLine();
            _builder.append("                                                           ");
            _builder.append("0.1Hz resolution */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define HALL_MTPA  \t\t\t\t\t\t");
            _builder.append((Object)((boolean)mtpa_enable), "\t");
            _builder.append("\t");
            _builder.newLineIfNotEmpty();
        } else if (aux_sel == SensorSelection_enum.HALL_SENSORS && en_aux_sel) {
            _builder.append("\t");
            _builder.append("/****** Hall sensors ************/");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define HALL_MEAS_ERRORS_BEFORE_FAULTS  ");
            _round_2 = Math.round(err_max);
            _builder.append((Object)_round_4, "\t");
            _builder.append(" /*!< Number of failed");
            _builder.newLineIfNotEmpty();
            _builder.append("                                                           ");
            _builder.append("derived class specific speed");
            _builder.newLine();
            _builder.append("                                                           ");
            _builder.append("measurements before main sensor");
            _builder.newLine();
            _builder.append("                                                           ");
            _builder.append("goes in fault */");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define HALL_AVERAGING_FIFO_DEPTH        ");
            _round_3 = Math.round(aux_FIFO);
            _builder.append((Object)_round_5, "\t");
            _builder.append(" /*!< depth of the FIFO used to");
            _builder.newLineIfNotEmpty();
            _builder.append("                                                           ");
            _builder.append("average mechanical speed in");
            _builder.newLine();
            _builder.append("                                                           ");
            _builder.append("0.1Hz resolution */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define HALL_MTPA  \t\t\t\t\t\t");
            _builder.append((Object)((boolean)mtpa_enable), "\t");
            _builder.append("\t");
            _builder.newLineIfNotEmpty();
        }
        if (main_sel == SensorSelection_enum.QUADRATURE_ENCODER) {
            _builder.append("\t");
            _builder.append("/****** Encoder ************/");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/****** Quadrature Encoder is the main sensor ******/");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define ENC_MEAS_ERRORS_BEFORE_FAULTS    ");
            _round_4 = Math.round(err_max);
            _builder.append((Object)_round_6, "\t");
            _builder.append(" /*!< Number of failed   ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("derived class specific speed ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("measurements before main sensor  ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("goes in fault */");
            _builder.newLine();
            if (main_rev) {
                _builder.append("\t");
                _builder.append("#define ENC_INVERT_SPEED                ENABLE  /*!< To be enabled for  ");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
                _builder.append("encoder (main or aux) if  ");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
                _builder.append("measured speed is opposite ");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
                _builder.append("to real one */");
                _builder.newLine();
            } else {
                _builder.append("\t");
                _builder.append("#define ENC_INVERT_SPEED                DISABLE  /*!< To be enabled for  ");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
                _builder.append("encoder (main or aux) if  ");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
                _builder.append("measured speed is opposite ");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
                _builder.append("to real one */");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("#define ENC_AVERAGING_FIFO_DEPTH        ");
            _round_5 = Math.round(main_FIFO);
            _builder.append((Object)_round_7, "\t");
            _builder.append(" /*!< depth of the FIFO used to ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("average mechanical speed in ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("0.1Hz resolution */");
            _builder.newLine();
        } else if (aux_sel == SensorSelection_enum.QUADRATURE_ENCODER && en_aux_sel) {
            _builder.append("\t");
            _builder.append("/****** Encoder ************/");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/****** Quadrature Encoder is the auxiliary sensor ******/");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define ENC_MEAS_ERRORS_BEFORE_FAULTS    ");
            _round_6 = Math.round(err_max);
            _builder.append((Object)_round_8, "\t");
            _builder.append(" /*!< Number of failed   ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("derived class specific speed ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("measurements before main sensor  ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("goes in fault */");
            _builder.newLine();
            if (aux_rev) {
                _builder.append("#define ENC_INVERT_SPEED                ENABLE  /*!< To be enabled for  ");
                _builder.newLine();
                _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
                _builder.append("encoder (main or aux) if  ");
                _builder.newLine();
                _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
                _builder.append("measured speed is opposite ");
                _builder.newLine();
                _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
                _builder.append("to real one */");
                _builder.newLine();
            } else {
                _builder.append("#define ENC_INVERT_SPEED                DISABLE  /*!< To be enabled for  ");
                _builder.newLine();
                _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
                _builder.append("encoder (main or aux) if  ");
                _builder.newLine();
                _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
                _builder.append("measured speed is opposite ");
                _builder.newLine();
                _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
                _builder.append("to real one */");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("#define ENC_AVERAGING_FIFO_DEPTH        ");
            _round_7 = Math.round(aux_FIFO);
            _builder.append((Object)_round_9, "\t");
            _builder.append(" /*!< depth of the FIFO used to ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("average mechanical speed in ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("0.1Hz resolution */\t\t");
            _builder.newLine();
        }
        if (!qe && main_sel == SensorSelection_enum.QUADRATURE_ENCODER || !qe && aux_sel == SensorSelection_enum.QUADRATURE_ENCODER) {
            if (main_sel == SensorSelection_enum.QUADRATURE_ENCODER) {
                _builder.append("\t");
                _builder.append("/* Error created for managing these exceptions.The generation must fail */");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("[#stop \"Main speed Sensor is set to the Quadrature Encoder, but the motor doesn't support it\"]");
                _builder.newLine();
            }
            if (aux_sel == SensorSelection_enum.QUADRATURE_ENCODER && en_aux_sel) {
                _builder.append("\t");
                _builder.append("/* Error created for managing these exceptions.The generation must fail */");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("[#stop \"Auxiliary speed Sensor is set to the Quadrature Encoder, but the motor doesn't support it\"]");
                _builder.newLine();
            }
        }
        if (!hs && main_sel == SensorSelection_enum.HALL_SENSORS || !hs && aux_sel == SensorSelection_enum.HALL_SENSORS) {
            if (main_sel == SensorSelection_enum.HALL_SENSORS) {
                _builder.append("\t");
                _builder.append("/* Error created for managing these exceptions.The generation must fail */");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("[#stop \"Main speed Sensor is set to the Hall Sensors, but the motor doesn't support it\"]");
                _builder.newLine();
            }
            if (aux_sel == SensorSelection_enum.HALL_SENSORS && en_aux_sel) {
                _builder.append("\t");
                _builder.append("/* Error created for managing these exceptions.The generation must fail */");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("[#stop \"Auxiliary speed Sensor is set to the Hall Sensors, but the motor doesn't support it\"]");
                _builder.newLine();
            }
        }
        if (main_sel == SensorSelection_enum.RESOLVER) {
            _builder.append("\t");
            _builder.append("/****** Resolver ************/");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/****** Resolver is the main sensor ******/");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define EXCITING_FREQUENCY ");
            _round_8 = Math.round(main_sig_freq);
            _builder.append((Object)_round_10, "\t");
            _builder.append(" /* Hz */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define EXCITING_AMPLITUDE_PERCENTAGE 100.0f    /* Exciting frequency in percentage (Max 3V) */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define RESOLVER_DELAY_TIM15_CCR1 ");
            _round_9 = Math.round(main_shift);
            _builder.append((Object)_round_11, "\t");
            _builder.append("U");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* Resolver PLL invert direction */");
            _builder.newLine();
            if (main_pll_invert_dir) {
                _builder.append("\t");
                _builder.append("#define RESOLVER_INVERT_DIRECTION -1");
                _builder.newLine();
            } else {
                _builder.append("\t");
                _builder.append("#define RESOLVER_INVERT_DIRECTION 1");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("/* Ratio between resolver frequency and rotor mechanical frequency  */       ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* [Note: FW manages only case in which ( POLE_PAIR_NUM / RESOLVER_TO_MECHANICAL_RATIO ) >= 1] */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define RESOLVER_TO_MECHANICAL_RATIO  ");
            _builder.append((Object)main_res_mec_ratio, "\t");
            _builder.newLineIfNotEmpty();
            if (main_pll_manual_editing) {
                void _round_12;
                _builder.append("\t");
                _builder.append("#define RESOLVER_PLL_KP_GAIN                ");
                int n15 = Math.round(main_res_KP_PLL);
                _builder.append((Object)((int)_round_12), "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("#define RESOLVER_PLL_KP_DIVIDER\t\t\t\t");
                _builder.append(main_res_KPDIV_PLL, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("#define RESOLVER_PLL_KI_GAIN                ");
                int n16 = Math.round(main_res_KI_PLL);
                _builder.append((Object)_round_13, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("#define RESOLVER_PLL_KI_DIVIDER\t\t\t\t");
                _builder.append(main_res_KIDIV_PLL, "\t");
                _builder.newLineIfNotEmpty();
            } else {
                void _round_14;
                _builder.append("\t");
                _builder.append("#define RESOLVER_PLL_KP_GAIN                ");
                long _round_12 = Math.round((double)(532 * pole) * max_speed * tfreg / PWM_freq);
                _builder.append((Object)((long)_round_14), "\t");
                _builder.append("  ");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("#define RESOLVER_PLL_KP_DIVIDER\t\t\t\t16384");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("#define RESOLVER_PLL_KI_GAIN                ");
                long l6 = Math.round((double)(1506742 * pole) * max_speed / (4.0 * loc));
                _builder.append((Object)_round_15, "\t");
                _builder.append("  ");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("#define RESOLVER_PLL_KI_DIVIDER\t\t\t\t16384");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("#define OLENDSPEEDRPM   100.0f");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define OLSTARTDURATION 1.0f");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define OLCURRENT       1.0f");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define EXCITING_AMPLITUDE_S32    (int32_t)((EXCITING_AMPLITUDE_PERCENTAGE * 32768.0f) / 100.0f)");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define RESOLVER_ANGLE_OFFSET_S16 ((RESOLVER_ANGLE_OFFSET_DEGREE * 32768.0f) / 180.0f)");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define OLCURRENTS16              (int16_t)((OLCURRENT * 65536.0f * AMPLIFICATION_GAIN * RSHUNT) / ADC_REFERENCE_VOLTAGE)");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define RESOLVER_MAX_SPEED_DPP    (int16_t)(((float)(MOTOR_MAX_SPEED_RPM*1.15f) * 65536.0f)/(60.0f*EXCITING_FREQUENCY))");
            _builder.newLine();
        } else if (aux_sel == SensorSelection_enum.RESOLVER && en_aux_sel) {
            _builder.append("\t");
            _builder.append("/****** Resolver ************/");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/****** Resolver is the auxiliary sensor ******/");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define EXCITING_FREQUENCY ");
            _round_10 = Math.round(aux_sig_freq);
            _builder.append((Object)_round_16, "\t");
            _builder.append(" /* Hz */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define EXCITING_AMPLITUDE_PERCENTAGE 100.0f    /* Exciting frequency in percentage (Max 3V) */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define RESOLVER_DELAY_TIM15_CCR1 ");
            _round_11 = Math.round(aux_shift);
            _builder.append((Object)_round_17, "\t");
            _builder.append("U");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* Resolver PLL invert direction */");
            _builder.newLine();
            if (aux_pll_invert_dir) {
                _builder.append("\t");
                _builder.append("#define RESOLVER_INVERT_DIRECTION -1");
                _builder.newLine();
            } else {
                _builder.append("\t");
                _builder.append("#define RESOLVER_INVERT_DIRECTION 1");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("/* Ratio between resolver frequency and rotor mechanical frequency */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* [Note: FW manages only case in which ( POLE_PAIR_NUM / RESOLVER_TO_MECHANICAL_RATIO ) >= 1] */       ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define RESOLVER_TO_MECHANICAL_RATIO  ");
            _builder.append((Object)aux_res_mec_ratio, "\t");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            if (aux_pll_manual_editing) {
                void _round_19;
                void _round_18;
                _builder.append("\t");
                _builder.append("#define RESOLVER_PLL_KP_GAIN                    ");
                int _round_14 = Math.round(aux_res_KP_PLL);
                _builder.append((Object)((int)_round_18), "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("#define RESOLVER_PLL_KP_DIVIDER\t\t\t\t\t");
                _builder.append((Object)aux_res_KPDIV_PLL, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("#define RESOLVER_PLL_KI_GAIN                    ");
                _round_13 = Math.round(aux_res_KI_PLL);
                _builder.append((Object)((int)_round_19), "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("#define RESOLVER_PLL_KI_DIVIDER\t\t\t\t\t");
                _builder.append((Object)aux_res_KIDIV_PLL, "\t");
                _builder.newLineIfNotEmpty();
            } else {
                void _round_20;
                _builder.append("\t");
                _builder.append("#define RESOLVER_PLL_KP_GAIN                    ");
                long _round_18 = Math.round((double)(532 * pole) * max_speed * tfreg / PWM_freq);
                _builder.append((Object)((long)_round_20), "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("#define RESOLVER_PLL_KP_DIVIDER\t\t\t\t\t16384");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("#define RESOLVER_PLL_KI_GAIN                    ");
                _round_15 = Math.round((double)(1506742 * pole) * max_speed / (4.0 * loc));
                _builder.append((Object)_round_21, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("#define RESOLVER_PLL_KI_DIVIDER\t\t\t\t\t16384");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define OLENDSPEEDRPM   100.0f");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define OLSTARTDURATION 1.0f");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define OLCURRENT       1.0f");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define EXCITING_AMPLITUDE_S32    (int32_t)((EXCITING_AMPLITUDE_PERCENTAGE * 32768.0f) / 100.0f)");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define RESOLVER_ANGLE_OFFSET_S16 ((RESOLVER_ANGLE_OFFSET_DEGREE * 32768.0f) / 180.0f)");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define OLCURRENTS16              (int16_t)((OLCURRENT * 65536.0f * AMPLIFICATION_GAIN * RSHUNT) / ADC_REFERENCE_VOLTAGE)");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define RESOLVER_MAX_SPEED_DPP    (int16_t)(((float)(MOTOR_MAX_SPEED_RPM*1.15f) * 65536.0f)/(60.0f*EXCITING_FREQUENCY))");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        if (main_sel == SensorSelection_enum.EXTERNAL_SENSOR) {
            _builder.append("\t");
            _builder.append("/****** External sensors ************/");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/****** External Sensor is the main sensor ******/");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define EXT_MEAS_ERRORS_BEFORE_FAULTS  ");
            _round_16 = Math.round(err_max);
            _builder.append((Object)_round_22, "\t");
            _builder.append(" /*!< Number of failed   ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("derived class specific speed ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("measurements before main sensor  ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("goes in fault */");
            _builder.newLine();
        } else if (aux_sel == SensorSelection_enum.EXTERNAL_SENSOR && en_aux_sel) {
            void _round_23;
            _builder.append("\t");
            _builder.append("/****** External sensors ************/");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/****** External Sensor is the auxiliary sensor ******/");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define EXT_MEAS_ERRORS_BEFORE_FAULTS  ");
            _round_22 = Math.round(err_max);
            _builder.append((Object)((long)_round_23), "\t");
            _builder.append(" /*!< Number of failed   ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("derived class specific speed ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("measurements before main sensor  ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("goes in fault */\t\t");
            _builder.newLine();
        }
        if (!ext && main_sel == SensorSelection_enum.EXTERNAL_SENSOR || !ext && aux_sel == SensorSelection_enum.EXTERNAL_SENSOR) {
            if (main_sel == SensorSelection_enum.EXTERNAL_SENSOR) {
                _builder.append("\t");
                _builder.append("/* Error created for managing these exceptions.The generation must fail */");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("[#stop \"Main speed Sensor is set to the External Sensor, but the motor doesn't support it\"]");
                _builder.newLine();
            }
            if (aux_sel == SensorSelection_enum.EXTERNAL_SENSOR && en_aux_sel) {
                _builder.append("\t");
                _builder.append("/* Error created for managing these exceptions.The generation must fail */");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("[#stop \"Auxiliary speed Sensor is set to the External Sensor, but the motor doesn't support it\"]");
                _builder.newLine();
            }
        }
        _builder.newLine();
        _builder.newLine();
        if (main_sel == SensorSelection_enum.OBSERVER_PLL) {
            void _round_34;
            void _round_32;
            long _round_31;
            long _round_27;
            int _round_25;
            _builder.append("\t");
            _builder.append("/****** State Observer + PLL ************/");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/****** State Observer + PLL is the main sensor ******/");
            _builder.newLine();
            if (main_depth_loop < main_depth_obs) {
                _builder.append("\t");
                _builder.append("[#stop \" In main sensor Observer+PLL Average speed depth for speed loop is lower than Average speed depth for speed Observer equations\"]");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("#define VARIANCE_THRESHOLD               ");
            _builder.append((Object)main_var, "\t");
            _builder.append(" /*!<Maximum accepted ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("variance on speed ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("estimates (percentage) */");
            _builder.newLine();
            if (main_manual) {
                void _round_24;
                _builder.append("/* State observer scaling factors */");
                _builder.newLine();
                _builder.append("#define F1                               ");
                _builder.append((Object)main_F1);
                _builder.newLineIfNotEmpty();
                _builder.append("#define F2                               ");
                _builder.append((Object)main_F2);
                _builder.newLineIfNotEmpty();
                _builder.append("#define F1_LOG                           LOG2(");
                _builder.append((Object)aux_F1);
                _builder.append(")");
                _builder.newLineIfNotEmpty();
                _builder.append("#define F2_LOG                           LOG2(");
                _builder.append((Object)aux_F2);
                _builder.append(")");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append("/* State observer constants */");
                _builder.newLine();
                _builder.append("#define GAIN1                            ");
                int _round_23 = Math.round(main_G1);
                _builder.append((Object)((int)_round_24));
                _builder.newLineIfNotEmpty();
                _builder.append("#define GAIN2                            ");
                int n17 = Math.round(main_G2);
                _builder.append((Object)_round_25);
                _builder.newLineIfNotEmpty();
            } else {
                void _round_26;
                _builder.append("/* State observer scaling factors */");
                _builder.newLine();
                _builder.append("#define F1                               ");
                _builder.append((Object)f1);
                _builder.newLineIfNotEmpty();
                _builder.append("#define F2                               ");
                _builder.append((Object)f2);
                _builder.newLineIfNotEmpty();
                _builder.append("#define F1_LOG                           LOG2(");
                _builder.append((Object)f1);
                _builder.append(")");
                _builder.newLineIfNotEmpty();
                _builder.append("#define F2_LOG                           LOG2(");
                _builder.append((Object)f2);
                _builder.append(")");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append("/* State observer constants */");
                _builder.newLine();
                _builder.append("#define GAIN1                            ");
                long _round_24 = Math.round(g1);
                _builder.append((Object)((long)_round_26));
                _builder.newLineIfNotEmpty();
                _builder.append("#define GAIN2                            ");
                _round_17 = Math.round((double)g2);
                _builder.append((Object)_round_27);
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("/*Only in case PLL is used, PLL gains */");
            _builder.newLine();
            if (main_manual) {
                void _round_28;
                _builder.append("#define PLL_KP_GAIN                      ");
                int _round_26 = Math.round(main_KP_PLL);
                _builder.append((Object)((int)_round_28));
                _builder.newLineIfNotEmpty();
                _builder.append("#define PLL_KPDIV     \t\t\t\t\t");
                _builder.append((Object)main_KP_PLL_div);
                _builder.newLineIfNotEmpty();
                _builder.append("#define PLL_KPDIV_LOG \t\t\t\t\tLOG2(PLL_KPDIV)");
                _builder.newLine();
                _builder.append("#define PLL_KI_GAIN                      ");
                _round_25 = Math.round(main_KI_PLL);
                _builder.append((Object)_round_29);
                _builder.newLineIfNotEmpty();
                _builder.append("#define PLL_KIDIV     \t\t\t\t\t");
                _builder.append((Object)main_KI_PLL_div);
                _builder.newLineIfNotEmpty();
                _builder.append("#define PLL_KIDIV_LOG \t\t\t\t\tLOG2(PLL_KIDIV)");
                _builder.newLine();
            } else {
                void _round_30;
                _builder.append("#define PLL_KP_GAIN                      ");
                long _round_28 = Math.round((double)(532 * pole) * max_speed * tfreg / PWM_freq);
                _builder.append((Object)((long)_round_30));
                _builder.newLineIfNotEmpty();
                _builder.append("#define PLL_KPDIV     \t\t\t\t\t16384");
                _builder.newLine();
                _builder.append("#define PLL_KPDIV_LOG \t\t\t\t\tLOG2(PLL_KPDIV)        ");
                _builder.newLine();
                _builder.append("#define PLL_KI_GAIN                      ");
                _round_27 = Math.round((double)(1506742 * pole) * max_speed / (4.0 * loc));
                _builder.append((Object)_round_31);
                _builder.newLineIfNotEmpty();
                _builder.append("#define PLL_KIDIV     \t\t\t\t\t65535");
                _builder.newLine();
                _builder.append("#define PLL_KIDIV_LOG \t\t\t\t\tLOG2(PLL_KIDIV)        ");
                _builder.newLine();
            }
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define OBS_MEAS_ERRORS_BEFORE_FAULTS    ");
            long _round_30 = Math.round(err_max);
            _builder.append((Object)((long)_round_32), "\t");
            _builder.append("  /*!< Number of consecutive errors   ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("on variance test before a speed ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("feedback error is reported */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define STO_FIFO_DEPTH_DPP               ");
            _round_31 = Math.round(main_depth_obs);
            _builder.append((Object)_round_33, "\t");
            _builder.append("  /*!< Depth of the FIFO used  ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("to average mechanical speed  ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("in dpp format */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define STO_FIFO_DEPTH_DPP_LOG           LOG2(STO_FIFO_DEPTH_DPP)");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define STO_FIFO_DEPTH_01HZ              ");
            long _round_20 = Math.round(main_depth_loop);
            _builder.append((Object)((long)_round_34), "\t");
            _builder.append("  /*!< Depth of the FIFO used  ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("to average mechanical speed  ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("in dpp format */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define STO_FIFO_DEPTH_UNIT              STO_FIFO_DEPTH_01HZ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define BEMF_CONSISTENCY_TOL             ");
            _round_21 = Math.round(main_emf_tol * 64.0 / 100.0);
            _builder.append((Object)_round_35, "\t");
            _builder.append("   /* Parameter for B-emf ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("amplitude-speed consistency */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define BEMF_CONSISTENCY_GAIN            ");
            long l7 = Math.round(main_emf_gain * 64.0 / 100.0);
            _builder.append((Object)_round_36, "\t");
            _builder.append("   /* Parameter for B-emf ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("amplitude-speed consistency */");
            _builder.newLine();
        } else if (aux_sel == SensorSelection_enum.OBSERVER_PLL && en_aux_sel) {
            void _round_47;
            void _round_45;
            long _round_44;
            long _round_40;
            int _round_38;
            _builder.append("\t");
            _builder.append("/****** State Observer + PLL ************/");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/****** State Observer + PLL is the auxiliary sensor ******/");
            _builder.newLine();
            if (aux_depth_loop < aux_depth_obs) {
                _builder.append("\t");
                _builder.append("[#stop \" In auxiliary sensor Observer+PLL Average speed depth for speed loop is lower than Average speed depth for speed Observer equations\"]");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("#define VARIANCE_THRESHOLD               ");
            _builder.append((Object)aux_var, "\t");
            _builder.append(" /*!<Maximum accepted ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("variance on speed ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("estimates (percentage) */");
            _builder.newLine();
            if (aux_manual) {
                void _round_37;
                _builder.append("\t");
                _builder.append("/* State observer scaling factors */");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("#define F1                               ");
                _builder.append((Object)aux_F1, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("#define F2                               ");
                _builder.append((Object)aux_F2, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("#define F1_LOG                           LOG2(");
                _builder.append((Object)aux_F1, "\t");
                _builder.append(")");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("#define F2_LOG                           LOG2(");
                _builder.append((Object)aux_F2, "\t");
                _builder.append(")");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append("\t");
                _builder.append("/* State observer constants */");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("#define GAIN1                            ");
                int _round_32 = Math.round(aux_G1);
                _builder.append((Object)((int)_round_37), "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("#define GAIN2                            ");
                _round_29 = Math.round(aux_G2);
                _builder.append((Object)_round_38, "\t");
                _builder.newLineIfNotEmpty();
            } else {
                void _round_39;
                _builder.append("\t");
                _builder.append("/* State observer scaling factors */");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("#define F1                               ");
                _builder.append((Object)f1, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("#define F2                               ");
                _builder.append((Object)f2, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("#define F1_LOG                           LOG2(");
                _builder.append((Object)f1, "\t");
                _builder.append(")");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("#define F2_LOG                           LOG2(");
                _builder.append((Object)f2, "\t");
                _builder.append(")");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append("\t");
                _builder.append("/* State observer constants */");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("#define GAIN1                            ");
                long _round_37 = Math.round(g1);
                _builder.append((Object)((long)_round_39), "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("#define GAIN2                            ");
                _round_33 = Math.round((double)g2);
                _builder.append((Object)_round_40, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("/* Only in case PLL is used, PLL gains */");
            _builder.newLine();
            if (aux_manual) {
                void _round_41;
                _builder.append("\t");
                _builder.append("#define PLL_KP_GAIN                      ");
                int _round_39 = Math.round(aux_KP_PLL);
                _builder.append((Object)((int)_round_41), "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("#define PLL_KPDIV     \t\t\t\t\t");
                _builder.append((Object)aux_KP_PLL_div, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("#define PLL_KPDIV_LOG \t\t\t\t\tLOG2(PLL_KPDIV)");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("#define PLL_KI_GAIN                      ");
                _round_38 = Math.round(aux_KI_PLL);
                _builder.append((Object)_round_42, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("#define PLL_KIDIV     \t\t\t\t\t");
                _builder.append((Object)aux_KI_PLL_div, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("#define PLL_KIDIV_LOG \t\t\t\t\tLOG2(PLL_KIDIV)");
                _builder.newLine();
            } else {
                void _round_43;
                _builder.append("\t");
                _builder.append("#define PLL_KP_GAIN                      ");
                long _round_41 = Math.round((double)(532 * pole) * max_speed * tfreg / PWM_freq);
                _builder.append((Object)((long)_round_43), "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("#define PLL_KPDIV     \t\t\t\t\t16384");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("#define PLL_KPDIV_LOG \t\t\t\t\tLOG2(PLL_KPDIV)");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("#define PLL_KI_GAIN                      ");
                _round_40 = Math.round((double)(1506742 * pole) * max_speed / (4.0 * loc));
                _builder.append((Object)_round_44, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("#define PLL_KIDIV     \t\t\t\t\t65535");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("#define PLL_KIDIV_LOG \t\t\t\t\tLOG2(PLL_KIDIV)");
                _builder.newLine();
            }
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define OBS_MEAS_ERRORS_BEFORE_FAULTS    ");
            long _round_43 = Math.round(err_max);
            _builder.append((Object)((long)_round_45), "\t");
            _builder.append("  /*!< Number of consecutive errors   ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("on variance test before a speed ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("feedback error is reported */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define STO_FIFO_DEPTH_DPP               ");
            _round_44 = Math.round(aux_depth_obs);
            _builder.append((Object)_round_46, "\t");
            _builder.append("  /*!< Depth of the FIFO used  ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("to average mechanical speed  ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("in dpp format */");
            _builder.newLine();
            _builder.append("        ");
            _builder.append("#define STO_FIFO_DEPTH_DPP_LOG           LOG2(STO_FIFO_DEPTH_DPP)");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define STO_FIFO_DEPTH_01HZ              ");
            long _round_34 = Math.round(aux_depth_loop);
            _builder.append((Object)((long)_round_47), "\t");
            _builder.append("  /*!< Depth of the FIFO used  ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("to average mechanical speed  ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("in dpp format */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define STO_FIFO_DEPTH_UNIT              STO_FIFO_DEPTH_01HZ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define BEMF_CONSISTENCY_TOL             ");
            _round_35 = Math.round(aux_emf_tol * 64.0 / 100.0);
            _builder.append((Object)_round_48, "\t");
            _builder.append("   /* Parameter for B-emf ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("amplitude-speed consistency */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define BEMF_CONSISTENCY_GAIN            ");
            _round_36 = Math.round(aux_emf_gain * 64.0 / 100.0);
            _builder.append((Object)_round_49, "\t");
            _builder.append("   /* Parameter for B-emf ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("amplitude-speed consistency */");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.newLine();
        if (main_sel == SensorSelection_enum.OBSERVER_CORDIC) {
            void _round_56;
            void _round_54;
            long _round_53;
            long _round_52;
            _builder.append("\t");
            _builder.append("/****** State Observer + Cordic ************/\t");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/****** State Observer + Cordic is the main sensor ******/");
            _builder.newLine();
            if (main_depth_loop < main_depth_obs) {
                _builder.append("\t");
                _builder.append("[#stop \" In main sensor Observer+Cordic Average speed depth for speed loop is lower than Average speed depth for speed Observer equations\"]");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("#define CORD_VARIANCE_THRESHOLD          ");
            _builder.append((Object)main_var, "\t");
            _builder.append("  /*!<Maxiumum accepted ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("variance on speed ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("estimates (percentage) */");
            _builder.newLine();
            if (main_manual) {
                void _round_50;
                _builder.append("#define CORD_F1                          ");
                _builder.append((Object)main_F1);
                _builder.newLineIfNotEmpty();
                _builder.append("#define CORD_F2                          ");
                _builder.append((Object)main_F2);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append("/* State observer constants */");
                _builder.newLine();
                _builder.append("#define CORD_GAIN1                       ");
                int _round_45 = Math.round(main_G1);
                _builder.append((Object)((int)_round_50));
                _builder.newLineIfNotEmpty();
                _builder.append("#define CORD_GAIN2                       ");
                _round_42 = Math.round(main_G2);
                _builder.append((Object)_round_51);
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("#define CORD_F1                          ");
                _builder.append((Object)f1);
                _builder.newLineIfNotEmpty();
                _builder.append("#define CORD_F2                          ");
                _builder.append((Object)f2);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append("/* State observer constants */");
                _builder.newLine();
                _builder.append("#define CORD_GAIN1                       ");
                long _round_50 = Math.round(g1);
                _builder.append((Object)_round_52);
                _builder.newLineIfNotEmpty();
                _builder.append("#define CORD_GAIN2                       ");
                _round_46 = Math.round((double)g2);
                _builder.append((Object)_round_53);
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define CORD_MEAS_ERRORS_BEFORE_FAULTS   ");
            _round_52 = Math.round(err_max);
            _builder.append((Object)((long)_round_54), "\t");
            _builder.append("  /*!< Number of consecutive errors   ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("on variance test before a speed ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("feedback error is reported */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define CORD_FIFO_DEPTH_DPP              ");
            _round_53 = Math.round(main_depth_obs);
            _builder.append((Object)_round_55, "\t");
            _builder.append("  /*!< Depth of the FIFO used  ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("to average mechanical speed  ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("in dpp format */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define CORD_FIFO_DEPTH_01HZ             ");
            long _round_47 = Math.round(main_depth_loop);
            _builder.append((Object)((long)_round_56), "\t");
            _builder.append("  /*!< Depth of the FIFO used  ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("to average mechanical speed  ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("in dpp format */        ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define CORD_MAX_ACCEL_DPPP              ");
            _round_48 = Math.round(main_max_acc);
            _builder.append((Object)_round_57, "\t");
            _builder.append("  /*!< Maximum instantaneous ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("electrical acceleration (dpp ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("per control period) */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define CORD_BEMF_CONSISTENCY_TOL        ");
            _round_49 = Math.round(main_emf_tol * 64.0 / 100.0);
            _builder.append((Object)_round_58, "\t");
            _builder.append("  /* Parameter for B-emf ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("amplitude-speed consistency */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define CORD_BEMF_CONSISTENCY_GAIN       ");
            long l8 = Math.round(main_emf_gain * 64.0 / 100.0);
            _builder.append((Object)_round_59, "\t");
            _builder.append("  /* Parameter for B-emf ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("amplitude-speed consistency */");
            _builder.newLine();
        } else if (aux_sel == SensorSelection_enum.OBSERVER_CORDIC && en_aux_sel) {
            void _round_69;
            void _round_68;
            void _round_67;
            void _round_66;
            void _round_65;
            void _round_64;
            long _round_63;
            long _round_62;
            _builder.append("\t");
            _builder.append("/****** State Observer + Cordic is the auxiliary sensor ******/");
            _builder.newLine();
            if (aux_depth_loop < aux_depth_obs) {
                _builder.append("\t");
                _builder.append("[#stop \" In auxiliary sensor Observer+Cordic Average speed depth for speed loop is lower than Average speed depth for speed Observer equations\"]");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("#define CORD_VARIANCE_THRESHOLD          ");
            _builder.append((Object)aux_var, "\t");
            _builder.append("  /*!<Maxiumum accepted ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("variance on speed ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("estimates (percentage) */");
            _builder.newLine();
            if (aux_manual) {
                void _round_60;
                _builder.append("#define CORD_F1                          ");
                _builder.append((Object)aux_F1);
                _builder.newLineIfNotEmpty();
                _builder.append("#define CORD_F2                          ");
                _builder.append((Object)aux_F2);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append("/* State observer constants */");
                _builder.newLine();
                _builder.append("#define CORD_GAIN1                       ");
                int _round_54 = Math.round(aux_G1);
                _builder.append((Object)((int)_round_60));
                _builder.newLineIfNotEmpty();
                _builder.append("#define CORD_GAIN2                       ");
                _round_51 = Math.round(aux_G2);
                _builder.append((Object)_round_61);
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("#define CORD_F1                          ");
                _builder.append((Object)f1);
                _builder.newLineIfNotEmpty();
                _builder.append("#define CORD_F2                          ");
                _builder.append((Object)f2);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append("/* State observer constants */");
                _builder.newLine();
                _builder.append("#define CORD_GAIN1                       ");
                long _round_60 = Math.round(g1);
                _builder.append((Object)_round_62);
                _builder.newLineIfNotEmpty();
                _builder.append("#define CORD_GAIN2                       ");
                _round_55 = Math.round((double)g2);
                _builder.append((Object)_round_63);
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define CORD_MEAS_ERRORS_BEFORE_FAULTS   ");
            _round_62 = Math.round(err_max);
            _builder.append((Object)((long)_round_64), "\t");
            _builder.append("  /*!< Number of consecutive errors   ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("on variance test before a speed ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("feedback error is reported */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define CORD_FIFO_DEPTH_DPP              ");
            _round_63 = Math.round(aux_depth_obs);
            _builder.append((Object)((long)_round_65), "\t");
            _builder.append("  /*!< Depth of the FIFO used  ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("to average mechanical speed  ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("in dpp format */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define CORD_FIFO_DEPTH_01HZ             ");
            long _round_56 = Math.round(aux_depth_loop);
            _builder.append((Object)((long)_round_66), "\t");
            _builder.append("  /*!< Depth of the FIFO used  ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("to average mechanical speed  ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("in dpp format */        ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define CORD_MAX_ACCEL_DPPP              ");
            _round_57 = Math.round(aux_max_acc);
            _builder.append((Object)((long)_round_67), "\t");
            _builder.append("  /*!< Maximum instantaneous ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("electrical acceleration (dpp ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("per control period) */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define CORD_BEMF_CONSISTENCY_TOL        ");
            _round_58 = Math.round(aux_emf_tol * 64.0 / 100.0);
            _builder.append((Object)((long)_round_68), "\t");
            _builder.append("  /* Parameter for B-emf ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("amplitude-speed consistency */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define CORD_BEMF_CONSISTENCY_GAIN       ");
            _round_59 = Math.round(aux_emf_gain * 64.0 / 100.0);
            _builder.append((Object)((long)_round_69), "\t");
            _builder.append("  /* Parameter for B-emf ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("amplitude-speed consistency */");
            _builder.newLine();
        }
        _builder.newLine();
        if (main_sel == SensorSelection_enum.OBSERVER_HFI) {
            void _round_85;
            void _round_84;
            void _round_83;
            void _round_81;
            void _round_79;
            void lock_freq_dpp;
            void _round_78;
            void b2_for_dc;
            void b1_for_dc;
            void a1_for_dc;
            void b2_for_hp;
            void b1_for_hp;
            void a1_for_hp;
            void b2_for_lp;
            void b1_for_lp;
            void a1_for_lp;
            void b2_for_notch;
            void b1_for_notch;
            void a0_for_notch;
            void _round_77;
            void _round_76;
            void _round_75;
            void _round_74;
            int _round_73;
            int _greaterThan_1;
            int _round_72;
            void max_scan_freq;
            int _greaterThan;
            void _round_1462;
            boolean _round_65;
            void max_hfi_freq;
            void _equals_102;
            _builder.append("\t");
            _builder.append("/****** State Observer + HFI ************/");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/****** State Observer + HFI is the main sensor ******/");
            _builder.newLine();
            boolean _round_64 = Objects.equals((Object)magnetic, "Surface Mounted PMSM");
            if (_equals_102 != false) {
                _builder.append("\t");
                _builder.append("/*Error created for managing these exceptions.The generation must fail*/");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("[#stop \"Main speed sensor is set to the Sensor-less (Observer+HFI), but the motor magnetic structure isn't set to Internal PMSM\"]");
                _builder.newLine();
            }
            long _equals_102 = Math.round((double)max_hfi_freq);
            boolean bl12 = _round_65 = (long)hfi_freq > _round_1462;
            if (_greaterThan != 0) {
                void _round_71;
                _builder.append("\t");
                _builder.append("/*Error created for managing these exceptions.The generation must fail*/");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("[#stop \"Inserted value ");
                _builder.append((Object)hfi_freq, "\t");
                _builder.append(" exeeds max HFI Frequency allowed ");
                long l9 = Math.round((double)max_hfi_freq);
                _builder.append((Object)((long)_round_71), "\t");
                _builder.append("\"]");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.newLine();
            int _round_1462 = Math.round((float)max_scan_freq);
            int n18 = _round_61 = scan_freq > _round_72 ? 1 : 0;
            if (_greaterThan_1 != 0) {
                _builder.append("\t");
                _builder.append("/*Error created for managing these exceptions.The generation must fail*/");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("[#stop \"Inserted value ");
                _builder.append((Object)scan_freq, "\t");
                _builder.append(" exeeds max Scan Frequency allowed ");
                _greaterThan = Math.round((float)max_scan_freq);
                _builder.append((Object)_round_73, "\t");
                _builder.append("\"]");
                _builder.newLineIfNotEmpty();
            }
            if (main_depth_loop < main_depth_obs) {
                _builder.append("\t");
                _builder.append("[#stop \" In main sensor Observer+HFI Average speed depth for speed loop is lower than Average speed depth for speed Observer equations\"]");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define HFI_FREQUENCY                    ");
            _round_72 = Math.round(hfi_freq);
            _builder.append((Object)((int)_round_74), "\t");
            _builder.append("   /* Frequency of the HFI voltage signal */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define HFI_AMPLITUDE                    ");
            _greaterThan_1 = Math.round(amplitude);
            _builder.append((Object)((int)_round_75), "\t");
            _builder.append("   /* Amplitude of the HFI voltage signal */");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define HFI_PID_KP_DEFAULT               ");
            _round_73 = Math.round(kp);
            _builder.append((Object)((int)_round_76), "\t");
            _builder.append("   /* KP gains of the PI that tracks */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define HFI_PID_KI_DEFAULT               ");
            int _round_71 = Math.round(ki);
            _builder.append((Object)((int)_round_77), "\t");
            _builder.append("   /* KI gains of the PI that tracks*/");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define HFI_PID_KPDIV                    ");
            _builder.append((Object)kp_div, "\t");
            _builder.append("   /* KP divisor of the PI that tracks */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define HFI_PID_KIDIV                    ");
            _builder.append((Object)ki_div, "\t");
            _builder.append("   /* KI divisor of the PI that tracks */");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define HFI_IDH_DELAY                    32400");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define HFI_PLL_KP_DEFAULT               ");
            _builder.append((Object)pll_kp, "\t");
            _builder.append(" /* KP gain of the PLL that synchs */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define HFI_PLL_KI_DEFAULT               ");
            _builder.append((Object)pll_ki, "\t");
            _builder.append(" /* KI gain of the PLL that synchs */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define HFI_NOTCH_0_COEFF                ");
            _builder.append((Object)((double)a0_for_notch), "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define HFI_NOTCH_1_COEFF                ");
            _builder.append((Object)((double)a1_for_notch), "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define HFI_NOTCH_2_COEFF                ");
            _builder.append((Object)((double)a0_for_notch), "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define HFI_NOTCH_3_COEFF                ");
            _builder.append((Object)((double)b1_for_notch), "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define HFI_NOTCH_4_COEFF                ");
            _builder.append((Object)((double)b2_for_notch), "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define HFI_LP_0_COEFF                   ");
            _builder.append((Object)((double)a0_for_lp), "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define HFI_LP_1_COEFF                   ");
            _builder.append((Object)((double)a1_for_lp), "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define HFI_LP_2_COEFF                   ");
            _builder.append((Object)((double)a0_for_lp), "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define HFI_LP_3_COEFF                   ");
            _builder.append((Object)((double)b1_for_lp), "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define HFI_LP_4_COEFF                   ");
            _builder.append((Object)((double)b2_for_lp), "\t");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define HFI_HP_0_COEFF                   ");
            _builder.append((Object)((double)a0_for_hp), "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define HFI_HP_1_COEFF                   ");
            _builder.append((Object)((double)a1_for_hp), "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define HFI_HP_2_COEFF                   ");
            _builder.append((Object)((double)a0_for_hp), "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define HFI_HP_3_COEFF                   ");
            _builder.append((Object)((double)b1_for_hp), "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define HFI_HP_4_COEFF                   ");
            _builder.append((Object)((double)b2_for_hp), "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define HFI_DC_0_COEFF                   ");
            _builder.append((Object)((double)a0_for_dc), "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define HFI_DC_1_COEFF                   ");
            _builder.append((Object)((double)a1_for_dc), "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define HFI_DC_2_COEFF                   ");
            _builder.append((Object)((double)a0_for_dc), "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define HFI_DC_3_COEFF                   ");
            _builder.append((Object)((double)b1_for_dc), "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define HFI_DC_4_COEFF                   ");
            _builder.append((Object)((double)b2_for_dc), "\t");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define HFI_MINIMUM_SPEED_RPM            ");
            int _round_66 = Math.round(min_reliable_speed);
            _builder.append((Object)((int)_round_78), "\t");
            _builder.append("   /* Speed below which the PLL (linked to STO) is reset */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define HFI_SPD_BUFFER_DEPTH_01HZ        STO_FIFO_DEPTH_01HZ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define HFI_LOCKFREQ                     ");
            long _round_19 = Math.round((double)lock_freq_dpp);
            _builder.append((Object)((long)_round_79), "\t");
            _builder.append("   /* Rotation freq of the initial scan, expressed in dpp */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define HFI_SCANROTATIONSNO              ");
            int n19 = Math.round(rotation_no);
            _builder.append((Object)_round_80, "\t");
            _builder.append("   /* Number of electrical revolutions of the rotating stator field */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define HFI_WAITBEFORESN                 ");
            int _round_68 = Math.round(wait_before);
            _builder.append((Object)((int)_round_81), "\t");
            _builder.append("   /* Measured initial decay time of the signal [HFI freq/2]  */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define HFI_WAITAFTERNS                  ");
            int n20 = Math.round(wait_after);
            _builder.append((Object)_round_82, "\t");
            _builder.append("   /* Measured final decay time of the signal [HFI freq / 2] */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define HFI_HIFRAMPLSCAN                 ");
            _builder.append((Object)(amplitude + amplitude_boost), "\t");
            _builder.append("   /* High frequency signal amplification during scan */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define HFI_NSMAXDETPOINTS               ");
            int _round_69 = Math.round(pulse_number);
            _builder.append((Object)((int)_round_83), "\t");
            _builder.append("   /* Total duration of the NS detection stage [HFI freq/2] */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define HFI_NSDETPOINTSSKIP              ");
            int n21 = Math.round(pulses_skipped);
            _builder.append((Object)((int)_round_84), "\t");
            _builder.append("   /* Duration of the transitory in NS detection [HFI freq/2] */");
            _builder.newLineIfNotEmpty();
            if (debug_mode) {
                _builder.append("\t");
                _builder.append("#define HFI_DEBUG_MODE                  (TRUE)   /* Enables the HFI incremental system build */");
                _builder.newLine();
            } else {
                _builder.append("\t");
                _builder.append("#define HFI_DEBUG_MODE                  (FALSE)   /* Enables the HFI incremental system build */");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("#define HFI_STO_RPM_TH                   OBS_MINIMUM_SPEED_RPM   /* threshold to validate STO -HFI switch */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define STO_HFI_RPM_TH                   ");
            int n22 = Math.round(sto_hfi_th);
            _builder.append((Object)((int)_round_85), "\t");
            _builder.append("   /* threshold to validate HFI-STO switch */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define HFI_RESTART_RPM_TH               (((HFI_STO_RPM_TH) + (STO_HFI_RPM_TH))/2)");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define HFI_NS_MIN_SAT_DIFF              ");
            _builder.append((Object)min_sat_diff, "\t");
            _builder.append("   /* Typical measured saturation difference */");
            _builder.newLineIfNotEmpty();
            if (revert_direction) {
                _builder.append("\t");
                _builder.append("#define HFI_REVERT_DIRECTION            (TRUE)   /* Revert Direction */");
                _builder.newLine();
            } else {
                _builder.append("\t");
                _builder.append("#define HFI_REVERT_DIRECTION            (FALSE)   /* Revert Direction */");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("#define HFI_WAITTRACK                    20");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define HFI_WAITSYNCH                    20");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define HFI_STEPANGLE                    3640");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define HFI_MAXANGLEDIFF                 3640");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define HFI_RESTARTTIMESEC               0.1");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("/* USER CODE BEGIN angle reconstruction M1 */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#define PARK_ANGLE_COMPENSATION_FACTOR 0");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#define REV_PARK_ANGLE_COMPENSATION_FACTOR 0");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* USER CODE END angle reconstruction M1 */");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**************************    DRIVE SETTINGS SECTION   **********************/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* PWM generation and current reading */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#define PWM_FREQUENCY                    ");
        long _round_74 = Math.round(PWM_freq);
        _builder.append((Object)((long)_round_86), "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("#define PWM_FREQ_SCALING                 ");
        int _round_76 = Math.round(PWM_freq_scaling);
        _builder.append((Object)((int)_round_87), "\t");
        _builder.newLineIfNotEmpty();
        if (hs_complemented == Complementedfromhighside_enum.ENABLE) {
            if (hs_signal == DriverEnablingSignal_enum.ENABLE) {
                _builder.append("\t");
                _builder.append("#define LOW_SIDE_SIGNALS_ENABLING        ES_GPIO\t\t");
                _builder.newLine();
            } else {
                _builder.append("\t");
                _builder.append("#define LOW_SIDE_SIGNALS_ENABLING        LS_DISABLED");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("#define SW_DEADTIME_NS                   (0x0U)  ");
            _builder.newLine();
        } else {
            void _round_88;
            _builder.append("\t");
            _builder.append("#define LOW_SIDE_SIGNALS_ENABLING        LS_PWM_TIMER");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define SW_DEADTIME_NS                   ");
            long _round_77 = Math.round(SW_dead_time);
            _builder.append((Object)((long)_round_88), "\t");
            _builder.append(" /*!< Dead-time to be inserted  ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("by FW, only if low side ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("signals are enabled */");
            _builder.newLine();
        }
        _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* Torque and flux regulation loops */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#define REGULATION_EXECUTION_RATE     ");
        long _round_88 = Math.round(tfreg);
        _builder.append((Object)((long)_round_89), "\t");
        _builder.append("    /*!< FOC execution rate in ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        _builder.append("number of PWM cycles */  ");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* Gains values for torque and flux control loops */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#define PID_TORQUE_KP_DEFAULT         ");
        int _round_79 = Math.round(T_KP);
        _builder.append((Object)((int)_round_90), "\t");
        _builder.append("       ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("#define PID_TORQUE_KI_DEFAULT         ");
        int _round_67 = Math.round(T_KI);
        _builder.append((Object)((int)_round_91), "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("#define PID_TORQUE_KD_DEFAULT         100");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#define PID_FLUX_KP_DEFAULT           ");
        _round_80 = Math.round(F_KP);
        _builder.append((Object)((int)_round_92), "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("#define PID_FLUX_KI_DEFAULT           ");
        int _round_81 = Math.round(F_KI);
        _builder.append((Object)((int)_round_93), "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("#define PID_FLUX_KD_DEFAULT           100");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* Torque/Flux control loop gains dividers*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#define TF_KPDIV                      ");
        _round_82 = Math.round(T_KPDIV);
        _builder.append((Object)((int)_round_94), "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("#define TF_KIDIV                      ");
        int _round_83 = Math.round(T_KIDIV);
        _builder.append((Object)((int)_round_95), "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("#define TF_KDDIV                      8192 /*HARDWIRED*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#define TF_KPDIV_LOG                  LOG2(TF_KPDIV)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#define TF_KIDIV_LOG                  LOG2(TF_KIDIV)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#define TF_KDDIV_LOG                  LOG2(TF_KDDIV)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#define TFDIFFERENTIAL_TERM_ENABLING  DISABLE");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* Speed control loop */ ");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#define SPEED_LOOP_FREQUENCY_HZ       ");
        long _round_84 = Math.round(exec_rate);
        _builder.append((Object)((long)_round_96), "\t");
        _builder.append(" /*!<Execution rate of speed   ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        _builder.append("regulation loop (Hz) */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#define PID_SPEED_KP_DEFAULT          ");
        int n23 = Math.round(SP_KP);
        _builder.append((Object)((int)_round_97), "\t");
        _builder.append("/(SPEED_UNIT/10)");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("#define PID_SPEED_KI_DEFAULT          ");
        int n24 = Math.round(SP_KI);
        _builder.append((Object)((int)_round_98), "\t");
        _builder.append("/(SPEED_UNIT/10)");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("#define PID_SPEED_KD_DEFAULT          0/(SPEED_UNIT/10)\t/*HARDWIRED*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* Speed PID parameter dividers */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#define SP_KPDIV                      ");
        int n25 = Math.round(SP_KPDIV);
        _builder.append((Object)((int)_round_99), "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("#define SP_KIDIV                      ");
        int n26 = Math.round(SP_KIDIV);
        _builder.append((Object)((int)_round_100), "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("#define SP_KDDIV                      16");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#define SP_KPDIV_LOG                  LOG2(SP_KPDIV)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#define SP_KIDIV_LOG                  LOG2(SP_KIDIV)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#define SP_KDDIV_LOG                  LOG2(SP_KDDIV)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* USER CODE BEGIN PID_SPEED_INTEGRAL_INIT_DIV */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#define PID_SPEED_INTEGRAL_INIT_DIV 1 /*  */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* USER CODE END PID_SPEED_INTEGRAL_INIT_DIV */");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#define SPD_DIFFERENTIAL_TERM_ENABLING DISABLE");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* Default settings */");
        _builder.newLine();
        _builder.newLine();
        if (cnt_mode == Controlmode_enum.SPEED_CONTROL) {
            _builder.append("\t");
            _builder.append("#define DEFAULT_CONTROL_MODE           STC_SPEED_MODE  /*!< STC_TORQUE_MODE or ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("STC_SPEED_MODE */  ");
            _builder.newLine();
        } else {
            _builder.append("\t");
            _builder.append("#define DEFAULT_CONTROL_MODE           STC_TORQUE_MODE /*!< STC_TORQUE_MODE or ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("STC_SPEED_MODE */  ");
            _builder.newLine();
            if (torque_curr > In) {
                _builder.append("\t");
                _builder.append("[#stop \"Target stator current torque component higher than motor nominal current! Please set Torque component ");
                _builder.append((Object)torque_curr, "\t");
                _builder.append(" less than Nominal Current ");
                _builder.append((Object)In, "\t");
                _builder.append("\"]");
                _builder.newLineIfNotEmpty();
            }
            if (flux_curr > In) {
                _builder.append("\t");
                _builder.append("[#stop \"Target stator current  flux  component higher than motor nominal current! Please set  Flux  component [ ");
                _builder.append((Object)flux_curr, "\t");
                _builder.append(" ] less than Nominal Current ");
                _builder.append((Object)In, "\t");
                _builder.append("\"]");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("\t");
        _builder.append("#define DEFAULT_TARGET_SPEED_RPM       ");
        long l10 = Math.round(speed);
        _builder.append((Object)((long)_round_101), "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("#define DEFAULT_TARGET_SPEED_UNIT      (DEFAULT_TARGET_SPEED_RPM*SPEED_UNIT/_RPM)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#define DEFAULT_TORQUE_COMPONENT       ");
        double d93 = Math.floor((double)torque_curr_digit);
        _builder.append((Object)((double)_floor), "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("#define DEFAULT_FLUX_COMPONENT         ");
        double d94 = Math.floor((double)flux_curr_digit);
        _builder.append((Object)((double)_floor_1), "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/**************************    FIRMWARE PROTECTIONS SECTION   *****************/");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        if (!vbus_voltage_reading) {
            _builder.append("\t");
            _builder.append("#define OV_VOLTAGE_PROT_ENABLING        DISABLE /*!< Over voltage protection disabled */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define UV_VOLTAGE_PROT_ENABLING        DISABLE /*!< Under voltage protection disabled */");
            _builder.newLine();
        } else {
            _builder.append("\t");
            _builder.append("#define OV_VOLTAGE_PROT_ENABLING        ENABLE /*!< Over voltage protection enabled */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define UV_VOLTAGE_PROT_ENABLING        ENABLE /*!< Under voltage protection enabled */");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("#define OV_VOLTAGE_THRESHOLD_V          (");
        long l11 = Math.round(vbus_over_voltage_threshold);
        _builder.append((Object)((long)_round_102), "\t");
        _builder.append("U) /*!< Over-voltage threshold */");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("#define UD_VOLTAGE_THRESHOLD_V          (");
        long l12 = Math.round(vbus_under_voltage_threshold);
        _builder.append((Object)((long)_round_103), "\t");
        _builder.append("U) /*!< Under-voltage threshold */");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#define ON_OVER_VOLTAGE                 TURN_OFF_PWM /*!< TURN_OFF_PWM, ");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        _builder.append("TURN_ON_R_BRAKE or ");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        _builder.append("TURN_ON_LOW_SIDES */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#define R_BRAKE_SWITCH_OFF_THRES_V      10");
        _builder.newLine();
        _builder.append("    ");
        _builder.newLine();
        if (!enable_hw_prot) {
            _builder.append("\t");
            _builder.append("#define OV_TEMPERATURE_PROT_ENABLING    DISABLE");
            _builder.newLine();
        } else {
            _builder.append("\t");
            _builder.append("#define OV_TEMPERATURE_PROT_ENABLING    ENABLE");
            _builder.newLine();
        }
        if (use_max_working_temp) {
            _builder.append("\t");
            _builder.append("#define OV_TEMPERATURE_THRESHOLD_C      (");
            long l13 = Math.round(max_temp_on_sensor);
            _builder.append((Object)_round_104, "\t");
            _builder.append("U) /*!< Celsius degrees */");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("\t");
            _builder.append("#define OV_TEMPERATURE_THRESHOLD_C      (");
            _round_104 = Math.round(over_temp_threshold);
            _builder.append((Object)_round_105, "\t");
            _builder.append("U) /*!< Celsius degrees */");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("#define OV_TEMPERATURE_HYSTERESIS_C     (");
        _round_105 = Math.round(temp_hysteresis);
        _builder.append((Object)((long)_round_106), "\t");
        _builder.append("U)  /*!< Celsius degrees */");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#define HW_OV_CURRENT_PROT_BYPASS       DISABLE /*!<In case ON_OVER_VOLTAGE  ");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        _builder.append("is set to TURN_ON_LOW_SIDES");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        _builder.append("this feature may be used to");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        _builder.append("bypass HW over-current");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        _builder.append("protection (if supported by ");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        _builder.append("power stage) */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/******************************   START-UP PARAMETERS   **********************/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* Encoder alignment */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#define ALIGNMENT_DURATION              ");
        int n27 = Math.round(dur);
        _builder.append((Object)((int)_round_107), "\t");
        _builder.append("    /*!< milliseconds */");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("#define ALIGNMENT_ANGLE_DEG             ");
        int n28 = Math.round(align);
        _builder.append((Object)((int)_round_108), "\t");
        _builder.append("      /*!< degrees [0...359] */");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("#define FINAL_I_ALIGNMENT               ");
        double d95 = Math.floor((double)final_curr_ramp);
        _builder.append((Object)((double)_floor_2), "\t");
        _builder.append("    /*!< s16A */");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("/* With ALIGNMENT_ANGLE_DEG equal to 90 degrees final alignment */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* phase current = (FINAL_I_ALIGNMENT * 1.65/ Av)/(32767 * Rshunt) */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* being Av the voltage gain between Rshunt and A/D input */");
        _builder.newLine();
        _builder.append("    ");
        _builder.newLine();
        if (!adv) {
            void _floor_7;
            void _round_111;
            void _floor_6;
            void _round_110;
            void ph4_final_duration;
            void _floor_5;
            void ph3_final_curr;
            void _round_109;
            void ph3_final_speed;
            void _floor_4;
            void ph2_final_curr;
            double _floor_3;
            _builder.append("\t");
            _builder.append("/* Sensor-less rev-up sequence (BASIC)*/");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("/* Phase 1 */");
            _builder.newLine();
            if (!align_en) {
                _builder.append("\t");
                _builder.append("#define STARTING_ANGLE_DEG             0 /*!< degrees [0...359] */");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("#define PHASE1_DURATION                0 /*milliseconds */");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("#define PHASE1_FINAL_SPEED_UNIT        (0*SPEED_UNIT/_RPM)/* rpm */");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("#define PHASE1_FINAL_CURRENT           0");
                _builder.newLine();
            } else {
                void ph1_final_curr;
                _builder.append("\t");
                _builder.append("#define STARTING_ANGLE_DEG             ");
                _builder.append((Object)align_angle, "\t");
                _builder.append("  /*!< degrees [0...359] */");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("#define PHASE1_DURATION                0 /*milliseconds */");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("#define PHASE1_FINAL_SPEED_UNIT        (0*SPEED_UNIT/_RPM) /* rpm */");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("#define PHASE1_FINAL_CURRENT           ");
                double d96 = Math.floor((double)ph1_final_curr);
                _builder.append((Object)_floor_3, "\t");
                _builder.append("    /*!< s16A */");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("/* Phase 2 */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define PHASE2_DURATION                ");
            _builder.append((Object)align_duration, "\t");
            _builder.append(" /*milliseconds */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define PHASE2_FINAL_SPEED_UNIT        0 /* rpm */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define PHASE2_FINAL_CURRENT           ");
            _floor_3 = Math.floor((double)ph2_final_curr);
            _builder.append((Object)((double)_floor_4), "\t");
            _builder.append("    /*!< s16A */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("/* Phase 3 */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define PHASE3_DURATION                ");
            _builder.append((Object)ph3_duration_val, "\t");
            _builder.append(" /*milliseconds */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define PHASE3_FINAL_SPEED_UNIT        (");
            int n29 = Math.round((float)ph3_final_speed);
            _builder.append((Object)((int)_round_109), "\t");
            _builder.append("*SPEED_UNIT/_RPM)/* rpm */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define PHASE3_FINAL_CURRENT           ");
            double d97 = Math.floor((double)ph3_final_curr);
            _builder.append((Object)((double)_floor_5), "\t");
            _builder.append("    /*!< s16A */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("/* Phase 4 */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define PHASE4_DURATION                ");
            _builder.append((Object)((int)ph4_final_duration), "\t");
            _builder.append(" /*milliseconds */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define PHASE4_FINAL_SPEED_UNIT        (");
            int n30 = Math.round(speed_fin_val);
            _builder.append((Object)((int)_round_110), "\t");
            _builder.append("*SPEED_UNIT/_RPM) /* rpm */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define PHASE4_FINAL_CURRENT           ");
            double d98 = Math.floor((double)ph3_final_curr);
            _builder.append((Object)((double)_floor_6), "\t");
            _builder.append("    /*!< s16A */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("/* Phase 5 */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define PHASE5_DURATION                0 /* milliseconds */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define PHASE5_FINAL_SPEED_UNIT        (");
            int n31 = Math.round(speed_fin_val);
            _builder.append((Object)((int)_round_111), "\t");
            _builder.append("*SPEED_UNIT/_RPM) /* rpm */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define PHASE5_FINAL_CURRENT           ");
            double d99 = Math.floor((double)ph3_final_curr);
            _builder.append((Object)((double)_floor_7), "\t");
            _builder.append("    /*!< s16A */");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define ENABLE_SL_ALGO_FROM_PHASE      3");
            _builder.newLine();
        } else {
            void exec;
            void _floor_12;
            void ph5_fin_curr;
            void _round_116;
            void ph5_fin_speed;
            void ph5_duration;
            void _floor_11;
            void ph4_fin_curr;
            void _round_115;
            void _floor_10;
            void ph3_fin_curr;
            void _round_114;
            void _floor_9;
            void ph2_fin_curr;
            void _round_113;
            void _floor_8;
            void ph1_fin_curr;
            void _round_112;
            _builder.append("\t");
            _builder.append("/* Sensor-less rev-up sequence (ADV)*/");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define STARTING_ANGLE_DEG             ");
            _builder.append((Object)adv_align_angle, "\t");
            _builder.append("  /*!< degrees [0...359] */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("/* Phase 1 */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define PHASE1_DURATION                ");
            _builder.append((Object)ph1_duration, "\t");
            _builder.append(" /*milliseconds */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define PHASE1_FINAL_SPEED_UNIT        (");
            int _floor_4 = Math.round(ph1_fin_speed);
            _builder.append((Object)((int)_round_112), "\t");
            _builder.append("*SPEED_UNIT/_RPM) /* rpm */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define PHASE1_FINAL_CURRENT           ");
            double d100 = Math.floor((double)ph1_fin_curr);
            _builder.append((Object)((double)_floor_8), "\t");
            _builder.append("    /*!< s16A */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("/* Phase 2 */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define PHASE2_DURATION                ");
            _builder.append((Object)ph2_duration, "\t");
            _builder.append(" /*milliseconds */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define PHASE2_FINAL_SPEED_UNIT        (");
            int _floor_5 = Math.round(ph2_fin_speed);
            _builder.append((Object)((int)_round_113), "\t");
            _builder.append("*SPEED_UNIT/_RPM) /* rpm */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define PHASE2_FINAL_CURRENT           ");
            double d101 = Math.floor((double)ph2_fin_curr);
            _builder.append((Object)((double)_floor_9), "\t");
            _builder.append("    /*!< s16A */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("/* Phase 3 */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define PHASE3_DURATION                ");
            _builder.append((Object)ph3_duration, "\t");
            _builder.append(" /*milliseconds */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define PHASE3_FINAL_SPEED_UNIT        (");
            int _floor_6 = Math.round(ph3_fin_speed);
            _builder.append((Object)((int)_round_114), "\t");
            _builder.append("*SPEED_UNIT/_RPM)/* rpm */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define PHASE3_FINAL_CURRENT           ");
            double d102 = Math.floor((double)ph3_fin_curr);
            _builder.append((Object)((double)_floor_10), "\t");
            _builder.append("    /*!< s16A */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("/* Phase 4 */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define PHASE4_DURATION                ");
            _builder.append((Object)ph4_duration, "\t");
            _builder.append(" /*milliseconds */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define PHASE4_FINAL_SPEED_UNIT        (");
            int _floor_7 = Math.round(ph4_fin_speed);
            _builder.append((Object)((int)_round_115), "\t");
            _builder.append("*SPEED_UNIT/_RPM) /* rpm */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define PHASE4_FINAL_CURRENT           ");
            double d103 = Math.floor((double)ph4_fin_curr);
            _builder.append((Object)((double)_floor_11), "\t");
            _builder.append("    /*!< s16A */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("/* Phase 5 */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define PHASE5_DURATION                ");
            _builder.append((Object)((int)ph5_duration), "\t");
            _builder.append(" /*milliseconds */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define PHASE5_FINAL_SPEED_UNIT        (");
            int n32 = Math.round((float)ph5_fin_speed);
            _builder.append((Object)((int)_round_116), "\t");
            _builder.append("*SPEED_UNIT/_RPM)/* rpm */");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define PHASE5_FINAL_CURRENT           ");
            double d104 = Math.floor((double)ph5_fin_curr);
            _builder.append((Object)((double)_floor_12), "\t");
            _builder.append("    /*!< s16A */");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define ENABLE_SL_ALGO_FROM_PHASE      ");
            _builder.append((Object)exec, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* Observer start-up output conditions */");
        _builder.newLine();
        if (main_sel == SensorSelection_enum.OBSERVER_HFI) {
            void hfi_lower_limit;
            void hfi_upper_limit;
            void _round_118;
            void hfi_cons_startup;
            void hfi_sto_th;
            _builder.append("\t");
            _builder.append("#define OBS_MINIMUM_SPEED_RPM          ");
            int _round_112 = Math.round((float)hfi_sto_th);
            _builder.append((Object)_round_117, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define NB_CONSECUTIVE_TESTS           ");
            int _floor_8 = Math.round((float)hfi_cons_startup);
            _builder.append((Object)((int)_round_118), "\t");
            _builder.append(" /* corresponding to ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("former NB_CONSECUTIVE_TESTS/");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("(TF_REGULATION_RATE/");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("MEDIUM_FREQUENCY_TASK_RATE) */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define SPEED_BAND_UPPER_LIMIT         ");
            long _round_109 = Math.round((double)hfi_upper_limit);
            _builder.append((Object)_round_119, "\t");
            _builder.append(" /*!< It expresses how much ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("estimated speed can exceed ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("forced stator electrical ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("without being considered wrong. ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("In 1/16 of forced speed */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define SPEED_BAND_LOWER_LIMIT         ");
            long _floor_9 = Math.round((double)hfi_lower_limit);
            _builder.append((Object)_round_120, "\t");
            _builder.append("  /*!< It expresses how much ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("estimated speed can be below ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("forced stator electrical ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("without being considered wrong. ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("In 1/16 of forced speed */");
            _builder.newLine();
            _builder.newLine();
        } else {
            void lower_limit;
            void upper_limit;
            void _round_122;
            void cons_startup;
            void _round_121;
            void min_startup;
            _builder.append("\t");
            _builder.append("#define OBS_MINIMUM_SPEED_RPM          ");
            _round_117 = Math.round((float)min_startup);
            _builder.append((Object)((int)_round_121), "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define NB_CONSECUTIVE_TESTS           ");
            int _round_118 = Math.round((float)cons_startup);
            _builder.append((Object)((int)_round_122), "\t");
            _builder.append(" /* corresponding to ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("former NB_CONSECUTIVE_TESTS/");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("(TF_REGULATION_RATE/");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("MEDIUM_FREQUENCY_TASK_RATE) */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define SPEED_BAND_UPPER_LIMIT         ");
            _round_119 = Math.round((double)upper_limit);
            _builder.append((Object)_round_123, "\t");
            _builder.append(" /*!< It expresses how much ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("estimated speed can exceed ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("forced stator electrical ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("without being considered wrong. ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("In 1/16 of forced speed */");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define SPEED_BAND_LOWER_LIMIT         ");
            _round_120 = Math.round((double)lower_limit);
            _builder.append((Object)_round_124, "\t");
            _builder.append("  /*!< It expresses how much ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("estimated speed can be below ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("forced stator electrical ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("without being considered wrong. ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
            _builder.append("In 1/16 of forced speed */");
            _builder.newLine();
        }
        if (en_switch_over == false) {
            _builder.append("\t");
            _builder.append("#define TRANSITION_DURATION            0  /* Switch over duration, ms */");
            _builder.newLine();
        } else {
            void duration_switch_over;
            _builder.append("\t");
            _builder.append("#define TRANSITION_DURATION            ");
            _builder.append((Object)((int)duration_switch_over), "\t");
            _builder.append("  /* Switch over duration, ms */");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("/******************************   ADDITIONAL FEATURES   **********************/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/******************************   Bus VOLTAGE Motor 1  **********************/");
        _builder.newLine();
        if (!vbus_voltage_reading) {
            _builder.newLine();
        } else {
            _builder.append("\t");
            _builder.append("#define  M1_VBUS_SAMPLING_TIME  LL_ADC_SAMPLING_CYCLE(47)\t/* HARDWIRED */");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/******************************   Temperature sensing Motor 1  **********************/");
        _builder.newLine();
        if (!temperature_reading) {
            _builder.newLine();
        } else {
            _builder.append("\t");
            _builder.append("#define  M1_TEMP_SAMPLING_TIME  LL_ADC_SAMPLING_CYCLE(47)  /* HARDWIRED */");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/******************************   Current sensing Motor 1   **********************/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#define ADC_SAMPLING_CYCLES (6 + SAMPLING_CYCLE_CORRECTION) //HARDWIRED");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.newLine();
        if (mtpa_enable != false && Objects.equals((Object)magnetic, "Surface Mounted PMSM")) {
            _builder.append("\t");
            _builder.append("/*Error created for managing these exceptions.The generation must fail*/");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("[#stop \"MTPA strategy not applicable on SM-PMSM\"]");
            _builder.newLine();
        }
        if (mtpa_enable != false && Ld >= Lq) {
            _builder.append("\t");
            _builder.append("/*Error created for managing these exceptions.The generation must fail*/");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("[#stop \"using MTPA strategy, Ld must be lower than Lq for I-PMSM\"]");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("/* Flux Weakening parameters */");
        _builder.newLine();
        if (fw_enable != false) {
            _builder.append("\t");
            _builder.append("#define  FLUX_WEAKENING_ENABLING       ENABLE");
            _builder.newLine();
        } else {
            _builder.append("\t");
            _builder.append("#define  FLUX_WEAKENING_ENABLING       DISABLE");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("#define  FW_VOLTAGE_REF                ");
        _builder.append((Object)((double)v_limit), "\t");
        _builder.append(" /*!<Vs reference, tenth ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        _builder.append("of a percent */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#define  FW_KP_GAIN                    ");
        _builder.append((Object)((int)fw_kp), "\t");
        _builder.append(" /*!< Default Kp gain */");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("#define  FW_KI_GAIN                    ");
        _builder.append((Object)((int)fw_ki), "\t");
        _builder.append(" /*!< Default Ki gain */");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("#define  FW_KPDIV                      ");
        _builder.append((Object)fw_kp_div, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t");
        _builder.append("/*!< Kp gain divisor.If FULL_MISRA_C_COMPLIANCY");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t");
        _builder.append("is not defined the divisor is implemented through");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t");
        _builder.append("algebrical right shifts to speed up PIs execution. ");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t");
        _builder.append("Only in this case this parameter specifies the ");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t");
        _builder.append("number of right shifts to be executed */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#define  FW_KIDIV                      ");
        _builder.append((Object)fw_ki_div, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t");
        _builder.append("/*!< Ki gain divisor.If FULL_MISRA_C_COMPLIANCY");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t");
        _builder.append("is not defined the divisor is implemented through");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t");
        _builder.append("algebrical right shifts to speed up PIs execution. ");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t");
        _builder.append("Only in this case this parameter specifies the ");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t");
        _builder.append("number of right shifts to be executed */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/*  Feed-forward parameters */");
        _builder.newLine();
        _builder.newLine();
        if (ff_enable != false) {
            void c2_QD;
            void _round_125;
            _builder.append("\t");
            _builder.append("#define FEED_FORWARD_CURRENT_REG_ENABLING   ENABLE");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define CONSTANT1_Q                    ");
            long _round_121 = Math.round(c1_Q);
            _builder.append((Object)((long)_round_125), "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define CONSTANT1_D                    ");
            _round_123 = Math.round(c1_D);
            _builder.append((Object)_round_126, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define CONSTANT2_QD                   ");
            _round_124 = Math.round((double)c2_QD);
            _builder.append((Object)_round_127, "\t");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("\t");
            _builder.append("#define FEED_FORWARD_CURRENT_REG_ENABLING   DISABLE");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define CONSTANT1_Q                    123532");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define CONSTANT1_D                    123532");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define CONSTANT2_QD                   5837");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/*  Maximum Torque Per Ampere strategy parameters */");
        _builder.newLine();
        if (mtpa_enable != false) {
            void _round_144;
            void off7;
            void _round_143;
            void off6;
            void _round_142;
            void off5;
            void _round_141;
            void off4;
            void _round_140;
            void off3;
            void _round_139;
            void off2;
            void _round_138;
            void off1;
            void _round_137;
            void _round_136;
            void _round_135;
            void _round_134;
            void _round_133;
            void _round_132;
            void _round_131;
            void _round_130;
            void m0;
            void _round_129;
            void cSegDiv;
            void _round_128;
            _builder.append("\t");
            _builder.append("#define MTPA_ENABLING                  ENABLE");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define IQMAX                          ");
            long _round_125 = Math.round((double)cIqmax);
            _builder.append((Object)((long)_round_128), "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define SEGDIV                         ");
            _round_126 = Math.round((double)cSegDiv);
            _builder.append((Object)((long)_round_129), "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define ANGC                           {");
            _round_127 = Math.round((double)m0);
            _builder.append((Object)((long)_round_130), "\t");
            _builder.append(",");
            long _round_114 = Math.round((double)m1);
            _builder.append((Object)((long)_round_131), "\t");
            _builder.append(",");
            long _round_111 = Math.round((double)m2);
            _builder.append((Object)((long)_round_132), "\t");
            _builder.append(",");
            long _floor_11 = Math.round((double)m3);
            _builder.append((Object)((long)_round_133), "\t");
            _builder.append(",");
            long _round_116 = Math.round((double)m4);
            _builder.append((Object)((long)_round_134), "\t");
            _builder.append(",");
            long l14 = Math.round((double)m5);
            _builder.append((Object)((long)_round_135), "\t");
            _builder.append(",");
            long l15 = Math.round((double)m6);
            _builder.append((Object)((long)_round_136), "\t");
            _builder.append(",");
            long l16 = Math.round((double)m7);
            _builder.append((Object)((long)_round_137), "\t");
            _builder.append("}");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define OFST                           {0,");
            long l17 = Math.round((double)off1);
            _builder.append((Object)((long)_round_138), "\t");
            _builder.append(",");
            long l18 = Math.round((double)off2);
            _builder.append((Object)((long)_round_139), "\t");
            _builder.append(",");
            long l19 = Math.round((double)off3);
            _builder.append((Object)((long)_round_140), "\t");
            _builder.append(",");
            long l20 = Math.round((double)off4);
            _builder.append((Object)((long)_round_141), "\t");
            _builder.append(",");
            long l21 = Math.round((double)off5);
            _builder.append((Object)((long)_round_142), "\t");
            _builder.append(",");
            long l22 = Math.round((double)off6);
            _builder.append((Object)((long)_round_143), "\t");
            _builder.append(",");
            long l23 = Math.round((double)off7);
            _builder.append((Object)((long)_round_144), "\t");
            _builder.append("}");
            _builder.newLineIfNotEmpty();
        } else {
            void _round_145;
            void nom_cur_digit;
            _builder.append("\t");
            _builder.append("#define MTPA_ENABLING                  DISABLE");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define IQMAX                          ");
            long _round_128 = Math.round((double)nom_cur_digit);
            _builder.append((Object)((long)_round_145), "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("#define SEGDIV                         0");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define ANGC                           {0,0,0,0,0,0,0,0}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("#define OFST                           {0,0,0,0,0,0,0,0}");
            _builder.newLine();
        }
        if (inrushcurr_enable) {
            _builder.append("\t");
            _builder.append("#define INRUSH_CURRLIMIT_ENABLING        ENABLE");
            _builder.newLine();
        } else {
            _builder.append("\t");
            _builder.append("#define INRUSH_CURRLIMIT_ENABLING        DISABLE");
            _builder.newLine();
        }
        if (po_state == Poweronstate_enum.INACTIVE) {
            _builder.append("\t");
            _builder.append("#define INRUSH_CURRLIMIT_AT_POWER_ON     INACTIVE   /* ACTIVE or INACTIVE */");
            _builder.newLine();
        } else {
            _builder.append("\t");
            _builder.append("#define INRUSH_CURRLIMIT_AT_POWER_ON     ACTIVE     /* ACTIVE or INACTIVE */");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("#define INRUSH_CURRLIMIT_CHANGE_AFTER_MS ");
        _builder.append((Object)after, "\t");
        _builder.append("       /* milliseconds */");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("/******************************** DEBUG ADD-ONs *******************************/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#define LCD_JOYSTICK_FUNCTIONALITY       DISABLE");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#define LCD_MODE                         LCD_FULL");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#define START_STOP_BTN                   DISABLE");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/******************************** PFC ENABLING ********************************/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* #define PFC_ENABLED to enable the PFC */ ");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("#endif /*__DRIVE_PARAMETERS_H*/");
        _builder.newLine();
        _builder.newLine();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    public String generateMcConfigCode(Component comp) {
        TIM_moduletype_enum main_hall_tim_module;
        TIM_moduletype_enum main_enc_tim_module;
        String _xblockexpression = null;
        ControlStage ControlStage2 = ((Motorcontrol)comp).getControl_stage();
        PWM_functionality pwm_functionality = ControlStage2.getPwm_functionality();
        PWM_moduletype_enum pwm_module = pwm_functionality.getPWM_Module();
        PWM_channeltype_enum pwm_u_ch = pwm_functionality.getPWM_U_channel();
        PWM_channeltype_enum pwm_v_ch = pwm_functionality.getPWM_V_channel();
        PWM_channeltype_enum pwm_w_ch = pwm_functionality.getPWM_W_channel();
        PWM_channeltype_enum pwm_adc_trig_ch = pwm_functionality.getPWM_ADC_Trig_channel();
        CURRENTSENSING_functionality currentsensing = ControlStage2.getCurrentSensing();
        OVERCURRENT_BRK_POLARITY_enum brk_polarity = currentsensing.getOvercurrent_brk_polarity();
        OVERCURRENT_BRK_FILTERTYPE_enum brk_filter_div = currentsensing.getOvercurrent_brk_filter();
        boolean brk2_enable = currentsensing.isBrk2_enable();
        OVERCURRENT_BRK2_POLARITY_enum brk2_polarity = currentsensing.getOvercurrent_brk2_polarity();
        OVERCURRENT_BRK2_FILTERTYPE_enum brk2_filter_div = currentsensing.getOvercurrent_brk2_filter();
        ADC_COUPLE_enum adc_curr_ab = currentsensing.getADC_Current_IA_IB_Selection();
        ADC_MODULETYPE_enum adc_curr_c = currentsensing.getADC_Current_C_Selection();
        ADC_CHANNELTYPE_enum adc_ch_a = currentsensing.getADC_Channel_IA();
        ADC_CHANNELTYPE_enum adc_ch_c = currentsensing.getADC_Channel_IB();
        ADC_CHANNELTYPE_enum adc_ch_b = currentsensing.getADC_Channel_IC();
        DACFunctionality dac_funcionality = ControlStage2.getDac_functionality();
        boolean dac_active = dac_funcionality.isDac_enable();
        CH1_enum debug_dac_ch1 = dac_funcionality.getDebug_ch1();
        CH2_enum debug_dac_ch2 = dac_funcionality.getDebug_ch2();
        DAC_MODETYPE_enum dac_mode = dac_funcionality.getDac_mode();
        DAC_TIM_MODULETYPE_enum dac_tim_module = dac_funcionality.getDac_timer_selection();
        DAC_TIM_CHANNELTYPE_enum dac_tim_ch1 = dac_funcionality.getCh1_timer_channel();
        DAC_TIM_CHANNELTYPE_enum dac_tim_ch2 = dac_funcionality.getCh2_timer_channel();
        BDAC_CHANNELTYPE_enum bdac_ch1 = dac_funcionality.getCh1_bdac_channel();
        BDAC_CHANNELTYPE_enum bdac_ch2 = dac_funcionality.getCh2_bdac_channel();
        CH1Variable_enum variable_ch1 = dac_funcionality.getCh1_variable();
        CH2Variable_enum variable_ch2 = dac_funcionality.getCh2_variable();
        ResolverInterface resolverinterface = ControlStage2.getResolver();
        ADC_RESOLVER_enum res_adc = resolverinterface.getResolver_adc_selection();
        SinCosSensing sincos = resolverinterface.getSin_cos_sensing();
        ADC_CHANNELTYPE_enum adc_sin_ch = sincos.getAdc_channel_for_sin();
        ADC_CHANNELTYPE_enum adc_cos_ch = sincos.getAdc_channel_for_cos();
        BDAC_CHANNELTYPE_enum res_dac_ch = resolverinterface.getResolver_bdac_channel();
        RES_DMA_CONFIG res_dma = resolverinterface.getResolver_dma();
        RES_DMA_MOD_enum res_dma_mod = res_dma.getRes_dma_mode();
        RES_DMA_STREAMTYPE_enum res_dma_st = res_dma.getRes_dma_stream();
        RES_DMAMUX1_CHANNELTYPE_enum res_dmamux1_ch = res_dma.getRes_dmamux1_channel();
        RES_DMAMUX2_CHANNELTYPE_enum res_dmamux2_ch = res_dma.getRes_dmamux2_channel();
        VBUS_TEMP_CONTAINER vbus_temp = ControlStage2.getVbus_temp_measures();
        VBUS_TEMP_MODETYPE_enum vbus_mode = vbus_temp.getVbus_sensing_mode();
        ADC_MODULETYPE_enum adc_vbus_mod = vbus_temp.getVbus_adc_module();
        ADC_CHANNELTYPE_enum adc_vbus_ch = vbus_temp.getVbus_adc_channel();
        TIM_moduletype_enum tim_vbus_mod = vbus_temp.getVbus_tim_module();
        SENSING_TIM_CHANNELTYPE_enum tim_vbus_ch = vbus_temp.getVbus_tim_channel();
        INPUT_FILTERTYPE_enum tim_vbus_filter = vbus_temp.getVbus_tim_filter();
        int tim_vbus_device = vbus_temp.getVbus_tim_device();
        VBUS_TEMP_MODETYPE_enum temp_mode = vbus_temp.getTemp_sensing_mode();
        ADC_MODULETYPE_enum adc_temp_mod = vbus_temp.getTemp_adc_module();
        ADC_CHANNELTYPE_enum adc_temp_ch = vbus_temp.getTemp_adc_channel();
        int tim_temp_device = vbus_temp.getTemp_tim_device();
        TIM_moduletype_enum tim_temp_mod = vbus_temp.getTemp_tim_module();
        SENSING_TIM_CHANNELTYPE_enum tim_temp_ch = vbus_temp.getTemp_tim_channel();
        INPUT_FILTERTYPE_enum tim_temp_filter = vbus_temp.getTemp_tim_filter();
        DriveManagement DriveMan = ((Motorcontrol)comp).getDrive_management();
        HighsidePWMidlestate_enum hs_idle = DriveMan.getDrive_settings().getPwm_generation_and_current_reading().getHigh_side_pwm_idle_state();
        LowsidePWMidlestate_enum ls_idle = DriveMan.getDrive_settings().getPwm_generation_and_current_reading().getLow_side_signals_and_dead_time().getLow_side_pwm_idle_state();
        ControlStage Ctrl_stage = ((Motorcontrol)comp).getControl_stage();
        TIM_moduletype_enum aux_enc_tim_module = main_enc_tim_module = Ctrl_stage.getEncoder().getTim_module();
        TIM_moduletype_enum aux_hall_tim_module = main_hall_tim_module = Ctrl_stage.getHall().getTim_module();
        PWM_channeltype_enum enc_tim_cha = Ctrl_stage.getEncoder().getEncoder_channels().getEncoder_tim_a();
        PWM_channeltype_enum enc_tim_chb = Ctrl_stage.getEncoder().getEncoder_channels().getEncoder_tim_b();
        PWM_channeltype_enum hall_tim_ch_s1 = Ctrl_stage.getHall().getHall_channels().getHall_sensor_for_s1();
        PWM_channeltype_enum hall_tim_ch_s2 = Ctrl_stage.getHall().getHall_channels().getHall_sensor_for_s2();
        PWM_channeltype_enum hall_tim_ch_s3 = Ctrl_stage.getHall().getHall_channels().getHall_sensor_for_s3();
        SensorSelection_enum main_sel = DriveMan.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_selection();
        boolean en_aux_sel = DriveMan.getSpeed_sensor_selection().getAuxiliary_sensor().isEnable_auxiliary_sensor();
        boolean enableui = DriveMan.getUser_interface().isEnable_ui();
        SensorSelection_enum aux_sel = DriveMan.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getSensor_selection();
        CanChannel_enum can_ch = DriveMan.getUser_interface().getCan_details().getCanchannel();
        CanBaudRate_enum can_br = DriveMan.getUser_interface().getCan_details().getCanbaudrate();
        int can_start = DriveMan.getUser_interface().getCan_details().getStarting_tx_message_id();
        int can_max_msg = DriveMan.getUser_interface().getCan_details().getMax_message_length();
        COMSelection_enum com_sel = DriveMan.getUser_interface().getCom_selection();
        SerialChannel_enum ser_sel = DriveMan.getUser_interface().getSerial_details().getSerialchannel();
        boolean ser_swap = DriveMan.getUser_interface().getSerial_details().isTxrx_swap();
        SerialBaudRate_enum ser_br = DriveMan.getUser_interface().getSerial_details().getSerialbaudrate();
        boolean ser_bidir = DriveMan.getUser_interface().getSerial_details().isBidirectional();
        PowerStage PowerStage2 = ((Motorcontrol)comp).getPower_stage();
        boolean ovrcurrent_rpot_en = PowerStage2.getOver_current_protection().isOvercurrent_protection_enable();
        Complementedfromhighside_enum hs_complemented = PowerStage2.getPhase_drivers().getComplemented_from_high_side();
        DriverEnablingSignal_enum hs_signal = PowerStage2.getPhase_drivers().getDriver_enabling_signal();
        CurrentReadingTopology_enum topology = PowerStage2.getCurrent_sensing().getCurrent_reading_topology();
        CurrentSensing settingsP = PowerStage2.getCurrent_sensing();
        Amplificationselection_enum Vamp_selection = settingsP.getAmplification_selection();
        boolean threeshunt = false;
        boolean _equals = Objects.equals((Object)topology, (Object)CurrentReadingTopology_enum.THREE_SHUNT_RESISTOR);
        if (_equals) {
            threeshunt = true;
        }
        boolean InitADC1 = false;
        boolean InitADC2 = false;
        boolean InitADC3 = false;
        boolean InitADC4 = false;
        boolean InitADC5 = false;
        if (Objects.equals((Object)res_adc, (Object)ADC_RESOLVER_enum.ADC1_ADC2) && (Objects.equals((Object)main_sel, (Object)SensorSelection_enum.RESOLVER) || aux_sel == SensorSelection_enum.RESOLVER && en_aux_sel) || Objects.equals((Object)res_adc, (Object)ADC_RESOLVER_enum.ADC1) && (Objects.equals((Object)main_sel, (Object)SensorSelection_enum.RESOLVER) || aux_sel == SensorSelection_enum.RESOLVER && en_aux_sel) || Objects.equals((Object)adc_curr_ab, (Object)ADC_COUPLE_enum.ADC1_ADC2) || Objects.equals((Object)adc_curr_c, (Object)ADC_MODULETYPE_enum.ADC1) && threeshunt) {
            InitADC1 = false;
        } else if (Objects.equals((Object)adc_vbus_mod, (Object)ADC_MODULETYPE_enum.ADC1) && Objects.equals((Object)vbus_mode, (Object)VBUS_TEMP_MODETYPE_enum.ADC) || Objects.equals((Object)adc_temp_mod, (Object)ADC_MODULETYPE_enum.ADC1) && Objects.equals((Object)temp_mode, (Object)VBUS_TEMP_MODETYPE_enum.ADC)) {
            InitADC1 = true;
        }
        if (Objects.equals((Object)res_adc, (Object)ADC_RESOLVER_enum.ADC1_ADC2) && (Objects.equals((Object)main_sel, (Object)SensorSelection_enum.RESOLVER) || aux_sel == SensorSelection_enum.RESOLVER && en_aux_sel) || Objects.equals((Object)res_adc, (Object)ADC_RESOLVER_enum.ADC2) && (Objects.equals((Object)main_sel, (Object)SensorSelection_enum.RESOLVER) || aux_sel == SensorSelection_enum.RESOLVER && en_aux_sel) || Objects.equals((Object)adc_curr_ab, (Object)ADC_COUPLE_enum.ADC1_ADC2) || Objects.equals((Object)adc_curr_c, (Object)ADC_MODULETYPE_enum.ADC2) && threeshunt) {
            InitADC2 = false;
        } else if (Objects.equals((Object)adc_vbus_mod, (Object)ADC_MODULETYPE_enum.ADC2) && Objects.equals((Object)vbus_mode, (Object)VBUS_TEMP_MODETYPE_enum.ADC) || Objects.equals((Object)adc_temp_mod, (Object)ADC_MODULETYPE_enum.ADC2) && Objects.equals((Object)temp_mode, (Object)VBUS_TEMP_MODETYPE_enum.ADC)) {
            InitADC2 = true;
        }
        if (Objects.equals((Object)res_adc, (Object)ADC_RESOLVER_enum.ADC3_ADC4) && (Objects.equals((Object)main_sel, (Object)SensorSelection_enum.RESOLVER) || aux_sel == SensorSelection_enum.RESOLVER && en_aux_sel) || Objects.equals((Object)res_adc, (Object)ADC_RESOLVER_enum.ADC3) && (Objects.equals((Object)main_sel, (Object)SensorSelection_enum.RESOLVER) || aux_sel == SensorSelection_enum.RESOLVER && en_aux_sel) || Objects.equals((Object)adc_curr_ab, (Object)ADC_COUPLE_enum.ADC3_ADC4) || Objects.equals((Object)adc_curr_c, (Object)ADC_MODULETYPE_enum.ADC3) && threeshunt) {
            InitADC3 = false;
        } else if (Objects.equals((Object)adc_vbus_mod, (Object)ADC_MODULETYPE_enum.ADC3) && Objects.equals((Object)vbus_mode, (Object)VBUS_TEMP_MODETYPE_enum.ADC) || Objects.equals((Object)adc_temp_mod, (Object)ADC_MODULETYPE_enum.ADC3) && Objects.equals((Object)temp_mode, (Object)VBUS_TEMP_MODETYPE_enum.ADC)) {
            InitADC3 = true;
        }
        if (Objects.equals((Object)res_adc, (Object)ADC_COUPLE_enum.ADC3_ADC4) && (Objects.equals((Object)main_sel, (Object)SensorSelection_enum.RESOLVER) || aux_sel == SensorSelection_enum.RESOLVER && en_aux_sel) || Objects.equals((Object)res_adc, (Object)ADC_RESOLVER_enum.ADC4) && (Objects.equals((Object)main_sel, (Object)SensorSelection_enum.RESOLVER) || aux_sel == SensorSelection_enum.RESOLVER && en_aux_sel) || Objects.equals((Object)adc_curr_ab, (Object)ADC_COUPLE_enum.ADC3_ADC4) || Objects.equals((Object)adc_curr_c, (Object)ADC_MODULETYPE_enum.ADC4) && threeshunt) {
            InitADC4 = false;
        } else if (Objects.equals((Object)adc_vbus_mod, (Object)ADC_MODULETYPE_enum.ADC4) && Objects.equals((Object)vbus_mode, (Object)VBUS_TEMP_MODETYPE_enum.ADC) || Objects.equals((Object)adc_temp_mod, (Object)ADC_MODULETYPE_enum.ADC4) && Objects.equals((Object)temp_mode, (Object)VBUS_TEMP_MODETYPE_enum.ADC)) {
            InitADC4 = true;
        }
        if (Objects.equals((Object)res_adc, (Object)ADC_RESOLVER_enum.ADC5) && (Objects.equals((Object)main_sel, (Object)SensorSelection_enum.RESOLVER) || aux_sel == SensorSelection_enum.RESOLVER && en_aux_sel) || Objects.equals((Object)adc_curr_c, (Object)ADC_MODULETYPE_enum.ADC5) && threeshunt) {
            InitADC5 = false;
        } else if (Objects.equals((Object)adc_vbus_mod, (Object)ADC_MODULETYPE_enum.ADC5) && Objects.equals((Object)vbus_mode, (Object)VBUS_TEMP_MODETYPE_enum.ADC) || Objects.equals((Object)adc_temp_mod, (Object)ADC_MODULETYPE_enum.ADC5) && Objects.equals((Object)temp_mode, (Object)VBUS_TEMP_MODETYPE_enum.ADC)) {
            InitADC5 = true;
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/****************************************************************************");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("* Copyright (c) 2023 STMicroelectronics - All Rights Reserved");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("* License terms: STMicroelectronics Proprietary in accordance with licensing");
        _builder.newLine();
        _builder.append("* terms SLA0098 at www.st.com.");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("* THIS SOFTWARE IS DISTRIBUTED \"AS IS,\" AND ALL WARRANTIES ARE DISCLAIMED,");
        _builder.newLine();
        _builder.append("* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("*****************************************************************************/");
        _builder.newLine();
        _builder.append("/*");
        _builder.newLine();
        _builder.append("* @file    mc_config.h");
        _builder.newLine();
        _builder.append("* @author  Motor Control SDK Team, ST Microelectronics");
        _builder.newLine();
        _builder.append("* @brief   Motor Control Subsystem components configuration and handler");
        _builder.newLine();
        _builder.append("*          structures declarations.");
        _builder.newLine();
        _builder.append("*/");
        _builder.newLine();
        _builder.append("#ifndef __MC_CONFIG_H");
        _builder.newLine();
        _builder.append("#define __MC_CONFIG_H");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include \"pid_regulator.h\"");
        _builder.newLine();
        _builder.append("#include \"revup_ctrl.h\"");
        _builder.newLine();
        _builder.append("#include \"speed_torq_ctrl.h\"");
        _builder.newLine();
        _builder.append("#include \"virtual_speed_sensor.h\"");
        _builder.newLine();
        _builder.append("#include \"ntc_temperature_sensor.h\"");
        _builder.newLine();
        _builder.append("#include \"pwm_curr_fdbk.h\"");
        _builder.newLine();
        _builder.append("#include \"r_divider_bus_voltage_sensor.h\"");
        _builder.newLine();
        _builder.append("#include \"virtual_bus_voltage_sensor.h\"");
        _builder.newLine();
        _builder.append("#include \"pqd_motor_power_measurement.h\"");
        _builder.newLine();
        _builder.append("#include \"user_interface.h\"");
        _builder.newLine();
        _builder.append("#include \"motor_control_protocol.h\"");
        _builder.newLine();
        _builder.append("#include \"usart_frame_communication_protocol.h\"");
        _builder.newLine();
        _builder.append("#include \"can_frame_communication_protocol.h\"");
        _builder.newLine();
        _builder.append("#include \"dac_common_ui.h\"");
        _builder.newLine();
        _builder.append("#include \"dac_rctimer_ui.h\"");
        _builder.newLine();
        _builder.append("#include \"dac_ui.h\"");
        _builder.newLine();
        _builder.append("#include \"ics_SR5E1_pwm_curr_fdbk.h\"");
        _builder.newLine();
        _builder.append("#include \"encoder_speed_pos_fdbk.h\"");
        _builder.newLine();
        _builder.append("#include \"resolver_SR5E1_speed_pos_fdbk.h\"");
        _builder.newLine();
        _builder.append("#include \"enc_align_ctrl.h\"");
        _builder.newLine();
        _builder.append("#include \"hall_speed_pos_fdbk.h\"        ");
        _builder.newLine();
        _builder.append("#include \"ramp_ext_mngr.h\"");
        _builder.newLine();
        _builder.append("#include \"circle_limitation.h\"");
        _builder.newLine();
        _builder.append("#include \"sto_speed_pos_fdbk.h\"");
        _builder.newLine();
        _builder.append("#include \"sto_pll_speed_pos_fdbk.h\"");
        _builder.newLine();
        _builder.append("#include \"external_adc_out.h\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#ifdef USE_STGAP1S");
        _builder.newLine();
        _builder.append("#include \"gap_gate_driver_ctrl.h\"");
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        _builder.newLine();
        _builder.append("extern RevUpCtrl_Handle_t RevUpControlM1;");
        _builder.newLine();
        _builder.append("extern PID_Handle_t PIDSpeedHandle_M1;");
        _builder.newLine();
        _builder.append("extern PID_Handle_t PIDIqHandle_M1;");
        _builder.newLine();
        _builder.append("extern PID_Handle_t PIDIdHandle_M1;");
        _builder.newLine();
        _builder.append("extern NTC_Handle_t TempSensorParamsM1;");
        _builder.newLine();
        _builder.append("extern PWMC_ICS_Handle_t PWM_Handle_M1;");
        _builder.newLine();
        _builder.append("extern SpeednTorqCtrl_Handle_t SpeednTorqCtrlM1;");
        _builder.newLine();
        _builder.append("extern PQD_MotorPowMeas_Handle_t PQD_MotorPowMeasM1;");
        _builder.newLine();
        _builder.append("extern PQD_MotorPowMeas_Handle_t *pPQD_MotorPowMeasM1;");
        _builder.newLine();
        _builder.append("extern VirtualSpeedSensor_Handle_t VirtualSpeedSensorM1;");
        _builder.newLine();
        _builder.append("extern STO_Handle_t STO_M1;");
        _builder.newLine();
        _builder.append("extern STO_PLL_Handle_t STO_PLL_M1;");
        _builder.newLine();
        _builder.append("extern ENCODER_Handle_t ENCODER_M1;");
        _builder.newLine();
        _builder.append("extern EncAlign_Handle_t EncAlignCtrlM1;");
        _builder.newLine();
        _builder.append("extern HALL_Handle_t HALL_M1;");
        _builder.newLine();
        _builder.append("extern Resolver_SR5E1_Handle_t Resolver_M1;");
        _builder.newLine();
        _builder.append("extern RDivider_Handle_t RealBusVoltageSensorParamsM1;");
        _builder.newLine();
        _builder.append("extern VirtualBusVoltageSensor_Handle_t VirtualBusVoltageSensorParamsM1;");
        _builder.newLine();
        _builder.append("extern CircleLimitation_Handle_t CircleLimitationM1;");
        _builder.newLine();
        _builder.append("extern RampExtMngr_Handle_t RampExtMngrHFParamsM1;");
        _builder.newLine();
        _builder.append("extern UI_Handle_t UI_Params;");
        _builder.newLine();
        _builder.append("extern DAC_UI_Handle_t DAC_UI_Params;");
        _builder.newLine();
        _builder.append("extern UFCP_Handle_t pUSART;");
        _builder.newLine();
        _builder.append("extern CFCP_Handle_t pFDCAN;");
        _builder.newLine();
        _builder.append("extern Ext_ADC_OUT_t VBUS_EXT_ADCOUT_M1;");
        _builder.newLine();
        _builder.append("extern Ext_ADC_OUT_t TEMP_EXT_ADCOUT_M1;        ");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#ifdef USE_STGAP1S");
        _builder.newLine();
        _builder.append("extern GAP_Handle_t STGAP_M1;");
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/* enable ITCM */");
        _builder.newLine();
        _builder.append("#define MCTK_ITCM");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#define NBR_OF_MOTORS 1\t\t");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/* PWM Module section */");
        _builder.newLine();
        _builder.append("#define PWM_MODULE_SELECTION              ");
        String _literal = pwm_module.getLiteral();
        _builder.append(_literal);
        _builder.append("    ");
        _builder.newLineIfNotEmpty();
        _builder.append("/* TIM channel assignment */");
        _builder.newLine();
        _builder.append("#define TIMx_UH_CHANNEL       (LL_TIM_");
        String _literal_1 = pwm_u_ch.getLiteral();
        _builder.append(_literal_1);
        _builder.append(")  /* Phase A Top transistor channel */");
        _builder.newLineIfNotEmpty();
        _builder.append("#define TIMx_UL_CHANNEL       (LL_TIM_");
        String _literal_2 = pwm_u_ch.getLiteral();
        _builder.append(_literal_2);
        _builder.append("N) /* Phase A Bottom transistor channel */");
        _builder.newLineIfNotEmpty();
        _builder.append("#define TIMx_VH_CHANNEL       (LL_TIM_");
        String _literal_3 = pwm_v_ch.getLiteral();
        _builder.append(_literal_3);
        _builder.append(")  /* Phase B Top transistor channel */ ");
        _builder.newLineIfNotEmpty();
        _builder.append("#define TIMx_VL_CHANNEL       (LL_TIM_");
        String _literal_4 = pwm_v_ch.getLiteral();
        _builder.append(_literal_4);
        _builder.append("N) /* Phase B Bottom transistor channel */ ");
        _builder.newLineIfNotEmpty();
        _builder.append("#define TIMx_WH_CHANNEL       (LL_TIM_");
        String _literal_5 = pwm_w_ch.getLiteral();
        _builder.append(_literal_5);
        _builder.append(")  /* Phase C Top transistor channel */");
        _builder.newLineIfNotEmpty();
        _builder.append("#define TIMx_WL_CHANNEL       (LL_TIM_");
        String _literal_6 = pwm_w_ch.getLiteral();
        _builder.append(_literal_6);
        _builder.append("N) /* Phase C Bottom transistor channel */");
        _builder.newLineIfNotEmpty();
        _builder.append("#define TIMx_ADC_TRG_CH       (LL_TIM_");
        String _literal_7 = pwm_adc_trig_ch.getLiteral();
        _builder.append(_literal_7);
        _builder.append(")  /* ADC trigger channel (current sensing) */");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _equals_1 = Objects.equals((Object)pwm_module, (Object)PWM_moduletype_enum.TIM1);
        if (_equals_1) {
            _builder.append("#define ICS_ADC_INJ_TRIG_EXT_TIMx_TRGO         LL_ADC_INJ_TRIG_EXT_TIM1_TRGO");
            _builder.newLine();
        } else {
            _builder.append("#define ICS_ADC_INJ_TRIG_EXT_TIMx_TRGO         LL_ADC_INJ_TRIG_EXT_TIM8_TRGO");
            _builder.newLine();
        }
        _builder.append("/* IDLE state --> to be moved into drive paramters.h file */");
        _builder.newLine();
        boolean _equals_2 = Objects.equals((Object)hs_idle, (Object)HighsidePWMidlestate_enum.TURN_OFF);
        if (_equals_2) {
            _builder.append("#define PWM_HIGH_SIDE_IDLE_STATE (LL_TIM_OCIDLESTATE_LOW)");
            _builder.newLine();
        } else {
            _builder.append("#define PWM_HIGH_SIDE_IDLE_STATE (LL_TIM_OCIDLESTATE_HIGH)");
            _builder.newLine();
        }
        _builder.newLine();
        boolean _equals_3 = Objects.equals((Object)ls_idle, (Object)LowsidePWMidlestate_enum.TURN_OFF);
        if (_equals_3) {
            _builder.append("#define PWM_LOW_SIDE_IDLE_STATE (LL_TIM_OCIDLESTATE_LOW)");
            _builder.newLine();
        } else {
            _builder.append("#define PWM_LOW_SIDE_IDLE_STATE (LL_TIM_OCIDLESTATE_HIGH)");
            _builder.newLine();
        }
        if (hs_complemented != Complementedfromhighside_enum.ENABLE || hs_signal != DriverEnablingSignal_enum.ENABLE) {
            _builder.append("/* These pin must be defined only for ES_GPIO configuration */");
            _builder.newLine();
            _builder.append("#define ENABLE_CH1 0");
            _builder.newLine();
            _builder.append("#define ENABLE_CH2 0");
            _builder.newLine();
            _builder.append("#define ENABLE_CH3 0\t\t");
            _builder.newLine();
        }
        _builder.append("/* over current protection */");
        _builder.newLine();
        _builder.append("/* enable/disable in power stage over current protection */");
        _builder.newLine();
        if (ovrcurrent_rpot_en) {
            _builder.append("#define SW_OV_CURRENT_PROT_ENABLING (LL_TIM_BREAK_ENABLE)");
            _builder.newLine();
        } else {
            _builder.append("#define SW_OV_CURRENT_PROT_ENABLING (LL_TIM_BREAK_DISABLE)");
            _builder.newLine();
        }
        _builder.append("#define OVERCURR_FEEDBACK_POLARITY  (LL_TIM_BREAK_POLARITY_");
        String _literal_8 = brk_polarity.getLiteral();
        _builder.append(_literal_8);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.append("#define OVERCURR_BREAK_FILTER       (LL_TIM_BREAK_FILTER_");
        String _literal_9 = brk_filter_div.getLiteral();
        _builder.append(_literal_9);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/* PWM BREAK2 */");
        _builder.newLine();
        if (brk2_enable) {
            _builder.append("#define ICS_BREAK2_ENABLING           (LL_TIM_BREAK2_ENABLE)");
            _builder.newLine();
        } else {
            _builder.append("#define ICS_BREAK2_ENABLING           (LL_TIM_BREAK2_DISABLE)\t\t");
            _builder.newLine();
        }
        _builder.append("#define ICS_BREAK2_FEEDBACK_POLARITY  (LL_TIM_BREAK2_POLARITY_");
        String _literal_10 = brk2_polarity.getLiteral();
        _builder.append(_literal_10);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.append("#define ICS_BREAK2_FILTER             (LL_TIM_BREAK2_FILTER_");
        String _literal_11 = brk2_filter_div.getLiteral();
        _builder.append(_literal_11);
        _builder.append(")\t\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/* Currents Sensing ADC section */");
        _builder.newLine();
        boolean _equals_4 = Objects.equals((Object)adc_curr_ab, (Object)ADC_COUPLE_enum.ADC1_ADC2);
        if (_equals_4) {
            _builder.append("#define ADC_0_PERIPH                    (ADC1)");
            _builder.newLine();
            _builder.append("#define ADC_1_PERIPH                    (ADC2)");
            _builder.newLine();
        } else {
            boolean _equals_5 = Objects.equals((Object)adc_curr_ab, (Object)ADC_COUPLE_enum.ADC3_ADC4);
            if (_equals_5) {
                _builder.append("#define ADC_0_PERIPH                    (ADC3)");
                _builder.newLine();
                _builder.append("#define ADC_1_PERIPH                    (ADC4)");
                _builder.newLine();
            }
        }
        _builder.newLine();
        _builder.append("#define ADC_2_PERIPH                    (");
        String _literal_12 = adc_curr_c.getLiteral();
        _builder.append(_literal_12);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.append("#define PHASE_IA_CURR_CHANNEL           (MC_ADC_");
        String _literal_13 = adc_ch_a.getLiteral();
        _builder.append(_literal_13);
        _builder.append(") ");
        _builder.newLineIfNotEmpty();
        _builder.append("#define PHASE_IB_CURR_CHANNEL           (MC_ADC_");
        String _literal_14 = adc_ch_c.getLiteral();
        _builder.append(_literal_14);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.append("#define PHASE_IC_CURR_CHANNEL           (MC_ADC_");
        String _literal_15 = adc_ch_b.getLiteral();
        _builder.append(_literal_15);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#define ADC_SAMPLING_TIME               (LL_ADC_SAMPLINGTIME_6CYCLES_5) ");
        _builder.newLine();
        _builder.newLine();
        boolean _equals_6 = Objects.equals((Object)adc_curr_ab, (Object)ADC_COUPLE_enum.ADC1_ADC2);
        if (_equals_6) {
            _builder.append("#define ADCx_HF_M1_IRQHandler  IRQ_ADC1_HANDLER");
            _builder.newLine();
            _builder.append("#define IRQ_HF_ADC_VECTOR      IRQ_ADC1_VECTOR");
            _builder.newLine();
        } else {
            _builder.append("#define ADCx_HF_M1_IRQHandler  IRQ_ADC3_HANDLER");
            _builder.newLine();
            _builder.append("#define IRQ_HF_ADC_VECTOR      IRQ_ADC3_VECTOR");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("/****             DAC    ***/");
        _builder.newLine();
        _builder.append("/* DAC Debug Setting */");
        _builder.newLine();
        _builder.newLine();
        if (dac_active) {
            _builder.append("#define DAC_FUNCTIONALITY                TRUE");
            _builder.newLine();
        } else {
            _builder.append("#define DAC_FUNCTIONALITY                FALSE");
            _builder.newLine();
        }
        _builder.newLine();
        if (debug_dac_ch1 == CH1_enum.DEBUG) {
            _builder.append("#define DEBUG_DAC_CH1                    TRUE");
            _builder.newLine();
        } else {
            _builder.append("#define DEBUG_DAC_CH1                    FALSE");
            _builder.newLine();
        }
        if (debug_dac_ch2 == CH2_enum.DEBUG) {
            _builder.append("#define DEBUG_DAC_CH2                    TRUE");
            _builder.newLine();
        } else {
            _builder.append("#define DEBUG_DAC_CH2                    FALSE");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("#define DEFAULT_DAC_CHANNEL_1            MC_PROTOCOL_REG_");
        String _name = variable_ch1.getName();
        _builder.append(_name);
        _builder.newLineIfNotEmpty();
        _builder.append("#define DEFAULT_DAC_CHANNEL_2            MC_PROTOCOL_REG_");
        String _name_1 = variable_ch2.getName();
        _builder.append(_name_1);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _equals_7 = Objects.equals((Object)dac_mode, (Object)DAC_MODETYPE_enum.TIM);
        if (_equals_7) {
            _builder.append("/* DAC as TIM */");
            _builder.newLine();
            _builder.append("#define TIM_DAC");
            _builder.newLine();
            _builder.append("#define DAC_MODULE         ");
            String _literal_16 = dac_tim_module.getLiteral();
            _builder.append(_literal_16);
            _builder.append(" /* (TIMx Module) */");
            _builder.newLineIfNotEmpty();
            _builder.append("#define DAC_RESOURCE_CH1   LL_TIM_");
            String _literal_17 = dac_tim_ch1.getLiteral();
            _builder.append(_literal_17);
            _builder.append(" /* DAC TIM timer channel 1 */");
            _builder.newLineIfNotEmpty();
            _builder.append("#define DAC_RESOURCE_CH2   LL_TIM_");
            String _literal_18 = dac_tim_ch2.getLiteral();
            _builder.append(_literal_18);
            _builder.append(" /* DAC TIM timer channel 2 */");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("/* DAC as BDAC */");
            _builder.newLine();
            _builder.append("#define DAC_MODULE         BDAC1 ");
            _builder.newLine();
            _builder.append("#define DAC_RESOURCE_CH1   LL_DAC_");
            String _literal_19 = bdac_ch1.getLiteral();
            _builder.append(_literal_19);
            _builder.append(" /* BDAC channel  */");
            _builder.newLineIfNotEmpty();
            _builder.append("#define DAC_RESOURCE_CH2   LL_DAC_");
            String _literal_20 = bdac_ch2.getLiteral();
            _builder.append(_literal_20);
            _builder.append(" /* BDAC channel  */");
            _builder.newLineIfNotEmpty();
        }
        if (main_sel == SensorSelection_enum.HALL_SENSORS) {
            _builder.append("/****    HALL    ***/");
            _builder.newLine();
            _builder.append("/* HALL timer section */");
            _builder.newLine();
            _builder.append("#define HALL_TIMER_SELECTION              (");
            String _literal_21 = main_hall_tim_module.getLiteral();
            _builder.append(_literal_21);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("#define HALL_S1_CH               \t\t  (LL_TIM_");
            String _literal_22 = hall_tim_ch_s1.getLiteral();
            _builder.append(_literal_22, "\t\t");
            _builder.append(")  ");
            _builder.newLineIfNotEmpty();
            _builder.append("        ");
            _builder.append("#define HALL_S2_CH                        (LL_TIM_");
            String _literal_23 = hall_tim_ch_s2.getLiteral();
            _builder.append(_literal_23, "        ");
            _builder.append(")  ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("#define HALL_S3_CH                        (LL_TIM_");
            String _literal_24 = hall_tim_ch_s3.getLiteral();
            _builder.append(_literal_24, "\t\t");
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("#define HALL_TIMx_VECTOR                  IRQ_");
            String _literal_25 = main_hall_tim_module.getLiteral();
            _builder.append(_literal_25, "\t\t");
            _builder.append("_VECTOR\t\t");
            _builder.newLineIfNotEmpty();
        } else if (aux_sel == SensorSelection_enum.HALL_SENSORS && en_aux_sel) {
            _builder.append("/****    HALL    ***/");
            _builder.newLine();
            _builder.append(" \t\t");
            _builder.append("/* HALL timer section */");
            _builder.newLine();
            _builder.append("#define HALL_TIMER_SELECTION              (");
            String _literal_26 = aux_hall_tim_module.getLiteral();
            _builder.append(_literal_26);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _builder.append("#define HALL_S1_CH               \t\t  (LL_TIM_");
            String _literal_27 = hall_tim_ch_s1.getLiteral();
            _builder.append(_literal_27);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _builder.append("#define HALL_S2_CH                        (LL_TIM_");
            String _literal_28 = hall_tim_ch_s2.getLiteral();
            _builder.append(_literal_28);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _builder.append("#define HALL_S3_CH                        (LL_TIM_");
            String _literal_29 = hall_tim_ch_s3.getLiteral();
            _builder.append(_literal_29);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _builder.append("#define HALL_TIMx_VECTOR                  IRQ_");
            String _literal_30 = aux_hall_tim_module.getLiteral();
            _builder.append(_literal_30);
            _builder.append("_VECTOR\t\t");
            _builder.newLineIfNotEmpty();
        }
        if (main_sel == SensorSelection_enum.QUADRATURE_ENCODER) {
            _builder.append("/****    ENCODER    ***/");
            _builder.newLine();
            _builder.append(" \t\t");
            _builder.append("/* ENCODER timer section */");
            _builder.newLine();
            _builder.append("#define ENC_TIMER_SELECTION               (");
            String _literal_31 = main_enc_tim_module.getLiteral();
            _builder.append(_literal_31);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _builder.append("#define ENC_CH_A_INPUT                    (LL_TIM_");
            String _literal_32 = enc_tim_cha.getLiteral();
            _builder.append(_literal_32);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _builder.append("#define ENC_CH_B_INPUT                    (LL_TIM_");
            String _literal_33 = enc_tim_chb.getLiteral();
            _builder.append(_literal_33);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _builder.append("#define ENC_TIMx_VECTOR                   IRQ_");
            String _literal_34 = main_enc_tim_module.getLiteral();
            _builder.append(_literal_34);
            _builder.append("_VECTOR");
            _builder.newLineIfNotEmpty();
        } else if (aux_sel == SensorSelection_enum.QUADRATURE_ENCODER && en_aux_sel) {
            _builder.append("/****    ENCODER    ***/");
            _builder.newLine();
            _builder.append(" \t\t");
            _builder.append("/* ENCODER timer section */");
            _builder.newLine();
            _builder.append("#define ENC_TIMER_SELECTION               (");
            String _literal_35 = aux_enc_tim_module.getLiteral();
            _builder.append(_literal_35);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _builder.append("#define ENC_CH_A_INPUT                    (LL_TIM_");
            String _literal_36 = enc_tim_cha.getLiteral();
            _builder.append(_literal_36);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _builder.append("#define ENC_CH_B_INPUT                    (LL_TIM_");
            String _literal_37 = enc_tim_chb.getLiteral();
            _builder.append(_literal_37);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _builder.append("#define ENC_TIMx_VECTOR                   IRQ_");
            String _literal_38 = aux_enc_tim_module.getLiteral();
            _builder.append(_literal_38);
            _builder.append("_VECTOR");
            _builder.newLineIfNotEmpty();
        }
        if (main_sel == SensorSelection_enum.RESOLVER) {
            boolean _equals_14;
            boolean _equals_13;
            boolean _equals_12;
            boolean _equals_11;
            boolean _equals_10;
            boolean _equals_9;
            _builder.append("/****    RESOLVER    ***/");
            _builder.newLine();
            boolean _equals_8 = Objects.equals((Object)res_adc, (Object)ADC_RESOLVER_enum.ADC1_ADC2);
            if (_equals_8) {
                _builder.append("/* DUAL ADC used for Resolver (SIN/COS) */");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_SIN              (ADC1)");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_COS              (ADC2)");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_SIN_COS          (ADC1) /* not used */");
                _builder.newLine();
                _builder.append("#define IRQ_RES_ADC_VECTOR              IRQ_ADC1_VECTOR");
                _builder.newLine();
                _builder.append("#define ADCx_RES_M1_IRQHandler          IRQ_ADC1_HANDLER");
                _builder.newLine();
            }
            if (_equals_9 = Objects.equals((Object)res_adc, (Object)ADC_RESOLVER_enum.ADC3_ADC4)) {
                _builder.append("/* DUAL ADC used for Resolver (SIN/COS)\t*/\t");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_SIN              (ADC3)");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_COS              (ADC4)");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_SIN_COS          (ADC3) /* not used */");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("#define IRQ_RES_ADC_VECTOR              IRQ_ADC3_VECTOR");
                _builder.newLine();
                _builder.append("#define ADCx_RES_M1_IRQHandler          IRQ_ADC3_HANDLER\t\t");
                _builder.newLine();
            }
            if (_equals_10 = Objects.equals((Object)res_adc, (Object)ADC_RESOLVER_enum.ADC1)) {
                _builder.append("/* Single ADC used for Resolver (SIN/COS) */");
                _builder.newLine();
                _builder.append("#define RES_SINGLE_ADC_RESOURCE");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_SIN_COS          (ADC1)");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_SIN              (ADC1) /* not used */");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_COS              (ADC1) /* not used */");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("#define IRQ_RES_ADC_VECTOR              IRQ_ADC1_VECTOR");
                _builder.newLine();
                _builder.append("#define ADCx_RES_M1_IRQHandler          IRQ_ADC1_HANDLER\t\t");
                _builder.newLine();
            }
            if (_equals_11 = Objects.equals((Object)res_adc, (Object)ADC_RESOLVER_enum.ADC2)) {
                _builder.append("/* Single ADC used for Resolver (SIN/COS) */");
                _builder.newLine();
                _builder.append("#define RES_SINGLE_ADC_RESOURCE");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_SIN_COS          (ADC2)");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_SIN              (ADC2) /* not used */");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_COS              (ADC2) /* not used */");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("#define IRQ_RES_ADC_VECTOR              IRQ_ADC2_VECTOR");
                _builder.newLine();
                _builder.append("#define ADCx_RES_M1_IRQHandler          IRQ_ADC2_HANDLER\t\t");
                _builder.newLine();
            }
            if (_equals_12 = Objects.equals((Object)res_adc, (Object)ADC_RESOLVER_enum.ADC3)) {
                _builder.append("/* Single ADC used for Resolver (SIN/COS) */");
                _builder.newLine();
                _builder.append("#define RES_SINGLE_ADC_RESOURCE");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_SIN_COS          (ADC3)");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_SIN              (ADC3) /* not used */");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_COS              (ADC3) /* not used */");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("#define IRQ_RES_ADC_VECTOR              IRQ_ADC3_VECTOR");
                _builder.newLine();
                _builder.append("#define ADCx_RES_M1_IRQHandler          IRQ_ADC3_HANDLER\t\t");
                _builder.newLine();
            }
            if (_equals_13 = Objects.equals((Object)res_adc, (Object)ADC_RESOLVER_enum.ADC4)) {
                _builder.append("/* Single ADC used for Resolver (SIN/COS) */");
                _builder.newLine();
                _builder.append("#define RES_SINGLE_ADC_RESOURCE");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_SIN_COS          (ADC4)");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_SIN              (ADC4) /* not used */");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_COS              (ADC4) /* not used */");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("#define IRQ_RES_ADC_VECTOR              IRQ_ADC4_VECTOR");
                _builder.newLine();
                _builder.append("#define ADCx_RES_M1_IRQHandler          IRQ_ADC4_HANDLER\t\t");
                _builder.newLine();
            }
            if (_equals_14 = Objects.equals((Object)res_adc, (Object)ADC_RESOLVER_enum.ADC5)) {
                _builder.append("/* Single ADC used for Resolver (SIN/COS) */");
                _builder.newLine();
                _builder.append("#define RES_SINGLE_ADC_RESOURCE");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_SIN_COS          (ADC5)");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_SIN              (ADC5) /* not used */");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_COS              (ADC5 /* not used */");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("#define IRQ_RES_ADC_VECTOR              IRQ_ADC5_VECTOR");
                _builder.newLine();
                _builder.append("#define ADCx_RES_M1_IRQHandler          IRQ_ADC5_HANDLER\t\t");
                _builder.newLine();
            }
            _builder.append("#define RES_ADC_CHANNEL_SIN             (LL_ADC_");
            String _literal_39 = adc_sin_ch.getLiteral();
            _builder.append(_literal_39);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _builder.append("#define RES_ADC_CHANNEL_COS             (LL_ADC_");
            String _literal_40 = adc_cos_ch.getLiteral();
            _builder.append(_literal_40);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("#define RES_DAC_MODULE                  (BDAC1)               /* BDACx HW Settings */");
            _builder.newLine();
            _builder.append("#define RES_DAC_CHANNEL                 (LL_DAC_");
            String _literal_41 = res_dac_ch.getLiteral();
            _builder.append(_literal_41);
            _builder.append(")    /* Resolver excitation DAC channel */");
            _builder.newLineIfNotEmpty();
            _builder.append("#define RES_DMA                         (");
            String _literal_42 = res_dma_mod.getLiteral();
            _builder.append(_literal_42);
            _builder.append(")                /* DMA peripheral used to update output register of the DAC (exciting signal) */");
            _builder.newLineIfNotEmpty();
            _builder.append("#define RES_DMA_CHANNEL                 (LL_DMA_");
            String _literal_43 = res_dma_st.getLiteral();
            _builder.append(_literal_43);
            _builder.append(")     /* STREAM_x DMA channel used to update output register of the DAC (exciting signal) */");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            boolean _equals_15 = Objects.equals((Object)res_dma_mod, (Object)RES_DMA_MOD_enum.DMA1);
            if (_equals_15) {
                _builder.append("#define RES_DMA_MUX                     (DMAMUX1)             /* DMA mux used to update output register of the DAC  */");
                _builder.newLine();
                _builder.append("#define RES_DMA_MUX_CH                 (LL_DMAMUX_");
                String _literal_44 = res_dmamux1_ch.getLiteral();
                _builder.append(_literal_44);
                _builder.append(") /* DMA mux channel used to update output register of the DAC  */");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("#define RES_DMA_MUX                     (DMAMUX2)             /* DMA mux used to update output register of the DAC  */");
                _builder.newLine();
                _builder.append("#define RES_DMA_MUX_CH                  (LL_DMAMUX_");
                String _literal_45 = res_dmamux2_ch.getLiteral();
                _builder.append(_literal_45);
                _builder.append(") /* DMA mux channel used to update output register of the DAC  */");
                _builder.newLineIfNotEmpty();
            }
            _builder.newLine();
            _builder.append("#define RES_TIM_MODULE_FOR_DAC          (TIM6)                /* High frequency timer (TIM6 or TIM7) to clock the BDAC update of values */");
            _builder.newLine();
            _builder.append("#define RES_TIM_MODULE_FOR_ADC          (TIM15)               /* Timer used to trigger the ADC conversions (SIN/COS). It is synchronized with TIM6 or TIM 7 */");
            _builder.newLine();
            _builder.append("                                                              ");
            _builder.append("/* The triggering point is set by CCR 1 (TIM15_TRGO) */");
            _builder.newLine();
            _builder.append("#define RES_TIM_CHANNEL_FOR_ADC         (LL_TIM_CHANNEL_CH1)  /* Timer chennel used to trigger the ADC conversions (SIN/COS). It is synchronized with TIM6 or TIM7 */");
            _builder.newLine();
        } else if (aux_sel == SensorSelection_enum.RESOLVER && en_aux_sel) {
            boolean _equals_22;
            boolean _equals_21;
            boolean _equals_20;
            boolean _equals_19;
            boolean _equals_18;
            boolean _equals_17;
            _builder.append("/****    RESOLVER    ***/");
            _builder.newLine();
            boolean _equals_16 = Objects.equals((Object)res_adc, (Object)ADC_RESOLVER_enum.ADC1_ADC2);
            if (_equals_16) {
                _builder.append("/* DUAL ADC used for Resolver (SIN/COS) */");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_SIN              (ADC1)");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_COS              (ADC2)");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_SIN_COS          (ADC1) /* not used */");
                _builder.newLine();
                _builder.append("#define IRQ_RES_ADC_VECTOR              IRQ_ADC1_VECTOR");
                _builder.newLine();
                _builder.append("#define ADCx_RES_M1_IRQHandler          IRQ_ADC1_HANDLER\t\t");
                _builder.newLine();
            }
            if (_equals_17 = Objects.equals((Object)res_adc, (Object)ADC_RESOLVER_enum.ADC3_ADC4)) {
                _builder.append("/* DUAL ADC used for Resolver (SIN/COS) */");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_SIN              (ADC3)");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_COS              (ADC4)");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_SIN_COS          (ADC3) /* not used */");
                _builder.newLine();
                _builder.append("#define IRQ_RES_ADC_VECTOR              IRQ_ADC3_VECTOR");
                _builder.newLine();
                _builder.append("#define ADCx_RES_M1_IRQHandler          IRQ_ADC3_HANDLER\t\t");
                _builder.newLine();
            }
            if (_equals_18 = Objects.equals((Object)res_adc, (Object)ADC_RESOLVER_enum.ADC1)) {
                _builder.append("/* Single ADC used for Resolver (SIN/COS) */");
                _builder.newLine();
                _builder.append("#define RES_SINGLE_ADC_RESOURCE");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_SIN_COS          (ADC1)");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_SIN              (ADC1) /* not used */");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_COS              (ADC1) /* not used */");
                _builder.newLine();
                _builder.append("#define IRQ_RES_ADC_VECTOR              IRQ_ADC1_VECTOR");
                _builder.newLine();
                _builder.append("#define ADCx_RES_M1_IRQHandler          IRQ_ADC1_HANDLER\t\t");
                _builder.newLine();
            }
            if (_equals_19 = Objects.equals((Object)res_adc, (Object)ADC_RESOLVER_enum.ADC2)) {
                _builder.append("/* Single ADC used for Resolver (SIN/COS) */");
                _builder.newLine();
                _builder.append("#define RES_SINGLE_ADC_RESOURCE");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_SIN_COS          (ADC2)");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_SIN              (ADC2) /* not used */");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_COS              (ADC2) /* not used */");
                _builder.newLine();
                _builder.append("#define IRQ_RES_ADC_VECTOR              IRQ_ADC2_VECTOR");
                _builder.newLine();
                _builder.append("#define ADCx_RES_M1_IRQHandler          IRQ_ADC2_HANDLER\t");
                _builder.newLine();
            }
            if (_equals_20 = Objects.equals((Object)res_adc, (Object)ADC_RESOLVER_enum.ADC3)) {
                _builder.append("/* Single ADC used for Resolver (SIN/COS) */");
                _builder.newLine();
                _builder.append("#define RES_SINGLE_ADC_RESOURCE");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_SIN_COS          (ADC3)");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_SIN              (ADC3) /* not used */");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_COS              (ADC3) /* not used */");
                _builder.newLine();
                _builder.append("#define IRQ_RES_ADC_VECTOR              IRQ_ADC3_VECTOR");
                _builder.newLine();
                _builder.append("#define ADCx_RES_M1_IRQHandler          IRQ_ADC3_HANDLER\t\t");
                _builder.newLine();
            }
            if (_equals_21 = Objects.equals((Object)res_adc, (Object)ADC_RESOLVER_enum.ADC4)) {
                _builder.append("/* Single ADC used for Resolver (SIN/COS) */");
                _builder.newLine();
                _builder.append("#define RES_SINGLE_ADC_RESOURCE");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_SIN_COS          (ADC4)");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_SIN              (ADC4) /* not used */");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_COS              (ADC4) /* not used */");
                _builder.newLine();
                _builder.append("#define IRQ_RES_ADC_VECTOR              IRQ_ADC4_VECTOR");
                _builder.newLine();
                _builder.append("#define ADCx_RES_M1_IRQHandler          IRQ_ADC4_HANDLER\t\t");
                _builder.newLine();
            }
            if (_equals_22 = Objects.equals((Object)res_adc, (Object)ADC_RESOLVER_enum.ADC5)) {
                _builder.append("/* Single ADC used for Resolver (SIN/COS) */");
                _builder.newLine();
                _builder.append("#define RES_SINGLE_ADC_RESOURCE");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_SIN_COS          (ADC5)");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_SIN              (ADC5) /* not used */");
                _builder.newLine();
                _builder.append("#define RES_ADC_MODULE_COS              (ADC5 /* not used */");
                _builder.newLine();
                _builder.append("#define IRQ_RES_ADC_VECTOR              IRQ_ADC5_VECTOR");
                _builder.newLine();
                _builder.append("#define ADCx_RES_M1_IRQHandler          IRQ_ADC5_HANDLER\t\t");
                _builder.newLine();
            }
            _builder.append("#define RES_ADC_CHANNEL_SIN             (LL_ADC_");
            String _literal_46 = adc_sin_ch.getLiteral();
            _builder.append(_literal_46);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _builder.append("#define RES_ADC_CHANNEL_COS             (LL_ADC_");
            String _literal_47 = adc_cos_ch.getLiteral();
            _builder.append(_literal_47);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("#define RES_DAC_MODULE                  (BDAC1)               /* BDACx HW Settings */");
            _builder.newLine();
            _builder.append("#define RES_DAC_CHANNEL                 (LL_DAC_");
            String _literal_48 = res_dac_ch.getLiteral();
            _builder.append(_literal_48);
            _builder.append(")    /* Resolver excitation DAC channel */");
            _builder.newLineIfNotEmpty();
            _builder.append("#define RES_DMA                         (");
            String _literal_49 = res_dma_mod.getLiteral();
            _builder.append(_literal_49);
            _builder.append(")                /* DMA peripheral used to update output register of the DAC (exciting signal) */");
            _builder.newLineIfNotEmpty();
            _builder.append("#define RES_DMA_CHANNEL                 (LL_DMA_");
            String _literal_50 = res_dma_st.getLiteral();
            _builder.append(_literal_50);
            _builder.append(")     /* STREAM_x DMA channel used to update output register of the DAC (exciting signal) */");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            boolean _equals_23 = Objects.equals((Object)res_dma_mod, (Object)RES_DMA_MOD_enum.DMA1);
            if (_equals_23) {
                _builder.append("#define RES_DMA_MUX                     (DMAMUX1)             /* DMA mux used to update output register of the DAC  */");
                _builder.newLine();
                _builder.append("#define RES_DMA_MUX_CH                 (LL_DMAMUX_");
                String _literal_51 = res_dmamux1_ch.getLiteral();
                _builder.append(_literal_51);
                _builder.append(") /* DMA mux channel used to update output register of the DAC  */");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("#define RES_DMA_MUX                     (DMAMUX2)             /* DMA mux used to update output register of the DAC  */");
                _builder.newLine();
                _builder.append("#define RES_DMA_MUX_CH                  (LL_DMAMUX_");
                String _literal_52 = res_dmamux2_ch.getLiteral();
                _builder.append(_literal_52);
                _builder.append(") /* DMA mux channel used to update output register of the DAC  */");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("#define RES_TIM_MODULE_FOR_DAC          (TIM6)                /* High frequency timer (TIM6 or TIM7) to clock the BDAC update of values */");
            _builder.newLine();
            _builder.append("#define RES_TIM_MODULE_FOR_ADC          (TIM15)               /* Timer used to trigger the ADC conversions (SIN/COS). It is synchronized with TIM6 or TIM 7 */");
            _builder.newLine();
            _builder.append("                                                              ");
            _builder.append("/* The triggering point is set by CCR 1 (TIM15_TRGO) */");
            _builder.newLine();
            _builder.append("#define RES_TIM_CHANNEL_FOR_ADC         (LL_TIM_CHANNEL_CH1)  /* Timer chennel used to trigger the ADC conversions (SIN/COS). It is synchronized with TIM6 or TIM7 */");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("/* VBUS / TEMP sensing */");
        _builder.newLine();
        _builder.append("/* nr. ADC modules on device */");
        _builder.newLine();
        _builder.append("#define MAX_ADC_MODULE 5U");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/* ADC module configuration to initialize User conversion.                   */");
        _builder.newLine();
        _builder.append("/* These macro initialiaze SAR ADC when the value is TRUE. The ADC module is */ ");
        _builder.newLine();
        _builder.append("/* used for VBUS/Temperature sensing. The initializaion is done in current sensing module (for i.e. ICS)  */");
        _builder.newLine();
        _builder.append("#define INIT_SARADC_UNIT_1 (");
        String _upperCase = Boolean.valueOf(InitADC1).toString().toUpperCase();
        _builder.append(_upperCase);
        _builder.append(") ");
        _builder.newLineIfNotEmpty();
        _builder.append("#define INIT_SARADC_UNIT_2 (");
        String _upperCase_1 = Boolean.valueOf(InitADC2).toString().toUpperCase();
        _builder.append(_upperCase_1);
        _builder.append(") ");
        _builder.newLineIfNotEmpty();
        _builder.append("#define INIT_SARADC_UNIT_3 (");
        String _upperCase_2 = Boolean.valueOf(InitADC3).toString().toUpperCase();
        _builder.append(_upperCase_2);
        _builder.append(") ");
        _builder.newLineIfNotEmpty();
        _builder.append("#define INIT_SARADC_UNIT_4 (");
        String _upperCase_3 = Boolean.valueOf(InitADC4).toString().toUpperCase();
        _builder.append(_upperCase_3);
        _builder.append(") ");
        _builder.newLineIfNotEmpty();
        _builder.append("#define INIT_SARADC_UNIT_5 (");
        String _upperCase_4 = Boolean.valueOf(InitADC5).toString().toUpperCase();
        _builder.append(_upperCase_4);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _equals_24 = Objects.equals((Object)vbus_mode, (Object)VBUS_TEMP_MODETYPE_enum.TIM);
        if (_equals_24) {
            boolean _equals_25 = Objects.equals((Object)Vamp_selection, (Object)Amplificationselection_enum.BY_L9502);
            if (_equals_25) {
                _builder.append("#define VBUS_ADC_REFERENCE_VOLTAGE 5.7");
                _builder.newLine();
            } else {
                _builder.append("#define VBUS_ADC_REFERENCE_VOLTAGE ADC_REFERENCE_VOLTAGE");
                _builder.newLine();
            }
        } else {
            _builder.append("#define VBUS_ADC_REFERENCE_VOLTAGE ADC_REFERENCE_VOLTAGE");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("/** VBus readings **/");
        _builder.newLine();
        boolean _equals_26 = Objects.equals((Object)vbus_mode, (Object)VBUS_TEMP_MODETYPE_enum.TIM);
        if (_equals_26) {
            _builder.append("/* VBUS sensing configured with TIM (Input Capture) (external ADC sensing) */");
            _builder.newLine();
            _builder.append("/* Enable ADC OUT for VBUS configuration */");
            _builder.newLine();
            _builder.append("#define USE_VBUS_EXT_ADC_OUT");
            _builder.newLine();
            _builder.append("#define VBUS_EXT_ADC_TIMER              ");
            String _literal_53 = tim_vbus_mod.getLiteral();
            _builder.append(_literal_53);
            _builder.newLineIfNotEmpty();
            _builder.append("#define VBUS_EXT_ADC_INPUT_CAPTURE_CH   LL_TIM_");
            String _literal_54 = tim_vbus_ch.getLiteral();
            _builder.append(_literal_54);
            _builder.append(" /* TIM timer channel */");
            _builder.newLineIfNotEmpty();
            _builder.append("#define VBUS_EXT_ADC_DEVICE_NB          ");
            _builder.append((Object)tim_vbus_device);
            _builder.append(" /* VBUS device number */");
            _builder.newLineIfNotEmpty();
            _builder.append("#define VBUS_EXT_INPUT_FILTER           LL_TIM_IC_FILTER_");
            String _literal_55 = tim_vbus_filter.getLiteral();
            _builder.append(_literal_55);
            _builder.newLineIfNotEmpty();
            boolean _equals_27 = Objects.equals((Object)tim_vbus_ch, (Object)SENSING_TIM_CHANNELTYPE_enum.CHANNEL_CH1);
            if (_equals_27) {
                _builder.append("#define VBUS_EXT_ADC_MEASURED_CH        LL_TIM_CHANNEL_CH2");
                _builder.newLine();
            } else {
                _builder.append("#define VBUS_EXT_ADC_MEASURED_CH        LL_TIM_CHANNEL_CH1");
                _builder.newLine();
            }
            _builder.append("#define VBUS_EXT_ADC_TIM_IRQHandler     IRQ_");
            String _literal_56 = tim_vbus_mod.getLiteral();
            _builder.append(_literal_56);
            _builder.append("_HANDLER");
            _builder.newLineIfNotEmpty();
            _builder.append("#define VBUS_EXT_ADC_TIM_VECTOR         IRQ_");
            String _literal_57 = tim_vbus_mod.getLiteral();
            _builder.append(_literal_57);
            _builder.append("_VECTOR");
            _builder.newLineIfNotEmpty();
            _builder.append("#define VBUS_EXT_ADC_TIM_PRIO           IRQ_");
            String _literal_58 = tim_vbus_mod.getLiteral();
            _builder.append(_literal_58);
            _builder.append("_PRIO");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("/* VBUS configured to use internal ADC */");
            _builder.newLine();
            _builder.append("#define VBUS_ADC_MODULE                 (");
            String _literal_59 = adc_vbus_mod.getLiteral();
            _builder.append(_literal_59);
            _builder.append(")        /*!< Adc module used for VBus sensing */");
            _builder.newLineIfNotEmpty();
            _builder.append("#define VBUS_ADC_CHANNEL                (MC_ADC_");
            String _literal_60 = adc_vbus_ch.getLiteral();
            _builder.append(_literal_60);
            _builder.append(")  /*!< Adc channel used for VBus sensing */");
            _builder.newLineIfNotEmpty();
            _builder.append("#define VBUS_ADC_SAMPLING_TIME          (M1_VBUS_SAMPLING_TIME)         /* hardwired */");
            _builder.newLine();
        }
        _builder.newLine();
        boolean _equals_28 = Objects.equals((Object)temp_mode, (Object)VBUS_TEMP_MODETYPE_enum.TIM);
        if (_equals_28) {
            boolean _equals_29 = Objects.equals((Object)Vamp_selection, (Object)Amplificationselection_enum.BY_L9502);
            if (_equals_29) {
                _builder.append("#define TEMP_ADC_REFERENCE_VOLTAGE 5.0");
                _builder.newLine();
            } else {
                _builder.append("#define TEMP_ADC_REFERENCE_VOLTAGE ADC_REFERENCE_VOLTAGE");
                _builder.newLine();
            }
        } else {
            _builder.append("#define TEMP_ADC_REFERENCE_VOLTAGE ADC_REFERENCE_VOLTAGE");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.newLine();
        _builder.append("/** Temperature readings **/");
        _builder.newLine();
        boolean _equals_30 = Objects.equals((Object)temp_mode, (Object)VBUS_TEMP_MODETYPE_enum.TIM);
        if (_equals_30) {
            _builder.append("/* Temperature sensing configured with TIM (Input Capture) (external ADC sensing) */");
            _builder.newLine();
            _builder.append("/* Enable ADC OUT for Temperature sensing configuration */");
            _builder.newLine();
            _builder.append("#define USE_TEMP_EXT_ADC_OUT");
            _builder.newLine();
            _builder.append("#define TEMP_EXT_ADC_TIMER              ");
            String _literal_61 = tim_temp_mod.getLiteral();
            _builder.append(_literal_61);
            _builder.newLineIfNotEmpty();
            _builder.append("#define TEMP_EXT_ADC_INPUT_CAPTURE_CH   LL_TIM_");
            String _literal_62 = tim_temp_ch.getLiteral();
            _builder.append(_literal_62);
            _builder.append(" /* TIM timer channel */");
            _builder.newLineIfNotEmpty();
            _builder.append("#define TEMP_EXT_ADC_DEVICE_NB          ");
            _builder.append((Object)tim_temp_device);
            _builder.append(" /* Temperature device number */");
            _builder.newLineIfNotEmpty();
            _builder.append("#define TEMP_EXT_INPUT_FILTER           LL_TIM_IC_FILTER_");
            String _literal_63 = tim_temp_filter.getLiteral();
            _builder.append(_literal_63);
            _builder.append("\t\t");
            _builder.newLineIfNotEmpty();
            boolean _equals_31 = Objects.equals((Object)tim_temp_ch, (Object)SENSING_TIM_CHANNELTYPE_enum.CHANNEL_CH1);
            if (_equals_31) {
                _builder.append("#define TEMP_EXT_ADC_MEASURED_CH        LL_TIM_CHANNEL_CH2");
                _builder.newLine();
            } else {
                _builder.append("#define TEMP_EXT_ADC_MEASURED_CH        LL_TIM_CHANNEL_CH1");
                _builder.newLine();
            }
            _builder.append("#define TEMP_EXT_ADC_TIM_IRQHandler     IRQ_");
            String _literal_64 = tim_temp_mod.getLiteral();
            _builder.append(_literal_64);
            _builder.append("_HANDLER");
            _builder.newLineIfNotEmpty();
            _builder.append("#define TEMP_EXT_ADC_TIM_VECTOR         IRQ_");
            String _literal_65 = tim_temp_mod.getLiteral();
            _builder.append(_literal_65);
            _builder.append("_VECTOR");
            _builder.newLineIfNotEmpty();
            _builder.append("#define TEMP_EXT_ADC_TIM_PRIO           IRQ_");
            String _literal_66 = tim_temp_mod.getLiteral();
            _builder.append(_literal_66);
            _builder.append("_PRIO        ");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("/* Temperature sensing configured to use internal ADC */");
            _builder.newLine();
            _builder.append("#define TEMP_FDBK_ADC_MODULE            (");
            String _literal_67 = adc_temp_mod.getLiteral();
            _builder.append(_literal_67);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _builder.append("#define TEMP_FDBK_ADC_CHANNEL           (MC_ADC_");
            String _literal_68 = adc_temp_ch.getLiteral();
            _builder.append(_literal_68);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _builder.append("#define TEMP_ADC_SAMPLING_TIME          (uint16_t)(ADC_PRECHG_VALUE(SLOW_SARADC_PRECHG_VALUE_CONF)|ADC_INPSAMP_VALUE(SLOW_SARADC_INPSAMP_VALUE_CONF)) /* hardwired */");
            _builder.newLine();
        }
        _builder.newLine();
        if (enableui) {
            boolean _equals_32 = Objects.equals((Object)com_sel, (Object)COMSelection_enum.SERIAL);
            if (_equals_32) {
                _builder.append("/* Serial communication */");
                _builder.newLine();
                _builder.append("#define SERIAL_COMMUNICATION   /* enable SERIAL User Interface */");
                _builder.newLine();
                _builder.append("#define USART_SELECTION                 ");
                String _literal_69 = ser_sel.getLiteral();
                _builder.append(_literal_69);
                _builder.newLineIfNotEmpty();
                _builder.append("#define USART_SPEED                     ");
                String _literal_70 = ser_br.getLiteral();
                _builder.append(_literal_70);
                _builder.newLineIfNotEmpty();
                if (ser_swap) {
                    _builder.append("#define USART_SWAP_TXRX_PIN             LL_USART_TXRX_SWAPPED ");
                    _builder.newLine();
                } else {
                    _builder.append("#define USART_SWAP_TXRX_PIN             LL_USART_TXRX_STANDARD");
                    _builder.newLine();
                }
            } else {
                _builder.append("/* Can communication */");
                _builder.newLine();
                _builder.append("#define CAN_COMMUNICATION   /* enable CAN User Interface */");
                _builder.newLine();
                _builder.append("#define CAN_SELECTION                   FD");
                String _literal_71 = can_ch.getLiteral();
                _builder.append(_literal_71);
                _builder.newLineIfNotEmpty();
                _builder.append("#define CAN_MAX_MSG_LENGTH              ");
                _builder.append((Object)can_max_msg);
                _builder.append("U");
                _builder.newLineIfNotEmpty();
                _builder.append("#define CAN_TX_MSG_ID_START             ");
                _builder.append((Object)can_start);
                _builder.append("U");
                _builder.newLineIfNotEmpty();
                _builder.append("#define CAN_BR_SELECTION                CAN_");
                String _literal_72 = can_br.getLiteral();
                _builder.append(_literal_72);
                _builder.append("_KBPS\t\t");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("#endif /* __MC_CONFIG_H */");
        _builder.newLine();
        _builder.append("/******************* (C) COPYRIGHT 2023 STMicroelectronics *****END OF FILE****/");
        _builder.newLine();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    public String generateParameterConversion(Component comp) {
        TIM_moduletype_enum main_hall_tim_module;
        TIM_moduletype_enum main_enc_tim_module;
        String _xblockexpression = null;
        DriveManagement DriveMan = ((Motorcontrol)comp).getDrive_management();
        SensorSelection_enum main_sel = DriveMan.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getSensor_selection();
        boolean en_aux_sel = DriveMan.getSpeed_sensor_selection().getAuxiliary_sensor().isEnable_auxiliary_sensor();
        SensorSelection_enum aux_sel = DriveMan.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getSensor_selection();
        double main_encoder_ic_filter = DriveMan.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getQuadrature_encoder().getEncoder_ic_filter();
        double aux_encoder_ic_filter = DriveMan.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getQuadrature_encoder().getEncoder_ic_filter();
        double main_hall_ic_filter = DriveMan.getSpeed_sensor_selection().getMain_sensor().getSensor_list1().getHall_sensors().getHall_ic_filter();
        double aux_hall_ic_filter = DriveMan.getSpeed_sensor_selection().getAuxiliary_sensor().getSensor_list().getHall_sensors().getHall_ic_filter();
        boolean fw_enable = DriveMan.getAdditional_features().getAdditional_methods().isFlux_weakening_enable();
        boolean ff_enable = DriveMan.getAdditional_features().getAdditional_methods().isFeed_forward_enable();
        COMSelection_enum com_sel = DriveMan.getUser_interface().getCom_selection();
        SerialChannel_enum serialchannel = DriveMan.getUser_interface().getSerial_details().getSerialchannel();
        boolean positioncontrol1 = false;
        ControlStage Ctrl_stage = ((Motorcontrol)comp).getControl_stage();
        double mcu_supply = Ctrl_stage.getMcu_supply_voltage_and_clock_frequency().getMcu_supply_voltage();
        boolean dac_func_en = Ctrl_stage.getDac_functionality().isDac_enable();
        TIM_moduletype_enum aux_enc_tim_module = main_enc_tim_module = Ctrl_stage.getEncoder().getTim_module();
        TIM_moduletype_enum aux_hall_tim_module = main_hall_tim_module = Ctrl_stage.getHall().getTim_module();
        PowerStage powerStage = ((Motorcontrol)comp).getPower_stage();
        boolean vbus_voltage_reading = powerStage.getBus_voltage_sensing().isBus_voltage_sensing_enable();
        CurrentReadingTopology_enum topology = powerStage.getCurrent_sensing().getCurrent_reading_topology();
        boolean pfc_enable = powerStage.getPfc_power_factor_correction_().isPower_factor_correction_enable();
        Complementedfromhighside_enum hs_complemented = powerStage.getPhase_drivers().getComplemented_from_high_side();
        boolean dualmotor = false;
        boolean positioncontrol2 = false;
        boolean vbus_voltage_reading2 = false;
        boolean main_sel2 = false;
        boolean aux_sel2 = false;
        boolean en_aux_sel2 = false;
        boolean topology2 = false;
        boolean fw_enable2 = false;
        boolean ff_enable2 = false;
        boolean main_encoder_ic_filter2 = false;
        boolean aux_encoder_ic_filter2 = false;
        boolean main_hall_ic_filter2 = false;
        boolean aux_hall_ic_filter2 = false;
        boolean main_enc_tim_module2 = false;
        boolean aux_enc_tim_module2 = false;
        boolean main_hall_tim_module2 = false;
        boolean aux_hall_tim_module2 = false;
        Complementedfromhighside_enum hs_complemented2 = Complementedfromhighside_enum.DISABLE;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/****************************************************************************");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("* Copyright (c) 2023 STMicroelectronics - All Rights Reserved");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("* License terms: STMicroelectronics Proprietary in accordance with licensing");
        _builder.newLine();
        _builder.append("* terms SLA0098 at www.st.com.");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("* THIS SOFTWARE IS DISTRIBUTED \"AS IS,\" AND ALL WARRANTIES ARE DISCLAIMED,");
        _builder.newLine();
        _builder.append("* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.");
        _builder.newLine();
        _builder.append("*");
        _builder.newLine();
        _builder.append("*****************************************************************************/");
        _builder.newLine();
        _builder.append("/*");
        _builder.newLine();
        _builder.append("* @file    parameters_conversion.h");
        _builder.newLine();
        _builder.append("* @author  Motor Control SDK Team, ST Microelectronics");
        _builder.newLine();
        _builder.append("* @brief   This file includes the proper Parameter conversion on the base");
        _builder.newLine();
        _builder.append("*          of stdlib for the first drive");
        _builder.newLine();
        _builder.append("*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/* Define to prevent recursive inclusion -------------------------------------*/");
        _builder.newLine();
        _builder.append("#ifndef __PARAMETERS_CONVERSION_H");
        _builder.newLine();
        _builder.append("#define __PARAMETERS_CONVERSION_H");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include \"mc_math.h\"");
        _builder.newLine();
        _builder.append("#include \"parameters_conversion_SR5E1.h\"");
        _builder.newLine();
        _builder.append("#include \"pmsm_motor_parameters.h\"");
        _builder.newLine();
        _builder.append("#include \"drive_parameters.h\"");
        _builder.newLine();
        _builder.append("#include \"power_stage_parameters.h\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#define ADC_REFERENCE_VOLTAGE  ");
        _builder.append((Object)mcu_supply);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/************************* CONTROL FREQUENCIES & DELAIES **********************/");
        _builder.newLine();
        _builder.append("#define TF_REGULATION_RATE \t(uint32_t) ((uint32_t)(PWM_FREQUENCY)/(REGULATION_EXECUTION_RATE))");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/* TF_REGULATION_RATE_SCALED is TF_REGULATION_RATE divided by PWM_FREQ_SCALING to allow more dynamic */ ");
        _builder.newLine();
        _builder.append("#define TF_REGULATION_RATE_SCALED (uint16_t) ((uint32_t)(PWM_FREQUENCY)/(REGULATION_EXECUTION_RATE*PWM_FREQ_SCALING))");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/* DPP_CONV_FACTOR is introduce to compute the right DPP with TF_REGULATOR_SCALED  */");
        _builder.newLine();
        _builder.append("#define DPP_CONV_FACTOR (65536/PWM_FREQ_SCALING) ");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#define REP_COUNTER \t\t\t(uint16_t) ((REGULATION_EXECUTION_RATE *2u)-1u)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#define SYS_TICK_FREQUENCY          2000");
        _builder.newLine();
        _builder.append("#define UI_TASK_FREQUENCY_HZ        10");
        _builder.newLine();
        _builder.append("#define SERIAL_COM_TIMEOUT_INVERSE  25");
        _builder.newLine();
        _builder.append("#define SERIAL_COM_ATR_TIME_MS      20");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#define MEDIUM_FREQUENCY_TASK_RATE\t(uint16_t)SPEED_LOOP_FREQUENCY_HZ");
        _builder.newLine();
        _builder.append(" ");
        _builder.newLine();
        _builder.append("#define INRUSH_CURRLIMIT_DELAY_COUNTS  (uint16_t)(INRUSH_CURRLIMIT_DELAY_MS * \\");
        _builder.newLine();
        _builder.append("                                  ");
        _builder.append("((uint16_t)SPEED_LOOP_FREQUENCY_HZ)/1000u -1u)");
        _builder.newLine();
        _builder.append(" ");
        _builder.newLine();
        _builder.append("#define MF_TASK_OCCURENCE_TICKS  (SYS_TICK_FREQUENCY/SPEED_LOOP_FREQUENCY_HZ)-1u");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#define UI_TASK_OCCURENCE_TICKS  (SYS_TICK_FREQUENCY/UI_TASK_FREQUENCY_HZ)-1u");
        _builder.newLine();
        _builder.append("#define SERIALCOM_TIMEOUT_OCCURENCE_TICKS (SYS_TICK_FREQUENCY/SERIAL_COM_TIMEOUT_INVERSE)-1u");
        _builder.newLine();
        _builder.append("#define SERIALCOM_ATR_TIME_TICKS (uint16_t)(((SYS_TICK_FREQUENCY * SERIAL_COM_ATR_TIME_MS) / 1000u) - 1u)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("   \t    ");
        _builder.append("#define MAX_APPLICATION_SPEED_UNIT ((MAX_APPLICATION_SPEED_RPM*SPEED_UNIT)/_RPM)");
        _builder.newLine();
        _builder.append("#define MIN_APPLICATION_SPEED_UNIT ((MIN_APPLICATION_SPEED_RPM*SPEED_UNIT)/_RPM)");
        _builder.newLine();
        _builder.append("#if (NOMINAL_BUS_VOLTAGE_V >= 500 )");
        _builder.newLine();
        _builder.append("#define MAX_MEASURABLE_VOLTAGE 1498 /* Max Voltage for High Voltage Traction Inverter */");
        _builder.newLine();
        _builder.append("#else");
        _builder.newLine();
        _builder.append("#define MAX_MEASURABLE_VOLTAGE 500  /* Max Voltage for Low Voltage Inverter */");
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        _builder.append("#if (VBUS_VOLTAGE_ENABLE == TRUE)");
        _builder.newLine();
        _builder.append("/*max phase voltage, 0-peak Volts*/");
        _builder.newLine();
        _builder.append("#define MAX_VOLTAGE (int16_t)((ADC_REFERENCE_VOLTAGE/SQRT_3)/VBUS_PARTITIONING_FACTOR)");
        _builder.newLine();
        _builder.append("#else");
        _builder.newLine();
        _builder.append("#define MAX_VOLTAGE (int16_t)(MAX_MEASURABLE_VOLTAGE/2) /* Virtual sensor conversion factor */");
        _builder.newLine();
        _builder.append("#endif        ");
        _builder.newLine();
        _builder.newLine();
        if (main_sel == SensorSelection_enum.OBSERVER_CORDIC || aux_sel == SensorSelection_enum.OBSERVER_CORDIC || main_sel == SensorSelection_enum.OBSERVER_PLL || aux_sel == SensorSelection_enum.OBSERVER_PLL) {
            _builder.append("\t\t ");
            _builder.append("/************************* COMMON OBSERVER PARAMETERS **************************/");
            _builder.newLine();
            _builder.append("\t\t ");
            _builder.append("#define MAX_BEMF_VOLTAGE  (uint16_t)((MAX_APPLICATION_SPEED_RPM * 1.2 *\\");
            _builder.newLine();
            _builder.append("\t\t                            ");
            _builder.append("MOTOR_VOLTAGE_CONSTANT*SQRT_2)/(1000u*SQRT_3)) ");
            _builder.newLine();
            boolean _equals = Objects.equals((Object)topology, (Object)CurrentReadingTopology_enum.TWO_INSULATED_CURRENT_SENSORS);
            if (_equals) {
                _builder.append("\t\t ");
                _builder.append("#define MAX_CURRENT (ADC_REFERENCE_VOLTAGE/(2*AMPLIFICATION_GAIN))");
                _builder.newLine();
            } else {
                _builder.append("\t\t ");
                _builder.append("#define MAX_CURRENT (ADC_REFERENCE_VOLTAGE/(2*RSHUNT*AMPLIFICATION_GAIN))");
                _builder.newLine();
            }
            _builder.append("\t\t ");
            _builder.append("#define OBS_MINIMUM_SPEED_UNIT    (uint16_t) ((OBS_MINIMUM_SPEED_RPM*SPEED_UNIT)/_RPM)  ");
            _builder.newLine();
            _builder.newLine();
            if (main_sel == SensorSelection_enum.OBSERVER_PLL || aux_sel == SensorSelection_enum.OBSERVER_PLL) {
                _builder.append("\t\t ");
                _builder.append("/************************* PLL PARAMETERS **************************/");
                _builder.newLine();
                _builder.append("\t\t ");
                _builder.append("#define C1 (int32_t)((((int16_t)F1)*RS)/(LS*TF_REGULATION_RATE))");
                _builder.newLine();
                _builder.append("\t\t ");
                _builder.append("#define C2 (int32_t) GAIN1");
                _builder.newLine();
                _builder.append("\t\t ");
                _builder.append("#define C3 (int32_t)((((int16_t)F1)*MAX_BEMF_VOLTAGE)/(LS*MAX_CURRENT*TF_REGULATION_RATE))");
                _builder.newLine();
                _builder.append("\t\t ");
                _builder.append("#define C4 (int32_t) GAIN2");
                _builder.newLine();
                _builder.append("\t\t ");
                _builder.append("#define C5 (int32_t)((((int16_t)F1)*MAX_VOLTAGE)/(LS*MAX_CURRENT*TF_REGULATION_RATE))");
                _builder.newLine();
                _builder.append("  ");
                _builder.newLine();
                _builder.append("\t\t ");
                _builder.append("#define PERCENTAGE_FACTOR    (uint16_t)(VARIANCE_THRESHOLD*128u)      ");
                _builder.newLine();
                _builder.append("\t\t ");
                _builder.append("#define HFI_MINIMUM_SPEED    (uint16_t) (HFI_MINIMUM_SPEED_RPM/6u)");
                _builder.newLine();
            }
            _builder.newLine();
            if (main_sel == SensorSelection_enum.OBSERVER_CORDIC || aux_sel == SensorSelection_enum.OBSERVER_CORDIC) {
                _builder.append("     ");
                _builder.append("/*********************** OBSERVER + CORDIC PARAMETERS *************************/");
                _builder.newLine();
                _builder.append("\t\t ");
                _builder.append("#define CORD_C1 (int32_t)((((int16_t)CORD_F1)*RS)/(LS*TF_REGULATION_RATE))");
                _builder.newLine();
                _builder.append("\t\t ");
                _builder.append("#define CORD_C2 (int32_t) CORD_GAIN1");
                _builder.newLine();
                _builder.append("\t\t ");
                _builder.append("#define CORD_C3 (int32_t)((((int16_t)CORD_F1)*MAX_BEMF_VOLTAGE)/(LS*MAX_CURRENT\\");
                _builder.newLine();
                _builder.append("\t\t ");
                _builder.append("                                                           ");
                _builder.append("*TF_REGULATION_RATE))");
                _builder.newLine();
                _builder.append("\t\t ");
                _builder.append("#define CORD_C4 (int32_t) CORD_GAIN2");
                _builder.newLine();
                _builder.append("\t\t ");
                _builder.append("#define CORD_C5 (int32_t)((((int16_t)CORD_F1)*MAX_VOLTAGE)/(LS*MAX_CURRENT*\\");
                _builder.newLine();
                _builder.append("\t\t ");
                _builder.append("                                                          ");
                _builder.append("TF_REGULATION_RATE))");
                _builder.newLine();
                _builder.append("\t\t ");
                _builder.append("#define CORD_PERCENTAGE_FACTOR    (uint16_t)(CORD_VARIANCE_THRESHOLD*128u)      ");
                _builder.newLine();
            }
        }
        _builder.newLine();
        _builder.newLine();
        _builder.append("/**************************   VOLTAGE CONVERSIONS  Motor 1 *************************/");
        _builder.newLine();
        _builder.append("#define OVERVOLTAGE_THRESHOLD_d   (uint16_t)(OV_VOLTAGE_THRESHOLD_V*65535/\\");
        _builder.newLine();
        _builder.append("                                  ");
        _builder.append("(ADC_REFERENCE_VOLTAGE/VBUS_PARTITIONING_FACTOR))");
        _builder.newLine();
        _builder.append("#define UNDERVOLTAGE_THRESHOLD_d  (uint16_t)((UD_VOLTAGE_THRESHOLD_V*65535)/\\");
        _builder.newLine();
        _builder.append("                                  ");
        _builder.append("((uint16_t)(ADC_REFERENCE_VOLTAGE/\\");
        _builder.newLine();
        _builder.append("                                                           ");
        _builder.append("VBUS_PARTITIONING_FACTOR)))");
        _builder.newLine();
        _builder.append("#define INT_SUPPLY_VOLTAGE          (uint16_t)(65536/ADC_REFERENCE_VOLTAGE)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#define DELTA_TEMP_THRESHOLD        (OV_TEMPERATURE_THRESHOLD_C- T0_C)");
        _builder.newLine();
        _builder.append("#define DELTA_V_THRESHOLD           (dV_dT * DELTA_TEMP_THRESHOLD)");
        _builder.newLine();
        _builder.append("#define OV_TEMPERATURE_THRESHOLD_d  ((V0_V + DELTA_V_THRESHOLD)*INT_SUPPLY_VOLTAGE)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#define DELTA_TEMP_HYSTERESIS        (OV_TEMPERATURE_HYSTERESIS_C)");
        _builder.newLine();
        _builder.append("#define DELTA_V_HYSTERESIS           (dV_dT * DELTA_TEMP_HYSTERESIS)");
        _builder.newLine();
        _builder.append("#define OV_TEMPERATURE_HYSTERESIS_d  (DELTA_V_HYSTERESIS*INT_SUPPLY_VOLTAGE)");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        if (main_sel == SensorSelection_enum.QUADRATURE_ENCODER || aux_sel == SensorSelection_enum.QUADRATURE_ENCODER) {
            _builder.append("/*************** Encoder Alignemnt ************************/");
            _builder.newLine();
            _builder.append("#define ALIGNMENT_ANGLE_S16      (int16_t)  (ALIGNMENT_ANGLE_DEG*65536u/360u)");
            _builder.newLine();
        }
        if (0 == SensorSelection_enum.QUADRATURE_ENCODER.getValue() || 0 == SensorSelection_enum.QUADRATURE_ENCODER.getValue()) {
            _builder.append("#define ALIGNMENT_ANGLE_S162      (int16_t)  (ALIGNMENT_ANGLE_DEG2*65536u/360u)");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("/*************** Timer for PWM generation & currenst sensing parameters  ******/");
        _builder.newLine();
        _builder.append("#define PWM_PERIOD_CYCLES (uint16_t)((ADV_TIM_CLK_MHz*(uint32_t)1000000u/((uint32_t)(PWM_FREQUENCY)))&0xFFFE)");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        if (hs_complemented == Complementedfromhighside_enum.ENABLE) {
            _builder.append("#define DEADTIME_NS  HW_DEAD_TIME_NS");
            _builder.newLine();
        } else {
            _builder.append("#define DEADTIME_NS  SW_DEADTIME_NS");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("#define DEAD_TIME_ADV_TIM_CLK_MHz (ADV_TIM_CLK_MHz * TIM_CLOCK_DIVIDER)");
        _builder.newLine();
        _builder.append("#define DEAD_TIME_COUNTS_1  (DEAD_TIME_ADV_TIM_CLK_MHz * DEADTIME_NS/1000uL)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#if (DEAD_TIME_COUNTS_1 <= 255)");
        _builder.newLine();
        _builder.append("#define DEAD_TIME_COUNTS (uint16_t) DEAD_TIME_COUNTS_1");
        _builder.newLine();
        _builder.append("#elif (DEAD_TIME_COUNTS_1 <= 508)");
        _builder.newLine();
        _builder.append("#define DEAD_TIME_COUNTS (uint16_t)(((DEAD_TIME_ADV_TIM_CLK_MHz * DEADTIME_NS/2) /1000uL) + 128)");
        _builder.newLine();
        _builder.append("#elif (DEAD_TIME_COUNTS_1 <= 1008)");
        _builder.newLine();
        _builder.append("#define DEAD_TIME_COUNTS (uint16_t)(((DEAD_TIME_ADV_TIM_CLK_MHz * DEADTIME_NS/8) /1000uL) + 320)");
        _builder.newLine();
        _builder.append("#elif (DEAD_TIME_COUNTS_1 <= 2015)");
        _builder.newLine();
        _builder.append("#define DEAD_TIME_COUNTS (uint16_t)(((DEAD_TIME_ADV_TIM_CLK_MHz * DEADTIME_NS/16) /1000uL) + 384)");
        _builder.newLine();
        _builder.append("#else");
        _builder.newLine();
        _builder.append("#define DEAD_TIME_COUNTS 510");
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#define DTCOMPCNT (uint16_t)((DEADTIME_NS * ADV_TIM_CLK_MHz) / 2000)");
        _builder.newLine();
        _builder.append("#define TON_NS  500");
        _builder.newLine();
        _builder.append("#define TOFF_NS 500");
        _builder.newLine();
        _builder.append("#define TON  (uint16_t)((TON_NS * ADV_TIM_CLK_MHz)  / 2000)");
        _builder.newLine();
        _builder.append("#define TOFF (uint16_t)((TOFF_NS * ADV_TIM_CLK_MHz) / 2000)");
        _builder.newLine();
        _builder.append("/**********************/");
        _builder.newLine();
        _builder.append("/* MOTOR 1 ADC Timing */");
        _builder.newLine();
        _builder.append("/**********************/");
        _builder.newLine();
        _builder.append("#define SAMPLING_TIME ((ADC_SAMPLING_CYCLES * ADV_TIM_CLK_MHz) / ADC_CLK_MHz) /* In ADV_TIMER CLK cycles*/");
        _builder.newLine();
        if (topology == CurrentReadingTopology_enum.ONE_SHUNT_RESISTOR) {
            _builder.append("#define TRISE ((TRISE_NS * ADV_TIM_CLK_MHz)/1000uL)");
            _builder.newLine();
            _builder.append("#define TDEAD ((uint16_t)((DEADTIME_NS * ADV_TIM_CLK_MHz)/1000uL))");
            _builder.newLine();
            _builder.append("#define TAFTER ((uint16_t)(TDEAD + TRISE))");
            _builder.newLine();
            _builder.append("#define TBEFORE ((uint16_t)((ADC_TRIG_CONV_LATENCY_CYCLES + ADC_SAMPLING_CYCLES) * ADV_TIM_CLK_MHz) / ADC_CLK_MHz  + 1u)");
            _builder.newLine();
            _builder.append("#define TMIN ((uint16_t)( TAFTER + TBEFORE ))");
            _builder.newLine();
            _builder.append("#define HTMIN ((uint16_t)(TMIN >> 1))");
            _builder.newLine();
            _builder.append("#define CHTMIN ((uint16_t)(TMIN/(REGULATION_EXECUTION_RATE*2)))");
            _builder.newLine();
            _builder.append("#if (TRISE > SAMPLING_TIME)");
            _builder.newLine();
            _builder.append("#define MAX_TRTS (2 * TRISE)");
            _builder.newLine();
            _builder.append("#else");
            _builder.newLine();
            _builder.append("#define MAX_TRTS (2 * SAMPLING_TIME)");
            _builder.newLine();
            _builder.append("#endif");
            _builder.newLine();
        } else {
            _builder.append("#define HTMIN 1 /* Required for main.c compilation only, CCR4 is overwritten at runtime */");
            _builder.newLine();
            _builder.append("#define TW_BEFORE ((uint16_t)((ADC_TRIG_CONV_LATENCY_CYCLES + ADC_SAMPLING_CYCLES) * ADV_TIM_CLK_MHz) / ADC_CLK_MHz  + 1u)");
            _builder.newLine();
            _builder.append("#define TW_BEFORE_R3_1 ((uint16_t)((ADC_TRIG_CONV_LATENCY_CYCLES + ADC_SAMPLING_CYCLES*2 + ADC_SAR_CYCLES) * ADV_TIM_CLK_MHz) / ADC_CLK_MHz  + 1u)");
            _builder.newLine();
            _builder.append("#define TW_AFTER ((uint16_t)(((DEADTIME_NS+MAX_TNTR_NS)*ADV_TIM_CLK_MHz)/1000ul))");
            _builder.newLine();
            _builder.append("#define MAX_TWAIT ((uint16_t)((TW_AFTER - SAMPLING_TIME)/2))");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.newLine();
        _builder.append("/* USER CODE BEGIN temperature */");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#define M1_VIRTUAL_HEAT_SINK_TEMPERATURE_VALUE   25u");
        _builder.newLine();
        _builder.append("#define M1_TEMP_SW_FILTER_BW_FACTOR      250u");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/* USER CODE END temperature */");
        _builder.newLine();
        if (fw_enable || ff_enable) {
            _builder.append("/* Flux Weakening - Feed forward */");
            _builder.newLine();
            _builder.append("#define M1_VQD_SW_FILTER_BW_FACTOR       128u");
            _builder.newLine();
            _builder.append("#define M1_VQD_SW_FILTER_BW_FACTOR_LOG LOG2(M1_VQD_SW_FILTER_BW_FACTOR)");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        boolean _equals_2 = Objects.equals((Object)topology, (Object)CurrentReadingTopology_enum.TWO_INSULATED_CURRENT_SENSORS);
        if (_equals_2) {
            _builder.append("#define PQD_CONVERSION_FACTOR (int32_t)(( 1000 * 3 * ADC_REFERENCE_VOLTAGE ) /\\");
            _builder.newLine();
            _builder.append("             ");
            _builder.append("( 1.732 * AMPLIFICATION_GAIN ))");
            _builder.newLine();
        } else {
            _builder.append("#define PQD_CONVERSION_FACTOR (int32_t)(( 1000 * 3 * ADC_REFERENCE_VOLTAGE ) /\\");
            _builder.newLine();
            _builder.append("             ");
            _builder.append("( 1.732 * RSHUNT * AMPLIFICATION_GAIN ))");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.newLine();
        _builder.append("#define USART_IRQHandler IRQ_");
        String _literal = serialchannel.getLiteral();
        _builder.append(_literal);
        _builder.append("_HANDLER");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/****** Prepares the UI configurations according the MCconfxx settings ********/");
        _builder.newLine();
        if (com_sel == COMSelection_enum.SERIAL) {
            _builder.append("#define COM_ENABLE | OPT_COM");
            _builder.newLine();
        } else {
            _builder.append("#define COM_ENABLE");
            _builder.newLine();
        }
        _builder.newLine();
        if (dac_func_en) {
            _builder.append("#define DAC_ENABLE | OPT_DAC");
            _builder.newLine();
            _builder.append("#define DAC_OP_ENABLE | UI_CFGOPT_DAC");
            _builder.newLine();
        } else {
            _builder.append("#define DAC_ENABLE");
            _builder.newLine();
            _builder.append("#define DAC_OP_ENABLE");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("/* Motor 1 settings */");
        _builder.newLine();
        if (fw_enable) {
            _builder.append("#define FW_ENABLE | UI_CFGOPT_FW");
            _builder.newLine();
        } else {
            _builder.append("#define FW_ENABLE");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("#define DIFFTERM_ENABLE");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("/* Sensors setting */");
        _builder.newLine();
        if (main_sel == SensorSelection_enum.OBSERVER_PLL) {
            _builder.append("#define MAIN_SCFG UI_SCODE_STO_PLL");
            _builder.newLine();
        }
        _builder.newLine();
        if (aux_sel == SensorSelection_enum.OBSERVER_PLL && en_aux_sel) {
            _builder.append("#define AUX_SCFG UI_SCODE_STO_PLL");
            _builder.newLine();
        }
        _builder.newLine();
        if (main_sel == SensorSelection_enum.OBSERVER_CORDIC) {
            _builder.append("#define MAIN_SCFG UI_SCODE_STO_CR");
            _builder.newLine();
        }
        _builder.newLine();
        if (aux_sel == SensorSelection_enum.OBSERVER_CORDIC && en_aux_sel) {
            _builder.append("#define AUX_SCFG UI_SCODE_STO_CR");
            _builder.newLine();
        }
        _builder.newLine();
        if (main_sel == SensorSelection_enum.OBSERVER_HFI) {
            _builder.append("#define MAIN_SCFG UI_SCODE_HFINJ");
            _builder.newLine();
        }
        _builder.newLine();
        if (aux_sel == SensorSelection_enum.OBSERVER_HFI && en_aux_sel) {
            _builder.append("#define AUX_SCFG UI_SCODE_HFINJ");
            _builder.newLine();
        }
        _builder.newLine();
        if (main_sel == SensorSelection_enum.QUADRATURE_ENCODER) {
            _builder.append("#define MAIN_SCFG UI_SCODE_ENC");
            _builder.newLine();
        }
        _builder.newLine();
        if (aux_sel == SensorSelection_enum.QUADRATURE_ENCODER && en_aux_sel) {
            _builder.append("#define AUX_SCFG UI_SCODE_ENC");
            _builder.newLine();
        }
        _builder.newLine();
        if (main_sel == SensorSelection_enum.HALL_SENSORS) {
            _builder.append("#define MAIN_SCFG UI_SCODE_HALL");
            _builder.newLine();
        }
        _builder.newLine();
        if (aux_sel == SensorSelection_enum.HALL_SENSORS && en_aux_sel) {
            _builder.append("#define AUX_SCFG UI_SCODE_HALL");
            _builder.newLine();
        }
        _builder.newLine();
        if (main_sel == SensorSelection_enum.RESOLVER) {
            _builder.append("#define MAIN_SCFG UI_SCODE_RES");
            _builder.newLine();
        }
        _builder.newLine();
        if (aux_sel == SensorSelection_enum.RESOLVER && en_aux_sel) {
            _builder.append("#define AUX_SCFG UI_SCODE_RES");
            _builder.newLine();
        }
        _builder.newLine();
        if (aux_sel == SensorSelection_enum.EXTERNAL_SENSOR && en_aux_sel) {
            _builder.append("#define AUX_SCFG 0x0");
            _builder.newLine();
        }
        _builder.append("        ");
        _builder.newLine();
        if (!en_aux_sel) {
            _builder.append("#define AUX_SCFG UI_SCODE_NONE");
            _builder.newLine();
        }
        _builder.append("        ");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#define PLLTUNING_ENABLE");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        if (pfc_enable) {
            _builder.append("#define UI_CFGOPT_PFC_ENABLE | UI_CFGOPT_PFC");
            _builder.newLine();
        } else {
            _builder.append("#define UI_CFGOPT_PFC_ENABLE");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("/******************************************************************************* ");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("* UI configurations settings. It can be manually overwritten if special ");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("* configuartion is required. ");
        _builder.newLine();
        _builder.append("*******************************************************************************/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/* Specific options of UI */");
        _builder.newLine();
        _builder.append("#define UI_CONFIG_M1 ( UI_CFGOPT_NONE DAC_OP_ENABLE FW_ENABLE DIFFTERM_ENABLE \\");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("| (MAIN_SCFG << MAIN_SCFG_POS) | (AUX_SCFG << AUX_SCFG_POS) | UI_CFGOPT_SETIDINSPDMODE PLLTUNING_ENABLE UI_CFGOPT_PFC_ENABLE | UI_CFGOPT_PLLTUNING)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#define UI_CONFIG_M2");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#define DIN_ACTIVE_LOW Bit_RESET");
        _builder.newLine();
        _builder.append("#define DIN_ACTIVE_HIGH Bit_SET");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#define DOUT_ACTIVE_HIGH   DOutputActiveHigh");
        _builder.newLine();
        _builder.append("#define DOUT_ACTIVE_LOW    DOutputActiveLow");
        _builder.newLine();
        _builder.newLine();
        if (main_sel == SensorSelection_enum.HALL_SENSORS) {
            _builder.append("/**********  AUXILIARY HALL TIMER MOTOR 1 *************/");
            _builder.newLine();
            _builder.append("#define M1_HALL_TIM_PERIOD 65535");
            _builder.newLine();
            _builder.append("#define M1_HALL_IC_FILTER  ");
            _builder.append((Object)main_hall_ic_filter);
            _builder.newLineIfNotEmpty();
            _builder.append("#define SPD_HALL_IRQHandler IRQ_");
            String _literal_1 = main_hall_tim_module.getLiteral();
            _builder.append(_literal_1);
            _builder.append("_HANDLER");
            _builder.newLineIfNotEmpty();
        } else if (aux_sel == SensorSelection_enum.HALL_SENSORS && en_aux_sel) {
            _builder.append("/**********  AUXILIARY HALL TIMER MOTOR 1 *************/");
            _builder.newLine();
            _builder.append("#define M1_HALL_TIM_PERIOD 65535");
            _builder.newLine();
            _builder.append("#define M1_HALL_IC_FILTER  ");
            _builder.append((Object)aux_hall_ic_filter);
            _builder.newLineIfNotEmpty();
            _builder.append("#define SPD_HALL_IRQHandler IRQ_");
            String _literal_2 = aux_hall_tim_module.getLiteral();
            _builder.append(_literal_2);
            _builder.append("_HANDLER");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        if (main_sel == SensorSelection_enum.QUADRATURE_ENCODER) {
            _builder.append("#define M1_PULSE_NBR ( (4 * (M1_ENCODER_PPR)) - 1 )");
            _builder.newLine();
            _builder.append("#define M1_ENC_IC_FILTER  ");
            _builder.append((Object)main_encoder_ic_filter);
            _builder.append("  ");
            _builder.newLineIfNotEmpty();
            _builder.append("#define SPD_ENCODER_IRQHandler IRQ_");
            String _literal_3 = main_enc_tim_module.getLiteral();
            _builder.append(_literal_3);
            _builder.append("_HANDLER  ");
            _builder.newLineIfNotEmpty();
        } else if (aux_sel == SensorSelection_enum.QUADRATURE_ENCODER && en_aux_sel) {
            _builder.append("#define M1_PULSE_NBR ( (4 * (M1_ENCODER_PPR)) - 1 )");
            _builder.newLine();
            _builder.append("#define M1_ENC_IC_FILTER  ");
            _builder.append((Object)aux_encoder_ic_filter);
            _builder.append("   ");
            _builder.newLineIfNotEmpty();
            _builder.append("#define SPD_ENCODER_IRQHandler IRQ_");
            String _literal_4 = aux_enc_tim_module.getLiteral();
            _builder.append(_literal_4);
            _builder.append("_HANDLER  ");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.newLine();
        if (pfc_enable) {
            _builder.append("#define PFC_ETRFILTER_IC   //${ Fx_ic_filter(MC.ETRFILTER?number) } /*TO DEFINE THE FUNCTION IN XTEND*/");
            _builder.newLine();
            _builder.append("#define PFC_SYNCFILTER_IC //${ Fx_ic_filter(MC.SYNCFILTER?number) } /*TO DEFINE THE FUNCTION IN XTEND*/");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("/* MMI Table Motor 1 MAX_MODULATION_100_PER_CENT */");
        _builder.newLine();
        _builder.append("#define START_INDEX 63");
        _builder.newLine();
        _builder.append("#define MAX_MODULE 32767");
        _builder.newLine();
        _builder.append("#define MMITABLE  {\\");
        _builder.newLine();
        _builder.append("32767,32390,32146,31907,31673,31444,31220,31001,30787,30577,30371,\\");
        _builder.newLine();
        _builder.append("30169,29971,29777,29587,29400,29217,29037,28861,28687,28517,\\");
        _builder.newLine();
        _builder.append("28350,28185,28024,27865,27709,27555,27404,27256,27110,26966,\\");
        _builder.newLine();
        _builder.append("26824,26685,26548,26413,26280,26149,26019,25892,25767,25643,\\");
        _builder.newLine();
        _builder.append("25521,25401,25283,25166,25051,24937,24825,24715,24606,24498,\\");
        _builder.newLine();
        _builder.append("24392,24287,24183,24081,23980,23880,23782,23684,23588,23493,\\");
        _builder.newLine();
        _builder.append("23400,23307,23215,23125\\");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("#define SAMPLING_CYCLE_CORRECTION 0.5 /* Add half cycle required by StellarE ADC */");
        _builder.newLine();
        _builder.append("#define LL_ADC_SAMPLINGTIME_1CYCLES_5 LL_ADC_SAMPLINGTIME_1CYCLE_5");
        _builder.newLine();
        _builder.append("#define LL_ADC_SAMPLING_CYCLE(CYCLE) LL_ADC_SAMPLINGTIME_ ## CYCLE ## CYCLES_5");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#endif /*__PARAMETERS_CONVERSION_H*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append("/******************* (C) COPYRIGHT 2019 STMicroelectronics *****END OF FILE****/");
        _builder.newLine();
        _builder.newLine();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    public String generateParameterSR5E1(Component comp) {
        double sysclk;
        String _xblockexpression = null;
        ControlStage ControlStage2 = ((Motorcontrol)comp).getControl_stage();
        double mcu_frq = ControlStage2.getMcu_supply_voltage_and_clock_frequency().getCpu_clock_frequency();
        PWM_moduletype_enum pwm_sel = ControlStage2.getPwm_functionality().getPWM_Module();
        double adv_tim_freq = sysclk = mcu_frq;
        double apb1_tim_freq = sysclk / 2.0;
        double apb2_tim_freq = sysclk;
        TIM_moduletype_enum hall_tim_sel = ControlStage2.getHall().getTim_module();
        double hall_tim_freq = 0.0;
        hall_tim_freq = Objects.equals((Object)hall_tim_sel, (Object)TIM_moduletype_enum.TIM2) || Objects.equals((Object)hall_tim_sel, (Object)TIM_moduletype_enum.TIM3) ? apb1_tim_freq : apb2_tim_freq;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/****************************************************************************");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Copyright (c) 2023 STMicroelectronics - All Rights Reserved");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* License terms: STMicroelectronics Proprietary in accordance with licensing");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* terms SLA0098 at www.st.com.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* THIS SOFTWARE IS DISTRIBUTED \"AS IS,\" AND ALL WARRANTIES ARE DISCLAIMED,");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*****************************************************************************/");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*   @file    parameters_conversion_SR5E1.h");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*   @version 1.1.0");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*   @brief   This file contains the SR5E1 parameters needed for the Stellar");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*            Motor Control.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("/* Define to prevent recursive inclusion -------------------------------------*/");
        _builder.newLine();
        _builder.append("#ifndef __PARAMETERS_CONVERSION_SR5E1_H");
        _builder.newLine();
        _builder.append("#define __PARAMETERS_CONVERSION_SR5E1_H");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include \"pmsm_motor_parameters.h\"");
        _builder.newLine();
        _builder.append("#include \"drive_parameters.h\"");
        _builder.newLine();
        _builder.append("#include \"power_stage_parameters.h\"");
        _builder.newLine();
        _builder.append("#include \"mc_math.h\"");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("#define SYSCLK_FREQ       ");
        int _intValue = Double.valueOf(mcu_frq).intValue();
        _builder.append((Object)_intValue);
        _builder.append("000000uL ");
        _builder.newLineIfNotEmpty();
        _builder.append("#define TIM_CLOCK_DIVIDER  1");
        _builder.newLine();
        _builder.append("#define ADV_TIM_CLK_MHz   ");
        int _intValue_1 = Double.valueOf(adv_tim_freq).intValue();
        _builder.append((Object)_intValue_1);
        _builder.newLineIfNotEmpty();
        _builder.append("#define ADC_CLK_MHz     42");
        _builder.newLine();
        _builder.append("#define HALL_TIM_CLK    ");
        int _intValue_2 = Double.valueOf(hall_tim_freq).intValue();
        _builder.append((Object)_intValue_2);
        _builder.append("000000uL");
        _builder.newLineIfNotEmpty();
        _builder.append("#define APB1TIM_FREQ    ");
        int _intValue_3 = Double.valueOf(apb1_tim_freq).intValue();
        _builder.append((Object)_intValue_3);
        _builder.append("000000uL");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("/*************************  IRQ Handler Mapping  *********************/");
        _builder.newLine();
        _builder.append("#define TIMx_UP_M1_IRQHandler IRQ_");
        String _literal = pwm_sel.getLiteral();
        _builder.append(_literal);
        _builder.append("_UP_HANDLER");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#define TIMx_BRK_M1_IRQHandler IRQ_");
        String _literal_1 = pwm_sel.getLiteral();
        _builder.append(_literal_1);
        _builder.append("_BRK_HANDLER");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.newLine();
        _builder.append("#define IRQ_TIMx_BRK_VECTOR    IRQ_");
        String _literal_2 = pwm_sel.getLiteral();
        _builder.append(_literal_2);
        _builder.append("_BRK_VECTOR");
        _builder.newLineIfNotEmpty();
        _builder.append("                               ");
        _builder.newLine();
        _builder.append("#define IRQ_TIMx_UP_VECTOR     IRQ_");
        String _literal_3 = pwm_sel.getLiteral();
        _builder.append(_literal_3);
        _builder.append("_UP_VECTOR\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("#define ADC_TRIG_CONV_LATENCY_CYCLES 3.5");
        _builder.newLine();
        _builder.append("#define ADC_SAR_CYCLES 12.5");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#define M1_VBUS_SW_FILTER_BW_FACTOR     6u");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#if defined(STATE_OBSERVER_CORDIC) || defined(AUX_STATE_OBSERVER_CORDIC)");
        _builder.newLine();
        _builder.append("#error \"Observer Cordic sensor not available in this version\"");
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#if defined(HFINJECTION) || defined(AUX_HFINJECTION)");
        _builder.newLine();
        _builder.append("#error \"HFINJECTION sensor not available in this version\"");
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#if defined(EXTERNAL_SENSOR) || defined(AUX_EXTERNAL_SENSOR)");
        _builder.newLine();
        _builder.append("#error \"External sensor not available in this version\"");
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#if defined(STATE_OBSERVER_PLL) && defined(AUX_STATE_OBSERVER_PLL)");
        _builder.newLine();
        _builder.append("#error \"Observer PLL defined as main and auxliary sensor\"");
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#if defined(STATE_OBSERVER_CORDIC) && defined(AUX_STATE_OBSERVER_CORDIC)");
        _builder.newLine();
        _builder.append("#error \"Observer Cordic defined as main and auxliary sensor\"");
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#if defined(HFINJECTION) && defined(AUX_HFINJECTION)");
        _builder.newLine();
        _builder.append("#error \"HFINJECTION sensor defined as main and auxliary sensor\"");
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#if defined(ENCODER) && defined(AUX_ENCODER)");
        _builder.newLine();
        _builder.append("#error \"ENCODER sensor defined as main and auxliary sensor\"");
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#if defined(HALL_SENSORS) && defined(AUX_HALL_SENSORS)");
        _builder.newLine();
        _builder.append("#error \"Hall sensor defined as main and auxliary sensor\"");
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#if defined(RESOLVER) && defined(AUX_RESOLVER)");
        _builder.newLine();
        _builder.append("#error \"Resolver defined as main and auxliary sensor\"");
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#if defined(EXTERNAL_SENSOR) && defined(AUX_EXTERNAL_SENSOR)");
        _builder.newLine();
        _builder.append("#error \"External sensor defined as main and auxliary sensor\"");
        _builder.newLine();
        _builder.append("#endif");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#endif /*__PARAMETERS_CONVERSION_SR5E1_H*/");
        _builder.newLine();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }
}

