/*
 * Decompiled with CFR 0.152.
 */
package com.st.stellar.component.motorcontrol.impl;

import com.st.stellar.component.model.DerivedAttributeService;
import com.st.stellar.component.motorcontrol.Flux;
import com.st.stellar.component.motorcontrol.MMotorcontrolPackage;
import com.st.stellar.component.motorcontrol.Magneticstructure_enum;
import com.st.stellar.component.motorcontrol.Motorcontrol;
import com.st.stellar.component.motorcontrol.Torqueandfluxregulators;
import com.st.stellar.component.motorcontrol.impl.MFluxImpl;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

public class FluxImpl
extends MFluxImpl
implements Flux {
    private boolean initialized = false;
    private final InternalFlux flux = new InternalFlux();
    private final InternalTorque torque = new InternalTorque();

    public void dependsOn(EAttribute attr, EObject source, List<EAttribute> featureIDs) {
        DerivedAttributeService.INSTANCE.addDependencyListener(source, attr, featureIDs);
    }

    public void addDependencies() {
        EAttribute _torqueandfluxregulators_Manual_editing_enabled = MMotorcontrolPackage.eINSTANCE.getTorqueandfluxregulators_Manual_editing_enabled();
        EAttribute _torqueandfluxregulators_Cut_off_frequency = MMotorcontrolPackage.eINSTANCE.getTorqueandfluxregulators_Cut_off_frequency();
        EAttribute _torqueandfluxregulators_Execution_rate = MMotorcontrolPackage.eINSTANCE.getTorqueandfluxregulators_Execution_rate();
        EAttribute _electricalparameters_Lq = MMotorcontrolPackage.eINSTANCE.getElectricalparameters_Lq();
        EAttribute _electricalparameters_Ld = MMotorcontrolPackage.eINSTANCE.getElectricalparameters_Ld();
        this.dependsOn(MMotorcontrolPackage.eINSTANCE.getFlux_Kp(), this, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EAttribute[]{_torqueandfluxregulators_Manual_editing_enabled, _torqueandfluxregulators_Cut_off_frequency, _torqueandfluxregulators_Execution_rate, _electricalparameters_Lq, _electricalparameters_Ld})));
        EAttribute _torqueandfluxregulators_Manual_editing_enabled_1 = MMotorcontrolPackage.eINSTANCE.getTorqueandfluxregulators_Manual_editing_enabled();
        EAttribute _torqueandfluxregulators_Cut_off_frequency_1 = MMotorcontrolPackage.eINSTANCE.getTorqueandfluxregulators_Cut_off_frequency();
        EAttribute _torqueandfluxregulators_Execution_rate_1 = MMotorcontrolPackage.eINSTANCE.getTorqueandfluxregulators_Execution_rate();
        EAttribute _electricalparameters_Lq_1 = MMotorcontrolPackage.eINSTANCE.getElectricalparameters_Lq();
        EAttribute _electricalparameters_Ld_1 = MMotorcontrolPackage.eINSTANCE.getElectricalparameters_Ld();
        this.dependsOn(MMotorcontrolPackage.eINSTANCE.getFlux_Ki(), this, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EAttribute[]{_torqueandfluxregulators_Manual_editing_enabled_1, _torqueandfluxregulators_Cut_off_frequency_1, _torqueandfluxregulators_Execution_rate_1, _electricalparameters_Lq_1, _electricalparameters_Ld_1})));
        EAttribute _torqueandfluxregulators_Manual_editing_enabled_2 = MMotorcontrolPackage.eINSTANCE.getTorqueandfluxregulators_Manual_editing_enabled();
        EAttribute _torqueandfluxregulators_Cut_off_frequency_2 = MMotorcontrolPackage.eINSTANCE.getTorqueandfluxregulators_Cut_off_frequency();
        EAttribute _torqueandfluxregulators_Execution_rate_2 = MMotorcontrolPackage.eINSTANCE.getTorqueandfluxregulators_Execution_rate();
        EAttribute _electricalparameters_Lq_2 = MMotorcontrolPackage.eINSTANCE.getElectricalparameters_Lq();
        EAttribute _electricalparameters_Ld_2 = MMotorcontrolPackage.eINSTANCE.getElectricalparameters_Ld();
        this.dependsOn(MMotorcontrolPackage.eINSTANCE.getFlux_Ki_div(), this, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EAttribute[]{_torqueandfluxregulators_Manual_editing_enabled_2, _torqueandfluxregulators_Cut_off_frequency_2, _torqueandfluxregulators_Execution_rate_2, _electricalparameters_Lq_2, _electricalparameters_Ld_2})));
        EAttribute _torqueandfluxregulators_Manual_editing_enabled_3 = MMotorcontrolPackage.eINSTANCE.getTorqueandfluxregulators_Manual_editing_enabled();
        EAttribute _torqueandfluxregulators_Cut_off_frequency_3 = MMotorcontrolPackage.eINSTANCE.getTorqueandfluxregulators_Cut_off_frequency();
        EAttribute _torqueandfluxregulators_Execution_rate_3 = MMotorcontrolPackage.eINSTANCE.getTorqueandfluxregulators_Execution_rate();
        EAttribute _electricalparameters_Lq_3 = MMotorcontrolPackage.eINSTANCE.getElectricalparameters_Lq();
        EAttribute _electricalparameters_Ld_3 = MMotorcontrolPackage.eINSTANCE.getElectricalparameters_Ld();
        this.dependsOn(MMotorcontrolPackage.eINSTANCE.getFlux_Kp_div(), this, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EAttribute[]{_torqueandfluxregulators_Manual_editing_enabled_3, _torqueandfluxregulators_Cut_off_frequency_3, _torqueandfluxregulators_Execution_rate_3, _electricalparameters_Lq_3, _electricalparameters_Ld_3})));
    }

    public FluxImpl() {
        EList _eAdapters = this.eAdapters();
        _eAdapters.add((Object)new AdapterImpl(){

            public void notifyChanged(Notification arg0) {
                if (!FluxImpl.this.initialized) {
                    FluxImpl.this.initialized = true;
                    FluxImpl.this.addDependencies();
                }
            }
        });
    }

    @Override
    public int getKi() {
        EObject _rootContainer = EcoreUtil2.getRootContainer((EObject)this);
        Motorcontrol root = (Motorcontrol)_rootContainer;
        Torqueandfluxregulators parent = root.getDrive_management().getDrive_settings().getTorque_and_flux_regulators();
        boolean _isManual_editing_enabled = parent.isManual_editing_enabled();
        if (_isManual_editing_enabled) {
            return super.getKi();
        }
        this.calcKpKi(root);
        this.ki = (int)this.flux.ki;
        return this.ki;
    }

    @Override
    public int getKi_div() {
        EObject _rootContainer = EcoreUtil2.getRootContainer((EObject)this);
        Motorcontrol root = (Motorcontrol)_rootContainer;
        Torqueandfluxregulators parent = root.getDrive_management().getDrive_settings().getTorque_and_flux_regulators();
        boolean _isManual_editing_enabled = parent.isManual_editing_enabled();
        if (_isManual_editing_enabled) {
            return super.getKi_div();
        }
        this.calcKpKi(root);
        this.ki_div = this.flux.ki_div;
        return this.ki_div;
    }

    @Override
    public int getKp() {
        EObject _rootContainer = EcoreUtil2.getRootContainer((EObject)this);
        Motorcontrol root = (Motorcontrol)_rootContainer;
        Torqueandfluxregulators parent = root.getDrive_management().getDrive_settings().getTorque_and_flux_regulators();
        boolean _isManual_editing_enabled = parent.isManual_editing_enabled();
        if (_isManual_editing_enabled) {
            return super.getKp();
        }
        this.calcKpKi(root);
        this.kp = (int)this.flux.kp;
        return this.kp;
    }

    @Override
    public int getKp_div() {
        EObject _rootContainer = EcoreUtil2.getRootContainer((EObject)this);
        Motorcontrol root = (Motorcontrol)_rootContainer;
        Torqueandfluxregulators parent = root.getDrive_management().getDrive_settings().getTorque_and_flux_regulators();
        boolean _isManual_editing_enabled = parent.isManual_editing_enabled();
        if (_isManual_editing_enabled) {
            return super.getKp_div();
        }
        this.calcKpKi(root);
        this.kp_div = this.flux.kp_div;
        return this.kp_div;
    }

    public void calcKpKi(Motorcontrol motorControl) {
        double vbus = motorControl.getPower_stage().getBus_voltage_sensing().getNominal_voltage();
        double gain = motorControl.getPower_stage().getCurrent_sensing().getOverall_amplification_gain();
        double mcu_voltage = motorControl.getControl_stage().getMcu_supply_voltage_and_clock_frequency().getMcu_supply_voltage();
        double cut_off = motorControl.getDrive_management().getDrive_settings().getTorque_and_flux_regulators().getCut_off_frequency();
        double AB = vbus * gain / mcu_voltage;
        Magneticstructure_enum structure = motorControl.getMotor_settings().getMagnetic_structure();
        double ls = motorControl.getMotor_settings().getElectrical_parameters().getLs();
        double lq = motorControl.getMotor_settings().getElectrical_parameters().getLq();
        double Leq = 0.0;
        boolean _equals = Objects.equals((Object)structure, (Object)Magneticstructure_enum.SURFACE_MOUNTED_PMSM);
        Leq = _equals ? ls : lq;
        double tfkp = (Leq /= 1000.0) * cut_off / AB;
        int i = 0;
        boolean stop = false;
        for (i = 0; i < 15 && !stop; ++i) {
            this.flux.kp_div = this.torque.kp_div = 1 << i;
            this.torque.kp = (double)this.torque.kp_div * tfkp;
            if (!(this.torque.kp <= 4000.0) || !(this.torque.kp >= 2000.0)) continue;
            stop = true;
        }
        double ld = motorControl.getMotor_settings().getElectrical_parameters().getLd();
        double fkp = (ld /= 1000.0) * cut_off / AB;
        boolean _equals_1 = Objects.equals((Object)structure, (Object)Magneticstructure_enum.INTERNAL_PMSM);
        if (_equals_1) {
            stop = false;
            for (i = 0; i < 15 && !stop; ++i) {
                this.flux.kp_div = 1 << i;
                this.flux.kp = (double)this.flux.kp_div * fkp;
                if (!(this.flux.kp <= 4000.0) || !(this.flux.kp >= 2000.0)) continue;
                stop = true;
            }
        } else {
            this.flux.kp = this.torque.kp;
        }
        double rs = motorControl.getMotor_settings().getElectrical_parameters().getRs();
        double pwm_freq = motorControl.getDrive_management().getDrive_settings().getPwm_generation_and_current_reading().getPwm_frequency();
        int rate = motorControl.getDrive_management().getDrive_settings().getTorque_and_flux_regulators().getExecution_rate().getValue();
        double foc_rate = pwm_freq / (double)rate;
        double fki = rs * cut_off / AB / foc_rate;
        stop = false;
        for (i = 0; i < 15 && !stop; ++i) {
            this.flux.ki_div = 1 << i;
            this.flux.ki = (double)this.flux.ki_div * fki;
            if (!(this.flux.ki <= 4000.0) || !(this.flux.ki >= 2000.0)) continue;
            stop = true;
        }
    }

    public static class InternalFlux {
        private double kp;
        private double ki;
        private int kp_div;
        private int ki_div;
    }

    public static class InternalTorque {
        private double kp;
        private int kp_div;
    }
}

