/****************************************************************************
*
* Copyright (c) 2023 STMicroelectronics - All Rights Reserved
*
* License terms: STMicroelectronics Proprietary in accordance with licensing
* terms SLA0098 at www.st.com.
*
* THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*****************************************************************************/      
/*
*   @file    L9502_cfg.h
*   @version M4_VERSION
*   @brief   L9502 configuration macros
*          
*   @details L9502 configuration macros.
*
*/

#ifndef __L9502_CFG_H__
#define __L9502_CFG_H__

#ifdef __cplusplus
extern "C"{
#endif

/*==================================================================================================
*                                        INCLUDE FILES
* 1) system and project includes
* 2) needed interfaces from external units
* 3) internal and external interfaces from this unit
==================================================================================================*/

/*==================================================================================================
*                                          CONSTANTS
==================================================================================================*/

/**** THIS IS THE ACTIVE CONFIGURATION ****/
#define VERSION_CD

/* #define L9502_SOFT_START_SW */   /* Disable Soft Start Up for Cut BA/CA/CD */

/* Test Mode is not available on this FW */
#define TEST_MODE       0 /* if enabled, L9502 is switched into test mode and SPI frames are used */ 

/*==================================================================================================
*                                      DEFINES AND MACROS
==================================================================================================*/


/* Number of Devices connected in Daisy Chain */
#define L9502_DEVICE_NUM            6

/* Chip ID value on Low Voltage Side */
#define CHIP_ID_LV_VALUE            (0x20U)

/* Low Voltage Side Configuration Registers */ 
#define   L9502_VALUE_CFG_8         (0x202U) /* 0b0010 0000 0010 */

#define   L9502_VALUE_CFG_9         (0x000U) /* 0b0000 0000 0000 */

/* High Voltage Side Configuration Registers*/
#define   L9502_VALUE_CFG_0         (0x168U)  /* 0b0001 0110 1000 */

#define   L9502_VALUE_CFG_1         (0x000U)  /* 0b0000 0000 0000 */

#define   L9502_VALUE_CFG_2         (0x0FFU)  /* 0b0000 1111 1111 */

#define   L9502_VALUE_CFG_3         (0x38AU)  /* 0b0011 1000 1010 */

#define   L9502_VALUE_CFG_4         (0x040U)  /* 0b0000 0100 0000 */

#define   L9502_VALUE_CFG_5         (0x000U)  /* 0b0000 0000 0000 */

#define   L9502_VALUE_CFG_6         (0x000U)  /* 0b0000 0000 0000 */

#define   L9502_VALUE_CFG_7         (0x000U)  /* 0b0000 0000 0000 */

/* Paging Registers: Most significant Nibble represent page number [1/2/3] */

#define   L9502_VALUE_CFG_10_P1     (0x180U)   /* Re Engagement procedure: DIS_PULSE_ONLY */

#define   L9502_VALUE_CFG_10_P2     (0x200U)

#define   L9502_VALUE_CFG_10_P3     (0x3F2U)

#define   L9502_VALUE_CFG_11_P1     (0x107U)

#define   L9502_VALUE_CFG_11_P2     (0x208U)

#define   L9502_VALUE_CFG_11_P3     (0x370U)

/* Soft Turn Off Configuration Register */

#define   L9502_VALUE_STO_CFG      (0x145U) /* 0b0001 0100 0101 */

/* Low  Voltage Diagnostic Registers (default value) */
#define   L9502_VALUE_FHM_2         (0x007U)
#define   L9502_VALUE_FHM_3         (0x000U)

/* High Voltage Diagnostic Registers (default value) */
#define   L9502_VALUE_FHM_0         (0x1FFU)
#define   L9502_VALUE_FHM_1         (0x01FU)


#ifdef __cplusplus
}
#endif

#endif /* __L9502_CFG_H__ */

