/****************************************************************************
*
* Copyright (c) 2022 STMicroelectronics - All Rights Reserved
*
* License terms: STMicroelectronics Proprietary in accordance with licensing
* terms SLA0098 at www.st.com.
*
* THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*
* PLEASE NOTE THAT THIS FILE IS GENERATED FROM A CONFIGURATION FILE,
* USING com.st.stellar.pinmap.gpiocfg, Version 2.1.0.202406141217
* MODIFYING IT IMPLIES POTENTIAL LOSS OF YOUR MODIFICATIONS.
*
*****************************************************************************/
/**
 * @file    evbe3000d.h
 * @brief   SR5E1-MYBOARD board header file.
 *
 * @addtogroup PLATFORM
 * @addtogroup BOARD
 * @ingroup PLATFORM
 * @addtogroup EVBE3000D
 * @ingroup BOARD
 * @{
 */

#ifndef _EVBE3000D_H_
#define _EVBE3000D_H_

#include <gpio.h>
#include <platform.h>
#include <typedefs.h>


/*===========================================================================*/
/* Module constants.                                                         */
/*===========================================================================*/

#define MYBOARD	1

/*--------------------- TIM8 pins definitions ---------------------*/
#define MC_PWM_UH gpio_iopack(GPIO_PORT_I, GPIO_PIN_0) /* PI[0] */
#define MC_PWM_UH_CFG                               \
	(GPIO_MODE_MODER_ALTERNATE |                    \
	 GPIO_MODE_OTYPER_PUSHPULL |                    \
	 GPIO_MODE_OSPEEDR_HIGH |                       \
	 GPIO_MODE_PUPDR_PULLDOWN |                     \
	 GPIO_MODE_AFR(4U) |                            \
	 GPIO_MODE_IHYSTR_CMOS |                        \
	 GPIO_MODE_TRIGENR_IN_DISABLED |                \
	 GPIO_MODE_SAFESELR_DISABLED |                  \
	 GPIO_MODE_SAFEVALR_LOW)

#define MC_PWM_UL gpio_iopack(GPIO_PORT_I, GPIO_PIN_1) /* PI[1] */
#define MC_PWM_UL_CFG                               \
	(GPIO_MODE_MODER_ALTERNATE |                    \
	 GPIO_MODE_OTYPER_PUSHPULL |                    \
	 GPIO_MODE_OSPEEDR_HIGH |                       \
	 GPIO_MODE_PUPDR_PULLDOWN |                     \
	 GPIO_MODE_AFR(4U) |                            \
	 GPIO_MODE_IHYSTR_CMOS |                        \
	 GPIO_MODE_TRIGENR_IN_DISABLED |                \
	 GPIO_MODE_SAFESELR_DISABLED |                  \
	 GPIO_MODE_SAFEVALR_LOW)

#define MC_PWM_VH gpio_iopack(GPIO_PORT_I, GPIO_PIN_2) /* PI[2] */
#define MC_PWM_VH_CFG                               \
	(GPIO_MODE_MODER_ALTERNATE |                    \
	 GPIO_MODE_OTYPER_PUSHPULL |                    \
	 GPIO_MODE_OSPEEDR_HIGH |                       \
	 GPIO_MODE_PUPDR_PULLDOWN |                     \
	 GPIO_MODE_AFR(4U) |                            \
	 GPIO_MODE_IHYSTR_CMOS |                        \
	 GPIO_MODE_TRIGENR_IN_DISABLED |                \
	 GPIO_MODE_SAFESELR_DISABLED |                  \
	 GPIO_MODE_SAFEVALR_LOW)

#define MC_PWM_VL gpio_iopack(GPIO_PORT_I, GPIO_PIN_3) /* PI[3] */
#define MC_PWM_VL_CFG                               \
	(GPIO_MODE_MODER_ALTERNATE |                    \
	 GPIO_MODE_OTYPER_PUSHPULL |                    \
	 GPIO_MODE_OSPEEDR_HIGH |                       \
	 GPIO_MODE_PUPDR_PULLDOWN |                     \
	 GPIO_MODE_AFR(4U) |                            \
	 GPIO_MODE_IHYSTR_CMOS |                        \
	 GPIO_MODE_TRIGENR_IN_DISABLED |                \
	 GPIO_MODE_SAFESELR_DISABLED |                  \
	 GPIO_MODE_SAFEVALR_LOW)

#define MC_PWM_WH gpio_iopack(GPIO_PORT_I, GPIO_PIN_4) /* PI[4] */
#define MC_PWM_WH_CFG                               \
	(GPIO_MODE_MODER_ALTERNATE |                    \
	 GPIO_MODE_OTYPER_PUSHPULL |                    \
	 GPIO_MODE_OSPEEDR_HIGH |                       \
	 GPIO_MODE_PUPDR_PULLDOWN |                     \
	 GPIO_MODE_AFR(4U) |                            \
	 GPIO_MODE_IHYSTR_CMOS |                        \
	 GPIO_MODE_TRIGENR_IN_DISABLED |                \
	 GPIO_MODE_SAFESELR_DISABLED |                  \
	 GPIO_MODE_SAFEVALR_LOW)

#define MC_PWM_WL gpio_iopack(GPIO_PORT_I, GPIO_PIN_5) /* PI[5] */
#define MC_PWM_WL_CFG                               \
	(GPIO_MODE_MODER_ALTERNATE |                    \
	 GPIO_MODE_OTYPER_PUSHPULL |                    \
	 GPIO_MODE_OSPEEDR_HIGH |                       \
	 GPIO_MODE_PUPDR_PULLDOWN |                     \
	 GPIO_MODE_AFR(4U) |                            \
	 GPIO_MODE_IHYSTR_CMOS |                        \
	 GPIO_MODE_TRIGENR_IN_DISABLED |                \
	 GPIO_MODE_SAFESELR_DISABLED |                  \
	 GPIO_MODE_SAFEVALR_LOW)


/*--------------------- SAR1 pins definitions ---------------------*/
#define CURR_FBK_U gpio_iopack(GPIO_PORT_B, GPIO_PIN_2) /* PB[2] */
#define CURR_FBK_U_CFG                              \
	(GPIO_MODE_MODER_ANALOG |                       \
	 GPIO_MODE_OTYPER_PUSHPULL |                    \
	 GPIO_MODE_OSPEEDR_LOW |                        \
	 GPIO_MODE_PUPDR_FLOATING |                     \
	 GPIO_MODE_AFR(0U) |                            \
	 GPIO_MODE_IHYSTR_CMOS |                        \
	 GPIO_MODE_TRIGENR_IN_DISABLED |                \
	 GPIO_MODE_SAFESELR_DISABLED |                  \
	 GPIO_MODE_SAFEVALR_LOW)


/*--------------------- SAR2 pins definitions ---------------------*/
#define CURR_FBK_V gpio_iopack(GPIO_PORT_B, GPIO_PIN_7) /* PB[7] */
#define CURR_FBK_V_CFG                              \
	(GPIO_MODE_MODER_ANALOG |                       \
	 GPIO_MODE_OTYPER_PUSHPULL |                    \
	 GPIO_MODE_OSPEEDR_LOW |                        \
	 GPIO_MODE_PUPDR_FLOATING |                     \
	 GPIO_MODE_AFR(0U) |                            \
	 GPIO_MODE_IHYSTR_CMOS |                        \
	 GPIO_MODE_TRIGENR_IN_DISABLED |                \
	 GPIO_MODE_SAFESELR_DISABLED |                  \
	 GPIO_MODE_SAFEVALR_LOW)


/*--------------------- SAR3 pins definitions ---------------------*/
#define VBUS_FBK gpio_iopack(GPIO_PORT_B, GPIO_PIN_14) /* PB[14] */
#define VBUS_FBK_CFG                                \
	(GPIO_MODE_MODER_ANALOG |                       \
	 GPIO_MODE_OTYPER_PUSHPULL |                    \
	 GPIO_MODE_OSPEEDR_LOW |                        \
	 GPIO_MODE_PUPDR_FLOATING |                     \
	 GPIO_MODE_AFR(0U) |                            \
	 GPIO_MODE_IHYSTR_CMOS |                        \
	 GPIO_MODE_TRIGENR_IN_DISABLED |                \
	 GPIO_MODE_SAFESELR_DISABLED |                  \
	 GPIO_MODE_SAFEVALR_LOW)


/*--------------------- SAR5 pins definitions ---------------------*/
#define TEMP_FBK gpio_iopack(GPIO_PORT_C, GPIO_PIN_10) /* PC[10] */
#define TEMP_FBK_CFG                                \
	(GPIO_MODE_MODER_ANALOG |                       \
	 GPIO_MODE_OTYPER_PUSHPULL |                    \
	 GPIO_MODE_OSPEEDR_LOW |                        \
	 GPIO_MODE_PUPDR_FLOATING |                     \
	 GPIO_MODE_AFR(0U) |                            \
	 GPIO_MODE_IHYSTR_CMOS |                        \
	 GPIO_MODE_TRIGENR_IN_DISABLED |                \
	 GPIO_MODE_SAFESELR_DISABLED |                  \
	 GPIO_MODE_SAFEVALR_LOW)


/*--------------------- UART1 pins definitions ---------------------*/
#define UART1_RX gpio_iopack(GPIO_PORT_F, GPIO_PIN_2) /* PF[2] */
#define UART1_RX_CFG                                \
	(GPIO_MODE_MODER_ALTERNATE |                    \
	 GPIO_MODE_OTYPER_PUSHPULL |                    \
	 GPIO_MODE_OSPEEDR_LOW |                        \
	 GPIO_MODE_PUPDR_FLOATING |                     \
	 GPIO_MODE_AFR(7U) |                            \
	 GPIO_MODE_IHYSTR_CMOS |                        \
	 GPIO_MODE_TRIGENR_IN_ENABLED |                 \
	 GPIO_MODE_SAFESELR_DISABLED |                  \
	 GPIO_MODE_SAFEVALR_LOW)

#define UART1_TX gpio_iopack(GPIO_PORT_F, GPIO_PIN_3) /* PF[3] */
#define UART1_TX_CFG                                \
	(GPIO_MODE_MODER_ALTERNATE |                    \
	 GPIO_MODE_OTYPER_PUSHPULL |                    \
	 GPIO_MODE_OSPEEDR_LOW |                        \
	 GPIO_MODE_PUPDR_FLOATING |                     \
	 GPIO_MODE_AFR(7U) |                            \
	 GPIO_MODE_IHYSTR_CMOS |                        \
	 GPIO_MODE_TRIGENR_IN_DISABLED |                \
	 GPIO_MODE_SAFESELR_DISABLED |                  \
	 GPIO_MODE_SAFEVALR_LOW)


/*--------------------- TIM5 pins definitions ---------------------*/
#define MC_HALL_CH1 gpio_iopack(GPIO_PORT_G, GPIO_PIN_5) /* PG[5] */
#define MC_HALL_CH1_CFG                             \
	(GPIO_MODE_MODER_ALTERNATE |                    \
	 GPIO_MODE_OTYPER_PUSHPULL |                    \
	 GPIO_MODE_OSPEEDR_LOW |                        \
	 GPIO_MODE_PUPDR_FLOATING |                     \
	 GPIO_MODE_AFR(1U) |                            \
	 GPIO_MODE_IHYSTR_CMOS |                        \
	 GPIO_MODE_TRIGENR_IN_ENABLED |                 \
	 GPIO_MODE_SAFESELR_DISABLED |                  \
	 GPIO_MODE_SAFEVALR_LOW)

#define MC_HALL_CH2 gpio_iopack(GPIO_PORT_G, GPIO_PIN_6) /* PG[6] */
#define MC_HALL_CH2_CFG                             \
	(GPIO_MODE_MODER_ALTERNATE |                    \
	 GPIO_MODE_OTYPER_PUSHPULL |                    \
	 GPIO_MODE_OSPEEDR_LOW |                        \
	 GPIO_MODE_PUPDR_FLOATING |                     \
	 GPIO_MODE_AFR(1U) |                            \
	 GPIO_MODE_IHYSTR_CMOS |                        \
	 GPIO_MODE_TRIGENR_IN_ENABLED |                 \
	 GPIO_MODE_SAFESELR_DISABLED |                  \
	 GPIO_MODE_SAFEVALR_LOW)

#define MC_HALL_CH3 gpio_iopack(GPIO_PORT_G, GPIO_PIN_7) /* PG[7] */
#define MC_HALL_CH3_CFG                             \
	(GPIO_MODE_MODER_ALTERNATE |                    \
	 GPIO_MODE_OTYPER_PUSHPULL |                    \
	 GPIO_MODE_OSPEEDR_LOW |                        \
	 GPIO_MODE_PUPDR_FLOATING |                     \
	 GPIO_MODE_AFR(1U) |                            \
	 GPIO_MODE_IHYSTR_CMOS |                        \
	 GPIO_MODE_TRIGENR_IN_ENABLED |                 \
	 GPIO_MODE_SAFESELR_DISABLED |                  \
	 GPIO_MODE_SAFEVALR_LOW)



/*===========================================================================*/
/* Module pre-compile time settings.                                         */
/*===========================================================================*/

/*===========================================================================*/
/* Derived constants and error checks.                                       */
/*===========================================================================*/

/*===========================================================================*/
/* Module data structures and types.                                         */
/*===========================================================================*/

/*===========================================================================*/
/* Module macros.                                                            */
/*===========================================================================*/

/*===========================================================================*/
/* External declarations.                                                    */
/*===========================================================================*/

#if !defined(_FROM_ASM_)
#ifdef __cplusplus
extern "C" {
#endif

#ifdef __cplusplus
}
#endif
#endif /* _FROM_ASM_ */

/*===========================================================================*/
/* Module inline functions.                                                  */
/*===========================================================================*/


__STATIC_INLINE void evbe3000d_init(void) {
	
	/* TIM8 */
	gpio_set_pin_mode(MC_PWM_UH, MC_PWM_UH_CFG);
	gpio_set_pin_mode(MC_PWM_UL, MC_PWM_UL_CFG);
	gpio_set_pin_mode(MC_PWM_VH, MC_PWM_VH_CFG);
	gpio_set_pin_mode(MC_PWM_VL, MC_PWM_VL_CFG);
	gpio_set_pin_mode(MC_PWM_WH, MC_PWM_WH_CFG);
	gpio_set_pin_mode(MC_PWM_WL, MC_PWM_WL_CFG);

	/* SAR1 */
	gpio_set_pin_mode(CURR_FBK_U, CURR_FBK_U_CFG);

	/* SAR2 */
	gpio_set_pin_mode(CURR_FBK_V, CURR_FBK_V_CFG);

	/* SAR3 */
	gpio_set_pin_mode(VBUS_FBK, VBUS_FBK_CFG);

	/* SAR5 */
	gpio_set_pin_mode(TEMP_FBK, TEMP_FBK_CFG);

	/* UART1 */
	gpio_set_pin_mode(UART1_RX, UART1_RX_CFG);
	gpio_set_pin_mode(UART1_TX, UART1_TX_CFG);

	/* TIM5 */
	gpio_set_pin_mode(MC_HALL_CH1, MC_HALL_CH1_CFG);
	gpio_set_pin_mode(MC_HALL_CH2, MC_HALL_CH2_CFG);
	gpio_set_pin_mode(MC_HALL_CH3, MC_HALL_CH3_CFG);

}

/*===========================================================================*/
/* Module late inclusions.                                                   */
/*===========================================================================*/

#endif /* _EVBE3000D_H_ */

/** @} */

