package com.st.stellar.component.gd_9502.impl;

import com.st.stellar.component.gd_9502.Gd_9502
import com.st.stellar.component.gd_9502.Gd_9502Package
import com.st.stellar.component.gd_9502.validation.MyGd_9502Validator
//import com.st.stellar.component.model.DerivedAttributeService
import org.eclipse.core.resources.IProject
import org.eclipse.core.resources.ResourcesPlugin
//import org.eclipse.core.runtime.IPath
//import org.eclipse.core.runtime.Path
import org.eclipse.emf.common.command.Command
import org.eclipse.emf.ecore.EAttribute
import org.eclipse.emf.ecore.EDataType
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.edit.command.SetCommand
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain
//import org.eclipse.swt.widgets.DirectoryDialog
//import org.eclipse.swt.widgets.Display
import org.eclipse.emf.ecore.EValidator

// This class overrides the generated class and will be instantiated by factory
class Gd_9502Impl extends MGd_9502Impl implements Gd_9502 {
	
	new() {
		/*DerivedAttributeService.INSTANCE.addDependencyListener(
			this,
			Gd_9502Package.eINSTANCE.gd_9502_FilePath,
			#[
				Gd_9502Package.eINSTANCE.gd_9502_Browse
			]
		)*/
		
		EValidator.Registry.INSTANCE.put(Gd_9502Package.eINSTANCE, new EValidator.Descriptor() {
			override getEValidator() {
				return MyGd_9502Validator.INSTANCE
			}
		});
		
	}

	/*override void browseModelPath() {
		Display.getDefault().syncExec([
			var DirectoryDialog dlg = new DirectoryDialog(Display.getDefault().getActiveShell()) // FileDialog dlg = new FileDialog(Display.getDefault().getActiveShell());
			// Set the initial filter path according
			// to anything they've selected or typed in
			dlg.setFilterPath("")

			// Change the title bar text
			dlg.setText("Select a folder")

			// Calling open() will open and run the dialog.
			// It will return the selected directory, or null if user cancels
			var String dir = dlg.open()
			if (dir !== null) {
				var IPath location = null;
				if (dir !== null) {
					// Replace absolute file name by relative path to the workspace
					location = new Path(dir);
					val base = getProject(this).getLocation();
					location = location.makeRelativeTo(base);

					setAttributeValue(this, Gd_9502Package.eINSTANCE.gd_9502_FilePath, location.toString);
				}
			}
		])
	}*/
	
	static def IProject getProject(EObject model) {
		var IProject project = null
		val uri = model.eResource().getURI();
		if (!uri.isFile()) {
			project = null;
		}
		val projectName = uri.segmentsList().get(1).toString()
		project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
		return project;
	}
	
	def setAttributeValue(EObject object, EAttribute attribute, String value) {
		val editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor(object)

		val eClassifier = attribute.EType
		if (eClassifier instanceof EDataType) {
			val eDataType = eClassifier as EDataType
			val eFactory = eDataType.getEPackage().getEFactoryInstance()
			val newValue = eFactory.createFromString(eDataType, value)
			val Command command = SetCommand.create(editingDomain, object, attribute,
				newValue);
			// System.out.println("Attribute '" + attribute.getName() + "' set to " + newValue.toString());
			editingDomain.getCommandStack().execute(command);
		}
	}
}
