package com.st.stellar.component.gd_9502.impl

//import java.util.Locale
import com.google.inject.Inject
import com.google.inject.Provider
import com.st.stellar.component.Component
import org.eclipse.emf.ecore.resource.Resource
import org.eclipse.xtext.generator.AbstractGenerator
import org.eclipse.xtext.generator.IFileSystemAccess2
import org.eclipse.xtext.generator.IGeneratorContext
import com.st.stellar.component.gd_9502.safe_sel_enum
import com.st.stellar.component.gd_9502.react_cfg_enum
import com.st.stellar.component.gd_9502.fault2_adc_cfg_enum
import com.st.stellar.component.gd_9502.in_m_dis_enum
import com.st.stellar.component.gd_9502.fault_force_enum
import com.st.stellar.component.gd_9502.en_enum
import com.st.stellar.component.gd_9502.fly_ovc_react_cfg_enum
import com.st.stellar.component.gd_9502.dtp_cfg_enum
import com.st.stellar.component.gd_9502.symmetric_delay_enum
import com.st.stellar.component.gd_9502.red_cfg_enum
import com.st.stellar.component.gd_9502.vl_cfg_enum
import com.st.stellar.component.gd_9502.desat_current_cfg_enum
import com.st.stellar.component.gd_9502.desat_th_cfg_enum
import com.st.stellar.component.gd_9502.sense_th_cfg_enum
import com.st.stellar.component.gd_9502.desat_blk_enum
import com.st.stellar.component.gd_9502.vgemon_react_cfg_enum
import com.st.stellar.component.gd_9502.tsen_curr_cfg_enum
import com.st.stellar.component.gd_9502.sto_i_cfg_enum
import com.st.stellar.component.gd_9502.abist_en_enum
import com.st.stellar.component.gd_9502.adc_soc_enum
import com.st.stellar.component.gd_9502.global_latch_clear_enum
import com.st.stellar.component.gd_9502.sto_tsto_cfg_enum
import com.st.stellar.component.gd_9502.sto_vth_cfg_enum
import com.st.stellar.component.gd_9502.dis_re_engagement_enum
import com.st.stellar.component.gd_9502.adc_out_sel_enum
import com.st.stellar.component.gd_9502.drv_capability_enum
import com.st.stellar.component.gd_9502.brake_priority_enum
import com.st.stellar.component.gd_9502.vh_uv_priority_enum
import com.st.stellar.component.gd_9502.vh_uv_fail_inj_enum
import com.st.stellar.component.gd_9502.adc_vtref_select_enum
import com.st.stellar.component.gd_9502.vge_filt_cfg_enum
import com.st.stellar.component.gd_9502.shoot_dly_enum
import com.st.stellar.component.gd_9502.Ip_version_enum
import org.eclipse.emf.ecore.resource.ResourceSet
import com.st.stellar.component.gd_9502.Gd_9502

class Gd_9502CodeGenerator extends AbstractGenerator {

	@Inject Provider<ResourceSet> rsp
	override doGenerate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
		val resourceSet = rsp.get
		val r = resourceSet.getResource(input.URI, true)
		if(r.contents.empty) return
		val cmp = r.contents.head as Component
		   val html_L9502cfg = generateL9502cfgCode(cmp)
           fsa.generateFile("../code-gen/L9502_cfg.h", html_L9502cfg)
		   val html_L9502 = generateL9502Code(cmp)
           fsa.generateFile("../code-gen/L9502.c", html_L9502)
		   
			/*try {
				ResourcesPlugin.workspace.root.refreshLocal(IResource.DEPTH_INFINITE, new NullProgressMonitor)
			} catch (IllegalStateException ise) {
				// Ignore it... workspace is closed 
			}*/
		
	}


	
	def String generateL9502cfgCode(Component comp) {
		val settings = (comp as Gd_9502)
		val num_devices = settings.number_of_devices
        val enable = settings.enable_soft_start_up
        val test_mode = settings.test_mode
        val version = settings.ip_version
        val chip_id = settings.l9502_registers.low_voltage_registers.chip_id
        val chip_LSBs = chip_id%16
        val chip_MSBs = chip_id/16
		val hex_chip_LSBs = int2hex(chip_LSBs)
		val hex_chip_MSBs = int2hex(chip_MSBs)

     /*                CFG 8 START                              */
        val cfg_8 = settings.l9502_registers.low_voltage_registers.cfg_8
        val srr_parity = cfg_8.srr_parity
        var safe_sel_temp = cfg_8.safe_sel
        var cfg8_safe_sel = 1
        if(safe_sel_temp === safe_sel_enum.LS_ON){
            cfg8_safe_sel = 0
        }
        var wtd_react_cfg_temp = cfg_8.wtd_react_cfg
        var wtd_react_cfg = 1
        if(wtd_react_cfg_temp === react_cfg_enum.MODE){
            wtd_react_cfg = 0
        }
        val faultn2_adc_cfg_temp = cfg_8.fault2_adc_cfg    
        var faultn2_adc_cfg = 1
        if(faultn2_adc_cfg_temp === fault2_adc_cfg_enum.FAULT2){
            faultn2_adc_cfg = 0
        }
        val in_m_dis_temp = cfg_8.in_m_dis    
        var in_m_dis = 0
        if(in_m_dis_temp === in_m_dis_enum.DISCARTED){
            in_m_dis = 1
        }
        val fault1_force_temp = cfg_8.fault1_force    
        var fault1_force = 1
        if(fault1_force_temp === fault_force_enum.IDLE){
            fault1_force = 0
        }
        val fault2_force_temp = cfg_8.fault2_force    
        var fault2_force = 1
        if(fault2_force_temp === fault_force_enum.IDLE){
            fault2_force = 0
        }       
        val fly_en_temp = cfg_8.fly_en    
        var fly_en = 1
        if(fly_en_temp === en_enum.DISABLED){
            fly_en = 0
        }
        val fly_ovc_react_cfg_temp = cfg_8.fly_ovc_react_cfg    
        var fly_ovc_react_cfg = 1
        if(fly_ovc_react_cfg_temp === fly_ovc_react_cfg_enum.NEXT_PWM){
            fly_ovc_react_cfg = 0
        }
     /*                CFG 8 END                              */
    
     /*                CFG 9 START                            */
        val cfg_9 = settings.l9502_registers.low_voltage_registers.cfg_9
        val dtp_cfg_temp = cfg_9.dtp_cfg
        var dtp_cfg_2 = 0
        var dtp_cfg_1 = 0
        var dtp_cfg_0 = 0
        if(dtp_cfg_temp === dtp_cfg_enum.TDEAD_45_0NS){
            dtp_cfg_2 = 0
            dtp_cfg_1 = 0
            dtp_cfg_0 = 0
        }else if(dtp_cfg_temp === dtp_cfg_enum.TDEAD_65_0NS){
            dtp_cfg_2 = 0
            dtp_cfg_1 = 0
            dtp_cfg_0 = 1   
        }else if(dtp_cfg_temp === dtp_cfg_enum.TDEAD_83_0NS){
            dtp_cfg_2 = 0
            dtp_cfg_1 = 1
            dtp_cfg_0 = 0   
        }else if(dtp_cfg_temp === dtp_cfg_enum.TDEAD_92_0NS){
            dtp_cfg_2 = 0
            dtp_cfg_1 = 1
            dtp_cfg_0 = 1   
        }else if(dtp_cfg_temp === dtp_cfg_enum.TDEAD_1US2){
            dtp_cfg_2 = 1
            dtp_cfg_1 = 0
            dtp_cfg_0 = 0   
        }else if(dtp_cfg_temp === dtp_cfg_enum.TDEAD_1US32){
            dtp_cfg_2 = 1
            dtp_cfg_1 = 0
            dtp_cfg_0 = 1   
        }else if(dtp_cfg_temp === dtp_cfg_enum.TDEAD_1US8){
            dtp_cfg_2 = 1
            dtp_cfg_1 = 1
            dtp_cfg_0 = 0   
        }else if(dtp_cfg_temp === dtp_cfg_enum.TDEAD_2US6){
            dtp_cfg_2 = 1
            dtp_cfg_1 = 1
            dtp_cfg_0 = 1   
        }
        var symmetric_delay_temp = cfg_9.symmetric_delay
        var cfg9_symmetric_delay = 1
        if(symmetric_delay_temp === symmetric_delay_enum.ASYMMETRIC){
            cfg9_symmetric_delay = 0
        }
        var red_cfg_wtd_fail_temp = cfg_9.red_cfg_wtd_fail
        var red_cfg9_wtd_fail_1 = 1
        var red_cfg9_wtd_fail_0 = 1
        if(red_cfg_wtd_fail_temp === red_cfg_enum.NO_DIRECTION){
            red_cfg9_wtd_fail_1 = 0
            red_cfg9_wtd_fail_0 = 0
        }else if(red_cfg_wtd_fail_temp === red_cfg_enum.GSW1_FAULTN1){
            red_cfg9_wtd_fail_1 = 0
            red_cfg9_wtd_fail_0 = 1   
        }else if(red_cfg_wtd_fail_temp === red_cfg_enum.GSW2_FAULTN2){
            red_cfg9_wtd_fail_1 = 1
            red_cfg9_wtd_fail_0 = 0   
        }else if(red_cfg_wtd_fail_temp === red_cfg_enum.BOTH){
            red_cfg9_wtd_fail_1 = 1
            red_cfg9_wtd_fail_0 = 1   
        } 
        var red_cfg_srr_fail_temp = cfg_9.red_cfg_srr_fail
        var red_cfg9_srr_fail_1 = 1
        var red_cfg9_srr_fail_0 = 1
        if(red_cfg_srr_fail_temp === red_cfg_enum.NO_DIRECTION){
            red_cfg9_srr_fail_1 = 0
            red_cfg9_srr_fail_0 = 0
        }else if(red_cfg_srr_fail_temp === red_cfg_enum.GSW1_FAULTN1){
            red_cfg9_srr_fail_1 = 0
            red_cfg9_srr_fail_0 = 1   
        }else if(red_cfg_srr_fail_temp === red_cfg_enum.GSW2_FAULTN2){
            red_cfg9_srr_fail_1 = 1
            red_cfg9_srr_fail_0 = 0   
        }else if(red_cfg_srr_fail_temp === red_cfg_enum.BOTH){
            red_cfg9_srr_fail_1 = 1
            red_cfg9_srr_fail_0 = 1   
        }
        val red_cfg_fly_ovc_temp = cfg_9.red_cfg_fly_ovc
        var red_cfg_fly_ovc_1 = 1
        var red_cfg_fly_ovc_0 = 1
        if(red_cfg_fly_ovc_temp === red_cfg_enum.NO_DIRECTION){
            red_cfg_fly_ovc_1 = 0
            red_cfg_fly_ovc_0 = 0
        }else if(red_cfg_fly_ovc_temp === red_cfg_enum.GSW1_FAULTN1){
            red_cfg_fly_ovc_1 = 0
            red_cfg_fly_ovc_0 = 1   
        }else if(red_cfg_fly_ovc_temp === red_cfg_enum.GSW2_FAULTN2){
            red_cfg_fly_ovc_1 = 1
            red_cfg_fly_ovc_0 = 0   
        }else if(red_cfg_fly_ovc_temp === red_cfg_enum.BOTH){
            red_cfg_fly_ovc_1 = 1
            red_cfg_fly_ovc_0 = 1   
        }
     /*                CFG 9 END                               */

     /*                CFG 0 START                              */
        val cfg_0 = settings.l9502_registers.high_voltage_registers.cfg_0
        
        safe_sel_temp = cfg_0.safe_sel
        var cfg0_safe_sel = 1
        if(safe_sel_temp === safe_sel_enum.LS_ON){
            cfg0_safe_sel = 0
        }

        val desat_en_temp = cfg_0.desat_en
        var desat_en = 1
        if(desat_en_temp === en_enum.DISABLED){
            desat_en = 0
        }

        val sense_en_temp = cfg_0.sense_en
        var sense_en = 1
        if(sense_en_temp === en_enum.DISABLED){
            sense_en = 0
        }

        val vh_ov_en_temp = cfg_0.vh_ov_en
        var vh_ov_en = 1
        if(vh_ov_en_temp === en_enum.DISABLED){
            vh_ov_en = 0
        }

        val vh_uv_en_temp = cfg_0.vh_uv_en
        var vh_uv_en = 1
        if(vh_uv_en_temp === en_enum.DISABLED){
            vh_uv_en = 0
        }

        val vl_cfg_temp = cfg_0.vl_cfg
        var vl1_cfg = 0
        var vl0_cfg = 0
        if(vl_cfg_temp === vl_cfg_enum.MENUS_3V3){
             vl1_cfg = 0
             vl0_cfg = 0
        }else if(vl_cfg_temp === vl_cfg_enum.MENUS_5V){
             vl1_cfg = 0
             vl0_cfg = 1            
        }else if(vl_cfg_temp === vl_cfg_enum.MENUS_8V){
             vl1_cfg = 1
             vl0_cfg = 0            
        }else if(vl_cfg_temp === vl_cfg_enum.VL_DISABLED){
             vl1_cfg = 1
             vl0_cfg = 1            
        }
     /*                CFG 0 END                              */

     /*                CFG 1 START                              */
        val cfg_1 = settings.l9502_registers.high_voltage_registers.cfg_1  
        val tsen_ot_react_cfg_temp = cfg_1.tsen_ot_react_cfg
        var tsen_ot_react_cfg = 1
        if(tsen_ot_react_cfg_temp === react_cfg_enum.MODE){
            tsen_ot_react_cfg = 0
        }
        val desat_react_cfg_temp = cfg_1.desat_react_cfg
        var desat_react_cfg = 1
        if(desat_react_cfg_temp === react_cfg_enum.MODE){
            desat_react_cfg = 0
        }
        val sense_react_cfg_temp = cfg_1.sense_react_cfg
        var sense_react_cfg = 1
        if(sense_react_cfg_temp === react_cfg_enum.MODE){
            sense_react_cfg = 0
        }
        val vh_uv_react_cfg_temp = cfg_1.vh_uv_react_cfg
        var vh_uv_react_cfg = 1
        if(vh_uv_react_cfg_temp === react_cfg_enum.MODE){
            vh_uv_react_cfg = 0
        }
        val vh_ov_react_cfg_temp = cfg_1.vh_ov_react_cfg
        var vh_ov_react_cfg = 1
        if(vh_ov_react_cfg_temp === react_cfg_enum.MODE){
            vh_ov_react_cfg = 0
        }
        val vl_uv_react_cfg_temp = cfg_1.vl_uv_react_cfg
        var vl_uv_react_cfg = 1
        if(vl_uv_react_cfg_temp === react_cfg_enum.MODE){
            vl_uv_react_cfg = 0
        }
        val vl_ov_react_cfg_temp = cfg_1.vl_ov_react_cfg
        var vl_ov_react_cfg = 1
        if(vl_ov_react_cfg_temp === react_cfg_enum.MODE){
            vl_ov_react_cfg = 0
        }
     /*                CFG 1 END                              */

     /*                CFG 2 START                              */
        val cfg_2 = settings.l9502_registers.high_voltage_registers.cfg_2  
        wtd_react_cfg_temp = cfg_2.wtd_react_cfg
        var wtd_react_cfg_1 = 0
        var wtd_react_cfg_0 = 1
         if(wtd_react_cfg_temp === react_cfg_enum.MODE){
            wtd_react_cfg_0 = 0
        }
        val desat_current_cfg_temp = cfg_2.desat_current_cfg
        var desat_current_cfg_1 = 1
        var desat_current_cfg_0 = 1
        if(desat_current_cfg_temp ===  desat_current_cfg_enum.IDESAT_0M_A5){
            desat_current_cfg_1 = 0
            desat_current_cfg_0 = 0
        }else if(desat_current_cfg_temp ===  desat_current_cfg_enum.IDESAT_1M_A5){
            desat_current_cfg_1 = 0
            desat_current_cfg_0 = 1
        }else if(desat_current_cfg_temp ===  desat_current_cfg_enum.IDESAT_3M_A2){
            desat_current_cfg_1 = 1
            desat_current_cfg_0 = 0
        }else if(desat_current_cfg_temp ===  desat_current_cfg_enum.IDESAT_4M_A2){
            desat_current_cfg_1 = 1
            desat_current_cfg_0 = 1
        }
        val desat_th_cfg_temp = cfg_2.desat_th_cfg
        var desat_th_cfg_2 = 1
        var desat_th_cfg_1 = 1
        var desat_th_cfg_0 = 1
        if(desat_th_cfg_temp ===  desat_th_cfg_enum.VDESATD_TH_3V){
            desat_th_cfg_2 = 0
            desat_th_cfg_1 = 0
            desat_th_cfg_0 = 0
        }else if(desat_th_cfg_temp ===  desat_th_cfg_enum.VDESATD_TH_4V){
            desat_th_cfg_2 = 0
            desat_th_cfg_1 = 0
            desat_th_cfg_0 = 1
        }else if(desat_th_cfg_temp ===  desat_th_cfg_enum.VDESATD_TH_5V){
            desat_th_cfg_2 = 0
            desat_th_cfg_1 = 1
            desat_th_cfg_0 = 0
        }else if(desat_th_cfg_temp ===  desat_th_cfg_enum.VDESATD_TH_6V){
            desat_th_cfg_2 = 0
            desat_th_cfg_1 = 1
            desat_th_cfg_0 = 1
        }else if(desat_th_cfg_temp ===  desat_th_cfg_enum.VDESATD_TH_7V){
            desat_th_cfg_2 = 1
            desat_th_cfg_1 = 0
            desat_th_cfg_0 = 0
        }else if(desat_th_cfg_temp ===  desat_th_cfg_enum.VDESATD_TH_8V){
            desat_th_cfg_2 = 1
            desat_th_cfg_1 = 0
            desat_th_cfg_0 = 1
        }else if(desat_th_cfg_temp ===  desat_th_cfg_enum.VDESATD_TH_9V){
            desat_th_cfg_2 = 1
            desat_th_cfg_1 = 1
            desat_th_cfg_0 = 0
        }else if(desat_th_cfg_temp ===  desat_th_cfg_enum.VDESATD_TH_10V){
            desat_th_cfg_2 = 1
            desat_th_cfg_1 = 1
            desat_th_cfg_0 = 1
        }
        val sense_th_cfg_temp = cfg_2.sense_th_cfg
        var sense_th_cfg_2 = 1
        var sense_th_cfg_1 = 1
        var sense_th_cfg_0 = 1
        if(sense_th_cfg_temp ===  sense_th_cfg_enum.VISEN_TH_20_0M_V ){
            sense_th_cfg_2 = 0
            sense_th_cfg_1 = 0
            sense_th_cfg_0 = 0
        }else if(sense_th_cfg_temp ===  sense_th_cfg_enum.VISEN_TH_25_0M_V ){
            sense_th_cfg_2 = 0
            sense_th_cfg_1 = 0
            sense_th_cfg_0 = 1
        }else if(sense_th_cfg_temp ===  sense_th_cfg_enum.VISEN_TH_30_0M_V){
            sense_th_cfg_2 = 0
            sense_th_cfg_1 = 1
            sense_th_cfg_0 = 0
        }else if(sense_th_cfg_temp ===  sense_th_cfg_enum.VISEN_TH_35_0M_V){
            sense_th_cfg_2 = 0
            sense_th_cfg_1 = 1
            sense_th_cfg_0 = 1
        }else if(sense_th_cfg_temp ===  sense_th_cfg_enum.VISEN_TH_40_0M_V){
            sense_th_cfg_2 = 1
            sense_th_cfg_1 = 0
            sense_th_cfg_0 = 0
        }else if(sense_th_cfg_temp ===  sense_th_cfg_enum.VISEN_TH_45_0M_V){
            sense_th_cfg_2 = 1
            sense_th_cfg_1 = 0
            sense_th_cfg_0 = 1
        }else if(sense_th_cfg_temp ===  sense_th_cfg_enum.VISEN_TH_50_0M_V){
            sense_th_cfg_2 = 1
            sense_th_cfg_1 = 1
            sense_th_cfg_0 = 0
        }else if(sense_th_cfg_temp ===  sense_th_cfg_enum.VISEN_TH_55_0M_V){
            sense_th_cfg_2 = 1
            sense_th_cfg_1 = 1
            sense_th_cfg_0 = 1
        }
     /*                CFG 2 END                              */

     /*                CFG 3 START                              */
        val cfg_3 = settings.l9502_registers.high_voltage_registers.cfg_3  
        val desat_blk_temp = cfg_3.desat_blk
        var desat_blk_2 = 1
        var desat_blk_1 = 1
        var desat_blk_0 = 1
        if(desat_blk_temp ===  desat_blk_enum.TDESAT_0NS){
            desat_blk_2 = 0
            desat_blk_1 = 0
            desat_blk_0 = 0
        }else if(desat_blk_temp ===  desat_blk_enum.TDESAT_15_5NS){
            desat_blk_2 = 0
            desat_blk_1 = 0
            desat_blk_0 = 1
        }else if(desat_blk_temp ===  desat_blk_enum.TDESAT_25_5NS){
            desat_blk_2 = 0
            desat_blk_1 = 1
            desat_blk_0 = 0
        }else if(desat_blk_temp ===  desat_blk_enum.TDESAT_35_5NS){
            desat_blk_2 = 0
            desat_blk_1 = 1
            desat_blk_0 = 1
        }else if(desat_blk_temp ===  desat_blk_enum.TDESAT_45_5NS){
            desat_blk_2 = 1
            desat_blk_1 = 0
            desat_blk_0 = 0
        }else if(desat_blk_temp ===  desat_blk_enum.TDESAT_55_5NS){
            desat_blk_2 = 1
            desat_blk_1 = 0
            desat_blk_0 = 1
        }else if(desat_blk_temp ===  desat_blk_enum.TDESAT_65_5NS){
            desat_blk_2 = 1
            desat_blk_1 = 1
            desat_blk_0 = 0
        }else if(desat_blk_temp ===  desat_blk_enum.TDESAT_75_5NS){
            desat_blk_2 = 1
            desat_blk_1 = 1
            desat_blk_0 = 1
        }
        val vgemon_react_cfg_temp = cfg_3.vgemon_react_cfg
        var vgemon_react_cfg_1 = 1
        var vgemon_react_cfg_0 = 1
        if(vgemon_react_cfg_temp ===  vgemon_react_cfg_enum.FLAG){
            vgemon_react_cfg_1 = 0
            vgemon_react_cfg_0 = 0
        }else if(vgemon_react_cfg_temp ===  vgemon_react_cfg_enum.HI_Z){
            vgemon_react_cfg_1 = 0
            vgemon_react_cfg_0 = 1
        }else if(vgemon_react_cfg_temp ===  vgemon_react_cfg_enum.SAFE_LCKO){
            vgemon_react_cfg_1 = 1
            vgemon_react_cfg_0 = 0
        }
        val tsen_curr_cfg_temp = cfg_3.tsen_curr_cfg
        var tsen_curr_cfg_1 = 1
        var tsen_curr_cfg_0 = 1
        if(tsen_curr_cfg_temp ===  tsen_curr_cfg_enum.VTREF){
            tsen_curr_cfg_1 = 0
            tsen_curr_cfg_0 = 0
        }else if(tsen_curr_cfg_temp ===  tsen_curr_cfg_enum.I25_0U_A){
            tsen_curr_cfg_1 = 0
            tsen_curr_cfg_0 = 1
        }else if(tsen_curr_cfg_temp ===  tsen_curr_cfg_enum.I50_0U_A){
            tsen_curr_cfg_1 = 1
            tsen_curr_cfg_0 = 0
        }else if(tsen_curr_cfg_temp ===  tsen_curr_cfg_enum.I1M_A){
            tsen_curr_cfg_1 = 1
            tsen_curr_cfg_0 = 1
        }
        val sto_i_cfg_temp = cfg_3.sto_i_cfg
        var sto_i_cfg_2 = 1
        var sto_i_cfg_1 = 1
        var sto_i_cfg_0 = 1
        if(sto_i_cfg_temp ===  sto_i_cfg_enum.ISTO_68_0M_A){
            sto_i_cfg_2 = 0
            sto_i_cfg_1 = 0
            sto_i_cfg_0 = 0
        }else if(sto_i_cfg_temp ===  sto_i_cfg_enum.ISTO_92_0M_A){
            sto_i_cfg_2 = 0
            sto_i_cfg_1 = 0
            sto_i_cfg_0 = 1
        }else if(sto_i_cfg_temp ===  sto_i_cfg_enum.ISTO_124_0M_A){
            sto_i_cfg_2 = 0
            sto_i_cfg_1 = 1
            sto_i_cfg_0 = 0
        }else if(sto_i_cfg_temp ===  sto_i_cfg_enum.ISTO_156_0M_A){
            sto_i_cfg_2 = 0
            sto_i_cfg_1 = 1
            sto_i_cfg_0 = 1
        }else if(sto_i_cfg_temp ===  sto_i_cfg_enum.ISTO_188_0M_A){
            sto_i_cfg_2 = 1
            sto_i_cfg_1 = 0
            sto_i_cfg_0 = 0
        }else if(sto_i_cfg_temp ===  sto_i_cfg_enum.ISTO_220_0M_A){
            sto_i_cfg_2 = 1
            sto_i_cfg_1 = 0
            sto_i_cfg_0 = 1
        }else if(sto_i_cfg_temp ===  sto_i_cfg_enum.ISTO_252_0M_A){
            sto_i_cfg_2 = 1
            sto_i_cfg_1 = 1
            sto_i_cfg_0 = 0
        }else if(sto_i_cfg_temp ===  sto_i_cfg_enum.ISTO_284_0M_A){
            sto_i_cfg_2 = 1
            sto_i_cfg_1 = 1
            sto_i_cfg_0 = 1
        }
     /*                CFG 3 END                              */

     /*                CFG 4 START                              */
        val cfg_4 = settings.l9502_registers.high_voltage_registers.cfg_4 
        val red_cfg_tsen_temp = cfg_4.red_cfg_tsen
        var red_cfg_tsen_1 = 1
        var red_cfg_tsen_0 = 1
        if(red_cfg_tsen_temp === red_cfg_enum.NO_DIRECTION){
            red_cfg_tsen_1 = 0
            red_cfg_tsen_0 = 0
        }else if(red_cfg_tsen_temp === red_cfg_enum.GSW1_FAULTN1){
            red_cfg_tsen_1 = 0
            red_cfg_tsen_0 = 1   
        }else if(red_cfg_tsen_temp === red_cfg_enum.GSW2_FAULTN2){
            red_cfg_tsen_1 = 1
            red_cfg_tsen_0 = 0   
        }else if(red_cfg_tsen_temp === red_cfg_enum.BOTH){
            red_cfg_tsen_1 = 1
            red_cfg_tsen_0 = 1   
        }
        val red_cfg_desat_temp = cfg_4.red_cfg_desat
        var red_cfg_desat_1 = 1
        var red_cfg_desat_0 = 1
        if(red_cfg_desat_temp === red_cfg_enum.NO_DIRECTION){
            red_cfg_desat_1 = 0
            red_cfg_desat_0 = 0
        }else if(red_cfg_desat_temp === red_cfg_enum.GSW1_FAULTN1){
            red_cfg_desat_1 = 0
            red_cfg_desat_0 = 1   
        }else if(red_cfg_desat_temp === red_cfg_enum.GSW2_FAULTN2){
            red_cfg_desat_1 = 1
            red_cfg_desat_0 = 0   
        }else if(red_cfg_desat_temp === red_cfg_enum.BOTH){
            red_cfg_desat_1 = 1
            red_cfg_desat_0 = 1   
        }
        val red_cfg_sense_temp = cfg_4.red_cfg_sense
        var red_cfg_sense_1 = 1
        var red_cfg_sense_0 = 1
        if(red_cfg_sense_temp === red_cfg_enum.NO_DIRECTION){
            red_cfg_sense_1 = 0
            red_cfg_sense_0 = 0
        }else if(red_cfg_sense_temp === red_cfg_enum.GSW1_FAULTN1){
            red_cfg_sense_1 = 0
            red_cfg_sense_0 = 1   
        }else if(red_cfg_sense_temp === red_cfg_enum.GSW2_FAULTN2){
            red_cfg_sense_1 = 1
            red_cfg_sense_0 = 0   
        }else if(red_cfg_sense_temp === red_cfg_enum.BOTH){
            red_cfg_sense_1 = 1
            red_cfg_sense_0 = 1   
        }
        val red_cfg_vh_ov_temp = cfg_4.red_cfg_vh_ov
        var red_cfg_vh_ov_1 = 1
        var red_cfg_vh_ov_0 = 1
        if(red_cfg_vh_ov_temp === red_cfg_enum.NO_DIRECTION){
            red_cfg_vh_ov_1 = 0
            red_cfg_vh_ov_0 = 0
        }else if(red_cfg_vh_ov_temp === red_cfg_enum.GSW1_FAULTN1){
            red_cfg_vh_ov_1 = 0
            red_cfg_vh_ov_0 = 1   
        }else if(red_cfg_vh_ov_temp === red_cfg_enum.GSW2_FAULTN2){
            red_cfg_vh_ov_1 = 1
            red_cfg_vh_ov_0 = 0   
        }else if(red_cfg_vh_ov_temp === red_cfg_enum.BOTH){
            red_cfg_vh_ov_1 = 1
            red_cfg_vh_ov_0 = 1   
        }
        val red_cfg_vh_uv_temp = cfg_4.red_cfg_vh_uv
        var red_cfg_vh_uv_1 = 1
        var red_cfg_vh_uv_0 = 1
        if(red_cfg_vh_uv_temp === red_cfg_enum.NO_DIRECTION){
            red_cfg_vh_uv_1 = 0
            red_cfg_vh_uv_0 = 0
        }else if(red_cfg_vh_uv_temp === red_cfg_enum.GSW1_FAULTN1){
            red_cfg_vh_uv_1 = 0
            red_cfg_vh_uv_0 = 1   
        }else if(red_cfg_vh_uv_temp === red_cfg_enum.GSW2_FAULTN2){
            red_cfg_vh_uv_1 = 1
            red_cfg_vh_uv_0 = 0   
        }else if(red_cfg_vh_uv_temp === red_cfg_enum.BOTH){
            red_cfg_vh_uv_1 = 1
            red_cfg_vh_uv_0 = 1   
        }
     /*                CFG 4 END                              */

     /*                CFG 5 START                              */
        val cfg_5 = settings.l9502_registers.high_voltage_registers.cfg_5 
        val abist_en_temp = cfg_5.abist_en
        var abist_en = 1
        if(abist_en_temp === abist_en_enum.STOP){
            abist_en = 0
        }
        val mc_dis_temp = cfg_5.mc_dis
        var mc_dis = 1
        if(mc_dis_temp === en_enum.ENABLED){
            mc_dis = 0
        }
        val red_cfg_vl_ov_temp = cfg_5.red_cfg_vl_ov
        var red_cfg_vl_ov_1 = 1
        var red_cfg_vl_ov_0 = 1
        if(red_cfg_vl_ov_temp === red_cfg_enum.NO_DIRECTION){
            red_cfg_vl_ov_1 = 0
            red_cfg_vl_ov_0 = 0
        }else if(red_cfg_vl_ov_temp === red_cfg_enum.GSW1_FAULTN1){
            red_cfg_vl_ov_1 = 0
            red_cfg_vl_ov_0 = 1   
        }else if(red_cfg_vl_ov_temp === red_cfg_enum.GSW2_FAULTN2){
            red_cfg_vl_ov_1 = 1
            red_cfg_vl_ov_0 = 0   
        }else if(red_cfg_vl_ov_temp === red_cfg_enum.BOTH){
            red_cfg_vl_ov_1 = 1
            red_cfg_vl_ov_0 = 1   
        }
        val red_cfg_vl_uv_temp = cfg_5.red_cfg_vl_uv
        var red_cfg_vl_uv_1 = 1
        var red_cfg_vl_uv_0 = 1
        if(red_cfg_vl_uv_temp === red_cfg_enum.NO_DIRECTION){
            red_cfg_vl_uv_1 = 0
            red_cfg_vl_uv_0 = 0
        }else if(red_cfg_vl_uv_temp === red_cfg_enum.GSW1_FAULTN1){
            red_cfg_vl_uv_1 = 0
            red_cfg_vl_uv_0 = 1   
        }else if(red_cfg_vl_uv_temp === red_cfg_enum.GSW2_FAULTN2){
            red_cfg_vl_uv_1 = 1
            red_cfg_vl_uv_0 = 0   
        }else if(red_cfg_vl_uv_temp === red_cfg_enum.BOTH){
            red_cfg_vl_uv_1 = 1
            red_cfg_vl_uv_0 = 1   
        }
        val red_cfg_otm_sd_temp = cfg_5.red_cfg_otm_sd
        var red_cfg_otm_sd_1 = 1
        var red_cfg_otm_sd_0 = 1
        if(red_cfg_otm_sd_temp === red_cfg_enum.NO_DIRECTION){
            red_cfg_otm_sd_1 = 0
            red_cfg_otm_sd_0 = 0
        }else if(red_cfg_otm_sd_temp === red_cfg_enum.GSW1_FAULTN1){
            red_cfg_otm_sd_1 = 0
            red_cfg_otm_sd_0 = 1   
        }else if(red_cfg_otm_sd_temp === red_cfg_enum.GSW2_FAULTN2){
            red_cfg_otm_sd_1 = 1
            red_cfg_otm_sd_0 = 0   
        }else if(red_cfg_otm_sd_temp === red_cfg_enum.BOTH){
            red_cfg_otm_sd_1 = 1
            red_cfg_otm_sd_0 = 1   
        }
         red_cfg_wtd_fail_temp = cfg_5.red_cfg_wtd_fail
        var red_cfg5_wtd_fail_1 = 1
        var red_cfg5_wtd_fail_0 = 1
        if(red_cfg_wtd_fail_temp === red_cfg_enum.NO_DIRECTION){
            red_cfg5_wtd_fail_1 = 0
            red_cfg5_wtd_fail_0 = 0
        }else if(red_cfg_wtd_fail_temp === red_cfg_enum.GSW1_FAULTN1){
            red_cfg5_wtd_fail_1 = 0
            red_cfg5_wtd_fail_0 = 1   
        }else if(red_cfg_wtd_fail_temp === red_cfg_enum.GSW2_FAULTN2){
            red_cfg5_wtd_fail_1 = 1
            red_cfg5_wtd_fail_0 = 0   
        }else if(red_cfg_wtd_fail_temp === red_cfg_enum.BOTH){
            red_cfg5_wtd_fail_1 = 1
            red_cfg5_wtd_fail_0 = 1   
        }
     /*                CFG 5 END                              */

     /*                CFG 6 START                              */
        val cfg_6 = settings.l9502_registers.high_voltage_registers.cfg_6 
        val red_cfg_vce_clamp_temp = cfg_6.red_cfg_vce_clamp
        var red_cfg_vce_clamp_1 = 1
        var red_cfg_vce_clamp_0 = 1
        if(red_cfg_vce_clamp_temp === red_cfg_enum.NO_DIRECTION){
            red_cfg_vce_clamp_1 = 0
            red_cfg_vce_clamp_0 = 0
        }else if(red_cfg_vce_clamp_temp === red_cfg_enum.GSW1_FAULTN1){
            red_cfg_vce_clamp_1 = 0
            red_cfg_vce_clamp_0 = 1   
        }else if(red_cfg_vce_clamp_temp === red_cfg_enum.GSW2_FAULTN2){
            red_cfg_vce_clamp_1 = 1
            red_cfg_vce_clamp_0 = 0   
        }else if(red_cfg_vce_clamp_temp === red_cfg_enum.BOTH){
            red_cfg_vce_clamp_1 = 1
            red_cfg_vce_clamp_0 = 1   
        }
        val red_cfg_clk_mon_err_temp = cfg_6.red_cfg_clk_mon_err
        var red_cfg_clk_mon_err_1 = 1
        var red_cfg_clk_mon_err_0 = 1
        if(red_cfg_clk_mon_err_temp === red_cfg_enum.NO_DIRECTION){
            red_cfg_clk_mon_err_1 = 0
            red_cfg_clk_mon_err_0 = 0
        }else if(red_cfg_clk_mon_err_temp === red_cfg_enum.GSW1_FAULTN1){
            red_cfg_clk_mon_err_1 = 0
            red_cfg_clk_mon_err_0 = 1   
        }else if(red_cfg_clk_mon_err_temp === red_cfg_enum.GSW2_FAULTN2){
            red_cfg_clk_mon_err_1 = 1
            red_cfg_clk_mon_err_0 = 0   
        }else if(red_cfg_clk_mon_err_temp === red_cfg_enum.BOTH){
            red_cfg_clk_mon_err_1 = 1
            red_cfg_clk_mon_err_0 = 1   
        }
        val red_cfg_otm_wr_temp = cfg_6.red_cfg_otm_wr
        var red_cfg_otm_wr_1 = 1
        var red_cfg_otm_wr_0 = 1
        if(red_cfg_otm_wr_temp === red_cfg_enum.NO_DIRECTION){
            red_cfg_otm_wr_1 = 0
            red_cfg_otm_wr_0 = 0
        }else if(red_cfg_otm_wr_temp === red_cfg_enum.GSW1_FAULTN1){
            red_cfg_otm_wr_1 = 0
            red_cfg_otm_wr_0 = 1   
        }else if(red_cfg_otm_wr_temp === red_cfg_enum.GSW2_FAULTN2){
            red_cfg_otm_wr_1 = 1
            red_cfg_otm_wr_0 = 0   
        }else if(red_cfg_otm_wr_temp === red_cfg_enum.BOTH){
            red_cfg_otm_wr_1 = 1
            red_cfg_otm_wr_0 = 1   
        }
         red_cfg_srr_fail_temp = cfg_6.red_cfg_srr_fail
         var red_cfg6_srr_fail_1 = 1
         var red_cfg6_srr_fail_0 = 1
        if(red_cfg_srr_fail_temp === red_cfg_enum.NO_DIRECTION){
            red_cfg6_srr_fail_1 = 0
            red_cfg6_srr_fail_0 = 0
        }else if(red_cfg_srr_fail_temp === red_cfg_enum.GSW1_FAULTN1){
            red_cfg6_srr_fail_1 = 0
            red_cfg6_srr_fail_0 = 1   
        }else if(red_cfg_srr_fail_temp === red_cfg_enum.GSW2_FAULTN2){
            red_cfg6_srr_fail_1 = 1
            red_cfg6_srr_fail_0 = 0   
        }else if(red_cfg_srr_fail_temp === red_cfg_enum.BOTH){
            red_cfg6_srr_fail_1 = 1
            red_cfg6_srr_fail_0 = 1   
        }
        val red_cfg_gate_err_temp = cfg_6.red_cfg_gate_err
        var red_cfg_gate_err_1 = 1
        var red_cfg_gate_err_0 = 1
        if(red_cfg_gate_err_temp === red_cfg_enum.NO_DIRECTION){
            red_cfg_gate_err_1 = 0
            red_cfg_gate_err_0 = 0
        }else if(red_cfg_gate_err_temp === red_cfg_enum.GSW1_FAULTN1){
            red_cfg_gate_err_1 = 0
            red_cfg_gate_err_0 = 1   
        }else if(red_cfg_gate_err_temp === red_cfg_enum.GSW2_FAULTN2){
            red_cfg_gate_err_1 = 1
            red_cfg_gate_err_0 = 0   
        }else if(red_cfg_gate_err_temp === red_cfg_enum.BOTH){
            red_cfg_gate_err_1 = 1
            red_cfg_gate_err_0 = 1   
        }
     /*                CFG 6 END                              */
    
     /*                CFG 7 START                              */
        val cfg_7 = settings.l9502_registers.high_voltage_registers.cfg_7 
        val adc_soc_temp = cfg_7.adc_soc
        var adc_soc = 1
        if(adc_soc_temp === adc_soc_enum.BYPASS){
            adc_soc = 0
        }
        val global_latch_clear_temp = cfg_7.global_latch_clear
        var global_latch_clear = 1
        if(global_latch_clear_temp === global_latch_clear_enum.RESET){
            global_latch_clear = 0
        }
     /*                CFG 7 END                              */

     /*                CFG STO START                              */
        val cfg_STO = settings.l9502_registers.high_voltage_registers.sto_cfg 
        val sto_tsto_cfg_temp = cfg_STO.sto_tsto_cfg
        var sto_tsto_cfg_2 = 1
        var sto_tsto_cfg_1 = 1
        var sto_tsto_cfg_0 = 1
        if(sto_tsto_cfg_temp === sto_tsto_cfg_enum.TIME_0US){
             sto_tsto_cfg_2 = 0
             sto_tsto_cfg_1 = 0
             sto_tsto_cfg_0 = 0
        }else if(sto_tsto_cfg_temp === sto_tsto_cfg_enum.TIME_0US4){
             sto_tsto_cfg_2 = 0
             sto_tsto_cfg_1 = 0
             sto_tsto_cfg_0 = 1
        }else if(sto_tsto_cfg_temp === sto_tsto_cfg_enum.TIME_0US5){
             sto_tsto_cfg_2 = 0
             sto_tsto_cfg_1 = 1
             sto_tsto_cfg_0 = 0
        }else if(sto_tsto_cfg_temp === sto_tsto_cfg_enum.TIME_0US6){
             sto_tsto_cfg_2 = 0
             sto_tsto_cfg_1 = 1
             sto_tsto_cfg_0 = 1
        }else if(sto_tsto_cfg_temp === sto_tsto_cfg_enum.TIME_0US7){
             sto_tsto_cfg_2 = 1
             sto_tsto_cfg_1 = 0
             sto_tsto_cfg_0 = 0
        }else if(sto_tsto_cfg_temp === sto_tsto_cfg_enum.TIME_0US8){
             sto_tsto_cfg_2 = 1
             sto_tsto_cfg_1 = 0
             sto_tsto_cfg_0 = 1
        }else if(sto_tsto_cfg_temp === sto_tsto_cfg_enum.TIME_1US7){
             sto_tsto_cfg_2 = 1
             sto_tsto_cfg_1 = 1
             sto_tsto_cfg_0 = 0
        }else if(sto_tsto_cfg_temp === sto_tsto_cfg_enum.TIME_2US3){
             sto_tsto_cfg_2 = 1
             sto_tsto_cfg_1 = 1
             sto_tsto_cfg_0 = 1
        }
        val sto_t2lto_cfg_temp = cfg_STO.sto_t2lto_cfg
        var sto_t2lto_cfg_2 = 1
        var sto_t2lto_cfg_1 = 1
        var sto_t2lto_cfg_0 = 1
        if(sto_t2lto_cfg_temp === sto_tsto_cfg_enum.TIME_0US){
             sto_t2lto_cfg_2 = 0
             sto_t2lto_cfg_1 = 0
             sto_t2lto_cfg_0 = 0
        }else if(sto_t2lto_cfg_temp === sto_tsto_cfg_enum.TIME_0US4){
             sto_t2lto_cfg_2 = 0
             sto_t2lto_cfg_1 = 0
             sto_t2lto_cfg_0 = 1
        }else if(sto_t2lto_cfg_temp === sto_tsto_cfg_enum.TIME_0US5){
             sto_t2lto_cfg_2 = 0
             sto_t2lto_cfg_1 = 1
             sto_t2lto_cfg_0 = 0
        }else if(sto_t2lto_cfg_temp === sto_tsto_cfg_enum.TIME_0US6){
             sto_t2lto_cfg_2 = 0
             sto_t2lto_cfg_1 = 1
             sto_t2lto_cfg_0 = 1
        }else if(sto_t2lto_cfg_temp === sto_tsto_cfg_enum.TIME_0US7){
             sto_t2lto_cfg_2 = 1
             sto_t2lto_cfg_1 = 0
             sto_t2lto_cfg_0 = 0
        }else if(sto_t2lto_cfg_temp === sto_tsto_cfg_enum.TIME_0US8){
             sto_t2lto_cfg_2 = 1
             sto_t2lto_cfg_1 = 0
             sto_t2lto_cfg_0 = 1
        }else if(sto_t2lto_cfg_temp === sto_tsto_cfg_enum.TIME_1US7){
             sto_t2lto_cfg_2 = 1
             sto_t2lto_cfg_1 = 1
             sto_t2lto_cfg_0 = 0
        }else if(sto_t2lto_cfg_temp === sto_tsto_cfg_enum.TIME_2US3){
             sto_t2lto_cfg_2 = 1
             sto_t2lto_cfg_1 = 1
             sto_t2lto_cfg_0 = 1
        }
        val sto_vth_cfg_temp = cfg_STO.sto_vth_cfg
        var sto_vth_cfg_2 = 1
        var sto_vth_cfg_1 = 1
        var sto_vth_cfg_0 = 1
        if(sto_vth_cfg_temp === sto_vth_cfg_enum.VSTO_7V5){
             sto_vth_cfg_2 = 0
             sto_vth_cfg_1 = 0
             sto_vth_cfg_0 = 0
        }else if(sto_vth_cfg_temp === sto_vth_cfg_enum.VSTO_8V5){
             sto_vth_cfg_2 = 0
             sto_vth_cfg_1 = 0
             sto_vth_cfg_0 = 1
        }else if(sto_vth_cfg_temp === sto_vth_cfg_enum.VSTO_9V5){
             sto_vth_cfg_2 = 0
             sto_vth_cfg_1 = 1
             sto_vth_cfg_0 = 0
        }else if(sto_vth_cfg_temp === sto_vth_cfg_enum.VSTO_10V5){
             sto_vth_cfg_2 = 0
             sto_vth_cfg_1 = 1
             sto_vth_cfg_0 = 1
        }else if(sto_vth_cfg_temp === sto_vth_cfg_enum.VSTO_11V5){
             sto_vth_cfg_2 = 1
             sto_vth_cfg_1 = 0
             sto_vth_cfg_0 = 0
        }else if(sto_vth_cfg_temp === sto_vth_cfg_enum.VSTO_12V5){
             sto_vth_cfg_2 = 1
             sto_vth_cfg_1 = 0
             sto_vth_cfg_0 = 1
        }else if(sto_vth_cfg_temp === sto_vth_cfg_enum.VSTO_13V5){
             sto_vth_cfg_2 = 1
             sto_vth_cfg_1 = 1
             sto_vth_cfg_0 = 0
        }else if(sto_vth_cfg_temp === sto_vth_cfg_enum.VSTO_14V5){
             sto_vth_cfg_2 = 1
             sto_vth_cfg_1 = 1
             sto_vth_cfg_0 = 1
        }
     /*                CFG STO END                              */

     /*                CFG CFG10_PAGE1 START                              */
        val cfg_10_page_1 = settings.l9502_registers.paging_registers.cfg_10.page_1 
        val dis_re_engagement_temp = cfg_10_page_1.dis_re_engagement
        var dis_re_engagement = 1
        if(dis_re_engagement_temp === dis_re_engagement_enum.NORMAL){
            dis_re_engagement = 0
        }
        var tsen_thr_temp = cfg_10_page_1.tsen_thr
        var temp = 0
        var temp1 = 0
        if(dis_re_engagement === 1){
            temp = 128 + tsen_thr_temp
        }else{
            temp = tsen_thr_temp  
        }
        temp1 = temp/16
     /*                CFG STO END                              */

     /*                CFG CFG10_PAGE2 START                              */
        val cfg_10_page_2 = settings.l9502_registers.paging_registers.cfg_10.page_2 
        val adc_out_sel_temp = cfg_10_page_2.adc_out_sel
        var adc_out_sel_2 = 1
        var adc_out_sel_1 = 1
        var adc_out_sel_0 = 1
        if(adc_out_sel_temp === adc_out_sel_enum.VH){
            adc_out_sel_2 = 0
            adc_out_sel_1 = 0
            adc_out_sel_0 = 0
        }else if(adc_out_sel_temp === adc_out_sel_enum.VL){
            adc_out_sel_2 = 0
            adc_out_sel_1 = 0
            adc_out_sel_0 = 1
        }else if(adc_out_sel_temp === adc_out_sel_enum.AIN){
            adc_out_sel_2 = 0
            adc_out_sel_1 = 1
            adc_out_sel_0 = 0 
        }else if(adc_out_sel_temp === adc_out_sel_enum.TSEN){
            adc_out_sel_2 = 0
            adc_out_sel_1 = 1
            adc_out_sel_0 = 1 
        }else if(adc_out_sel_temp === adc_out_sel_enum.TJ){
            adc_out_sel_2 = 1
            adc_out_sel_1 = 0
            adc_out_sel_0 = 0 
        }else if(adc_out_sel_temp === adc_out_sel_enum.REDUNDANT_BANDGAP){
            adc_out_sel_2 = 1
            adc_out_sel_1 = 0
            adc_out_sel_0 = 1 
        }else if(adc_out_sel_temp === adc_out_sel_enum.MILLER_CLAMP){
            adc_out_sel_2 = 1
            adc_out_sel_1 = 1
            adc_out_sel_0 = 0 
        }else if(adc_out_sel_temp === adc_out_sel_enum.VGSTH){
            adc_out_sel_2 = 1
            adc_out_sel_1 = 1
            adc_out_sel_0 = 1 
        }
     /*                CFG CFG10_PAGE2 END                              */

     /*                CFG CFG10_PAGE3 START                              */
        val cfg_10_page_3 = settings.l9502_registers.paging_registers.cfg_10.page_3 
        val vh_ov_thr_temp = cfg_10_page_3.vh_ov_thr
        val vh_uv_thr_temp = cfg_10_page_3.vh_uv_thr
        val vh_ov_thr = vh_ov_thr_temp - 15
        val vh_uv_thr = vh_uv_thr_temp - 6
     /*                CFG CFG10_PAGE3 END                              */

     /*                CFG CFG11_PAGE1 START                              */
        val cfg_11_page_1 = settings.l9502_registers.paging_registers.cfg_11.page_1 
        val drv_capability_temp = cfg_11_page_1.drv_capability
        var drv_capability_1 = 1
        var drv_capability_0 = 1
        if(drv_capability_temp === drv_capability_enum.FULL_DEFAULT){
            drv_capability_1 = 0
            drv_capability_0 = 0
        }else if(drv_capability_temp === drv_capability_enum.MID){
            drv_capability_1 = 0
            drv_capability_0 = 1
        }else if(drv_capability_temp === drv_capability_enum.LOW){
            drv_capability_1 = 1
            drv_capability_0 = 0 
        }else if(drv_capability_temp === drv_capability_enum.VERYLOW){
            drv_capability_1 = 1
            drv_capability_0 = 1 
        }
        val vgs_th_pu_en_temp = cfg_11_page_1.vgs_th_pu_en
        var vgs_th_pu_en = 1
        if(vgs_th_pu_en_temp === en_enum.DISABLED){
            vgs_th_pu_en = 0
        }
        val vgs_th_meas_temp = cfg_11_page_1.vgs_th_meas
        var vgs_th_meas = 1
        if(vgs_th_meas_temp === en_enum.DISABLED){
            vgs_th_meas = 0
        }
        val hto_double_check_dis_temp = cfg_11_page_1.hto_double_check_dis
        var hto_double_check_dis = 1
        if(hto_double_check_dis_temp === en_enum.ENABLED){
            hto_double_check_dis = 0
        }
        val sto_i_2lto_temp = cfg_11_page_1.sto_i_2lto
        var sto_i_2lto_2 = 1
        var sto_i_2lto_1 = 1
        var sto_i_2lto_0 = 1
        if(sto_i_2lto_temp ===  sto_i_cfg_enum.ISTO_68_0M_A){
            sto_i_2lto_2 = 0
            sto_i_2lto_1 = 0
            sto_i_2lto_0 = 0
        }else if(sto_i_2lto_temp ===  sto_i_cfg_enum.ISTO_92_0M_A){
            sto_i_2lto_2 = 0
            sto_i_2lto_1 = 0
            sto_i_2lto_0 = 1
        }else if(sto_i_2lto_temp ===  sto_i_cfg_enum.ISTO_124_0M_A){
            sto_i_2lto_2 = 0
            sto_i_2lto_1 = 1
            sto_i_2lto_0 = 0
        }else if(sto_i_2lto_temp ===  sto_i_cfg_enum.ISTO_156_0M_A){
            sto_i_2lto_2 = 0
            sto_i_2lto_1 = 1
            sto_i_2lto_0 = 1
        }else if(sto_i_2lto_temp ===  sto_i_cfg_enum.ISTO_188_0M_A){
            sto_i_2lto_2 = 1
            sto_i_2lto_1 = 0
            sto_i_2lto_0 = 0
        }else if(sto_i_2lto_temp ===  sto_i_cfg_enum.ISTO_220_0M_A){
            sto_i_2lto_2 = 1
            sto_i_2lto_1 = 0
            sto_i_2lto_0 = 1
        }else if(sto_i_2lto_temp ===  sto_i_cfg_enum.ISTO_252_0M_A){
            sto_i_2lto_2 = 1
            sto_i_2lto_1 = 1
            sto_i_2lto_0 = 0
        }else if(sto_i_2lto_temp ===  sto_i_cfg_enum.ISTO_284_0M_A){
            sto_i_2lto_2 = 1
            sto_i_2lto_1 = 1
            sto_i_2lto_0 = 1
        }
     /*                CFG CFG11_PAGE1 END                               */

     /*                CFG CFG11_PAGE2 START                              */
        val cfg_11_page_2 = settings.l9502_registers.paging_registers.cfg_11.page_2 
        val brake_priority_temp = cfg_11_page_2.brake_priority
        var brake_priority = 1
        if(brake_priority_temp === brake_priority_enum.STD_PRIORITY){
            brake_priority = 0
        }
        val vh_uv_priority_temp = cfg_11_page_2.vh_uv_priority
        var vh_uv_priority = 1
        if(vh_uv_priority_temp === vh_uv_priority_enum.HV_DIE_GROUP_1){
            vh_uv_priority = 0
        }
        val vh_uv_fail_inj_temp = cfg_11_page_2.vh_uv_fail_inj
        var vh_uv_fail_inj = 1
        if(vh_uv_fail_inj_temp === vh_uv_fail_inj_enum.IDLE){
            vh_uv_fail_inj = 0
        }
        val adc_vtref_select_temp = cfg_11_page_2.adc_vtref_select
        var adc_vtref_select = 1
        if(adc_vtref_select_temp === adc_vtref_select_enum.VTREF_5V){
            adc_vtref_select = 0
        }
        val adc_ain_tsen_pd_en_temp = cfg_11_page_2.adc_ain_tsen_pd_en
        var adc_ain_tsen_pd_en = 1
        if(adc_ain_tsen_pd_en_temp === en_enum.DISABLED){
            adc_ain_tsen_pd_en = 0
        }
        val vge_filt_cfg_temp = cfg_11_page_2.vge_filt_cfg
        var vge_filt_cfg_2 = 1
        var vge_filt_cfg_1 = 1
        var vge_filt_cfg_0 = 1
        if(vge_filt_cfg_temp ===  vge_filt_cfg_enum.TFIL_40_0NS){
            vge_filt_cfg_2 = 0
            vge_filt_cfg_1 = 0
            vge_filt_cfg_0 = 0
        }else if(vge_filt_cfg_temp ===  vge_filt_cfg_enum.TFIL_60_0NS){
            vge_filt_cfg_2 = 0
            vge_filt_cfg_1 = 0
            vge_filt_cfg_0 = 1
        }else if(vge_filt_cfg_temp ===  vge_filt_cfg_enum.TFIL_80_0NS){
            vge_filt_cfg_2 = 0
            vge_filt_cfg_1 = 1
            vge_filt_cfg_0 = 0
        }else if(vge_filt_cfg_temp ===  vge_filt_cfg_enum.TFIL_120_0NS){
            vge_filt_cfg_2 = 0
            vge_filt_cfg_1 = 1
            vge_filt_cfg_0 = 1  
        }else if(vge_filt_cfg_temp ===  vge_filt_cfg_enum.TFIL_160_0NS){
            vge_filt_cfg_2 = 1
            vge_filt_cfg_1 = 0
            vge_filt_cfg_0 = 0
        }else if(vge_filt_cfg_temp ===  vge_filt_cfg_enum.TFIL_240_0NS){
            vge_filt_cfg_2 = 1
            vge_filt_cfg_1 = 0
            vge_filt_cfg_0 = 1
        }else if(vge_filt_cfg_temp ===  vge_filt_cfg_enum.TFIL_280_0NS){
            vge_filt_cfg_2 = 1
            vge_filt_cfg_1 = 1
            vge_filt_cfg_0 = 0
        }else if(vge_filt_cfg_temp ===  vge_filt_cfg_enum.TFIL_320_0NS){
            vge_filt_cfg_2 = 1
            vge_filt_cfg_1 = 1
            vge_filt_cfg_0 = 1
        }
     /*                CFG CFG11_PAGE2 END                               */

     /*                CFG CFG11_PAGE3 START                              */
        val cfg_11_page_3 = settings.l9502_registers.paging_registers.cfg_11.page_3 
        symmetric_delay_temp = cfg_11_page_3.symmetric_delay
        var cfg11_symmetric_delay = 1
        if(symmetric_delay_temp === symmetric_delay_enum.ASYMMETRIC){
            cfg11_symmetric_delay = 0
        }
        val isen_ovc_th_temp = cfg_11_page_3.isen_ovc_th
        var isen_ovc_th_2 = 1
        var isen_ovc_th_1 = 1
        var isen_ovc_th_0 = 1
        if(isen_ovc_th_temp ===  sense_th_cfg_enum.VISEN_TH_20_0M_V){
            isen_ovc_th_2 = 0
            isen_ovc_th_1 = 0
            isen_ovc_th_0 = 0
        }else if(isen_ovc_th_temp ===  sense_th_cfg_enum.VISEN_TH_25_0M_V){
            isen_ovc_th_2 = 0
            isen_ovc_th_1 = 0
            isen_ovc_th_0 = 1
        }else if(isen_ovc_th_temp ===  sense_th_cfg_enum.VISEN_TH_30_0M_V){
            isen_ovc_th_2 = 0
            isen_ovc_th_1 = 1
            isen_ovc_th_0 = 0
        }else if(isen_ovc_th_temp ===  sense_th_cfg_enum.VISEN_TH_35_0M_V){
            isen_ovc_th_2 = 0
            isen_ovc_th_1 = 1
            isen_ovc_th_0 = 1
        }else if(isen_ovc_th_temp ===  sense_th_cfg_enum.VISEN_TH_40_0M_V){
            isen_ovc_th_2 = 1
            isen_ovc_th_1 = 0
            isen_ovc_th_0 = 0
        }else if(isen_ovc_th_temp ===  sense_th_cfg_enum.VISEN_TH_45_0M_V){
            isen_ovc_th_2 = 1
            isen_ovc_th_1 = 0
            isen_ovc_th_0 = 1
        }else if(isen_ovc_th_temp ===  sense_th_cfg_enum.VISEN_TH_50_0M_V){
            isen_ovc_th_2 = 1
            isen_ovc_th_1 = 1
            isen_ovc_th_0 = 0
        }else if(isen_ovc_th_temp ===  sense_th_cfg_enum.VISEN_TH_55_0M_V){
            isen_ovc_th_2 = 1
            isen_ovc_th_1 = 1
            isen_ovc_th_0 = 1
        }
        val shoot_en_temp = cfg_11_page_3.shoot_en
        var shoot_en = 1
        if(shoot_en_temp === en_enum.DISABLED){
            shoot_en = 0
        }
        val shoot_dly_temp = cfg_11_page_3.shoot_dly
        var shoot_dly_2 = 1
        var shoot_dly_1 = 1
        var shoot_dly_0 = 1
        
        if(shoot_dly_temp ===  shoot_dly_enum.T0NS){
            shoot_dly_2 = 0
            shoot_dly_1 = 0
            shoot_dly_0 = 0
        }else if(shoot_dly_temp ===  shoot_dly_enum.T20NS){
            shoot_dly_2 = 0
            shoot_dly_1 = 0
            shoot_dly_0 = 1
        }else if(shoot_dly_temp ===  shoot_dly_enum.T40NS){
            shoot_dly_2 = 0
            shoot_dly_1 = 1
            shoot_dly_0 = 0
        }else if(shoot_dly_temp ===  shoot_dly_enum.T60NS){
            shoot_dly_2 = 0
            shoot_dly_1 = 1
            shoot_dly_0 = 1
        }else if(shoot_dly_temp ===  shoot_dly_enum.T80NS){
            shoot_dly_2 = 1
            shoot_dly_1 = 0
            shoot_dly_0 = 0
        }else if(shoot_dly_temp ===  shoot_dly_enum.T10_0NS){
            shoot_dly_2 = 1
            shoot_dly_1 = 0
            shoot_dly_0 = 1
        }else if(shoot_dly_temp ===  shoot_dly_enum.T12_0NS){
            shoot_dly_2 = 1
            shoot_dly_1 = 1
            shoot_dly_0 = 0
        }else if(shoot_dly_temp ===  shoot_dly_enum.T14_0NS){
            shoot_dly_2 = 1
            shoot_dly_1 = 1
            shoot_dly_0 = 1
        }
     /*                CFG CFG11_PAGE3 END                              */
    
	 /*                REG VAR START                              */ 
	 val cfg_8_b_2  = nibble(0,0,srr_parity,0);
	 val cfg_8_b_1  = nibble(wtd_react_cfg,0,faultn2_adc_cfg,in_m_dis)
	 val cfg_8_b_0  = nibble(fault1_force, fault2_force, fly_en, fly_ovc_react_cfg) 
	   
	 val cfg_9_b_2  = nibble(0,0,dtp_cfg_2, dtp_cfg_1)
	 val cfg_9_b_1  = nibble(dtp_cfg_0, cfg9_symmetric_delay, red_cfg9_wtd_fail_1, red_cfg9_wtd_fail_0)
	 val cfg_9_b_0  = nibble(red_cfg9_srr_fail_1, red_cfg9_srr_fail_0, red_cfg_fly_ovc_1, red_cfg_fly_ovc_0)
	   
	 val cfg_0_b_2  = nibble(0,0,cfg0_safe_sel,desat_en)
	 val cfg_0_b_1  = nibble(sense_en, vh_ov_en, vh_uv_en, vl1_cfg)
	 val cfg_0_b_0  = nibble(vl0_cfg,0,0,0)
	   
	 val cfg_1_b_2  = nibble(0,0,tsen_ot_react_cfg, desat_react_cfg)
	 val cfg_1_b_1  = nibble(sense_react_cfg, vh_uv_react_cfg, vh_ov_react_cfg, vl_uv_react_cfg)
	 val cfg_1_b_0  = nibble(vl_ov_react_cfg,0,0,0)
	   
	 val cfg_2_b_2  = nibble(0,0,wtd_react_cfg_1, wtd_react_cfg_0)
	 val cfg_2_b_1  = nibble(desat_current_cfg_1, desat_current_cfg_0, desat_th_cfg_2, desat_th_cfg_1)
	 val cfg_2_b_0  = nibble(desat_th_cfg_0, sense_th_cfg_2, sense_th_cfg_1, sense_th_cfg_0)
	   
	 val cfg_3_b_2  = nibble(0,0,desat_blk_2, desat_blk_1)
	 val cfg_3_b_1  = nibble(desat_blk_0, vgemon_react_cfg_1, vgemon_react_cfg_0, tsen_curr_cfg_1)
	 val cfg_3_b_0  = nibble(tsen_curr_cfg_0, sto_i_cfg_2, sto_i_cfg_1, sto_i_cfg_0)
	   
	 val cfg_4_b_2  = nibble(0,0,red_cfg_tsen_1, red_cfg_tsen_0)
	 val cfg_4_b_1  = nibble(red_cfg_desat_1, red_cfg_desat_0, red_cfg_sense_1, red_cfg_sense_0)
	 val cfg_4_b_0  = nibble(red_cfg_vh_ov_1, red_cfg_vh_ov_0, red_cfg_vh_uv_1, red_cfg_vh_uv_0)
	   
	 val cfg_5_b_2  = nibble(0,0,abist_en, mc_dis)
	 val cfg_5_b_1  = nibble(red_cfg_vl_ov_1, red_cfg_vl_ov_0, red_cfg_vl_uv_1, red_cfg_vl_uv_0)
	 val cfg_5_b_0  = nibble(red_cfg_otm_sd_1, red_cfg_otm_sd_0, red_cfg5_wtd_fail_1, red_cfg5_wtd_fail_0)
	   
	 val cfg_6_b_2  = nibble(0,0,red_cfg_vce_clamp_1, red_cfg_vce_clamp_0)
	 val cfg_6_b_1  = nibble(red_cfg_clk_mon_err_1, red_cfg_clk_mon_err_0, red_cfg_otm_wr_1, red_cfg_otm_wr_0)
	 val cfg_6_b_0  = nibble(red_cfg6_srr_fail_1, red_cfg6_srr_fail_0, red_cfg_gate_err_1, red_cfg_gate_err_0)
	   
	 val cfg_7_b_2  = nibble(0,0,0,0)
	 val cfg_7_b_1  = nibble(adc_soc,0,0,0)
	 val cfg_7_b_0  = nibble(0,0,global_latch_clear,0)
	 
	 val cfg_sto_b_2 = nibble(0,0,0,sto_tsto_cfg_2)
	 val cfg_sto_b_1 = nibble(sto_tsto_cfg_1, sto_tsto_cfg_0, sto_t2lto_cfg_2, sto_t2lto_cfg_1)
	 val cfg_sto_b_0 = nibble(sto_t2lto_cfg_0, sto_vth_cfg_2, sto_vth_cfg_1, sto_vth_cfg_0)
     /*                REG VAR START                               */ 
     '''
      /****************************************************************************
      *
      * Copyright (c) 2023 STMicroelectronics - All Rights Reserved
      *
      * License terms: STMicroelectronics Proprietary in accordance with licensing
      * terms SLA0098 at www.st.com.
      *
      * THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
      * INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
      *****************************************************************************/      
      /*
      *   @file    L9502_cfg.h
      *   @version M4_VERSION
      *   @brief   L9502 configuration macros
      *          
      *   @details L9502 configuration macros.
      *
      */
      
      #ifndef __L9502_CFG_H__
      #define __L9502_CFG_H__
      
      #ifdef __cplusplus
      extern "C"{
      #endif
      
      /*==================================================================================================
      *                                        INCLUDE FILES
      * 1) system and project includes
      * 2) needed interfaces from external units
      * 3) internal and external interfaces from this unit
      ==================================================================================================*/
      
      /*==================================================================================================
      *                                          CONSTANTS
      ==================================================================================================*/
      
      /**** THIS IS THE ACTIVE CONFIGURATION ****/
      #define VERSION_«version»
      
      «IF(version===Ip_version_enum.AA)»
      #define L9502_SOFT_START_SW         /* Only Soft Start Up Mode is available on CUT AA */
      «ELSE»
      «IF(enable)»
      #define L9502_SOFT_START_SW         /* Enable Soft Start Up for Cut BA/CA/CD */
      «ELSE»
      /* #define L9502_SOFT_START_SW */   /* Disable Soft Start Up for Cut BA/CA/CD */
      «ENDIF»
      «ENDIF»
      
      /* Test Mode is not available on this FW */
      «IF(test_mode)»
      #define TEST_MODE       1 /* if enabled, L9502 is switched into test mode and SPI frames are used */
      «ELSE»
      #define TEST_MODE       0 /* if enabled, L9502 is switched into test mode and SPI frames are used */ 
      «ENDIF»
      
      /*==================================================================================================
      *                                      DEFINES AND MACROS
      ==================================================================================================*/
      
      
      /* Number of Devices connected in Daisy Chain */
      #define L9502_DEVICE_NUM            «num_devices»
      
      /* Chip ID value on Low Voltage Side */
      #define CHIP_ID_LV_VALUE            (0x«hex_chip_MSBs»«hex_chip_LSBs»U)
      
      /* Low Voltage Side Configuration Registers */ 
      «IF(version===Ip_version_enum.BA || version===Ip_version_enum.CA || version===Ip_version_enum.CD)»
      #define   L9502_VALUE_CFG_8         (0x«cfg_8_b_2»«cfg_8_b_1»«cfg_8_b_0»U) /* 0b00«srr_parity»«cfg8_safe_sel» «wtd_react_cfg»0«faultn2_adc_cfg»«in_m_dis» «fault1_force»«fault2_force»«fly_en»«fly_ovc_react_cfg» */
      
      #define   L9502_VALUE_CFG_9         (0x«cfg_9_b_2»«cfg_9_b_1»«cfg_9_b_0»U) /* 0b00«dtp_cfg_2»«dtp_cfg_1» «dtp_cfg_0»«cfg9_symmetric_delay»«red_cfg9_wtd_fail_1»«red_cfg9_wtd_fail_0» «red_cfg9_srr_fail_1»«red_cfg9_srr_fail_0»«red_cfg_fly_ovc_1»«red_cfg_fly_ovc_0» */
      
      /* High Voltage Side Configuration Registers*/
      #define   L9502_VALUE_CFG_0         (0x«cfg_0_b_2»«cfg_0_b_1»«cfg_0_b_0»U)  /* 0b00«cfg0_safe_sel»«desat_en» «sense_en»«vh_ov_en»«vh_uv_en»«vl1_cfg» «vl0_cfg»000 */
      
      #define   L9502_VALUE_CFG_1         (0x«cfg_1_b_2»«cfg_1_b_1»«cfg_1_b_0»U)  /* 0b00«tsen_ot_react_cfg»«desat_react_cfg» «sense_react_cfg»«vh_uv_react_cfg»«vh_ov_react_cfg»«vl_uv_react_cfg» «vl_ov_react_cfg»000 */
      
      #define   L9502_VALUE_CFG_2         (0x«cfg_2_b_2»«cfg_2_b_1»«cfg_2_b_0»U)  /* 0b00«wtd_react_cfg_1»«wtd_react_cfg_0» «desat_current_cfg_1»«desat_current_cfg_0»«desat_th_cfg_2»«desat_th_cfg_1» «desat_th_cfg_0»«sense_th_cfg_2»«sense_th_cfg_1»«sense_th_cfg_0» */
      
      #define   L9502_VALUE_CFG_3         (0x«cfg_3_b_2»«cfg_3_b_1»«cfg_3_b_0»U)  /* 0b00«desat_blk_2»«desat_blk_1» «desat_blk_0»«vgemon_react_cfg_1»«vgemon_react_cfg_0»«tsen_curr_cfg_1» «tsen_curr_cfg_0»«sto_i_cfg_2»«sto_i_cfg_1»«sto_i_cfg_0» */
      
      #define   L9502_VALUE_CFG_4         (0x«cfg_4_b_2»«cfg_4_b_1»«cfg_4_b_0»U)  /* 0b00«red_cfg_tsen_1»«red_cfg_tsen_0» «red_cfg_desat_1»«red_cfg_desat_0»«red_cfg_sense_1»«red_cfg_sense_0» «red_cfg_vh_ov_1»«red_cfg_vh_ov_0»«red_cfg_vh_uv_1»«red_cfg_vh_uv_0» */
      
      #define   L9502_VALUE_CFG_5         (0x«cfg_5_b_2»«cfg_5_b_1»«cfg_5_b_0»U)  /* 0b00«abist_en»«mc_dis» «red_cfg_vl_ov_1»«red_cfg_vl_ov_0»«red_cfg_vl_uv_1»«red_cfg_vl_uv_0» «red_cfg_otm_sd_1»«red_cfg_otm_sd_0»«red_cfg5_wtd_fail_1»«red_cfg5_wtd_fail_0» */
      
      #define   L9502_VALUE_CFG_6         (0x«cfg_6_b_2»«cfg_6_b_1»«cfg_6_b_0»U)  /* 0b00«red_cfg_vce_clamp_1»«red_cfg_vce_clamp_0» «red_cfg_clk_mon_err_1»«red_cfg_clk_mon_err_0»«red_cfg_otm_wr_1»«red_cfg_otm_wr_0» «red_cfg6_srr_fail_1»«red_cfg6_srr_fail_0»«red_cfg_gate_err_1»«red_cfg_gate_err_0» */
      
      #define   L9502_VALUE_CFG_7         (0x«cfg_7_b_2»«cfg_7_b_1»«cfg_7_b_0»U)  /* 0b0000 «adc_soc»000 00«global_latch_clear»0 */
      
      /* Paging Registers: Most significant Nibble represent page number [1/2/3] */
      
      #define   L9502_VALUE_CFG_10_P1     (0x1«int2hex(temp1)»«int2hex(temp%16)»U)   /* Re Engagement procedure: «dis_re_engagement_temp» */
      
      #define   L9502_VALUE_CFG_10_P2     (0x20«nibble(0,adc_out_sel_2,adc_out_sel_1,adc_out_sel_0)»U)
      
      #define   L9502_VALUE_CFG_10_P3     (0x3«int2hex(vh_ov_thr)»«int2hex(vh_uv_thr)»U)
      
      #define   L9502_VALUE_CFG_11_P1     (0x1«nibble(drv_capability_1,drv_capability_0,vgs_th_pu_en,vgs_th_meas)»«nibble(hto_double_check_dis,sto_i_2lto_2,sto_i_2lto_1,sto_i_2lto_0)»U)
      
      #define   L9502_VALUE_CFG_11_P2     (0x2«nibble(brake_priority,vh_uv_priority,vh_uv_fail_inj,adc_vtref_select)»«nibble(adc_ain_tsen_pd_en,vge_filt_cfg_2,vge_filt_cfg_1,vge_filt_cfg_0)»U)
      
      #define   L9502_VALUE_CFG_11_P3     (0x3«nibble(cfg11_symmetric_delay,isen_ovc_th_2,isen_ovc_th_1,isen_ovc_th_0)»«nibble(shoot_en,shoot_dly_2,shoot_dly_1,shoot_dly_0)»U)
      
      /* Soft Turn Off Configuration Register */
      
      #define   L9502_VALUE_STO_CFG      (0x«cfg_sto_b_2»«cfg_sto_b_1»«cfg_sto_b_0»U) /* 0b000«sto_tsto_cfg_2» «sto_tsto_cfg_1»«sto_tsto_cfg_0»«sto_t2lto_cfg_2»«sto_t2lto_cfg_1» «sto_t2lto_cfg_0»«sto_vth_cfg_2»«sto_vth_cfg_1»«sto_vth_cfg_0» */
      
      /* Low  Voltage Diagnostic Registers (default value) */
      #define   L9502_VALUE_FHM_2         (0x007U)
      #define   L9502_VALUE_FHM_3         (0x000U)
      
      /* High Voltage Diagnostic Registers (default value) */
      #define   L9502_VALUE_FHM_0         (0x1FFU)
      #define   L9502_VALUE_FHM_1         (0x01FU)
      
      «ELSE»
      /**** STATIC CONFIGURATION FOR CUT AA:
       *   (Config registers cannot be changed by graphical Interface) ****/
      
      /* Low  Voltage Diagnostic Registers (default value) */
      #define   L9502_VALUE_FHM_2         (0x007U)
      #define   L9502_VALUE_FHM_3         (0x000U)
      
      /* High Voltage Diagnostic Registers (default value) */
      #define   L9502_VALUE_FHM_0         (0x1FFU)
      #define   L9502_VALUE_FHM_1         (0x01FU)
      «ENDIF»
      
      #ifdef __cplusplus
      }
      #endif
      
      #endif /* __L9502_CFG_H__ */
      
     '''
 }
   
    def String generateL9502Code(Component comp){
		
		val settings = (comp as Gd_9502)
		val num_devices = settings.number_of_devices

		'''
		/****************************************************************************
		*
		* Copyright (c) 2023 STMicroelectronics - All Rights Reserved
		*
		* License terms: STMicroelectronics Proprietary in accordance with licensing
		* terms SLA0098 at www.st.com.
		*
		* THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
		* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
		*****************************************************************************/
		/**
		*   @file    L9502_cfg.c
		*   @version M4_VERSION
		*   @brief   L9502 configuration file
		*
		*
 		*/
		#include "typedefs.h"
		#include "L9502_cfg.h"
		#include "L9502.h"

		L9502DeviceParams_t L9502DeviceParams =
		{
		L9502_VALUE_CFG_8,
		L9502_VALUE_CFG_9,
		L9502_VALUE_CFG_0,
		L9502_VALUE_CFG_1,
		L9502_VALUE_CFG_2,
		L9502_VALUE_CFG_3,
		L9502_VALUE_CFG_4,
		L9502_VALUE_CFG_5,
		L9502_VALUE_CFG_6,
		L9502_VALUE_CFG_7
		#if defined(VERSION_BA) || defined(VERSION_CA) || defined(VERSION_CD)
		,L9502_VALUE_CFG_10_P1,
		L9502_VALUE_CFG_10_P2,
		L9502_VALUE_CFG_10_P3,
		L9502_VALUE_CFG_11_P1,
		L9502_VALUE_CFG_11_P2,
		L9502_VALUE_CFG_11_P3,
		L9502_VALUE_STO_CFG
		#endif
		};

		L9502Params_t L9502Config =
		{
		L9502_DEVICE_NUM,
		{
		«IF(num_devices>6)»
			&L9502DeviceParams,
		«ENDIF»
		«IF(num_devices>5)»
			&L9502DeviceParams,
		«ENDIF»
		«IF(num_devices>4)»
			&L9502DeviceParams,
		«ENDIF»
		«IF(num_devices>3)»
			&L9502DeviceParams,
		«ENDIF»
		«IF(num_devices>2)»
			&L9502DeviceParams,
		«ENDIF»
		«IF(num_devices>1)»
			&L9502DeviceParams,
		«ENDIF»
		&L9502DeviceParams
		}
		};
		'''
	}
	
    def String nibble (int a, int b, int c, int d){
	 if ( ((a<0) || (a>1)) || ((b<0) || (b>1) ) || ((c<0) || (c>1) ) || ((d<0) || (d>1)) )
	 /*[#function nibble a,b,c,d]
	 [#stop "nibble: operand must be a binary number («a»,«b»,«c»,«d»)"]*/
	 return 'X'
	 else{
		var x1 = (8*a) + (4*b) + (2*c) + d
		if(x1 == 10){
			return 'A'
		}else if(x1 == 11){
			return 'B'
		}else if(x1 == 12){
			return 'C'
		}else if(x1 == 13){
			return 'D'
		}else if(x1 == 14){
			return 'E'
		}else if(x1 == 15){
			return 'F'
		}else if(x1 == 0){
			return '0'
		}else if(x1 == 1){
			return '1'
		}else if(x1 == 2){
			return '2'
		}else if(x1 == 3){
			return '3'
		}else if(x1 == 4){
			return '4'
		}else if(x1 == 5){
			return '5'
		}else if(x1 == 6){
			return '6'
		}else if(x1 == 7){
			return '7'
		}else if(x1 == 8){
			return '8'
		}else if(x1 == 9){
			return '9'
		}
	  }
	}
	
	def String int2hex (int x1){
	   if(x1 == 10){
	   	return 'A'
	   }else if(x1 == 11){
	   	return 'B'
	   }else if(x1 == 12){
	   	return 'C'
	   }else if(x1 == 13){
	   	return 'D'
	   }else if(x1 == 14){
	   	return 'E'
	   }else if(x1 == 15){
	   	return 'F'
	   }else{
	   	return x1.toString
	   }
	 }
}