/**
 ******************************************************************************
 * @file    stellar_pg.ld
 * @author  MDRF Automotive division
 * @brief   Default script file based from StellarSDK
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; Copyright (c) 2023,2024 STMicroelectronics.
 * All rights reserved.</center></h2>
 *
 * This software is licensed under terms that can be found in the LICENSE file in
 * the root directory of this software component.
 * If no LICENSE file comes with this software, it is provided AS-IS.
 *
 ******************************************************************************
 */

ENTRY(el2_reset_handler_core)

/* Memories definition for sr6p7 from SDK sr6p7\memory_map.h file */
MEMORY
{
    RAM	        (xrw) : ORIGIN = 0x60000000, LENGTH = 512k  /* cluster0_core0_local_ram */
    FLASH	    (xr)  : ORIGIN = 0x28000000, LENGTH = 3840k /* cluster0_core0_local_nvm */
	BOOT_RECORD (xr)  : ORIGIN = 0x29f87e00, LENGTH = 64    /* cluster0_utest_nvm_boot0 */
	
    DME_iram    (xrw) : ORIGIN = 0x20200000, LENGTH = 96k
    DME_dram    (xrw) : ORIGIN = 0x20100000, LENGTH = 32k
    DSPH_iram   (xrw) : ORIGIN = 0x20500000, LENGTH = 32k
    DSPH_dram   (xrw) : ORIGIN = 0x20400000, LENGTH = 64k
	
    EMBED_TCM_A (xrw) : ORIGIN = 0x68000000, LENGTH = 64k   /* cluster0_core0_tcm_a */
    EMBED_TCM_B (xrw) : ORIGIN = 0x68100000, LENGTH = 16k   /* cluster0_core0_tcm_b */
    EMBED_TCM_C (xrw) : ORIGIN = 0x68200000, LENGTH = 16k   /* cluster0_core0_tcm_c */
	
	SYSRAM0     (xrw) : ORIGIN = 0x64000000, LENGTH = 280k
    SYSRAM1     (xrw) : ORIGIN = 0x64400000, LENGTH = 280k
}

SECTIONS
{
    .boot_record_utest (ORIGIN(BOOT_RECORD)):
    {
        KEEP(*(.boot_record_utest))
    } > BOOT_RECORD

    .exec_boot_region (ORIGIN(FLASH)):
    {
        KEEP(*(.reset_vector))
        KEEP(*(.boot))
        KEEP(*(.crt0))
        KEEP(*(.common_vectors_section))
    } > FLASH
    . = ALIGN(0x1000);


    /* Core vectors */
    .exec_code_region :
    {
        KEEP(*(.core_vectors_section))
        *(.text)
        *(.text.*)
        *(.rodata)
        *(.rodata.*)
        *(.gnu.linkonce.t.*)
    } > FLASH


    .ARM.exidx :
    {
        *(.ARM.exidx*)
    } > FLASH


    .DME_code (ORIGIN(DME_iram)): ALIGN(4)
    {
        __DME_code__ = .;
        KEEP(*(.dme_code))
    } > DME_iram AT> FLASH
    __DME_code_size__ = SIZEOF(.DME_code);
    __DME_code_load__ = LOADADDR(.DME_code);

    .DME_data (ORIGIN(DME_dram)): ALIGN(4)
    {
        __DME_data__ = .;
        KEEP(*(.dme_data))
    } > DME_dram AT> FLASH
    __DME_data_size__ = SIZEOF(.DME_data);
    __DME_data_load__ = LOADADDR(.DME_data);

    .DSPH_code (ORIGIN(DSPH_iram)): ALIGN(4)
    {
        __DSPH_code__ = .;
        KEEP(*(.dsph_code))
    } > DSPH_iram AT> FLASH
    __DSPH_code_size__ = SIZEOF(.DSPH_code);
    __DSPH_code_load__ = LOADADDR(.DSPH_code);

    .DSPH_data (ORIGIN(DSPH_dram)): ALIGN(4)
    {
        __DSPH_data__ = .;
        KEEP(*(.dsph_data))
    } > DSPH_dram AT> FLASH
    __DSPH_data_size__ = SIZEOF(.DSPH_data);
    __DSPH_data_load__ = LOADADDR(.DSPH_data);

    .tcm_a_code (ORIGIN(EMBED_TCM_A)):
    {
        __tcm_a_code__ = . ;
        KEEP(*(.vectors))
        KEEP(*(.handlers))
        KEEP(*(.init))
    } > EMBED_TCM_A AT> FLASH
    __tcm_a_code_size__ = SIZEOF(.tcm_a_code);
    __tcm_a_code_len__  = LENGTH(EMBED_TCM_A);
    __tcm_a_code_load__ = LOADADDR(.tcm_a_code);


    .tcm_b_data (ORIGIN(EMBED_TCM_B)):
    {
        __tcm_b_data__ = .;
    } > EMBED_TCM_B AT> FLASH
    __tcm_b_data_size__ = SIZEOF(.tcm_b_data);
    __tcm_b_data_len__  = LENGTH(EMBED_TCM_B);
    __tcm_b_data_load__ = LOADADDR(.tcm_b_data);


    .tcm_c_data (ORIGIN(EMBED_TCM_C)):
    {
        __tcm_c_data__ = .;
    } > EMBED_TCM_C AT> FLASH
    __tcm_c_data_size__ = SIZEOF(.tcm_c_data);
    __tcm_c_data_len__  = LENGTH(EMBED_TCM_C);
    __tcm_c_data_load__ = LOADADDR(.tcm_c_data);

    /* Used by the startup to initialize data */
    _sidata = LOADADDR(.data);

    .data ORIGIN(RAM):
    {
        __data_start__ = .;
         *(.data)
         *(.data.*)
         *(.gnu.linkonce.d.*)
        __data_end__ = .;
    } > RAM AT> FLASH
    __data_size__ = SIZEOF(.data);
    __data_load__ = LOADADDR(.data);


    .bss :
    {
        . = ALIGN(0x08);
        __bss_start__ = .;
         *(.bss)
         *(.bss.*)
         *(.gnu.linkonce.b.*)
         *(COMMON)
        __bss_end__ = .;
    } > RAM


    .supervisor_stack :
    {
        . = ALIGN(0x10);
        __supervisor_stack__ = .;
        . += 1k;
        __supervisor_stack_limit__ = .;
    } > RAM


    .abort_stack :
    {
        . = ALIGN(0x10);
        __abort_stack__ = .;
        . += 1k;
        __abort_stack_limit__ = .;
    } > RAM


    .undefined_stack :
    {
        . = ALIGN(0x10);
        __undefined_stack__ = .;
        . += 1k;
        __undefined_stack_limit__ = .;
    } > RAM


    .irq_stack :
    {
        . = ALIGN(0x10);
        __irq_stack__ = .;
        . += 1k;
        __irq_stack_limit__ = .;
    } > RAM


    .fiq_stack :
    {
        . = ALIGN(0x10);
        __fiq_stack__ = .;
        . += 1k;
        __fiq_stack_limit__ = .;
    } > RAM


    .hyp_stack :
    {
        . = ALIGN(0x10);
        __hyp_stack__ = .;
        . += 4k;
        __hyp_stack_limit__ = .;
    } > RAM


    .user_stack :
    {
        . = ALIGN(0x10);
        __user_stack__ = .;
        . += 32k;
       _estack = .;
        __user_stack_limit__ = .;
    } > RAM


    .user_sysram0 (NOLOAD) :
    {
        KEEP(*(.shared_sysram0))
    } > SYSRAM0


	.user_sysram1 (NOLOAD) :
    {
        KEEP(*(.shared_sysram1))
    } > SYSRAM1

    /* Remove information from the compiler libraries */
    /DISCARD/ :
    {
      libc.a ( * )
      libm.a ( * )
      libgcc.a ( * )
    }

    . = ALIGN(0x10);
    __heap_base__ = .;
    __heap_end__  = ORIGIN(RAM) + LENGTH(RAM);


/*
 * The following variable are used to clean-up the memory at boot time.
 * See _raminit in ram.S.
 */
    __mem_start__ = ORIGIN(RAM);
    __mem_end__   = __heap_end__;

    __sysram0_start__ = ORIGIN(SYSRAM0);
    __sysram0_end__   = ORIGIN(SYSRAM0) + LENGTH(SYSRAM0);

    __sysram1_start__ = ORIGIN(SYSRAM1);
    __sysram1_end__   = ORIGIN(SYSRAM1) + LENGTH(SYSRAM1);

    __dmeData_start__ = ORIGIN(DME_dram);
    __dmeData_end__   = ORIGIN(DME_dram) + LENGTH(DME_dram);
    __dmeIram_start__ = ORIGIN(DME_iram);
    __dmeIram_end__   = ORIGIN(DME_iram) + LENGTH(DME_iram);
    __dsphData_start__ = ORIGIN(DSPH_dram);
    __dsphData_end__   = ORIGIN(DSPH_dram) + LENGTH(DSPH_dram);
    __dsphIram_start__ = ORIGIN(DSPH_iram);
    __dsphIram_end__   = ORIGIN(DSPH_iram) + LENGTH(DSPH_iram);
}
