/**
 ******************************************************************************
 * @file    stedgeai_app_main.c
 * @author  MCD/AIS Team
 * @brief   Minimal main template to use the ST AI generated c-model using the
            STAI api.
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; Copyright (c) 2024 STMicroelectronics.
 * All rights reserved.</center></h2>
 *
 * This software is licensed under terms that can be found in the LICENSE file in
 * the root directory of this software component.
 * If no LICENSE file comes with this software, it is provided AS-IS.
 *
 ******************************************************************************
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "${name}.h"
#include "${name}_data.h"

/* Global handle to reference the instantiated C-model */
STAI_NETWORK_CONTEXT_DECLARE(m_${name}, STAI_${name.upper()}_CONTEXT_SIZE)

% for idx, input in enumerate(activations):
/* Array to store the data of the activation buffers */
  % if allocate_activations:
/* -> activations_${loop.index+1} is allocated in ${name.upper()}.c */
  % else:
STAI_ALIGNED(STAI_${name.upper()}_ACTIVATION_${loop.index+1}_ALIGNMENT)
static uint8_t activations_${loop.index+1}[STAI_${name.upper()}_ACTIVATION_${loop.index+1}_SIZE_BYTES];
  % endif
% endfor

% for idx, state in enumerate(states):
/* Array to store the data of the state buffers */
  % if allocate_states:
/* -> states_${loop.index+1} is allocated in ${name.upper()}.c */
  % else:
STAI_ALIGNED(STAI_${name.upper()}_STATE_${loop.index+1}_ALIGNMENT)
static uint8_t states_${loop.index+1}[STAI_${name.upper()}_STATE_${loop.index+1}_SIZE_BYTES];
  % endif
% endfor

/* Array to store the data of the input tensors */
% for idx, input in enumerate(inputs):
  % if allocate_inputs:
/* -> data_in_${loop.index+1} is allocated in activations buffer */
  % else:
STAI_ALIGNED(STAI_${name.upper()}_IN_${loop.index+1}_ALIGNMENT)
static uint8_t data_in_${loop.index+1}[STAI_${name.upper()}_IN_${loop.index+1}_SIZE_BYTES];
  % endif
% endfor

/* Array to store the data of the output tensors */
% for idx, output in enumerate(outputs):
  % if allocate_outputs:
/* -> data_out_${loop.index+1} is allocated in activations buffer */
  % else:
STAI_ALIGNED(STAI_${name.upper()}_OUT_${loop.index+1}_ALIGNMENT)
static uint8_t data_out_${loop.index+1}[STAI_${name.upper()}_OUT_${loop.index+1}_SIZE_BYTES];
  % endif
% endfor

static stai_ptr m_inputs[STAI_${name.upper()}_IN_NUM];
static stai_ptr m_outputs[STAI_${name.upper()}_OUT_NUM];
% if activations:
static stai_ptr m_acts[STAI_${name.upper()}_ACTIVATIONS_NUM];
% endif
% if states:
static stai_ptr m_states[STAI_${name.upper()}_STATES_NUM];
% endif

int aiInit(void);
stai_return_code aiRun(void);
void main_loop(void);
int main(void);

/* 
 * Bootstrap
 */
int aiInit(void)
{
  stai_size _dummy;

  /* -- Create and initialize the c-model */

  /* Initialize the instance */
  stai_${name}_init(m_${name});

% if activations:

  /* -- Set the @ of the activation buffers */

% if allocate_activations:
  /* Activation buffers are allocated in the ${name.upper()}.c */
  stai_${name}_get_activations(m_${name}, m_acts, &_dummy);
% else:
  /* Activation buffers are allocated in the user/app space */
  % for idx, input in enumerate(activations):
  m_acts[${loop.index}] = (stai_ptr)activations_${loop.index+1};
  % endfor
  stai_${name}_set_activations(m_${name}, m_acts, STAI_${name.upper()}_ACTIVATIONS_NUM);
  stai_${name}_get_activations(m_${name}, m_acts, &_dummy);
% endif

% endif

% if states:

  /* -- Set the @ of the state buffers */

% if allocate_states:
  /* State buffers are allocated in the ${name.upper()}.c */
  stai_${name}_get_states(m_${name}, m_states, &_dummy);
% else:
  /* States buffers are allocated in the user/app space */
  % for idx, input in enumerate(states):
  m_states[${loop.index}] = (stai_ptr)states_${loop.index+1};
  % endfor
  stai_${name}_set_states(m_${name}, m_states, STAI_${name.upper()}_STATES_NUM);
  stai_${name}_get_states(m_${name}, m_states, &_dummy);
% endif

% endif

  /* -- Set the @ of the input/output buffers */

% if allocate_inputs:
  /* Input buffers are allocated in the activations buffer */
  stai_${name}_get_inputs(m_${name}, m_inputs, &_dummy);
% else:
  /* Input buffers are allocated in the user/app space */
  % for idx, input in enumerate(inputs):
  m_inputs[${loop.index}] = (stai_ptr)data_in_${loop.index+1};
  % endfor
  stai_${name}_set_inputs(m_${name}, m_inputs, STAI_${name.upper()}_IN_NUM);
  stai_${name}_get_inputs(m_${name}, m_inputs, &_dummy);
% endif

% if allocate_outputs:
  /* Output buffers are allocated in the activations buffer */
  stai_${name}_get_outputs(m_${name}, m_outputs, &_dummy);
% else:
  /* Output buffers are allocated in the user/app space */
  % for idx, input in enumerate(outputs):
  m_outputs[${loop.index}] = (stai_ptr)data_out_${loop.index+1};
  % endfor
  stai_${name}_set_outputs(m_${name}, m_outputs, STAI_${name.upper()}_OUT_NUM);
  stai_${name}_get_outputs(m_${name}, m_outputs, &_dummy);
% endif

  return 0;
}

/* 
 * Run inference
 */
stai_return_code aiRun()
{
  stai_return_code res;

  res = stai_${name}_run(m_${name}, STAI_MODE_SYNC);
  
  return res;
}

/* 
 * Example of main loop function
 */
void main_loop()
{

  aiInit();

  
  while (1) {
    /* 1 - Acquire, pre-process and fill the input buffers */
    // acquire_and_process_data(...);

    /* 2 - Call inference engine */
    aiRun();

    /* 3 - Post-process the predictions */
    // post_process(...);
  }
}

/* 
 * Example of system initialization function
 */
void SystemInit(void)
{

}

/* 
 * Example of main application function
 */
int main()
{
  SystemInit();
  main_loop();
  return 0;
}
