{#
  ******************************************************************************
  * @file    stai_common.j2.c
  * @author  AST Embedded Analytics Research Platform
  * @brief   STAI Tool Automatic Code Generator for Embedded NN computing
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2023 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  ******************************************************************************
#}

{# STAI Code Generation Macros #}

{%- macro render_array_values(values, sep=', ', postfix='') -%}
  {%- if values -%}
  {{values|join(postfix + sep)}}{{postfix}}
  {%- endif -%}
{%- endmacro -%}


{%- macro render_array(type, values, sep=', ', postfix='') -%}
  {%- if values -%}
  STAI_DECLARE_ARRAY({{type}}, {{values|length}}, {{render_array_values(values, sep, postfix)}})
  {%- else -%}
  STAI_EMPTY_ARRAY()
  {%- endif -%}
{%- endmacro -%}
