{#
  ******************************************************************************
  * @file    network_params.j2.c
  * @author  AST Embedded Analytics Research Platform
  * @brief   AI Tool Automatic Code Generator for Embedded NN computing
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2022 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  ******************************************************************************
#}
{%- import 'network_layers.j2.c' as layers -%}

{% set net_name = config['net_name'].lower() -%}
{% set NET_NAME = config['net_name'].upper() -%}
{% set data_module = config['data_module'].lower() -%}
{% set DATA_MODULE = config['data_module'].upper() -%}
{% set _activations = config[layers.ACTIVATIONS] -%}
{% set _weights = config[layers.WEIGHTS] -%}

/**
  ******************************************************************************
  * @file    {{ data_module }}_params.c
  * @author  AST Embedded Analytics Research Platform
  * @date    {{ config['date_time'] }}
  * @brief   AI Tool Automatic Code Generator for Embedded NN computing
  ******************************************************************************
  * {{ config['copyright'] }}
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  ******************************************************************************
  */

#include "{{ data_module }}_params.h"

{% if _activations['size'] > 0 %}
/**  Activations Section  ****************************************************/
ai_handle {{ _activations['table'] }}[{{ _activations['buffers']|length }} + 2] = {
  AI_HANDLE_PTR(AI_MAGIC_MARKER),
{%- for buf in _activations['buffers']: %}
  AI_HANDLE_PTR(NULL),
{%- endfor %}
  AI_HANDLE_PTR(AI_MAGIC_MARKER),
};
{{ "" }}
{% endif %}

{% if _weights['size'] > 0 %}
/**  Weights Section  ********************************************************/
{%- if _weights['hexify'] %}
{%- for buf in _weights['buffers']: %}
AI_ALIGNED(32)
const ai_{{ buf['buffer_c_type'] }} {{ buf['buffer_c_name'] }}[{{ buf['buffer_c_count'] }}] = {
{%- for line in buf['buffer_c_data']: %}
  {{ line|join(', ') }},
{%- endfor %}
};
{{ "" }}
{%- endfor %}

ai_handle {{ _weights['table'] }}[{{ _weights['buffers']|length }} + 2] = {
  AI_HANDLE_PTR(AI_MAGIC_MARKER),
{%- for buf in _weights['buffers']: %}
  AI_HANDLE_PTR({{ buf['buffer_c_name'] }}),
{%- endfor %}
  AI_HANDLE_PTR(AI_MAGIC_MARKER),
};
{%- else %}
ai_handle {{ _weights['table'] }}[{{ _weights['buffers']|length }} + 2] = {
  AI_HANDLE_PTR(AI_MAGIC_MARKER),
{%- for buf in _weights['buffers']: %}
  AI_HANDLE_PTR(NULL),
{%- endfor %}
  AI_HANDLE_PTR(AI_MAGIC_MARKER),
};
{%- endif %}
{{ "" }}
{% endif %}
