{#
  ******************************************************************************
  * @file    network_inputs.j2.c
  * @author  AST Embedded Analytics Research Platform
  * @brief   AI Tool Automatic Code Generator for Embedded NN computing
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2022 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  ******************************************************************************
#}
{% set net_name = config['net_name'].lower() -%}

/**
  ******************************************************************************
  * @file    {{ net_name }}_inputs.c
  * @author  AST Embedded Analytics Research Platform
  * @date    {{ config['date_time'] }}
  * @brief   AI Tool Automatic Code Generator for Embedded NN computing
  ******************************************************************************
  * {{ config['copyright'] }}
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  ******************************************************************************
  */

#include "{{ net_name }}_inputs.h"

{%- for _input in config['c_net_in'] %}
{%- set _input_index = loop.index %}
#ifndef MINIMAL_COMPILE
{%- for _batch in _input['init_c_data']: %}
{%- set _batch_index = loop.index %}
const {{ _input['fmt'].get_c_type() }} input{{_input_index}}_{{_batch_index}}[{{ _input['padded_elements']}}] __attribute__((aligned(4)))= {
{%- for line in _batch: %}
  {{ line }}
{%- endfor %}
};

{%- endfor %}

const {{ _input['fmt'].get_c_type() }} * input{{_input_index}} [{{ config['batches'] }}] = {
{%- for _batch in _input['init_c_data']: %}
{%- set _batch_index = loop.index %}
  input{{_input_index}}_{{_batch_index}}{%- if not loop.last -%},{%- endif -%}
{%- endfor %}
};
#else
const {{ _input['fmt'].get_c_type() }} * input{{loop.index}} = NULL;
#endif

{%- endfor %}
