{#
  ******************************************************************************
  * @file    legacy_network.j2.h
  * @author  AST Embedded Analytics Research Platform
  * @brief   AI Tool Automatic Code Generator for Embedded NN computing
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2023 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  ******************************************************************************
#}
{%- import 'network_layers.j2.c' as layers -%}
{%- set net_name = config['net_name'].lower() -%}
{%- set NET_NAME = config['net_name'].upper() -%}
{%- set _activations = config[layers.ACTIVATIONS] -%}
{%- set _weights = config[layers.WEIGHTS] -%}
/**
  ******************************************************************************
  * @file    {{ net_name }}.h
  * @author  AST Embedded Analytics Research Platform
  * @date    {{ config['date_time'] }}
  * @brief   AI Tool Automatic Code Generator for Embedded NN computing
  ******************************************************************************
  * @attention
  *
  * {{ config['copyright'] }}
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  ******************************************************************************
  */
#ifndef _LEGACY_AI_{{ NET_NAME }}_H
#define _LEGACY_AI_{{ NET_NAME }}_H

#include "{{ net_name }}_config.h"
#include "ai_platform.h"

/******************************************************************************/
#define AI_{{ NET_NAME }}_MODEL_NAME          "{{ config['model_name'] }}"
#define AI_{{ NET_NAME }}_ORIGIN_MODEL_NAME   "{{ config['model_origin_name'] }}"

/******************************************************************************/
#define AI_{{ NET_NAME }}_ACTIVATIONS_ALIGNMENT   ({{ _activations['alignment'] }})
{% if config['allocate_inputs'] -%}
#define AI_{{ NET_NAME }}_INPUTS_IN_ACTIVATIONS   ({{ config['allocate_inputs'] }})
{%- endif %}
{% if config['allocate_outputs'] -%}
#define AI_{{ NET_NAME }}_OUTPUTS_IN_ACTIVATIONS  ({{ config['allocate_outputs'] }})
{%- endif %}

/******************************************************************************/
#define AI_{{ NET_NAME }}_IN_NUM        ({{ config['c_net_in']|length }})

AI_DEPRECATED
#define AI_{{ NET_NAME }}_IN \
  ai_{{ net_name }}_inputs_get(AI_HANDLE_NULL, NULL)

#define AI_{{ NET_NAME }}_IN_SIZE { \
{%- for tensor in config['c_net_in']: %}
  AI_{{ NET_NAME }}_IN_{{ loop.index }}_SIZE, \
{%- endfor %}
}
#define AI_{{ NET_NAME }}_IN_SIZE_BYTES { \
{%- for tensor in config['c_net_in']: %}
  AI_{{ NET_NAME }}_IN_{{ loop.index }}_SIZE_BYTES, \
{%- endfor %}
}

{%- for _shape, _buffer in config['in_shapes']: %}
{%- set _index = loop.index %}
#define AI_{{ NET_NAME }}_IN_{{ _index }}_FORMAT      ({{ _buffer['fmt'].get_c_buffer_format() }})
{%- for _name, _value in _shape.to_c(prefix=''): %}
#define AI_{{ NET_NAME }}_IN_{{ _index }}_{{ _name.ljust(11) }} ({{ _value }})
{%- endfor %}
#define AI_{{ NET_NAME }}_IN_{{ _index }}_SIZE        ({{ _shape.get_size() }})
#define AI_{{ NET_NAME }}_IN_{{ _index }}_SIZE_BYTES  ({{ _buffer['array_byte_size'] }})
{%- endfor %}

/******************************************************************************/
#define AI_{{ NET_NAME }}_OUT_NUM       ({{ config['c_net_out']|length }})

AI_DEPRECATED
#define AI_{{ NET_NAME }}_OUT \
  ai_{{ net_name }}_outputs_get(AI_HANDLE_NULL, NULL)

#define AI_{{ NET_NAME }}_OUT_SIZE { \
{%- for tensor in config['c_net_out']: %}
  AI_{{ NET_NAME }}_OUT_{{ loop.index }}_SIZE, \
{%- endfor %}
}
#define AI_{{ NET_NAME }}_OUT_SIZE_BYTES { \
{%- for tensor in config['c_net_out']: %}
  AI_{{ NET_NAME }}_OUT_{{ loop.index }}_SIZE_BYTES, \
{%- endfor %}
}

{%- for _shape, _buffer in config['out_shapes']: %}
{%- set _index = loop.index %}
#define AI_{{ NET_NAME }}_OUT_{{ _index }}_FORMAT      ({{ _buffer['fmt'].get_c_buffer_format() }})
{%- for _name, _value in _shape.to_c(prefix=''): %}
#define AI_{{ NET_NAME }}_OUT_{{ _index }}_{{ _name.ljust(11) }} ({{ _value }})
{%- endfor %}
#define AI_{{ NET_NAME }}_OUT_{{ _index }}_SIZE        ({{ _shape.get_size() }})
#define AI_{{ NET_NAME }}_OUT_{{ _index }}_SIZE_BYTES  ({{ _buffer['array_byte_size'] }})
{%- endfor %}

/******************************************************************************/
#define AI_{{ NET_NAME }}_N_NODES ({{ config['layers']|length }})


AI_API_DECLARE_BEGIN

/*!
 * @defgroup {{ net_name }}
 * @brief Public neural network APIs
 * @details This is the header for the network public APIs declarations
 * for interfacing a generated network model.
 * @details The public neural network APIs hide the structure of the network
 * and offer a set of interfaces to create, initialize, query, configure, 
 * run and destroy a network instance.
 * To handle this, an opaque handler to the network context is provided 
 * on creation.
 * The APIs are meant as stadard interfaces for the calling code; depending on
 * the supported platforms and the models, different implementations could be
 * available.
 */

/******************************************************************************/
/*! Public API Functions Declarations */


/*!
 * @brief Get network library report as a datastruct.
 * @ingroup {{ net_name }}
 * @param[in] network: the handler to the network context
 * @param[out] report a pointer to the report struct where to
 * store network info. See @ref ai_network_report struct for details
 * @return a boolean reporting the exit status of the API
 */
AI_API_ENTRY
ai_bool ai_{{ net_name }}_get_report(
  ai_handle network, ai_network_report* report);


/*!
 * @brief Get first network error code.
 * @ingroup {{ net_name }}
 * @details Get an error code related to the 1st error generated during
 * network processing. The error code is structure containing an 
 * error type indicating the type of error with an associated error code
 * Note: after this call the error code is internally reset to AI_ERROR_NONE
 * @param network an opaque handle to the network context
 * @return an error type/code pair indicating both the error type and code
 * see @ref ai_error for struct definition
 */
AI_API_ENTRY
ai_error ai_{{ net_name }}_get_error(ai_handle network);


/*!
 * @brief Create a neural network.
 * @ingroup {{ net_name }}
 * @details Instantiate a network and returns an object to handle it;
 * @param network an opaque handle to the network context
 * @param network_config a pointer to the network configuration info coded as a 
 * buffer
 * @return an error code reporting the status of the API on exit
 */
AI_API_ENTRY
ai_error ai_{{ net_name }}_create(
  ai_handle* network, const ai_buffer* network_config);


/*!
 * @brief Destroy a neural network and frees the allocated memory.
 * @ingroup {{ net_name }}
 * @details Destroys the network and frees its memory. The network handle is returned;
 * if the handle is not NULL, the unloading has not been successful.
 * @param network an opaque handle to the network context
 * @return an object handle : AI_HANDLE_NULL if network was destroyed
 * correctly. The same input network handle if destroy failed.
 */
AI_API_ENTRY
ai_handle ai_{{ net_name }}_destroy(ai_handle network);


/*!
 * @brief Initialize the data structures of the network.
 * @ingroup {{ net_name }}
 * @details This API initialized the network after a successfull
 * @ref ai_{{ net_name }}_create. Both the activations memory buffer 
 * and params (i.e. weights) need to be provided by caller application
 * 
 * @param network an opaque handle to the network context
 * @param params the parameters of the network (required). 
 * see @ref ai_network_params struct for details
 * @return true if the network was correctly initialized, false otherwise
 * in case of error the error type could be queried by 
 * using @ref ai_{{ net_name }}_get_error
 */
AI_API_ENTRY
ai_bool ai_{{ net_name }}_init(
  ai_handle network, const ai_network_params* params);


/*!
 * @brief Create and initialize a neural network (helper function)
 * @ingroup {{ net_name }}
 * @details Helper function to instantiate and to initialize a network. It returns an object to handle it;
 * @param network an opaque handle to the network context
 * @param activations array of addresses of the activations buffers
 * @param weights array of addresses of the weights buffers
 * @return an error code reporting the status of the API on exit
 */
AI_API_ENTRY
ai_error ai_{{ net_name }}_create_and_init(
  ai_handle* network, const ai_handle activations[], const ai_handle weights[]);


/*!
 * @brief Get network inputs array pointer as a ai_buffer array pointer.
 * @ingroup {{ net_name }}
 * @param network an opaque handle to the network context
 * @param n_buffer optional parameter to return the number of outputs
 * @return a ai_buffer pointer to the inputs arrays
 */
AI_API_ENTRY
ai_buffer* ai_{{ net_name }}_inputs_get(
  ai_handle network, ai_u16 *n_buffer);


/*!
 * @brief Get network outputs array pointer as a ai_buffer array pointer.
 * @ingroup {{ net_name }}
 * @param network an opaque handle to the network context
 * @param n_buffer optional parameter to return the number of outputs
 * @return a ai_buffer pointer to the outputs arrays
 */
AI_API_ENTRY
ai_buffer* ai_{{ net_name }}_outputs_get(
  ai_handle network, ai_u16 *n_buffer);


/*!
 * @brief Run the network and return the output
 * @ingroup {{ net_name }}
 *
 * @details Runs the network on the inputs and returns the corresponding output.
 * The size of the input and output buffers is stored in this
 * header generated by the code generation tool. See AI_{{ NET_NAME }}_*
 * defines into file @ref {{ net_name }}.h for all network sizes defines
 *
 * @param network an opaque handle to the network context
 * @param[in] input buffer with the input data
 * @param[out] output buffer with the output data
 * @return the number of input batches processed (default 1) or <= 0 if it fails
 * in case of error the error type could be queried by 
 * using @ref ai_{{ net_name }}_get_error
 */
AI_API_ENTRY
ai_i32 ai_{{ net_name }}_run(
  ai_handle network, const ai_buffer* input, ai_buffer* output);


/*!
 * @brief Runs the network on the inputs.
 * @ingroup {{ net_name }}
 *
 * @details Differently from @ref ai_network_run, no output is returned, e.g. for
 * temporal models with a fixed step size.
 *
 * @param network the network to be run
 * @param[in] input buffer with the input data
 * @return the number of input batches processed (usually 1) or <= 0 if it fails
 * in case of error the error type could be queried by 
 * using @ref ai_{{ net_name }}_get_error
 */
AI_API_ENTRY
ai_i32 ai_{{ net_name }}_forward(
  ai_handle network, const ai_buffer* input);

AI_API_DECLARE_END

#endif /* _LEGACY_AI_{{ NET_NAME }}_H */
{{ "" }}
