{#
  ******************************************************************************
  * @file    layers_custom.j2.c
  * @author  AST Embedded Analytics Research Platform
  * @brief   AI Tool Automatic Code Generator for Embedded NN computing
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2020 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  ******************************************************************************
#}

{%- import 'network_layers.j2.c' as layers -%}
{% set custom = config[layers.CUSTOM] -%}

{# Code Generation Macros #}

{% macro user_code_render(indent) %}
{{ indent }}/* USER CODE BEGINS HERE */

{{ indent }}/* USER CODE ENDS HERE */
{% endmacro %}

{%- macro custom_render_macros(macros) -%}
{% if macros|length > 0 %}
  switch (l->id)
  {
  {%- for macro in macros: %}
    case {{ macro['layer_name'] }}:
    {
      {{ user_code_render('      ') }}
    } break;
  {% endfor %}
    default: break;
  }
{% else %}
  {{ user_code_render('  ') }}
{% endif %}
{%- endmacro -%}

{%- macro custom_render_tensors(signature, name, type) -%}
{% for idx in range(signature): -%}
  ai_tensor* {{ name }}{{ idx }} = ai_layer_get_tensor_{{ type }}(l, {{ idx }});
{% endfor %}
{%- endmacro -%}

/**
  ******************************************************************************
  * @file    {{ custom['file_name'] }}
  * @author  AST Embedded Analytics Research Platform
  * @date    {{ config['date_time'] }}
  * @brief   AI Tool Automatic Code Generator for Custom Layers Implementation
  ******************************************************************************
  * @attention
  *
  * {{ config['copyright'] }}
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  ******************************************************************************
  */

#include "ai_layer_custom_interface.h"

{%- if custom['macros']|length > 0 %}
{%- for macro in custom['macros']: %}
#define {{ macro['layer_name'] }}           ({{ macro['layer_id'] }})
{% endfor -%}
{%- endif -%}

{{ user_code_render('') }}

/*****************************************************************************/
{% for function in custom['init']: %}
/* Layer Init Function #{{ loop.index0 }} */
void {{ function[0] }}(ai_layer* layer)
{
  ai_layer_custom* l = ai_layer_custom_get(layer);
  {{ custom_render_tensors(function[1]['inputs'], 't_in', 'in') }}
  {{ custom_render_tensors(function[1]['outputs'], 't_out', 'out') }}
  {{ custom_render_macros(custom['macros']) }}

  ai_layer_custom_release(layer);
}
{% endfor -%}

/*****************************************************************************/
{% for function in custom['forward']: %}
/* Layer Forward Function #{{ loop.index0 }} */
void {{ function[0] }}(ai_layer* layer)
{
  ai_layer_custom* l = ai_layer_custom_get(layer);
  {{ custom_render_tensors(function[1]['inputs'], 't_in', 'in') }}
  {{ custom_render_tensors(function[1]['outputs'], 't_out', 'out') }}
  {{ custom_render_tensors(function[1]['weights'], 't_weight', 'weights') }}
  {{ custom_render_macros(custom['macros']) }}

  ai_layer_custom_release(layer);
}
{% endfor -%}

{%- if custom['macros']|length > 0 %}
{% for macro in custom['macros']: %}
#undef {{ macro['layer_name'] }}
{% endfor -%}
{%- endif -%}
{{ "" }}
