/**
 ******************************************************************************
 * @file    stellar_e.ld
 * @author  MDRF Automotive division
 * @brief   Default script file
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; Copyright (c) 2023,2024 STMicroelectronics.
 * All rights reserved.</center></h2>
 *
 * This software is licensed under terms that can be found in the LICENSE file in
 * the root directory of this software component.
 * If no LICENSE file comes with this software, it is provided AS-IS.
 *
 ******************************************************************************
 */

/* Entry Point */
ENTRY(Reset_Handler)

/* Memories definition */
MEMORY
{
    RAM	    (xrw) : ORIGIN = 0x24000000, LENGTH = 256k  /* SRAM1 + SRAM2 */
    FLASH	(rx)  : ORIGIN = 0x08000000, LENGTH = 1920k /* Code Flash 1 + Code Flash 2 */
	
    core_itcm1_dir (wx) : org = 0x5A000000, len = 32k   /* ITCM1 */
    core_itcm2_dir (wx) : org = 0x5A040000, len = 32k   /* ITCM2 */
    core_dtcm1_dir (wx) : org = 0x5C000000, len = 64k   /* DTCM1 */
    core_dtcm2_dir (wx) : org = 0x5C040000, len = 64k   /* DTCM2 */

}

/* Sections */
SECTIONS
{
    startup : ALIGN(16) SUBALIGN(1024)
    {
        KEEP(*(.vectors))
        KEEP(*(.reset_handler))
    } > FLASH


    constructors : ALIGN(4) SUBALIGN(4)
    {
        PROVIDE(__init_array_start = .);
        KEEP(*(SORT(.init_array.*)))
        KEEP(*(.init_array))
        PROVIDE(__init_array_end = .);
    } > FLASH


    destructors : ALIGN(4) SUBALIGN(4)
    {
        PROVIDE(__fini_array_start = .);
        KEEP(*(.fini_array))
        KEEP(*(SORT(.fini_array.*)))
        PROVIDE(__fini_array_end = .);
    } > FLASH


    .text : ALIGN(16) SUBALIGN(16)
    {
        *(.text)
        *(.text.*)
        *(.rodata)
        *(.rodata.*)
        *(.glue_7t)
        *(.glue_7)
        *(.gcc*)
    } > FLASH


    .ARM.extab :
    {
        *(.ARM.extab* .gnu.linkonce.armextab.*)
    } > FLASH


    .ARM.exidx :
    {
        PROVIDE(__exidx_start = .);
        *(.ARM.exidx* .gnu.linkonce.armexidx.*)
        PROVIDE(__exidx_end = .);
    } > FLASH


    .eh_frame_hdr :
    {
        *(.eh_frame_hdr)
    } > FLASH


    .eh_frame : ONLY_IF_RO
    {
        *(.eh_frame)
    } > FLASH


    .itcm ORIGIN(core_itcm1_dir) : ALIGN(16)
    {
        __itcm__ = . ;
    } > core_itcm1_dir AT> FLASH
    __itcm_start__ = ORIGIN(core_itcm1_dir);
    __itcm_len__ = LENGTH(core_itcm1_dir);
    __itcm_end__ = __itcm_start__ + __itcm_len__;
    __itcm_size__ = SIZEOF(.itcm);
    __itcm_load__ = LOADADDR(.itcm);


    .dtcm ORIGIN(core_dtcm1_dir) : ALIGN(4)
    {
        __dtcm__ = . ;
    } > core_dtcm1_dir AT> FLASH
    __dtcm_start__ = ORIGIN(core_dtcm1_dir);
    __dtcm_len__ = LENGTH(core_dtcm1_dir);
    __dtcm_end__ = __dtcm_start__ + __dtcm_len__;
    __dtcm_size__ = SIZEOF(.dtcm);
    __dtcm_load__ = LOADADDR(.dtcm);

    /* Used by the startup to initialize data */
    _sidata = LOADADDR(.data);

    .data ORIGIN(RAM) : ALIGN(4)
    {
        . = ALIGN(4);
        PROVIDE(__data_start__ = .);
        *(.data)
        *(.data.*)
        *(.gnu.linkonce.d.*)
        PROVIDE(__data_end__ = .);
    } > RAM AT> FLASH
    __data_size__ = SIZEOF(.data);
    __data_load__ = LOADADDR(.data);


    .bss :
    {
        . = ALIGN(8);
        PROVIDE(__bss_start__ = .);
        *(.bss)
        *(.bss.*)
        *(.gnu.linkonce.b.*)
        *(COMMON)
        PROVIDE(__bss_end__ = .);
    } > RAM


    .mstack (NOLOAD) :
    {
        . = ALIGN(8);
        __main_stack_base__ = .;
        . += 4k;
        . = ALIGN(8);
        __main_stack_end__ = .;
    } > RAM


    .pstack (NOLOAD) :
    {
        __process_stack_base__ = .;
        __main_thread_stack_base__ = .;
        . += 4k;
        . = ALIGN(8);
        __process_stack_end__ = .;
       _estack = .;
        __main_thread_stack_end__ = .;
    } > RAM


  /* Remove information from the compiler libraries */
  /DISCARD/ :
  {
    libc.a ( * )
    libm.a ( * )
    libgcc.a ( * )
  }

  .ARM.attributes 0 : { *(.ARM.attributes) }

    . = ALIGN(16);
    __heap_base__ = .;
    __heap_end__ = ORIGIN(RAM) + LENGTH(RAM);

    __mem_start__ = ORIGIN(RAM);
    __mem_end__ = __heap_end__;
}
