/**
 ******************************************************************************
 * @file    stedgeai_app_main.c
 * @author  MCD/AIS Team
 * @brief   Minimal main template to use the ST AI generated c-model
 *          (lite version) - EXPERIMENTAL
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; Copyright (c) 2019,2021 STMicroelectronics.
 * All rights reserved.</center></h2>
 *
 * This software is licensed under terms that can be found in the LICENSE file in
 * the root directory of this software component.
 * If no LICENSE file comes with this software, it is provided AS-IS.
 *
 ******************************************************************************
 */

#include <stdio.h>
#include <string.h>

#define EXPORT_RUNTIME_LITE_APIS

#include "ai_lite.h"
#include "ai_platform.h"

// #include "${name}_data.h"

#include "${name}_config.h"
#include "${name}_data_params.h"
#include "${name}_lite_functions.h"
#include "${name}_lite_io.h"

/* Global handle to reference the instantiated C-graph */
static lite_graph graph;

/* Global c-array to handle the activations buffer(s) */
% for idx, act in enumerate(activations):
AI_ALIGNED(32)
static ai_u8 activations_${loop.index+1}[AI_${name.upper()}_DATA_ACTIVATION_${loop.index+1}_SIZE];
% endfor 

/* Array to store the data of the input tensors */
% for idx, input in enumerate(inputs):
  % if allocate_inputs:
/* -> data_in_${loop.index+1} is allocated in activations buffer */
  % else:
AI_ALIGNED(32) static ai_i8 data_in_${loop.index+1}[LITE_${name.upper()}_IN_${loop.index+1}_SIZE_BYTES];
  % endif
% endfor

/* Array to store the data of the output tensors */
% for idx, output in enumerate(outputs):
  % if allocate_outputs:
/* -> data_out_${loop.index+1} is allocated in activations buffer */
  % else:
AI_ALIGNED(32) static ai_i8 data_out_${loop.index+1}[LITE_${name.upper()}_OUT_${loop.index+1}_SIZE_BYTES];
  % endif
% endfor


/* Array of pointer to manage the model's input/output buffers */

ai_handle input_buffers[] = {
 % for idx, input in enumerate(inputs):
   % if allocate_inputs:
   AI_HANDLE_PTR(NULL),
   % else:
  (ai_handle)&data_in_${loop.index+1},
   % endif
 % endfor
};

ai_handle output_buffers[] = {
 % for idx, input in enumerate(outputs):
   % if allocate_outputs:
   AI_HANDLE_PTR(NULL),
   % else:
  (ai_handle)&data_out_${loop.index+1},
   % endif
 % endfor
 };

/* 
 * Bootstrap
 */
int aiInit(void) {
  
  /* Create and initialize the c-model */
  const ai_handle activation_buffers[] = {
% for idx, act in enumerate(activations):
% if idx == len(activations) - 1: 
    activations_${loop.index+1}
% else:
    activations_${loop.index+1},
% endif
% endfor
  };
  
  ai_handle* weights = AI_NETWORK_DATA_WEIGHTS_TABLE_GET();

  graph.inputs = input_buffers;
  graph.outputs = output_buffers;
  graph.activations = activation_buffers;
  graph.weights = weights;

  return 0;
}

/* 
 * Run inference
 */
lite_result aiRun() {

  lite_result ok = run_lite_graph_1(&graph);  

  return ok;
}

/* 
 * Example of main loop function
 */
void main_loop() {

  aiInit();

  
  while (1) {
    /* 1 - Acquire, pre-process and fill the input buffers */
    // acquire_and_process_data(...);

    /* 2 - Call inference engine */
    aiRun();

    /* 3 - Post-process the predictions */
    // post_process(...);
  }
}

/* 
 * Example of system initialization function
 */
void SystemInit(void)
{

}

/* 
 * Example of main application function
 */
int main(int argc, char* argv[])
{
  SystemInit();
  main_loop();
  return 0;
}
