{#
  ******************************************************************************
  * @file    stai_network.j2.h
  * @brief   AI Tool Automatic Code Generator for Embedded NN computing
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2023 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  ******************************************************************************
#}
{%- set config = ir.get_solution().get_c_config() -%}
{%- set net_name = config['net_name'].lower() -%}
{%- set NET_NAME = config['net_name'].upper() -%}
{%- set graph = ir.get_network().get_graph() -%}

/**
  ******************************************************************************
  * @file    {{ net_name }}.h
  * @date    {{ config['date_time'] }}
  * @brief   ST.AI Tool Automatic Code Generator for Embedded NN computing
  ******************************************************************************
  * @attention
  *
  * {{ config['copyright'] }}
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  ******************************************************************************
  */
#ifndef STAI_{{ NET_NAME}}_DETAILS_H
#define STAI_{{ NET_NAME}}_DETAILS_H

#include "stai.h"
#include "layers.h"

const stai_network_details g_{{net_name}}_details = {
{%- set relevant_tensors = [] -%}
{%- set relevant_layers = [] -%}
{%- for _tensor in graph.get_tensors() -%}
{%- if _tensor.get_d_id() is not none-%}
{%- if relevant_tensors.append((_tensor.get_d_id(), _tensor)) -%}
{%- endif -%}
{%- endif -%}
{%- endfor %}
  .tensors = (const stai_tensor[{{ relevant_tensors|length }}]) {
{%- set sorted_relevant_tensors = dict.from_keys(relevant_tensors) -%}
{%- for _tensor_d_id in range(sorted_relevant_tensors|length) -%}
{%- set _tensor = sorted_relevant_tensors[_tensor_d_id] %}
   { {{cu.render_c_stai_tensor(_tensor)}} }{% if not loop.last %},{% endif %} 
{%- endfor -%}
{%- for layer in graph.get_layers() -%}
{%- if layer.get_internal_apis() -%}
{%- if relevant_layers.append(layer) -%}{%- endif -%}
{%- endif %}
{%- endfor %}
  },
  .nodes = (const stai_node_details[{{ relevant_layers|length }}]){
{%- for layer in relevant_layers -%}
{%- set tensors_in_d_ids = graph.get_predecessor_tensors_d_id(layer) %}
{%- set tensors_out_d_ids = graph.get_successor_tensors_d_id(layer) %}
    {.id = {{ layer.get_original_id() }}, .type = {{ ('AI_LAYER_' + layer.get_c_functions()[0] + '_TYPE').upper()}}, .input_tensors = {{cu.render_c_stai_array(tensors_in_d_ids) }}, .output_tensors = {{cu.render_c_stai_array(tensors_out_d_ids)}} }{% if not loop.last %},{% endif %} /* {{layer.get_name()}} */
{%- endfor %}
  },
  .n_nodes = {{ relevant_layers|length }}
};
#endif
