{#
  ******************************************************************************
  * @file    stai_network_data.j2.h
  * @author  AST Embedded Analytics Research Platform
  * @brief   AI Tool Automatic Code Generator for Embedded NN computing
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2023 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  ******************************************************************************
#}
{%- import 'network_layers.j2.c' as layers -%}
{% set _weights = config[layers.WEIGHTS] -%}
{% set data_module = config['data_module'].lower() -%}

/**
  ******************************************************************************
  * @file    {{ data_module }}.c
  * @author  AST Embedded Analytics Research Platform
  * @date    {{ config['date_time'] }}
  * @brief   AI Tool Automatic Code Generator for Embedded NN computing
  ******************************************************************************
  * {{ config['copyright'] }}
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  ******************************************************************************
  */

#include "{{ data_module }}.h"

{%- for buf in _weights['buffers']: %}
STAI_ALIGNED(8)
const {{ buf['buffer_c_type'] }} {{ buf['buffer_c_name'] }}[{{ buf['buffer_c_count'] }}] = {
{%- for line in buf['buffer_c_data']: %}
  {{ line|join(', ') }},
{%- endfor %}
};
{{ "" }}
{%- endfor %}
