{#
  ******************************************************************************
  * @file    stai_network.j2.h
  * @author  AST Embedded Analytics Research Platform
  * @brief   AI Tool Automatic Code Generator for Embedded NN computing
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2023 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  ******************************************************************************
#}
{%- import 'network_layers.j2.c' as layers -%}
{%- import 'stai_common.j2.c' as stai -%}
{%- set net_name = config['net_name'].lower() -%}
{%- set net_signature = config['net_signature'] -%}
{%- set NET_NAME = config['net_name'].upper() -%}
{%- set _activations = config[layers.ACTIVATIONS] -%}
{%- set _states = config[layers.STATES] -%}
{%- set _weights = config[layers.WEIGHTS] -%}

/**
  ******************************************************************************
  * @file    {{ net_name }}.h
  * @author  AST Embedded Analytics Research Platform
  * @date    {{ config['date_time'] }}
  * @brief   ST.AI Tool Automatic Code Generator for Embedded NN computing
  ******************************************************************************
  * @attention
  *
  * {{ config['copyright'] }}
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  ******************************************************************************
  */
#ifndef STAI_{{ NET_NAME }}_H
#define STAI_{{ NET_NAME }}_H

#include "stai.h"
#include "stai_debug.h"

/*****************************************************************************/
/*  Original model name and signature  */
#define STAI_{{ NET_NAME }}_ORIGIN_MODEL_NAME         "{{config['model_origin_name']}}"
#define STAI_{{ NET_NAME }}_ORIGIN_MODEL_SIGNATURE    "{{config['model_signature']}}"

/*  Generated model name and signature  */
#define STAI_{{ NET_NAME }}_MODEL_NAME                "{{net_name}}"
#define STAI_{{ NET_NAME }}_MODEL_SIGNATURE           ({{net_signature}})


/*****************************************************************************/
/*  Macros to declare network context size and required alignment  */
#define STAI_{{ NET_NAME }}_CONTEXT_ALIGNMENT   (8)
#define STAI_{{ NET_NAME }}_CONTEXT_SIZE        (sizeof(_stai_{{ net_name }}_context))

/*  Macro to declare network flags  */
#define STAI_{{ NET_NAME }}_FLAGS               ({{config['c_net_flags']}})

/*  Macro to declare number of network C nodes generated  */
#define STAI_{{ NET_NAME }}_NODES_NUM           ({{config[layers.LAYERS]|length}})

/*  Macro to declare number macc for generated network model  */
#define STAI_{{ NET_NAME }}_MACC_NUM            ({{config['Macc']}})

/*  Macros to declare input buffers characteristics  */
#define STAI_{{ NET_NAME }}_IN_NUM              ({{config['c_net_in']|length}})
#define STAI_{{ NET_NAME }}_IN_SIZE_BYTES       ({{config['c_net_in_size']}})

#define STAI_{{ NET_NAME }}_IN_ALIGNMENTS \
  { {%- for inp in config['c_net_in']: %} {{ inp['alignment'] }}{%-if not loop.last -%}, {%-endif-%}{%-endfor-%} }
#define STAI_{{ NET_NAME }}_IN_NAMES \
  { {%- for inp in config['c_net_in']: %} NULL{%-if not loop.last -%}, {%-endif-%}{%-endfor-%} }
#define STAI_{{ NET_NAME }}_IN_FORMATS \
  { {%- for _shape, _buffer in config['in_shapes']: %} {{ _buffer['fmt'].get_c_buffer_format(prefix='STAI') }}{%-if not loop.last -%},{%-endif-%}{%-endfor-%} }
#define STAI_{{ NET_NAME }}_IN_SIZES \
  { {%- for _shape, _buffer in config['in_shapes']: -%}{{ _shape.get_size() }}{%-if not loop.last -%}, {%-endif-%}{%-endfor-%} }
#define STAI_{{ NET_NAME }}_IN_SIZES_BYTES \
  { {%- for _shape, _buffer in config['in_shapes']: %}{{ _buffer['array_byte_size'] }}{%-if not loop.last -%}, {%-endif-%}{%-endfor-%} }

{%- for _shape, _buffer in config['in_shapes']: %}
{%- set _index = loop.index %}

#define STAI_{{ NET_NAME }}_IN_{{ _index }}_ALIGNMENT   ({{ config['c_net_in'][_index - 1]['alignment'] }})
#define STAI_{{ NET_NAME }}_IN_{{ _index }}_NAME        (NULL)
#define STAI_{{ NET_NAME }}_IN_{{ _index }}_FLAGS       ({{ config['c_net_in'][_index -1]['flags'] }})
#define STAI_{{ NET_NAME }}_IN_{{ _index }}_FORMAT      ({{ _buffer['fmt'].get_c_buffer_format(prefix='STAI') }})
#define STAI_{{ NET_NAME }}_IN_{{ _index }}_SHAPE       { {%- for _, _value in _buffer['dl_shape'].to_c():%}{{ _value }}{%-if not loop.last -%}, {%-endif-%}{%-endfor-%} }
{%- for _name, _value in _buffer['dl_shape'].to_c(prefix=''): %}
#define STAI_{{ NET_NAME }}_IN_{{ _index }}_{{ _name.ljust(11) }} ({{ _value }})
{%- endfor %}
#define STAI_{{ NET_NAME }}_IN_{{ _index }}_RANK        ({{ _shape.to_stai()[0] }})
#define STAI_{{ NET_NAME }}_IN_{{ _index }}_SIZE        ({{ _shape.get_size() }})
#define STAI_{{ NET_NAME }}_IN_{{ _index }}_SIZE_BYTES  ({{ _buffer['array_byte_size'] }})
{%- if _buffer['fmt'].get_scale() %}
#define STAI_{{ NET_NAME }}_IN_{{ _index }}_SCALE       ({{ _buffer['fmt'].get_scale()[0] }}f)
#define STAI_{{ NET_NAME }}_IN_{{ _index }}_ZERO_POINT  ({{ _buffer['fmt'].get_zero()[0] }})
{%- endif %}
{%- endfor %}

/*****************************************************************************/
/*  Macros to declare output buffers characteristics  */
#define STAI_{{ NET_NAME }}_OUT_NUM             ({{config['c_net_out']|length}})
#define STAI_{{ NET_NAME }}_OUT_SIZE_BYTES      ({{config['c_net_out_size']}})
#define STAI_{{ NET_NAME }}_OUT_ALIGNMENTS \
  { {%- for inp in config['c_net_out']: %} {{ inp['alignment'] }}{%-if not loop.last -%}, {%-endif-%}{%-endfor-%} }
#define STAI_{{ NET_NAME }}_OUT_NAMES \
  { {%- for inp in config['c_net_out']: %} NULL{%-if not loop.last -%}, {%-endif-%}{%-endfor-%} }
#define STAI_{{ NET_NAME }}_OUT_FORMATS \
  { {%- for _shape, _buffer in config['out_shapes']: %} {{ _buffer['fmt'].get_c_buffer_format(prefix='STAI') }}{%-if not loop.last -%},{%-endif-%} {%-endfor-%} }
#define STAI_{{ NET_NAME }}_OUT_SIZES \
  { {%- for _shape, _buffer in config['out_shapes']: %} {{ _shape.get_size() }}{%-if not loop.last -%}, {%-endif-%}{%-endfor-%} }
#define STAI_{{ NET_NAME }}_OUT_SIZES_BYTES \
  { {%- for _shape, _buffer in config['out_shapes']: %}{{ _buffer['array_byte_size']}}{%-if not loop.last -%}, {%-endif-%}{%-endfor-%} }


{%- for _shape, _buffer in config['out_shapes']: %}
{%- set _index = loop.index %}

#define STAI_{{ NET_NAME }}_OUT_{{ _index }}_ALIGNMENT   ({{ config['c_net_out'][_index - 1]['alignment'] }})
#define STAI_{{ NET_NAME }}_OUT_{{ _index }}_NAME        (NULL)
#define STAI_{{ NET_NAME }}_OUT_{{ _index }}_FLAGS       ({{ config['c_net_out'][_index -1]['flags'] }})
#define STAI_{{ NET_NAME }}_OUT_{{ _index }}_FORMAT      ({{ _buffer['fmt'].get_c_buffer_format(prefix='STAI') }})
#define STAI_{{ NET_NAME }}_OUT_{{ _index }}_SHAPE       { {%- for _, _value in _buffer['dl_shape'].to_c():%}{{ _value }}{%-if not loop.last -%}, {%-endif-%}{%-endfor-%} }
{%- for _name, _value in _buffer['dl_shape'].to_c(prefix=''): %}
#define STAI_{{ NET_NAME }}_OUT_{{ _index }}_{{ _name.ljust(11) }} ({{ _value }})
{%- endfor %}
#define STAI_{{ NET_NAME }}_OUT_{{ _index }}_RANK        ({{ _shape.to_stai()[0] }})
#define STAI_{{ NET_NAME }}_OUT_{{ _index }}_SIZE        ({{ _shape.get_values(_shape.get_shape_map()) | replace(',)', ')') | replace(',', ' *') }})
#define STAI_{{ NET_NAME }}_OUT_{{ _index }}_SIZE_BYTES  ({{ _buffer['array_byte_size'] }})
{%- if _buffer['fmt'].get_scale() %}
#define STAI_{{ NET_NAME }}_OUT_{{ _index }}_SCALE       ({{ _buffer['fmt'].get_scale()[0] }}f)
#define STAI_{{ NET_NAME }}_OUT_{{ _index }}_ZERO_POINT  ({{ _buffer['fmt'].get_zero()[0] }})
{%- endif %}
{%- endfor %}

/*****************************************************************************/
/*  Macros to declare activations buffers characteristics  */
{%- if _activations['size'] > 0 %}
#define STAI_{{ NET_NAME }}_ACTIVATIONS_SIZE              ({{ _activations['size'] }})
#define STAI_{{ NET_NAME }}_ACTIVATIONS_SIZE_BYTES        ({{ _activations['size'] }})
#define STAI_{{ NET_NAME }}_ACTIVATIONS_ALIGNMENTS \
  { {% for buf in _activations['buffers']: -%}{{ config['data_alignment'] }}{%-if not loop.last -%}, {%-endif-%}{% endfor -%} }
#define STAI_{{ NET_NAME }}_ACTIVATIONS_SIZES \
  { {% for buf in _activations['buffers']: -%}{{ buf['pool_size'] }}{%-if not loop.last -%}, {%-endif-%}{% endfor -%} }
#define STAI_{{ NET_NAME }}_ACTIVATIONS_NUM               ({{ _activations['buffers']|length }})

{% for buf in _activations['buffers']: -%}
#define STAI_{{ NET_NAME }}_ACTIVATION_{{loop.index}}_FLAGS      ({{ buf['flags'] }})
#define STAI_{{ NET_NAME }}_ACTIVATION_{{loop.index}}_SIZE       ({{ buf['pool_size'] }})
#define STAI_{{ NET_NAME }}_ACTIVATION_{{loop.index}}_SIZE_BYTES ({{ buf['pool_size'] }})
#define STAI_{{ NET_NAME }}_ACTIVATION_{{loop.index}}_ALIGNMENT  ({{ buf['alignment'] }})
{% endfor -%}
{% else %}
#define STAI_{{ NET_NAME }}_ACTIVATIONS_SIZE              (0)
#define STAI_{{ NET_NAME }}_ACTIVATIONS_SIZE_BYTES        (0)
#define STAI_{{ NET_NAME }}_ACTIVATIONS_ALIGNMENTS        {}
#define STAI_{{ NET_NAME }}_ACTIVATIONS_SIZES             { 0, }
#define STAI_{{ NET_NAME }}_ACTIVATIONS_NUM               (0)

#define STAI_{{ NET_NAME }}_ACTIVATION_1_SIZE             (0)
#define STAI_{{ NET_NAME }}_ACTIVATION_1_SIZE_BYTES       (0)
{% endif -%}

/*  Macros to declare weights buffers characteristics  */
{% if _weights['size'] > 0 %}
#define STAI_{{ NET_NAME }}_WEIGHTS_NUM                  ({{ _weights['buffers']|length }})
#define STAI_{{ NET_NAME }}_WEIGHTS_SIZE                  ({{ _weights['size'] }})
#define STAI_{{ NET_NAME }}_WEIGHTS_SIZE_BYTES            ({{ _weights['size'] }})
#define STAI_{{ NET_NAME }}_WEIGHTS_ALIGNMENTS \
  { {% for buf in _weights['buffers']: -%}{{ config['data_alignment'] }}{%-if not loop.last -%}, {%-endif-%}{% endfor -%} }
#define STAI_{{ NET_NAME }}_WEIGHTS_SIZES \
  { {% for buf in _weights['buffers']: -%}{{ buf['pool_size'] }}{%-if not loop.last -%}, {%-endif-%}{% endfor -%} }
#define STAI_{{ NET_NAME }}_WEIGHTS_NUM        ({{ _weights['buffers']|length }})
{% for buf in _weights['buffers']: -%}
#define STAI_{{ NET_NAME }}_WEIGHT_{{loop.index}}_FLAGS       ({{ buf['flags'] }})
#define STAI_{{ NET_NAME }}_WEIGHT_{{loop.index}}_SIZE        ({{ buf['pool_size'] }})
#define STAI_{{ NET_NAME }}_WEIGHT_{{loop.index}}_SIZE_BYTES  ({{ buf['pool_size'] }})
{% endfor -%}
{% else %}
#define STAI_{{ NET_NAME }}_WEIGHTS_SIZE         (0)
#define STAI_{{ NET_NAME }}_WEIGHTS_SIZE_BYTES   (0)
#define STAI_{{ NET_NAME }}_WEIGHTS_ALIGNMENTS   {}
#define STAI_{{ NET_NAME }}_WEIGHTS_SIZES        { 0, }

#define STAI_{{ NET_NAME }}_WEIGHTS_NUM          (0)
#define STAI_{{ NET_NAME }}_WEIGHT_1_SIZE        (0)
#define STAI_{{ NET_NAME }}_WEIGHT_1_SIZE_BYTES  (0)
{% endif %}

/*****************************************************************************/
/*  Macros to declare states buffers characteristics  */
{%- if _states['size'] > 0 %}
#define STAI_{{ NET_NAME }}_STATES_NUM              ({{ _states['buffers']|length }})
#define STAI_{{ NET_NAME }}_STATES_SIZE              ({{ _states['size'] }})
#define STAI_{{ NET_NAME }}_STATES_SIZE_BYTES        ({{ _states['size'] }})
#define STAI_{{ NET_NAME }}_STATES_ALIGNMENTS \
  { {% for buf in _states['buffers']: -%}{{ buf['alignment'] }}{%-if not loop.last -%}, {%-endif-%}{% endfor -%} }
#define STAI_{{ NET_NAME }}_STATES_SIZES \
  { {% for buf in _states['buffers']: -%}{{ buf['pool_size'] }}{%-if not loop.last -%}, {%-endif-%}{% endfor -%} }
#define STAI_{{ NET_NAME }}_STATES_NUM         ({{ _states['buffers']|length }})

{% for buf in _states['buffers']: -%}
#define STAI_{{ NET_NAME }}_STATE_{{loop.index}}_FLAGS      ({{ buf['flags'] }})
#define STAI_{{ NET_NAME }}_STATE_{{loop.index}}_ALIGNMENT  ({{ buf['alignment'] }})
#define STAI_{{ NET_NAME }}_STATE_{{loop.index}}_SIZE       ({{ buf['pool_size'] }})
#define STAI_{{ NET_NAME }}_STATE_{{loop.index}}_SIZE_BYTES ({{ buf['pool_size'] }})
{% endfor -%}
{% else %}
#define STAI_{{ NET_NAME }}_STATES_SIZE              (0)
#define STAI_{{ NET_NAME }}_STATES_SIZE_BYTES        (0)
#define STAI_{{ NET_NAME }}_STATES_ALIGNMENTS        {}
#define STAI_{{ NET_NAME }}_STATES_SIZES             { 0, }
#define STAI_{{ NET_NAME }}_STATES_NUM               (0)

#define STAI_{{ NET_NAME }}_STATE_1_FLAGS            (0x0)
#define STAI_{{ NET_NAME }}_STATE_1_ALIGNMENT        (4)
#define STAI_{{ NET_NAME }}_STATE_1_SIZE             (0)
#define STAI_{{ NET_NAME }}_STATE_1_SIZE_BYTES       (0)
{% endif -%}

/*****************************************************************************/
STAI_API_DECLARE_BEGIN

/*****************************************************************************/
/** Network private context: DO NOT EDIT NOR access this struct directly    **/
/*****************************************************************************/
/**
 * @brief Private internal context C struct definition
 * @details this is the C struct defining the internal context of the generated network.
 *          this struct must be allocated by applications as a byte array of a given size,
 *          but MUST not be accessed directly by application. It must be manipulated / queried only
 *          using st.ai APIs.
 */
typedef struct {
  uint32_t                     _magic;
  uint64_t                     _signature;
  stai_flags                   _flags;
  stai_return_code             _return_code;
  stai_event_cb                _callback;
  void*                        _callback_cookie;

{%- if _activations['size'] > 0 %}
  stai_ptr                     _activations[STAI_{{ NET_NAME }}_ACTIVATIONS_NUM];
{%- endif -%}
{%- if _states['size'] > 0 %}
  stai_ptr                     _states[STAI_{{ NET_NAME }}_STATES_NUM];
{%- endif -%}
{%- if _weights['size'] > 0 %}
  stai_ptr                     _weights[STAI_{{ NET_NAME }}_WEIGHTS_NUM];
{%- endif %}
  stai_ptr                     _inputs[STAI_{{ NET_NAME }}_IN_NUM];
  stai_ptr                     _outputs[STAI_{{ NET_NAME }}_OUT_NUM];
} _stai_{{net_name}}_context;


/*****************************************************************************/
/*  Network run management APIs Section  */

/**
 * @brief Initialize the network internal context
 * @details The application must provide the memory area where to initialize the internal network context as an opaque
 *          handler named network.
 *          Application must never access directly the directly the context but it must be accessed only with
 *          associates stai APIs. Application knows network context size by using macro
 *          @ref STAI_{{ NET_NAME}}_CONTEXT_SIZE or @ref stai_{{ net_name }}_get_context_size(void) API
 * @param[in] network network context opaque pointer
 * @return STAI_SUCCESS on correct initialization, else 1st error return code from @ref stai_return_code enums.
 */
STAI_API_ENTRY
stai_return_code stai_{{net_name}}_init(
  stai_network* network);


/**
 * @brief Deinitialize the network internal context
 * @details The application must provide the memory area where to initialize the internal network context as an opaque
 *          handler named netwrok.
 *          Application must never access directly the directly the context but it must be accessed only with
 *          associates stai APIs.
 * @param[in] network network context opaque pointer
 * @return STAI_SUCCESS on correct de-initialization, else 1st error return code from @ref stai_return_code enums.
 */
STAI_API_ENTRY
stai_return_code stai_{{net_name}}_deinit(
  stai_network* network);


/**
 * @brief Runs the network model inference on a single input sample
 * @details This API runs a newtwork inference. Network input data is expected to be available in expected format
 *          on the input buffers whose memory adresses are retrived using @ref stai_{{ net_name }}_get_inputs() API.
 *          Alternatively the application could allocate the inputs and set the addresses using the
 *          @ref stai_{{ net_name }}_set_inputs() API. Similar behaviour is expected for the network outputs handling.
 *          The features of each input / output buffer (format, byte size, etc.)may be queried using
 *          @ref stai_{{ net_name }}_get_info() API or the set of specific macros available in this header file.
 *          When mode is MODE_SYNC the call to this API is blocking untile the end of the inference. In ASYNC_MODE the
 *          API will exit before the completion of the inference by returning the current state of the inference. It
 *          could be also used to query wether or not the inference has been completed.
 *          After completions of run API the results of the network inference may be retrieved at addresses returned by
 *          @ref stai_{{ net_name }}_get_outputs() API.
 * @param[in] network network context opaque pointer
 * @param[in] mode the modality used to run the network. It may be synchronous (MODE_SYNC) or asyncronous (MODE_ASYNC).
 *            see @ref stai_run_mode enum
 * @return STAI_SUCCESS on correct run, else error 1st return code from @ref stai_return_code enums.
 */
STAI_API_ENTRY
stai_return_code stai_{{net_name}}_run(
  stai_network* network,
  const stai_run_mode mode);


/*****************************************************************************/
/*  Getters APIs Section  */

/**
 * @brief Returns the newtwork context size (in bytes)
 * @details This API is used to return the size in byte of the network internal context. The st.ai APIs could support
 *          multiple network contexts, thus tt is expected that the network context is always allocated by application
 *          but MUST be handled / queried / managed only by using st.ai APIs
 * @return the network context size in bytes
 */
STAI_API_ENTRY
stai_size stai_{{ net_name }}_get_context_size(void);


/**
 * @brief Get the relevant info for the C generated network model.
 * @details See @ref stai_network_info C struct.
 * @param[in] network network context opaque pointer
 * @param[out] info a pointer to a @ref stai_network_info data struct
 * @return STAI_SUCCESS on correct run, else error 1st return code from @ref stai_return_code enums.
 */
STAI_API_ENTRY
stai_return_code stai_{{ net_name }}_get_info(
  stai_network* network,
  stai_network_info* info);


/**
 * @brief Get the activations buffers addresses.
 * @details as an array of pointers of size n_activations
 * @param[in] network network context opaque pointer
 * @param[out] activations an array of pointers reporting the addresses of all the activation buffers
 * @param[out] n_activations the number of the network activations (i.e. the size of the activations array)
 * @return STAI_SUCCESS if successfull, else error 1st return code from @ref stai_return_code enums.
 * @note activations array pointers are passed by copy
 */
STAI_API_ENTRY
stai_return_code stai_{{ net_name }}_get_activations(
  stai_network* network,
  stai_ptr* activations,
  stai_size* n_activations);


/**
 * @brief Get the weights buffers addresses.
 * @details as an array of pointers of size n_weights
 * @param[in] network network context opaque pointer
 * @param[out] weights an array of pointers reporting the addresses of all the weights buffers
 * @param[out] n_weights the number of the network weights (i.e. the size of the weights array)
 * @return STAI_SUCCESS if successfull, else error 1st return code from @ref stai_return_code enums.
 * @note weights array pointers are passed by copy
 */
STAI_API_ENTRY
stai_return_code stai_{{ net_name }}_get_weights(
  stai_network* network,
  stai_ptr* weights,
  stai_size* n_weights);


/**
 * @brief Get the network inputs buffers addresses.
 * @details as an array of pointers of size n_inputs
 * @param[in] network network context opaque pointer
 * @param[out] inputs an array of pointers reporting the addresses of all the network inputs buffers
 * @param[out] n_inputs the number of the network inputs (i.e. the size of the inputs array)
 * @return STAI_SUCCESS if successfull, else error 1st return code from @ref stai_return_code enums.
 * @note inputs array pointers are passed by copy
 */
STAI_API_ENTRY
stai_return_code stai_{{ net_name }}_get_inputs(
  stai_network* network,
  stai_ptr* inputs,
  stai_size* n_inputs);


/**
 * @brief Get the network outputs buffers addresses.
 * @details as an array of pointers of size n_outputs
 * @param[in] network network context opaque pointer
 * @param[out] outputs an array of pointers reporting the addresses of all the network outputs buffers
 * @param[out] n_outputs the number of the network outputs (i.e. the size of the outputs array)
 * @return STAI_SUCCESS if successfull, else error 1st return code from @ref stai_return_code enums.
 * @note outputs array pointers are passed by copy
 */
STAI_API_ENTRY
stai_return_code stai_{{ net_name }}_get_outputs(
  stai_network* network,
  stai_ptr* outputs,
  stai_size* n_outputs);


/**
 * @brief Get the network internal states buffers addresses.
 * @details as an array of pointers of size n_states. Optional API for stateful newtorks. It gets the
 *          addresses of persistent internal states of the network. This APIs allows an application to manage
 *          stateful buffers (e.g. to save them). State buffers may be set back using
 *          @ref stai_{{ net_name }}_set_states() dual API
 * @param[in] network network context opaque pointer
 * @param[out] states an array of pointers reporting the addresses of all the network internal states buffers
 * @param[out] n_states the number of the network internal states (i.e. the size of the states array)
 * @return STAI_SUCCESS if successfull, else error 1st return code from @ref stai_return_code enums.
 * @note outputs array pointers are passed by copy
 */
STAI_API_ENTRY
stai_return_code stai_{{ net_name }}_get_states(
  stai_network* network,
  stai_ptr* states,
  stai_size* n_states);


/**
 * @brief Get the newtork error state.
 * @details In particular it return STAI_SUCCESS if no errors encountered during APIs orchestration, otherwise this
 *          API return the 1st error generated.
 * @param[in] network network context opaque pointer
 * @return STAI_SUCCESS if no errors, else the 1st error generated.
 */
STAI_API_ENTRY
stai_return_code stai_{{ net_name }}_get_error(
  stai_network* network);


/*****************************************************************************/
/*  Setters APIS Section  */

/**
 * @brief Set the activations buffers addresses.
 * @details activations buffers are provides as as an array of pointers of size n_activations
 * @param[in] network network context opaque pointer
 * @param[in] activations an array of pointers reporting the addresses of all the activation buffers
 * @param[in] n_activations the number of the network activations (i.e. the size of the activations array)
 * @return STAI_SUCCESS if successfull, else error 1st return code from @ref stai_return_code enums.
 * @note activations array pointers are passed by copy
 */
STAI_API_ENTRY
stai_return_code stai_{{net_name}}_set_activations(
  stai_network* network,
  const stai_ptr* activations,
  const stai_size n_activations);


/**
 * @brief Set the weights buffers addresses.
 * @details weights buffers are provides as as an array of pointers of size n_weights
 * @param[in] network network context opaque pointer
 * @param[in] weights an array of pointers reporting the addresses of all the weights buffers
 * @param[in] n_weights the number of the network weights (i.e. the size of the weights array)
 * @return STAI_SUCCESS if successfull, else error 1st return code from @ref stai_return_code enums.
 * @note weights array pointers are passed by copy
 */
STAI_API_ENTRY
stai_return_code stai_{{ net_name }}_set_weights(
  stai_network* network,
  const stai_ptr* weights,
  const stai_size n_weights);


/**
 * @brief Set the network inputs buffers addresses.
 * @details network inputs buffers are provides as as an array of pointers of size n_inputs
 * @param[in] network network context opaque pointer
 * @param[in] inputs an array of pointers reporting the addresses of all the network inputs buffers
 * @param[in] n_inputs the number of the network inputs (i.e. the size of the inputs array)
 * @return STAI_SUCCESS if successfull, else error 1st return code from @ref stai_return_code enums.
 * @note inputs array pointers are passed by copy
 */
STAI_API_ENTRY
stai_return_code stai_{{ net_name }}_set_inputs(
  stai_network* network,
  const stai_ptr* inputs,
  const stai_size n_inputs);


/**
 * @brief Set the network outputs buffers addresses.
 * @details network outputs buffers are provides as as an array of pointers of size n_inputs
 * @param[in] network network context opaque pointer
 * @param[in] outputs an array of pointers reporting the addresses of all the network outputs buffers
 * @param[in] n_outputs the number of the network outputs (i.e. the size of the outputs array)
 * @return STAI_SUCCESS if successfull, else error 1st return code from @ref stai_return_code enums.
 * @note outputs array pointers are passed by copy
 */
STAI_API_ENTRY
stai_return_code stai_{{ net_name }}_set_outputs(
  stai_network* network,
  const stai_ptr* outputs,
  const stai_size n_outputs);


/**
 * @brief Set the network internal states buffers addresses.
 * @details network states buffers are provides as as an array of pointers of size n_states
 * @param[in] network network context opaque pointer
 * @param[in] states an array of pointers reporting the addresses of all the network internal states buffers
 * @param[in] n_states the number of the network states (i.e. the size of the states array)
 * @return STAI_SUCCESS if successfull, else error 1st return code from @ref stai_return_code enums.
 * @note states array pointers are passed by copy
 */
STAI_API_ENTRY
stai_return_code stai_{{ net_name }}_set_states(
  stai_network* network,
  const stai_ptr* states,
  const stai_size n_states);


/**
 * @brief Set a callback function to inspect network activation buffers.
 * @details this is an API to retrieve the content on intermediate activations buffers while executing the
 *          @ref stai_{{net_name}}_run() API. It is a helper routine that could be used by an application for debug
 *          and / or benchmarking intermadiate results of the network.
 * @param[in] network network context opaque pointer
 * @param[in] cb a function pointer to the inspection callback routine. See @ref stai_event_cb function pointer for
 *            a definition of the callback API.
 * @param[in] cb_cookie an opaque pointer to an application memory buffer and / or variable.
 * @return STAI_SUCCESS if successfull, else error 1st return code from @ref stai_return_code enums.
 */
STAI_API_ENTRY
stai_return_code stai_{{ net_name }}_set_callback(
  stai_network* network,
  const stai_event_cb cb,
  void* cb_cookie);

{% if 0 -%}

/***************************************************************************/
/**  Extended Target Specific APIs Section  **/


/*** Asynchronous Execution ***/
/**
 * @brief continue network execution of an asynchronously started/run network (i.e. network was started/run in `stai_run_mode::MODE_ASYNC` mode)
 * @details Running a network in asynchronous mode (see function `stai_{{ net_name }}_run()` and its parameter `mode` being equal to `stai_run_mode::MODE_ASYNC`)
 *          means that `stai_{{ net_name }}_run()` returns while the network is still in execution. In this case the user may not call
 *          `stai_{{ net_name }}_run()` again until the network's execution has actually finish.
 *          Therefore, we need to have two new API functions, one that provides the execution status of the currently running network (`get_nn_execution_status()`),
 *          and one which triggers the continuation of the network execution (`continue_nn_execution()`).
 * @details While the asynchronously started network is in execution the user may call any application specific code.
 *          When she/he has finished to do so she/he should call `get_nn_execution_status()` and act as described for the different `execution_status` values
 *          returned ny the call of `get_nn_execution_status()`.
 * @param[in] network network context opaque pointer
 * @return error or return code
 *
 * @note the number of samples of asynchronous runs (parameter `stai_size n_samples` of function `stai_{{ net_name }}_run()`) is restricted to `1`!
 * @note enum `stai_return_code` might need to be extended to better represent errors of new API functions,
 *       in this case e.g. an enum value specifying that the provided network handle does not identify the currently running network,
 *       and one that informs about a still running network execution (for function `stai_{{ net_name }}_run()`).
 */
STAI_API_ENTRY
stai_return_code stai_ext_{{ net_name }}_run_continue(stai_network* network);

/**
 * @brief continue network execution of an asynchronously started/run network (i.e. network was started/run in `stai_run_mode::MODE_ASYNC` mode)
 * @details Running a network in asynchronous mode (see function `stai_{{ net_name }}_run()` and its parameter `mode` being equal to `stai_run_mode::MODE_ASYNC`)
 *          means that `stai_{{ net_name }}_run()` returns while the network is still in execution. In this case the user may not call
 *          `stai_{{ net_name }}_run()` again until the network's execution has actually finish.
 *          Therefore, we need to have two new API functions, one that provides the execution status of the currently running network (`get_nn_execution_status()`),
 *          and one which triggers the continuation of the network execution (`continue_nn_execution()`).
 * @details While the asynchronously started network is in execution the user may call any application specific code.
 *          When she/he has finished to do so she/he should call `get_nn_execution_status()` and act as described for the different `execution_status` values
 *          returned ny the call of `get_nn_execution_status()`.
 * @param[in] network network handle
 * @return error code
 *
 * @note the number of samples of asynchronous runs (parameter `stai_size n_samples` of function `stai_{{ net_name }}_run()`) is restricted to `1`!
 * @note enum `stai_return_code` might need to be extended to better represent errors of new API functions,
 *       in this case e.g. an enum value specifying that the provided network handle does not identify the currently running network,
 *       and one that informs about a still running network execution (for function `stai_{{ net_name }}_run()`).
 */
STAI_API_ENTRY
stai_return_code stai_ext_{{ net_name }}_get_nn_run_status(stai_network* network);

{%- endif %}

STAI_API_DECLARE_END

#endif    /* STAI_{{NET_NAME}}_H */
{{ "" }}
