{#
  *****************************************************************************
  * @file    op_lite_io.j2.h
  * @author  AST Embedded Analytics Research Platform
  * @brief   AI Tool Automatic Code Generator for Embedded NN computing
  *****************************************************************************
  * @attention
  *
  * Copyright (c) 2022 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *****************************************************************************
#}
{%- import 'op_lite_common.j2.c' as lite -%}
{%- set net_name = config['net_name'].lower() -%}
{%- set NET_NAME = config['net_name'].upper() -%}
{%- set lite_graphs = config[lite.LITE_GRAPHS] -%}
{%- set file_name = config[lite.LITE_GRAPHS]['file_io_name'] -%}
/**
  *****************************************************************************
  * @file    {{ file_name }}.h
  * @author  AST Embedded Analytics Research Platform
  * @date    {{ config['date_time'] }}
  * @brief   AI Tool Automatic Code Generator for Embedded NN computing
  *****************************************************************************
  * @attention
  *
  * {{ config['copyright'] }}
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *****************************************************************************
  */

#ifndef {{ file_name.upper() }}_H
#define {{ file_name.upper() }}_H

#include "ai_platform.h"

/*****************************************************************************/
#define LITE_{{ NET_NAME }}_MODEL_NAME          "{{ config['model_name'] }}"
#define LITE_{{ NET_NAME }}_ORIGIN_MODEL_NAME   "{{ config['model_origin_name'] }}"

/*****************************************************************************/
#define LITE_{{ NET_NAME }}_IN_NUM        ({{ config['c_net_in']|length }})


#define LITE_{{ NET_NAME }}_IN_SIZE { \
{%- for tensor in config['c_net_in']: %}
  LITE_{{ NET_NAME }}_IN_{{ loop.index }}_SIZE, \
{%- endfor %}
}
#define LITE_{{ NET_NAME }}_IN_SIZE_BYTES { \
{%- for tensor in config['c_net_in']: %}
  LITE_{{ NET_NAME }}_IN_{{ loop.index }}_SIZE_BYTES, \
{%- endfor %}
}

{%- for _shape, _buffer in config['in_shapes']: %}
{%- set _index = loop.index %}
#define LITE_{{ NET_NAME }}_IN_{{ _index }}_FORMAT      ({{ _buffer['fmt'].get_c_buffer_format() }})
{%- for _name, _value in _shape.to_c(prefix=''): %}
#define LITE_{{ NET_NAME }}_IN_{{ _index }}_{{ _name.ljust(11) }} ({{ _value }})
{%- endfor %}
#define LITE_{{ NET_NAME }}_IN_{{ _index }}_SIZE        ({{ _shape.get_size() }})
#define LITE_{{ NET_NAME }}_IN_{{ _index }}_SIZE_BYTES  ({{ _buffer['array_byte_size'] }})
{%- endfor %}

/*****************************************************************************/
#define LITE_{{ NET_NAME }}_OUT_NUM       ({{ config['c_net_out']|length }})


#define LITE_{{ NET_NAME }}_OUT_SIZE { \
{%- for tensor in config['c_net_out']: %}
  LITE_{{ NET_NAME }}_OUT_{{ loop.index }}_SIZE, \
{%- endfor %}
}
#define LITE_{{ NET_NAME }}_OUT_SIZE_BYTES { \
{%- for tensor in config['c_net_out']: %}
  LITE_{{ NET_NAME }}_OUT_{{ loop.index }}_SIZE_BYTES, \
{%- endfor %}
}

{%- for _shape, _buffer in config['out_shapes']: %}
{%- set _index = loop.index %}
#define LITE_{{ NET_NAME }}_OUT_{{ _index }}_FORMAT      ({{ _buffer['fmt'].get_c_buffer_format() }})
{%- for _name, _value in _shape.to_c(prefix=''): %}
#define LITE_{{ NET_NAME }}_OUT_{{ _index }}_{{ _name.ljust(11) }} ({{ _value }})
{%- endfor %}
#define LITE_{{ NET_NAME }}_OUT_{{ _index }}_SIZE        ({{ _shape.get_size() }})
#define LITE_{{ NET_NAME }}_OUT_{{ _index }}_SIZE_BYTES  ({{ _buffer['array_byte_size'] }})
{%- endfor %}


#endif /* {{ file_name.upper() }}_H */
{{ "" }}
