{#
  ******************************************************************************
  * @file    op_lite_functions.j2.h
  * @author  AST Embedded Analytics Research Platform
  * @brief   AI Tool Automatic Code Generator for Embedded NN computing
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2022 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  ******************************************************************************
#}
{%- import 'network_layers.j2.c' as layers -%}
{%- import 'op_lite_common.j2.c' as lite -%}
{% set NET_NAME = config['net_name'].upper() -%}
{% set lite_graphs = config[lite.LITE_GRAPHS] -%}
{% set file_name = config[lite.LITE_GRAPHS]['file_name'] -%}
{% set _activations = config[layers.ACTIVATIONS] -%}
{% set _weights = config[layers.WEIGHTS] -%}

/**
  ******************************************************************************
  * @file    {{ file_name }}.h
  * @author  AST Embedded Analytics Research Platform
  * @date    {{ config['date_time'] }}
  * @brief   AI Tool Automatic Code Generator for Embedded NN computing
  ******************************************************************************
  * @attention
  *
  * {{ config['copyright'] }}
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  ******************************************************************************
  */

#ifndef {{ file_name.upper() }}_H
#define {{ file_name.upper() }}_H

#include "ai_platform.h"
#include "ai_lite_interface.h"

#define EXPORT_RUNTIME_APIS
#define EXPORT_RUNTIME_LITE_APIS

#ifdef EXPORT_RUNTIME_APIS
#include "ai_platform_interface.h"
#endif


/*****************************************************************************/
{% if _activations['size'] > 0 %}
#define LITE_{{ NET_NAME }}_DATA_ACTIVATIONS_ALIGNMENT   ({{ _activations['alignment'] }})

#define LITE_{{ NET_NAME }}_DATA_ACTIVATIONS_SIZES \
  { {% for buf in _activations['buffers']: -%}{{ buf['pool_size'] }}, {% endfor -%} }
#define LITE_{{ NET_NAME }}_DATA_ACTIVATIONS_COUNT    ({{ _activations['buffers']|length }})
{% else %}
#define LITE_{{ NET_NAME }}_DATA_ACTIVATIONS_SIZES    { 0, }
#define LITE_{{ NET_NAME }}_DATA_ACTIVATIONS_COUNT    (0)
{% endif %}

{% if _weights['size'] > 0 %}
#define LITE_{{ NET_NAME }}_DATA_WEIGHTS_SIZES \
  { {% for buf in _weights['buffers']: -%}{{ buf['pool_size'] }}, {% endfor -%} }
#define LITE_{{ NET_NAME }}_DATA_WEIGHTS_COUNT        ({{ _weights['buffers']|length }})
{% else %}
#define LITE_{{ NET_NAME }}_DATA_WEIGHTS_SIZES        { 0, }
#define LITE_{{ NET_NAME }}_DATA_WEIGHTS_COUNT        (0)
{% endif %}

/*****************************************************************************/

#ifdef EXPORT_RUNTIME_LITE_APIS
{{ lite.lite_functions_declaration(lite_graphs) }}
#endif   /* EXPORT_RUNTIME_LITE_APIS */

#ifdef EXPORT_RUNTIME_APIS
{{ lite.lite_forward_declaration(lite_graphs) }}
#endif  /* EXPORT_RUNTIME_APIS */

#endif /* {{ file_name.upper() }}_H */
{{ "" }}
