{#
  ******************************************************************************
  * @file    op_lite_functions.j2.c
  * @author  AST Embedded Analytics Research Platform
  * @brief   AI Tool Automatic Code Generator for Embedded NN computing
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2022 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  ******************************************************************************
#}
{%- import 'op_lite_common.j2.c' as lite -%}
{%- set lite_graphs = config[lite.LITE_GRAPHS] -%}
{%- set net_name = config['net_name'].lower() -%}
{%- set file_name = lite_graphs['file_name'] -%}
/**
  ******************************************************************************
  * @file    {{ file_name }}.c
  * @author  AST Embedded Analytics Research Platform
  * @date    {{ config['date_time'] }}
  * @brief   AI Tool Automatic Code Generator for Embedded NN computing
  ******************************************************************************
  * @attention
  *
  * {{ config['copyright'] }}
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  ******************************************************************************
  */
#include "ai_lite_inspect.h"
{{ lite.include_lite(net_name, lite_graphs) }}
{%- for file in lite_graphs['includes']: %}
#include "{{ file }}"
{% endfor -%}

{%- if config['hybrid_lite']['layers'] -%}
#include "{{ config['net_name']}}_hybrid_lite.h"
{% endif -%}

#ifdef EXPORT_RUNTIME_APIS
#include "layers_lite_graph.h"
#endif

#ifdef EXPORT_RUNTIME_LITE_APIS
#define LITE_CODEGEN_API_ENTRY      LITE_API_ENTRY
#else
#define LITE_CODEGEN_API_ENTRY      LITE_FORCE_INLINE
#endif

{{ lite.lite_functions_body(lite_graphs) }}

#ifdef EXPORT_RUNTIME_APIS

{{ lite.lite_forward_body(lite_graphs) }}

#endif  /* EXPORT_RUNTIME_APIS */

#undef LITE_CODEGEN_API_ENTRY
{{ "" }}
