{#
  ******************************************************************************
  * @file    op_lite_common.j2.c
  * @author  AST Embedded Analytics Research Platform
  * @brief   AI Tool Automatic Code Generator for Embedded NN computing
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2022 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  ******************************************************************************
#}
{% set LITE_GRAPHS = 'lite_graphs' -%}

{# Lite Global Declarations #}

{% macro include_lite(net_name, conf) -%}
{% if conf -%}
#include "{{ conf['file_name'] }}.h"
{%- endif -%}
{%- endmacro -%}

{# Code Generation Macros #}
{%- macro hybrid_lite_render_functions(layers, args, declare_only, NET_NAME) -%}
/**  Hybrid layers declarations section  *************************************/
{%- for layer in layers %}
{%- if not layer['layer']['is_wrapped'] %}
{%- if declare_only %}
void {{ layer['lite_function'] }}({{ args }});
{%- else %}
void {{ layer['lite_function'] }}({{ args }})
{
{%- for array_name, array_dict in layer['array_init'].items() %}
  {{ array_name }}.data = AI_PTR({{ array_dict['offset'] }});
  {{ array_name }}.data_start = AI_PTR({{ array_dict['start_offset'] }});
{%- endfor %}
  _STAI_{{ NET_NAME }}_EVENT_NODE_START_CB({{ layer['layer']['tags']['c_layer_id']}}, {{layer['layer']['tensor_chain']['input']|length}}, { {%for inp_ in layer['layer']['tensor_chain']['input']%}{{inp_[1:]}}.data->data{%- if not loop.last -%}, {%- endif -%}{% endfor %}});
  {{ layer['forward'] }}( {%-if layer['forward'].startswith('node_convert') -%}(ai_node *) {%- endif -%} &{{ layer['layer']['layer_name'] }});
  _STAI_{{ NET_NAME }}_EVENT_NODE_STOP_CB({{ layer['layer']['tags']['c_layer_id']}}, {{layer['layer']['tensor_chain']['output']|length}}, { {%for out_ in layer['layer']['tensor_chain']['output']%}{{out_[1:]}}.data->data{%- if not loop.last -%}, {%- endif -%}{% endfor %}});
}
{%- endif %}
{%- endif %}
{%- endfor %}
{%- endmacro -%}


{%- macro lite_render_args(args, sep=', ', prefix='', postfix='') -%}
{% if args %}{{ prefix }}{{ args|join(sep) }}{{ postfix }}{% endif %}
{%- endmacro -%}


{%- macro lite_render_func(func) -%}
{%- if 'declares' in func -%}
  {% for declare in func['declares']: -%}
    {{ lite_render_args(declare, '\n    ', '  ') }}
  {% endfor -%}
{%- endif %}
  {{ lite_render_args(func['outputs'], ', ', '', ' = ') }}{{ func['name'] }}({{ lite_render_args(func['args']) }});
{%- endmacro -%}

{%- macro lite_render_section(section) -%}
  /* LITE_KERNEL_SECTION BEGIN {{ section['name'] }} */
  {
{%- for func in section['funcs']: %}
    {{ lite_render_func(func) }}
{%- endfor %}
  }
  /* LITE_KERNEL_SECTION END {{ section['name'] }} */
{%- endmacro %}

{# Lite Functions Declarations #}
{%- macro lite_functions_declaration(conf) -%}
{%- for graph in conf['graphs']: %}
LITE_API_ENTRY
lite_result run_{{ graph['name'] }}(lite_graph* graph);
{% endfor -%}
{%- endmacro -%}

{%- macro lite_forward_declaration(conf) -%}
{%   for graph in conf['graphs']: %}
AI_INTERNAL_API
void forward_{{ graph['name'] }}(ai_layer* layer);
{%   endfor -%}
{%- endmacro -%}


{# Lite Functions Implementation #}
{%- macro lite_functions_body(conf) -%}
{%- for graph in conf['graphs']: %}
LITE_CODEGEN_API_ENTRY
lite_result run_{{ graph['name'] }}(lite_graph* graph)
{
  if (!graph) return LITE_KO_GRAPH;
  if (!(graph->inputs && graph->inputs[0])) return LITE_KO_INPUTS;
  if (!(graph->outputs && graph->outputs[0])) return LITE_KO_OUTPUTS;
  if (graph->activations && (!graph->activations[0])) return LITE_KO_ACTIVATIONS;
  if (graph->weights && (!graph->weights[0])) return LITE_KO_WEIGHTS;

  LITE_GRAPH_START("{{ graph['name'] }}")
  {% for section in graph['sections']: -%}
  {{ lite_render_section(section) }}
  {% endfor -%}
  LITE_GRAPH_END("{{ graph['name'] }}")

  return LITE_OK;
}
{% endfor -%}
{%- endmacro -%}

{%- macro lite_forward_body(conf) -%}
{%- for graph in conf['graphs']: %}
AI_INTERNAL_API
void forward_{{ graph['name'] }}(ai_layer* layer)
{
  LITE_LAYER_ACQUIRE(l, lite_graph, layer)

  ai_handle p_inputs[{{ graph['args']['inputs']|length }}] = {
    {% for elem in graph['args']['inputs']: -%}
    LITE_ARRAY_DATA(LITE_TENSOR_ARRAY(LITE_TENSOR_IN(l->tensors, {{ elem }}), 0), void),
    {% endfor -%}
  };
  ai_handle p_outputs[{{ graph['args']['outputs']|length }}] = {
    {% for elem in graph['args']['outputs']: -%}
    LITE_ARRAY_DATA(LITE_TENSOR_ARRAY(LITE_TENSOR_OUT(l->tensors, {{ elem }}), 0), void),
    {% endfor -%}
  };

  lite_graph graph = LITE_GRAPH_INIT(
    p_inputs, p_outputs, l->activations_map, l->weights_map, l->network->lite_cb, NULL);
  const lite_result ok = run_{{ graph['name'] }}(&graph);

  LITE_ASSERT(ok == LITE_OK)
  LITE_UNUSED(ok)

  LITE_LAYER_RELEASE(l, lite_graph)
}
{% endfor -%}
{%- endmacro -%}
