{#
  ******************************************************************************
  * @file    network.j2.h
  * @author  MCD/AIS Team
  * @brief   network.h template for Neural-Art network with legacy api
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2025  STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  ******************************************************************************
#}
{% set net_name = config['net_name'].lower() %}
{% set NET_NAME = config['net_name'].upper() %}


{#-
Macro to render buffer description (show size, alignment etc...)
Inputs: 
  - Buffer list
  - Suffix for defines names (IN or OUT)
#}
{% macro render_buffers(buff_list, IO) %}
{% for buffer in buff_list: %}
{% set bufnum = loop.index %}
// {{ IO | capitalize}}put buffer {{ bufnum }} -- {{ buffer['name'] }}
#define LL_ATON_{{ NET_NAME }}_{{ IO }}_{{ bufnum }}_ALIGNMENT   ({{ buffer['alignment_bytes'] }})
#define LL_ATON_{{ NET_NAME }}_{{ IO }}_{{ bufnum }}_SIZE_BYTES  ({{ buffer['size_bytes'] }})
{# // REMOVED IN THE CURRENT IMPLEMENTATION
#define LL_ATON_{{ NET_NAME }}_{{ IO }}_{{ bufnum }}_FORMAT      ("{{ buffer['data_type'] }}")
#define LL_ATON_{{ NET_NAME }}_{{ IO }}_{{ bufnum }}_SIZE        ({{ buffer['size'] }})           // Buffer size in elements
#define LL_ATON_{{ NET_NAME }}_{{ IO }}_{{ bufnum }}_SHAPE       ({{ buffer['shape']|string | replace("[", "{") | replace("]", "}")  }}) // Buffer shape
#}
{% endfor %}
{% endmacro %}


{#-
Macro to generate list of buffer attributes (size, alignment etc...)
Inputs: 
  - Buffer list
  - Suffix for defines names (IN or OUT)
#}
{% macro generate_description_defines(buff_list, IO) %}
{% for category in ["SIZE", "ALIGNMENT"]: %}
#define LL_ATON_{{ NET_NAME }}_{{ IO }}_{{ category }} { \
{% for tensor in buff_list: %}
  LL_ATON_{{ NET_NAME }}_{{ IO }}_{{ loop.index }}_{{ category }}, \
{% endfor %}
}
{% endfor %}
{% endmacro %}


{#-
Macro to instantiate buffers and provide a list of pointers to them
#}
{% macro instantiate_buffs(buff_list, IO) %}
{% for buffer in buff_list: %}
{% set bufnum = loop.index %}
{% set pfx    = "LL_ATON_" + NET_NAME + "_" +  IO + "_" + bufnum|string  %}
   AI_ALIGNED({{ buffer['alignment_bytes'] }}) static ai_i8 data_{{ IO|lower }}_{{ bufnum }}[{{ pfx }}_SIZE_BYTES]; \
{% endfor %}
   ai_i8* data_{{ IO|lower }}_buffers[LL_ATON_{{ NET_NAME }}_USER_ALLOCATED_{{ IO }}PUTS] = { \
{% for buffer in buff_list: %}
       data_{{ IO|lower }}_{{ loop.index }}, \
{% endfor %}
   };
{%- endmacro %}
/**
  ******************************************************************************
  * @file    {{ config['fname'] }}
  * @author  STEdgeAI
  * @date    {{ config['date_time'] }}
  * @brief   Minimal description of the generated c-implemention of the network
  ******************************************************************************
  * @attention
  *
  * {{ config['copyright'] }}
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  ******************************************************************************
  */
#ifndef LL_ATON_{{ NET_NAME }}_H
#define LL_ATON_{{ NET_NAME }}_H
{# #include "ai_platform.h"        /* AI_ALIGNED */ #}

/******************************************************************************/
#define LL_ATON_{{ NET_NAME }}_C_MODEL_NAME        "{{ config['net_name'] }}"
#define LL_ATON_{{ NET_NAME }}_ORIGIN_MODEL_NAME   "{{ config['model_origin_name'] }}"

/************************** USER ALLOCATED IOs ********************************/
{% if config['user_allocated_inputs'] %}
#define LL_ATON_{{ NET_NAME }}_USER_ALLOCATED_INPUTS   ({{ config['user_allocated_inputs'] }})  // Number of input buffers not allocated by the compiler
{% else %}
// No user allocated inputs
{% endif %}
{% if config['user_allocated_outputs'] %}
#define LL_ATON_{{ NET_NAME }}_USER_ALLOCATED_OUTPUTS  ({{ config['user_allocated_outputs'] }})  // Number of output buffers not allocated by the compiler
{% else %}
// No user allocated outputs
{% endif %}

/************************** INPUTS ********************************************/
#define LL_ATON_{{ NET_NAME }}_IN_NUM        ({{ config['c_net_in']|length }})    // Total number of input buffers
{# {{ generate_description_defines(config['c_net_in'], "IN") }} #}
{{ render_buffers(config['c_net_in'], "IN") }}
/************************** OUTPUTS *******************************************/
#define LL_ATON_{{ NET_NAME }}_OUT_NUM        ({{ config['c_net_out']|length }})    // Total number of output buffers
{# {{ generate_description_defines(config['c_net_out'], "OUT") }} #}
{{ render_buffers(config['c_net_out'], "OUT") }}
{# #############################################################################
 # REMOVED IN THE CURRENT IMPLEMENTATION TO SIMPLIFY OUTPUTS
/******************************************************************************/
#define LL_ATON_ALLOCATE_BUFFERS_{{ NET_NAME }} \
{% if config['user_allocated_inputs'] %}
{{ instantiate_buffs(config['c_net_in'], "IN") }}\
{% endif %}

{%- if config['user_allocated_outputs'] %}
{{ instantiate_buffs(config['c_net_out'], "OUT") }}
{% endif %}

/************************** WEIGHTS *******************************************/
{% for k,v in config["weights"].items(): %}
#define LL_ATON_{{ NET_NAME }}_WEIGHTS_{{ v["name"]|upper }}_OFFSET     ({{ '0x%08x' | format(v['offset']) }})
#define LL_ATON_{{ NET_NAME }}_WEIGHTS_{{ v["name"]|upper }}_SIZE_BYTES ({{ v['size_bytes'] }})
#define LL_ATON_{{ NET_NAME }}_WEIGHTS_{{ v["name"]|upper }}_MD5        ({{ v['md5'] }})
#define LL_ATON_{{ NET_NAME }}_WEIGHTS_{{ v["name"]|upper }}_CRC32      ({{ v['crc32'] }})
#define LL_ATON_{{ NET_NAME }}_WEIGHTS_{{ v["name"]|upper }}_SHA1       ({{ v['sha1'] }})
{% endfor %}
################################################################################
#}
#endif /* LL_ATON_{{ NET_NAME }}_H */
{{ "" }}
