{#
  ******************************************************************************
  * @file    network_params.j2.h
  * @author  AST Embedded Analytics Research Platform
  * @brief   AI Tool Automatic Code Generator for Embedded NN computing
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2022 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  ******************************************************************************
#}
{%- import 'network_layers.j2.c' as layers -%}

{% set net_name = config['net_name'].lower() -%}
{% set NET_NAME = config['net_name'].upper() -%}
{% set data_module = config['data_module'].lower() -%}
{% set DATA_MODULE = config['data_module'].upper() -%}
{% set _activations = config[layers.ACTIVATIONS] -%}
{% set _weights = config[layers.WEIGHTS] -%}

/**
  ******************************************************************************
  * @file    {{ data_module }}_params.h
  * @author  AST Embedded Analytics Research Platform
  * @date    {{ config['date_time'] }}
  * @brief   AI Tool Automatic Code Generator for Embedded NN computing
  ******************************************************************************
  * {{ config['copyright'] }}
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  ******************************************************************************
  */

#ifndef {{ DATA_MODULE }}_PARAMS_H
#define {{ DATA_MODULE }}_PARAMS_H

#include "ai_platform.h"

/*
#define AI_{{ DATA_MODULE }}_WEIGHTS_PARAMS \
  (AI_HANDLE_PTR(&ai_{{ data_module }}_weights_params[1]))
*/

#define AI_{{ DATA_MODULE }}_CONFIG               (NULL)

{% if _activations['size'] > 0 %}
#define AI_{{ DATA_MODULE }}_ACTIVATIONS_SIZES \
  { {% for buf in _activations['buffers']: -%}{{ buf['pool_size'] }}, {% endfor -%} }
#define AI_{{ DATA_MODULE }}_ACTIVATIONS_SIZE     ({{ _activations['size'] }})
#define AI_{{ DATA_MODULE }}_ACTIVATIONS_COUNT    ({{ _activations['buffers']|length }})
{% for buf in _activations['buffers']: -%}
#define AI_{{ DATA_MODULE }}_ACTIVATION_{{ loop.index0 + 1 }}_SIZE    ({{ buf['pool_size'] }})
{% endfor -%}
{% else %}
#define AI_{{ DATA_MODULE }}_ACTIVATIONS_SIZES    { 0, }
#define AI_{{ DATA_MODULE }}_ACTIVATIONS_SIZE     (0)
#define AI_{{ DATA_MODULE }}_ACTIVATIONS_COUNT    (0)
#define AI_{{ DATA_MODULE }}_ACTIVATION_1_SIZE    (0)
{% endif %}

{% if _weights['size'] > 0 %}
#define AI_{{ DATA_MODULE }}_WEIGHTS_SIZES \
  { {% for buf in _weights['buffers']: -%}{{ buf['pool_size'] }}, {% endfor -%} }
#define AI_{{ DATA_MODULE }}_WEIGHTS_SIZE         ({{ _weights['size'] }})
#define AI_{{ DATA_MODULE }}_WEIGHTS_COUNT        ({{ _weights['buffers']|length }})
{% for buf in _weights['buffers']: -%}
#define AI_{{ DATA_MODULE }}_WEIGHT_{{ loop.index0 + 1 }}_SIZE        ({{ buf['pool_size'] }})
{% endfor -%}
{% else %}
#define AI_{{ DATA_MODULE }}_WEIGHTS_SIZES        { 0, }
#define AI_{{ DATA_MODULE }}_WEIGHTS_SIZE         (0)
#define AI_{{ DATA_MODULE }}_WEIGHTS_COUNT        (0)
#define AI_{{ DATA_MODULE }}_WEIGHT_1_SIZE        (0)
{% endif %}

{% if _activations['size'] > 0 %}
#define AI_{{ DATA_MODULE }}_ACTIVATIONS_TABLE_GET() \
  (&{{ _activations['table'] }}[1])

extern ai_handle {{ _activations['table'] }}[{{ _activations['buffers']|length }} + 2];
{% else %}
#define AI_{{ DATA_MODULE }}_ACTIVATIONS_TABLE_GET() \
  (NULL)
{% endif %}

{% if _weights['size'] > 0 %}
#define AI_{{ DATA_MODULE }}_WEIGHTS_TABLE_GET() \
  (&{{ _weights['table'] }}[1])

extern ai_handle {{ _weights['table'] }}[{{ _weights['buffers']|length }} + 2];
{% else %}
#define AI_{{ DATA_MODULE }}_WEIGHTS_TABLE_GET() \
  (NULL)
{% endif %}

#endif    /* {{ DATA_MODULE }}_PARAMS_H */
{{ "" }}
