{#
  ******************************************************************************
  * @file    network_layers.j2.c
  * @author  AST Embedded Analytics Research Platform
  * @brief   AI Tool Automatic Code Generator for Embedded NN computing
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2017 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  ******************************************************************************
#}
{% set ACTIVATIONS = 'activations' -%}
{% set ARRAYS = 'arrays' -%}
{% set CUSTOM = 'custom' -%}
{% set FORMATS = 'formats' -%}
{% set FUNCTIONS = 'functions' -%}
{% set INTQS = 'intqs' -%}
{% set LAYERS = 'layers' -%}
{% set TAGS = 'tags' -%}
{% set TENSORS = 'tensors' -%}
{% set WEIGHTS = 'weights' -%}
{% set STATES = 'states' -%}


{# Arrays Macro Section #}

{%- macro array_forward_declaration(conf, is_const=False) -%}
{% if is_const %}AI_STATIC_CONST{% else %}AI_STATIC{% endif %} ai_array {{ conf['name'] }};
{%- endmacro -%}

{%- macro declare_param_arrays(conf) -%}
AI_STATIC_CONST {{conf['c_type']}} {{conf['name']}}_data[] = { {{conf['init']}} };
AI_ARRAY_OBJ_DECLARE(
    {{conf['name']}}, {{conf['fmt_data']}},
    {{conf['name']}}_data, {{conf['name']}}_data, {{conf['size']}}, AI_STATIC_CONST)
{%- endmacro -%}

{%- macro declare_array(conf, index, is_const=False) -%}
/* Array#{{ index }} */
AI_ARRAY_OBJ_DECLARE(
  {{conf['name']}}, {{conf['fmt_data']}},
  {{conf['p_data']}}, {{conf['p_data']}}, {{conf['size']}}, AI_STATIC{%- if is_const -%}_CONST{%- endif -%})
{% endmacro %}

{# Tensors Macro Section #}

{%- macro tensor_forward_declaration(conf, is_const=False) -%}
AI_STATIC{%- if is_const -%}_CONST{% endif %} ai_tensor {{ conf['name'] }};
{%- endmacro -%}

{%- macro declare_tensor(conf, index, is_const=False) -%}
/* Tensor #{{ index }} */
AI_TENSOR_OBJ_DECLARE(
  {{ conf['name'] }}, AI_STATIC{%- if is_const -%}_CONST{%- endif -%},
  {{ conf['id'] }}, {{ conf['flags'] }},
  AI_SHAPE_INIT({{ conf['dimensions'] }}), AI_STRIDE_INIT({{ conf['strides'] }}),
  {{ conf[ARRAYS]|length }}, {{ conf[ARRAYS][0]['array'] }}, {{ conf['intq'] }})
{% endmacro %}

{%- macro declare_intq(conf, index, is_const=False) -%}
/* Int quant #{{ index }} */
AI_INTQ_INFO_LIST_OBJ_DECLARE({{ conf['name'] }}, AI_STATIC{%- if is_const -%}_CONST{%- endif -%},
  {{ conf['flags'] }}, {{ conf['size'] }},
  AI_PACK_INTQ_INFO(
    {{ conf['scale'] }},
    {{ conf['zero'] }}))
{% endmacro %}

{# Layers Tensorchains Macro Section #}

{%- macro declare_tensor_list(list) -%}
  {%- if list|length>0 -%}
  AI_TENSOR_LIST_OBJ_INIT(AI_FLAG_NONE, {{ list|length }}, {{ list|join(', ') }})
  {%- else -%}
  AI_TENSOR_LIST_OBJ_EMPTY
  {%- endif -%}
{%- endmacro -%}

{%- macro tensor_chain_forward_declare(chain, is_const=True) -%}
{% if is_const %}AI_STATIC_CONST{% else%}AI_STATIC{% endif %} ai_tensor_chain {{ chain['name'] }};
{%- endmacro -%}

{%- macro declare_tensor_chain(chain, is_const=True) -%}
AI_TENSOR_CHAIN_OBJ_DECLARE(
  {{ chain['name'] }}, {% if is_const %}AI_STATIC_CONST{% else%}AI_STATIC{% endif %}, 4,{{"\n  "-}}
  {{ declare_tensor_list(chain['input']) }},
  {{ declare_tensor_list(chain['output']) }},
  {{ declare_tensor_list(chain['weights']) }},
  {{ declare_tensor_list(chain['scratch']) }}
)
{%- endmacro -%}

{# Layers Macro Section #}

{%- macro layer_forward_declaration(layer) -%}
{% if is_const %}AI_STATIC_CONST{% else %}AI_STATIC{% endif %} ai_layer_{{ layer[TAGS]['c_layer_postfix'] }} {{ layer['layer_name'] }};
{%- endmacro -%}

{%- macro declare_layer_object(layer, net_obj, is_const=False) -%}
AI_LAYER_OBJ_DECLARE(
  {{ layer['layer_name'] }}, {{ layer[TAGS]['c_layer_id'] }},
  {{ layer[TAGS]['c_layer_type'].upper() }}, {{ layer[TAGS]['c_layer_flags'] }}, {{ layer[TAGS]['c_layer_klass'] }},
  {{ layer[TAGS]['c_layer_postfix'] }}, {{ layer[TAGS]['c_layer_forward'] }},
  &{{ layer['tensor_chain']['name'] }},
  {{ net_obj }}, &{{ layer['next'] }}, {% if is_const %}AI_STATIC_CONST{% else %}AI_STATIC{% endif %},{{" "-}}
  {% for param_str in layer[TAGS]['c_param_strings']: %}
  {{ param_str }},{{" "-}}
  {%- endfor %}
)
{%- endmacro -%}

{%- macro declare_layer(layer, net_obj) -%}
{%   for array in layer["arrays"]: %}
{{     declare_param_arrays(array) }}
{%   endfor -%}

{{ declare_tensor_chain(layer['tensor_chain']) }}

{{ declare_layer_object(layer, net_obj) }}

{%- endmacro -%}


{# Offsets Computation Macro Section #}

{%- macro weights_init_offsets(weight_buffers, weights_map) -%}
{%- for buf in weight_buffers: -%}
  {%- for elem in buf['buffer_offsets']: %}
    {{ elem['buffer_name'] }}.format |= AI_FMT_FLAG_CONST;
    {{ elem['buffer_name'] }}.data = AI_PTR({{ weights_map }}[{{ buf['pool_id'] }}] + {{ elem['offset'] }});
    {{ elem['buffer_name'] }}.data_start = AI_PTR({{ weights_map }}[{{ buf['pool_id'] }}] + {{ elem['start_offset'] }});
  {%- endfor -%}
{% endfor -%}
{%- endmacro -%}

{%- macro activations_init_offsets(activations_buffers, activations_map) -%}
{% for buf in activations_buffers: -%}
  {%- for elem in buf['buffer_offsets']: %}
    {{ elem['buffer_name'] }}.data = AI_PTR({{ activations_map }}[{{ buf['pool_id'] }}] + {{ elem['offset'] }});
    {{ elem['buffer_name'] }}.data_start = AI_PTR({{ activations_map }}[{{ buf['pool_id'] }}] + {{ elem['start_offset'] }});
  {%- endfor -%}
{% endfor -%}
{%- endmacro -%}


{# Custom layers Section #}

{% macro define_binary_operator(op) -%}
{% set params = op.tags %}
{{layers.declare_tensor_chain(op.tensor_chain)}}
AI_STATIC ai_operator_{{params.c_op_postfix}} {{op.name}}_op = AI_OPERATOR_INIT(
{{params.c_op_type.upper()}}, NULL, &{{params.next}}, {{params.c_op_compute}},
.tensors= &{{op.tensor_chain['name']}},
{% for param_str in params.param_strings: -%}
{{ param_str }},{{" "-}}
{%- endfor -%}
);
{%- endmacro -%}


{% macro declare_custom(custom_layers) -%}
{%   for custom in custom_layers: %}
void forward_{{custom_layer}}(ai_layer * _ai_layer);
{%   endfor -%}
{%- endmacro -%}

{% macro include_lambda(net_name, functions) -%}
{%- if functions -%}
#include "{{net_name}}_lambda.h"
{%- endif -%}
{%- endmacro -%}


{% macro custom_func_head(graph) -%}
AI_INTERNAL_API
void ai_{{graph.name}}_fn(ai_handle out, ai_handle {{graph.input[0]}}_ph, ai_handle {{graph.input[1] or 'def_val'}}_ph)
{%- endmacro -%}

{% macro custom_func_buffer_head(graph) -%}
AI_INTERNAL_API
void ai_{{graph.name}}_fn_buffer(ai_handle out, ai_handle {{graph.input[0]}}_ph, ai_handle {{graph.input[1] or 'def_val'}}_ph, const ai_size loop)
{%- endmacro -%}

{% macro custom_func_body(graph) -%}
{{custom_func_head(graph)}}
{
  /* Custom generated code for {{graph.name}} */
  ai_float* o = (ai_float *)out;
{%- for input in graph.input: %}
  ai_float {{input}} = *((ai_float*){{input}}_ph);
{%- endfor %}

{%- for constant in graph.const: %}
  AI_STATIC_CONST ai_float {{constant.name}} = {{constant.float_data}};
{%- endfor %}
{% for line in graph.body %}
  {{line}}
{%- endfor %}
  *o = {{graph.output}};
}
{%- endmacro -%}

{% macro custom_func_buffer_body(graph) -%}
{{custom_func_buffer_head(graph)}}
{
  /* Custom generated code for {{graph.name}}_buffer */
  ai_float* o = (ai_float *)out;
{%- for input in graph.input: %}
  ai_float * {{input}}_p = (ai_float*){{input}}_ph;
{%- endfor %}

{%- for constant in graph.const: %}
  AI_STATIC_CONST ai_float {{constant.name}} = {{constant.float_data}};
{%- endfor %}
  for(ai_size i=0; i<loop; i++) {
{%- for input in graph.input: %}
    ai_float {{input}} = *{{input}}_p;
{%- endfor %}
{% for line in graph.body %}
    {{line}}
{%- endfor %}
    *o = {{graph.output}};
    o++;
{%- for input in graph.input: %}
    {{input}}_p++;
{%- endfor %}
  }
}
{%- endmacro -%}
