{#
  ******************************************************************************
  * @file    network_data.j2.c
  * @author  AST Embedded Analytics Research Platform
  * @brief   AI Tool Automatic Code Generator for Embedded NN computing
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2021 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  ******************************************************************************
#}
{%- import 'network_layers.j2.c' as layers -%}

{% set net_name = config['net_name'].lower() -%}
{% set NET_NAME = config['net_name'].upper() -%}
{% set data_module = config['data_module'].lower() -%}
{% set DATA_MODULE = config['data_module'].upper() -%}
{% set net_data = config['net_data'] -%}
{% set _activations = config[layers.ACTIVATIONS] -%}
{% set _weights = config[layers.WEIGHTS] -%}

/**
  ******************************************************************************
  * @file    {{ data_module }}.c
  * @author  AST Embedded Analytics Research Platform
  * @date    {{ config['date_time'] }}
  * @brief   AI Tool Automatic Code Generator for Embedded NN computing
  ******************************************************************************
  * @attention
  *
  * {{ config['copyright'] }}
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  ******************************************************************************
  */
#include "{{ data_module }}.h"
#include "ai_platform_interface.h"
{%- if _weights['address_src'] %}
#include <string.h>
{%- endif %}

{%- if _weights['address'] %}

#define {{ _weights['address'][0] }}     ({{ _weights['address'][1] }})
{%- if _weights['address_src'] %}
#define {{ _weights['address_src'][0] }}     ({{ _weights['address_src'][1] }})
{%- endif %}
{%- endif %}

AI_API_DECLARE_BEGIN

{%- if _weights['address_src'] %}

/*!
 * @brief Local function to copy the weights buffer
 * @ingroup {{ data_module }}
 */
AI_INTERNAL_API
AI_STATIC void s_{{ net_name }}_copy_weights(void)
{
  memcpy((void *){{ _weights['address'][0] }}, (const void*){{ _weights['address_src'][0] }}, {{ _weights['buffers'][0]['pool_size']}});
}
{%- endif %}

{%- if net_data['model_strings']: %}

const ai_char *ai_{{ net_name }}_string_map[] = {
  {%- for val in net_data['model_strings']: %}
  "{{ val }}",
  {%- endfor %}
};

{%- endif %}

{%- if _activations['size'] > 0 %}
ai_buffer g_{{ data_module }}_map_activations[AI_{{ DATA_MODULE }}_ACTIVATIONS_COUNT] = {
  {% for buf in _activations['buffers']: -%}
  AI_BUFFER_INIT(AI_FLAG_NONE,  AI_BUFFER_FORMAT_U8,
    AI_BUFFER_SHAPE_INIT(AI_SHAPE_BCWH, 4, 1, {{ buf['pool_size'] }}, 1, 1),
    {{ buf['pool_size'] }}, NULL, {{ buf['buffer_c_name_addr'] }}),    /* {{ buf['name'] }} */
  {% endfor -%}
};
{%- endif %}


{%- if _weights['size'] > 0 %}
ai_buffer g_{{ data_module }}_map_weights[AI_{{ DATA_MODULE }}_WEIGHTS_COUNT] = {
  {% for buf in _weights['buffers']: -%}
  AI_BUFFER_INIT(AI_FLAG_NONE,  AI_BUFFER_FORMAT_U8,
    AI_BUFFER_SHAPE_INIT(AI_SHAPE_BCWH, 4, 1, {{ buf['pool_size'] }}, 1, 1),
    {{ buf['pool_size'] }}, NULL, {{ buf['buffer_c_name_addr'] }}),   /* {{ buf['name'] }} */
  {% endfor -%}
};
{%- endif %}


/*!
 * @brief Get network activations buffer initialized struct.
 * @ingroup {{ data_module }}
 * @param[in] ptr a pointer to the activations array storage area
 * @return an ai_buffer initialized struct
 */
AI_DEPRECATED
AI_API_ENTRY
ai_buffer ai_{{ data_module }}_activations_buffer_get(const ai_handle ptr)
{
  ai_buffer buf = AI_BUFFER_INIT(
    AI_FLAG_NONE, AI_BUFFER_FORMAT_U8,
    AI_BUFFER_SHAPE_INIT(AI_SHAPE_BCWH, 4, 1, AI_{{ DATA_MODULE }}_ACTIVATIONS_SIZE, 1, AI_{{ DATA_MODULE }}_ACTIVATIONS_COUNT),
    AI_{{ DATA_MODULE }}_ACTIVATIONS_SIZE,
    NULL, ptr);
  return buf;
}

/*!
 * @brief Get network weights buffer initialized struct.
 * @ingroup {{ data_module }}
 * @param[in] ptr a pointer to the weights array storage area
 * @return an ai_buffer initialized struct
 */
AI_DEPRECATED
AI_API_ENTRY
ai_buffer ai_{{ data_module }}_weights_buffer_get(const ai_handle ptr)
{
  ai_buffer buf = AI_BUFFER_INIT(
    AI_FLAG_NONE, AI_BUFFER_FORMAT_U8|AI_BUFFER_FMT_FLAG_CONST,
    AI_BUFFER_SHAPE_INIT(AI_SHAPE_BCWH, 4, 1, AI_{{ DATA_MODULE }}_WEIGHTS_SIZE, 1, AI_{{ DATA_MODULE }}_WEIGHTS_COUNT),
    AI_{{ DATA_MODULE }}_WEIGHTS_SIZE,
    NULL, ptr);
  return buf;
}


/*!
 * @brief Get network weights array pointer as a handle ptr.
 * @ingroup {{ data_module }}
 * @return a ai_handle pointer to the weights array
 */
AI_DEPRECATED
AI_API_ENTRY
ai_handle ai_{{ data_module }}_weights_get(void)
{
{%- if _weights['address_src'] %}
  s_{{ net_name }}_copy_weights();
{%- endif %}
{%- if _weights['hexify'] %}
  return AI_HANDLE_PTR({{ _weights['table'] }});
{% else %}
{%- if _weights['address'] %}
  return AI_HANDLE_PTR({{ _weights['address'][0] }});
{%- else %}
  return AI_HANDLE_PTR(NULL);
{%- endif %}
{%- endif %}
}


/*!
 * @brief Get network params configuration data structure.
 * @ingroup {{ data_module }}
 * @return true if a valid configuration is present, false otherwise
 */
AI_API_ENTRY
ai_bool ai_{{ data_module }}_params_get(ai_network_params* params)
{
  if (!params) return false;
  {%- if _weights['address_src'] %}

  s_{{ net_name }}_copy_weights();
  {%- endif %}
  {{ "" }}
{%- if _activations['size'] > 0 %}
  const ai_buffer_array map_activations = 
    AI_BUFFER_ARRAY_OBJ_INIT(AI_FLAG_NONE, AI_{{ DATA_MODULE }}_ACTIVATIONS_COUNT, g_{{ data_module }}_map_activations);
{%- else %}
  const ai_buffer_array map_activations = AI_BUFFER_ARRAY_OBJ_INIT(AI_FLAG_NONE, 0, NULL);
{%- endif %}
  {{ "" }}
{%- if _weights['size'] > 0 %}
  const ai_buffer_array map_weights = 
    AI_BUFFER_ARRAY_OBJ_INIT(AI_FLAG_NONE, AI_{{ DATA_MODULE }}_WEIGHTS_COUNT, g_{{ data_module }}_map_weights);
{%- else %}
  const ai_buffer_array map_weights = AI_BUFFER_ARRAY_OBJ_INIT(AI_FLAG_NONE, 0, NULL);
{%- endif %}

  return ai_platform_bind_network_params(params, &map_weights, &map_activations);
}


AI_API_DECLARE_END
{{ "" }}
