{#
  ******************************************************************************
  * @file    network_config.j2.h
  * @author  AST Embedded Analytics Research Platform
  * @brief   AI Tool Automatic Code Generator for Embedded NN computing
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2021 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  ******************************************************************************
#}
{% set net_name = config['net_name'].lower() -%}
{% set NET_NAME = config['net_name'].upper() -%}

/**
  ******************************************************************************
  * @file    {{ net_name }}_config.h
  * @author  AST Embedded Analytics Research Platform
  * @date    {{ config['date_time'] }}
  * @brief   AI Tool Automatic Code Generator for Custom Layers Implementation
  ******************************************************************************
  * @attention
  *
  * {{ config['copyright'] }}
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  ******************************************************************************
  */

#ifndef AI_{{ NET_NAME }}_CONFIG_H
#define AI_{{ NET_NAME }}_CONFIG_H

#undef AI_TOOLS_VERSION_MAJOR
#undef AI_TOOLS_VERSION_MINOR
#undef AI_TOOLS_VERSION_MICRO
#define AI_TOOLS_VERSION_MAJOR {{ config['st_ai_version']['major'] }}
#define AI_TOOLS_VERSION_MINOR {{ config['st_ai_version']['minor'] }}
#define AI_TOOLS_VERSION_MICRO {{ config['st_ai_version']['micro'] }}
{% if config['st_ai_version']['extra'] -%}
#define AI_TOOLS_VERSION_EXTRA "{{ config['st_ai_version']['extra'] }}"
{% endif %}

#undef AI_PLATFORM_API_MAJOR
#undef AI_PLATFORM_API_MINOR
#undef AI_PLATFORM_API_MICRO
#define AI_PLATFORM_API_MAJOR       (1)
#define AI_PLATFORM_API_MINOR       (1)
#define AI_PLATFORM_API_MICRO       (0)

#undef AI_TOOLS_API_VERSION_MAJOR
#undef AI_TOOLS_API_VERSION_MINOR
#undef AI_TOOLS_API_VERSION_MICRO
#define AI_TOOLS_API_VERSION_MAJOR ({{ config['tool_api_version']['major'] }})
#define AI_TOOLS_API_VERSION_MINOR ({{ config['tool_api_version']['minor'] }})
#define AI_TOOLS_API_VERSION_MICRO ({{ config['tool_api_version']['micro'] }})

#endif /*AI_{{ NET_NAME }}_CONFIG_H*/
{{ "" }}
