{#
  ******************************************************************************
  * @file    main_app.j2.c
  * @author  AST Embedded Analytics Research Platform
  * @brief   AI Tool Automatic Code Generator for Embedded NN computing
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2023 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  ******************************************************************************
#}
{%- import 'network_layers.j2.c' as layers -%}
{% set _activation_buffers = config[layers.ACTIVATIONS] -%}
{% set _graph = config['lite_graphs']['graphs'][0] -%}
{% set net_name = config['net_name'].lower() -%}
{% set NET_NAME = config['net_name'].upper() -%}


/**
  ******************************************************************************
  * @file    {{ net_name }}_inputs.c
  * @author  AST Embedded Analytics Research Platform
  * @date    {{ config['date_time'] }}
  * @brief   AI Tool Automatic Code Generator for Embedded NN computing
  ******************************************************************************
  * {{ config['copyright'] }}
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  ******************************************************************************
  */

#define EXPORT_RUNTIME_LITE_APIS

#ifndef MINIMAL_COMPILE
#include <stdio.h>
#endif


#include "ai_lite.h"
#include "ai_platform.h"

#include "{{ net_name }}_config.h"
#include "{{ net_name }}_data_params.h"
#include "{{ net_name }}_inputs.h"
#include "{{ net_name }}_lite_functions.h"

#define my_lite_inspect_cb      (NULL)

#ifdef MINIMAL_COMPILE
#define LOG_PRINT(fmt, ...) \
  {} while (0);

#else
#define LOG_PRINT(fmt, ...) \
  { printf(fmt, ##__VA_ARGS__); }
#endif

int simple_atoi(char * str) {
   int ret = 0;
   for(int i = 0; str[i] != '\0'; i++)
      ret = ret * 10 + str[i] - '0';
   return ret;
}

__attribute__((noinline,noclone,optimize("O3"))) void th_signal_start(){  __asm__("nop");}
__attribute__((noinline,noclone,optimize("O3"))) void th_signal_stop() {  __asm__("nop");__asm__("nop");}

int main(int argc, char *argv[])
{
#ifndef MINIMAL_COMPILE
   int sample = simple_atoi(argv[1]);
   if(sample == 0) {
      LOG_PRINT("__START_SELF_INSPECTION__\n")
      LOG_PRINT("name:{{ net_name }}\n");
      LOG_PRINT("n_inputs:{{ config['c_net_in']|length }}\n");
      {% for input in config['c_net_in'] -%}
         {# using jinja filter to retrieve shape length from get_value() input tuple -#}
         {% set _values = input['shape'].get_values() -%}
         {% if _values|length == 6 -%}
      LOG_PRINT("inputtensor_{{ loop.index }}:({{ _values[5] }},{{ _values[1] }},{{ _values[2] }},{{ _values[3] }},{{ _values[4] }},{{ _values[0] }})#{{ input['fmt'].get_c_format() }}#{{ input['array_byte_size']}}#{{ input['fmt'].get_scale()}}#{{ input['fmt'].get_zero()}}\n");
         {% elif _values|length == 5 -%}
      LOG_PRINT("inputtensor_{{ loop.index }}:({{ _values[4] }},{{ _values[1] }},{{ _values[2] }},{{ _values[3] }},{{ _values[0] }})#{{ input['fmt'].get_c_format() }}#{{ input['array_byte_size']}}#{{ input['fmt'].get_scale()}}#{{ input['fmt'].get_zero()}}\n");
         {% else -%}
      LOG_PRINT("inputtensor_{{ loop.index }}:({{ _values[3] }},{{ _values[1] }},{{ _values[2] }},{{ _values[0] }})#{{ input['fmt'].get_c_format() }}#{{ input['array_byte_size']}}#{{ input['fmt'].get_scale()}}#{{ input['fmt'].get_zero()}}\n");
         {% endif -%}
      {% endfor %}
      LOG_PRINT("n_outputs:{{ config['c_net_out']|length }}\n");
      {% for output in config['c_net_out'] -%}
         {# using jinja filter to retrieve shape length from get_value() output tuple -#}
         {% set _values = output['shape'].get_values() -%}
         {% if _values|length == 6 -%}
      LOG_PRINT("outputtensor_{{ loop.index }}:({{ _values[5] }},{{ _values[1] }},{{ _values[2] }},{{ _values[3] }},{{ _values[4] }},{{ _values[0] }})#{{ output['fmt'].get_c_format() }}#{{ output['array_byte_size']}}#{{ output['fmt'].get_scale()}}#{{ output['fmt'].get_zero()}}\n");
         {% elif _values|length == 5 -%}
      LOG_PRINT("outputtensor_{{ loop.index }}:({{ _values[4] }},{{ _values[1] }},{{ _values[2] }},{{ _values[3] }},{{ _values[0] }})#{{ output['fmt'].get_c_format() }}#{{ output['array_byte_size']}}#{{ output['fmt'].get_scale()}}#{{ output['fmt'].get_zero()}}\n");
         {% else -%}
      LOG_PRINT("outputtensor_{{ loop.index }}:({{ _values[3] }},{{ _values[1] }},{{ _values[2] }},{{ _values[0] }})#{{ output['fmt'].get_c_format() }}#{{ output['array_byte_size']}}#{{ output['fmt'].get_scale()}}#{{ output['fmt'].get_zero()}}\n");
         {% endif -%}
      {% endfor %}
      LOG_PRINT("n_nodes:{{ config['lite_graphs']['graphs'][0]['sections']|length }}\n");
      LOG_PRINT("activations:{{ config[layers.ACTIVATIONS]['size'] }}\n");
      LOG_PRINT("weights:{{ config[layers.WEIGHTS]['size'] }}\n");
      LOG_PRINT("runtime_name:STM.AI\n");
      LOG_PRINT("macc:{{ config['Macc'] }}\n");
      LOG_PRINT("runtime_version:%d.%d.%d\n", AI_TOOLS_VERSION_MAJOR, AI_TOOLS_VERSION_MINOR, AI_TOOLS_VERSION_MICRO);
      LOG_PRINT("runtime_tools_version:%d.%d.%d\n", AI_TOOLS_VERSION_MAJOR, AI_TOOLS_VERSION_MINOR, AI_TOOLS_VERSION_MICRO);
      LOG_PRINT("__STOP_SELF_INSPECTION__\n")

      return 0;
   }
   sample = sample - 1;
#endif
   ai_handle* activation_buffers = AI_{{ NET_NAME }}_DATA_ACTIVATIONS_TABLE_GET();

   {% for activation_counter in range( _activation_buffers['buffers']|length): -%}
   ai_u8 activation{{ activation_counter + 1 }}[AI_{{ NET_NAME }}_DATA_ACTIVATION_{{ activation_counter + 1 }}_SIZE] = {0};
   activation_buffers[{{ activation_counter }}] = activation{{ activation_counter + 1 }};
   {% endfor %}

   ai_handle* weights = AI_{{ NET_NAME }}_DATA_WEIGHTS_TABLE_GET();

   ai_handle input_buffers[{{ config['c_net_in']|length }}];
   {% for _input in config['c_net_in'] -%}
#ifndef MINIMAL_COMPILE
   input_buffers[{{ loop.index - 1 }}] = AI_HANDLE_PTR(input{{ loop.index }}[sample]);
#else
   input_buffers[{{ loop.index - 1 }}] = AI_HANDLE_PTR(input{{ loop.index }});
#endif
   {% endfor %}

   {# copy inputs into activation buffers if allocate_inputs is used #}
   {% if config['allocate_inputs'] != 0 -%}
      {% for activation_counter in range( _activation_buffers['buffers']|length): -%}
         {% for input_counter in range( config['c_net_in']|length): -%}
            {% set input_name = config['c_net_in'][input_counter]['ptr'][1:] -%}  {# remove the '&' to the input name -#}
            {% set input_name_array = input_name + '_array' -%}
            {# check if input_name is contained in the buffer name, for each buffer name in the activation buffers #}
            {% for buffer_counter in range(_activation_buffers['buffers'][activation_counter]['buffer_offsets']|length): -%}
               {% if input_name_array == _activation_buffers['buffers'][activation_counter]['buffer_offsets'][buffer_counter]['buffer_name'] -%}
                  {% set activation_offset = _activation_buffers['buffers'][activation_counter]['buffer_offsets'][buffer_counter]['offset'] -%}
                  {% set memory_size = _activation_buffers['buffers'][activation_counter]['buffer_offsets'][buffer_counter]['size'] -%}
   memcpy(activation_buffers[{{ activation_counter }}] + {{ activation_offset }}, input_buffers[{{ input_counter }}], {{ memory_size }});
               {% endif -%}
            {% endfor -%}
         {% endfor -%}
      {% endfor -%}
   {% endif -%}

   ai_handle output_buffers[{{ config['c_net_out']|length }}];
   {% for _output in config['c_net_out'] -%}
   {{ _output['fmt'].get_c_type() }} output{{ loop.index}}[{{ _output['padded_elements'] }}];
   output_buffers[{{ loop.index - 1 }}] = AI_HANDLE_PTR(output{{ loop.index }});
   {% endfor %}

   lite_graph graph = LITE_GRAPH_INIT(input_buffers, output_buffers, activation_buffers, weights, my_lite_inspect_cb, NULL);

   // execute inference model on test
   th_signal_start();
   const lite_result ok = run_{{_graph['name']}}(&graph);
   th_signal_stop();
   
   {# copy activation buffers into outputs if allocate_outputs is used. This is done after the lite graph run #}
   {% if config['allocate_outputs'] != 0 -%}
      {% for activation_counter in range( _activation_buffers['buffers']|length): -%}
         {% for output_counter in range( config['c_net_out']|length): -%}
            {% set output_name = config['c_net_out'][output_counter]['ptr'][1:] -%}  {# remove the '&' to the output name -#}
            {% set output_name_array = output_name + '_array' -%}
            {# check if output name is contained in the buffer name, for each buffer name in the activation buffers #}
            {% for buffer_counter in range(_activation_buffers['buffers'][activation_counter]['buffer_offsets']|length): -%}
               {% if output_name_array == _activation_buffers['buffers'][activation_counter]['buffer_offsets'][buffer_counter]['buffer_name'] -%}
                  {% set activation_offset = _activation_buffers['buffers'][activation_counter]['buffer_offsets'][buffer_counter]['offset'] -%}
                  {% set memory_size = _activation_buffers['buffers'][activation_counter]['buffer_offsets'][buffer_counter]['size'] -%}
   memcpy(output_buffers[{{ output_counter }}], activation_buffers[{{ activation_counter }}] + {{ activation_offset }}, {{ memory_size }});
               {% endif -%}
            {% endfor -%}   
         {% endfor -%}   
      {% endfor -%}
   {% endif -%}

   if (ok != LITE_OK ) {
      LOG_PRINT("  ## Test Failed executing graph: 0x%x.\n\n", ok)
      return -1;
   }
   {% for _output in config['c_net_out'] -%}
   LOG_PRINT("__START_OUTPUT{{ loop.index }} __\n");
   for(int o = 0; o < {{ _output['padded_elements'] / (32 if _output['fmt'].is_minus_plus_one() else 1) }}; o++) {
      {% if _output['fmt'].is_quantized_integer(size=8) and _output['fmt'].is_signed() -%}
      ai_i8 temp = *(ai_i8* )&output{{ loop.index }}[o];
      {% elif _output['fmt'].is_quantized_integer(size=8) and _output['fmt'].is_unsigned() -%}
      ai_u8 temp = *(ai_u8* )&output{{ loop.index }}[o];
      {% elif _output['fmt'].is_quantized_integer(size=16) and _output['fmt'].is_signed() -%}
      ai_i16 temp = *(ai_i16* )&output{{ loop.index }}[o];
      {% elif _output['fmt'].is_quantized_integer(size=16) and _output['fmt'].is_unsigned() -%}
      ai_u16 temp = *(ai_u16* )&output{{ loop.index }}[o];
      {% elif _output['fmt'].get_bit_size() == 32 and _output['fmt'].is_signed() -%}
      ai_i32 temp = *(ai_i32* )&output{{ loop.index }}[o];
      {% elif _output['fmt'].get_bit_size() == 32 and _output['fmt'].is_unsigned() -%}
      ai_u32 temp = *(ai_u32* )&output{{ loop.index }}[o];
      {% elif _output['fmt'].is_bool() -%}
      ai_bool temp = *(ai_bool* )&output{{ loop.index }}[o];
      {% else -%}
      ai_u32 temp = *(ai_u32 *)&output{{ loop.index }}[o];
      {% endif -%}
      if(o != 0 && o % 10 == 0) {
         LOG_PRINT("\n");
      }
      LOG_PRINT("%08" PRIX32 " ", temp);
   }
   LOG_PRINT("\n__END_OUTPUT{{ loop.index }} __\n");
   {% endfor %}
   return 0;
}
