{#
  ******************************************************************************
  * @file    legacy_network_data.j2.h
  * @author  AST Embedded Analytics Research Platform
  * @brief   AI Tool Automatic Code Generator for Embedded NN computing
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2023 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  ******************************************************************************
#}
{%- import 'network_layers.j2.c' as layers -%}

{% set net_name = config['net_name'].lower() -%}
{% set NET_NAME = config['net_name'].upper() -%}
{% set data_module = config['data_module'].lower() -%}
{% set DATA_MODULE = config['data_module'].upper() -%}
{% set net_data = config['net_data'] -%}
{% set _activations = config[layers.ACTIVATIONS] -%}
{% set _weights = config[layers.WEIGHTS] -%}

/**
  ******************************************************************************
  * @file    {{ data_module }}.h
  * @author  AST Embedded Analytics Research Platform
  * @date    {{ config['date_time'] }}
  * @brief   AI Tool Automatic Code Generator for Embedded NN computing
  ******************************************************************************
  * {{ config['copyright'] }}
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  ******************************************************************************
  */

#ifndef _LEGACY_{{ DATA_MODULE }}_H
#define _LEGACY_{{ DATA_MODULE }}_H

#include "{{ net_name }}_config.h"
#include "{{ data_module }}_params.h"

AI_DEPRECATED
#define AI_{{ DATA_MODULE }}_ACTIVATIONS(ptr_)  \
  ai_{{ data_module }}_activations_buffer_get(AI_HANDLE_PTR(ptr_))

AI_DEPRECATED
#define AI_{{ DATA_MODULE }}_WEIGHTS(ptr_)  \
  ai_{{ data_module }}_weights_buffer_get(AI_HANDLE_PTR(ptr_))


AI_API_DECLARE_BEGIN

{%- if net_data['model_strings']: %}

/* Model strings */
#define AI_NETWORK_STRING_COUNT   ({{net_data['model_strings']|length}})

enum {
  {%- for val in net_data['model_strings']: %}
  AI_STRING_{{ val.upper() }} = {{ loop.index0 }},
  {%- endfor %}
};

extern const ai_char *ai_{{ net_name }}_string_map[];

{%- endif %}

{% if _weights['hexify'] %}
{%- for buf in _weights['buffers']: %}
extern const {{ buf['buffer_c_type'] }} {{ buf['buffer_c_name'] }}[{{ buf['buffer_c_count'] }}];
{%- endfor %}
{{ "" }}
{% endif %}

/*!
 * @brief Get network activations buffer initialized struct.
 * @ingroup {{ data_module }}
 * @param[in] ptr a pointer to the activations array storage area
 * @return an ai_buffer initialized struct
 */
AI_DEPRECATED
AI_API_ENTRY
ai_buffer ai_{{ data_module }}_activations_buffer_get(const ai_handle ptr);


/*!
 * @brief Get network weights buffer initialized struct.
 * @ingroup {{ data_module }}
 * @param[in] ptr a pointer to the weights array storage area
 * @return an ai_buffer initialized struct
 */
AI_DEPRECATED
AI_API_ENTRY
ai_buffer ai_{{ data_module }}_weights_buffer_get(const ai_handle ptr);


/*!
 * @brief Get network weights array pointer as a handle ptr.
 * @ingroup {{ data_module }}
 * @return a ai_handle pointer to the weights array
 */
AI_DEPRECATED
AI_API_ENTRY
ai_handle ai_{{ data_module }}_weights_get(void);


/*!
 * @brief Get network params configuration data structure.
 * @ingroup {{ data_module }}
 * @return true if a valid configuration is present, false otherwise
 */
AI_API_ENTRY
ai_bool ai_{{ data_module }}_params_get(ai_network_params* params);


AI_API_DECLARE_END

#endif /* _LEGACY_{{ DATA_MODULE }}_H */
{{ "" }}

