{#
  ******************************************************************************
  * @file    hybrid_lite.j2.c
  * @author  AST Embedded Analytics Research Platform
  * @brief   AI Tool Automatic Code Generator for Embedded NN computing
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2023 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  ******************************************************************************
#}
{%- set hybrid_lite = config['hybrid_lite'] -%}
{%- set file_name = hybrid_lite['file_name'] -%}
{%- set net_name = config['net_name'].lower() -%}
{%- set NET_NAME = config['net_name'].upper() -%}
{%- set custom = config[layers.CUSTOM] -%}
{%- import 'network_layers.j2.c' as layers -%}
{%- import 'op_lite_common.j2.c' as lite -%}

/**
  ******************************************************************************
  * @file    {{ file_name }}.c
  * @author  AST Embedded Analytics Research Platform
  * @date    {{ config['date_time'] }}
  * @brief   AI Tool Automatic Code Generator for Embedded NN computing
  ******************************************************************************
  * @attention
  *
  * {{ config['copyright'] }}
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  ******************************************************************************
  */

{{layers.include_lambda(net_name, config[layers.FUNCTIONS])}}
#include "core_convert.h"
#include "layers.h"

{%  for init_func in custom['init']: -%}
void {{ init_func }}(ai_layer* layer);
{% endfor %}
{%  for forward_func in custom['forward']: -%}
void {{ forward_func }}(ai_layer* layer);
{% endfor %}

{% for _, intq in hybrid_lite[layers.INTQS].items(): -%}
{{ layers.declare_intq(intq, loop.index0) }}
{% endfor %}

{% for _, array in hybrid_lite[layers.ARRAYS].items(): -%}
{{ layers.declare_array(array, loop.index0) }}
{% endfor %}

{% for _, tensor in hybrid_lite[layers.TENSORS].items(): -%}
{{ layers.declare_tensor(tensor, loop.index0) }}
{% endfor %}

{%- for layer in hybrid_lite[layers.LAYERS] %}
{{ layers.declare_layer(layer['layer'], 'NULL') }}
{% endfor -%}

{{ lite.hybrid_lite_render_functions(hybrid_lite[layers.LAYERS], "lite_graph* graph", False, NET_NAME) }}
