/****************************************************************************
*
* Copyright (c) 2025 STMicroelectronics - All Rights Reserved
*
* License terms: STMicroelectronics Proprietary in accordance with licensing
* terms SLA0098 at www.st.com.
*
* THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*
*****************************************************************************/
/**
 * @file    main.c
 * @brief   AI test the Multicore.
 *
 * @{
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <typedefs.h>

#include <io.h>
#include <irq.h>
#include <me.h>
#include <osal.h>
#include <siul2.h>
#include <uart.h>
#include <gst.h>
#include <rgm.h>

#include <clock.h>
#include <agt.h>
#include <linflexd.h>

#include <board_cfg.h>
#include "stellar_ai_cfg.h"

/* Cluster Core validation configuration */
#include "cluster_core_validation.h"

AGTDriver AgtHandle;
UARTDriver UartHandle;

RGMDriver rgm_inst_0;
RGMDriver rgm_inst_3;
MEDriver me_inst_0;
MEDriver me_inst_3;

#if (STELLAR_AI_VALIDATE == TRUE)
#include "stellar_ai.h"
#endif /* #if (STELLAR_AI_VALIDATE == TRUE) */

void error_handler(){
	while(1){
		;
	}
}

static void SystemInit(void)
{
  irq_init();
  osal_init();
  agt_init(&AgtHandle, AGT_VIRT);
  siul2_init();

  /* Start OSAL for system time. */
  osal_start();

  if (!me_init(&me_inst_0, ME_CORE_DOMAIN_0_ID) ||
      !me_init(&me_inst_3, ME_PERIPHERAL_DOMAIN_ID)){
            error_handler();
    }

  rgm_init(&rgm_inst_0, RGM_CORE_DOMAIN_0_ID, RGM_TYPE_CORE);
  rgm_init(&rgm_inst_3, RGM_PERIPHERAL_DOMAIN_ID, RGM_TYPE_PERIPHERAL);

#if (AI_VALIDATION_CLUSTER0_CORE1 == 1)
  io_init(&UartHandle, UART_5_DEVICE_ID);
  linflexd_init();
  io_start(&UartHandle);
#endif
}

#if (STELLAR_AI_VALIDATE == TRUE)
/*
 * Application entry point for cluster0 core0
 */
int main(void) {

  SystemInit();

  printf("Cluster0 Core1 Cortex-R52 with NEON AI validation project\n\r");

#if (AI_VALIDATION_CLUSTER0_CORE1 == 1)
  aiValidateStart();
#else
  while (true) {
    siul2_iotoggle(USER_LED2);
    osal_delay_milliseconds(500);
  }
#endif

  /* never here...*/
}
#else
/*
 * Application entry point for cluster0 core0
 */
int main(void) {

  SystemInit();

  printf("Cluster0 Core1 Cortex-R52 with NEON AI template application\n\r");

  while (true) {
  }

  return 0;
}
#endif /* #if (STELLAR_AI_VALIDATE == TRUE) */

/** @} */
