/****************************************************************************
*
* Copyright (c) 2025 STMicroelectronics - All Rights Reserved
*
* License terms: STMicroelectronics Proprietary in accordance with licensing
* terms SLA0098 at www.st.com.
*
* THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*
*****************************************************************************/
/**
 * @file    main.c
 * @brief   AI test the Multicore.
 *
 * The test runs the Stellar P7 cores simultaneously with AI networks.
 *
 * @{
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <typedefs.h>

#include <io.h>
#include <irq.h>
#include <me.h>
#include <osal.h>
#include <siul2.h>
#include <uart.h>
#include <gst.h>
#include <rgm.h>

#include <clock.h>
#include <agt.h>
#include <linflexd.h>

#include <board_cfg.h>

/* DME/DSPH loading code/data */
#include <ld_sym.h>

/* R52 entry points */
#include <cluster0_core1_sym.h>

/* Cluster Core validation configuration */
#include "cluster_core_validation.h"

RGMDriver rgm_inst_0;
RGMDriver rgm_inst_3;
MEDriver me_inst_0;
MEDriver me_inst_3;

AGTDriver AgtHandle;
GSTDriver tbu_inst;
UARTDriver UartHandle;

#include "stellar_ai_cfg.h"

#if (STELLAR_AI_VALIDATE == TRUE)
#include "stellar_ai.h"
#endif /* #if (STELLAR_AI_VALIDATE == TRUE) */

static void start_other_cores(void)
{
    /* Start cluster0 core1 */
    me_runcore(&me_inst_0, ME_CORE_1_ID, __cluster0_core1_entry_point__);
}

void error_handler(){
	while(1){
		;
	}
}

/*
 * Example of system initialization function
 */
static void SystemInit(void)
{
  clockInit();
  irq_init();

  gst_init(&tbu_inst, 0, GST_TYPE_TBU);
  gst_start(&tbu_inst);
  agt_init(&AgtHandle, AGT_VIRT);
  osal_init();
  siul2_init();

  /* Start the SIUL2 for I/O configuration */
  siul2_start();

  /* Now we can initialiaze the I/O */
  BOARD_INIT_FUNC(BOARD_NAME);

  /* Starts GST and AGT */
  osal_start();

  if (!me_init(&me_inst_0, ME_CORE_DOMAIN_0_ID) ||
      !me_init(&me_inst_3, ME_PERIPHERAL_DOMAIN_ID)){
            error_handler();
    }

  rgm_init(&rgm_inst_0, RGM_CORE_DOMAIN_0_ID, RGM_TYPE_CORE);
  rgm_init(&rgm_inst_3, RGM_PERIPHERAL_DOMAIN_ID, RGM_TYPE_PERIPHERAL);

#if (AI_VALIDATION_CLUSTER0_CORE0 == 1)
  io_init(&UartHandle, UART_5_DEVICE_ID);
  linflexd_init();
  io_start(&UartHandle);
#endif
}

#if (STELLAR_AI_VALIDATE == TRUE)
/*
 * Application entry point for cluster0 core0
 */
int main(void) {

  SystemInit();

  /* Start the other cores */
  start_other_cores();

  printf("Cluster0 Core0 Cortex-R52 AI validation project\n\r");

#if (AI_VALIDATION_CLUSTER0_CORE0 == 1)
  aiValidateStart();
#else
  while (true) {
    siul2_iotoggle(USER_LED1);
    osal_delay_milliseconds(500);
  }
#endif

  /* never here...*/
}
#else
/*
 * Application entry point for cluster0 core0
 */
int main(void) {

  SystemInit();

  /* Start the other cores */
  start_other_cores();

  printf("Cluster0 Core0 Cortex-R52 AI template application\n\r");

  while (true) {
  }

  return 0;
}
#endif /* #if (STELLAR_AI_VALIDATE == TRUE) */

/** @} */
