/****************************************************************************
 *
 * Copyright (c) 2023-2025 STMicroelectronics - All Rights Reserved
 *
 * License terms: STMicroelectronics Proprietary in accordance with licensing
 * terms SLA0098 at www.st.com.
 *
 * THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
 * INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * DO NOT EDIT: Header Automatically generated
 *****************************************************************************/

#ifndef _CLOCK_CFG_H_
#define _CLOCK_CFG_H_

#define OSC40M_DIG_0 OSC40M_DIG_PERIPHERAL_DOMAIN

/*
 * Clock parameter settings.
 */

/* DO NOT EDIT: Header Automatically generated */

#undef EXCLUDE_XOSC
#define SSDK_XOSC_CLK 40000000U
#define SSDK_IRCOSC20_CLK 20000000U
#define SSDK_OSC_BYPASS           FALSE
#define SSDK_NO_INIT              FALSE
#define SSDK_ALLOW_OVERCLOCK      FALSE
#define SSDK_ENABLE_CLOCKOUT      FALSE
#define SSDK_CLOCK_FAILURE_HOOK() irq_sys_halt()

#define SSDK_IRCOSC_FREQ_HZ   20000000
#define SSDK_IRCOSC40_FREQ_HZ 40000000
#define SSDK_EXT_XOSC_CLK     0
#define SSDK_PLL1_FREQ_MOD    250000U
#define SSDK_DRCLK_IO_CLK   8000000U

// remove unified ME_ME handling!!
#define SSDK_ME_ME_BITS                                                        \
    (0UL | SSDK_ME_ME_RESET | SSDK_ME_ME_SAFE | SSDK_ME_ME_DRUN |              \
     SSDK_ME_ME_RUN0 | SSDK_ME_ME_RUN1 | SSDK_ME_ME_RUN2 | SSDK_ME_ME_RUN3)

#define SSDK_FINAL_RUNMODE_D0             RUNMODE_RUN0
#define SSDK_FINAL_RUNMODE_D1             RUNMODE_RUN0
#define SSDK_FINAL_RUNMODE_D2             RUNMODE_RUN0
#define SSDK_FINAL_RUNMODE_PER            RUNMODE_RUN0
#define SSDK_ME_PER_FINAL_RUNMODE_MC_BITS ME_PER_RUN0_MC_BITS

#define SSDK_SYS_CLK_0   400000000U
#define SSDK_SYS_CLK_1   400000000U
#define SSDK_SYS_CLK_2   400000000U
#define SSDK_SYS_CLK_PER 40000000U


/* CLOCK CALIBRATION CONTROL UNIT */
#define CCCU_0_START_PTCL (ME_PCTL_RUN(2) | ME_PCTL_LP(2))
#define CCCU_0_STOP_PTCL  (ME_PCTL_RUN(0) | ME_PCTL_LP(0))

#define CCCU_0_PTCL 249
#define CCCU_0_ENABLE_CLOCK()                                                  \
    setPeripheralClockMode(CCCU_0_PTCL, CCCU_0_START_PTCL);
#define CCCU_0_DISABLE_CLOCK()                                                 \
    setPeripheralClockMode(CCCU_0_PTCL, CCCU_0_STOP_PTCL);

#define SSDK_ME_PER_RUN0_SYSCLK  SSDK_ME_MC_SYSCLK_XOSC

/* CGM0 Settings */
#define SSDK_ME0_RUN0_SYSCLK  SSDK_ME_MC_SYSCLK_PLL0PHI

#define SSDK_CGM0_AC0_SC_BITS SSDK_CGM_SC_PLL0PHI1
#define SSDK_PLL1_D0_MFD_VALUE 20U
#define SSDK_PLL1_D0_RFDPHI_LC_VALUE 2U
#define SSDK_PLL1_D0_RFDPHI_HP_VALUE 2U
#define SSDK_DIV_SYS_CLK_0 (SSDK_SYS_CLK_0 / SSDK_CGM0_SC_DC0_DIV_VALUE)
#define SSDK_CGM0_SC_DC0_DIV_VALUE 8U
#define SSDK_CGM0_SC_DC1_DIV_VALUE 2U
#define SSDK_CGM0_SC_DC2_DIV_VALUE 8U
#define SSDK_CGM0_SC_DC3_DIV_VALUE 8U
#define SSDK_CGM0_SC_DC4_DIV_VALUE 4U
#define SSDK_CGM0_SC_DC5_DIV_VALUE 2U

/* CGM1 Settings */
#define SSDK_ME1_RUN0_SYSCLK  SSDK_ME_MC_SYSCLK_PLL0PHI

#define SSDK_CGM1_AC0_SC_BITS SSDK_CGM_SC_PLL0PHI1
#define SSDK_PLL1_D1_MFD_VALUE 20U
#define SSDK_PLL1_D1_RFDPHI_LC_VALUE 2U
#define SSDK_PLL1_D1_RFDPHI_HP_VALUE 2U
#define SSDK_CGM1_SC_DC0_DIV_VALUE 8U
#define SSDK_CGM1_SC_DC1_DIV_VALUE 2U

/* CGM2 Settings */
#define SSDK_ME2_RUN0_SYSCLK  SSDK_ME_MC_SYSCLK_PLL0PHI

#define SSDK_CGM2_AC0_SC_BITS SSDK_CGM_SC_PLL0PHI1
#define SSDK_PLL1_D2_MFD_VALUE 20U
#define SSDK_PLL1_D2_RFDPHI_LC_VALUE 2U
#define SSDK_PLL1_D2_RFDPHI_HP_VALUE 2U
#define SSDK_CGM2_SC_DC0_DIV_VALUE 8U
#define SSDK_CGM2_SC_DC1_DIV_VALUE 2U

/* CGM PER AC1 Settings */
#define SSDK_CGM_PER_AC1_SC_BITS SSDK_CGM_SC_XOSC
#define SSDK_PLL0_MFD_VALUE 20U
#define SSDK_PLL0_RFDPHI_VALUE 1U
#define SSDK_PLL0_RFDPHI1_VALUE 10U
#define SSDK_PLL0_RFDPHI_JM_VALUE 1U
#define SSDK_PLL0_PREDIV_VALUE 2U
#define SSDK_CGM_PER_SC_DC0_DIV_VALUE 2U

/* CGM PER AC2 Settings */
#define SSDK_CGM_PER_AC2_DC0_DIV_VALUE 5U

/* CGM PER AC3 Settings */
#define SSDK_CGM_PER_AC3_SC_BITS SSDK_CGM_SC_PLL0PHI
#define SSDK_CGM_PER_AC3_DC0_DIV_VALUE 2U
#define SSDK_CGM_PER_AC3_DC1_DIV_VALUE 25U
#define SSDK_CGM_PER_AC3_DC2_DIV_VALUE 20U

/* CGM PER AC4 Settings */
#define SSDK_CGM_PER_AC4_SC_BITS SSDK_CGM_SC_PLL0PHI
#define SSDK_CGM_PER_AC4_DC0_DIV_VALUE 14U

/* CGM PER AC5 Settings */
#define SSDK_CGM_PER_AC5_DC0_DIV_VALUE 6613U
#define SSDK_CGM_PER_AC5_DC0_DIV_FMT_VALUE 2U
#define SSDK_CGM_PER_AC5_DC1_DIV_VALUE 100U
#define SSDK_CGM_PER_AC5_DC2_DIV_VALUE 400U

/* CGM PER AC6 Settings */
#define SSDK_CGM_PER_AC6_SC_BITS SSDK_CGM_SC_IRC
#define SSDK_CGM_PER_AC6_DC0_DIV_VALUE 1U

/* CGM PER AC7 Settings */
#define SSDK_CGM_PER_AC7_SC_BITS SSDK_CGM_SC_XOSC
#define SSDK_CGM_PER_AC7_DC0_DIV_VALUE 1U

/* CGM PER AC8 Settings */
#define SSDK_CGM_PER_AC8_SC_BITS SSDK_CGM_SC_XOSC
#define SSDK_CGM_PER_AC8_DC0_DIV_VALUE 1U
#define SSDK_CGM_PER_AC8_DC1_DIV_VALUE 1U

/* CGM PER AC9 Settings */
#define SSDK_CGM_PER_AC9_SC_BITS SSDK_CGM_SC_PLL0PHI_DIV2_5
#define SSDK_CGM_PER_AC9_DC0_DIV_VALUE 4U
#define SSDK_CGM_PER_AC9_DC1_DIV_VALUE 1U

/* CGM PER AC10 Settings */
#define SSDK_CGM_PER_AC10_SC_BITS SSDK_CGM_SC_PLL0PHI
#define SSDK_CGM_PER_AC10_DC0_DIV_VALUE 4U

/* CGM PER AC11 Settings */
#define SSDK_CGM_PER_AC11_SC_BITS SSDK_CGM_SC_PLL0PHI
#define SSDK_CGM_PER_AC11_DC0_DIV_VALUE 8U

/* CGM PER AC12 Settings */
#define SSDK_CGM_PER_AC12_SC_BITS SSDK_CGM_SC_PLL0PHI
#define SSDK_CGM_PER_AC12_DC0_DIV_VALUE 4U
#define SSDK_CGM_PER_AC12_DC1_DIV_VALUE 2U
#define SSDK_CGM_PER_AC12_DC2_DIV_VALUE 8U
#define SSDK_CGM_PER_AC12_DC3_DIV_VALUE 4U
#define SSDK_CGM_PER_AC12_DC5_DIV_VALUE 8U

/* CGM PER AC13 Settings */
#define SSDK_CGM_PER_AC13_SC_BITS SSDK_CGM_SC_XOSC
#define SSDK_CGM_PER_AC13_DC0_DIV_VALUE 1U


#endif /* _CLOCK_CFG_H_ */
