/****************************************************************************
*
* Copyright (c) 2022 STMicroelectronics - All Rights Reserved
*
* License terms: STMicroelectronics Proprietary in accordance with licensing
* terms SLA0098 at www.st.com.
*
* THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*
*****************************************************************************/

#include <typedefs.h>

#include <irq.h>
#include <osal.h>
#include <siul2.h>

#include <board_cfg.h>

int main(void)
{
    irq_init();
    osal_init();
    siul2_init();

    /*
     * If siul2_start() has not already been called by R52 add it here.
     * siul2_start();
     */

    /* Start OSAL for sywtem time. */
    osal_start();

	/* Application main loop */
	for ( ; ; ) {
    	siul2_iotoggle(USER_LED8);
    	osal_delay_milliseconds(400);
    }
}
