################################################################################
# Project makefile for AI validation.
################################################################################

# AI auto-genereted folder
DIR_NAME := SR6G7_AI_Demo_EVBC4000P_A

################################################################################
# Add project files
################################################################################

# C sources
ifeq (,$(filter $(CONFIG_TARGET_CORE),dme dsph))
C_SRCS += \
	$(DIR_NAME)/lib/stellar/src/stellar_ai.c \
	$(DIR_NAME)/lib/validation/src/aiPbIO.c \
	$(DIR_NAME)/lib/validation/src/aiPbMemRWServices.c \
	$(DIR_NAME)/lib/validation/src/aiPbMgr.c \
	$(DIR_NAME)/lib/validation/src/aiValidation_ST_AI.c \
	$(DIR_NAME)/lib/validation/src/pb_common.c \
	$(DIR_NAME)/lib/validation/src/pb_decode.c \
	$(DIR_NAME)/lib/validation/src/pb_encode.c \
	$(DIR_NAME)/lib/validation/src/stellar_ai_validate.c \
	$(DIR_NAME)/lib/validation/src/stm32msg.pb.c \
	$(DIR_NAME)/lib/misc/src/ai_device_adaptor.c \
	$(DIR_NAME)/lib/misc/src/aiTestHelper_ST_AI.c \
	$(DIR_NAME)/lib/misc/src/aiTestUtility.c \
	$(DIR_NAME)/lib/misc/src/syscalls.c
endif

C_SRCS += \
	$(DIR_NAME)/cfg/src/network_data.c \
	$(DIR_NAME)/cfg/src/network.c

ifeq (,$(filter $(CONFIG_TARGET_CORE),dme dsph))
C_SRCS += \
	$(DIR_NAME)/cfg/app_stellar-studio-ai.c
endif

# C includes
C_INCS += \
	$(DIR_NAME)/lib/ai/inc \
	ifeq (,$(filter $(CONFIG_TARGET_CORE),dme dsph)) \
	$(DIR_NAME)/lib/stellar/inc \
	endif \
	$(DIR_NAME)/cfg/inc \
	$(DIR_NAME)/cfg

ifeq (,$(filter $(CONFIG_TARGET_CORE),dme dsph))
C_INCS += \
	$(DIR_NAME)/lib/validation/inc \
	$(DIR_NAME)/lib/misc/inc
endif

# Library includes
ifneq (,$(filter $(CONFIG_TARGET_CORE),dme dsph))
# dme dsph cores on sr6 devices
	ifeq ($(TOOLCHAIN), ARM)
	LIBS += \
		$(DIR_NAME)/lib/ai/Lib/GCC/StellarPG_M4/NetworkRuntime1100_CM4_GCC.a \
		-lm
	else ifeq ($(TOOLCHAIN), HIGHTEC)
	LIBS += \
		$(DIR_NAME)/lib/ai/Lib/HT/StellarPG_M4/NetworkRuntime1100_CM4_HT.a
	else ifeq ($(TOOLCHAIN), ARMCLANG)
	LIBS += \
		$(DIR_NAME)/lib/ai/Lib/ARMCLANG/StellarPG_M4/NetworkRuntime1100_CM4_ARMCLANG.a
	endif
else ifneq (,$(filter $(CONFIG_DEVICE),sr6p7g7 sr6p7lp sr6p7 sr6g7))
# sr6p7g7 sr6p7lp sr6p7 sr6g7 cores
	ifneq (,$(filter $(CONFIG_TARGET_CLUSTER),cluster0 cluster1))
		ifneq (,$(filter $(CONFIG_TARGET_CORE),core1))
			ifeq ($(TOOLCHAIN), ARM)
			LIBS += \
				$(DIR_NAME)/lib/ai/Lib/GCC/StellarPG_R52/NetworkRuntime1100_CR52_GCC_NEON.a \
				-lm
			else ifeq ($(TOOLCHAIN), HIGHTEC)
			LIBS += \
				$(DIR_NAME)/lib/ai/Lib/HT/StellarPG_R52/NetworkRuntime1100_CR52_HT_NEON.a
			else ifeq ($(TOOLCHAIN), ARMCLANG)
			LIBS += \
				$(DIR_NAME)/lib/ai/Lib/ARMCLANG/StellarPG_R52/NetworkRuntime1100_CR52_ARMCLANG_NEON.a
			endif
		else
			ifeq ($(TOOLCHAIN), ARM)
			LIBS += \
				$(DIR_NAME)/lib/ai/Lib/GCC/StellarPG_R52/NetworkRuntime1100_CR52_GCC.a \
				-lm
			else ifeq ($(TOOLCHAIN), HIGHTEC)
			LIBS += \
				$(DIR_NAME)/lib/ai/Lib/HT/StellarPG_R52/NetworkRuntime1100_CR52_HT.a
			else ifeq ($(TOOLCHAIN), ARMCLANG)
			LIBS += \
				$(DIR_NAME)/lib/ai/Lib/ARMCLANG/StellarPG_R52/NetworkRuntime1100_CR52_ARMCLANG.a
			endif
		endif
	else
		ifeq ($(TOOLCHAIN), ARM)
		LIBS += \
			$(DIR_NAME)/lib/ai/Lib/GCC/StellarPG_R52/NetworkRuntime1100_CR52_GCC.a \
			-lm
		else ifeq ($(TOOLCHAIN), HIGHTEC)
		LIBS += \
			$(DIR_NAME)/lib/ai/Lib/HT/StellarPG_R52/NetworkRuntime1100_CR52_HT.a
		else ifeq ($(TOOLCHAIN), ARMCLANG)
		LIBS += \
			$(DIR_NAME)/lib/ai/Lib/ARMCLANG/StellarPG_R52/NetworkRuntime1100_CR52_ARMCLANG.a
		endif
	endif
else ifneq (,$(filter $(CONFIG_DEVICE),sr6g6))
# sr6g6 core
	ifneq (,$(filter $(CONFIG_TARGET_CLUSTER),cluster0))
		ifneq (,$(filter $(CONFIG_TARGET_CORE),core1))
			ifeq ($(TOOLCHAIN), ARM)
			LIBS += \
				$(DIR_NAME)/lib/ai/Lib/GCC/StellarPG_R52/NetworkRuntime1100_CR52_GCC_NEON.a \
				-lm
			else ifeq ($(TOOLCHAIN), HIGHTEC)
			LIBS += \
				$(DIR_NAME)/lib/ai/Lib/HT/StellarPG_R52/NetworkRuntime1100_CR52_HT_NEON.a
			else ifeq ($(TOOLCHAIN), ARMCLANG)
			LIBS += \
				$(DIR_NAME)/lib/ai/Lib/ARMCLANG/StellarPG_R52/NetworkRuntime1100_CR52_ARMCLANG_NEON.a
			endif
		else
			ifeq ($(TOOLCHAIN), ARM)
			LIBS += \
				$(DIR_NAME)/lib/ai/Lib/GCC/StellarPG_R52/NetworkRuntime1100_CR52_GCC.a \
				-lm
			else ifeq ($(TOOLCHAIN), HIGHTEC)
			LIBS += \
				$(DIR_NAME)/lib/ai/Lib/HT/StellarPG_R52/NetworkRuntime1100_CR52_HT.a
			else ifeq ($(TOOLCHAIN), ARMCLANG)
			LIBS += \
				$(DIR_NAME)/lib/ai/Lib/ARMCLANG/StellarPG_R52/NetworkRuntime1100_CR52_ARMCLANG.a
			endif
		endif
	else
		ifeq ($(TOOLCHAIN), ARM)
		LIBS += \
			$(DIR_NAME)/lib/ai/Lib/GCC/StellarPG_R52/NetworkRuntime1100_CR52_GCC.a \
			-lm
		else ifeq ($(TOOLCHAIN), HIGHTEC)
		LIBS += \
			$(DIR_NAME)/lib/ai/Lib/HT/StellarPG_R52/NetworkRuntime1100_CR52_HT.a
		else ifeq ($(TOOLCHAIN), ARMCLANG)
		LIBS += \
			$(DIR_NAME)/lib/ai/Lib/ARMCLANG/StellarPG_R52/NetworkRuntime1100_CR52_ARMCLANG.a
		endif
	endif
else ifneq (,$(filter $(CONFIG_DEVICE),sr6g3))
# sr6g3 core
	ifneq (,$(filter $(CONFIG_TARGET_CLUSTER),cluster0))
		ifneq (,$(filter $(CONFIG_TARGET_CORE),core0 core2))
			ifeq ($(TOOLCHAIN), ARM)
			LIBS += \
				$(DIR_NAME)/lib/ai/Lib/GCC/StellarPG_R52/NetworkRuntime1100_CR52_GCC_NEON.a \
				-lm
			else ifeq ($(TOOLCHAIN), HIGHTEC)
			LIBS += \
				$(DIR_NAME)/lib/ai/Lib/HT/StellarPG_R52/NetworkRuntime1100_CR52_HT_NEON.a
			else ifeq ($(TOOLCHAIN), ARMCLANG)
			LIBS += \
				$(DIR_NAME)/lib/ai/Lib/ARMCLANG/StellarPG_R52/NetworkRuntime1100_CR52_ARMCLANG_NEON.a
			endif
		else
			ifeq ($(TOOLCHAIN), ARM)
			LIBS += \
				$(DIR_NAME)/lib/ai/Lib/GCC/StellarPG_R52/NetworkRuntime1100_CR52_GCC.a \
				-lm
			else ifeq ($(TOOLCHAIN), HIGHTEC)
			LIBS += \
				$(DIR_NAME)/lib/ai/Lib/HT/StellarPG_R52/NetworkRuntime1100_CR52_HT.a
			else ifeq ($(TOOLCHAIN), ARMCLANG)
			LIBS += \
				$(DIR_NAME)/lib/ai/Lib/ARMCLANG/StellarPG_R52/NetworkRuntime1100_CR52_ARMCLANG.a
			endif
		endif
	endif
else
# sr6p6 sr6p3
	ifeq ($(TOOLCHAIN), ARM)
	LIBS += \
		$(DIR_NAME)/lib/ai/Lib/GCC/StellarPG_R52/NetworkRuntime1100_CR52_GCC.a \
		-lm
	else ifeq ($(TOOLCHAIN), HIGHTEC)
	LIBS += \
		$(DIR_NAME)/lib/ai/Lib/HT/StellarPG_R52/NetworkRuntime1100_CR52_HT.a
	else ifeq ($(TOOLCHAIN), ARMCLANG)
	LIBS += \
		$(DIR_NAME)/lib/ai/Lib/ARMCLANG/StellarPG_R52/NetworkRuntime1100_CR52_ARMCLANG.a
	endif
endif

# C defines
ifeq (,$(filter $(CONFIG_TARGET_CORE),dme dsph))
C_DEFS += \
	SR6X
endif

# C defines
C_DEFS += \
	HAVE_NETWORK_INFO
