/****************************************************************************
*
* Copyright (c) 2025 STMicroelectronics - All Rights Reserved
*
* License terms: STMicroelectronics Proprietary in accordance with licensing
* terms SLA0098 at www.st.com.
*
* THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*
*
*****************************************************************************/
/**
 * @file    main.c
 * @brief   Stellar Studio AI main test application
 *
 * @{
 * @details
 * Stellar Studio AI main application for validation and run inference.
 * @verbatim

Configuration:
- UART setup: 115200, N, 8, 1

Prerequisites:
- Mini USB UART output (available on the board) cable connected to a Test Station
- Test Station running a serial terminal, same configuration as DUT configuration

 @endverbatim
 */

#include <typedefs.h>

#include <clock.h>
#include <irq.h>

#include <rgm.h>
#include <agt.h>
#include <gst.h>
#include <siul2.h>
#include <osal.h>
#include <linflexd.h>
#include <uart.h>
#include <io.h>
#include <stdio.h>
#include <string.h>

#include <board_cfg.h>
#include "stellar_ai_cfg.h"

UARTDriver UartHandle;
AGTDriver AgtHandle;
GSTDriver gst_instance_tbu;
RGMDriver rgm_inst_0;
RGMDriver rgm_inst_3;
MEDriver me_inst_0;
MEDriver me_inst_3;

#if (STELLAR_AI_VALIDATE == TRUE)
#include "stellar_ai.h"
#endif /* #if (STELLAR_AI_VALIDATE == TRUE) */

/*===========================================================================*/
/* Driver defines.                                                           */
/*===========================================================================*/

/*===========================================================================*/
/* Driver local variables and types.                                         */
/*===========================================================================*/

/*===========================================================================*/
/* Driver exported variables.                                                */
/*===========================================================================*/

/*===========================================================================*/
/* Driver local functions.                                                   */
/*===========================================================================*/

int main(void);

/*
 * Example of system initialization function
 */
static void SystemInit(void)
{
  clockInit();
  siul2_init();
  siul2_start();
  BOARD_INIT_FUNC(BOARD_NAME);
  irq_init();

  gst_init(&gst_instance_tbu, 0, GST_TYPE_TBU);
  gst_start(&gst_instance_tbu);
  agt_init(&AgtHandle, AGT_VIRT);
  me_init(&me_inst_0, ME_CORE_DOMAIN_0_ID);
  me_init(&me_inst_3, ME_PERIPHERAL_DOMAIN_ID);
  rgm_init(&rgm_inst_0, RGM_CORE_DOMAIN_0_ID, RGM_TYPE_CORE);
  rgm_init(&rgm_inst_3, RGM_PERIPHERAL_DOMAIN_ID, RGM_TYPE_PERIPHERAL);

  osal_init();
  osal_start();

  io_init(&UartHandle, UART_5_DEVICE_ID);
  linflexd_init();
  io_start(&UartHandle);
}

#if (STELLAR_AI_VALIDATE == TRUE)
/*
 * Application entry point for validation process
 */
int main(void) {

  SystemInit();

  aiValidateStart();

  /* never here...*/
  while (true) {
  }
}
#else
/*
 * Application entry point for inference run
 */
int main(void) {

  SystemInit();

  printf("#### Minimal application to run inference.\r\n");

  /* give a look at the main_loop() function inside the ws\build_network\stedgeai_app_main.c generated file on how to initialize and run the inference. */
  /* main_loop(); */
  
  /* never here...*/
  while (true) {
  }
}
#endif /* #if (STELLAR_AI_VALIDATE == TRUE) */

/** @} */
