/****************************************************************************
*
* Copyright (c) 2025 STMicroelectronics - All Rights Reserved
*
* License terms: STMicroelectronics Proprietary in accordance with licensing
* terms SLA0098 at www.st.com.
*
* THIS SOFTWARE IS DISTRIBUTED "AS IS," AND ALL WARRANTIES ARE DISCLAIMED,
* INCLUDING MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*
*****************************************************************************/
/**
 * @file    main.c
 * @brief   AI test the Multicore.
 *
 * @{
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <typedefs.h>

#include <io.h>
#include <irq.h>
#include <me.h>
#include <osal.h>
#include <siul2.h>
#include <uart.h>
#include <gst.h>

#include <clock.h>
#include <agt.h>
#include <linflexd.h>

#include <modules_cfg.h>

#include <board_cfg.h>

/* DME/DSPH loading code/data */
#include <ld_sym.h>

/* R52 entry points */
#include <cluster0_core1_sym.h>

#include "stellar_ai_cfg.h"

#if (STELLAR_AI_VALIDATE == TRUE)
#include "stellar_ai.h"
#endif /* #if (STELLAR_AI_VALIDATE == TRUE) */

static void start_other_cores(void)
{
    /* Start cluster0 core1 */
    me_runcore(&MED0, ME_CORE_1_ID, __cluster0_core1_entry_point__);
}

/*
 * Example of system initialization function
 */
static void SystemInit(void)
{
    clockInit();
    siul2_init();
    siul2_start();

    BOARD_INIT_FUNC(BOARD_NAME);

    irq_init();
    gst_init(&GST_TBUD0);
    agt_init();

    /* GST driver: starting TBU_0 for AGT clock */
    gst_start(&GST_TBUD0);

    osal_init();
    osal_start();

#if (AI_VALIDATION_CLUSTER0_CORE0 == 1)
    linflexd_init();

    /* Initialize the UART device */
    uart_init(&UARTD);

    /* Initialize Runtime IO module.*/
    io_init();

    /* Start Runtime IO module.*/
    io_start(&UARTD);
#endif
}

#if (STELLAR_AI_VALIDATE == TRUE)
/*
 * Application entry point for cluster0 core0
 */
int main(void) {

  SystemInit();

  /* Start the other cores */
  start_other_cores();

#if (AI_VALIDATION_CLUSTER0_CORE0 == 1)
  aiValidateStart();
#else
  while (true) {
    siul2_iotoggle(USER_LED1);
    osal_delay_milliseconds(500);
  }
#endif

  /* never here...*/
}
#else
/*
 * Application entry point for cluster0 core0
 */
int main(void) {

  SystemInit();

  /* Start the other cores */
  start_other_cores();

  printf("Hello World from Cluster0 Core0 Cortex-R52\n\r");

  while (true) {
  }

  return 0;
}
#endif /* #if (STELLAR_AI_VALIDATE == TRUE) */

/** @} */
